/*!
 * jQuery JavaScript Library v3.5.1
 * https://jquery.com/
 *
 * Includes Sizzle.js
 * https://sizzlejs.com/
 *
 * Copyright JS Foundation and other contributors
 * Released under the MIT license
 * https://jquery.org/license
 *
 * Date: 2020-05-04T22:49Z
 */
( function( global, factory ) {

	"use strict";

	if ( typeof module === "object" && typeof module.exports === "object" ) {

		// For CommonJS and CommonJS-like environments where a proper `window`
		// is present, execute the factory and get jQuery.
		// For environments that do not have a `window` with a `document`
		// (such as Node.js), expose a factory as module.exports.
		// This accentuates the need for the creation of a real `window`.
		// e.g. var jQuery = require("jquery")(window);
		// See ticket #14549 for more info.
		module.exports = global.document ?
			factory( global, true ) :
			function( w ) {
				if ( !w.document ) {
					throw new Error( "jQuery requires a window with a document" );
				}
				return factory( w );
			};
	} else {
		factory( global );
	}

// Pass this if window is not defined yet
} )( typeof window !== "undefined" ? window : this, function( window, noGlobal ) {

// Edge <= 12 - 13+, Firefox <=18 - 45+, IE 10 - 11, Safari 5.1 - 9+, iOS 6 - 9.1
// throw exceptions when non-strict code (e.g., ASP.NET 4.5) accesses strict mode
// arguments.callee.caller (trac-13335). But as of jQuery 3.0 (2016), strict mode should be common
// enough that all such attempts are guarded in a try block.
"use strict";

var arr = [];

var getProto = Object.getPrototypeOf;

var slice = arr.slice;

var flat = arr.flat ? function( array ) {
	return arr.flat.call( array );
} : function( array ) {
	return arr.concat.apply( [], array );
};


var push = arr.push;

var indexOf = arr.indexOf;

var class2type = {};

var toString = class2type.toString;

var hasOwn = class2type.hasOwnProperty;

var fnToString = hasOwn.toString;

var ObjectFunctionString = fnToString.call( Object );

var support = {};

var isFunction = function isFunction( obj ) {

      // Support: Chrome <=57, Firefox <=52
      // In some browsers, typeof returns "function" for HTML <object> elements
      // (i.e., `typeof document.createElement( "object" ) === "function"`).
      // We don't want to classify *any* DOM node as a function.
      return typeof obj === "function" && typeof obj.nodeType !== "number";
  };


var isWindow = function isWindow( obj ) {
		return obj != null && obj === obj.window;
	};


var document = window.document;



	var preservedScriptAttributes = {
		type: true,
		src: true,
		nonce: true,
		noModule: true
	};

	function DOMEval( code, node, doc ) {
		doc = doc || document;

		var i, val,
			script = doc.createElement( "script" );

		script.text = code;
		if ( node ) {
			for ( i in preservedScriptAttributes ) {

				// Support: Firefox 64+, Edge 18+
				// Some browsers don't support the "nonce" property on scripts.
				// On the other hand, just using `getAttribute` is not enough as
				// the `nonce` attribute is reset to an empty string whenever it
				// becomes browsing-context connected.
				// See https://github.com/whatwg/html/issues/2369
				// See https://html.spec.whatwg.org/#nonce-attributes
				// The `node.getAttribute` check was added for the sake of
				// `jQuery.globalEval` so that it can fake a nonce-containing node
				// via an object.
				val = node[ i ] || node.getAttribute && node.getAttribute( i );
				if ( val ) {
					script.setAttribute( i, val );
				}
			}
		}
		doc.head.appendChild( script ).parentNode.removeChild( script );
	}


function toType( obj ) {
	if ( obj == null ) {
		return obj + "";
	}

	// Support: Android <=2.3 only (functionish RegExp)
	return typeof obj === "object" || typeof obj === "function" ?
		class2type[ toString.call( obj ) ] || "object" :
		typeof obj;
}
/* global Symbol */
// Defining this global in .eslintrc.json would create a danger of using the global
// unguarded in another place, it seems safer to define global only for this module



var
	version = "3.5.1",

	// Define a local copy of jQuery
	jQuery = function( selector, context ) {

		// The jQuery object is actually just the init constructor 'enhanced'
		// Need init if jQuery is called (just allow error to be thrown if not included)
		return new jQuery.fn.init( selector, context );
	};

jQuery.fn = jQuery.prototype = {

	// The current version of jQuery being used
	jquery: version,

	constructor: jQuery,

	// The default length of a jQuery object is 0
	length: 0,

	toArray: function() {
		return slice.call( this );
	},

	// Get the Nth element in the matched element set OR
	// Get the whole matched element set as a clean array
	get: function( num ) {

		// Return all the elements in a clean array
		if ( num == null ) {
			return slice.call( this );
		}

		// Return just the one element from the set
		return num < 0 ? this[ num + this.length ] : this[ num ];
	},

	// Take an array of elements and push it onto the stack
	// (returning the new matched element set)
	pushStack: function( elems ) {

		// Build a new jQuery matched element set
		var ret = jQuery.merge( this.constructor(), elems );

		// Add the old object onto the stack (as a reference)
		ret.prevObject = this;

		// Return the newly-formed element set
		return ret;
	},

	// Execute a callback for every element in the matched set.
	each: function( callback ) {
		return jQuery.each( this, callback );
	},

	map: function( callback ) {
		return this.pushStack( jQuery.map( this, function( elem, i ) {
			return callback.call( elem, i, elem );
		} ) );
	},

	slice: function() {
		return this.pushStack( slice.apply( this, arguments ) );
	},

	first: function() {
		return this.eq( 0 );
	},

	last: function() {
		return this.eq( -1 );
	},

	even: function() {
		return this.pushStack( jQuery.grep( this, function( _elem, i ) {
			return ( i + 1 ) % 2;
		} ) );
	},

	odd: function() {
		return this.pushStack( jQuery.grep( this, function( _elem, i ) {
			return i % 2;
		} ) );
	},

	eq: function( i ) {
		var len = this.length,
			j = +i + ( i < 0 ? len : 0 );
		return this.pushStack( j >= 0 && j < len ? [ this[ j ] ] : [] );
	},

	end: function() {
		return this.prevObject || this.constructor();
	},

	// For internal use only.
	// Behaves like an Array's method, not like a jQuery method.
	push: push,
	sort: arr.sort,
	splice: arr.splice
};

jQuery.extend = jQuery.fn.extend = function() {
	var options, name, src, copy, copyIsArray, clone,
		target = arguments[ 0 ] || {},
		i = 1,
		length = arguments.length,
		deep = false;

	// Handle a deep copy situation
	if ( typeof target === "boolean" ) {
		deep = target;

		// Skip the boolean and the target
		target = arguments[ i ] || {};
		i++;
	}

	// Handle case when target is a string or something (possible in deep copy)
	if ( typeof target !== "object" && !isFunction( target ) ) {
		target = {};
	}

	// Extend jQuery itself if only one argument is passed
	if ( i === length ) {
		target = this;
		i--;
	}

	for ( ; i < length; i++ ) {

		// Only deal with non-null/undefined values
		if ( ( options = arguments[ i ] ) != null ) {

			// Extend the base object
			for ( name in options ) {
				copy = options[ name ];

				// Prevent Object.prototype pollution
				// Prevent never-ending loop
				if ( name === "__proto__" || target === copy ) {
					continue;
				}

				// Recurse if we're merging plain objects or arrays
				if ( deep && copy && ( jQuery.isPlainObject( copy ) ||
					( copyIsArray = Array.isArray( copy ) ) ) ) {
					src = target[ name ];

					// Ensure proper type for the source value
					if ( copyIsArray && !Array.isArray( src ) ) {
						clone = [];
					} else if ( !copyIsArray && !jQuery.isPlainObject( src ) ) {
						clone = {};
					} else {
						clone = src;
					}
					copyIsArray = false;

					// Never move original objects, clone them
					target[ name ] = jQuery.extend( deep, clone, copy );

				// Don't bring in undefined values
				} else if ( copy !== undefined ) {
					target[ name ] = copy;
				}
			}
		}
	}

	// Return the modified object
	return target;
};

jQuery.extend( {

	// Unique for each copy of jQuery on the page
	expando: "jQuery" + ( version + Math.random() ).replace( /\D/g, "" ),

	// Assume jQuery is ready without the ready module
	isReady: true,

	error: function( msg ) {
		throw new Error( msg );
	},

	noop: function() {},

	isPlainObject: function( obj ) {
		var proto, Ctor;

		// Detect obvious negatives
		// Use toString instead of jQuery.type to catch host objects
		if ( !obj || toString.call( obj ) !== "[object Object]" ) {
			return false;
		}

		proto = getProto( obj );

		// Objects with no prototype (e.g., `Object.create( null )`) are plain
		if ( !proto ) {
			return true;
		}

		// Objects with prototype are plain iff they were constructed by a global Object function
		Ctor = hasOwn.call( proto, "constructor" ) && proto.constructor;
		return typeof Ctor === "function" && fnToString.call( Ctor ) === ObjectFunctionString;
	},

	isEmptyObject: function( obj ) {
		var name;

		for ( name in obj ) {
			return false;
		}
		return true;
	},

	// Evaluates a script in a provided context; falls back to the global one
	// if not specified.
	globalEval: function( code, options, doc ) {
		DOMEval( code, { nonce: options && options.nonce }, doc );
	},

	each: function( obj, callback ) {
		var length, i = 0;

		if ( isArrayLike( obj ) ) {
			length = obj.length;
			for ( ; i < length; i++ ) {
				if ( callback.call( obj[ i ], i, obj[ i ] ) === false ) {
					break;
				}
			}
		} else {
			for ( i in obj ) {
				if ( callback.call( obj[ i ], i, obj[ i ] ) === false ) {
					break;
				}
			}
		}

		return obj;
	},

	// results is for internal usage only
	makeArray: function( arr, results ) {
		var ret = results || [];

		if ( arr != null ) {
			if ( isArrayLike( Object( arr ) ) ) {
				jQuery.merge( ret,
					typeof arr === "string" ?
					[ arr ] : arr
				);
			} else {
				push.call( ret, arr );
			}
		}

		return ret;
	},

	inArray: function( elem, arr, i ) {
		return arr == null ? -1 : indexOf.call( arr, elem, i );
	},

	// Support: Android <=4.0 only, PhantomJS 1 only
	// push.apply(_, arraylike) throws on ancient WebKit
	merge: function( first, second ) {
		var len = +second.length,
			j = 0,
			i = first.length;

		for ( ; j < len; j++ ) {
			first[ i++ ] = second[ j ];
		}

		first.length = i;

		return first;
	},

	grep: function( elems, callback, invert ) {
		var callbackInverse,
			matches = [],
			i = 0,
			length = elems.length,
			callbackExpect = !invert;

		// Go through the array, only saving the items
		// that pass the validator function
		for ( ; i < length; i++ ) {
			callbackInverse = !callback( elems[ i ], i );
			if ( callbackInverse !== callbackExpect ) {
				matches.push( elems[ i ] );
			}
		}

		return matches;
	},

	// arg is for internal usage only
	map: function( elems, callback, arg ) {
		var length, value,
			i = 0,
			ret = [];

		// Go through the array, translating each of the items to their new values
		if ( isArrayLike( elems ) ) {
			length = elems.length;
			for ( ; i < length; i++ ) {
				value = callback( elems[ i ], i, arg );

				if ( value != null ) {
					ret.push( value );
				}
			}

		// Go through every key on the object,
		} else {
			for ( i in elems ) {
				value = callback( elems[ i ], i, arg );

				if ( value != null ) {
					ret.push( value );
				}
			}
		}

		// Flatten any nested arrays
		return flat( ret );
	},

	// A global GUID counter for objects
	guid: 1,

	// jQuery.support is not used in Core but other projects attach their
	// properties to it so it needs to exist.
	support: support
} );

if ( typeof Symbol === "function" ) {
	jQuery.fn[ Symbol.iterator ] = arr[ Symbol.iterator ];
}

// Populate the class2type map
jQuery.each( "Boolean Number String Function Array Date RegExp Object Error Symbol".split( " " ),
function( _i, name ) {
	class2type[ "[object " + name + "]" ] = name.toLowerCase();
} );

function isArrayLike( obj ) {

	// Support: real iOS 8.2 only (not reproducible in simulator)
	// `in` check used to prevent JIT error (gh-2145)
	// hasOwn isn't used here due to false negatives
	// regarding Nodelist length in IE
	var length = !!obj && "length" in obj && obj.length,
		type = toType( obj );

	if ( isFunction( obj ) || isWindow( obj ) ) {
		return false;
	}

	return type === "array" || length === 0 ||
		typeof length === "number" && length > 0 && ( length - 1 ) in obj;
}
var Sizzle =
/*!
 * Sizzle CSS Selector Engine v2.3.5
 * https://sizzlejs.com/
 *
 * Copyright JS Foundation and other contributors
 * Released under the MIT license
 * https://js.foundation/
 *
 * Date: 2020-03-14
 */
( function( window ) {
var i,
	support,
	Expr,
	getText,
	isXML,
	tokenize,
	compile,
	select,
	outermostContext,
	sortInput,
	hasDuplicate,

	// Local document vars
	setDocument,
	document,
	docElem,
	documentIsHTML,
	rbuggyQSA,
	rbuggyMatches,
	matches,
	contains,

	// Instance-specific data
	expando = "sizzle" + 1 * new Date(),
	preferredDoc = window.document,
	dirruns = 0,
	done = 0,
	classCache = createCache(),
	tokenCache = createCache(),
	compilerCache = createCache(),
	nonnativeSelectorCache = createCache(),
	sortOrder = function( a, b ) {
		if ( a === b ) {
			hasDuplicate = true;
		}
		return 0;
	},

	// Instance methods
	hasOwn = ( {} ).hasOwnProperty,
	arr = [],
	pop = arr.pop,
	pushNative = arr.push,
	push = arr.push,
	slice = arr.slice,

	// Use a stripped-down indexOf as it's faster than native
	// https://jsperf.com/thor-indexof-vs-for/5
	indexOf = function( list, elem ) {
		var i = 0,
			len = list.length;
		for ( ; i < len; i++ ) {
			if ( list[ i ] === elem ) {
				return i;
			}
		}
		return -1;
	},

	booleans = "checked|selected|async|autofocus|autoplay|controls|defer|disabled|hidden|" +
		"ismap|loop|multiple|open|readonly|required|scoped",

	// Regular expressions

	// http://www.w3.org/TR/css3-selectors/#whitespace
	whitespace = "[\\x20\\t\\r\\n\\f]",

	// https://www.w3.org/TR/css-syntax-3/#ident-token-diagram
	identifier = "(?:\\\\[\\da-fA-F]{1,6}" + whitespace +
		"?|\\\\[^\\r\\n\\f]|[\\w-]|[^\0-\\x7f])+",

	// Attribute selectors: http://www.w3.org/TR/selectors/#attribute-selectors
	attributes = "\\[" + whitespace + "*(" + identifier + ")(?:" + whitespace +

		// Operator (capture 2)
		"*([*^$|!~]?=)" + whitespace +

		// "Attribute values must be CSS identifiers [capture 5]
		// or strings [capture 3 or capture 4]"
		"*(?:'((?:\\\\.|[^\\\\'])*)'|\"((?:\\\\.|[^\\\\\"])*)\"|(" + identifier + "))|)" +
		whitespace + "*\\]",

	pseudos = ":(" + identifier + ")(?:\\((" +

		// To reduce the number of selectors needing tokenize in the preFilter, prefer arguments:
		// 1. quoted (capture 3; capture 4 or capture 5)
		"('((?:\\\\.|[^\\\\'])*)'|\"((?:\\\\.|[^\\\\\"])*)\")|" +

		// 2. simple (capture 6)
		"((?:\\\\.|[^\\\\()[\\]]|" + attributes + ")*)|" +

		// 3. anything else (capture 2)
		".*" +
		")\\)|)",

	// Leading and non-escaped trailing whitespace, capturing some non-whitespace characters preceding the latter
	rwhitespace = new RegExp( whitespace + "+", "g" ),
	rtrim = new RegExp( "^" + whitespace + "+|((?:^|[^\\\\])(?:\\\\.)*)" +
		whitespace + "+$", "g" ),

	rcomma = new RegExp( "^" + whitespace + "*," + whitespace + "*" ),
	rcombinators = new RegExp( "^" + whitespace + "*([>+~]|" + whitespace + ")" + whitespace +
		"*" ),
	rdescend = new RegExp( whitespace + "|>" ),

	rpseudo = new RegExp( pseudos ),
	ridentifier = new RegExp( "^" + identifier + "$" ),

	matchExpr = {
		"ID": new RegExp( "^#(" + identifier + ")" ),
		"CLASS": new RegExp( "^\\.(" + identifier + ")" ),
		"TAG": new RegExp( "^(" + identifier + "|[*])" ),
		"ATTR": new RegExp( "^" + attributes ),
		"PSEUDO": new RegExp( "^" + pseudos ),
		"CHILD": new RegExp( "^:(only|first|last|nth|nth-last)-(child|of-type)(?:\\(" +
			whitespace + "*(even|odd|(([+-]|)(\\d*)n|)" + whitespace + "*(?:([+-]|)" +
			whitespace + "*(\\d+)|))" + whitespace + "*\\)|)", "i" ),
		"bool": new RegExp( "^(?:" + booleans + ")$", "i" ),

		// For use in libraries implementing .is()
		// We use this for POS matching in `select`
		"needsContext": new RegExp( "^" + whitespace +
			"*[>+~]|:(even|odd|eq|gt|lt|nth|first|last)(?:\\(" + whitespace +
			"*((?:-\\d)?\\d*)" + whitespace + "*\\)|)(?=[^-]|$)", "i" )
	},

	rhtml = /HTML$/i,
	rinputs = /^(?:input|select|textarea|button)$/i,
	rheader = /^h\d$/i,

	rnative = /^[^{]+\{\s*\[native \w/,

	// Easily-parseable/retrievable ID or TAG or CLASS selectors
	rquickExpr = /^(?:#([\w-]+)|(\w+)|\.([\w-]+))$/,

	rsibling = /[+~]/,

	// CSS escapes
	// http://www.w3.org/TR/CSS21/syndata.html#escaped-characters
	runescape = new RegExp( "\\\\[\\da-fA-F]{1,6}" + whitespace + "?|\\\\([^\\r\\n\\f])", "g" ),
	funescape = function( escape, nonHex ) {
		var high = "0x" + escape.slice( 1 ) - 0x10000;

		return nonHex ?

			// Strip the backslash prefix from a non-hex escape sequence
			nonHex :

			// Replace a hexadecimal escape sequence with the encoded Unicode code point
			// Support: IE <=11+
			// For values outside the Basic Multilingual Plane (BMP), manually construct a
			// surrogate pair
			high < 0 ?
				String.fromCharCode( high + 0x10000 ) :
				String.fromCharCode( high >> 10 | 0xD800, high & 0x3FF | 0xDC00 );
	},

	// CSS string/identifier serialization
	// https://drafts.csswg.org/cssom/#common-serializing-idioms
	rcssescape = /([\0-\x1f\x7f]|^-?\d)|^-$|[^\0-\x1f\x7f-\uFFFF\w-]/g,
	fcssescape = function( ch, asCodePoint ) {
		if ( asCodePoint ) {

			// U+0000 NULL becomes U+FFFD REPLACEMENT CHARACTER
			if ( ch === "\0" ) {
				return "\uFFFD";
			}

			// Control characters and (dependent upon position) numbers get escaped as code points
			return ch.slice( 0, -1 ) + "\\" +
				ch.charCodeAt( ch.length - 1 ).toString( 16 ) + " ";
		}

		// Other potentially-special ASCII characters get backslash-escaped
		return "\\" + ch;
	},

	// Used for iframes
	// See setDocument()
	// Removing the function wrapper causes a "Permission Denied"
	// error in IE
	unloadHandler = function() {
		setDocument();
	},

	inDisabledFieldset = addCombinator(
		function( elem ) {
			return elem.disabled === true && elem.nodeName.toLowerCase() === "fieldset";
		},
		{ dir: "parentNode", next: "legend" }
	);

// Optimize for push.apply( _, NodeList )
try {
	push.apply(
		( arr = slice.call( preferredDoc.childNodes ) ),
		preferredDoc.childNodes
	);

	// Support: Android<4.0
	// Detect silently failing push.apply
	// eslint-disable-next-line no-unused-expressions
	arr[ preferredDoc.childNodes.length ].nodeType;
} catch ( e ) {
	push = { apply: arr.length ?

		// Leverage slice if possible
		function( target, els ) {
			pushNative.apply( target, slice.call( els ) );
		} :

		// Support: IE<9
		// Otherwise append directly
		function( target, els ) {
			var j = target.length,
				i = 0;

			// Can't trust NodeList.length
			while ( ( target[ j++ ] = els[ i++ ] ) ) {}
			target.length = j - 1;
		}
	};
}

function Sizzle( selector, context, results, seed ) {
	var m, i, elem, nid, match, groups, newSelector,
		newContext = context && context.ownerDocument,

		// nodeType defaults to 9, since context defaults to document
		nodeType = context ? context.nodeType : 9;

	results = results || [];

	// Return early from calls with invalid selector or context
	if ( typeof selector !== "string" || !selector ||
		nodeType !== 1 && nodeType !== 9 && nodeType !== 11 ) {

		return results;
	}

	// Try to shortcut find operations (as opposed to filters) in HTML documents
	if ( !seed ) {
		setDocument( context );
		context = context || document;

		if ( documentIsHTML ) {

			// If the selector is sufficiently simple, try using a "get*By*" DOM method
			// (excepting DocumentFragment context, where the methods don't exist)
			if ( nodeType !== 11 && ( match = rquickExpr.exec( selector ) ) ) {

				// ID selector
				if ( ( m = match[ 1 ] ) ) {

					// Document context
					if ( nodeType === 9 ) {
						if ( ( elem = context.getElementById( m ) ) ) {

							// Support: IE, Opera, Webkit
							// TODO: identify versions
							// getElementById can match elements by name instead of ID
							if ( elem.id === m ) {
								results.push( elem );
								return results;
							}
						} else {
							return results;
						}

					// Element context
					} else {

						// Support: IE, Opera, Webkit
						// TODO: identify versions
						// getElementById can match elements by name instead of ID
						if ( newContext && ( elem = newContext.getElementById( m ) ) &&
							contains( context, elem ) &&
							elem.id === m ) {

							results.push( elem );
							return results;
						}
					}

				// Type selector
				} else if ( match[ 2 ] ) {
					push.apply( results, context.getElementsByTagName( selector ) );
					return results;

				// Class selector
				} else if ( ( m = match[ 3 ] ) && support.getElementsByClassName &&
					context.getElementsByClassName ) {

					push.apply( results, context.getElementsByClassName( m ) );
					return results;
				}
			}

			// Take advantage of querySelectorAll
			if ( support.qsa &&
				!nonnativeSelectorCache[ selector + " " ] &&
				( !rbuggyQSA || !rbuggyQSA.test( selector ) ) &&

				// Support: IE 8 only
				// Exclude object elements
				( nodeType !== 1 || context.nodeName.toLowerCase() !== "object" ) ) {

				newSelector = selector;
				newContext = context;

				// qSA considers elements outside a scoping root when evaluating child or
				// descendant combinators, which is not what we want.
				// In such cases, we work around the behavior by prefixing every selector in the
				// list with an ID selector referencing the scope context.
				// The technique has to be used as well when a leading combinator is used
				// as such selectors are not recognized by querySelectorAll.
				// Thanks to Andrew Dupont for this technique.
				if ( nodeType === 1 &&
					( rdescend.test( selector ) || rcombinators.test( selector ) ) ) {

					// Expand context for sibling selectors
					newContext = rsibling.test( selector ) && testContext( context.parentNode ) ||
						context;

					// We can use :scope instead of the ID hack if the browser
					// supports it & if we're not changing the context.
					if ( newContext !== context || !support.scope ) {

						// Capture the context ID, setting it first if necessary
						if ( ( nid = context.getAttribute( "id" ) ) ) {
							nid = nid.replace( rcssescape, fcssescape );
						} else {
							context.setAttribute( "id", ( nid = expando ) );
						}
					}

					// Prefix every selector in the list
					groups = tokenize( selector );
					i = groups.length;
					while ( i-- ) {
						groups[ i ] = ( nid ? "#" + nid : ":scope" ) + " " +
							toSelector( groups[ i ] );
					}
					newSelector = groups.join( "," );
				}

				try {
					push.apply( results,
						newContext.querySelectorAll( newSelector )
					);
					return results;
				} catch ( qsaError ) {
					nonnativeSelectorCache( selector, true );
				} finally {
					if ( nid === expando ) {
						context.removeAttribute( "id" );
					}
				}
			}
		}
	}

	// All others
	return select( selector.replace( rtrim, "$1" ), context, results, seed );
}

/**
 * Create key-value caches of limited size
 * @returns {function(string, object)} Returns the Object data after storing it on itself with
 *	property name the (space-suffixed) string and (if the cache is larger than Expr.cacheLength)
 *	deleting the oldest entry
 */
function createCache() {
	var keys = [];

	function cache( key, value ) {

		// Use (key + " ") to avoid collision with native prototype properties (see Issue #157)
		if ( keys.push( key + " " ) > Expr.cacheLength ) {

			// Only keep the most recent entries
			delete cache[ keys.shift() ];
		}
		return ( cache[ key + " " ] = value );
	}
	return cache;
}

/**
 * Mark a function for special use by Sizzle
 * @param {Function} fn The function to mark
 */
function markFunction( fn ) {
	fn[ expando ] = true;
	return fn;
}

/**
 * Support testing using an element
 * @param {Function} fn Passed the created element and returns a boolean result
 */
function assert( fn ) {
	var el = document.createElement( "fieldset" );

	try {
		return !!fn( el );
	} catch ( e ) {
		return false;
	} finally {

		// Remove from its parent by default
		if ( el.parentNode ) {
			el.parentNode.removeChild( el );
		}

		// release memory in IE
		el = null;
	}
}

/**
 * Adds the same handler for all of the specified attrs
 * @param {String} attrs Pipe-separated list of attributes
 * @param {Function} handler The method that will be applied
 */
function addHandle( attrs, handler ) {
	var arr = attrs.split( "|" ),
		i = arr.length;

	while ( i-- ) {
		Expr.attrHandle[ arr[ i ] ] = handler;
	}
}

/**
 * Checks document order of two siblings
 * @param {Element} a
 * @param {Element} b
 * @returns {Number} Returns less than 0 if a precedes b, greater than 0 if a follows b
 */
function siblingCheck( a, b ) {
	var cur = b && a,
		diff = cur && a.nodeType === 1 && b.nodeType === 1 &&
			a.sourceIndex - b.sourceIndex;

	// Use IE sourceIndex if available on both nodes
	if ( diff ) {
		return diff;
	}

	// Check if b follows a
	if ( cur ) {
		while ( ( cur = cur.nextSibling ) ) {
			if ( cur === b ) {
				return -1;
			}
		}
	}

	return a ? 1 : -1;
}

/**
 * Returns a function to use in pseudos for input types
 * @param {String} type
 */
function createInputPseudo( type ) {
	return function( elem ) {
		var name = elem.nodeName.toLowerCase();
		return name === "input" && elem.type === type;
	};
}

/**
 * Returns a function to use in pseudos for buttons
 * @param {String} type
 */
function createButtonPseudo( type ) {
	return function( elem ) {
		var name = elem.nodeName.toLowerCase();
		return ( name === "input" || name === "button" ) && elem.type === type;
	};
}

/**
 * Returns a function to use in pseudos for :enabled/:disabled
 * @param {Boolean} disabled true for :disabled; false for :enabled
 */
function createDisabledPseudo( disabled ) {

	// Known :disabled false positives: fieldset[disabled] > legend:nth-of-type(n+2) :can-disable
	return function( elem ) {

		// Only certain elements can match :enabled or :disabled
		// https://html.spec.whatwg.org/multipage/scripting.html#selector-enabled
		// https://html.spec.whatwg.org/multipage/scripting.html#selector-disabled
		if ( "form" in elem ) {

			// Check for inherited disabledness on relevant non-disabled elements:
			// * listed form-associated elements in a disabled fieldset
			//   https://html.spec.whatwg.org/multipage/forms.html#category-listed
			//   https://html.spec.whatwg.org/multipage/forms.html#concept-fe-disabled
			// * option elements in a disabled optgroup
			//   https://html.spec.whatwg.org/multipage/forms.html#concept-option-disabled
			// All such elements have a "form" property.
			if ( elem.parentNode && elem.disabled === false ) {

				// Option elements defer to a parent optgroup if present
				if ( "label" in elem ) {
					if ( "label" in elem.parentNode ) {
						return elem.parentNode.disabled === disabled;
					} else {
						return elem.disabled === disabled;
					}
				}

				// Support: IE 6 - 11
				// Use the isDisabled shortcut property to check for disabled fieldset ancestors
				return elem.isDisabled === disabled ||

					// Where there is no isDisabled, check manually
					/* jshint -W018 */
					elem.isDisabled !== !disabled &&
					inDisabledFieldset( elem ) === disabled;
			}

			return elem.disabled === disabled;

		// Try to winnow out elements that can't be disabled before trusting the disabled property.
		// Some victims get caught in our net (label, legend, menu, track), but it shouldn't
		// even exist on them, let alone have a boolean value.
		} else if ( "label" in elem ) {
			return elem.disabled === disabled;
		}

		// Remaining elements are neither :enabled nor :disabled
		return false;
	};
}

/**
 * Returns a function to use in pseudos for positionals
 * @param {Function} fn
 */
function createPositionalPseudo( fn ) {
	return markFunction( function( argument ) {
		argument = +argument;
		return markFunction( function( seed, matches ) {
			var j,
				matchIndexes = fn( [], seed.length, argument ),
				i = matchIndexes.length;

			// Match elements found at the specified indexes
			while ( i-- ) {
				if ( seed[ ( j = matchIndexes[ i ] ) ] ) {
					seed[ j ] = !( matches[ j ] = seed[ j ] );
				}
			}
		} );
	} );
}

/**
 * Checks a node for validity as a Sizzle context
 * @param {Element|Object=} context
 * @returns {Element|Object|Boolean} The input node if acceptable, otherwise a falsy value
 */
function testContext( context ) {
	return context && typeof context.getElementsByTagName !== "undefined" && context;
}

// Expose support vars for convenience
support = Sizzle.support = {};

/**
 * Detects XML nodes
 * @param {Element|Object} elem An element or a document
 * @returns {Boolean} True iff elem is a non-HTML XML node
 */
isXML = Sizzle.isXML = function( elem ) {
	var namespace = elem.namespaceURI,
		docElem = ( elem.ownerDocument || elem ).documentElement;

	// Support: IE <=8
	// Assume HTML when documentElement doesn't yet exist, such as inside loading iframes
	// https://bugs.jquery.com/ticket/4833
	return !rhtml.test( namespace || docElem && docElem.nodeName || "HTML" );
};

/**
 * Sets document-related variables once based on the current document
 * @param {Element|Object} [doc] An element or document object to use to set the document
 * @returns {Object} Returns the current document
 */
setDocument = Sizzle.setDocument = function( node ) {
	var hasCompare, subWindow,
		doc = node ? node.ownerDocument || node : preferredDoc;

	// Return early if doc is invalid or already selected
	// Support: IE 11+, Edge 17 - 18+
	// IE/Edge sometimes throw a "Permission denied" error when strict-comparing
	// two documents; shallow comparisons work.
	// eslint-disable-next-line eqeqeq
	if ( doc == document || doc.nodeType !== 9 || !doc.documentElement ) {
		return document;
	}

	// Update global variables
	document = doc;
	docElem = document.documentElement;
	documentIsHTML = !isXML( document );

	// Support: IE 9 - 11+, Edge 12 - 18+
	// Accessing iframe documents after unload throws "permission denied" errors (jQuery #13936)
	// Support: IE 11+, Edge 17 - 18+
	// IE/Edge sometimes throw a "Permission denied" error when strict-comparing
	// two documents; shallow comparisons work.
	// eslint-disable-next-line eqeqeq
	if ( preferredDoc != document &&
		( subWindow = document.defaultView ) && subWindow.top !== subWindow ) {

		// Support: IE 11, Edge
		if ( subWindow.addEventListener ) {
			subWindow.addEventListener( "unload", unloadHandler, false );

		// Support: IE 9 - 10 only
		} else if ( subWindow.attachEvent ) {
			subWindow.attachEvent( "onunload", unloadHandler );
		}
	}

	// Support: IE 8 - 11+, Edge 12 - 18+, Chrome <=16 - 25 only, Firefox <=3.6 - 31 only,
	// Safari 4 - 5 only, Opera <=11.6 - 12.x only
	// IE/Edge & older browsers don't support the :scope pseudo-class.
	// Support: Safari 6.0 only
	// Safari 6.0 supports :scope but it's an alias of :root there.
	support.scope = assert( function( el ) {
		docElem.appendChild( el ).appendChild( document.createElement( "div" ) );
		return typeof el.querySelectorAll !== "undefined" &&
			!el.querySelectorAll( ":scope fieldset div" ).length;
	} );

	/* Attributes
	---------------------------------------------------------------------- */

	// Support: IE<8
	// Verify that getAttribute really returns attributes and not properties
	// (excepting IE8 booleans)
	support.attributes = assert( function( el ) {
		el.className = "i";
		return !el.getAttribute( "className" );
	} );

	/* getElement(s)By*
	---------------------------------------------------------------------- */

	// Check if getElementsByTagName("*") returns only elements
	support.getElementsByTagName = assert( function( el ) {
		el.appendChild( document.createComment( "" ) );
		return !el.getElementsByTagName( "*" ).length;
	} );

	// Support: IE<9
	support.getElementsByClassName = rnative.test( document.getElementsByClassName );

	// Support: IE<10
	// Check if getElementById returns elements by name
	// The broken getElementById methods don't pick up programmatically-set names,
	// so use a roundabout getElementsByName test
	support.getById = assert( function( el ) {
		docElem.appendChild( el ).id = expando;
		return !document.getElementsByName || !document.getElementsByName( expando ).length;
	} );

	// ID filter and find
	if ( support.getById ) {
		Expr.filter[ "ID" ] = function( id ) {
			var attrId = id.replace( runescape, funescape );
			return function( elem ) {
				return elem.getAttribute( "id" ) === attrId;
			};
		};
		Expr.find[ "ID" ] = function( id, context ) {
			if ( typeof context.getElementById !== "undefined" && documentIsHTML ) {
				var elem = context.getElementById( id );
				return elem ? [ elem ] : [];
			}
		};
	} else {
		Expr.filter[ "ID" ] =  function( id ) {
			var attrId = id.replace( runescape, funescape );
			return function( elem ) {
				var node = typeof elem.getAttributeNode !== "undefined" &&
					elem.getAttributeNode( "id" );
				return node && node.value === attrId;
			};
		};

		// Support: IE 6 - 7 only
		// getElementById is not reliable as a find shortcut
		Expr.find[ "ID" ] = function( id, context ) {
			if ( typeof context.getElementById !== "undefined" && documentIsHTML ) {
				var node, i, elems,
					elem = context.getElementById( id );

				if ( elem ) {

					// Verify the id attribute
					node = elem.getAttributeNode( "id" );
					if ( node && node.value === id ) {
						return [ elem ];
					}

					// Fall back on getElementsByName
					elems = context.getElementsByName( id );
					i = 0;
					while ( ( elem = elems[ i++ ] ) ) {
						node = elem.getAttributeNode( "id" );
						if ( node && node.value === id ) {
							return [ elem ];
						}
					}
				}

				return [];
			}
		};
	}

	// Tag
	Expr.find[ "TAG" ] = support.getElementsByTagName ?
		function( tag, context ) {
			if ( typeof context.getElementsByTagName !== "undefined" ) {
				return context.getElementsByTagName( tag );

			// DocumentFragment nodes don't have gEBTN
			} else if ( support.qsa ) {
				return context.querySelectorAll( tag );
			}
		} :

		function( tag, context ) {
			var elem,
				tmp = [],
				i = 0,

				// By happy coincidence, a (broken) gEBTN appears on DocumentFragment nodes too
				results = context.getElementsByTagName( tag );

			// Filter out possible comments
			if ( tag === "*" ) {
				while ( ( elem = results[ i++ ] ) ) {
					if ( elem.nodeType === 1 ) {
						tmp.push( elem );
					}
				}

				return tmp;
			}
			return results;
		};

	// Class
	Expr.find[ "CLASS" ] = support.getElementsByClassName && function( className, context ) {
		if ( typeof context.getElementsByClassName !== "undefined" && documentIsHTML ) {
			return context.getElementsByClassName( className );
		}
	};

	/* QSA/matchesSelector
	---------------------------------------------------------------------- */

	// QSA and matchesSelector support

	// matchesSelector(:active) reports false when true (IE9/Opera 11.5)
	rbuggyMatches = [];

	// qSa(:focus) reports false when true (Chrome 21)
	// We allow this because of a bug in IE8/9 that throws an error
	// whenever `document.activeElement` is accessed on an iframe
	// So, we allow :focus to pass through QSA all the time to avoid the IE error
	// See https://bugs.jquery.com/ticket/13378
	rbuggyQSA = [];

	if ( ( support.qsa = rnative.test( document.querySelectorAll ) ) ) {

		// Build QSA regex
		// Regex strategy adopted from Diego Perini
		assert( function( el ) {

			var input;

			// Select is set to empty string on purpose
			// This is to test IE's treatment of not explicitly
			// setting a boolean content attribute,
			// since its presence should be enough
			// https://bugs.jquery.com/ticket/12359
			docElem.appendChild( el ).innerHTML = "<a id='" + expando + "'></a>" +
				"<select id='" + expando + "-\r\\' msallowcapture=''>" +
				"<option selected=''></option></select>";

			// Support: IE8, Opera 11-12.16
			// Nothing should be selected when empty strings follow ^= or $= or *=
			// The test attribute must be unknown in Opera but "safe" for WinRT
			// https://msdn.microsoft.com/en-us/library/ie/hh465388.aspx#attribute_section
			if ( el.querySelectorAll( "[msallowcapture^='']" ).length ) {
				rbuggyQSA.push( "[*^$]=" + whitespace + "*(?:''|\"\")" );
			}

			// Support: IE8
			// Boolean attributes and "value" are not treated correctly
			if ( !el.querySelectorAll( "[selected]" ).length ) {
				rbuggyQSA.push( "\\[" + whitespace + "*(?:value|" + booleans + ")" );
			}

			// Support: Chrome<29, Android<4.4, Safari<7.0+, iOS<7.0+, PhantomJS<1.9.8+
			if ( !el.querySelectorAll( "[id~=" + expando + "-]" ).length ) {
				rbuggyQSA.push( "~=" );
			}

			// Support: IE 11+, Edge 15 - 18+
			// IE 11/Edge don't find elements on a `[name='']` query in some cases.
			// Adding a temporary attribute to the document before the selection works
			// around the issue.
			// Interestingly, IE 10 & older don't seem to have the issue.
			input = document.createElement( "input" );
			input.setAttribute( "name", "" );
			el.appendChild( input );
			if ( !el.querySelectorAll( "[name='']" ).length ) {
				rbuggyQSA.push( "\\[" + whitespace + "*name" + whitespace + "*=" +
					whitespace + "*(?:''|\"\")" );
			}

			// Webkit/Opera - :checked should return selected option elements
			// http://www.w3.org/TR/2011/REC-css3-selectors-20110929/#checked
			// IE8 throws error here and will not see later tests
			if ( !el.querySelectorAll( ":checked" ).length ) {
				rbuggyQSA.push( ":checked" );
			}

			// Support: Safari 8+, iOS 8+
			// https://bugs.webkit.org/show_bug.cgi?id=136851
			// In-page `selector#id sibling-combinator selector` fails
			if ( !el.querySelectorAll( "a#" + expando + "+*" ).length ) {
				rbuggyQSA.push( ".#.+[+~]" );
			}

			// Support: Firefox <=3.6 - 5 only
			// Old Firefox doesn't throw on a badly-escaped identifier.
			el.querySelectorAll( "\\\f" );
			rbuggyQSA.push( "[\\r\\n\\f]" );
		} );

		assert( function( el ) {
			el.innerHTML = "<a href='' disabled='disabled'></a>" +
				"<select disabled='disabled'><option/></select>";

			// Support: Windows 8 Native Apps
			// The type and name attributes are restricted during .innerHTML assignment
			var input = document.createElement( "input" );
			input.setAttribute( "type", "hidden" );
			el.appendChild( input ).setAttribute( "name", "D" );

			// Support: IE8
			// Enforce case-sensitivity of name attribute
			if ( el.querySelectorAll( "[name=d]" ).length ) {
				rbuggyQSA.push( "name" + whitespace + "*[*^$|!~]?=" );
			}

			// FF 3.5 - :enabled/:disabled and hidden elements (hidden elements are still enabled)
			// IE8 throws error here and will not see later tests
			if ( el.querySelectorAll( ":enabled" ).length !== 2 ) {
				rbuggyQSA.push( ":enabled", ":disabled" );
			}

			// Support: IE9-11+
			// IE's :disabled selector does not pick up the children of disabled fieldsets
			docElem.appendChild( el ).disabled = true;
			if ( el.querySelectorAll( ":disabled" ).length !== 2 ) {
				rbuggyQSA.push( ":enabled", ":disabled" );
			}

			// Support: Opera 10 - 11 only
			// Opera 10-11 does not throw on post-comma invalid pseudos
			el.querySelectorAll( "*,:x" );
			rbuggyQSA.push( ",.*:" );
		} );
	}

	if ( ( support.matchesSelector = rnative.test( ( matches = docElem.matches ||
		docElem.webkitMatchesSelector ||
		docElem.mozMatchesSelector ||
		docElem.oMatchesSelector ||
		docElem.msMatchesSelector ) ) ) ) {

		assert( function( el ) {

			// Check to see if it's possible to do matchesSelector
			// on a disconnected node (IE 9)
			support.disconnectedMatch = matches.call( el, "*" );

			// This should fail with an exception
			// Gecko does not error, returns false instead
			matches.call( el, "[s!='']:x" );
			rbuggyMatches.push( "!=", pseudos );
		} );
	}

	rbuggyQSA = rbuggyQSA.length && new RegExp( rbuggyQSA.join( "|" ) );
	rbuggyMatches = rbuggyMatches.length && new RegExp( rbuggyMatches.join( "|" ) );

	/* Contains
	---------------------------------------------------------------------- */
	hasCompare = rnative.test( docElem.compareDocumentPosition );

	// Element contains another
	// Purposefully self-exclusive
	// As in, an element does not contain itself
	contains = hasCompare || rnative.test( docElem.contains ) ?
		function( a, b ) {
			var adown = a.nodeType === 9 ? a.documentElement : a,
				bup = b && b.parentNode;
			return a === bup || !!( bup && bup.nodeType === 1 && (
				adown.contains ?
					adown.contains( bup ) :
					a.compareDocumentPosition && a.compareDocumentPosition( bup ) & 16
			) );
		} :
		function( a, b ) {
			if ( b ) {
				while ( ( b = b.parentNode ) ) {
					if ( b === a ) {
						return true;
					}
				}
			}
			return false;
		};

	/* Sorting
	---------------------------------------------------------------------- */

	// Document order sorting
	sortOrder = hasCompare ?
	function( a, b ) {

		// Flag for duplicate removal
		if ( a === b ) {
			hasDuplicate = true;
			return 0;
		}

		// Sort on method existence if only one input has compareDocumentPosition
		var compare = !a.compareDocumentPosition - !b.compareDocumentPosition;
		if ( compare ) {
			return compare;
		}

		// Calculate position if both inputs belong to the same document
		// Support: IE 11+, Edge 17 - 18+
		// IE/Edge sometimes throw a "Permission denied" error when strict-comparing
		// two documents; shallow comparisons work.
		// eslint-disable-next-line eqeqeq
		compare = ( a.ownerDocument || a ) == ( b.ownerDocument || b ) ?
			a.compareDocumentPosition( b ) :

			// Otherwise we know they are disconnected
			1;

		// Disconnected nodes
		if ( compare & 1 ||
			( !support.sortDetached && b.compareDocumentPosition( a ) === compare ) ) {

			// Choose the first element that is related to our preferred document
			// Support: IE 11+, Edge 17 - 18+
			// IE/Edge sometimes throw a "Permission denied" error when strict-comparing
			// two documents; shallow comparisons work.
			// eslint-disable-next-line eqeqeq
			if ( a == document || a.ownerDocument == preferredDoc &&
				contains( preferredDoc, a ) ) {
				return -1;
			}

			// Support: IE 11+, Edge 17 - 18+
			// IE/Edge sometimes throw a "Permission denied" error when strict-comparing
			// two documents; shallow comparisons work.
			// eslint-disable-next-line eqeqeq
			if ( b == document || b.ownerDocument == preferredDoc &&
				contains( preferredDoc, b ) ) {
				return 1;
			}

			// Maintain original order
			return sortInput ?
				( indexOf( sortInput, a ) - indexOf( sortInput, b ) ) :
				0;
		}

		return compare & 4 ? -1 : 1;
	} :
	function( a, b ) {

		// Exit early if the nodes are identical
		if ( a === b ) {
			hasDuplicate = true;
			return 0;
		}

		var cur,
			i = 0,
			aup = a.parentNode,
			bup = b.parentNode,
			ap = [ a ],
			bp = [ b ];

		// Parentless nodes are either documents or disconnected
		if ( !aup || !bup ) {

			// Support: IE 11+, Edge 17 - 18+
			// IE/Edge sometimes throw a "Permission denied" error when strict-comparing
			// two documents; shallow comparisons work.
			/* eslint-disable eqeqeq */
			return a == document ? -1 :
				b == document ? 1 :
				/* eslint-enable eqeqeq */
				aup ? -1 :
				bup ? 1 :
				sortInput ?
				( indexOf( sortInput, a ) - indexOf( sortInput, b ) ) :
				0;

		// If the nodes are siblings, we can do a quick check
		} else if ( aup === bup ) {
			return siblingCheck( a, b );
		}

		// Otherwise we need full lists of their ancestors for comparison
		cur = a;
		while ( ( cur = cur.parentNode ) ) {
			ap.unshift( cur );
		}
		cur = b;
		while ( ( cur = cur.parentNode ) ) {
			bp.unshift( cur );
		}

		// Walk down the tree looking for a discrepancy
		while ( ap[ i ] === bp[ i ] ) {
			i++;
		}

		return i ?

			// Do a sibling check if the nodes have a common ancestor
			siblingCheck( ap[ i ], bp[ i ] ) :

			// Otherwise nodes in our document sort first
			// Support: IE 11+, Edge 17 - 18+
			// IE/Edge sometimes throw a "Permission denied" error when strict-comparing
			// two documents; shallow comparisons work.
			/* eslint-disable eqeqeq */
			ap[ i ] == preferredDoc ? -1 :
			bp[ i ] == preferredDoc ? 1 :
			/* eslint-enable eqeqeq */
			0;
	};

	return document;
};

Sizzle.matches = function( expr, elements ) {
	return Sizzle( expr, null, null, elements );
};

Sizzle.matchesSelector = function( elem, expr ) {
	setDocument( elem );

	if ( support.matchesSelector && documentIsHTML &&
		!nonnativeSelectorCache[ expr + " " ] &&
		( !rbuggyMatches || !rbuggyMatches.test( expr ) ) &&
		( !rbuggyQSA     || !rbuggyQSA.test( expr ) ) ) {

		try {
			var ret = matches.call( elem, expr );

			// IE 9's matchesSelector returns false on disconnected nodes
			if ( ret || support.disconnectedMatch ||

				// As well, disconnected nodes are said to be in a document
				// fragment in IE 9
				elem.document && elem.document.nodeType !== 11 ) {
				return ret;
			}
		} catch ( e ) {
			nonnativeSelectorCache( expr, true );
		}
	}

	return Sizzle( expr, document, null, [ elem ] ).length > 0;
};

Sizzle.contains = function( context, elem ) {

	// Set document vars if needed
	// Support: IE 11+, Edge 17 - 18+
	// IE/Edge sometimes throw a "Permission denied" error when strict-comparing
	// two documents; shallow comparisons work.
	// eslint-disable-next-line eqeqeq
	if ( ( context.ownerDocument || context ) != document ) {
		setDocument( context );
	}
	return contains( context, elem );
};

Sizzle.attr = function( elem, name ) {

	// Set document vars if needed
	// Support: IE 11+, Edge 17 - 18+
	// IE/Edge sometimes throw a "Permission denied" error when strict-comparing
	// two documents; shallow comparisons work.
	// eslint-disable-next-line eqeqeq
	if ( ( elem.ownerDocument || elem ) != document ) {
		setDocument( elem );
	}

	var fn = Expr.attrHandle[ name.toLowerCase() ],

		// Don't get fooled by Object.prototype properties (jQuery #13807)
		val = fn && hasOwn.call( Expr.attrHandle, name.toLowerCase() ) ?
			fn( elem, name, !documentIsHTML ) :
			undefined;

	return val !== undefined ?
		val :
		support.attributes || !documentIsHTML ?
			elem.getAttribute( name ) :
			( val = elem.getAttributeNode( name ) ) && val.specified ?
				val.value :
				null;
};

Sizzle.escape = function( sel ) {
	return ( sel + "" ).replace( rcssescape, fcssescape );
};

Sizzle.error = function( msg ) {
	throw new Error( "Syntax error, unrecognized expression: " + msg );
};

/**
 * Document sorting and removing duplicates
 * @param {ArrayLike} results
 */
Sizzle.uniqueSort = function( results ) {
	var elem,
		duplicates = [],
		j = 0,
		i = 0;

	// Unless we *know* we can detect duplicates, assume their presence
	hasDuplicate = !support.detectDuplicates;
	sortInput = !support.sortStable && results.slice( 0 );
	results.sort( sortOrder );

	if ( hasDuplicate ) {
		while ( ( elem = results[ i++ ] ) ) {
			if ( elem === results[ i ] ) {
				j = duplicates.push( i );
			}
		}
		while ( j-- ) {
			results.splice( duplicates[ j ], 1 );
		}
	}

	// Clear input after sorting to release objects
	// See https://github.com/jquery/sizzle/pull/225
	sortInput = null;

	return results;
};

/**
 * Utility function for retrieving the text value of an array of DOM nodes
 * @param {Array|Element} elem
 */
getText = Sizzle.getText = function( elem ) {
	var node,
		ret = "",
		i = 0,
		nodeType = elem.nodeType;

	if ( !nodeType ) {

		// If no nodeType, this is expected to be an array
		while ( ( node = elem[ i++ ] ) ) {

			// Do not traverse comment nodes
			ret += getText( node );
		}
	} else if ( nodeType === 1 || nodeType === 9 || nodeType === 11 ) {

		// Use textContent for elements
		// innerText usage removed for consistency of new lines (jQuery #11153)
		if ( typeof elem.textContent === "string" ) {
			return elem.textContent;
		} else {

			// Traverse its children
			for ( elem = elem.firstChild; elem; elem = elem.nextSibling ) {
				ret += getText( elem );
			}
		}
	} else if ( nodeType === 3 || nodeType === 4 ) {
		return elem.nodeValue;
	}

	// Do not include comment or processing instruction nodes

	return ret;
};

Expr = Sizzle.selectors = {

	// Can be adjusted by the user
	cacheLength: 50,

	createPseudo: markFunction,

	match: matchExpr,

	attrHandle: {},

	find: {},

	relative: {
		">": { dir: "parentNode", first: true },
		" ": { dir: "parentNode" },
		"+": { dir: "previousSibling", first: true },
		"~": { dir: "previousSibling" }
	},

	preFilter: {
		"ATTR": function( match ) {
			match[ 1 ] = match[ 1 ].replace( runescape, funescape );

			// Move the given value to match[3] whether quoted or unquoted
			match[ 3 ] = ( match[ 3 ] || match[ 4 ] ||
				match[ 5 ] || "" ).replace( runescape, funescape );

			if ( match[ 2 ] === "~=" ) {
				match[ 3 ] = " " + match[ 3 ] + " ";
			}

			return match.slice( 0, 4 );
		},

		"CHILD": function( match ) {

			/* matches from matchExpr["CHILD"]
				1 type (only|nth|...)
				2 what (child|of-type)
				3 argument (even|odd|\d*|\d*n([+-]\d+)?|...)
				4 xn-component of xn+y argument ([+-]?\d*n|)
				5 sign of xn-component
				6 x of xn-component
				7 sign of y-component
				8 y of y-component
			*/
			match[ 1 ] = match[ 1 ].toLowerCase();

			if ( match[ 1 ].slice( 0, 3 ) === "nth" ) {

				// nth-* requires argument
				if ( !match[ 3 ] ) {
					Sizzle.error( match[ 0 ] );
				}

				// numeric x and y parameters for Expr.filter.CHILD
				// remember that false/true cast respectively to 0/1
				match[ 4 ] = +( match[ 4 ] ?
					match[ 5 ] + ( match[ 6 ] || 1 ) :
					2 * ( match[ 3 ] === "even" || match[ 3 ] === "odd" ) );
				match[ 5 ] = +( ( match[ 7 ] + match[ 8 ] ) || match[ 3 ] === "odd" );

				// other types prohibit arguments
			} else if ( match[ 3 ] ) {
				Sizzle.error( match[ 0 ] );
			}

			return match;
		},

		"PSEUDO": function( match ) {
			var excess,
				unquoted = !match[ 6 ] && match[ 2 ];

			if ( matchExpr[ "CHILD" ].test( match[ 0 ] ) ) {
				return null;
			}

			// Accept quoted arguments as-is
			if ( match[ 3 ] ) {
				match[ 2 ] = match[ 4 ] || match[ 5 ] || "";

			// Strip excess characters from unquoted arguments
			} else if ( unquoted && rpseudo.test( unquoted ) &&

				// Get excess from tokenize (recursively)
				( excess = tokenize( unquoted, true ) ) &&

				// advance to the next closing parenthesis
				( excess = unquoted.indexOf( ")", unquoted.length - excess ) - unquoted.length ) ) {

				// excess is a negative index
				match[ 0 ] = match[ 0 ].slice( 0, excess );
				match[ 2 ] = unquoted.slice( 0, excess );
			}

			// Return only captures needed by the pseudo filter method (type and argument)
			return match.slice( 0, 3 );
		}
	},

	filter: {

		"TAG": function( nodeNameSelector ) {
			var nodeName = nodeNameSelector.replace( runescape, funescape ).toLowerCase();
			return nodeNameSelector === "*" ?
				function() {
					return true;
				} :
				function( elem ) {
					return elem.nodeName && elem.nodeName.toLowerCase() === nodeName;
				};
		},

		"CLASS": function( className ) {
			var pattern = classCache[ className + " " ];

			return pattern ||
				( pattern = new RegExp( "(^|" + whitespace +
					")" + className + "(" + whitespace + "|$)" ) ) && classCache(
						className, function( elem ) {
							return pattern.test(
								typeof elem.className === "string" && elem.className ||
								typeof elem.getAttribute !== "undefined" &&
									elem.getAttribute( "class" ) ||
								""
							);
				} );
		},

		"ATTR": function( name, operator, check ) {
			return function( elem ) {
				var result = Sizzle.attr( elem, name );

				if ( result == null ) {
					return operator === "!=";
				}
				if ( !operator ) {
					return true;
				}

				result += "";

				/* eslint-disable max-len */

				return operator === "=" ? result === check :
					operator === "!=" ? result !== check :
					operator === "^=" ? check && result.indexOf( check ) === 0 :
					operator === "*=" ? check && result.indexOf( check ) > -1 :
					operator === "$=" ? check && result.slice( -check.length ) === check :
					operator === "~=" ? ( " " + result.replace( rwhitespace, " " ) + " " ).indexOf( check ) > -1 :
					operator === "|=" ? result === check || result.slice( 0, check.length + 1 ) === check + "-" :
					false;
				/* eslint-enable max-len */

			};
		},

		"CHILD": function( type, what, _argument, first, last ) {
			var simple = type.slice( 0, 3 ) !== "nth",
				forward = type.slice( -4 ) !== "last",
				ofType = what === "of-type";

			return first === 1 && last === 0 ?

				// Shortcut for :nth-*(n)
				function( elem ) {
					return !!elem.parentNode;
				} :

				function( elem, _context, xml ) {
					var cache, uniqueCache, outerCache, node, nodeIndex, start,
						dir = simple !== forward ? "nextSibling" : "previousSibling",
						parent = elem.parentNode,
						name = ofType && elem.nodeName.toLowerCase(),
						useCache = !xml && !ofType,
						diff = false;

					if ( parent ) {

						// :(first|last|only)-(child|of-type)
						if ( simple ) {
							while ( dir ) {
								node = elem;
								while ( ( node = node[ dir ] ) ) {
									if ( ofType ?
										node.nodeName.toLowerCase() === name :
										node.nodeType === 1 ) {

										return false;
									}
								}

								// Reverse direction for :only-* (if we haven't yet done so)
								start = dir = type === "only" && !start && "nextSibling";
							}
							return true;
						}

						start = [ forward ? parent.firstChild : parent.lastChild ];

						// non-xml :nth-child(...) stores cache data on `parent`
						if ( forward && useCache ) {

							// Seek `elem` from a previously-cached index

							// ...in a gzip-friendly way
							node = parent;
							outerCache = node[ expando ] || ( node[ expando ] = {} );

							// Support: IE <9 only
							// Defend against cloned attroperties (jQuery gh-1709)
							uniqueCache = outerCache[ node.uniqueID ] ||
								( outerCache[ node.uniqueID ] = {} );

							cache = uniqueCache[ type ] || [];
							nodeIndex = cache[ 0 ] === dirruns && cache[ 1 ];
							diff = nodeIndex && cache[ 2 ];
							node = nodeIndex && parent.childNodes[ nodeIndex ];

							while ( ( node = ++nodeIndex && node && node[ dir ] ||

								// Fallback to seeking `elem` from the start
								( diff = nodeIndex = 0 ) || start.pop() ) ) {

								// When found, cache indexes on `parent` and break
								if ( node.nodeType === 1 && ++diff && node === elem ) {
									uniqueCache[ type ] = [ dirruns, nodeIndex, diff ];
									break;
								}
							}

						} else {

							// Use previously-cached element index if available
							if ( useCache ) {

								// ...in a gzip-friendly way
								node = elem;
								outerCache = node[ expando ] || ( node[ expando ] = {} );

								// Support: IE <9 only
								// Defend against cloned attroperties (jQuery gh-1709)
								uniqueCache = outerCache[ node.uniqueID ] ||
									( outerCache[ node.uniqueID ] = {} );

								cache = uniqueCache[ type ] || [];
								nodeIndex = cache[ 0 ] === dirruns && cache[ 1 ];
								diff = nodeIndex;
							}

							// xml :nth-child(...)
							// or :nth-last-child(...) or :nth(-last)?-of-type(...)
							if ( diff === false ) {

								// Use the same loop as above to seek `elem` from the start
								while ( ( node = ++nodeIndex && node && node[ dir ] ||
									( diff = nodeIndex = 0 ) || start.pop() ) ) {

									if ( ( ofType ?
										node.nodeName.toLowerCase() === name :
										node.nodeType === 1 ) &&
										++diff ) {

										// Cache the index of each encountered element
										if ( useCache ) {
											outerCache = node[ expando ] ||
												( node[ expando ] = {} );

											// Support: IE <9 only
											// Defend against cloned attroperties (jQuery gh-1709)
											uniqueCache = outerCache[ node.uniqueID ] ||
												( outerCache[ node.uniqueID ] = {} );

											uniqueCache[ type ] = [ dirruns, diff ];
										}

										if ( node === elem ) {
											break;
										}
									}
								}
							}
						}

						// Incorporate the offset, then check against cycle size
						diff -= last;
						return diff === first || ( diff % first === 0 && diff / first >= 0 );
					}
				};
		},

		"PSEUDO": function( pseudo, argument ) {

			// pseudo-class names are case-insensitive
			// http://www.w3.org/TR/selectors/#pseudo-classes
			// Prioritize by case sensitivity in case custom pseudos are added with uppercase letters
			// Remember that setFilters inherits from pseudos
			var args,
				fn = Expr.pseudos[ pseudo ] || Expr.setFilters[ pseudo.toLowerCase() ] ||
					Sizzle.error( "unsupported pseudo: " + pseudo );

			// The user may use createPseudo to indicate that
			// arguments are needed to create the filter function
			// just as Sizzle does
			if ( fn[ expando ] ) {
				return fn( argument );
			}

			// But maintain support for old signatures
			if ( fn.length > 1 ) {
				args = [ pseudo, pseudo, "", argument ];
				return Expr.setFilters.hasOwnProperty( pseudo.toLowerCase() ) ?
					markFunction( function( seed, matches ) {
						var idx,
							matched = fn( seed, argument ),
							i = matched.length;
						while ( i-- ) {
							idx = indexOf( seed, matched[ i ] );
							seed[ idx ] = !( matches[ idx ] = matched[ i ] );
						}
					} ) :
					function( elem ) {
						return fn( elem, 0, args );
					};
			}

			return fn;
		}
	},

	pseudos: {

		// Potentially complex pseudos
		"not": markFunction( function( selector ) {

			// Trim the selector passed to compile
			// to avoid treating leading and trailing
			// spaces as combinators
			var input = [],
				results = [],
				matcher = compile( selector.replace( rtrim, "$1" ) );

			return matcher[ expando ] ?
				markFunction( function( seed, matches, _context, xml ) {
					var elem,
						unmatched = matcher( seed, null, xml, [] ),
						i = seed.length;

					// Match elements unmatched by `matcher`
					while ( i-- ) {
						if ( ( elem = unmatched[ i ] ) ) {
							seed[ i ] = !( matches[ i ] = elem );
						}
					}
				} ) :
				function( elem, _context, xml ) {
					input[ 0 ] = elem;
					matcher( input, null, xml, results );

					// Don't keep the element (issue #299)
					input[ 0 ] = null;
					return !results.pop();
				};
		} ),

		"has": markFunction( function( selector ) {
			return function( elem ) {
				return Sizzle( selector, elem ).length > 0;
			};
		} ),

		"contains": markFunction( function( text ) {
			text = text.replace( runescape, funescape );
			return function( elem ) {
				return ( elem.textContent || getText( elem ) ).indexOf( text ) > -1;
			};
		} ),

		// "Whether an element is represented by a :lang() selector
		// is based solely on the element's language value
		// being equal to the identifier C,
		// or beginning with the identifier C immediately followed by "-".
		// The matching of C against the element's language value is performed case-insensitively.
		// The identifier C does not have to be a valid language name."
		// http://www.w3.org/TR/selectors/#lang-pseudo
		"lang": markFunction( function( lang ) {

			// lang value must be a valid identifier
			if ( !ridentifier.test( lang || "" ) ) {
				Sizzle.error( "unsupported lang: " + lang );
			}
			lang = lang.replace( runescape, funescape ).toLowerCase();
			return function( elem ) {
				var elemLang;
				do {
					if ( ( elemLang = documentIsHTML ?
						elem.lang :
						elem.getAttribute( "xml:lang" ) || elem.getAttribute( "lang" ) ) ) {

						elemLang = elemLang.toLowerCase();
						return elemLang === lang || elemLang.indexOf( lang + "-" ) === 0;
					}
				} while ( ( elem = elem.parentNode ) && elem.nodeType === 1 );
				return false;
			};
		} ),

		// Miscellaneous
		"target": function( elem ) {
			var hash = window.location && window.location.hash;
			return hash && hash.slice( 1 ) === elem.id;
		},

		"root": function( elem ) {
			return elem === docElem;
		},

		"focus": function( elem ) {
			return elem === document.activeElement &&
				( !document.hasFocus || document.hasFocus() ) &&
				!!( elem.type || elem.href || ~elem.tabIndex );
		},

		// Boolean properties
		"enabled": createDisabledPseudo( false ),
		"disabled": createDisabledPseudo( true ),

		"checked": function( elem ) {

			// In CSS3, :checked should return both checked and selected elements
			// http://www.w3.org/TR/2011/REC-css3-selectors-20110929/#checked
			var nodeName = elem.nodeName.toLowerCase();
			return ( nodeName === "input" && !!elem.checked ) ||
				( nodeName === "option" && !!elem.selected );
		},

		"selected": function( elem ) {

			// Accessing this property makes selected-by-default
			// options in Safari work properly
			if ( elem.parentNode ) {
				// eslint-disable-next-line no-unused-expressions
				elem.parentNode.selectedIndex;
			}

			return elem.selected === true;
		},

		// Contents
		"empty": function( elem ) {

			// http://www.w3.org/TR/selectors/#empty-pseudo
			// :empty is negated by element (1) or content nodes (text: 3; cdata: 4; entity ref: 5),
			//   but not by others (comment: 8; processing instruction: 7; etc.)
			// nodeType < 6 works because attributes (2) do not appear as children
			for ( elem = elem.firstChild; elem; elem = elem.nextSibling ) {
				if ( elem.nodeType < 6 ) {
					return false;
				}
			}
			return true;
		},

		"parent": function( elem ) {
			return !Expr.pseudos[ "empty" ]( elem );
		},

		// Element/input types
		"header": function( elem ) {
			return rheader.test( elem.nodeName );
		},

		"input": function( elem ) {
			return rinputs.test( elem.nodeName );
		},

		"button": function( elem ) {
			var name = elem.nodeName.toLowerCase();
			return name === "input" && elem.type === "button" || name === "button";
		},

		"text": function( elem ) {
			var attr;
			return elem.nodeName.toLowerCase() === "input" &&
				elem.type === "text" &&

				// Support: IE<8
				// New HTML5 attribute values (e.g., "search") appear with elem.type === "text"
				( ( attr = elem.getAttribute( "type" ) ) == null ||
					attr.toLowerCase() === "text" );
		},

		// Position-in-collection
		"first": createPositionalPseudo( function() {
			return [ 0 ];
		} ),

		"last": createPositionalPseudo( function( _matchIndexes, length ) {
			return [ length - 1 ];
		} ),

		"eq": createPositionalPseudo( function( _matchIndexes, length, argument ) {
			return [ argument < 0 ? argument + length : argument ];
		} ),

		"even": createPositionalPseudo( function( matchIndexes, length ) {
			var i = 0;
			for ( ; i < length; i += 2 ) {
				matchIndexes.push( i );
			}
			return matchIndexes;
		} ),

		"odd": createPositionalPseudo( function( matchIndexes, length ) {
			var i = 1;
			for ( ; i < length; i += 2 ) {
				matchIndexes.push( i );
			}
			return matchIndexes;
		} ),

		"lt": createPositionalPseudo( function( matchIndexes, length, argument ) {
			var i = argument < 0 ?
				argument + length :
				argument > length ?
					length :
					argument;
			for ( ; --i >= 0; ) {
				matchIndexes.push( i );
			}
			return matchIndexes;
		} ),

		"gt": createPositionalPseudo( function( matchIndexes, length, argument ) {
			var i = argument < 0 ? argument + length : argument;
			for ( ; ++i < length; ) {
				matchIndexes.push( i );
			}
			return matchIndexes;
		} )
	}
};

Expr.pseudos[ "nth" ] = Expr.pseudos[ "eq" ];

// Add button/input type pseudos
for ( i in { radio: true, checkbox: true, file: true, password: true, image: true } ) {
	Expr.pseudos[ i ] = createInputPseudo( i );
}
for ( i in { submit: true, reset: true } ) {
	Expr.pseudos[ i ] = createButtonPseudo( i );
}

// Easy API for creating new setFilters
function setFilters() {}
setFilters.prototype = Expr.filters = Expr.pseudos;
Expr.setFilters = new setFilters();

tokenize = Sizzle.tokenize = function( selector, parseOnly ) {
	var matched, match, tokens, type,
		soFar, groups, preFilters,
		cached = tokenCache[ selector + " " ];

	if ( cached ) {
		return parseOnly ? 0 : cached.slice( 0 );
	}

	soFar = selector;
	groups = [];
	preFilters = Expr.preFilter;

	while ( soFar ) {

		// Comma and first run
		if ( !matched || ( match = rcomma.exec( soFar ) ) ) {
			if ( match ) {

				// Don't consume trailing commas as valid
				soFar = soFar.slice( match[ 0 ].length ) || soFar;
			}
			groups.push( ( tokens = [] ) );
		}

		matched = false;

		// Combinators
		if ( ( match = rcombinators.exec( soFar ) ) ) {
			matched = match.shift();
			tokens.push( {
				value: matched,

				// Cast descendant combinators to space
				type: match[ 0 ].replace( rtrim, " " )
			} );
			soFar = soFar.slice( matched.length );
		}

		// Filters
		for ( type in Expr.filter ) {
			if ( ( match = matchExpr[ type ].exec( soFar ) ) && ( !preFilters[ type ] ||
				( match = preFilters[ type ]( match ) ) ) ) {
				matched = match.shift();
				tokens.push( {
					value: matched,
					type: type,
					matches: match
				} );
				soFar = soFar.slice( matched.length );
			}
		}

		if ( !matched ) {
			break;
		}
	}

	// Return the length of the invalid excess
	// if we're just parsing
	// Otherwise, throw an error or return tokens
	return parseOnly ?
		soFar.length :
		soFar ?
			Sizzle.error( selector ) :

			// Cache the tokens
			tokenCache( selector, groups ).slice( 0 );
};

function toSelector( tokens ) {
	var i = 0,
		len = tokens.length,
		selector = "";
	for ( ; i < len; i++ ) {
		selector += tokens[ i ].value;
	}
	return selector;
}

function addCombinator( matcher, combinator, base ) {
	var dir = combinator.dir,
		skip = combinator.next,
		key = skip || dir,
		checkNonElements = base && key === "parentNode",
		doneName = done++;

	return combinator.first ?

		// Check against closest ancestor/preceding element
		function( elem, context, xml ) {
			while ( ( elem = elem[ dir ] ) ) {
				if ( elem.nodeType === 1 || checkNonElements ) {
					return matcher( elem, context, xml );
				}
			}
			return false;
		} :

		// Check against all ancestor/preceding elements
		function( elem, context, xml ) {
			var oldCache, uniqueCache, outerCache,
				newCache = [ dirruns, doneName ];

			// We can't set arbitrary data on XML nodes, so they don't benefit from combinator caching
			if ( xml ) {
				while ( ( elem = elem[ dir ] ) ) {
					if ( elem.nodeType === 1 || checkNonElements ) {
						if ( matcher( elem, context, xml ) ) {
							return true;
						}
					}
				}
			} else {
				while ( ( elem = elem[ dir ] ) ) {
					if ( elem.nodeType === 1 || checkNonElements ) {
						outerCache = elem[ expando ] || ( elem[ expando ] = {} );

						// Support: IE <9 only
						// Defend against cloned attroperties (jQuery gh-1709)
						uniqueCache = outerCache[ elem.uniqueID ] ||
							( outerCache[ elem.uniqueID ] = {} );

						if ( skip && skip === elem.nodeName.toLowerCase() ) {
							elem = elem[ dir ] || elem;
						} else if ( ( oldCache = uniqueCache[ key ] ) &&
							oldCache[ 0 ] === dirruns && oldCache[ 1 ] === doneName ) {

							// Assign to newCache so results back-propagate to previous elements
							return ( newCache[ 2 ] = oldCache[ 2 ] );
						} else {

							// Reuse newcache so results back-propagate to previous elements
							uniqueCache[ key ] = newCache;

							// A match means we're done; a fail means we have to keep checking
							if ( ( newCache[ 2 ] = matcher( elem, context, xml ) ) ) {
								return true;
							}
						}
					}
				}
			}
			return false;
		};
}

function elementMatcher( matchers ) {
	return matchers.length > 1 ?
		function( elem, context, xml ) {
			var i = matchers.length;
			while ( i-- ) {
				if ( !matchers[ i ]( elem, context, xml ) ) {
					return false;
				}
			}
			return true;
		} :
		matchers[ 0 ];
}

function multipleContexts( selector, contexts, results ) {
	var i = 0,
		len = contexts.length;
	for ( ; i < len; i++ ) {
		Sizzle( selector, contexts[ i ], results );
	}
	return results;
}

function condense( unmatched, map, filter, context, xml ) {
	var elem,
		newUnmatched = [],
		i = 0,
		len = unmatched.length,
		mapped = map != null;

	for ( ; i < len; i++ ) {
		if ( ( elem = unmatched[ i ] ) ) {
			if ( !filter || filter( elem, context, xml ) ) {
				newUnmatched.push( elem );
				if ( mapped ) {
					map.push( i );
				}
			}
		}
	}

	return newUnmatched;
}

function setMatcher( preFilter, selector, matcher, postFilter, postFinder, postSelector ) {
	if ( postFilter && !postFilter[ expando ] ) {
		postFilter = setMatcher( postFilter );
	}
	if ( postFinder && !postFinder[ expando ] ) {
		postFinder = setMatcher( postFinder, postSelector );
	}
	return markFunction( function( seed, results, context, xml ) {
		var temp, i, elem,
			preMap = [],
			postMap = [],
			preexisting = results.length,

			// Get initial elements from seed or context
			elems = seed || multipleContexts(
				selector || "*",
				context.nodeType ? [ context ] : context,
				[]
			),

			// Prefilter to get matcher input, preserving a map for seed-results synchronization
			matcherIn = preFilter && ( seed || !selector ) ?
				condense( elems, preMap, preFilter, context, xml ) :
				elems,

			matcherOut = matcher ?

				// If we have a postFinder, or filtered seed, or non-seed postFilter or preexisting results,
				postFinder || ( seed ? preFilter : preexisting || postFilter ) ?

					// ...intermediate processing is necessary
					[] :

					// ...otherwise use results directly
					results :
				matcherIn;

		// Find primary matches
		if ( matcher ) {
			matcher( matcherIn, matcherOut, context, xml );
		}

		// Apply postFilter
		if ( postFilter ) {
			temp = condense( matcherOut, postMap );
			postFilter( temp, [], context, xml );

			// Un-match failing elements by moving them back to matcherIn
			i = temp.length;
			while ( i-- ) {
				if ( ( elem = temp[ i ] ) ) {
					matcherOut[ postMap[ i ] ] = !( matcherIn[ postMap[ i ] ] = elem );
				}
			}
		}

		if ( seed ) {
			if ( postFinder || preFilter ) {
				if ( postFinder ) {

					// Get the final matcherOut by condensing this intermediate into postFinder contexts
					temp = [];
					i = matcherOut.length;
					while ( i-- ) {
						if ( ( elem = matcherOut[ i ] ) ) {

							// Restore matcherIn since elem is not yet a final match
							temp.push( ( matcherIn[ i ] = elem ) );
						}
					}
					postFinder( null, ( matcherOut = [] ), temp, xml );
				}

				// Move matched elements from seed to results to keep them synchronized
				i = matcherOut.length;
				while ( i-- ) {
					if ( ( elem = matcherOut[ i ] ) &&
						( temp = postFinder ? indexOf( seed, elem ) : preMap[ i ] ) > -1 ) {

						seed[ temp ] = !( results[ temp ] = elem );
					}
				}
			}

		// Add elements to results, through postFinder if defined
		} else {
			matcherOut = condense(
				matcherOut === results ?
					matcherOut.splice( preexisting, matcherOut.length ) :
					matcherOut
			);
			if ( postFinder ) {
				postFinder( null, results, matcherOut, xml );
			} else {
				push.apply( results, matcherOut );
			}
		}
	} );
}

function matcherFromTokens( tokens ) {
	var checkContext, matcher, j,
		len = tokens.length,
		leadingRelative = Expr.relative[ tokens[ 0 ].type ],
		implicitRelative = leadingRelative || Expr.relative[ " " ],
		i = leadingRelative ? 1 : 0,

		// The foundational matcher ensures that elements are reachable from top-level context(s)
		matchContext = addCombinator( function( elem ) {
			return elem === checkContext;
		}, implicitRelative, true ),
		matchAnyContext = addCombinator( function( elem ) {
			return indexOf( checkContext, elem ) > -1;
		}, implicitRelative, true ),
		matchers = [ function( elem, context, xml ) {
			var ret = ( !leadingRelative && ( xml || context !== outermostContext ) ) || (
				( checkContext = context ).nodeType ?
					matchContext( elem, context, xml ) :
					matchAnyContext( elem, context, xml ) );

			// Avoid hanging onto element (issue #299)
			checkContext = null;
			return ret;
		} ];

	for ( ; i < len; i++ ) {
		if ( ( matcher = Expr.relative[ tokens[ i ].type ] ) ) {
			matchers = [ addCombinator( elementMatcher( matchers ), matcher ) ];
		} else {
			matcher = Expr.filter[ tokens[ i ].type ].apply( null, tokens[ i ].matches );

			// Return special upon seeing a positional matcher
			if ( matcher[ expando ] ) {

				// Find the next relative operator (if any) for proper handling
				j = ++i;
				for ( ; j < len; j++ ) {
					if ( Expr.relative[ tokens[ j ].type ] ) {
						break;
					}
				}
				return setMatcher(
					i > 1 && elementMatcher( matchers ),
					i > 1 && toSelector(

					// If the preceding token was a descendant combinator, insert an implicit any-element `*`
					tokens
						.slice( 0, i - 1 )
						.concat( { value: tokens[ i - 2 ].type === " " ? "*" : "" } )
					).replace( rtrim, "$1" ),
					matcher,
					i < j && matcherFromTokens( tokens.slice( i, j ) ),
					j < len && matcherFromTokens( ( tokens = tokens.slice( j ) ) ),
					j < len && toSelector( tokens )
				);
			}
			matchers.push( matcher );
		}
	}

	return elementMatcher( matchers );
}

function matcherFromGroupMatchers( elementMatchers, setMatchers ) {
	var bySet = setMatchers.length > 0,
		byElement = elementMatchers.length > 0,
		superMatcher = function( seed, context, xml, results, outermost ) {
			var elem, j, matcher,
				matchedCount = 0,
				i = "0",
				unmatched = seed && [],
				setMatched = [],
				contextBackup = outermostContext,

				// We must always have either seed elements or outermost context
				elems = seed || byElement && Expr.find[ "TAG" ]( "*", outermost ),

				// Use integer dirruns iff this is the outermost matcher
				dirrunsUnique = ( dirruns += contextBackup == null ? 1 : Math.random() || 0.1 ),
				len = elems.length;

			if ( outermost ) {

				// Support: IE 11+, Edge 17 - 18+
				// IE/Edge sometimes throw a "Permission denied" error when strict-comparing
				// two documents; shallow comparisons work.
				// eslint-disable-next-line eqeqeq
				outermostContext = context == document || context || outermost;
			}

			// Add elements passing elementMatchers directly to results
			// Support: IE<9, Safari
			// Tolerate NodeList properties (IE: "length"; Safari: <number>) matching elements by id
			for ( ; i !== len && ( elem = elems[ i ] ) != null; i++ ) {
				if ( byElement && elem ) {
					j = 0;

					// Support: IE 11+, Edge 17 - 18+
					// IE/Edge sometimes throw a "Permission denied" error when strict-comparing
					// two documents; shallow comparisons work.
					// eslint-disable-next-line eqeqeq
					if ( !context && elem.ownerDocument != document ) {
						setDocument( elem );
						xml = !documentIsHTML;
					}
					while ( ( matcher = elementMatchers[ j++ ] ) ) {
						if ( matcher( elem, context || document, xml ) ) {
							results.push( elem );
							break;
						}
					}
					if ( outermost ) {
						dirruns = dirrunsUnique;
					}
				}

				// Track unmatched elements for set filters
				if ( bySet ) {

					// They will have gone through all possible matchers
					if ( ( elem = !matcher && elem ) ) {
						matchedCount--;
					}

					// Lengthen the array for every element, matched or not
					if ( seed ) {
						unmatched.push( elem );
					}
				}
			}

			// `i` is now the count of elements visited above, and adding it to `matchedCount`
			// makes the latter nonnegative.
			matchedCount += i;

			// Apply set filters to unmatched elements
			// NOTE: This can be skipped if there are no unmatched elements (i.e., `matchedCount`
			// equals `i`), unless we didn't visit _any_ elements in the above loop because we have
			// no element matchers and no seed.
			// Incrementing an initially-string "0" `i` allows `i` to remain a string only in that
			// case, which will result in a "00" `matchedCount` that differs from `i` but is also
			// numerically zero.
			if ( bySet && i !== matchedCount ) {
				j = 0;
				while ( ( matcher = setMatchers[ j++ ] ) ) {
					matcher( unmatched, setMatched, context, xml );
				}

				if ( seed ) {

					// Reintegrate element matches to eliminate the need for sorting
					if ( matchedCount > 0 ) {
						while ( i-- ) {
							if ( !( unmatched[ i ] || setMatched[ i ] ) ) {
								setMatched[ i ] = pop.call( results );
							}
						}
					}

					// Discard index placeholder values to get only actual matches
					setMatched = condense( setMatched );
				}

				// Add matches to results
				push.apply( results, setMatched );

				// Seedless set matches succeeding multiple successful matchers stipulate sorting
				if ( outermost && !seed && setMatched.length > 0 &&
					( matchedCount + setMatchers.length ) > 1 ) {

					Sizzle.uniqueSort( results );
				}
			}

			// Override manipulation of globals by nested matchers
			if ( outermost ) {
				dirruns = dirrunsUnique;
				outermostContext = contextBackup;
			}

			return unmatched;
		};

	return bySet ?
		markFunction( superMatcher ) :
		superMatcher;
}

compile = Sizzle.compile = function( selector, match /* Internal Use Only */ ) {
	var i,
		setMatchers = [],
		elementMatchers = [],
		cached = compilerCache[ selector + " " ];

	if ( !cached ) {

		// Generate a function of recursive functions that can be used to check each element
		if ( !match ) {
			match = tokenize( selector );
		}
		i = match.length;
		while ( i-- ) {
			cached = matcherFromTokens( match[ i ] );
			if ( cached[ expando ] ) {
				setMatchers.push( cached );
			} else {
				elementMatchers.push( cached );
			}
		}

		// Cache the compiled function
		cached = compilerCache(
			selector,
			matcherFromGroupMatchers( elementMatchers, setMatchers )
		);

		// Save selector and tokenization
		cached.selector = selector;
	}
	return cached;
};

/**
 * A low-level selection function that works with Sizzle's compiled
 *  selector functions
 * @param {String|Function} selector A selector or a pre-compiled
 *  selector function built with Sizzle.compile
 * @param {Element} context
 * @param {Array} [results]
 * @param {Array} [seed] A set of elements to match against
 */
select = Sizzle.select = function( selector, context, results, seed ) {
	var i, tokens, token, type, find,
		compiled = typeof selector === "function" && selector,
		match = !seed && tokenize( ( selector = compiled.selector || selector ) );

	results = results || [];

	// Try to minimize operations if there is only one selector in the list and no seed
	// (the latter of which guarantees us context)
	if ( match.length === 1 ) {

		// Reduce context if the leading compound selector is an ID
		tokens = match[ 0 ] = match[ 0 ].slice( 0 );
		if ( tokens.length > 2 && ( token = tokens[ 0 ] ).type === "ID" &&
			context.nodeType === 9 && documentIsHTML && Expr.relative[ tokens[ 1 ].type ] ) {

			context = ( Expr.find[ "ID" ]( token.matches[ 0 ]
				.replace( runescape, funescape ), context ) || [] )[ 0 ];
			if ( !context ) {
				return results;

			// Precompiled matchers will still verify ancestry, so step up a level
			} else if ( compiled ) {
				context = context.parentNode;
			}

			selector = selector.slice( tokens.shift().value.length );
		}

		// Fetch a seed set for right-to-left matching
		i = matchExpr[ "needsContext" ].test( selector ) ? 0 : tokens.length;
		while ( i-- ) {
			token = tokens[ i ];

			// Abort if we hit a combinator
			if ( Expr.relative[ ( type = token.type ) ] ) {
				break;
			}
			if ( ( find = Expr.find[ type ] ) ) {

				// Search, expanding context for leading sibling combinators
				if ( ( seed = find(
					token.matches[ 0 ].replace( runescape, funescape ),
					rsibling.test( tokens[ 0 ].type ) && testContext( context.parentNode ) ||
						context
				) ) ) {

					// If seed is empty or no tokens remain, we can return early
					tokens.splice( i, 1 );
					selector = seed.length && toSelector( tokens );
					if ( !selector ) {
						push.apply( results, seed );
						return results;
					}

					break;
				}
			}
		}
	}

	// Compile and execute a filtering function if one is not provided
	// Provide `match` to avoid retokenization if we modified the selector above
	( compiled || compile( selector, match ) )(
		seed,
		context,
		!documentIsHTML,
		results,
		!context || rsibling.test( selector ) && testContext( context.parentNode ) || context
	);
	return results;
};

// One-time assignments

// Sort stability
support.sortStable = expando.split( "" ).sort( sortOrder ).join( "" ) === expando;

// Support: Chrome 14-35+
// Always assume duplicates if they aren't passed to the comparison function
support.detectDuplicates = !!hasDuplicate;

// Initialize against the default document
setDocument();

// Support: Webkit<537.32 - Safari 6.0.3/Chrome 25 (fixed in Chrome 27)
// Detached nodes confoundingly follow *each other*
support.sortDetached = assert( function( el ) {

	// Should return 1, but returns 4 (following)
	return el.compareDocumentPosition( document.createElement( "fieldset" ) ) & 1;
} );

// Support: IE<8
// Prevent attribute/property "interpolation"
// https://msdn.microsoft.com/en-us/library/ms536429%28VS.85%29.aspx
if ( !assert( function( el ) {
	el.innerHTML = "<a href='#'></a>";
	return el.firstChild.getAttribute( "href" ) === "#";
} ) ) {
	addHandle( "type|href|height|width", function( elem, name, isXML ) {
		if ( !isXML ) {
			return elem.getAttribute( name, name.toLowerCase() === "type" ? 1 : 2 );
		}
	} );
}

// Support: IE<9
// Use defaultValue in place of getAttribute("value")
if ( !support.attributes || !assert( function( el ) {
	el.innerHTML = "<input/>";
	el.firstChild.setAttribute( "value", "" );
	return el.firstChild.getAttribute( "value" ) === "";
} ) ) {
	addHandle( "value", function( elem, _name, isXML ) {
		if ( !isXML && elem.nodeName.toLowerCase() === "input" ) {
			return elem.defaultValue;
		}
	} );
}

// Support: IE<9
// Use getAttributeNode to fetch booleans when getAttribute lies
if ( !assert( function( el ) {
	return el.getAttribute( "disabled" ) == null;
} ) ) {
	addHandle( booleans, function( elem, name, isXML ) {
		var val;
		if ( !isXML ) {
			return elem[ name ] === true ? name.toLowerCase() :
				( val = elem.getAttributeNode( name ) ) && val.specified ?
					val.value :
					null;
		}
	} );
}

return Sizzle;

} )( window );



jQuery.find = Sizzle;
jQuery.expr = Sizzle.selectors;

// Deprecated
jQuery.expr[ ":" ] = jQuery.expr.pseudos;
jQuery.uniqueSort = jQuery.unique = Sizzle.uniqueSort;
jQuery.text = Sizzle.getText;
jQuery.isXMLDoc = Sizzle.isXML;
jQuery.contains = Sizzle.contains;
jQuery.escapeSelector = Sizzle.escape;




var dir = function( elem, dir, until ) {
	var matched = [],
		truncate = until !== undefined;

	while ( ( elem = elem[ dir ] ) && elem.nodeType !== 9 ) {
		if ( elem.nodeType === 1 ) {
			if ( truncate && jQuery( elem ).is( until ) ) {
				break;
			}
			matched.push( elem );
		}
	}
	return matched;
};


var siblings = function( n, elem ) {
	var matched = [];

	for ( ; n; n = n.nextSibling ) {
		if ( n.nodeType === 1 && n !== elem ) {
			matched.push( n );
		}
	}

	return matched;
};


var rneedsContext = jQuery.expr.match.needsContext;



function nodeName( elem, name ) {

  return elem.nodeName && elem.nodeName.toLowerCase() === name.toLowerCase();

};
var rsingleTag = ( /^<([a-z][^\/\0>:\x20\t\r\n\f]*)[\x20\t\r\n\f]*\/?>(?:<\/\1>|)$/i );



// Implement the identical functionality for filter and not
function winnow( elements, qualifier, not ) {
	if ( isFunction( qualifier ) ) {
		return jQuery.grep( elements, function( elem, i ) {
			return !!qualifier.call( elem, i, elem ) !== not;
		} );
	}

	// Single element
	if ( qualifier.nodeType ) {
		return jQuery.grep( elements, function( elem ) {
			return ( elem === qualifier ) !== not;
		} );
	}

	// Arraylike of elements (jQuery, arguments, Array)
	if ( typeof qualifier !== "string" ) {
		return jQuery.grep( elements, function( elem ) {
			return ( indexOf.call( qualifier, elem ) > -1 ) !== not;
		} );
	}

	// Filtered directly for both simple and complex selectors
	return jQuery.filter( qualifier, elements, not );
}

jQuery.filter = function( expr, elems, not ) {
	var elem = elems[ 0 ];

	if ( not ) {
		expr = ":not(" + expr + ")";
	}

	if ( elems.length === 1 && elem.nodeType === 1 ) {
		return jQuery.find.matchesSelector( elem, expr ) ? [ elem ] : [];
	}

	return jQuery.find.matches( expr, jQuery.grep( elems, function( elem ) {
		return elem.nodeType === 1;
	} ) );
};

jQuery.fn.extend( {
	find: function( selector ) {
		var i, ret,
			len = this.length,
			self = this;

		if ( typeof selector !== "string" ) {
			return this.pushStack( jQuery( selector ).filter( function() {
				for ( i = 0; i < len; i++ ) {
					if ( jQuery.contains( self[ i ], this ) ) {
						return true;
					}
				}
			} ) );
		}

		ret = this.pushStack( [] );

		for ( i = 0; i < len; i++ ) {
			jQuery.find( selector, self[ i ], ret );
		}

		return len > 1 ? jQuery.uniqueSort( ret ) : ret;
	},
	filter: function( selector ) {
		return this.pushStack( winnow( this, selector || [], false ) );
	},
	not: function( selector ) {
		return this.pushStack( winnow( this, selector || [], true ) );
	},
	is: function( selector ) {
		return !!winnow(
			this,

			// If this is a positional/relative selector, check membership in the returned set
			// so $("p:first").is("p:last") won't return true for a doc with two "p".
			typeof selector === "string" && rneedsContext.test( selector ) ?
				jQuery( selector ) :
				selector || [],
			false
		).length;
	}
} );


// Initialize a jQuery object


// A central reference to the root jQuery(document)
var rootjQuery,

	// A simple way to check for HTML strings
	// Prioritize #id over <tag> to avoid XSS via location.hash (#9521)
	// Strict HTML recognition (#11290: must start with <)
	// Shortcut simple #id case for speed
	rquickExpr = /^(?:\s*(<[\w\W]+>)[^>]*|#([\w-]+))$/,

	init = jQuery.fn.init = function( selector, context, root ) {
		var match, elem;

		// HANDLE: $(""), $(null), $(undefined), $(false)
		if ( !selector ) {
			return this;
		}

		// Method init() accepts an alternate rootjQuery
		// so migrate can support jQuery.sub (gh-2101)
		root = root || rootjQuery;

		// Handle HTML strings
		if ( typeof selector === "string" ) {
			if ( selector[ 0 ] === "<" &&
				selector[ selector.length - 1 ] === ">" &&
				selector.length >= 3 ) {

				// Assume that strings that start and end with <> are HTML and skip the regex check
				match = [ null, selector, null ];

			} else {
				match = rquickExpr.exec( selector );
			}

			// Match html or make sure no context is specified for #id
			if ( match && ( match[ 1 ] || !context ) ) {

				// HANDLE: $(html) -> $(array)
				if ( match[ 1 ] ) {
					context = context instanceof jQuery ? context[ 0 ] : context;

					// Option to run scripts is true for back-compat
					// Intentionally let the error be thrown if parseHTML is not present
					jQuery.merge( this, jQuery.parseHTML(
						match[ 1 ],
						context && context.nodeType ? context.ownerDocument || context : document,
						true
					) );

					// HANDLE: $(html, props)
					if ( rsingleTag.test( match[ 1 ] ) && jQuery.isPlainObject( context ) ) {
						for ( match in context ) {

							// Properties of context are called as methods if possible
							if ( isFunction( this[ match ] ) ) {
								this[ match ]( context[ match ] );

							// ...and otherwise set as attributes
							} else {
								this.attr( match, context[ match ] );
							}
						}
					}

					return this;

				// HANDLE: $(#id)
				} else {
					elem = document.getElementById( match[ 2 ] );

					if ( elem ) {

						// Inject the element directly into the jQuery object
						this[ 0 ] = elem;
						this.length = 1;
					}
					return this;
				}

			// HANDLE: $(expr, $(...))
			} else if ( !context || context.jquery ) {
				return ( context || root ).find( selector );

			// HANDLE: $(expr, context)
			// (which is just equivalent to: $(context).find(expr)
			} else {
				return this.constructor( context ).find( selector );
			}

		// HANDLE: $(DOMElement)
		} else if ( selector.nodeType ) {
			this[ 0 ] = selector;
			this.length = 1;
			return this;

		// HANDLE: $(function)
		// Shortcut for document ready
		} else if ( isFunction( selector ) ) {
			return root.ready !== undefined ?
				root.ready( selector ) :

				// Execute immediately if ready is not present
				selector( jQuery );
		}

		return jQuery.makeArray( selector, this );
	};

// Give the init function the jQuery prototype for later instantiation
init.prototype = jQuery.fn;

// Initialize central reference
rootjQuery = jQuery( document );


var rparentsprev = /^(?:parents|prev(?:Until|All))/,

	// Methods guaranteed to produce a unique set when starting from a unique set
	guaranteedUnique = {
		children: true,
		contents: true,
		next: true,
		prev: true
	};

jQuery.fn.extend( {
	has: function( target ) {
		var targets = jQuery( target, this ),
			l = targets.length;

		return this.filter( function() {
			var i = 0;
			for ( ; i < l; i++ ) {
				if ( jQuery.contains( this, targets[ i ] ) ) {
					return true;
				}
			}
		} );
	},

	closest: function( selectors, context ) {
		var cur,
			i = 0,
			l = this.length,
			matched = [],
			targets = typeof selectors !== "string" && jQuery( selectors );

		// Positional selectors never match, since there's no _selection_ context
		if ( !rneedsContext.test( selectors ) ) {
			for ( ; i < l; i++ ) {
				for ( cur = this[ i ]; cur && cur !== context; cur = cur.parentNode ) {

					// Always skip document fragments
					if ( cur.nodeType < 11 && ( targets ?
						targets.index( cur ) > -1 :

						// Don't pass non-elements to Sizzle
						cur.nodeType === 1 &&
							jQuery.find.matchesSelector( cur, selectors ) ) ) {

						matched.push( cur );
						break;
					}
				}
			}
		}

		return this.pushStack( matched.length > 1 ? jQuery.uniqueSort( matched ) : matched );
	},

	// Determine the position of an element within the set
	index: function( elem ) {

		// No argument, return index in parent
		if ( !elem ) {
			return ( this[ 0 ] && this[ 0 ].parentNode ) ? this.first().prevAll().length : -1;
		}

		// Index in selector
		if ( typeof elem === "string" ) {
			return indexOf.call( jQuery( elem ), this[ 0 ] );
		}

		// Locate the position of the desired element
		return indexOf.call( this,

			// If it receives a jQuery object, the first element is used
			elem.jquery ? elem[ 0 ] : elem
		);
	},

	add: function( selector, context ) {
		return this.pushStack(
			jQuery.uniqueSort(
				jQuery.merge( this.get(), jQuery( selector, context ) )
			)
		);
	},

	addBack: function( selector ) {
		return this.add( selector == null ?
			this.prevObject : this.prevObject.filter( selector )
		);
	}
} );

function sibling( cur, dir ) {
	while ( ( cur = cur[ dir ] ) && cur.nodeType !== 1 ) {}
	return cur;
}

jQuery.each( {
	parent: function( elem ) {
		var parent = elem.parentNode;
		return parent && parent.nodeType !== 11 ? parent : null;
	},
	parents: function( elem ) {
		return dir( elem, "parentNode" );
	},
	parentsUntil: function( elem, _i, until ) {
		return dir( elem, "parentNode", until );
	},
	next: function( elem ) {
		return sibling( elem, "nextSibling" );
	},
	prev: function( elem ) {
		return sibling( elem, "previousSibling" );
	},
	nextAll: function( elem ) {
		return dir( elem, "nextSibling" );
	},
	prevAll: function( elem ) {
		return dir( elem, "previousSibling" );
	},
	nextUntil: function( elem, _i, until ) {
		return dir( elem, "nextSibling", until );
	},
	prevUntil: function( elem, _i, until ) {
		return dir( elem, "previousSibling", until );
	},
	siblings: function( elem ) {
		return siblings( ( elem.parentNode || {} ).firstChild, elem );
	},
	children: function( elem ) {
		return siblings( elem.firstChild );
	},
	contents: function( elem ) {
		if ( elem.contentDocument != null &&

			// Support: IE 11+
			// <object> elements with no `data` attribute has an object
			// `contentDocument` with a `null` prototype.
			getProto( elem.contentDocument ) ) {

			return elem.contentDocument;
		}

		// Support: IE 9 - 11 only, iOS 7 only, Android Browser <=4.3 only
		// Treat the template element as a regular one in browsers that
		// don't support it.
		if ( nodeName( elem, "template" ) ) {
			elem = elem.content || elem;
		}

		return jQuery.merge( [], elem.childNodes );
	}
}, function( name, fn ) {
	jQuery.fn[ name ] = function( until, selector ) {
		var matched = jQuery.map( this, fn, until );

		if ( name.slice( -5 ) !== "Until" ) {
			selector = until;
		}

		if ( selector && typeof selector === "string" ) {
			matched = jQuery.filter( selector, matched );
		}

		if ( this.length > 1 ) {

			// Remove duplicates
			if ( !guaranteedUnique[ name ] ) {
				jQuery.uniqueSort( matched );
			}

			// Reverse order for parents* and prev-derivatives
			if ( rparentsprev.test( name ) ) {
				matched.reverse();
			}
		}

		return this.pushStack( matched );
	};
} );
var rnothtmlwhite = ( /[^\x20\t\r\n\f]+/g );



// Convert String-formatted options into Object-formatted ones
function createOptions( options ) {
	var object = {};
	jQuery.each( options.match( rnothtmlwhite ) || [], function( _, flag ) {
		object[ flag ] = true;
	} );
	return object;
}

/*
 * Create a callback list using the following parameters:
 *
 *	options: an optional list of space-separated options that will change how
 *			the callback list behaves or a more traditional option object
 *
 * By default a callback list will act like an event callback list and can be
 * "fired" multiple times.
 *
 * Possible options:
 *
 *	once:			will ensure the callback list can only be fired once (like a Deferred)
 *
 *	memory:			will keep track of previous values and will call any callback added
 *					after the list has been fired right away with the latest "memorized"
 *					values (like a Deferred)
 *
 *	unique:			will ensure a callback can only be added once (no duplicate in the list)
 *
 *	stopOnFalse:	interrupt callings when a callback returns false
 *
 */
jQuery.Callbacks = function( options ) {

	// Convert options from String-formatted to Object-formatted if needed
	// (we check in cache first)
	options = typeof options === "string" ?
		createOptions( options ) :
		jQuery.extend( {}, options );

	var // Flag to know if list is currently firing
		firing,

		// Last fire value for non-forgettable lists
		memory,

		// Flag to know if list was already fired
		fired,

		// Flag to prevent firing
		locked,

		// Actual callback list
		list = [],

		// Queue of execution data for repeatable lists
		queue = [],

		// Index of currently firing callback (modified by add/remove as needed)
		firingIndex = -1,

		// Fire callbacks
		fire = function() {

			// Enforce single-firing
			locked = locked || options.once;

			// Execute callbacks for all pending executions,
			// respecting firingIndex overrides and runtime changes
			fired = firing = true;
			for ( ; queue.length; firingIndex = -1 ) {
				memory = queue.shift();
				while ( ++firingIndex < list.length ) {

					// Run callback and check for early termination
					if ( list[ firingIndex ].apply( memory[ 0 ], memory[ 1 ] ) === false &&
						options.stopOnFalse ) {

						// Jump to end and forget the data so .add doesn't re-fire
						firingIndex = list.length;
						memory = false;
					}
				}
			}

			// Forget the data if we're done with it
			if ( !options.memory ) {
				memory = false;
			}

			firing = false;

			// Clean up if we're done firing for good
			if ( locked ) {

				// Keep an empty list if we have data for future add calls
				if ( memory ) {
					list = [];

				// Otherwise, this object is spent
				} else {
					list = "";
				}
			}
		},

		// Actual Callbacks object
		self = {

			// Add a callback or a collection of callbacks to the list
			add: function() {
				if ( list ) {

					// If we have memory from a past run, we should fire after adding
					if ( memory && !firing ) {
						firingIndex = list.length - 1;
						queue.push( memory );
					}

					( function add( args ) {
						jQuery.each( args, function( _, arg ) {
							if ( isFunction( arg ) ) {
								if ( !options.unique || !self.has( arg ) ) {
									list.push( arg );
								}
							} else if ( arg && arg.length && toType( arg ) !== "string" ) {

								// Inspect recursively
								add( arg );
							}
						} );
					} )( arguments );

					if ( memory && !firing ) {
						fire();
					}
				}
				return this;
			},

			// Remove a callback from the list
			remove: function() {
				jQuery.each( arguments, function( _, arg ) {
					var index;
					while ( ( index = jQuery.inArray( arg, list, index ) ) > -1 ) {
						list.splice( index, 1 );

						// Handle firing indexes
						if ( index <= firingIndex ) {
							firingIndex--;
						}
					}
				} );
				return this;
			},

			// Check if a given callback is in the list.
			// If no argument is given, return whether or not list has callbacks attached.
			has: function( fn ) {
				return fn ?
					jQuery.inArray( fn, list ) > -1 :
					list.length > 0;
			},

			// Remove all callbacks from the list
			empty: function() {
				if ( list ) {
					list = [];
				}
				return this;
			},

			// Disable .fire and .add
			// Abort any current/pending executions
			// Clear all callbacks and values
			disable: function() {
				locked = queue = [];
				list = memory = "";
				return this;
			},
			disabled: function() {
				return !list;
			},

			// Disable .fire
			// Also disable .add unless we have memory (since it would have no effect)
			// Abort any pending executions
			lock: function() {
				locked = queue = [];
				if ( !memory && !firing ) {
					list = memory = "";
				}
				return this;
			},
			locked: function() {
				return !!locked;
			},

			// Call all callbacks with the given context and arguments
			fireWith: function( context, args ) {
				if ( !locked ) {
					args = args || [];
					args = [ context, args.slice ? args.slice() : args ];
					queue.push( args );
					if ( !firing ) {
						fire();
					}
				}
				return this;
			},

			// Call all the callbacks with the given arguments
			fire: function() {
				self.fireWith( this, arguments );
				return this;
			},

			// To know if the callbacks have already been called at least once
			fired: function() {
				return !!fired;
			}
		};

	return self;
};


function Identity( v ) {
	return v;
}
function Thrower( ex ) {
	throw ex;
}

function adoptValue( value, resolve, reject, noValue ) {
	var method;

	try {

		// Check for promise aspect first to privilege synchronous behavior
		if ( value && isFunction( ( method = value.promise ) ) ) {
			method.call( value ).done( resolve ).fail( reject );

		// Other thenables
		} else if ( value && isFunction( ( method = value.then ) ) ) {
			method.call( value, resolve, reject );

		// Other non-thenables
		} else {

			// Control `resolve` arguments by letting Array#slice cast boolean `noValue` to integer:
			// * false: [ value ].slice( 0 ) => resolve( value )
			// * true: [ value ].slice( 1 ) => resolve()
			resolve.apply( undefined, [ value ].slice( noValue ) );
		}

	// For Promises/A+, convert exceptions into rejections
	// Since jQuery.when doesn't unwrap thenables, we can skip the extra checks appearing in
	// Deferred#then to conditionally suppress rejection.
	} catch ( value ) {

		// Support: Android 4.0 only
		// Strict mode functions invoked without .call/.apply get global-object context
		reject.apply( undefined, [ value ] );
	}
}

jQuery.extend( {

	Deferred: function( func ) {
		var tuples = [

				// action, add listener, callbacks,
				// ... .then handlers, argument index, [final state]
				[ "notify", "progress", jQuery.Callbacks( "memory" ),
					jQuery.Callbacks( "memory" ), 2 ],
				[ "resolve", "done", jQuery.Callbacks( "once memory" ),
					jQuery.Callbacks( "once memory" ), 0, "resolved" ],
				[ "reject", "fail", jQuery.Callbacks( "once memory" ),
					jQuery.Callbacks( "once memory" ), 1, "rejected" ]
			],
			state = "pending",
			promise = {
				state: function() {
					return state;
				},
				always: function() {
					deferred.done( arguments ).fail( arguments );
					return this;
				},
				"catch": function( fn ) {
					return promise.then( null, fn );
				},

				// Keep pipe for back-compat
				pipe: function( /* fnDone, fnFail, fnProgress */ ) {
					var fns = arguments;

					return jQuery.Deferred( function( newDefer ) {
						jQuery.each( tuples, function( _i, tuple ) {

							// Map tuples (progress, done, fail) to arguments (done, fail, progress)
							var fn = isFunction( fns[ tuple[ 4 ] ] ) && fns[ tuple[ 4 ] ];

							// deferred.progress(function() { bind to newDefer or newDefer.notify })
							// deferred.done(function() { bind to newDefer or newDefer.resolve })
							// deferred.fail(function() { bind to newDefer or newDefer.reject })
							deferred[ tuple[ 1 ] ]( function() {
								var returned = fn && fn.apply( this, arguments );
								if ( returned && isFunction( returned.promise ) ) {
									returned.promise()
										.progress( newDefer.notify )
										.done( newDefer.resolve )
										.fail( newDefer.reject );
								} else {
									newDefer[ tuple[ 0 ] + "With" ](
										this,
										fn ? [ returned ] : arguments
									);
								}
							} );
						} );
						fns = null;
					} ).promise();
				},
				then: function( onFulfilled, onRejected, onProgress ) {
					var maxDepth = 0;
					function resolve( depth, deferred, handler, special ) {
						return function() {
							var that = this,
								args = arguments,
								mightThrow = function() {
									var returned, then;

									// Support: Promises/A+ section 2.3.3.3.3
									// https://promisesaplus.com/#point-59
									// Ignore double-resolution attempts
									if ( depth < maxDepth ) {
										return;
									}

									returned = handler.apply( that, args );

									// Support: Promises/A+ section 2.3.1
									// https://promisesaplus.com/#point-48
									if ( returned === deferred.promise() ) {
										throw new TypeError( "Thenable self-resolution" );
									}

									// Support: Promises/A+ sections 2.3.3.1, 3.5
									// https://promisesaplus.com/#point-54
									// https://promisesaplus.com/#point-75
									// Retrieve `then` only once
									then = returned &&

										// Support: Promises/A+ section 2.3.4
										// https://promisesaplus.com/#point-64
										// Only check objects and functions for thenability
										( typeof returned === "object" ||
											typeof returned === "function" ) &&
										returned.then;

									// Handle a returned thenable
									if ( isFunction( then ) ) {

										// Special processors (notify) just wait for resolution
										if ( special ) {
											then.call(
												returned,
												resolve( maxDepth, deferred, Identity, special ),
												resolve( maxDepth, deferred, Thrower, special )
											);

										// Normal processors (resolve) also hook into progress
										} else {

											// ...and disregard older resolution values
											maxDepth++;

											then.call(
												returned,
												resolve( maxDepth, deferred, Identity, special ),
												resolve( maxDepth, deferred, Thrower, special ),
												resolve( maxDepth, deferred, Identity,
													deferred.notifyWith )
											);
										}

									// Handle all other returned values
									} else {

										// Only substitute handlers pass on context
										// and multiple values (non-spec behavior)
										if ( handler !== Identity ) {
											that = undefined;
											args = [ returned ];
										}

										// Process the value(s)
										// Default process is resolve
										( special || deferred.resolveWith )( that, args );
									}
								},

								// Only normal processors (resolve) catch and reject exceptions
								process = special ?
									mightThrow :
									function() {
										try {
											mightThrow();
										} catch ( e ) {

											if ( jQuery.Deferred.exceptionHook ) {
												jQuery.Deferred.exceptionHook( e,
													process.stackTrace );
											}

											// Support: Promises/A+ section 2.3.3.3.4.1
											// https://promisesaplus.com/#point-61
											// Ignore post-resolution exceptions
											if ( depth + 1 >= maxDepth ) {

												// Only substitute handlers pass on context
												// and multiple values (non-spec behavior)
												if ( handler !== Thrower ) {
													that = undefined;
													args = [ e ];
												}

												deferred.rejectWith( that, args );
											}
										}
									};

							// Support: Promises/A+ section 2.3.3.3.1
							// https://promisesaplus.com/#point-57
							// Re-resolve promises immediately to dodge false rejection from
							// subsequent errors
							if ( depth ) {
								process();
							} else {

								// Call an optional hook to record the stack, in case of exception
								// since it's otherwise lost when execution goes async
								if ( jQuery.Deferred.getStackHook ) {
									process.stackTrace = jQuery.Deferred.getStackHook();
								}
								window.setTimeout( process );
							}
						};
					}

					return jQuery.Deferred( function( newDefer ) {

						// progress_handlers.add( ... )
						tuples[ 0 ][ 3 ].add(
							resolve(
								0,
								newDefer,
								isFunction( onProgress ) ?
									onProgress :
									Identity,
								newDefer.notifyWith
							)
						);

						// fulfilled_handlers.add( ... )
						tuples[ 1 ][ 3 ].add(
							resolve(
								0,
								newDefer,
								isFunction( onFulfilled ) ?
									onFulfilled :
									Identity
							)
						);

						// rejected_handlers.add( ... )
						tuples[ 2 ][ 3 ].add(
							resolve(
								0,
								newDefer,
								isFunction( onRejected ) ?
									onRejected :
									Thrower
							)
						);
					} ).promise();
				},

				// Get a promise for this deferred
				// If obj is provided, the promise aspect is added to the object
				promise: function( obj ) {
					return obj != null ? jQuery.extend( obj, promise ) : promise;
				}
			},
			deferred = {};

		// Add list-specific methods
		jQuery.each( tuples, function( i, tuple ) {
			var list = tuple[ 2 ],
				stateString = tuple[ 5 ];

			// promise.progress = list.add
			// promise.done = list.add
			// promise.fail = list.add
			promise[ tuple[ 1 ] ] = list.add;

			// Handle state
			if ( stateString ) {
				list.add(
					function() {

						// state = "resolved" (i.e., fulfilled)
						// state = "rejected"
						state = stateString;
					},

					// rejected_callbacks.disable
					// fulfilled_callbacks.disable
					tuples[ 3 - i ][ 2 ].disable,

					// rejected_handlers.disable
					// fulfilled_handlers.disable
					tuples[ 3 - i ][ 3 ].disable,

					// progress_callbacks.lock
					tuples[ 0 ][ 2 ].lock,

					// progress_handlers.lock
					tuples[ 0 ][ 3 ].lock
				);
			}

			// progress_handlers.fire
			// fulfilled_handlers.fire
			// rejected_handlers.fire
			list.add( tuple[ 3 ].fire );

			// deferred.notify = function() { deferred.notifyWith(...) }
			// deferred.resolve = function() { deferred.resolveWith(...) }
			// deferred.reject = function() { deferred.rejectWith(...) }
			deferred[ tuple[ 0 ] ] = function() {
				deferred[ tuple[ 0 ] + "With" ]( this === deferred ? undefined : this, arguments );
				return this;
			};

			// deferred.notifyWith = list.fireWith
			// deferred.resolveWith = list.fireWith
			// deferred.rejectWith = list.fireWith
			deferred[ tuple[ 0 ] + "With" ] = list.fireWith;
		} );

		// Make the deferred a promise
		promise.promise( deferred );

		// Call given func if any
		if ( func ) {
			func.call( deferred, deferred );
		}

		// All done!
		return deferred;
	},

	// Deferred helper
	when: function( singleValue ) {
		var

			// count of uncompleted subordinates
			remaining = arguments.length,

			// count of unprocessed arguments
			i = remaining,

			// subordinate fulfillment data
			resolveContexts = Array( i ),
			resolveValues = slice.call( arguments ),

			// the master Deferred
			master = jQuery.Deferred(),

			// subordinate callback factory
			updateFunc = function( i ) {
				return function( value ) {
					resolveContexts[ i ] = this;
					resolveValues[ i ] = arguments.length > 1 ? slice.call( arguments ) : value;
					if ( !( --remaining ) ) {
						master.resolveWith( resolveContexts, resolveValues );
					}
				};
			};

		// Single- and empty arguments are adopted like Promise.resolve
		if ( remaining <= 1 ) {
			adoptValue( singleValue, master.done( updateFunc( i ) ).resolve, master.reject,
				!remaining );

			// Use .then() to unwrap secondary thenables (cf. gh-3000)
			if ( master.state() === "pending" ||
				isFunction( resolveValues[ i ] && resolveValues[ i ].then ) ) {

				return master.then();
			}
		}

		// Multiple arguments are aggregated like Promise.all array elements
		while ( i-- ) {
			adoptValue( resolveValues[ i ], updateFunc( i ), master.reject );
		}

		return master.promise();
	}
} );


// These usually indicate a programmer mistake during development,
// warn about them ASAP rather than swallowing them by default.
var rerrorNames = /^(Eval|Internal|Range|Reference|Syntax|Type|URI)Error$/;

jQuery.Deferred.exceptionHook = function( error, stack ) {

	// Support: IE 8 - 9 only
	// Console exists when dev tools are open, which can happen at any time
	if ( window.console && window.console.warn && error && rerrorNames.test( error.name ) ) {
		window.console.warn( "jQuery.Deferred exception: " + error.message, error.stack, stack );
	}
};




jQuery.readyException = function( error ) {
	window.setTimeout( function() {
		throw error;
	} );
};




// The deferred used on DOM ready
var readyList = jQuery.Deferred();

jQuery.fn.ready = function( fn ) {

	readyList
		.then( fn )

		// Wrap jQuery.readyException in a function so that the lookup
		// happens at the time of error handling instead of callback
		// registration.
		.catch( function( error ) {
			jQuery.readyException( error );
		} );

	return this;
};

jQuery.extend( {

	// Is the DOM ready to be used? Set to true once it occurs.
	isReady: false,

	// A counter to track how many items to wait for before
	// the ready event fires. See #6781
	readyWait: 1,

	// Handle when the DOM is ready
	ready: function( wait ) {

		// Abort if there are pending holds or we're already ready
		if ( wait === true ? --jQuery.readyWait : jQuery.isReady ) {
			return;
		}

		// Remember that the DOM is ready
		jQuery.isReady = true;

		// If a normal DOM Ready event fired, decrement, and wait if need be
		if ( wait !== true && --jQuery.readyWait > 0 ) {
			return;
		}

		// If there are functions bound, to execute
		readyList.resolveWith( document, [ jQuery ] );
	}
} );

jQuery.ready.then = readyList.then;

// The ready event handler and self cleanup method
function completed() {
	document.removeEventListener( "DOMContentLoaded", completed );
	window.removeEventListener( "load", completed );
	jQuery.ready();
}

// Catch cases where $(document).ready() is called
// after the browser event has already occurred.
// Support: IE <=9 - 10 only
// Older IE sometimes signals "interactive" too soon
if ( document.readyState === "complete" ||
	( document.readyState !== "loading" && !document.documentElement.doScroll ) ) {

	// Handle it asynchronously to allow scripts the opportunity to delay ready
	window.setTimeout( jQuery.ready );

} else {

	// Use the handy event callback
	document.addEventListener( "DOMContentLoaded", completed );

	// A fallback to window.onload, that will always work
	window.addEventListener( "load", completed );
}




// Multifunctional method to get and set values of a collection
// The value/s can optionally be executed if it's a function
var access = function( elems, fn, key, value, chainable, emptyGet, raw ) {
	var i = 0,
		len = elems.length,
		bulk = key == null;

	// Sets many values
	if ( toType( key ) === "object" ) {
		chainable = true;
		for ( i in key ) {
			access( elems, fn, i, key[ i ], true, emptyGet, raw );
		}

	// Sets one value
	} else if ( value !== undefined ) {
		chainable = true;

		if ( !isFunction( value ) ) {
			raw = true;
		}

		if ( bulk ) {

			// Bulk operations run against the entire set
			if ( raw ) {
				fn.call( elems, value );
				fn = null;

			// ...except when executing function values
			} else {
				bulk = fn;
				fn = function( elem, _key, value ) {
					return bulk.call( jQuery( elem ), value );
				};
			}
		}

		if ( fn ) {
			for ( ; i < len; i++ ) {
				fn(
					elems[ i ], key, raw ?
					value :
					value.call( elems[ i ], i, fn( elems[ i ], key ) )
				);
			}
		}
	}

	if ( chainable ) {
		return elems;
	}

	// Gets
	if ( bulk ) {
		return fn.call( elems );
	}

	return len ? fn( elems[ 0 ], key ) : emptyGet;
};


// Matches dashed string for camelizing
var rmsPrefix = /^-ms-/,
	rdashAlpha = /-([a-z])/g;

// Used by camelCase as callback to replace()
function fcamelCase( _all, letter ) {
	return letter.toUpperCase();
}

// Convert dashed to camelCase; used by the css and data modules
// Support: IE <=9 - 11, Edge 12 - 15
// Microsoft forgot to hump their vendor prefix (#9572)
function camelCase( string ) {
	return string.replace( rmsPrefix, "ms-" ).replace( rdashAlpha, fcamelCase );
}
var acceptData = function( owner ) {

	// Accepts only:
	//  - Node
	//    - Node.ELEMENT_NODE
	//    - Node.DOCUMENT_NODE
	//  - Object
	//    - Any
	return owner.nodeType === 1 || owner.nodeType === 9 || !( +owner.nodeType );
};




function Data() {
	this.expando = jQuery.expando + Data.uid++;
}

Data.uid = 1;

Data.prototype = {

	cache: function( owner ) {

		// Check if the owner object already has a cache
		var value = owner[ this.expando ];

		// If not, create one
		if ( !value ) {
			value = {};

			// We can accept data for non-element nodes in modern browsers,
			// but we should not, see #8335.
			// Always return an empty object.
			if ( acceptData( owner ) ) {

				// If it is a node unlikely to be stringify-ed or looped over
				// use plain assignment
				if ( owner.nodeType ) {
					owner[ this.expando ] = value;

				// Otherwise secure it in a non-enumerable property
				// configurable must be true to allow the property to be
				// deleted when data is removed
				} else {
					Object.defineProperty( owner, this.expando, {
						value: value,
						configurable: true
					} );
				}
			}
		}

		return value;
	},
	set: function( owner, data, value ) {
		var prop,
			cache = this.cache( owner );

		// Handle: [ owner, key, value ] args
		// Always use camelCase key (gh-2257)
		if ( typeof data === "string" ) {
			cache[ camelCase( data ) ] = value;

		// Handle: [ owner, { properties } ] args
		} else {

			// Copy the properties one-by-one to the cache object
			for ( prop in data ) {
				cache[ camelCase( prop ) ] = data[ prop ];
			}
		}
		return cache;
	},
	get: function( owner, key ) {
		return key === undefined ?
			this.cache( owner ) :

			// Always use camelCase key (gh-2257)
			owner[ this.expando ] && owner[ this.expando ][ camelCase( key ) ];
	},
	access: function( owner, key, value ) {

		// In cases where either:
		//
		//   1. No key was specified
		//   2. A string key was specified, but no value provided
		//
		// Take the "read" path and allow the get method to determine
		// which value to return, respectively either:
		//
		//   1. The entire cache object
		//   2. The data stored at the key
		//
		if ( key === undefined ||
				( ( key && typeof key === "string" ) && value === undefined ) ) {

			return this.get( owner, key );
		}

		// When the key is not a string, or both a key and value
		// are specified, set or extend (existing objects) with either:
		//
		//   1. An object of properties
		//   2. A key and value
		//
		this.set( owner, key, value );

		// Since the "set" path can have two possible entry points
		// return the expected data based on which path was taken[*]
		return value !== undefined ? value : key;
	},
	remove: function( owner, key ) {
		var i,
			cache = owner[ this.expando ];

		if ( cache === undefined ) {
			return;
		}

		if ( key !== undefined ) {

			// Support array or space separated string of keys
			if ( Array.isArray( key ) ) {

				// If key is an array of keys...
				// We always set camelCase keys, so remove that.
				key = key.map( camelCase );
			} else {
				key = camelCase( key );

				// If a key with the spaces exists, use it.
				// Otherwise, create an array by matching non-whitespace
				key = key in cache ?
					[ key ] :
					( key.match( rnothtmlwhite ) || [] );
			}

			i = key.length;

			while ( i-- ) {
				delete cache[ key[ i ] ];
			}
		}

		// Remove the expando if there's no more data
		if ( key === undefined || jQuery.isEmptyObject( cache ) ) {

			// Support: Chrome <=35 - 45
			// Webkit & Blink performance suffers when deleting properties
			// from DOM nodes, so set to undefined instead
			// https://bugs.chromium.org/p/chromium/issues/detail?id=378607 (bug restricted)
			if ( owner.nodeType ) {
				owner[ this.expando ] = undefined;
			} else {
				delete owner[ this.expando ];
			}
		}
	},
	hasData: function( owner ) {
		var cache = owner[ this.expando ];
		return cache !== undefined && !jQuery.isEmptyObject( cache );
	}
};
var dataPriv = new Data();

var dataUser = new Data();



//	Implementation Summary
//
//	1. Enforce API surface and semantic compatibility with 1.9.x branch
//	2. Improve the module's maintainability by reducing the storage
//		paths to a single mechanism.
//	3. Use the same single mechanism to support "private" and "user" data.
//	4. _Never_ expose "private" data to user code (TODO: Drop _data, _removeData)
//	5. Avoid exposing implementation details on user objects (eg. expando properties)
//	6. Provide a clear path for implementation upgrade to WeakMap in 2014

var rbrace = /^(?:\{[\w\W]*\}|\[[\w\W]*\])$/,
	rmultiDash = /[A-Z]/g;

function getData( data ) {
	if ( data === "true" ) {
		return true;
	}

	if ( data === "false" ) {
		return false;
	}

	if ( data === "null" ) {
		return null;
	}

	// Only convert to a number if it doesn't change the string
	if ( data === +data + "" ) {
		return +data;
	}

	if ( rbrace.test( data ) ) {
		return JSON.parse( data );
	}

	return data;
}

function dataAttr( elem, key, data ) {
	var name;

	// If nothing was found internally, try to fetch any
	// data from the HTML5 data-* attribute
	if ( data === undefined && elem.nodeType === 1 ) {
		name = "data-" + key.replace( rmultiDash, "-$&" ).toLowerCase();
		data = elem.getAttribute( name );

		if ( typeof data === "string" ) {
			try {
				data = getData( data );
			} catch ( e ) {}

			// Make sure we set the data so it isn't changed later
			dataUser.set( elem, key, data );
		} else {
			data = undefined;
		}
	}
	return data;
}

jQuery.extend( {
	hasData: function( elem ) {
		return dataUser.hasData( elem ) || dataPriv.hasData( elem );
	},

	data: function( elem, name, data ) {
		return dataUser.access( elem, name, data );
	},

	removeData: function( elem, name ) {
		dataUser.remove( elem, name );
	},

	// TODO: Now that all calls to _data and _removeData have been replaced
	// with direct calls to dataPriv methods, these can be deprecated.
	_data: function( elem, name, data ) {
		return dataPriv.access( elem, name, data );
	},

	_removeData: function( elem, name ) {
		dataPriv.remove( elem, name );
	}
} );

jQuery.fn.extend( {
	data: function( key, value ) {
		var i, name, data,
			elem = this[ 0 ],
			attrs = elem && elem.attributes;

		// Gets all values
		if ( key === undefined ) {
			if ( this.length ) {
				data = dataUser.get( elem );

				if ( elem.nodeType === 1 && !dataPriv.get( elem, "hasDataAttrs" ) ) {
					i = attrs.length;
					while ( i-- ) {

						// Support: IE 11 only
						// The attrs elements can be null (#14894)
						if ( attrs[ i ] ) {
							name = attrs[ i ].name;
							if ( name.indexOf( "data-" ) === 0 ) {
								name = camelCase( name.slice( 5 ) );
								dataAttr( elem, name, data[ name ] );
							}
						}
					}
					dataPriv.set( elem, "hasDataAttrs", true );
				}
			}

			return data;
		}

		// Sets multiple values
		if ( typeof key === "object" ) {
			return this.each( function() {
				dataUser.set( this, key );
			} );
		}

		return access( this, function( value ) {
			var data;

			// The calling jQuery object (element matches) is not empty
			// (and therefore has an element appears at this[ 0 ]) and the
			// `value` parameter was not undefined. An empty jQuery object
			// will result in `undefined` for elem = this[ 0 ] which will
			// throw an exception if an attempt to read a data cache is made.
			if ( elem && value === undefined ) {

				// Attempt to get data from the cache
				// The key will always be camelCased in Data
				data = dataUser.get( elem, key );
				if ( data !== undefined ) {
					return data;
				}

				// Attempt to "discover" the data in
				// HTML5 custom data-* attrs
				data = dataAttr( elem, key );
				if ( data !== undefined ) {
					return data;
				}

				// We tried really hard, but the data doesn't exist.
				return;
			}

			// Set the data...
			this.each( function() {

				// We always store the camelCased key
				dataUser.set( this, key, value );
			} );
		}, null, value, arguments.length > 1, null, true );
	},

	removeData: function( key ) {
		return this.each( function() {
			dataUser.remove( this, key );
		} );
	}
} );


jQuery.extend( {
	queue: function( elem, type, data ) {
		var queue;

		if ( elem ) {
			type = ( type || "fx" ) + "queue";
			queue = dataPriv.get( elem, type );

			// Speed up dequeue by getting out quickly if this is just a lookup
			if ( data ) {
				if ( !queue || Array.isArray( data ) ) {
					queue = dataPriv.access( elem, type, jQuery.makeArray( data ) );
				} else {
					queue.push( data );
				}
			}
			return queue || [];
		}
	},

	dequeue: function( elem, type ) {
		type = type || "fx";

		var queue = jQuery.queue( elem, type ),
			startLength = queue.length,
			fn = queue.shift(),
			hooks = jQuery._queueHooks( elem, type ),
			next = function() {
				jQuery.dequeue( elem, type );
			};

		// If the fx queue is dequeued, always remove the progress sentinel
		if ( fn === "inprogress" ) {
			fn = queue.shift();
			startLength--;
		}

		if ( fn ) {

			// Add a progress sentinel to prevent the fx queue from being
			// automatically dequeued
			if ( type === "fx" ) {
				queue.unshift( "inprogress" );
			}

			// Clear up the last queue stop function
			delete hooks.stop;
			fn.call( elem, next, hooks );
		}

		if ( !startLength && hooks ) {
			hooks.empty.fire();
		}
	},

	// Not public - generate a queueHooks object, or return the current one
	_queueHooks: function( elem, type ) {
		var key = type + "queueHooks";
		return dataPriv.get( elem, key ) || dataPriv.access( elem, key, {
			empty: jQuery.Callbacks( "once memory" ).add( function() {
				dataPriv.remove( elem, [ type + "queue", key ] );
			} )
		} );
	}
} );

jQuery.fn.extend( {
	queue: function( type, data ) {
		var setter = 2;

		if ( typeof type !== "string" ) {
			data = type;
			type = "fx";
			setter--;
		}

		if ( arguments.length < setter ) {
			return jQuery.queue( this[ 0 ], type );
		}

		return data === undefined ?
			this :
			this.each( function() {
				var queue = jQuery.queue( this, type, data );

				// Ensure a hooks for this queue
				jQuery._queueHooks( this, type );

				if ( type === "fx" && queue[ 0 ] !== "inprogress" ) {
					jQuery.dequeue( this, type );
				}
			} );
	},
	dequeue: function( type ) {
		return this.each( function() {
			jQuery.dequeue( this, type );
		} );
	},
	clearQueue: function( type ) {
		return this.queue( type || "fx", [] );
	},

	// Get a promise resolved when queues of a certain type
	// are emptied (fx is the type by default)
	promise: function( type, obj ) {
		var tmp,
			count = 1,
			defer = jQuery.Deferred(),
			elements = this,
			i = this.length,
			resolve = function() {
				if ( !( --count ) ) {
					defer.resolveWith( elements, [ elements ] );
				}
			};

		if ( typeof type !== "string" ) {
			obj = type;
			type = undefined;
		}
		type = type || "fx";

		while ( i-- ) {
			tmp = dataPriv.get( elements[ i ], type + "queueHooks" );
			if ( tmp && tmp.empty ) {
				count++;
				tmp.empty.add( resolve );
			}
		}
		resolve();
		return defer.promise( obj );
	}
} );
var pnum = ( /[+-]?(?:\d*\.|)\d+(?:[eE][+-]?\d+|)/ ).source;

var rcssNum = new RegExp( "^(?:([+-])=|)(" + pnum + ")([a-z%]*)$", "i" );


var cssExpand = [ "Top", "Right", "Bottom", "Left" ];

var documentElement = document.documentElement;



	var isAttached = function( elem ) {
			return jQuery.contains( elem.ownerDocument, elem );
		},
		composed = { composed: true };

	// Support: IE 9 - 11+, Edge 12 - 18+, iOS 10.0 - 10.2 only
	// Check attachment across shadow DOM boundaries when possible (gh-3504)
	// Support: iOS 10.0-10.2 only
	// Early iOS 10 versions support `attachShadow` but not `getRootNode`,
	// leading to errors. We need to check for `getRootNode`.
	if ( documentElement.getRootNode ) {
		isAttached = function( elem ) {
			return jQuery.contains( elem.ownerDocument, elem ) ||
				elem.getRootNode( composed ) === elem.ownerDocument;
		};
	}
var isHiddenWithinTree = function( elem, el ) {

		// isHiddenWithinTree might be called from jQuery#filter function;
		// in that case, element will be second argument
		elem = el || elem;

		// Inline style trumps all
		return elem.style.display === "none" ||
			elem.style.display === "" &&

			// Otherwise, check computed style
			// Support: Firefox <=43 - 45
			// Disconnected elements can have computed display: none, so first confirm that elem is
			// in the document.
			isAttached( elem ) &&

			jQuery.css( elem, "display" ) === "none";
	};



function adjustCSS( elem, prop, valueParts, tween ) {
	var adjusted, scale,
		maxIterations = 20,
		currentValue = tween ?
			function() {
				return tween.cur();
			} :
			function() {
				return jQuery.css( elem, prop, "" );
			},
		initial = currentValue(),
		unit = valueParts && valueParts[ 3 ] || ( jQuery.cssNumber[ prop ] ? "" : "px" ),

		// Starting value computation is required for potential unit mismatches
		initialInUnit = elem.nodeType &&
			( jQuery.cssNumber[ prop ] || unit !== "px" && +initial ) &&
			rcssNum.exec( jQuery.css( elem, prop ) );

	if ( initialInUnit && initialInUnit[ 3 ] !== unit ) {

		// Support: Firefox <=54
		// Halve the iteration target value to prevent interference from CSS upper bounds (gh-2144)
		initial = initial / 2;

		// Trust units reported by jQuery.css
		unit = unit || initialInUnit[ 3 ];

		// Iteratively approximate from a nonzero starting point
		initialInUnit = +initial || 1;

		while ( maxIterations-- ) {

			// Evaluate and update our best guess (doubling guesses that zero out).
			// Finish if the scale equals or crosses 1 (making the old*new product non-positive).
			jQuery.style( elem, prop, initialInUnit + unit );
			if ( ( 1 - scale ) * ( 1 - ( scale = currentValue() / initial || 0.5 ) ) <= 0 ) {
				maxIterations = 0;
			}
			initialInUnit = initialInUnit / scale;

		}

		initialInUnit = initialInUnit * 2;
		jQuery.style( elem, prop, initialInUnit + unit );

		// Make sure we update the tween properties later on
		valueParts = valueParts || [];
	}

	if ( valueParts ) {
		initialInUnit = +initialInUnit || +initial || 0;

		// Apply relative offset (+=/-=) if specified
		adjusted = valueParts[ 1 ] ?
			initialInUnit + ( valueParts[ 1 ] + 1 ) * valueParts[ 2 ] :
			+valueParts[ 2 ];
		if ( tween ) {
			tween.unit = unit;
			tween.start = initialInUnit;
			tween.end = adjusted;
		}
	}
	return adjusted;
}


var defaultDisplayMap = {};

function getDefaultDisplay( elem ) {
	var temp,
		doc = elem.ownerDocument,
		nodeName = elem.nodeName,
		display = defaultDisplayMap[ nodeName ];

	if ( display ) {
		return display;
	}

	temp = doc.body.appendChild( doc.createElement( nodeName ) );
	display = jQuery.css( temp, "display" );

	temp.parentNode.removeChild( temp );

	if ( display === "none" ) {
		display = "block";
	}
	defaultDisplayMap[ nodeName ] = display;

	return display;
}

function showHide( elements, show ) {
	var display, elem,
		values = [],
		index = 0,
		length = elements.length;

	// Determine new display value for elements that need to change
	for ( ; index < length; index++ ) {
		elem = elements[ index ];
		if ( !elem.style ) {
			continue;
		}

		display = elem.style.display;
		if ( show ) {

			// Since we force visibility upon cascade-hidden elements, an immediate (and slow)
			// check is required in this first loop unless we have a nonempty display value (either
			// inline or about-to-be-restored)
			if ( display === "none" ) {
				values[ index ] = dataPriv.get( elem, "display" ) || null;
				if ( !values[ index ] ) {
					elem.style.display = "";
				}
			}
			if ( elem.style.display === "" && isHiddenWithinTree( elem ) ) {
				values[ index ] = getDefaultDisplay( elem );
			}
		} else {
			if ( display !== "none" ) {
				values[ index ] = "none";

				// Remember what we're overwriting
				dataPriv.set( elem, "display", display );
			}
		}
	}

	// Set the display of the elements in a second loop to avoid constant reflow
	for ( index = 0; index < length; index++ ) {
		if ( values[ index ] != null ) {
			elements[ index ].style.display = values[ index ];
		}
	}

	return elements;
}

jQuery.fn.extend( {
	show: function() {
		return showHide( this, true );
	},
	hide: function() {
		return showHide( this );
	},
	toggle: function( state ) {
		if ( typeof state === "boolean" ) {
			return state ? this.show() : this.hide();
		}

		return this.each( function() {
			if ( isHiddenWithinTree( this ) ) {
				jQuery( this ).show();
			} else {
				jQuery( this ).hide();
			}
		} );
	}
} );
var rcheckableType = ( /^(?:checkbox|radio)$/i );

var rtagName = ( /<([a-z][^\/\0>\x20\t\r\n\f]*)/i );

var rscriptType = ( /^$|^module$|\/(?:java|ecma)script/i );



( function() {
	var fragment = document.createDocumentFragment(),
		div = fragment.appendChild( document.createElement( "div" ) ),
		input = document.createElement( "input" );

	// Support: Android 4.0 - 4.3 only
	// Check state lost if the name is set (#11217)
	// Support: Windows Web Apps (WWA)
	// `name` and `type` must use .setAttribute for WWA (#14901)
	input.setAttribute( "type", "radio" );
	input.setAttribute( "checked", "checked" );
	input.setAttribute( "name", "t" );

	div.appendChild( input );

	// Support: Android <=4.1 only
	// Older WebKit doesn't clone checked state correctly in fragments
	support.checkClone = div.cloneNode( true ).cloneNode( true ).lastChild.checked;

	// Support: IE <=11 only
	// Make sure textarea (and checkbox) defaultValue is properly cloned
	div.innerHTML = "<textarea>x</textarea>";
	support.noCloneChecked = !!div.cloneNode( true ).lastChild.defaultValue;

	// Support: IE <=9 only
	// IE <=9 replaces <option> tags with their contents when inserted outside of
	// the select element.
	div.innerHTML = "<option></option>";
	support.option = !!div.lastChild;
} )();


// We have to close these tags to support XHTML (#13200)
var wrapMap = {

	// XHTML parsers do not magically insert elements in the
	// same way that tag soup parsers do. So we cannot shorten
	// this by omitting <tbody> or other required elements.
	thead: [ 1, "<table>", "</table>" ],
	col: [ 2, "<table><colgroup>", "</colgroup></table>" ],
	tr: [ 2, "<table><tbody>", "</tbody></table>" ],
	td: [ 3, "<table><tbody><tr>", "</tr></tbody></table>" ],

	_default: [ 0, "", "" ]
};

wrapMap.tbody = wrapMap.tfoot = wrapMap.colgroup = wrapMap.caption = wrapMap.thead;
wrapMap.th = wrapMap.td;

// Support: IE <=9 only
if ( !support.option ) {
	wrapMap.optgroup = wrapMap.option = [ 1, "<select multiple='multiple'>", "</select>" ];
}


function getAll( context, tag ) {

	// Support: IE <=9 - 11 only
	// Use typeof to avoid zero-argument method invocation on host objects (#15151)
	var ret;

	if ( typeof context.getElementsByTagName !== "undefined" ) {
		ret = context.getElementsByTagName( tag || "*" );

	} else if ( typeof context.querySelectorAll !== "undefined" ) {
		ret = context.querySelectorAll( tag || "*" );

	} else {
		ret = [];
	}

	if ( tag === undefined || tag && nodeName( context, tag ) ) {
		return jQuery.merge( [ context ], ret );
	}

	return ret;
}


// Mark scripts as having already been evaluated
function setGlobalEval( elems, refElements ) {
	var i = 0,
		l = elems.length;

	for ( ; i < l; i++ ) {
		dataPriv.set(
			elems[ i ],
			"globalEval",
			!refElements || dataPriv.get( refElements[ i ], "globalEval" )
		);
	}
}


var rhtml = /<|&#?\w+;/;

function buildFragment( elems, context, scripts, selection, ignored ) {
	var elem, tmp, tag, wrap, attached, j,
		fragment = context.createDocumentFragment(),
		nodes = [],
		i = 0,
		l = elems.length;

	for ( ; i < l; i++ ) {
		elem = elems[ i ];

		if ( elem || elem === 0 ) {

			// Add nodes directly
			if ( toType( elem ) === "object" ) {

				// Support: Android <=4.0 only, PhantomJS 1 only
				// push.apply(_, arraylike) throws on ancient WebKit
				jQuery.merge( nodes, elem.nodeType ? [ elem ] : elem );

			// Convert non-html into a text node
			} else if ( !rhtml.test( elem ) ) {
				nodes.push( context.createTextNode( elem ) );

			// Convert html into DOM nodes
			} else {
				tmp = tmp || fragment.appendChild( context.createElement( "div" ) );

				// Deserialize a standard representation
				tag = ( rtagName.exec( elem ) || [ "", "" ] )[ 1 ].toLowerCase();
				wrap = wrapMap[ tag ] || wrapMap._default;
				tmp.innerHTML = wrap[ 1 ] + jQuery.htmlPrefilter( elem ) + wrap[ 2 ];

				// Descend through wrappers to the right content
				j = wrap[ 0 ];
				while ( j-- ) {
					tmp = tmp.lastChild;
				}

				// Support: Android <=4.0 only, PhantomJS 1 only
				// push.apply(_, arraylike) throws on ancient WebKit
				jQuery.merge( nodes, tmp.childNodes );

				// Remember the top-level container
				tmp = fragment.firstChild;

				// Ensure the created nodes are orphaned (#12392)
				tmp.textContent = "";
			}
		}
	}

	// Remove wrapper from fragment
	fragment.textContent = "";

	i = 0;
	while ( ( elem = nodes[ i++ ] ) ) {

		// Skip elements already in the context collection (trac-4087)
		if ( selection && jQuery.inArray( elem, selection ) > -1 ) {
			if ( ignored ) {
				ignored.push( elem );
			}
			continue;
		}

		attached = isAttached( elem );

		// Append to fragment
		tmp = getAll( fragment.appendChild( elem ), "script" );

		// Preserve script evaluation history
		if ( attached ) {
			setGlobalEval( tmp );
		}

		// Capture executables
		if ( scripts ) {
			j = 0;
			while ( ( elem = tmp[ j++ ] ) ) {
				if ( rscriptType.test( elem.type || "" ) ) {
					scripts.push( elem );
				}
			}
		}
	}

	return fragment;
}


var
	rkeyEvent = /^key/,
	rmouseEvent = /^(?:mouse|pointer|contextmenu|drag|drop)|click/,
	rtypenamespace = /^([^.]*)(?:\.(.+)|)/;

function returnTrue() {
	return true;
}

function returnFalse() {
	return false;
}

// Support: IE <=9 - 11+
// focus() and blur() are asynchronous, except when they are no-op.
// So expect focus to be synchronous when the element is already active,
// and blur to be synchronous when the element is not already active.
// (focus and blur are always synchronous in other supported browsers,
// this just defines when we can count on it).
function expectSync( elem, type ) {
	return ( elem === safeActiveElement() ) === ( type === "focus" );
}

// Support: IE <=9 only
// Accessing document.activeElement can throw unexpectedly
// https://bugs.jquery.com/ticket/13393
function safeActiveElement() {
	try {
		return document.activeElement;
	} catch ( err ) { }
}

function on( elem, types, selector, data, fn, one ) {
	var origFn, type;

	// Types can be a map of types/handlers
	if ( typeof types === "object" ) {

		// ( types-Object, selector, data )
		if ( typeof selector !== "string" ) {

			// ( types-Object, data )
			data = data || selector;
			selector = undefined;
		}
		for ( type in types ) {
			on( elem, type, selector, data, types[ type ], one );
		}
		return elem;
	}

	if ( data == null && fn == null ) {

		// ( types, fn )
		fn = selector;
		data = selector = undefined;
	} else if ( fn == null ) {
		if ( typeof selector === "string" ) {

			// ( types, selector, fn )
			fn = data;
			data = undefined;
		} else {

			// ( types, data, fn )
			fn = data;
			data = selector;
			selector = undefined;
		}
	}
	if ( fn === false ) {
		fn = returnFalse;
	} else if ( !fn ) {
		return elem;
	}

	if ( one === 1 ) {
		origFn = fn;
		fn = function( event ) {

			// Can use an empty set, since event contains the info
			jQuery().off( event );
			return origFn.apply( this, arguments );
		};

		// Use same guid so caller can remove using origFn
		fn.guid = origFn.guid || ( origFn.guid = jQuery.guid++ );
	}
	return elem.each( function() {
		jQuery.event.add( this, types, fn, data, selector );
	} );
}

/*
 * Helper functions for managing events -- not part of the public interface.
 * Props to Dean Edwards' addEvent library for many of the ideas.
 */
jQuery.event = {

	global: {},

	add: function( elem, types, handler, data, selector ) {

		var handleObjIn, eventHandle, tmp,
			events, t, handleObj,
			special, handlers, type, namespaces, origType,
			elemData = dataPriv.get( elem );

		// Only attach events to objects that accept data
		if ( !acceptData( elem ) ) {
			return;
		}

		// Caller can pass in an object of custom data in lieu of the handler
		if ( handler.handler ) {
			handleObjIn = handler;
			handler = handleObjIn.handler;
			selector = handleObjIn.selector;
		}

		// Ensure that invalid selectors throw exceptions at attach time
		// Evaluate against documentElement in case elem is a non-element node (e.g., document)
		if ( selector ) {
			jQuery.find.matchesSelector( documentElement, selector );
		}

		// Make sure that the handler has a unique ID, used to find/remove it later
		if ( !handler.guid ) {
			handler.guid = jQuery.guid++;
		}

		// Init the element's event structure and main handler, if this is the first
		if ( !( events = elemData.events ) ) {
			events = elemData.events = Object.create( null );
		}
		if ( !( eventHandle = elemData.handle ) ) {
			eventHandle = elemData.handle = function( e ) {

				// Discard the second event of a jQuery.event.trigger() and
				// when an event is called after a page has unloaded
				return typeof jQuery !== "undefined" && jQuery.event.triggered !== e.type ?
					jQuery.event.dispatch.apply( elem, arguments ) : undefined;
			};
		}

		// Handle multiple events separated by a space
		types = ( types || "" ).match( rnothtmlwhite ) || [ "" ];
		t = types.length;
		while ( t-- ) {
			tmp = rtypenamespace.exec( types[ t ] ) || [];
			type = origType = tmp[ 1 ];
			namespaces = ( tmp[ 2 ] || "" ).split( "." ).sort();

			// There *must* be a type, no attaching namespace-only handlers
			if ( !type ) {
				continue;
			}

			// If event changes its type, use the special event handlers for the changed type
			special = jQuery.event.special[ type ] || {};

			// If selector defined, determine special event api type, otherwise given type
			type = ( selector ? special.delegateType : special.bindType ) || type;

			// Update special based on newly reset type
			special = jQuery.event.special[ type ] || {};

			// handleObj is passed to all event handlers
			handleObj = jQuery.extend( {
				type: type,
				origType: origType,
				data: data,
				handler: handler,
				guid: handler.guid,
				selector: selector,
				needsContext: selector && jQuery.expr.match.needsContext.test( selector ),
				namespace: namespaces.join( "." )
			}, handleObjIn );

			// Init the event handler queue if we're the first
			if ( !( handlers = events[ type ] ) ) {
				handlers = events[ type ] = [];
				handlers.delegateCount = 0;

				// Only use addEventListener if the special events handler returns false
				if ( !special.setup ||
					special.setup.call( elem, data, namespaces, eventHandle ) === false ) {

					if ( elem.addEventListener ) {
						elem.addEventListener( type, eventHandle );
					}
				}
			}

			if ( special.add ) {
				special.add.call( elem, handleObj );

				if ( !handleObj.handler.guid ) {
					handleObj.handler.guid = handler.guid;
				}
			}

			// Add to the element's handler list, delegates in front
			if ( selector ) {
				handlers.splice( handlers.delegateCount++, 0, handleObj );
			} else {
				handlers.push( handleObj );
			}

			// Keep track of which events have ever been used, for event optimization
			jQuery.event.global[ type ] = true;
		}

	},

	// Detach an event or set of events from an element
	remove: function( elem, types, handler, selector, mappedTypes ) {

		var j, origCount, tmp,
			events, t, handleObj,
			special, handlers, type, namespaces, origType,
			elemData = dataPriv.hasData( elem ) && dataPriv.get( elem );

		if ( !elemData || !( events = elemData.events ) ) {
			return;
		}

		// Once for each type.namespace in types; type may be omitted
		types = ( types || "" ).match( rnothtmlwhite ) || [ "" ];
		t = types.length;
		while ( t-- ) {
			tmp = rtypenamespace.exec( types[ t ] ) || [];
			type = origType = tmp[ 1 ];
			namespaces = ( tmp[ 2 ] || "" ).split( "." ).sort();

			// Unbind all events (on this namespace, if provided) for the element
			if ( !type ) {
				for ( type in events ) {
					jQuery.event.remove( elem, type + types[ t ], handler, selector, true );
				}
				continue;
			}

			special = jQuery.event.special[ type ] || {};
			type = ( selector ? special.delegateType : special.bindType ) || type;
			handlers = events[ type ] || [];
			tmp = tmp[ 2 ] &&
				new RegExp( "(^|\\.)" + namespaces.join( "\\.(?:.*\\.|)" ) + "(\\.|$)" );

			// Remove matching events
			origCount = j = handlers.length;
			while ( j-- ) {
				handleObj = handlers[ j ];

				if ( ( mappedTypes || origType === handleObj.origType ) &&
					( !handler || handler.guid === handleObj.guid ) &&
					( !tmp || tmp.test( handleObj.namespace ) ) &&
					( !selector || selector === handleObj.selector ||
						selector === "**" && handleObj.selector ) ) {
					handlers.splice( j, 1 );

					if ( handleObj.selector ) {
						handlers.delegateCount--;
					}
					if ( special.remove ) {
						special.remove.call( elem, handleObj );
					}
				}
			}

			// Remove generic event handler if we removed something and no more handlers exist
			// (avoids potential for endless recursion during removal of special event handlers)
			if ( origCount && !handlers.length ) {
				if ( !special.teardown ||
					special.teardown.call( elem, namespaces, elemData.handle ) === false ) {

					jQuery.removeEvent( elem, type, elemData.handle );
				}

				delete events[ type ];
			}
		}

		// Remove data and the expando if it's no longer used
		if ( jQuery.isEmptyObject( events ) ) {
			dataPriv.remove( elem, "handle events" );
		}
	},

	dispatch: function( nativeEvent ) {

		var i, j, ret, matched, handleObj, handlerQueue,
			args = new Array( arguments.length ),

			// Make a writable jQuery.Event from the native event object
			event = jQuery.event.fix( nativeEvent ),

			handlers = (
					dataPriv.get( this, "events" ) || Object.create( null )
				)[ event.type ] || [],
			special = jQuery.event.special[ event.type ] || {};

		// Use the fix-ed jQuery.Event rather than the (read-only) native event
		args[ 0 ] = event;

		for ( i = 1; i < arguments.length; i++ ) {
			args[ i ] = arguments[ i ];
		}

		event.delegateTarget = this;

		// Call the preDispatch hook for the mapped type, and let it bail if desired
		if ( special.preDispatch && special.preDispatch.call( this, event ) === false ) {
			return;
		}

		// Determine handlers
		handlerQueue = jQuery.event.handlers.call( this, event, handlers );

		// Run delegates first; they may want to stop propagation beneath us
		i = 0;
		while ( ( matched = handlerQueue[ i++ ] ) && !event.isPropagationStopped() ) {
			event.currentTarget = matched.elem;

			j = 0;
			while ( ( handleObj = matched.handlers[ j++ ] ) &&
				!event.isImmediatePropagationStopped() ) {

				// If the event is namespaced, then each handler is only invoked if it is
				// specially universal or its namespaces are a superset of the event's.
				if ( !event.rnamespace || handleObj.namespace === false ||
					event.rnamespace.test( handleObj.namespace ) ) {

					event.handleObj = handleObj;
					event.data = handleObj.data;

					ret = ( ( jQuery.event.special[ handleObj.origType ] || {} ).handle ||
						handleObj.handler ).apply( matched.elem, args );

					if ( ret !== undefined ) {
						if ( ( event.result = ret ) === false ) {
							event.preventDefault();
							event.stopPropagation();
						}
					}
				}
			}
		}

		// Call the postDispatch hook for the mapped type
		if ( special.postDispatch ) {
			special.postDispatch.call( this, event );
		}

		return event.result;
	},

	handlers: function( event, handlers ) {
		var i, handleObj, sel, matchedHandlers, matchedSelectors,
			handlerQueue = [],
			delegateCount = handlers.delegateCount,
			cur = event.target;

		// Find delegate handlers
		if ( delegateCount &&

			// Support: IE <=9
			// Black-hole SVG <use> instance trees (trac-13180)
			cur.nodeType &&

			// Support: Firefox <=42
			// Suppress spec-violating clicks indicating a non-primary pointer button (trac-3861)
			// https://www.w3.org/TR/DOM-Level-3-Events/#event-type-click
			// Support: IE 11 only
			// ...but not arrow key "clicks" of radio inputs, which can have `button` -1 (gh-2343)
			!( event.type === "click" && event.button >= 1 ) ) {

			for ( ; cur !== this; cur = cur.parentNode || this ) {

				// Don't check non-elements (#13208)
				// Don't process clicks on disabled elements (#6911, #8165, #11382, #11764)
				if ( cur.nodeType === 1 && !( event.type === "click" && cur.disabled === true ) ) {
					matchedHandlers = [];
					matchedSelectors = {};
					for ( i = 0; i < delegateCount; i++ ) {
						handleObj = handlers[ i ];

						// Don't conflict with Object.prototype properties (#13203)
						sel = handleObj.selector + " ";

						if ( matchedSelectors[ sel ] === undefined ) {
							matchedSelectors[ sel ] = handleObj.needsContext ?
								jQuery( sel, this ).index( cur ) > -1 :
								jQuery.find( sel, this, null, [ cur ] ).length;
						}
						if ( matchedSelectors[ sel ] ) {
							matchedHandlers.push( handleObj );
						}
					}
					if ( matchedHandlers.length ) {
						handlerQueue.push( { elem: cur, handlers: matchedHandlers } );
					}
				}
			}
		}

		// Add the remaining (directly-bound) handlers
		cur = this;
		if ( delegateCount < handlers.length ) {
			handlerQueue.push( { elem: cur, handlers: handlers.slice( delegateCount ) } );
		}

		return handlerQueue;
	},

	addProp: function( name, hook ) {
		Object.defineProperty( jQuery.Event.prototype, name, {
			enumerable: true,
			configurable: true,

			get: isFunction( hook ) ?
				function() {
					if ( this.originalEvent ) {
							return hook( this.originalEvent );
					}
				} :
				function() {
					if ( this.originalEvent ) {
							return this.originalEvent[ name ];
					}
				},

			set: function( value ) {
				Object.defineProperty( this, name, {
					enumerable: true,
					configurable: true,
					writable: true,
					value: value
				} );
			}
		} );
	},

	fix: function( originalEvent ) {
		return originalEvent[ jQuery.expando ] ?
			originalEvent :
			new jQuery.Event( originalEvent );
	},

	special: {
		load: {

			// Prevent triggered image.load events from bubbling to window.load
			noBubble: true
		},
		click: {

			// Utilize native event to ensure correct state for checkable inputs
			setup: function( data ) {

				// For mutual compressibility with _default, replace `this` access with a local var.
				// `|| data` is dead code meant only to preserve the variable through minification.
				var el = this || data;

				// Claim the first handler
				if ( rcheckableType.test( el.type ) &&
					el.click && nodeName( el, "input" ) ) {

					// dataPriv.set( el, "click", ... )
					leverageNative( el, "click", returnTrue );
				}

				// Return false to allow normal processing in the caller
				return false;
			},
			trigger: function( data ) {

				// For mutual compressibility with _default, replace `this` access with a local var.
				// `|| data` is dead code meant only to preserve the variable through minification.
				var el = this || data;

				// Force setup before triggering a click
				if ( rcheckableType.test( el.type ) &&
					el.click && nodeName( el, "input" ) ) {

					leverageNative( el, "click" );
				}

				// Return non-false to allow normal event-path propagation
				return true;
			},

			// For cross-browser consistency, suppress native .click() on links
			// Also prevent it if we're currently inside a leveraged native-event stack
			_default: function( event ) {
				var target = event.target;
				return rcheckableType.test( target.type ) &&
					target.click && nodeName( target, "input" ) &&
					dataPriv.get( target, "click" ) ||
					nodeName( target, "a" );
			}
		},

		beforeunload: {
			postDispatch: function( event ) {

				// Support: Firefox 20+
				// Firefox doesn't alert if the returnValue field is not set.
				if ( event.result !== undefined && event.originalEvent ) {
					event.originalEvent.returnValue = event.result;
				}
			}
		}
	}
};

// Ensure the presence of an event listener that handles manually-triggered
// synthetic events by interrupting progress until reinvoked in response to
// *native* events that it fires directly, ensuring that state changes have
// already occurred before other listeners are invoked.
function leverageNative( el, type, expectSync ) {

	// Missing expectSync indicates a trigger call, which must force setup through jQuery.event.add
	if ( !expectSync ) {
		if ( dataPriv.get( el, type ) === undefined ) {
			jQuery.event.add( el, type, returnTrue );
		}
		return;
	}

	// Register the controller as a special universal handler for all event namespaces
	dataPriv.set( el, type, false );
	jQuery.event.add( el, type, {
		namespace: false,
		handler: function( event ) {
			var notAsync, result,
				saved = dataPriv.get( this, type );

			if ( ( event.isTrigger & 1 ) && this[ type ] ) {

				// Interrupt processing of the outer synthetic .trigger()ed event
				// Saved data should be false in such cases, but might be a leftover capture object
				// from an async native handler (gh-4350)
				if ( !saved.length ) {

					// Store arguments for use when handling the inner native event
					// There will always be at least one argument (an event object), so this array
					// will not be confused with a leftover capture object.
					saved = slice.call( arguments );
					dataPriv.set( this, type, saved );

					// Trigger the native event and capture its result
					// Support: IE <=9 - 11+
					// focus() and blur() are asynchronous
					notAsync = expectSync( this, type );
					this[ type ]();
					result = dataPriv.get( this, type );
					if ( saved !== result || notAsync ) {
						dataPriv.set( this, type, false );
					} else {
						result = {};
					}
					if ( saved !== result ) {

						// Cancel the outer synthetic event
						event.stopImmediatePropagation();
						event.preventDefault();
						return result.value;
					}

				// If this is an inner synthetic event for an event with a bubbling surrogate
				// (focus or blur), assume that the surrogate already propagated from triggering the
				// native event and prevent that from happening again here.
				// This technically gets the ordering wrong w.r.t. to `.trigger()` (in which the
				// bubbling surrogate propagates *after* the non-bubbling base), but that seems
				// less bad than duplication.
				} else if ( ( jQuery.event.special[ type ] || {} ).delegateType ) {
					event.stopPropagation();
				}

			// If this is a native event triggered above, everything is now in order
			// Fire an inner synthetic event with the original arguments
			} else if ( saved.length ) {

				// ...and capture the result
				dataPriv.set( this, type, {
					value: jQuery.event.trigger(

						// Support: IE <=9 - 11+
						// Extend with the prototype to reset the above stopImmediatePropagation()
						jQuery.extend( saved[ 0 ], jQuery.Event.prototype ),
						saved.slice( 1 ),
						this
					)
				} );

				// Abort handling of the native event
				event.stopImmediatePropagation();
			}
		}
	} );
}

jQuery.removeEvent = function( elem, type, handle ) {

	// This "if" is needed for plain objects
	if ( elem.removeEventListener ) {
		elem.removeEventListener( type, handle );
	}
};

jQuery.Event = function( src, props ) {

	// Allow instantiation without the 'new' keyword
	if ( !( this instanceof jQuery.Event ) ) {
		return new jQuery.Event( src, props );
	}

	// Event object
	if ( src && src.type ) {
		this.originalEvent = src;
		this.type = src.type;

		// Events bubbling up the document may have been marked as prevented
		// by a handler lower down the tree; reflect the correct value.
		this.isDefaultPrevented = src.defaultPrevented ||
				src.defaultPrevented === undefined &&

				// Support: Android <=2.3 only
				src.returnValue === false ?
			returnTrue :
			returnFalse;

		// Create target properties
		// Support: Safari <=6 - 7 only
		// Target should not be a text node (#504, #13143)
		this.target = ( src.target && src.target.nodeType === 3 ) ?
			src.target.parentNode :
			src.target;

		this.currentTarget = src.currentTarget;
		this.relatedTarget = src.relatedTarget;

	// Event type
	} else {
		this.type = src;
	}

	// Put explicitly provided properties onto the event object
	if ( props ) {
		jQuery.extend( this, props );
	}

	// Create a timestamp if incoming event doesn't have one
	this.timeStamp = src && src.timeStamp || Date.now();

	// Mark it as fixed
	this[ jQuery.expando ] = true;
};

// jQuery.Event is based on DOM3 Events as specified by the ECMAScript Language Binding
// https://www.w3.org/TR/2003/WD-DOM-Level-3-Events-20030331/ecma-script-binding.html
jQuery.Event.prototype = {
	constructor: jQuery.Event,
	isDefaultPrevented: returnFalse,
	isPropagationStopped: returnFalse,
	isImmediatePropagationStopped: returnFalse,
	isSimulated: false,

	preventDefault: function() {
		var e = this.originalEvent;

		this.isDefaultPrevented = returnTrue;

		if ( e && !this.isSimulated ) {
			e.preventDefault();
		}
	},
	stopPropagation: function() {
		var e = this.originalEvent;

		this.isPropagationStopped = returnTrue;

		if ( e && !this.isSimulated ) {
			e.stopPropagation();
		}
	},
	stopImmediatePropagation: function() {
		var e = this.originalEvent;

		this.isImmediatePropagationStopped = returnTrue;

		if ( e && !this.isSimulated ) {
			e.stopImmediatePropagation();
		}

		this.stopPropagation();
	}
};

// Includes all common event props including KeyEvent and MouseEvent specific props
jQuery.each( {
	altKey: true,
	bubbles: true,
	cancelable: true,
	changedTouches: true,
	ctrlKey: true,
	detail: true,
	eventPhase: true,
	metaKey: true,
	pageX: true,
	pageY: true,
	shiftKey: true,
	view: true,
	"char": true,
	code: true,
	charCode: true,
	key: true,
	keyCode: true,
	button: true,
	buttons: true,
	clientX: true,
	clientY: true,
	offsetX: true,
	offsetY: true,
	pointerId: true,
	pointerType: true,
	screenX: true,
	screenY: true,
	targetTouches: true,
	toElement: true,
	touches: true,

	which: function( event ) {
		var button = event.button;

		// Add which for key events
		if ( event.which == null && rkeyEvent.test( event.type ) ) {
			return event.charCode != null ? event.charCode : event.keyCode;
		}

		// Add which for click: 1 === left; 2 === middle; 3 === right
		if ( !event.which && button !== undefined && rmouseEvent.test( event.type ) ) {
			if ( button & 1 ) {
				return 1;
			}

			if ( button & 2 ) {
				return 3;
			}

			if ( button & 4 ) {
				return 2;
			}

			return 0;
		}

		return event.which;
	}
}, jQuery.event.addProp );

jQuery.each( { focus: "focusin", blur: "focusout" }, function( type, delegateType ) {
	jQuery.event.special[ type ] = {

		// Utilize native event if possible so blur/focus sequence is correct
		setup: function() {

			// Claim the first handler
			// dataPriv.set( this, "focus", ... )
			// dataPriv.set( this, "blur", ... )
			leverageNative( this, type, expectSync );

			// Return false to allow normal processing in the caller
			return false;
		},
		trigger: function() {

			// Force setup before trigger
			leverageNative( this, type );

			// Return non-false to allow normal event-path propagation
			return true;
		},

		delegateType: delegateType
	};
} );

// Create mouseenter/leave events using mouseover/out and event-time checks
// so that event delegation works in jQuery.
// Do the same for pointerenter/pointerleave and pointerover/pointerout
//
// Support: Safari 7 only
// Safari sends mouseenter too often; see:
// https://bugs.chromium.org/p/chromium/issues/detail?id=470258
// for the description of the bug (it existed in older Chrome versions as well).
jQuery.each( {
	mouseenter: "mouseover",
	mouseleave: "mouseout",
	pointerenter: "pointerover",
	pointerleave: "pointerout"
}, function( orig, fix ) {
	jQuery.event.special[ orig ] = {
		delegateType: fix,
		bindType: fix,

		handle: function( event ) {
			var ret,
				target = this,
				related = event.relatedTarget,
				handleObj = event.handleObj;

			// For mouseenter/leave call the handler if related is outside the target.
			// NB: No relatedTarget if the mouse left/entered the browser window
			if ( !related || ( related !== target && !jQuery.contains( target, related ) ) ) {
				event.type = handleObj.origType;
				ret = handleObj.handler.apply( this, arguments );
				event.type = fix;
			}
			return ret;
		}
	};
} );

jQuery.fn.extend( {

	on: function( types, selector, data, fn ) {
		return on( this, types, selector, data, fn );
	},
	one: function( types, selector, data, fn ) {
		return on( this, types, selector, data, fn, 1 );
	},
	off: function( types, selector, fn ) {
		var handleObj, type;
		if ( types && types.preventDefault && types.handleObj ) {

			// ( event )  dispatched jQuery.Event
			handleObj = types.handleObj;
			jQuery( types.delegateTarget ).off(
				handleObj.namespace ?
					handleObj.origType + "." + handleObj.namespace :
					handleObj.origType,
				handleObj.selector,
				handleObj.handler
			);
			return this;
		}
		if ( typeof types === "object" ) {

			// ( types-object [, selector] )
			for ( type in types ) {
				this.off( type, selector, types[ type ] );
			}
			return this;
		}
		if ( selector === false || typeof selector === "function" ) {

			// ( types [, fn] )
			fn = selector;
			selector = undefined;
		}
		if ( fn === false ) {
			fn = returnFalse;
		}
		return this.each( function() {
			jQuery.event.remove( this, types, fn, selector );
		} );
	}
} );


var

	// Support: IE <=10 - 11, Edge 12 - 13 only
	// In IE/Edge using regex groups here causes severe slowdowns.
	// See https://connect.microsoft.com/IE/feedback/details/1736512/
	rnoInnerhtml = /<script|<style|<link/i,

	// checked="checked" or checked
	rchecked = /checked\s*(?:[^=]|=\s*.checked.)/i,
	rcleanScript = /^\s*<!(?:\[CDATA\[|--)|(?:\]\]|--)>\s*$/g;

// Prefer a tbody over its parent table for containing new rows
function manipulationTarget( elem, content ) {
	if ( nodeName( elem, "table" ) &&
		nodeName( content.nodeType !== 11 ? content : content.firstChild, "tr" ) ) {

		return jQuery( elem ).children( "tbody" )[ 0 ] || elem;
	}

	return elem;
}

// Replace/restore the type attribute of script elements for safe DOM manipulation
function disableScript( elem ) {
	elem.type = ( elem.getAttribute( "type" ) !== null ) + "/" + elem.type;
	return elem;
}
function restoreScript( elem ) {
	if ( ( elem.type || "" ).slice( 0, 5 ) === "true/" ) {
		elem.type = elem.type.slice( 5 );
	} else {
		elem.removeAttribute( "type" );
	}

	return elem;
}

function cloneCopyEvent( src, dest ) {
	var i, l, type, pdataOld, udataOld, udataCur, events;

	if ( dest.nodeType !== 1 ) {
		return;
	}

	// 1. Copy private data: events, handlers, etc.
	if ( dataPriv.hasData( src ) ) {
		pdataOld = dataPriv.get( src );
		events = pdataOld.events;

		if ( events ) {
			dataPriv.remove( dest, "handle events" );

			for ( type in events ) {
				for ( i = 0, l = events[ type ].length; i < l; i++ ) {
					jQuery.event.add( dest, type, events[ type ][ i ] );
				}
			}
		}
	}

	// 2. Copy user data
	if ( dataUser.hasData( src ) ) {
		udataOld = dataUser.access( src );
		udataCur = jQuery.extend( {}, udataOld );

		dataUser.set( dest, udataCur );
	}
}

// Fix IE bugs, see support tests
function fixInput( src, dest ) {
	var nodeName = dest.nodeName.toLowerCase();

	// Fails to persist the checked state of a cloned checkbox or radio button.
	if ( nodeName === "input" && rcheckableType.test( src.type ) ) {
		dest.checked = src.checked;

	// Fails to return the selected option to the default selected state when cloning options
	} else if ( nodeName === "input" || nodeName === "textarea" ) {
		dest.defaultValue = src.defaultValue;
	}
}

function domManip( collection, args, callback, ignored ) {

	// Flatten any nested arrays
	args = flat( args );

	var fragment, first, scripts, hasScripts, node, doc,
		i = 0,
		l = collection.length,
		iNoClone = l - 1,
		value = args[ 0 ],
		valueIsFunction = isFunction( value );

	// We can't cloneNode fragments that contain checked, in WebKit
	if ( valueIsFunction ||
			( l > 1 && typeof value === "string" &&
				!support.checkClone && rchecked.test( value ) ) ) {
		return collection.each( function( index ) {
			var self = collection.eq( index );
			if ( valueIsFunction ) {
				args[ 0 ] = value.call( this, index, self.html() );
			}
			domManip( self, args, callback, ignored );
		} );
	}

	if ( l ) {
		fragment = buildFragment( args, collection[ 0 ].ownerDocument, false, collection, ignored );
		first = fragment.firstChild;

		if ( fragment.childNodes.length === 1 ) {
			fragment = first;
		}

		// Require either new content or an interest in ignored elements to invoke the callback
		if ( first || ignored ) {
			scripts = jQuery.map( getAll( fragment, "script" ), disableScript );
			hasScripts = scripts.length;

			// Use the original fragment for the last item
			// instead of the first because it can end up
			// being emptied incorrectly in certain situations (#8070).
			for ( ; i < l; i++ ) {
				node = fragment;

				if ( i !== iNoClone ) {
					node = jQuery.clone( node, true, true );

					// Keep references to cloned scripts for later restoration
					if ( hasScripts ) {

						// Support: Android <=4.0 only, PhantomJS 1 only
						// push.apply(_, arraylike) throws on ancient WebKit
						jQuery.merge( scripts, getAll( node, "script" ) );
					}
				}

				callback.call( collection[ i ], node, i );
			}

			if ( hasScripts ) {
				doc = scripts[ scripts.length - 1 ].ownerDocument;

				// Reenable scripts
				jQuery.map( scripts, restoreScript );

				// Evaluate executable scripts on first document insertion
				for ( i = 0; i < hasScripts; i++ ) {
					node = scripts[ i ];
					if ( rscriptType.test( node.type || "" ) &&
						!dataPriv.access( node, "globalEval" ) &&
						jQuery.contains( doc, node ) ) {

						if ( node.src && ( node.type || "" ).toLowerCase()  !== "module" ) {

							// Optional AJAX dependency, but won't run scripts if not present
							if ( jQuery._evalUrl && !node.noModule ) {
								jQuery._evalUrl( node.src, {
									nonce: node.nonce || node.getAttribute( "nonce" )
								}, doc );
							}
						} else {
							DOMEval( node.textContent.replace( rcleanScript, "" ), node, doc );
						}
					}
				}
			}
		}
	}

	return collection;
}

function remove( elem, selector, keepData ) {
	var node,
		nodes = selector ? jQuery.filter( selector, elem ) : elem,
		i = 0;

	for ( ; ( node = nodes[ i ] ) != null; i++ ) {
		if ( !keepData && node.nodeType === 1 ) {
			jQuery.cleanData( getAll( node ) );
		}

		if ( node.parentNode ) {
			if ( keepData && isAttached( node ) ) {
				setGlobalEval( getAll( node, "script" ) );
			}
			node.parentNode.removeChild( node );
		}
	}

	return elem;
}

jQuery.extend( {
	htmlPrefilter: function( html ) {
		return html;
	},

	clone: function( elem, dataAndEvents, deepDataAndEvents ) {
		var i, l, srcElements, destElements,
			clone = elem.cloneNode( true ),
			inPage = isAttached( elem );

		// Fix IE cloning issues
		if ( !support.noCloneChecked && ( elem.nodeType === 1 || elem.nodeType === 11 ) &&
				!jQuery.isXMLDoc( elem ) ) {

			// We eschew Sizzle here for performance reasons: https://jsperf.com/getall-vs-sizzle/2
			destElements = getAll( clone );
			srcElements = getAll( elem );

			for ( i = 0, l = srcElements.length; i < l; i++ ) {
				fixInput( srcElements[ i ], destElements[ i ] );
			}
		}

		// Copy the events from the original to the clone
		if ( dataAndEvents ) {
			if ( deepDataAndEvents ) {
				srcElements = srcElements || getAll( elem );
				destElements = destElements || getAll( clone );

				for ( i = 0, l = srcElements.length; i < l; i++ ) {
					cloneCopyEvent( srcElements[ i ], destElements[ i ] );
				}
			} else {
				cloneCopyEvent( elem, clone );
			}
		}

		// Preserve script evaluation history
		destElements = getAll( clone, "script" );
		if ( destElements.length > 0 ) {
			setGlobalEval( destElements, !inPage && getAll( elem, "script" ) );
		}

		// Return the cloned set
		return clone;
	},

	cleanData: function( elems ) {
		var data, elem, type,
			special = jQuery.event.special,
			i = 0;

		for ( ; ( elem = elems[ i ] ) !== undefined; i++ ) {
			if ( acceptData( elem ) ) {
				if ( ( data = elem[ dataPriv.expando ] ) ) {
					if ( data.events ) {
						for ( type in data.events ) {
							if ( special[ type ] ) {
								jQuery.event.remove( elem, type );

							// This is a shortcut to avoid jQuery.event.remove's overhead
							} else {
								jQuery.removeEvent( elem, type, data.handle );
							}
						}
					}

					// Support: Chrome <=35 - 45+
					// Assign undefined instead of using delete, see Data#remove
					elem[ dataPriv.expando ] = undefined;
				}
				if ( elem[ dataUser.expando ] ) {

					// Support: Chrome <=35 - 45+
					// Assign undefined instead of using delete, see Data#remove
					elem[ dataUser.expando ] = undefined;
				}
			}
		}
	}
} );

jQuery.fn.extend( {
	detach: function( selector ) {
		return remove( this, selector, true );
	},

	remove: function( selector ) {
		return remove( this, selector );
	},

	text: function( value ) {
		return access( this, function( value ) {
			return value === undefined ?
				jQuery.text( this ) :
				this.empty().each( function() {
					if ( this.nodeType === 1 || this.nodeType === 11 || this.nodeType === 9 ) {
						this.textContent = value;
					}
				} );
		}, null, value, arguments.length );
	},

	append: function() {
		return domManip( this, arguments, function( elem ) {
			if ( this.nodeType === 1 || this.nodeType === 11 || this.nodeType === 9 ) {
				var target = manipulationTarget( this, elem );
				target.appendChild( elem );
			}
		} );
	},

	prepend: function() {
		return domManip( this, arguments, function( elem ) {
			if ( this.nodeType === 1 || this.nodeType === 11 || this.nodeType === 9 ) {
				var target = manipulationTarget( this, elem );
				target.insertBefore( elem, target.firstChild );
			}
		} );
	},

	before: function() {
		return domManip( this, arguments, function( elem ) {
			if ( this.parentNode ) {
				this.parentNode.insertBefore( elem, this );
			}
		} );
	},

	after: function() {
		return domManip( this, arguments, function( elem ) {
			if ( this.parentNode ) {
				this.parentNode.insertBefore( elem, this.nextSibling );
			}
		} );
	},

	empty: function() {
		var elem,
			i = 0;

		for ( ; ( elem = this[ i ] ) != null; i++ ) {
			if ( elem.nodeType === 1 ) {

				// Prevent memory leaks
				jQuery.cleanData( getAll( elem, false ) );

				// Remove any remaining nodes
				elem.textContent = "";
			}
		}

		return this;
	},

	clone: function( dataAndEvents, deepDataAndEvents ) {
		dataAndEvents = dataAndEvents == null ? false : dataAndEvents;
		deepDataAndEvents = deepDataAndEvents == null ? dataAndEvents : deepDataAndEvents;

		return this.map( function() {
			return jQuery.clone( this, dataAndEvents, deepDataAndEvents );
		} );
	},

	html: function( value ) {
		return access( this, function( value ) {
			var elem = this[ 0 ] || {},
				i = 0,
				l = this.length;

			if ( value === undefined && elem.nodeType === 1 ) {
				return elem.innerHTML;
			}

			// See if we can take a shortcut and just use innerHTML
			if ( typeof value === "string" && !rnoInnerhtml.test( value ) &&
				!wrapMap[ ( rtagName.exec( value ) || [ "", "" ] )[ 1 ].toLowerCase() ] ) {

				value = jQuery.htmlPrefilter( value );

				try {
					for ( ; i < l; i++ ) {
						elem = this[ i ] || {};

						// Remove element nodes and prevent memory leaks
						if ( elem.nodeType === 1 ) {
							jQuery.cleanData( getAll( elem, false ) );
							elem.innerHTML = value;
						}
					}

					elem = 0;

				// If using innerHTML throws an exception, use the fallback method
				} catch ( e ) {}
			}

			if ( elem ) {
				this.empty().append( value );
			}
		}, null, value, arguments.length );
	},

	replaceWith: function() {
		var ignored = [];

		// Make the changes, replacing each non-ignored context element with the new content
		return domManip( this, arguments, function( elem ) {
			var parent = this.parentNode;

			if ( jQuery.inArray( this, ignored ) < 0 ) {
				jQuery.cleanData( getAll( this ) );
				if ( parent ) {
					parent.replaceChild( elem, this );
				}
			}

		// Force callback invocation
		}, ignored );
	}
} );

jQuery.each( {
	appendTo: "append",
	prependTo: "prepend",
	insertBefore: "before",
	insertAfter: "after",
	replaceAll: "replaceWith"
}, function( name, original ) {
	jQuery.fn[ name ] = function( selector ) {
		var elems,
			ret = [],
			insert = jQuery( selector ),
			last = insert.length - 1,
			i = 0;

		for ( ; i <= last; i++ ) {
			elems = i === last ? this : this.clone( true );
			jQuery( insert[ i ] )[ original ]( elems );

			// Support: Android <=4.0 only, PhantomJS 1 only
			// .get() because push.apply(_, arraylike) throws on ancient WebKit
			push.apply( ret, elems.get() );
		}

		return this.pushStack( ret );
	};
} );
var rnumnonpx = new RegExp( "^(" + pnum + ")(?!px)[a-z%]+$", "i" );

var getStyles = function( elem ) {

		// Support: IE <=11 only, Firefox <=30 (#15098, #14150)
		// IE throws on elements created in popups
		// FF meanwhile throws on frame elements through "defaultView.getComputedStyle"
		var view = elem.ownerDocument.defaultView;

		if ( !view || !view.opener ) {
			view = window;
		}

		return view.getComputedStyle( elem );
	};

var swap = function( elem, options, callback ) {
	var ret, name,
		old = {};

	// Remember the old values, and insert the new ones
	for ( name in options ) {
		old[ name ] = elem.style[ name ];
		elem.style[ name ] = options[ name ];
	}

	ret = callback.call( elem );

	// Revert the old values
	for ( name in options ) {
		elem.style[ name ] = old[ name ];
	}

	return ret;
};


var rboxStyle = new RegExp( cssExpand.join( "|" ), "i" );



( function() {

	// Executing both pixelPosition & boxSizingReliable tests require only one layout
	// so they're executed at the same time to save the second computation.
	function computeStyleTests() {

		// This is a singleton, we need to execute it only once
		if ( !div ) {
			return;
		}

		container.style.cssText = "position:absolute;left:-11111px;width:60px;" +
			"margin-top:1px;padding:0;border:0";
		div.style.cssText =
			"position:relative;display:block;box-sizing:border-box;overflow:scroll;" +
			"margin:auto;border:1px;padding:1px;" +
			"width:60%;top:1%";
		documentElement.appendChild( container ).appendChild( div );

		var divStyle = window.getComputedStyle( div );
		pixelPositionVal = divStyle.top !== "1%";

		// Support: Android 4.0 - 4.3 only, Firefox <=3 - 44
		reliableMarginLeftVal = roundPixelMeasures( divStyle.marginLeft ) === 12;

		// Support: Android 4.0 - 4.3 only, Safari <=9.1 - 10.1, iOS <=7.0 - 9.3
		// Some styles come back with percentage values, even though they shouldn't
		div.style.right = "60%";
		pixelBoxStylesVal = roundPixelMeasures( divStyle.right ) === 36;

		// Support: IE 9 - 11 only
		// Detect misreporting of content dimensions for box-sizing:border-box elements
		boxSizingReliableVal = roundPixelMeasures( divStyle.width ) === 36;

		// Support: IE 9 only
		// Detect overflow:scroll screwiness (gh-3699)
		// Support: Chrome <=64
		// Don't get tricked when zoom affects offsetWidth (gh-4029)
		div.style.position = "absolute";
		scrollboxSizeVal = roundPixelMeasures( div.offsetWidth / 3 ) === 12;

		documentElement.removeChild( container );

		// Nullify the div so it wouldn't be stored in the memory and
		// it will also be a sign that checks already performed
		div = null;
	}

	function roundPixelMeasures( measure ) {
		return Math.round( parseFloat( measure ) );
	}

	var pixelPositionVal, boxSizingReliableVal, scrollboxSizeVal, pixelBoxStylesVal,
		reliableTrDimensionsVal, reliableMarginLeftVal,
		container = document.createElement( "div" ),
		div = document.createElement( "div" );

	// Finish early in limited (non-browser) environments
	if ( !div.style ) {
		return;
	}

	// Support: IE <=9 - 11 only
	// Style of cloned element affects source element cloned (#8908)
	div.style.backgroundClip = "content-box";
	div.cloneNode( true ).style.backgroundClip = "";
	support.clearCloneStyle = div.style.backgroundClip === "content-box";

	jQuery.extend( support, {
		boxSizingReliable: function() {
			computeStyleTests();
			return boxSizingReliableVal;
		},
		pixelBoxStyles: function() {
			computeStyleTests();
			return pixelBoxStylesVal;
		},
		pixelPosition: function() {
			computeStyleTests();
			return pixelPositionVal;
		},
		reliableMarginLeft: function() {
			computeStyleTests();
			return reliableMarginLeftVal;
		},
		scrollboxSize: function() {
			computeStyleTests();
			return scrollboxSizeVal;
		},

		// Support: IE 9 - 11+, Edge 15 - 18+
		// IE/Edge misreport `getComputedStyle` of table rows with width/height
		// set in CSS while `offset*` properties report correct values.
		// Behavior in IE 9 is more subtle than in newer versions & it passes
		// some versions of this test; make sure not to make it pass there!
		reliableTrDimensions: function() {
			var table, tr, trChild, trStyle;
			if ( reliableTrDimensionsVal == null ) {
				table = document.createElement( "table" );
				tr = document.createElement( "tr" );
				trChild = document.createElement( "div" );

				table.style.cssText = "position:absolute;left:-11111px";
				tr.style.height = "1px";
				trChild.style.height = "9px";

				documentElement
					.appendChild( table )
					.appendChild( tr )
					.appendChild( trChild );

				trStyle = window.getComputedStyle( tr );
				reliableTrDimensionsVal = parseInt( trStyle.height ) > 3;

				documentElement.removeChild( table );
			}
			return reliableTrDimensionsVal;
		}
	} );
} )();


function curCSS( elem, name, computed ) {
	var width, minWidth, maxWidth, ret,

		// Support: Firefox 51+
		// Retrieving style before computed somehow
		// fixes an issue with getting wrong values
		// on detached elements
		style = elem.style;

	computed = computed || getStyles( elem );

	// getPropertyValue is needed for:
	//   .css('filter') (IE 9 only, #12537)
	//   .css('--customProperty) (#3144)
	if ( computed ) {
		ret = computed.getPropertyValue( name ) || computed[ name ];

		if ( ret === "" && !isAttached( elem ) ) {
			ret = jQuery.style( elem, name );
		}

		// A tribute to the "awesome hack by Dean Edwards"
		// Android Browser returns percentage for some values,
		// but width seems to be reliably pixels.
		// This is against the CSSOM draft spec:
		// https://drafts.csswg.org/cssom/#resolved-values
		if ( !support.pixelBoxStyles() && rnumnonpx.test( ret ) && rboxStyle.test( name ) ) {

			// Remember the original values
			width = style.width;
			minWidth = style.minWidth;
			maxWidth = style.maxWidth;

			// Put in the new values to get a computed value out
			style.minWidth = style.maxWidth = style.width = ret;
			ret = computed.width;

			// Revert the changed values
			style.width = width;
			style.minWidth = minWidth;
			style.maxWidth = maxWidth;
		}
	}

	return ret !== undefined ?

		// Support: IE <=9 - 11 only
		// IE returns zIndex value as an integer.
		ret + "" :
		ret;
}


function addGetHookIf( conditionFn, hookFn ) {

	// Define the hook, we'll check on the first run if it's really needed.
	return {
		get: function() {
			if ( conditionFn() ) {

				// Hook not needed (or it's not possible to use it due
				// to missing dependency), remove it.
				delete this.get;
				return;
			}

			// Hook needed; redefine it so that the support test is not executed again.
			return ( this.get = hookFn ).apply( this, arguments );
		}
	};
}


var cssPrefixes = [ "Webkit", "Moz", "ms" ],
	emptyStyle = document.createElement( "div" ).style,
	vendorProps = {};

// Return a vendor-prefixed property or undefined
function vendorPropName( name ) {

	// Check for vendor prefixed names
	var capName = name[ 0 ].toUpperCase() + name.slice( 1 ),
		i = cssPrefixes.length;

	while ( i-- ) {
		name = cssPrefixes[ i ] + capName;
		if ( name in emptyStyle ) {
			return name;
		}
	}
}

// Return a potentially-mapped jQuery.cssProps or vendor prefixed property
function finalPropName( name ) {
	var final = jQuery.cssProps[ name ] || vendorProps[ name ];

	if ( final ) {
		return final;
	}
	if ( name in emptyStyle ) {
		return name;
	}
	return vendorProps[ name ] = vendorPropName( name ) || name;
}


var

	// Swappable if display is none or starts with table
	// except "table", "table-cell", or "table-caption"
	// See here for display values: https://developer.mozilla.org/en-US/docs/CSS/display
	rdisplayswap = /^(none|table(?!-c[ea]).+)/,
	rcustomProp = /^--/,
	cssShow = { position: "absolute", visibility: "hidden", display: "block" },
	cssNormalTransform = {
		letterSpacing: "0",
		fontWeight: "400"
	};

function setPositiveNumber( _elem, value, subtract ) {

	// Any relative (+/-) values have already been
	// normalized at this point
	var matches = rcssNum.exec( value );
	return matches ?

		// Guard against undefined "subtract", e.g., when used as in cssHooks
		Math.max( 0, matches[ 2 ] - ( subtract || 0 ) ) + ( matches[ 3 ] || "px" ) :
		value;
}

function boxModelAdjustment( elem, dimension, box, isBorderBox, styles, computedVal ) {
	var i = dimension === "width" ? 1 : 0,
		extra = 0,
		delta = 0;

	// Adjustment may not be necessary
	if ( box === ( isBorderBox ? "border" : "content" ) ) {
		return 0;
	}

	for ( ; i < 4; i += 2 ) {

		// Both box models exclude margin
		if ( box === "margin" ) {
			delta += jQuery.css( elem, box + cssExpand[ i ], true, styles );
		}

		// If we get here with a content-box, we're seeking "padding" or "border" or "margin"
		if ( !isBorderBox ) {

			// Add padding
			delta += jQuery.css( elem, "padding" + cssExpand[ i ], true, styles );

			// For "border" or "margin", add border
			if ( box !== "padding" ) {
				delta += jQuery.css( elem, "border" + cssExpand[ i ] + "Width", true, styles );

			// But still keep track of it otherwise
			} else {
				extra += jQuery.css( elem, "border" + cssExpand[ i ] + "Width", true, styles );
			}

		// If we get here with a border-box (content + padding + border), we're seeking "content" or
		// "padding" or "margin"
		} else {

			// For "content", subtract padding
			if ( box === "content" ) {
				delta -= jQuery.css( elem, "padding" + cssExpand[ i ], true, styles );
			}

			// For "content" or "padding", subtract border
			if ( box !== "margin" ) {
				delta -= jQuery.css( elem, "border" + cssExpand[ i ] + "Width", true, styles );
			}
		}
	}

	// Account for positive content-box scroll gutter when requested by providing computedVal
	if ( !isBorderBox && computedVal >= 0 ) {

		// offsetWidth/offsetHeight is a rounded sum of content, padding, scroll gutter, and border
		// Assuming integer scroll gutter, subtract the rest and round down
		delta += Math.max( 0, Math.ceil(
			elem[ "offset" + dimension[ 0 ].toUpperCase() + dimension.slice( 1 ) ] -
			computedVal -
			delta -
			extra -
			0.5

		// If offsetWidth/offsetHeight is unknown, then we can't determine content-box scroll gutter
		// Use an explicit zero to avoid NaN (gh-3964)
		) ) || 0;
	}

	return delta;
}

function getWidthOrHeight( elem, dimension, extra ) {

	// Start with computed style
	var styles = getStyles( elem ),

		// To avoid forcing a reflow, only fetch boxSizing if we need it (gh-4322).
		// Fake content-box until we know it's needed to know the true value.
		boxSizingNeeded = !support.boxSizingReliable() || extra,
		isBorderBox = boxSizingNeeded &&
			jQuery.css( elem, "boxSizing", false, styles ) === "border-box",
		valueIsBorderBox = isBorderBox,

		val = curCSS( elem, dimension, styles ),
		offsetProp = "offset" + dimension[ 0 ].toUpperCase() + dimension.slice( 1 );

	// Support: Firefox <=54
	// Return a confounding non-pixel value or feign ignorance, as appropriate.
	if ( rnumnonpx.test( val ) ) {
		if ( !extra ) {
			return val;
		}
		val = "auto";
	}


	// Support: IE 9 - 11 only
	// Use offsetWidth/offsetHeight for when box sizing is unreliable.
	// In those cases, the computed value can be trusted to be border-box.
	if ( ( !support.boxSizingReliable() && isBorderBox ||

		// Support: IE 10 - 11+, Edge 15 - 18+
		// IE/Edge misreport `getComputedStyle` of table rows with width/height
		// set in CSS while `offset*` properties report correct values.
		// Interestingly, in some cases IE 9 doesn't suffer from this issue.
		!support.reliableTrDimensions() && nodeName( elem, "tr" ) ||

		// Fall back to offsetWidth/offsetHeight when value is "auto"
		// This happens for inline elements with no explicit setting (gh-3571)
		val === "auto" ||

		// Support: Android <=4.1 - 4.3 only
		// Also use offsetWidth/offsetHeight for misreported inline dimensions (gh-3602)
		!parseFloat( val ) && jQuery.css( elem, "display", false, styles ) === "inline" ) &&

		// Make sure the element is visible & connected
		elem.getClientRects().length ) {

		isBorderBox = jQuery.css( elem, "boxSizing", false, styles ) === "border-box";

		// Where available, offsetWidth/offsetHeight approximate border box dimensions.
		// Where not available (e.g., SVG), assume unreliable box-sizing and interpret the
		// retrieved value as a content box dimension.
		valueIsBorderBox = offsetProp in elem;
		if ( valueIsBorderBox ) {
			val = elem[ offsetProp ];
		}
	}

	// Normalize "" and auto
	val = parseFloat( val ) || 0;

	// Adjust for the element's box model
	return ( val +
		boxModelAdjustment(
			elem,
			dimension,
			extra || ( isBorderBox ? "border" : "content" ),
			valueIsBorderBox,
			styles,

			// Provide the current computed size to request scroll gutter calculation (gh-3589)
			val
		)
	) + "px";
}

jQuery.extend( {

	// Add in style property hooks for overriding the default
	// behavior of getting and setting a style property
	cssHooks: {
		opacity: {
			get: function( elem, computed ) {
				if ( computed ) {

					// We should always get a number back from opacity
					var ret = curCSS( elem, "opacity" );
					return ret === "" ? "1" : ret;
				}
			}
		}
	},

	// Don't automatically add "px" to these possibly-unitless properties
	cssNumber: {
		"animationIterationCount": true,
		"columnCount": true,
		"fillOpacity": true,
		"flexGrow": true,
		"flexShrink": true,
		"fontWeight": true,
		"gridArea": true,
		"gridColumn": true,
		"gridColumnEnd": true,
		"gridColumnStart": true,
		"gridRow": true,
		"gridRowEnd": true,
		"gridRowStart": true,
		"lineHeight": true,
		"opacity": true,
		"order": true,
		"orphans": true,
		"widows": true,
		"zIndex": true,
		"zoom": true
	},

	// Add in properties whose names you wish to fix before
	// setting or getting the value
	cssProps: {},

	// Get and set the style property on a DOM Node
	style: function( elem, name, value, extra ) {

		// Don't set styles on text and comment nodes
		if ( !elem || elem.nodeType === 3 || elem.nodeType === 8 || !elem.style ) {
			return;
		}

		// Make sure that we're working with the right name
		var ret, type, hooks,
			origName = camelCase( name ),
			isCustomProp = rcustomProp.test( name ),
			style = elem.style;

		// Make sure that we're working with the right name. We don't
		// want to query the value if it is a CSS custom property
		// since they are user-defined.
		if ( !isCustomProp ) {
			name = finalPropName( origName );
		}

		// Gets hook for the prefixed version, then unprefixed version
		hooks = jQuery.cssHooks[ name ] || jQuery.cssHooks[ origName ];

		// Check if we're setting a value
		if ( value !== undefined ) {
			type = typeof value;

			// Convert "+=" or "-=" to relative numbers (#7345)
			if ( type === "string" && ( ret = rcssNum.exec( value ) ) && ret[ 1 ] ) {
				value = adjustCSS( elem, name, ret );

				// Fixes bug #9237
				type = "number";
			}

			// Make sure that null and NaN values aren't set (#7116)
			if ( value == null || value !== value ) {
				return;
			}

			// If a number was passed in, add the unit (except for certain CSS properties)
			// The isCustomProp check can be removed in jQuery 4.0 when we only auto-append
			// "px" to a few hardcoded values.
			if ( type === "number" && !isCustomProp ) {
				value += ret && ret[ 3 ] || ( jQuery.cssNumber[ origName ] ? "" : "px" );
			}

			// background-* props affect original clone's values
			if ( !support.clearCloneStyle && value === "" && name.indexOf( "background" ) === 0 ) {
				style[ name ] = "inherit";
			}

			// If a hook was provided, use that value, otherwise just set the specified value
			if ( !hooks || !( "set" in hooks ) ||
				( value = hooks.set( elem, value, extra ) ) !== undefined ) {

				if ( isCustomProp ) {
					style.setProperty( name, value );
				} else {
					style[ name ] = value;
				}
			}

		} else {

			// If a hook was provided get the non-computed value from there
			if ( hooks && "get" in hooks &&
				( ret = hooks.get( elem, false, extra ) ) !== undefined ) {

				return ret;
			}

			// Otherwise just get the value from the style object
			return style[ name ];
		}
	},

	css: function( elem, name, extra, styles ) {
		var val, num, hooks,
			origName = camelCase( name ),
			isCustomProp = rcustomProp.test( name );

		// Make sure that we're working with the right name. We don't
		// want to modify the value if it is a CSS custom property
		// since they are user-defined.
		if ( !isCustomProp ) {
			name = finalPropName( origName );
		}

		// Try prefixed name followed by the unprefixed name
		hooks = jQuery.cssHooks[ name ] || jQuery.cssHooks[ origName ];

		// If a hook was provided get the computed value from there
		if ( hooks && "get" in hooks ) {
			val = hooks.get( elem, true, extra );
		}

		// Otherwise, if a way to get the computed value exists, use that
		if ( val === undefined ) {
			val = curCSS( elem, name, styles );
		}

		// Convert "normal" to computed value
		if ( val === "normal" && name in cssNormalTransform ) {
			val = cssNormalTransform[ name ];
		}

		// Make numeric if forced or a qualifier was provided and val looks numeric
		if ( extra === "" || extra ) {
			num = parseFloat( val );
			return extra === true || isFinite( num ) ? num || 0 : val;
		}

		return val;
	}
} );

jQuery.each( [ "height", "width" ], function( _i, dimension ) {
	jQuery.cssHooks[ dimension ] = {
		get: function( elem, computed, extra ) {
			if ( computed ) {

				// Certain elements can have dimension info if we invisibly show them
				// but it must have a current display style that would benefit
				return rdisplayswap.test( jQuery.css( elem, "display" ) ) &&

					// Support: Safari 8+
					// Table columns in Safari have non-zero offsetWidth & zero
					// getBoundingClientRect().width unless display is changed.
					// Support: IE <=11 only
					// Running getBoundingClientRect on a disconnected node
					// in IE throws an error.
					( !elem.getClientRects().length || !elem.getBoundingClientRect().width ) ?
						swap( elem, cssShow, function() {
							return getWidthOrHeight( elem, dimension, extra );
						} ) :
						getWidthOrHeight( elem, dimension, extra );
			}
		},

		set: function( elem, value, extra ) {
			var matches,
				styles = getStyles( elem ),

				// Only read styles.position if the test has a chance to fail
				// to avoid forcing a reflow.
				scrollboxSizeBuggy = !support.scrollboxSize() &&
					styles.position === "absolute",

				// To avoid forcing a reflow, only fetch boxSizing if we need it (gh-3991)
				boxSizingNeeded = scrollboxSizeBuggy || extra,
				isBorderBox = boxSizingNeeded &&
					jQuery.css( elem, "boxSizing", false, styles ) === "border-box",
				subtract = extra ?
					boxModelAdjustment(
						elem,
						dimension,
						extra,
						isBorderBox,
						styles
					) :
					0;

			// Account for unreliable border-box dimensions by comparing offset* to computed and
			// faking a content-box to get border and padding (gh-3699)
			if ( isBorderBox && scrollboxSizeBuggy ) {
				subtract -= Math.ceil(
					elem[ "offset" + dimension[ 0 ].toUpperCase() + dimension.slice( 1 ) ] -
					parseFloat( styles[ dimension ] ) -
					boxModelAdjustment( elem, dimension, "border", false, styles ) -
					0.5
				);
			}

			// Convert to pixels if value adjustment is needed
			if ( subtract && ( matches = rcssNum.exec( value ) ) &&
				( matches[ 3 ] || "px" ) !== "px" ) {

				elem.style[ dimension ] = value;
				value = jQuery.css( elem, dimension );
			}

			return setPositiveNumber( elem, value, subtract );
		}
	};
} );

jQuery.cssHooks.marginLeft = addGetHookIf( support.reliableMarginLeft,
	function( elem, computed ) {
		if ( computed ) {
			return ( parseFloat( curCSS( elem, "marginLeft" ) ) ||
				elem.getBoundingClientRect().left -
					swap( elem, { marginLeft: 0 }, function() {
						return elem.getBoundingClientRect().left;
					} )
				) + "px";
		}
	}
);

// These hooks are used by animate to expand properties
jQuery.each( {
	margin: "",
	padding: "",
	border: "Width"
}, function( prefix, suffix ) {
	jQuery.cssHooks[ prefix + suffix ] = {
		expand: function( value ) {
			var i = 0,
				expanded = {},

				// Assumes a single number if not a string
				parts = typeof value === "string" ? value.split( " " ) : [ value ];

			for ( ; i < 4; i++ ) {
				expanded[ prefix + cssExpand[ i ] + suffix ] =
					parts[ i ] || parts[ i - 2 ] || parts[ 0 ];
			}

			return expanded;
		}
	};

	if ( prefix !== "margin" ) {
		jQuery.cssHooks[ prefix + suffix ].set = setPositiveNumber;
	}
} );

jQuery.fn.extend( {
	css: function( name, value ) {
		return access( this, function( elem, name, value ) {
			var styles, len,
				map = {},
				i = 0;

			if ( Array.isArray( name ) ) {
				styles = getStyles( elem );
				len = name.length;

				for ( ; i < len; i++ ) {
					map[ name[ i ] ] = jQuery.css( elem, name[ i ], false, styles );
				}

				return map;
			}

			return value !== undefined ?
				jQuery.style( elem, name, value ) :
				jQuery.css( elem, name );
		}, name, value, arguments.length > 1 );
	}
} );


function Tween( elem, options, prop, end, easing ) {
	return new Tween.prototype.init( elem, options, prop, end, easing );
}
jQuery.Tween = Tween;

Tween.prototype = {
	constructor: Tween,
	init: function( elem, options, prop, end, easing, unit ) {
		this.elem = elem;
		this.prop = prop;
		this.easing = easing || jQuery.easing._default;
		this.options = options;
		this.start = this.now = this.cur();
		this.end = end;
		this.unit = unit || ( jQuery.cssNumber[ prop ] ? "" : "px" );
	},
	cur: function() {
		var hooks = Tween.propHooks[ this.prop ];

		return hooks && hooks.get ?
			hooks.get( this ) :
			Tween.propHooks._default.get( this );
	},
	run: function( percent ) {
		var eased,
			hooks = Tween.propHooks[ this.prop ];

		if ( this.options.duration ) {
			this.pos = eased = jQuery.easing[ this.easing ](
				percent, this.options.duration * percent, 0, 1, this.options.duration
			);
		} else {
			this.pos = eased = percent;
		}
		this.now = ( this.end - this.start ) * eased + this.start;

		if ( this.options.step ) {
			this.options.step.call( this.elem, this.now, this );
		}

		if ( hooks && hooks.set ) {
			hooks.set( this );
		} else {
			Tween.propHooks._default.set( this );
		}
		return this;
	}
};

Tween.prototype.init.prototype = Tween.prototype;

Tween.propHooks = {
	_default: {
		get: function( tween ) {
			var result;

			// Use a property on the element directly when it is not a DOM element,
			// or when there is no matching style property that exists.
			if ( tween.elem.nodeType !== 1 ||
				tween.elem[ tween.prop ] != null && tween.elem.style[ tween.prop ] == null ) {
				return tween.elem[ tween.prop ];
			}

			// Passing an empty string as a 3rd parameter to .css will automatically
			// attempt a parseFloat and fallback to a string if the parse fails.
			// Simple values such as "10px" are parsed to Float;
			// complex values such as "rotate(1rad)" are returned as-is.
			result = jQuery.css( tween.elem, tween.prop, "" );

			// Empty strings, null, undefined and "auto" are converted to 0.
			return !result || result === "auto" ? 0 : result;
		},
		set: function( tween ) {

			// Use step hook for back compat.
			// Use cssHook if its there.
			// Use .style if available and use plain properties where available.
			if ( jQuery.fx.step[ tween.prop ] ) {
				jQuery.fx.step[ tween.prop ]( tween );
			} else if ( tween.elem.nodeType === 1 && (
					jQuery.cssHooks[ tween.prop ] ||
					tween.elem.style[ finalPropName( tween.prop ) ] != null ) ) {
				jQuery.style( tween.elem, tween.prop, tween.now + tween.unit );
			} else {
				tween.elem[ tween.prop ] = tween.now;
			}
		}
	}
};

// Support: IE <=9 only
// Panic based approach to setting things on disconnected nodes
Tween.propHooks.scrollTop = Tween.propHooks.scrollLeft = {
	set: function( tween ) {
		if ( tween.elem.nodeType && tween.elem.parentNode ) {
			tween.elem[ tween.prop ] = tween.now;
		}
	}
};

jQuery.easing = {
	linear: function( p ) {
		return p;
	},
	swing: function( p ) {
		return 0.5 - Math.cos( p * Math.PI ) / 2;
	},
	_default: "swing"
};

jQuery.fx = Tween.prototype.init;

// Back compat <1.8 extension point
jQuery.fx.step = {};




var
	fxNow, inProgress,
	rfxtypes = /^(?:toggle|show|hide)$/,
	rrun = /queueHooks$/;

function schedule() {
	if ( inProgress ) {
		if ( document.hidden === false && window.requestAnimationFrame ) {
			window.requestAnimationFrame( schedule );
		} else {
			window.setTimeout( schedule, jQuery.fx.interval );
		}

		jQuery.fx.tick();
	}
}

// Animations created synchronously will run synchronously
function createFxNow() {
	window.setTimeout( function() {
		fxNow = undefined;
	} );
	return ( fxNow = Date.now() );
}

// Generate parameters to create a standard animation
function genFx( type, includeWidth ) {
	var which,
		i = 0,
		attrs = { height: type };

	// If we include width, step value is 1 to do all cssExpand values,
	// otherwise step value is 2 to skip over Left and Right
	includeWidth = includeWidth ? 1 : 0;
	for ( ; i < 4; i += 2 - includeWidth ) {
		which = cssExpand[ i ];
		attrs[ "margin" + which ] = attrs[ "padding" + which ] = type;
	}

	if ( includeWidth ) {
		attrs.opacity = attrs.width = type;
	}

	return attrs;
}

function createTween( value, prop, animation ) {
	var tween,
		collection = ( Animation.tweeners[ prop ] || [] ).concat( Animation.tweeners[ "*" ] ),
		index = 0,
		length = collection.length;
	for ( ; index < length; index++ ) {
		if ( ( tween = collection[ index ].call( animation, prop, value ) ) ) {

			// We're done with this property
			return tween;
		}
	}
}

function defaultPrefilter( elem, props, opts ) {
	var prop, value, toggle, hooks, oldfire, propTween, restoreDisplay, display,
		isBox = "width" in props || "height" in props,
		anim = this,
		orig = {},
		style = elem.style,
		hidden = elem.nodeType && isHiddenWithinTree( elem ),
		dataShow = dataPriv.get( elem, "fxshow" );

	// Queue-skipping animations hijack the fx hooks
	if ( !opts.queue ) {
		hooks = jQuery._queueHooks( elem, "fx" );
		if ( hooks.unqueued == null ) {
			hooks.unqueued = 0;
			oldfire = hooks.empty.fire;
			hooks.empty.fire = function() {
				if ( !hooks.unqueued ) {
					oldfire();
				}
			};
		}
		hooks.unqueued++;

		anim.always( function() {

			// Ensure the complete handler is called before this completes
			anim.always( function() {
				hooks.unqueued--;
				if ( !jQuery.queue( elem, "fx" ).length ) {
					hooks.empty.fire();
				}
			} );
		} );
	}

	// Detect show/hide animations
	for ( prop in props ) {
		value = props[ prop ];
		if ( rfxtypes.test( value ) ) {
			delete props[ prop ];
			toggle = toggle || value === "toggle";
			if ( value === ( hidden ? "hide" : "show" ) ) {

				// Pretend to be hidden if this is a "show" and
				// there is still data from a stopped show/hide
				if ( value === "show" && dataShow && dataShow[ prop ] !== undefined ) {
					hidden = true;

				// Ignore all other no-op show/hide data
				} else {
					continue;
				}
			}
			orig[ prop ] = dataShow && dataShow[ prop ] || jQuery.style( elem, prop );
		}
	}

	// Bail out if this is a no-op like .hide().hide()
	propTween = !jQuery.isEmptyObject( props );
	if ( !propTween && jQuery.isEmptyObject( orig ) ) {
		return;
	}

	// Restrict "overflow" and "display" styles during box animations
	if ( isBox && elem.nodeType === 1 ) {

		// Support: IE <=9 - 11, Edge 12 - 15
		// Record all 3 overflow attributes because IE does not infer the shorthand
		// from identically-valued overflowX and overflowY and Edge just mirrors
		// the overflowX value there.
		opts.overflow = [ style.overflow, style.overflowX, style.overflowY ];

		// Identify a display type, preferring old show/hide data over the CSS cascade
		restoreDisplay = dataShow && dataShow.display;
		if ( restoreDisplay == null ) {
			restoreDisplay = dataPriv.get( elem, "display" );
		}
		display = jQuery.css( elem, "display" );
		if ( display === "none" ) {
			if ( restoreDisplay ) {
				display = restoreDisplay;
			} else {

				// Get nonempty value(s) by temporarily forcing visibility
				showHide( [ elem ], true );
				restoreDisplay = elem.style.display || restoreDisplay;
				display = jQuery.css( elem, "display" );
				showHide( [ elem ] );
			}
		}

		// Animate inline elements as inline-block
		if ( display === "inline" || display === "inline-block" && restoreDisplay != null ) {
			if ( jQuery.css( elem, "float" ) === "none" ) {

				// Restore the original display value at the end of pure show/hide animations
				if ( !propTween ) {
					anim.done( function() {
						style.display = restoreDisplay;
					} );
					if ( restoreDisplay == null ) {
						display = style.display;
						restoreDisplay = display === "none" ? "" : display;
					}
				}
				style.display = "inline-block";
			}
		}
	}

	if ( opts.overflow ) {
		style.overflow = "hidden";
		anim.always( function() {
			style.overflow = opts.overflow[ 0 ];
			style.overflowX = opts.overflow[ 1 ];
			style.overflowY = opts.overflow[ 2 ];
		} );
	}

	// Implement show/hide animations
	propTween = false;
	for ( prop in orig ) {

		// General show/hide setup for this element animation
		if ( !propTween ) {
			if ( dataShow ) {
				if ( "hidden" in dataShow ) {
					hidden = dataShow.hidden;
				}
			} else {
				dataShow = dataPriv.access( elem, "fxshow", { display: restoreDisplay } );
			}

			// Store hidden/visible for toggle so `.stop().toggle()` "reverses"
			if ( toggle ) {
				dataShow.hidden = !hidden;
			}

			// Show elements before animating them
			if ( hidden ) {
				showHide( [ elem ], true );
			}

			/* eslint-disable no-loop-func */

			anim.done( function() {

			/* eslint-enable no-loop-func */

				// The final step of a "hide" animation is actually hiding the element
				if ( !hidden ) {
					showHide( [ elem ] );
				}
				dataPriv.remove( elem, "fxshow" );
				for ( prop in orig ) {
					jQuery.style( elem, prop, orig[ prop ] );
				}
			} );
		}

		// Per-property setup
		propTween = createTween( hidden ? dataShow[ prop ] : 0, prop, anim );
		if ( !( prop in dataShow ) ) {
			dataShow[ prop ] = propTween.start;
			if ( hidden ) {
				propTween.end = propTween.start;
				propTween.start = 0;
			}
		}
	}
}

function propFilter( props, specialEasing ) {
	var index, name, easing, value, hooks;

	// camelCase, specialEasing and expand cssHook pass
	for ( index in props ) {
		name = camelCase( index );
		easing = specialEasing[ name ];
		value = props[ index ];
		if ( Array.isArray( value ) ) {
			easing = value[ 1 ];
			value = props[ index ] = value[ 0 ];
		}

		if ( index !== name ) {
			props[ name ] = value;
			delete props[ index ];
		}

		hooks = jQuery.cssHooks[ name ];
		if ( hooks && "expand" in hooks ) {
			value = hooks.expand( value );
			delete props[ name ];

			// Not quite $.extend, this won't overwrite existing keys.
			// Reusing 'index' because we have the correct "name"
			for ( index in value ) {
				if ( !( index in props ) ) {
					props[ index ] = value[ index ];
					specialEasing[ index ] = easing;
				}
			}
		} else {
			specialEasing[ name ] = easing;
		}
	}
}

function Animation( elem, properties, options ) {
	var result,
		stopped,
		index = 0,
		length = Animation.prefilters.length,
		deferred = jQuery.Deferred().always( function() {

			// Don't match elem in the :animated selector
			delete tick.elem;
		} ),
		tick = function() {
			if ( stopped ) {
				return false;
			}
			var currentTime = fxNow || createFxNow(),
				remaining = Math.max( 0, animation.startTime + animation.duration - currentTime ),

				// Support: Android 2.3 only
				// Archaic crash bug won't allow us to use `1 - ( 0.5 || 0 )` (#12497)
				temp = remaining / animation.duration || 0,
				percent = 1 - temp,
				index = 0,
				length = animation.tweens.length;

			for ( ; index < length; index++ ) {
				animation.tweens[ index ].run( percent );
			}

			deferred.notifyWith( elem, [ animation, percent, remaining ] );

			// If there's more to do, yield
			if ( percent < 1 && length ) {
				return remaining;
			}

			// If this was an empty animation, synthesize a final progress notification
			if ( !length ) {
				deferred.notifyWith( elem, [ animation, 1, 0 ] );
			}

			// Resolve the animation and report its conclusion
			deferred.resolveWith( elem, [ animation ] );
			return false;
		},
		animation = deferred.promise( {
			elem: elem,
			props: jQuery.extend( {}, properties ),
			opts: jQuery.extend( true, {
				specialEasing: {},
				easing: jQuery.easing._default
			}, options ),
			originalProperties: properties,
			originalOptions: options,
			startTime: fxNow || createFxNow(),
			duration: options.duration,
			tweens: [],
			createTween: function( prop, end ) {
				var tween = jQuery.Tween( elem, animation.opts, prop, end,
						animation.opts.specialEasing[ prop ] || animation.opts.easing );
				animation.tweens.push( tween );
				return tween;
			},
			stop: function( gotoEnd ) {
				var index = 0,

					// If we are going to the end, we want to run all the tweens
					// otherwise we skip this part
					length = gotoEnd ? animation.tweens.length : 0;
				if ( stopped ) {
					return this;
				}
				stopped = true;
				for ( ; index < length; index++ ) {
					animation.tweens[ index ].run( 1 );
				}

				// Resolve when we played the last frame; otherwise, reject
				if ( gotoEnd ) {
					deferred.notifyWith( elem, [ animation, 1, 0 ] );
					deferred.resolveWith( elem, [ animation, gotoEnd ] );
				} else {
					deferred.rejectWith( elem, [ animation, gotoEnd ] );
				}
				return this;
			}
		} ),
		props = animation.props;

	propFilter( props, animation.opts.specialEasing );

	for ( ; index < length; index++ ) {
		result = Animation.prefilters[ index ].call( animation, elem, props, animation.opts );
		if ( result ) {
			if ( isFunction( result.stop ) ) {
				jQuery._queueHooks( animation.elem, animation.opts.queue ).stop =
					result.stop.bind( result );
			}
			return result;
		}
	}

	jQuery.map( props, createTween, animation );

	if ( isFunction( animation.opts.start ) ) {
		animation.opts.start.call( elem, animation );
	}

	// Attach callbacks from options
	animation
		.progress( animation.opts.progress )
		.done( animation.opts.done, animation.opts.complete )
		.fail( animation.opts.fail )
		.always( animation.opts.always );

	jQuery.fx.timer(
		jQuery.extend( tick, {
			elem: elem,
			anim: animation,
			queue: animation.opts.queue
		} )
	);

	return animation;
}

jQuery.Animation = jQuery.extend( Animation, {

	tweeners: {
		"*": [ function( prop, value ) {
			var tween = this.createTween( prop, value );
			adjustCSS( tween.elem, prop, rcssNum.exec( value ), tween );
			return tween;
		} ]
	},

	tweener: function( props, callback ) {
		if ( isFunction( props ) ) {
			callback = props;
			props = [ "*" ];
		} else {
			props = props.match( rnothtmlwhite );
		}

		var prop,
			index = 0,
			length = props.length;

		for ( ; index < length; index++ ) {
			prop = props[ index ];
			Animation.tweeners[ prop ] = Animation.tweeners[ prop ] || [];
			Animation.tweeners[ prop ].unshift( callback );
		}
	},

	prefilters: [ defaultPrefilter ],

	prefilter: function( callback, prepend ) {
		if ( prepend ) {
			Animation.prefilters.unshift( callback );
		} else {
			Animation.prefilters.push( callback );
		}
	}
} );

jQuery.speed = function( speed, easing, fn ) {
	var opt = speed && typeof speed === "object" ? jQuery.extend( {}, speed ) : {
		complete: fn || !fn && easing ||
			isFunction( speed ) && speed,
		duration: speed,
		easing: fn && easing || easing && !isFunction( easing ) && easing
	};

	// Go to the end state if fx are off
	if ( jQuery.fx.off ) {
		opt.duration = 0;

	} else {
		if ( typeof opt.duration !== "number" ) {
			if ( opt.duration in jQuery.fx.speeds ) {
				opt.duration = jQuery.fx.speeds[ opt.duration ];

			} else {
				opt.duration = jQuery.fx.speeds._default;
			}
		}
	}

	// Normalize opt.queue - true/undefined/null -> "fx"
	if ( opt.queue == null || opt.queue === true ) {
		opt.queue = "fx";
	}

	// Queueing
	opt.old = opt.complete;

	opt.complete = function() {
		if ( isFunction( opt.old ) ) {
			opt.old.call( this );
		}

		if ( opt.queue ) {
			jQuery.dequeue( this, opt.queue );
		}
	};

	return opt;
};

jQuery.fn.extend( {
	fadeTo: function( speed, to, easing, callback ) {

		// Show any hidden elements after setting opacity to 0
		return this.filter( isHiddenWithinTree ).css( "opacity", 0 ).show()

			// Animate to the value specified
			.end().animate( { opacity: to }, speed, easing, callback );
	},
	animate: function( prop, speed, easing, callback ) {
		var empty = jQuery.isEmptyObject( prop ),
			optall = jQuery.speed( speed, easing, callback ),
			doAnimation = function() {

				// Operate on a copy of prop so per-property easing won't be lost
				var anim = Animation( this, jQuery.extend( {}, prop ), optall );

				// Empty animations, or finishing resolves immediately
				if ( empty || dataPriv.get( this, "finish" ) ) {
					anim.stop( true );
				}
			};
			doAnimation.finish = doAnimation;

		return empty || optall.queue === false ?
			this.each( doAnimation ) :
			this.queue( optall.queue, doAnimation );
	},
	stop: function( type, clearQueue, gotoEnd ) {
		var stopQueue = function( hooks ) {
			var stop = hooks.stop;
			delete hooks.stop;
			stop( gotoEnd );
		};

		if ( typeof type !== "string" ) {
			gotoEnd = clearQueue;
			clearQueue = type;
			type = undefined;
		}
		if ( clearQueue ) {
			this.queue( type || "fx", [] );
		}

		return this.each( function() {
			var dequeue = true,
				index = type != null && type + "queueHooks",
				timers = jQuery.timers,
				data = dataPriv.get( this );

			if ( index ) {
				if ( data[ index ] && data[ index ].stop ) {
					stopQueue( data[ index ] );
				}
			} else {
				for ( index in data ) {
					if ( data[ index ] && data[ index ].stop && rrun.test( index ) ) {
						stopQueue( data[ index ] );
					}
				}
			}

			for ( index = timers.length; index--; ) {
				if ( timers[ index ].elem === this &&
					( type == null || timers[ index ].queue === type ) ) {

					timers[ index ].anim.stop( gotoEnd );
					dequeue = false;
					timers.splice( index, 1 );
				}
			}

			// Start the next in the queue if the last step wasn't forced.
			// Timers currently will call their complete callbacks, which
			// will dequeue but only if they were gotoEnd.
			if ( dequeue || !gotoEnd ) {
				jQuery.dequeue( this, type );
			}
		} );
	},
	finish: function( type ) {
		if ( type !== false ) {
			type = type || "fx";
		}
		return this.each( function() {
			var index,
				data = dataPriv.get( this ),
				queue = data[ type + "queue" ],
				hooks = data[ type + "queueHooks" ],
				timers = jQuery.timers,
				length = queue ? queue.length : 0;

			// Enable finishing flag on private data
			data.finish = true;

			// Empty the queue first
			jQuery.queue( this, type, [] );

			if ( hooks && hooks.stop ) {
				hooks.stop.call( this, true );
			}

			// Look for any active animations, and finish them
			for ( index = timers.length; index--; ) {
				if ( timers[ index ].elem === this && timers[ index ].queue === type ) {
					timers[ index ].anim.stop( true );
					timers.splice( index, 1 );
				}
			}

			// Look for any animations in the old queue and finish them
			for ( index = 0; index < length; index++ ) {
				if ( queue[ index ] && queue[ index ].finish ) {
					queue[ index ].finish.call( this );
				}
			}

			// Turn off finishing flag
			delete data.finish;
		} );
	}
} );

jQuery.each( [ "toggle", "show", "hide" ], function( _i, name ) {
	var cssFn = jQuery.fn[ name ];
	jQuery.fn[ name ] = function( speed, easing, callback ) {
		return speed == null || typeof speed === "boolean" ?
			cssFn.apply( this, arguments ) :
			this.animate( genFx( name, true ), speed, easing, callback );
	};
} );

// Generate shortcuts for custom animations
jQuery.each( {
	slideDown: genFx( "show" ),
	slideUp: genFx( "hide" ),
	slideToggle: genFx( "toggle" ),
	fadeIn: { opacity: "show" },
	fadeOut: { opacity: "hide" },
	fadeToggle: { opacity: "toggle" }
}, function( name, props ) {
	jQuery.fn[ name ] = function( speed, easing, callback ) {
		return this.animate( props, speed, easing, callback );
	};
} );

jQuery.timers = [];
jQuery.fx.tick = function() {
	var timer,
		i = 0,
		timers = jQuery.timers;

	fxNow = Date.now();

	for ( ; i < timers.length; i++ ) {
		timer = timers[ i ];

		// Run the timer and safely remove it when done (allowing for external removal)
		if ( !timer() && timers[ i ] === timer ) {
			timers.splice( i--, 1 );
		}
	}

	if ( !timers.length ) {
		jQuery.fx.stop();
	}
	fxNow = undefined;
};

jQuery.fx.timer = function( timer ) {
	jQuery.timers.push( timer );
	jQuery.fx.start();
};

jQuery.fx.interval = 13;
jQuery.fx.start = function() {
	if ( inProgress ) {
		return;
	}

	inProgress = true;
	schedule();
};

jQuery.fx.stop = function() {
	inProgress = null;
};

jQuery.fx.speeds = {
	slow: 600,
	fast: 200,

	// Default speed
	_default: 400
};


// Based off of the plugin by Clint Helfers, with permission.
// https://web.archive.org/web/20100324014747/http://blindsignals.com/index.php/2009/07/jquery-delay/
jQuery.fn.delay = function( time, type ) {
	time = jQuery.fx ? jQuery.fx.speeds[ time ] || time : time;
	type = type || "fx";

	return this.queue( type, function( next, hooks ) {
		var timeout = window.setTimeout( next, time );
		hooks.stop = function() {
			window.clearTimeout( timeout );
		};
	} );
};


( function() {
	var input = document.createElement( "input" ),
		select = document.createElement( "select" ),
		opt = select.appendChild( document.createElement( "option" ) );

	input.type = "checkbox";

	// Support: Android <=4.3 only
	// Default value for a checkbox should be "on"
	support.checkOn = input.value !== "";

	// Support: IE <=11 only
	// Must access selectedIndex to make default options select
	support.optSelected = opt.selected;

	// Support: IE <=11 only
	// An input loses its value after becoming a radio
	input = document.createElement( "input" );
	input.value = "t";
	input.type = "radio";
	support.radioValue = input.value === "t";
} )();


var boolHook,
	attrHandle = jQuery.expr.attrHandle;

jQuery.fn.extend( {
	attr: function( name, value ) {
		return access( this, jQuery.attr, name, value, arguments.length > 1 );
	},

	removeAttr: function( name ) {
		return this.each( function() {
			jQuery.removeAttr( this, name );
		} );
	}
} );

jQuery.extend( {
	attr: function( elem, name, value ) {
		var ret, hooks,
			nType = elem.nodeType;

		// Don't get/set attributes on text, comment and attribute nodes
		if ( nType === 3 || nType === 8 || nType === 2 ) {
			return;
		}

		// Fallback to prop when attributes are not supported
		if ( typeof elem.getAttribute === "undefined" ) {
			return jQuery.prop( elem, name, value );
		}

		// Attribute hooks are determined by the lowercase version
		// Grab necessary hook if one is defined
		if ( nType !== 1 || !jQuery.isXMLDoc( elem ) ) {
			hooks = jQuery.attrHooks[ name.toLowerCase() ] ||
				( jQuery.expr.match.bool.test( name ) ? boolHook : undefined );
		}

		if ( value !== undefined ) {
			if ( value === null ) {
				jQuery.removeAttr( elem, name );
				return;
			}

			if ( hooks && "set" in hooks &&
				( ret = hooks.set( elem, value, name ) ) !== undefined ) {
				return ret;
			}

			elem.setAttribute( name, value + "" );
			return value;
		}

		if ( hooks && "get" in hooks && ( ret = hooks.get( elem, name ) ) !== null ) {
			return ret;
		}

		ret = jQuery.find.attr( elem, name );

		// Non-existent attributes return null, we normalize to undefined
		return ret == null ? undefined : ret;
	},

	attrHooks: {
		type: {
			set: function( elem, value ) {
				if ( !support.radioValue && value === "radio" &&
					nodeName( elem, "input" ) ) {
					var val = elem.value;
					elem.setAttribute( "type", value );
					if ( val ) {
						elem.value = val;
					}
					return value;
				}
			}
		}
	},

	removeAttr: function( elem, value ) {
		var name,
			i = 0,

			// Attribute names can contain non-HTML whitespace characters
			// https://html.spec.whatwg.org/multipage/syntax.html#attributes-2
			attrNames = value && value.match( rnothtmlwhite );

		if ( attrNames && elem.nodeType === 1 ) {
			while ( ( name = attrNames[ i++ ] ) ) {
				elem.removeAttribute( name );
			}
		}
	}
} );

// Hooks for boolean attributes
boolHook = {
	set: function( elem, value, name ) {
		if ( value === false ) {

			// Remove boolean attributes when set to false
			jQuery.removeAttr( elem, name );
		} else {
			elem.setAttribute( name, name );
		}
		return name;
	}
};

jQuery.each( jQuery.expr.match.bool.source.match( /\w+/g ), function( _i, name ) {
	var getter = attrHandle[ name ] || jQuery.find.attr;

	attrHandle[ name ] = function( elem, name, isXML ) {
		var ret, handle,
			lowercaseName = name.toLowerCase();

		if ( !isXML ) {

			// Avoid an infinite loop by temporarily removing this function from the getter
			handle = attrHandle[ lowercaseName ];
			attrHandle[ lowercaseName ] = ret;
			ret = getter( elem, name, isXML ) != null ?
				lowercaseName :
				null;
			attrHandle[ lowercaseName ] = handle;
		}
		return ret;
	};
} );




var rfocusable = /^(?:input|select|textarea|button)$/i,
	rclickable = /^(?:a|area)$/i;

jQuery.fn.extend( {
	prop: function( name, value ) {
		return access( this, jQuery.prop, name, value, arguments.length > 1 );
	},

	removeProp: function( name ) {
		return this.each( function() {
			delete this[ jQuery.propFix[ name ] || name ];
		} );
	}
} );

jQuery.extend( {
	prop: function( elem, name, value ) {
		var ret, hooks,
			nType = elem.nodeType;

		// Don't get/set properties on text, comment and attribute nodes
		if ( nType === 3 || nType === 8 || nType === 2 ) {
			return;
		}

		if ( nType !== 1 || !jQuery.isXMLDoc( elem ) ) {

			// Fix name and attach hooks
			name = jQuery.propFix[ name ] || name;
			hooks = jQuery.propHooks[ name ];
		}

		if ( value !== undefined ) {
			if ( hooks && "set" in hooks &&
				( ret = hooks.set( elem, value, name ) ) !== undefined ) {
				return ret;
			}

			return ( elem[ name ] = value );
		}

		if ( hooks && "get" in hooks && ( ret = hooks.get( elem, name ) ) !== null ) {
			return ret;
		}

		return elem[ name ];
	},

	propHooks: {
		tabIndex: {
			get: function( elem ) {

				// Support: IE <=9 - 11 only
				// elem.tabIndex doesn't always return the
				// correct value when it hasn't been explicitly set
				// https://web.archive.org/web/20141116233347/http://fluidproject.org/blog/2008/01/09/getting-setting-and-removing-tabindex-values-with-javascript/
				// Use proper attribute retrieval(#12072)
				var tabindex = jQuery.find.attr( elem, "tabindex" );

				if ( tabindex ) {
					return parseInt( tabindex, 10 );
				}

				if (
					rfocusable.test( elem.nodeName ) ||
					rclickable.test( elem.nodeName ) &&
					elem.href
				) {
					return 0;
				}

				return -1;
			}
		}
	},

	propFix: {
		"for": "htmlFor",
		"class": "className"
	}
} );

// Support: IE <=11 only
// Accessing the selectedIndex property
// forces the browser to respect setting selected
// on the option
// The getter ensures a default option is selected
// when in an optgroup
// eslint rule "no-unused-expressions" is disabled for this code
// since it considers such accessions noop
if ( !support.optSelected ) {
	jQuery.propHooks.selected = {
		get: function( elem ) {

			/* eslint no-unused-expressions: "off" */

			var parent = elem.parentNode;
			if ( parent && parent.parentNode ) {
				parent.parentNode.selectedIndex;
			}
			return null;
		},
		set: function( elem ) {

			/* eslint no-unused-expressions: "off" */

			var parent = elem.parentNode;
			if ( parent ) {
				parent.selectedIndex;

				if ( parent.parentNode ) {
					parent.parentNode.selectedIndex;
				}
			}
		}
	};
}

jQuery.each( [
	"tabIndex",
	"readOnly",
	"maxLength",
	"cellSpacing",
	"cellPadding",
	"rowSpan",
	"colSpan",
	"useMap",
	"frameBorder",
	"contentEditable"
], function() {
	jQuery.propFix[ this.toLowerCase() ] = this;
} );




	// Strip and collapse whitespace according to HTML spec
	// https://infra.spec.whatwg.org/#strip-and-collapse-ascii-whitespace
	function stripAndCollapse( value ) {
		var tokens = value.match( rnothtmlwhite ) || [];
		return tokens.join( " " );
	}


function getClass( elem ) {
	return elem.getAttribute && elem.getAttribute( "class" ) || "";
}

function classesToArray( value ) {
	if ( Array.isArray( value ) ) {
		return value;
	}
	if ( typeof value === "string" ) {
		return value.match( rnothtmlwhite ) || [];
	}
	return [];
}

jQuery.fn.extend( {
	addClass: function( value ) {
		var classes, elem, cur, curValue, clazz, j, finalValue,
			i = 0;

		if ( isFunction( value ) ) {
			return this.each( function( j ) {
				jQuery( this ).addClass( value.call( this, j, getClass( this ) ) );
			} );
		}

		classes = classesToArray( value );

		if ( classes.length ) {
			while ( ( elem = this[ i++ ] ) ) {
				curValue = getClass( elem );
				cur = elem.nodeType === 1 && ( " " + stripAndCollapse( curValue ) + " " );

				if ( cur ) {
					j = 0;
					while ( ( clazz = classes[ j++ ] ) ) {
						if ( cur.indexOf( " " + clazz + " " ) < 0 ) {
							cur += clazz + " ";
						}
					}

					// Only assign if different to avoid unneeded rendering.
					finalValue = stripAndCollapse( cur );
					if ( curValue !== finalValue ) {
						elem.setAttribute( "class", finalValue );
					}
				}
			}
		}

		return this;
	},

	removeClass: function( value ) {
		var classes, elem, cur, curValue, clazz, j, finalValue,
			i = 0;

		if ( isFunction( value ) ) {
			return this.each( function( j ) {
				jQuery( this ).removeClass( value.call( this, j, getClass( this ) ) );
			} );
		}

		if ( !arguments.length ) {
			return this.attr( "class", "" );
		}

		classes = classesToArray( value );

		if ( classes.length ) {
			while ( ( elem = this[ i++ ] ) ) {
				curValue = getClass( elem );

				// This expression is here for better compressibility (see addClass)
				cur = elem.nodeType === 1 && ( " " + stripAndCollapse( curValue ) + " " );

				if ( cur ) {
					j = 0;
					while ( ( clazz = classes[ j++ ] ) ) {

						// Remove *all* instances
						while ( cur.indexOf( " " + clazz + " " ) > -1 ) {
							cur = cur.replace( " " + clazz + " ", " " );
						}
					}

					// Only assign if different to avoid unneeded rendering.
					finalValue = stripAndCollapse( cur );
					if ( curValue !== finalValue ) {
						elem.setAttribute( "class", finalValue );
					}
				}
			}
		}

		return this;
	},

	toggleClass: function( value, stateVal ) {
		var type = typeof value,
			isValidValue = type === "string" || Array.isArray( value );

		if ( typeof stateVal === "boolean" && isValidValue ) {
			return stateVal ? this.addClass( value ) : this.removeClass( value );
		}

		if ( isFunction( value ) ) {
			return this.each( function( i ) {
				jQuery( this ).toggleClass(
					value.call( this, i, getClass( this ), stateVal ),
					stateVal
				);
			} );
		}

		return this.each( function() {
			var className, i, self, classNames;

			if ( isValidValue ) {

				// Toggle individual class names
				i = 0;
				self = jQuery( this );
				classNames = classesToArray( value );

				while ( ( className = classNames[ i++ ] ) ) {

					// Check each className given, space separated list
					if ( self.hasClass( className ) ) {
						self.removeClass( className );
					} else {
						self.addClass( className );
					}
				}

			// Toggle whole class name
			} else if ( value === undefined || type === "boolean" ) {
				className = getClass( this );
				if ( className ) {

					// Store className if set
					dataPriv.set( this, "__className__", className );
				}

				// If the element has a class name or if we're passed `false`,
				// then remove the whole classname (if there was one, the above saved it).
				// Otherwise bring back whatever was previously saved (if anything),
				// falling back to the empty string if nothing was stored.
				if ( this.setAttribute ) {
					this.setAttribute( "class",
						className || value === false ?
						"" :
						dataPriv.get( this, "__className__" ) || ""
					);
				}
			}
		} );
	},

	hasClass: function( selector ) {
		var className, elem,
			i = 0;

		className = " " + selector + " ";
		while ( ( elem = this[ i++ ] ) ) {
			if ( elem.nodeType === 1 &&
				( " " + stripAndCollapse( getClass( elem ) ) + " " ).indexOf( className ) > -1 ) {
					return true;
			}
		}

		return false;
	}
} );




var rreturn = /\r/g;

jQuery.fn.extend( {
	val: function( value ) {
		var hooks, ret, valueIsFunction,
			elem = this[ 0 ];

		if ( !arguments.length ) {
			if ( elem ) {
				hooks = jQuery.valHooks[ elem.type ] ||
					jQuery.valHooks[ elem.nodeName.toLowerCase() ];

				if ( hooks &&
					"get" in hooks &&
					( ret = hooks.get( elem, "value" ) ) !== undefined
				) {
					return ret;
				}

				ret = elem.value;

				// Handle most common string cases
				if ( typeof ret === "string" ) {
					return ret.replace( rreturn, "" );
				}

				// Handle cases where value is null/undef or number
				return ret == null ? "" : ret;
			}

			return;
		}

		valueIsFunction = isFunction( value );

		return this.each( function( i ) {
			var val;

			if ( this.nodeType !== 1 ) {
				return;
			}

			if ( valueIsFunction ) {
				val = value.call( this, i, jQuery( this ).val() );
			} else {
				val = value;
			}

			// Treat null/undefined as ""; convert numbers to string
			if ( val == null ) {
				val = "";

			} else if ( typeof val === "number" ) {
				val += "";

			} else if ( Array.isArray( val ) ) {
				val = jQuery.map( val, function( value ) {
					return value == null ? "" : value + "";
				} );
			}

			hooks = jQuery.valHooks[ this.type ] || jQuery.valHooks[ this.nodeName.toLowerCase() ];

			// If set returns undefined, fall back to normal setting
			if ( !hooks || !( "set" in hooks ) || hooks.set( this, val, "value" ) === undefined ) {
				this.value = val;
			}
		} );
	}
} );

jQuery.extend( {
	valHooks: {
		option: {
			get: function( elem ) {

				var val = jQuery.find.attr( elem, "value" );
				return val != null ?
					val :

					// Support: IE <=10 - 11 only
					// option.text throws exceptions (#14686, #14858)
					// Strip and collapse whitespace
					// https://html.spec.whatwg.org/#strip-and-collapse-whitespace
					stripAndCollapse( jQuery.text( elem ) );
			}
		},
		select: {
			get: function( elem ) {
				var value, option, i,
					options = elem.options,
					index = elem.selectedIndex,
					one = elem.type === "select-one",
					values = one ? null : [],
					max = one ? index + 1 : options.length;

				if ( index < 0 ) {
					i = max;

				} else {
					i = one ? index : 0;
				}

				// Loop through all the selected options
				for ( ; i < max; i++ ) {
					option = options[ i ];

					// Support: IE <=9 only
					// IE8-9 doesn't update selected after form reset (#2551)
					if ( ( option.selected || i === index ) &&

							// Don't return options that are disabled or in a disabled optgroup
							!option.disabled &&
							( !option.parentNode.disabled ||
								!nodeName( option.parentNode, "optgroup" ) ) ) {

						// Get the specific value for the option
						value = jQuery( option ).val();

						// We don't need an array for one selects
						if ( one ) {
							return value;
						}

						// Multi-Selects return an array
						values.push( value );
					}
				}

				return values;
			},

			set: function( elem, value ) {
				var optionSet, option,
					options = elem.options,
					values = jQuery.makeArray( value ),
					i = options.length;

				while ( i-- ) {
					option = options[ i ];

					/* eslint-disable no-cond-assign */

					if ( option.selected =
						jQuery.inArray( jQuery.valHooks.option.get( option ), values ) > -1
					) {
						optionSet = true;
					}

					/* eslint-enable no-cond-assign */
				}

				// Force browsers to behave consistently when non-matching value is set
				if ( !optionSet ) {
					elem.selectedIndex = -1;
				}
				return values;
			}
		}
	}
} );

// Radios and checkboxes getter/setter
jQuery.each( [ "radio", "checkbox" ], function() {
	jQuery.valHooks[ this ] = {
		set: function( elem, value ) {
			if ( Array.isArray( value ) ) {
				return ( elem.checked = jQuery.inArray( jQuery( elem ).val(), value ) > -1 );
			}
		}
	};
	if ( !support.checkOn ) {
		jQuery.valHooks[ this ].get = function( elem ) {
			return elem.getAttribute( "value" ) === null ? "on" : elem.value;
		};
	}
} );




// Return jQuery for attributes-only inclusion


support.focusin = "onfocusin" in window;


var rfocusMorph = /^(?:focusinfocus|focusoutblur)$/,
	stopPropagationCallback = function( e ) {
		e.stopPropagation();
	};

jQuery.extend( jQuery.event, {

	trigger: function( event, data, elem, onlyHandlers ) {

		var i, cur, tmp, bubbleType, ontype, handle, special, lastElement,
			eventPath = [ elem || document ],
			type = hasOwn.call( event, "type" ) ? event.type : event,
			namespaces = hasOwn.call( event, "namespace" ) ? event.namespace.split( "." ) : [];

		cur = lastElement = tmp = elem = elem || document;

		// Don't do events on text and comment nodes
		if ( elem.nodeType === 3 || elem.nodeType === 8 ) {
			return;
		}

		// focus/blur morphs to focusin/out; ensure we're not firing them right now
		if ( rfocusMorph.test( type + jQuery.event.triggered ) ) {
			return;
		}

		if ( type.indexOf( "." ) > -1 ) {

			// Namespaced trigger; create a regexp to match event type in handle()
			namespaces = type.split( "." );
			type = namespaces.shift();
			namespaces.sort();
		}
		ontype = type.indexOf( ":" ) < 0 && "on" + type;

		// Caller can pass in a jQuery.Event object, Object, or just an event type string
		event = event[ jQuery.expando ] ?
			event :
			new jQuery.Event( type, typeof event === "object" && event );

		// Trigger bitmask: & 1 for native handlers; & 2 for jQuery (always true)
		event.isTrigger = onlyHandlers ? 2 : 3;
		event.namespace = namespaces.join( "." );
		event.rnamespace = event.namespace ?
			new RegExp( "(^|\\.)" + namespaces.join( "\\.(?:.*\\.|)" ) + "(\\.|$)" ) :
			null;

		// Clean up the event in case it is being reused
		event.result = undefined;
		if ( !event.target ) {
			event.target = elem;
		}

		// Clone any incoming data and prepend the event, creating the handler arg list
		data = data == null ?
			[ event ] :
			jQuery.makeArray( data, [ event ] );

		// Allow special events to draw outside the lines
		special = jQuery.event.special[ type ] || {};
		if ( !onlyHandlers && special.trigger && special.trigger.apply( elem, data ) === false ) {
			return;
		}

		// Determine event propagation path in advance, per W3C events spec (#9951)
		// Bubble up to document, then to window; watch for a global ownerDocument var (#9724)
		if ( !onlyHandlers && !special.noBubble && !isWindow( elem ) ) {

			bubbleType = special.delegateType || type;
			if ( !rfocusMorph.test( bubbleType + type ) ) {
				cur = cur.parentNode;
			}
			for ( ; cur; cur = cur.parentNode ) {
				eventPath.push( cur );
				tmp = cur;
			}

			// Only add window if we got to document (e.g., not plain obj or detached DOM)
			if ( tmp === ( elem.ownerDocument || document ) ) {
				eventPath.push( tmp.defaultView || tmp.parentWindow || window );
			}
		}

		// Fire handlers on the event path
		i = 0;
		while ( ( cur = eventPath[ i++ ] ) && !event.isPropagationStopped() ) {
			lastElement = cur;
			event.type = i > 1 ?
				bubbleType :
				special.bindType || type;

			// jQuery handler
			handle = (
					dataPriv.get( cur, "events" ) || Object.create( null )
				)[ event.type ] &&
				dataPriv.get( cur, "handle" );
			if ( handle ) {
				handle.apply( cur, data );
			}

			// Native handler
			handle = ontype && cur[ ontype ];
			if ( handle && handle.apply && acceptData( cur ) ) {
				event.result = handle.apply( cur, data );
				if ( event.result === false ) {
					event.preventDefault();
				}
			}
		}
		event.type = type;

		// If nobody prevented the default action, do it now
		if ( !onlyHandlers && !event.isDefaultPrevented() ) {

			if ( ( !special._default ||
				special._default.apply( eventPath.pop(), data ) === false ) &&
				acceptData( elem ) ) {

				// Call a native DOM method on the target with the same name as the event.
				// Don't do default actions on window, that's where global variables be (#6170)
				if ( ontype && isFunction( elem[ type ] ) && !isWindow( elem ) ) {

					// Don't re-trigger an onFOO event when we call its FOO() method
					tmp = elem[ ontype ];

					if ( tmp ) {
						elem[ ontype ] = null;
					}

					// Prevent re-triggering of the same event, since we already bubbled it above
					jQuery.event.triggered = type;

					if ( event.isPropagationStopped() ) {
						lastElement.addEventListener( type, stopPropagationCallback );
					}

					elem[ type ]();

					if ( event.isPropagationStopped() ) {
						lastElement.removeEventListener( type, stopPropagationCallback );
					}

					jQuery.event.triggered = undefined;

					if ( tmp ) {
						elem[ ontype ] = tmp;
					}
				}
			}
		}

		return event.result;
	},

	// Piggyback on a donor event to simulate a different one
	// Used only for `focus(in | out)` events
	simulate: function( type, elem, event ) {
		var e = jQuery.extend(
			new jQuery.Event(),
			event,
			{
				type: type,
				isSimulated: true
			}
		);

		jQuery.event.trigger( e, null, elem );
	}

} );

jQuery.fn.extend( {

	trigger: function( type, data ) {
		return this.each( function() {
			jQuery.event.trigger( type, data, this );
		} );
	},
	triggerHandler: function( type, data ) {
		var elem = this[ 0 ];
		if ( elem ) {
			return jQuery.event.trigger( type, data, elem, true );
		}
	}
} );


// Support: Firefox <=44
// Firefox doesn't have focus(in | out) events
// Related ticket - https://bugzilla.mozilla.org/show_bug.cgi?id=687787
//
// Support: Chrome <=48 - 49, Safari <=9.0 - 9.1
// focus(in | out) events fire after focus & blur events,
// which is spec violation - http://www.w3.org/TR/DOM-Level-3-Events/#events-focusevent-event-order
// Related ticket - https://bugs.chromium.org/p/chromium/issues/detail?id=449857
if ( !support.focusin ) {
	jQuery.each( { focus: "focusin", blur: "focusout" }, function( orig, fix ) {

		// Attach a single capturing handler on the document while someone wants focusin/focusout
		var handler = function( event ) {
			jQuery.event.simulate( fix, event.target, jQuery.event.fix( event ) );
		};

		jQuery.event.special[ fix ] = {
			setup: function() {

				// Handle: regular nodes (via `this.ownerDocument`), window
				// (via `this.document`) & document (via `this`).
				var doc = this.ownerDocument || this.document || this,
					attaches = dataPriv.access( doc, fix );

				if ( !attaches ) {
					doc.addEventListener( orig, handler, true );
				}
				dataPriv.access( doc, fix, ( attaches || 0 ) + 1 );
			},
			teardown: function() {
				var doc = this.ownerDocument || this.document || this,
					attaches = dataPriv.access( doc, fix ) - 1;

				if ( !attaches ) {
					doc.removeEventListener( orig, handler, true );
					dataPriv.remove( doc, fix );

				} else {
					dataPriv.access( doc, fix, attaches );
				}
			}
		};
	} );
}
var location = window.location;

var nonce = { guid: Date.now() };

var rquery = ( /\?/ );



// Cross-browser xml parsing
jQuery.parseXML = function( data ) {
	var xml;
	if ( !data || typeof data !== "string" ) {
		return null;
	}

	// Support: IE 9 - 11 only
	// IE throws on parseFromString with invalid input.
	try {
		xml = ( new window.DOMParser() ).parseFromString( data, "text/xml" );
	} catch ( e ) {
		xml = undefined;
	}

	if ( !xml || xml.getElementsByTagName( "parsererror" ).length ) {
		jQuery.error( "Invalid XML: " + data );
	}
	return xml;
};


var
	rbracket = /\[\]$/,
	rCRLF = /\r?\n/g,
	rsubmitterTypes = /^(?:submit|button|image|reset|file)$/i,
	rsubmittable = /^(?:input|select|textarea|keygen)/i;

function buildParams( prefix, obj, traditional, add ) {
	var name;

	if ( Array.isArray( obj ) ) {

		// Serialize array item.
		jQuery.each( obj, function( i, v ) {
			if ( traditional || rbracket.test( prefix ) ) {

				// Treat each array item as a scalar.
				add( prefix, v );

			} else {

				// Item is non-scalar (array or object), encode its numeric index.
				buildParams(
					prefix + "[" + ( typeof v === "object" && v != null ? i : "" ) + "]",
					v,
					traditional,
					add
				);
			}
		} );

	} else if ( !traditional && toType( obj ) === "object" ) {

		// Serialize object item.
		for ( name in obj ) {
			buildParams( prefix + "[" + name + "]", obj[ name ], traditional, add );
		}

	} else {

		// Serialize scalar item.
		add( prefix, obj );
	}
}

// Serialize an array of form elements or a set of
// key/values into a query string
jQuery.param = function( a, traditional ) {
	var prefix,
		s = [],
		add = function( key, valueOrFunction ) {

			// If value is a function, invoke it and use its return value
			var value = isFunction( valueOrFunction ) ?
				valueOrFunction() :
				valueOrFunction;

			s[ s.length ] = encodeURIComponent( key ) + "=" +
				encodeURIComponent( value == null ? "" : value );
		};

	if ( a == null ) {
		return "";
	}

	// If an array was passed in, assume that it is an array of form elements.
	if ( Array.isArray( a ) || ( a.jquery && !jQuery.isPlainObject( a ) ) ) {

		// Serialize the form elements
		jQuery.each( a, function() {
			add( this.name, this.value );
		} );

	} else {

		// If traditional, encode the "old" way (the way 1.3.2 or older
		// did it), otherwise encode params recursively.
		for ( prefix in a ) {
			buildParams( prefix, a[ prefix ], traditional, add );
		}
	}

	// Return the resulting serialization
	return s.join( "&" );
};

jQuery.fn.extend( {
	serialize: function() {
		return jQuery.param( this.serializeArray() );
	},
	serializeArray: function() {
		return this.map( function() {

			// Can add propHook for "elements" to filter or add form elements
			var elements = jQuery.prop( this, "elements" );
			return elements ? jQuery.makeArray( elements ) : this;
		} )
		.filter( function() {
			var type = this.type;

			// Use .is( ":disabled" ) so that fieldset[disabled] works
			return this.name && !jQuery( this ).is( ":disabled" ) &&
				rsubmittable.test( this.nodeName ) && !rsubmitterTypes.test( type ) &&
				( this.checked || !rcheckableType.test( type ) );
		} )
		.map( function( _i, elem ) {
			var val = jQuery( this ).val();

			if ( val == null ) {
				return null;
			}

			if ( Array.isArray( val ) ) {
				return jQuery.map( val, function( val ) {
					return { name: elem.name, value: val.replace( rCRLF, "\r\n" ) };
				} );
			}

			return { name: elem.name, value: val.replace( rCRLF, "\r\n" ) };
		} ).get();
	}
} );


var
	r20 = /%20/g,
	rhash = /#.*$/,
	rantiCache = /([?&])_=[^&]*/,
	rheaders = /^(.*?):[ \t]*([^\r\n]*)$/mg,

	// #7653, #8125, #8152: local protocol detection
	rlocalProtocol = /^(?:about|app|app-storage|.+-extension|file|res|widget):$/,
	rnoContent = /^(?:GET|HEAD)$/,
	rprotocol = /^\/\//,

	/* Prefilters
	 * 1) They are useful to introduce custom dataTypes (see ajax/jsonp.js for an example)
	 * 2) These are called:
	 *    - BEFORE asking for a transport
	 *    - AFTER param serialization (s.data is a string if s.processData is true)
	 * 3) key is the dataType
	 * 4) the catchall symbol "*" can be used
	 * 5) execution will start with transport dataType and THEN continue down to "*" if needed
	 */
	prefilters = {},

	/* Transports bindings
	 * 1) key is the dataType
	 * 2) the catchall symbol "*" can be used
	 * 3) selection will start with transport dataType and THEN go to "*" if needed
	 */
	transports = {},

	// Avoid comment-prolog char sequence (#10098); must appease lint and evade compression
	allTypes = "*/".concat( "*" ),

	// Anchor tag for parsing the document origin
	originAnchor = document.createElement( "a" );
	originAnchor.href = location.href;

// Base "constructor" for jQuery.ajaxPrefilter and jQuery.ajaxTransport
function addToPrefiltersOrTransports( structure ) {

	// dataTypeExpression is optional and defaults to "*"
	return function( dataTypeExpression, func ) {

		if ( typeof dataTypeExpression !== "string" ) {
			func = dataTypeExpression;
			dataTypeExpression = "*";
		}

		var dataType,
			i = 0,
			dataTypes = dataTypeExpression.toLowerCase().match( rnothtmlwhite ) || [];

		if ( isFunction( func ) ) {

			// For each dataType in the dataTypeExpression
			while ( ( dataType = dataTypes[ i++ ] ) ) {

				// Prepend if requested
				if ( dataType[ 0 ] === "+" ) {
					dataType = dataType.slice( 1 ) || "*";
					( structure[ dataType ] = structure[ dataType ] || [] ).unshift( func );

				// Otherwise append
				} else {
					( structure[ dataType ] = structure[ dataType ] || [] ).push( func );
				}
			}
		}
	};
}

// Base inspection function for prefilters and transports
function inspectPrefiltersOrTransports( structure, options, originalOptions, jqXHR ) {

	var inspected = {},
		seekingTransport = ( structure === transports );

	function inspect( dataType ) {
		var selected;
		inspected[ dataType ] = true;
		jQuery.each( structure[ dataType ] || [], function( _, prefilterOrFactory ) {
			var dataTypeOrTransport = prefilterOrFactory( options, originalOptions, jqXHR );
			if ( typeof dataTypeOrTransport === "string" &&
				!seekingTransport && !inspected[ dataTypeOrTransport ] ) {

				options.dataTypes.unshift( dataTypeOrTransport );
				inspect( dataTypeOrTransport );
				return false;
			} else if ( seekingTransport ) {
				return !( selected = dataTypeOrTransport );
			}
		} );
		return selected;
	}

	return inspect( options.dataTypes[ 0 ] ) || !inspected[ "*" ] && inspect( "*" );
}

// A special extend for ajax options
// that takes "flat" options (not to be deep extended)
// Fixes #9887
function ajaxExtend( target, src ) {
	var key, deep,
		flatOptions = jQuery.ajaxSettings.flatOptions || {};

	for ( key in src ) {
		if ( src[ key ] !== undefined ) {
			( flatOptions[ key ] ? target : ( deep || ( deep = {} ) ) )[ key ] = src[ key ];
		}
	}
	if ( deep ) {
		jQuery.extend( true, target, deep );
	}

	return target;
}

/* Handles responses to an ajax request:
 * - finds the right dataType (mediates between content-type and expected dataType)
 * - returns the corresponding response
 */
function ajaxHandleResponses( s, jqXHR, responses ) {

	var ct, type, finalDataType, firstDataType,
		contents = s.contents,
		dataTypes = s.dataTypes;

	// Remove auto dataType and get content-type in the process
	while ( dataTypes[ 0 ] === "*" ) {
		dataTypes.shift();
		if ( ct === undefined ) {
			ct = s.mimeType || jqXHR.getResponseHeader( "Content-Type" );
		}
	}

	// Check if we're dealing with a known content-type
	if ( ct ) {
		for ( type in contents ) {
			if ( contents[ type ] && contents[ type ].test( ct ) ) {
				dataTypes.unshift( type );
				break;
			}
		}
	}

	// Check to see if we have a response for the expected dataType
	if ( dataTypes[ 0 ] in responses ) {
		finalDataType = dataTypes[ 0 ];
	} else {

		// Try convertible dataTypes
		for ( type in responses ) {
			if ( !dataTypes[ 0 ] || s.converters[ type + " " + dataTypes[ 0 ] ] ) {
				finalDataType = type;
				break;
			}
			if ( !firstDataType ) {
				firstDataType = type;
			}
		}

		// Or just use first one
		finalDataType = finalDataType || firstDataType;
	}

	// If we found a dataType
	// We add the dataType to the list if needed
	// and return the corresponding response
	if ( finalDataType ) {
		if ( finalDataType !== dataTypes[ 0 ] ) {
			dataTypes.unshift( finalDataType );
		}
		return responses[ finalDataType ];
	}
}

/* Chain conversions given the request and the original response
 * Also sets the responseXXX fields on the jqXHR instance
 */
function ajaxConvert( s, response, jqXHR, isSuccess ) {
	var conv2, current, conv, tmp, prev,
		converters = {},

		// Work with a copy of dataTypes in case we need to modify it for conversion
		dataTypes = s.dataTypes.slice();

	// Create converters map with lowercased keys
	if ( dataTypes[ 1 ] ) {
		for ( conv in s.converters ) {
			converters[ conv.toLowerCase() ] = s.converters[ conv ];
		}
	}

	current = dataTypes.shift();

	// Convert to each sequential dataType
	while ( current ) {

		if ( s.responseFields[ current ] ) {
			jqXHR[ s.responseFields[ current ] ] = response;
		}

		// Apply the dataFilter if provided
		if ( !prev && isSuccess && s.dataFilter ) {
			response = s.dataFilter( response, s.dataType );
		}

		prev = current;
		current = dataTypes.shift();

		if ( current ) {

			// There's only work to do if current dataType is non-auto
			if ( current === "*" ) {

				current = prev;

			// Convert response if prev dataType is non-auto and differs from current
			} else if ( prev !== "*" && prev !== current ) {

				// Seek a direct converter
				conv = converters[ prev + " " + current ] || converters[ "* " + current ];

				// If none found, seek a pair
				if ( !conv ) {
					for ( conv2 in converters ) {

						// If conv2 outputs current
						tmp = conv2.split( " " );
						if ( tmp[ 1 ] === current ) {

							// If prev can be converted to accepted input
							conv = converters[ prev + " " + tmp[ 0 ] ] ||
								converters[ "* " + tmp[ 0 ] ];
							if ( conv ) {

								// Condense equivalence converters
								if ( conv === true ) {
									conv = converters[ conv2 ];

								// Otherwise, insert the intermediate dataType
								} else if ( converters[ conv2 ] !== true ) {
									current = tmp[ 0 ];
									dataTypes.unshift( tmp[ 1 ] );
								}
								break;
							}
						}
					}
				}

				// Apply converter (if not an equivalence)
				if ( conv !== true ) {

					// Unless errors are allowed to bubble, catch and return them
					if ( conv && s.throws ) {
						response = conv( response );
					} else {
						try {
							response = conv( response );
						} catch ( e ) {
							return {
								state: "parsererror",
								error: conv ? e : "No conversion from " + prev + " to " + current
							};
						}
					}
				}
			}
		}
	}

	return { state: "success", data: response };
}

jQuery.extend( {

	// Counter for holding the number of active queries
	active: 0,

	// Last-Modified header cache for next request
	lastModified: {},
	etag: {},

	ajaxSettings: {
		url: location.href,
		type: "GET",
		isLocal: rlocalProtocol.test( location.protocol ),
		global: true,
		processData: true,
		async: true,
		contentType: "application/x-www-form-urlencoded; charset=UTF-8",

		/*
		timeout: 0,
		data: null,
		dataType: null,
		username: null,
		password: null,
		cache: null,
		throws: false,
		traditional: false,
		headers: {},
		*/

		accepts: {
			"*": allTypes,
			text: "text/plain",
			html: "text/html",
			xml: "application/xml, text/xml",
			json: "application/json, text/javascript"
		},

		contents: {
			xml: /\bxml\b/,
			html: /\bhtml/,
			json: /\bjson\b/
		},

		responseFields: {
			xml: "responseXML",
			text: "responseText",
			json: "responseJSON"
		},

		// Data converters
		// Keys separate source (or catchall "*") and destination types with a single space
		converters: {

			// Convert anything to text
			"* text": String,

			// Text to html (true = no transformation)
			"text html": true,

			// Evaluate text as a json expression
			"text json": JSON.parse,

			// Parse text as xml
			"text xml": jQuery.parseXML
		},

		// For options that shouldn't be deep extended:
		// you can add your own custom options here if
		// and when you create one that shouldn't be
		// deep extended (see ajaxExtend)
		flatOptions: {
			url: true,
			context: true
		}
	},

	// Creates a full fledged settings object into target
	// with both ajaxSettings and settings fields.
	// If target is omitted, writes into ajaxSettings.
	ajaxSetup: function( target, settings ) {
		return settings ?

			// Building a settings object
			ajaxExtend( ajaxExtend( target, jQuery.ajaxSettings ), settings ) :

			// Extending ajaxSettings
			ajaxExtend( jQuery.ajaxSettings, target );
	},

	ajaxPrefilter: addToPrefiltersOrTransports( prefilters ),
	ajaxTransport: addToPrefiltersOrTransports( transports ),

	// Main method
	ajax: function( url, options ) {

		// If url is an object, simulate pre-1.5 signature
		if ( typeof url === "object" ) {
			options = url;
			url = undefined;
		}

		// Force options to be an object
		options = options || {};

		var transport,

			// URL without anti-cache param
			cacheURL,

			// Response headers
			responseHeadersString,
			responseHeaders,

			// timeout handle
			timeoutTimer,

			// Url cleanup var
			urlAnchor,

			// Request state (becomes false upon send and true upon completion)
			completed,

			// To know if global events are to be dispatched
			fireGlobals,

			// Loop variable
			i,

			// uncached part of the url
			uncached,

			// Create the final options object
			s = jQuery.ajaxSetup( {}, options ),

			// Callbacks context
			callbackContext = s.context || s,

			// Context for global events is callbackContext if it is a DOM node or jQuery collection
			globalEventContext = s.context &&
				( callbackContext.nodeType || callbackContext.jquery ) ?
					jQuery( callbackContext ) :
					jQuery.event,

			// Deferreds
			deferred = jQuery.Deferred(),
			completeDeferred = jQuery.Callbacks( "once memory" ),

			// Status-dependent callbacks
			statusCode = s.statusCode || {},

			// Headers (they are sent all at once)
			requestHeaders = {},
			requestHeadersNames = {},

			// Default abort message
			strAbort = "canceled",

			// Fake xhr
			jqXHR = {
				readyState: 0,

				// Builds headers hashtable if needed
				getResponseHeader: function( key ) {
					var match;
					if ( completed ) {
						if ( !responseHeaders ) {
							responseHeaders = {};
							while ( ( match = rheaders.exec( responseHeadersString ) ) ) {
								responseHeaders[ match[ 1 ].toLowerCase() + " " ] =
									( responseHeaders[ match[ 1 ].toLowerCase() + " " ] || [] )
										.concat( match[ 2 ] );
							}
						}
						match = responseHeaders[ key.toLowerCase() + " " ];
					}
					return match == null ? null : match.join( ", " );
				},

				// Raw string
				getAllResponseHeaders: function() {
					return completed ? responseHeadersString : null;
				},

				// Caches the header
				setRequestHeader: function( name, value ) {
					if ( completed == null ) {
						name = requestHeadersNames[ name.toLowerCase() ] =
							requestHeadersNames[ name.toLowerCase() ] || name;
						requestHeaders[ name ] = value;
					}
					return this;
				},

				// Overrides response content-type header
				overrideMimeType: function( type ) {
					if ( completed == null ) {
						s.mimeType = type;
					}
					return this;
				},

				// Status-dependent callbacks
				statusCode: function( map ) {
					var code;
					if ( map ) {
						if ( completed ) {

							// Execute the appropriate callbacks
							jqXHR.always( map[ jqXHR.status ] );
						} else {

							// Lazy-add the new callbacks in a way that preserves old ones
							for ( code in map ) {
								statusCode[ code ] = [ statusCode[ code ], map[ code ] ];
							}
						}
					}
					return this;
				},

				// Cancel the request
				abort: function( statusText ) {
					var finalText = statusText || strAbort;
					if ( transport ) {
						transport.abort( finalText );
					}
					done( 0, finalText );
					return this;
				}
			};

		// Attach deferreds
		deferred.promise( jqXHR );

		// Add protocol if not provided (prefilters might expect it)
		// Handle falsy url in the settings object (#10093: consistency with old signature)
		// We also use the url parameter if available
		s.url = ( ( url || s.url || location.href ) + "" )
			.replace( rprotocol, location.protocol + "//" );

		// Alias method option to type as per ticket #12004
		s.type = options.method || options.type || s.method || s.type;

		// Extract dataTypes list
		s.dataTypes = ( s.dataType || "*" ).toLowerCase().match( rnothtmlwhite ) || [ "" ];

		// A cross-domain request is in order when the origin doesn't match the current origin.
		if ( s.crossDomain == null ) {
			urlAnchor = document.createElement( "a" );

			// Support: IE <=8 - 11, Edge 12 - 15
			// IE throws exception on accessing the href property if url is malformed,
			// e.g. http://example.com:80x/
			try {
				urlAnchor.href = s.url;

				// Support: IE <=8 - 11 only
				// Anchor's host property isn't correctly set when s.url is relative
				urlAnchor.href = urlAnchor.href;
				s.crossDomain = originAnchor.protocol + "//" + originAnchor.host !==
					urlAnchor.protocol + "//" + urlAnchor.host;
			} catch ( e ) {

				// If there is an error parsing the URL, assume it is crossDomain,
				// it can be rejected by the transport if it is invalid
				s.crossDomain = true;
			}
		}

		// Convert data if not already a string
		if ( s.data && s.processData && typeof s.data !== "string" ) {
			s.data = jQuery.param( s.data, s.traditional );
		}

		// Apply prefilters
		inspectPrefiltersOrTransports( prefilters, s, options, jqXHR );

		// If request was aborted inside a prefilter, stop there
		if ( completed ) {
			return jqXHR;
		}

		// We can fire global events as of now if asked to
		// Don't fire events if jQuery.event is undefined in an AMD-usage scenario (#15118)
		fireGlobals = jQuery.event && s.global;

		// Watch for a new set of requests
		if ( fireGlobals && jQuery.active++ === 0 ) {
			jQuery.event.trigger( "ajaxStart" );
		}

		// Uppercase the type
		s.type = s.type.toUpperCase();

		// Determine if request has content
		s.hasContent = !rnoContent.test( s.type );

		// Save the URL in case we're toying with the If-Modified-Since
		// and/or If-None-Match header later on
		// Remove hash to simplify url manipulation
		cacheURL = s.url.replace( rhash, "" );

		// More options handling for requests with no content
		if ( !s.hasContent ) {

			// Remember the hash so we can put it back
			uncached = s.url.slice( cacheURL.length );

			// If data is available and should be processed, append data to url
			if ( s.data && ( s.processData || typeof s.data === "string" ) ) {
				cacheURL += ( rquery.test( cacheURL ) ? "&" : "?" ) + s.data;

				// #9682: remove data so that it's not used in an eventual retry
				delete s.data;
			}

			// Add or update anti-cache param if needed
			if ( s.cache === false ) {
				cacheURL = cacheURL.replace( rantiCache, "$1" );
				uncached = ( rquery.test( cacheURL ) ? "&" : "?" ) + "_=" + ( nonce.guid++ ) +
					uncached;
			}

			// Put hash and anti-cache on the URL that will be requested (gh-1732)
			s.url = cacheURL + uncached;

		// Change '%20' to '+' if this is encoded form body content (gh-2658)
		} else if ( s.data && s.processData &&
			( s.contentType || "" ).indexOf( "application/x-www-form-urlencoded" ) === 0 ) {
			s.data = s.data.replace( r20, "+" );
		}

		// Set the If-Modified-Since and/or If-None-Match header, if in ifModified mode.
		if ( s.ifModified ) {
			if ( jQuery.lastModified[ cacheURL ] ) {
				jqXHR.setRequestHeader( "If-Modified-Since", jQuery.lastModified[ cacheURL ] );
			}
			if ( jQuery.etag[ cacheURL ] ) {
				jqXHR.setRequestHeader( "If-None-Match", jQuery.etag[ cacheURL ] );
			}
		}

		// Set the correct header, if data is being sent
		if ( s.data && s.hasContent && s.contentType !== false || options.contentType ) {
			jqXHR.setRequestHeader( "Content-Type", s.contentType );
		}

		// Set the Accepts header for the server, depending on the dataType
		jqXHR.setRequestHeader(
			"Accept",
			s.dataTypes[ 0 ] && s.accepts[ s.dataTypes[ 0 ] ] ?
				s.accepts[ s.dataTypes[ 0 ] ] +
					( s.dataTypes[ 0 ] !== "*" ? ", " + allTypes + "; q=0.01" : "" ) :
				s.accepts[ "*" ]
		);

		// Check for headers option
		for ( i in s.headers ) {
			jqXHR.setRequestHeader( i, s.headers[ i ] );
		}

		// Allow custom headers/mimetypes and early abort
		if ( s.beforeSend &&
			( s.beforeSend.call( callbackContext, jqXHR, s ) === false || completed ) ) {

			// Abort if not done already and return
			return jqXHR.abort();
		}

		// Aborting is no longer a cancellation
		strAbort = "abort";

		// Install callbacks on deferreds
		completeDeferred.add( s.complete );
		jqXHR.done( s.success );
		jqXHR.fail( s.error );

		// Get transport
		transport = inspectPrefiltersOrTransports( transports, s, options, jqXHR );

		// If no transport, we auto-abort
		if ( !transport ) {
			done( -1, "No Transport" );
		} else {
			jqXHR.readyState = 1;

			// Send global event
			if ( fireGlobals ) {
				globalEventContext.trigger( "ajaxSend", [ jqXHR, s ] );
			}

			// If request was aborted inside ajaxSend, stop there
			if ( completed ) {
				return jqXHR;
			}

			// Timeout
			if ( s.async && s.timeout > 0 ) {
				timeoutTimer = window.setTimeout( function() {
					jqXHR.abort( "timeout" );
				}, s.timeout );
			}

			try {
				completed = false;
				transport.send( requestHeaders, done );
			} catch ( e ) {

				// Rethrow post-completion exceptions
				if ( completed ) {
					throw e;
				}

				// Propagate others as results
				done( -1, e );
			}
		}

		// Callback for when everything is done
		function done( status, nativeStatusText, responses, headers ) {
			var isSuccess, success, error, response, modified,
				statusText = nativeStatusText;

			// Ignore repeat invocations
			if ( completed ) {
				return;
			}

			completed = true;

			// Clear timeout if it exists
			if ( timeoutTimer ) {
				window.clearTimeout( timeoutTimer );
			}

			// Dereference transport for early garbage collection
			// (no matter how long the jqXHR object will be used)
			transport = undefined;

			// Cache response headers
			responseHeadersString = headers || "";

			// Set readyState
			jqXHR.readyState = status > 0 ? 4 : 0;

			// Determine if successful
			isSuccess = status >= 200 && status < 300 || status === 304;

			// Get response data
			if ( responses ) {
				response = ajaxHandleResponses( s, jqXHR, responses );
			}

			// Use a noop converter for missing script
			if ( !isSuccess && jQuery.inArray( "script", s.dataTypes ) > -1 ) {
				s.converters[ "text script" ] = function() {};
			}

			// Convert no matter what (that way responseXXX fields are always set)
			response = ajaxConvert( s, response, jqXHR, isSuccess );

			// If successful, handle type chaining
			if ( isSuccess ) {

				// Set the If-Modified-Since and/or If-None-Match header, if in ifModified mode.
				if ( s.ifModified ) {
					modified = jqXHR.getResponseHeader( "Last-Modified" );
					if ( modified ) {
						jQuery.lastModified[ cacheURL ] = modified;
					}
					modified = jqXHR.getResponseHeader( "etag" );
					if ( modified ) {
						jQuery.etag[ cacheURL ] = modified;
					}
				}

				// if no content
				if ( status === 204 || s.type === "HEAD" ) {
					statusText = "nocontent";

				// if not modified
				} else if ( status === 304 ) {
					statusText = "notmodified";

				// If we have data, let's convert it
				} else {
					statusText = response.state;
					success = response.data;
					error = response.error;
					isSuccess = !error;
				}
			} else {

				// Extract error from statusText and normalize for non-aborts
				error = statusText;
				if ( status || !statusText ) {
					statusText = "error";
					if ( status < 0 ) {
						status = 0;
					}
				}
			}

			// Set data for the fake xhr object
			jqXHR.status = status;
			jqXHR.statusText = ( nativeStatusText || statusText ) + "";

			// Success/Error
			if ( isSuccess ) {
				deferred.resolveWith( callbackContext, [ success, statusText, jqXHR ] );
			} else {
				deferred.rejectWith( callbackContext, [ jqXHR, statusText, error ] );
			}

			// Status-dependent callbacks
			jqXHR.statusCode( statusCode );
			statusCode = undefined;

			if ( fireGlobals ) {
				globalEventContext.trigger( isSuccess ? "ajaxSuccess" : "ajaxError",
					[ jqXHR, s, isSuccess ? success : error ] );
			}

			// Complete
			completeDeferred.fireWith( callbackContext, [ jqXHR, statusText ] );

			if ( fireGlobals ) {
				globalEventContext.trigger( "ajaxComplete", [ jqXHR, s ] );

				// Handle the global AJAX counter
				if ( !( --jQuery.active ) ) {
					jQuery.event.trigger( "ajaxStop" );
				}
			}
		}

		return jqXHR;
	},

	getJSON: function( url, data, callback ) {
		return jQuery.get( url, data, callback, "json" );
	},

	getScript: function( url, callback ) {
		return jQuery.get( url, undefined, callback, "script" );
	}
} );

jQuery.each( [ "get", "post" ], function( _i, method ) {
	jQuery[ method ] = function( url, data, callback, type ) {

		// Shift arguments if data argument was omitted
		if ( isFunction( data ) ) {
			type = type || callback;
			callback = data;
			data = undefined;
		}

		// The url can be an options object (which then must have .url)
		return jQuery.ajax( jQuery.extend( {
			url: url,
			type: method,
			dataType: type,
			data: data,
			success: callback
		}, jQuery.isPlainObject( url ) && url ) );
	};
} );

jQuery.ajaxPrefilter( function( s ) {
	var i;
	for ( i in s.headers ) {
		if ( i.toLowerCase() === "content-type" ) {
			s.contentType = s.headers[ i ] || "";
		}
	}
} );


jQuery._evalUrl = function( url, options, doc ) {
	return jQuery.ajax( {
		url: url,

		// Make this explicit, since user can override this through ajaxSetup (#11264)
		type: "GET",
		dataType: "script",
		cache: true,
		async: false,
		global: false,

		// Only evaluate the response if it is successful (gh-4126)
		// dataFilter is not invoked for failure responses, so using it instead
		// of the default converter is kludgy but it works.
		converters: {
			"text script": function() {}
		},
		dataFilter: function( response ) {
			jQuery.globalEval( response, options, doc );
		}
	} );
};


jQuery.fn.extend( {
	wrapAll: function( html ) {
		var wrap;

		if ( this[ 0 ] ) {
			if ( isFunction( html ) ) {
				html = html.call( this[ 0 ] );
			}

			// The elements to wrap the target around
			wrap = jQuery( html, this[ 0 ].ownerDocument ).eq( 0 ).clone( true );

			if ( this[ 0 ].parentNode ) {
				wrap.insertBefore( this[ 0 ] );
			}

			wrap.map( function() {
				var elem = this;

				while ( elem.firstElementChild ) {
					elem = elem.firstElementChild;
				}

				return elem;
			} ).append( this );
		}

		return this;
	},

	wrapInner: function( html ) {
		if ( isFunction( html ) ) {
			return this.each( function( i ) {
				jQuery( this ).wrapInner( html.call( this, i ) );
			} );
		}

		return this.each( function() {
			var self = jQuery( this ),
				contents = self.contents();

			if ( contents.length ) {
				contents.wrapAll( html );

			} else {
				self.append( html );
			}
		} );
	},

	wrap: function( html ) {
		var htmlIsFunction = isFunction( html );

		return this.each( function( i ) {
			jQuery( this ).wrapAll( htmlIsFunction ? html.call( this, i ) : html );
		} );
	},

	unwrap: function( selector ) {
		this.parent( selector ).not( "body" ).each( function() {
			jQuery( this ).replaceWith( this.childNodes );
		} );
		return this;
	}
} );


jQuery.expr.pseudos.hidden = function( elem ) {
	return !jQuery.expr.pseudos.visible( elem );
};
jQuery.expr.pseudos.visible = function( elem ) {
	return !!( elem.offsetWidth || elem.offsetHeight || elem.getClientRects().length );
};




jQuery.ajaxSettings.xhr = function() {
	try {
		return new window.XMLHttpRequest();
	} catch ( e ) {}
};

var xhrSuccessStatus = {

		// File protocol always yields status code 0, assume 200
		0: 200,

		// Support: IE <=9 only
		// #1450: sometimes IE returns 1223 when it should be 204
		1223: 204
	},
	xhrSupported = jQuery.ajaxSettings.xhr();

support.cors = !!xhrSupported && ( "withCredentials" in xhrSupported );
support.ajax = xhrSupported = !!xhrSupported;

jQuery.ajaxTransport( function( options ) {
	var callback, errorCallback;

	// Cross domain only allowed if supported through XMLHttpRequest
	if ( support.cors || xhrSupported && !options.crossDomain ) {
		return {
			send: function( headers, complete ) {
				var i,
					xhr = options.xhr();

				xhr.open(
					options.type,
					options.url,
					options.async,
					options.username,
					options.password
				);

				// Apply custom fields if provided
				if ( options.xhrFields ) {
					for ( i in options.xhrFields ) {
						xhr[ i ] = options.xhrFields[ i ];
					}
				}

				// Override mime type if needed
				if ( options.mimeType && xhr.overrideMimeType ) {
					xhr.overrideMimeType( options.mimeType );
				}

				// X-Requested-With header
				// For cross-domain requests, seeing as conditions for a preflight are
				// akin to a jigsaw puzzle, we simply never set it to be sure.
				// (it can always be set on a per-request basis or even using ajaxSetup)
				// For same-domain requests, won't change header if already provided.
				if ( !options.crossDomain && !headers[ "X-Requested-With" ] ) {
					headers[ "X-Requested-With" ] = "XMLHttpRequest";
				}

				// Set headers
				for ( i in headers ) {
					xhr.setRequestHeader( i, headers[ i ] );
				}

				// Callback
				callback = function( type ) {
					return function() {
						if ( callback ) {
							callback = errorCallback = xhr.onload =
								xhr.onerror = xhr.onabort = xhr.ontimeout =
									xhr.onreadystatechange = null;

							if ( type === "abort" ) {
								xhr.abort();
							} else if ( type === "error" ) {

								// Support: IE <=9 only
								// On a manual native abort, IE9 throws
								// errors on any property access that is not readyState
								if ( typeof xhr.status !== "number" ) {
									complete( 0, "error" );
								} else {
									complete(

										// File: protocol always yields status 0; see #8605, #14207
										xhr.status,
										xhr.statusText
									);
								}
							} else {
								complete(
									xhrSuccessStatus[ xhr.status ] || xhr.status,
									xhr.statusText,

									// Support: IE <=9 only
									// IE9 has no XHR2 but throws on binary (trac-11426)
									// For XHR2 non-text, let the caller handle it (gh-2498)
									( xhr.responseType || "text" ) !== "text"  ||
									typeof xhr.responseText !== "string" ?
										{ binary: xhr.response } :
										{ text: xhr.responseText },
									xhr.getAllResponseHeaders()
								);
							}
						}
					};
				};

				// Listen to events
				xhr.onload = callback();
				errorCallback = xhr.onerror = xhr.ontimeout = callback( "error" );

				// Support: IE 9 only
				// Use onreadystatechange to replace onabort
				// to handle uncaught aborts
				if ( xhr.onabort !== undefined ) {
					xhr.onabort = errorCallback;
				} else {
					xhr.onreadystatechange = function() {

						// Check readyState before timeout as it changes
						if ( xhr.readyState === 4 ) {

							// Allow onerror to be called first,
							// but that will not handle a native abort
							// Also, save errorCallback to a variable
							// as xhr.onerror cannot be accessed
							window.setTimeout( function() {
								if ( callback ) {
									errorCallback();
								}
							} );
						}
					};
				}

				// Create the abort callback
				callback = callback( "abort" );

				try {

					// Do send the request (this may raise an exception)
					xhr.send( options.hasContent && options.data || null );
				} catch ( e ) {

					// #14683: Only rethrow if this hasn't been notified as an error yet
					if ( callback ) {
						throw e;
					}
				}
			},

			abort: function() {
				if ( callback ) {
					callback();
				}
			}
		};
	}
} );




// Prevent auto-execution of scripts when no explicit dataType was provided (See gh-2432)
jQuery.ajaxPrefilter( function( s ) {
	if ( s.crossDomain ) {
		s.contents.script = false;
	}
} );

// Install script dataType
jQuery.ajaxSetup( {
	accepts: {
		script: "text/javascript, application/javascript, " +
			"application/ecmascript, application/x-ecmascript"
	},
	contents: {
		script: /\b(?:java|ecma)script\b/
	},
	converters: {
		"text script": function( text ) {
			jQuery.globalEval( text );
			return text;
		}
	}
} );

// Handle cache's special case and crossDomain
jQuery.ajaxPrefilter( "script", function( s ) {
	if ( s.cache === undefined ) {
		s.cache = false;
	}
	if ( s.crossDomain ) {
		s.type = "GET";
	}
} );

// Bind script tag hack transport
jQuery.ajaxTransport( "script", function( s ) {

	// This transport only deals with cross domain or forced-by-attrs requests
	if ( s.crossDomain || s.scriptAttrs ) {
		var script, callback;
		return {
			send: function( _, complete ) {
				script = jQuery( "<script>" )
					.attr( s.scriptAttrs || {} )
					.prop( { charset: s.scriptCharset, src: s.url } )
					.on( "load error", callback = function( evt ) {
						script.remove();
						callback = null;
						if ( evt ) {
							complete( evt.type === "error" ? 404 : 200, evt.type );
						}
					} );

				// Use native DOM manipulation to avoid our domManip AJAX trickery
				document.head.appendChild( script[ 0 ] );
			},
			abort: function() {
				if ( callback ) {
					callback();
				}
			}
		};
	}
} );




var oldCallbacks = [],
	rjsonp = /(=)\?(?=&|$)|\?\?/;

// Default jsonp settings
jQuery.ajaxSetup( {
	jsonp: "callback",
	jsonpCallback: function() {
		var callback = oldCallbacks.pop() || ( jQuery.expando + "_" + ( nonce.guid++ ) );
		this[ callback ] = true;
		return callback;
	}
} );

// Detect, normalize options and install callbacks for jsonp requests
jQuery.ajaxPrefilter( "json jsonp", function( s, originalSettings, jqXHR ) {

	var callbackName, overwritten, responseContainer,
		jsonProp = s.jsonp !== false && ( rjsonp.test( s.url ) ?
			"url" :
			typeof s.data === "string" &&
				( s.contentType || "" )
					.indexOf( "application/x-www-form-urlencoded" ) === 0 &&
				rjsonp.test( s.data ) && "data"
		);

	// Handle iff the expected data type is "jsonp" or we have a parameter to set
	if ( jsonProp || s.dataTypes[ 0 ] === "jsonp" ) {

		// Get callback name, remembering preexisting value associated with it
		callbackName = s.jsonpCallback = isFunction( s.jsonpCallback ) ?
			s.jsonpCallback() :
			s.jsonpCallback;

		// Insert callback into url or form data
		if ( jsonProp ) {
			s[ jsonProp ] = s[ jsonProp ].replace( rjsonp, "$1" + callbackName );
		} else if ( s.jsonp !== false ) {
			s.url += ( rquery.test( s.url ) ? "&" : "?" ) + s.jsonp + "=" + callbackName;
		}

		// Use data converter to retrieve json after script execution
		s.converters[ "script json" ] = function() {
			if ( !responseContainer ) {
				jQuery.error( callbackName + " was not called" );
			}
			return responseContainer[ 0 ];
		};

		// Force json dataType
		s.dataTypes[ 0 ] = "json";

		// Install callback
		overwritten = window[ callbackName ];
		window[ callbackName ] = function() {
			responseContainer = arguments;
		};

		// Clean-up function (fires after converters)
		jqXHR.always( function() {

			// If previous value didn't exist - remove it
			if ( overwritten === undefined ) {
				jQuery( window ).removeProp( callbackName );

			// Otherwise restore preexisting value
			} else {
				window[ callbackName ] = overwritten;
			}

			// Save back as free
			if ( s[ callbackName ] ) {

				// Make sure that re-using the options doesn't screw things around
				s.jsonpCallback = originalSettings.jsonpCallback;

				// Save the callback name for future use
				oldCallbacks.push( callbackName );
			}

			// Call if it was a function and we have a response
			if ( responseContainer && isFunction( overwritten ) ) {
				overwritten( responseContainer[ 0 ] );
			}

			responseContainer = overwritten = undefined;
		} );

		// Delegate to script
		return "script";
	}
} );




// Support: Safari 8 only
// In Safari 8 documents created via document.implementation.createHTMLDocument
// collapse sibling forms: the second one becomes a child of the first one.
// Because of that, this security measure has to be disabled in Safari 8.
// https://bugs.webkit.org/show_bug.cgi?id=137337
support.createHTMLDocument = ( function() {
	var body = document.implementation.createHTMLDocument( "" ).body;
	body.innerHTML = "<form></form><form></form>";
	return body.childNodes.length === 2;
} )();


// Argument "data" should be string of html
// context (optional): If specified, the fragment will be created in this context,
// defaults to document
// keepScripts (optional): If true, will include scripts passed in the html string
jQuery.parseHTML = function( data, context, keepScripts ) {
	if ( typeof data !== "string" ) {
		return [];
	}
	if ( typeof context === "boolean" ) {
		keepScripts = context;
		context = false;
	}

	var base, parsed, scripts;

	if ( !context ) {

		// Stop scripts or inline event handlers from being executed immediately
		// by using document.implementation
		if ( support.createHTMLDocument ) {
			context = document.implementation.createHTMLDocument( "" );

			// Set the base href for the created document
			// so any parsed elements with URLs
			// are based on the document's URL (gh-2965)
			base = context.createElement( "base" );
			base.href = document.location.href;
			context.head.appendChild( base );
		} else {
			context = document;
		}
	}

	parsed = rsingleTag.exec( data );
	scripts = !keepScripts && [];

	// Single tag
	if ( parsed ) {
		return [ context.createElement( parsed[ 1 ] ) ];
	}

	parsed = buildFragment( [ data ], context, scripts );

	if ( scripts && scripts.length ) {
		jQuery( scripts ).remove();
	}

	return jQuery.merge( [], parsed.childNodes );
};


/**
 * Load a url into a page
 */
jQuery.fn.load = function( url, params, callback ) {
	var selector, type, response,
		self = this,
		off = url.indexOf( " " );

	if ( off > -1 ) {
		selector = stripAndCollapse( url.slice( off ) );
		url = url.slice( 0, off );
	}

	// If it's a function
	if ( isFunction( params ) ) {

		// We assume that it's the callback
		callback = params;
		params = undefined;

	// Otherwise, build a param string
	} else if ( params && typeof params === "object" ) {
		type = "POST";
	}

	// If we have elements to modify, make the request
	if ( self.length > 0 ) {
		jQuery.ajax( {
			url: url,

			// If "type" variable is undefined, then "GET" method will be used.
			// Make value of this field explicit since
			// user can override it through ajaxSetup method
			type: type || "GET",
			dataType: "html",
			data: params
		} ).done( function( responseText ) {

			// Save response for use in complete callback
			response = arguments;

			self.html( selector ?

				// If a selector was specified, locate the right elements in a dummy div
				// Exclude scripts to avoid IE 'Permission Denied' errors
				jQuery( "<div>" ).append( jQuery.parseHTML( responseText ) ).find( selector ) :

				// Otherwise use the full result
				responseText );

		// If the request succeeds, this function gets "data", "status", "jqXHR"
		// but they are ignored because response was set above.
		// If it fails, this function gets "jqXHR", "status", "error"
		} ).always( callback && function( jqXHR, status ) {
			self.each( function() {
				callback.apply( this, response || [ jqXHR.responseText, status, jqXHR ] );
			} );
		} );
	}

	return this;
};




jQuery.expr.pseudos.animated = function( elem ) {
	return jQuery.grep( jQuery.timers, function( fn ) {
		return elem === fn.elem;
	} ).length;
};




jQuery.offset = {
	setOffset: function( elem, options, i ) {
		var curPosition, curLeft, curCSSTop, curTop, curOffset, curCSSLeft, calculatePosition,
			position = jQuery.css( elem, "position" ),
			curElem = jQuery( elem ),
			props = {};

		// Set position first, in-case top/left are set even on static elem
		if ( position === "static" ) {
			elem.style.position = "relative";
		}

		curOffset = curElem.offset();
		curCSSTop = jQuery.css( elem, "top" );
		curCSSLeft = jQuery.css( elem, "left" );
		calculatePosition = ( position === "absolute" || position === "fixed" ) &&
			( curCSSTop + curCSSLeft ).indexOf( "auto" ) > -1;

		// Need to be able to calculate position if either
		// top or left is auto and position is either absolute or fixed
		if ( calculatePosition ) {
			curPosition = curElem.position();
			curTop = curPosition.top;
			curLeft = curPosition.left;

		} else {
			curTop = parseFloat( curCSSTop ) || 0;
			curLeft = parseFloat( curCSSLeft ) || 0;
		}

		if ( isFunction( options ) ) {

			// Use jQuery.extend here to allow modification of coordinates argument (gh-1848)
			options = options.call( elem, i, jQuery.extend( {}, curOffset ) );
		}

		if ( options.top != null ) {
			props.top = ( options.top - curOffset.top ) + curTop;
		}
		if ( options.left != null ) {
			props.left = ( options.left - curOffset.left ) + curLeft;
		}

		if ( "using" in options ) {
			options.using.call( elem, props );

		} else {
			if ( typeof props.top === "number" ) {
				props.top += "px";
			}
			if ( typeof props.left === "number" ) {
				props.left += "px";
			}
			curElem.css( props );
		}
	}
};

jQuery.fn.extend( {

	// offset() relates an element's border box to the document origin
	offset: function( options ) {

		// Preserve chaining for setter
		if ( arguments.length ) {
			return options === undefined ?
				this :
				this.each( function( i ) {
					jQuery.offset.setOffset( this, options, i );
				} );
		}

		var rect, win,
			elem = this[ 0 ];

		if ( !elem ) {
			return;
		}

		// Return zeros for disconnected and hidden (display: none) elements (gh-2310)
		// Support: IE <=11 only
		// Running getBoundingClientRect on a
		// disconnected node in IE throws an error
		if ( !elem.getClientRects().length ) {
			return { top: 0, left: 0 };
		}

		// Get document-relative position by adding viewport scroll to viewport-relative gBCR
		rect = elem.getBoundingClientRect();
		win = elem.ownerDocument.defaultView;
		return {
			top: rect.top + win.pageYOffset,
			left: rect.left + win.pageXOffset
		};
	},

	// position() relates an element's margin box to its offset parent's padding box
	// This corresponds to the behavior of CSS absolute positioning
	position: function() {
		if ( !this[ 0 ] ) {
			return;
		}

		var offsetParent, offset, doc,
			elem = this[ 0 ],
			parentOffset = { top: 0, left: 0 };

		// position:fixed elements are offset from the viewport, which itself always has zero offset
		if ( jQuery.css( elem, "position" ) === "fixed" ) {

			// Assume position:fixed implies availability of getBoundingClientRect
			offset = elem.getBoundingClientRect();

		} else {
			offset = this.offset();

			// Account for the *real* offset parent, which can be the document or its root element
			// when a statically positioned element is identified
			doc = elem.ownerDocument;
			offsetParent = elem.offsetParent || doc.documentElement;
			while ( offsetParent &&
				( offsetParent === doc.body || offsetParent === doc.documentElement ) &&
				jQuery.css( offsetParent, "position" ) === "static" ) {

				offsetParent = offsetParent.parentNode;
			}
			if ( offsetParent && offsetParent !== elem && offsetParent.nodeType === 1 ) {

				// Incorporate borders into its offset, since they are outside its content origin
				parentOffset = jQuery( offsetParent ).offset();
				parentOffset.top += jQuery.css( offsetParent, "borderTopWidth", true );
				parentOffset.left += jQuery.css( offsetParent, "borderLeftWidth", true );
			}
		}

		// Subtract parent offsets and element margins
		return {
			top: offset.top - parentOffset.top - jQuery.css( elem, "marginTop", true ),
			left: offset.left - parentOffset.left - jQuery.css( elem, "marginLeft", true )
		};
	},

	// This method will return documentElement in the following cases:
	// 1) For the element inside the iframe without offsetParent, this method will return
	//    documentElement of the parent window
	// 2) For the hidden or detached element
	// 3) For body or html element, i.e. in case of the html node - it will return itself
	//
	// but those exceptions were never presented as a real life use-cases
	// and might be considered as more preferable results.
	//
	// This logic, however, is not guaranteed and can change at any point in the future
	offsetParent: function() {
		return this.map( function() {
			var offsetParent = this.offsetParent;

			while ( offsetParent && jQuery.css( offsetParent, "position" ) === "static" ) {
				offsetParent = offsetParent.offsetParent;
			}

			return offsetParent || documentElement;
		} );
	}
} );

// Create scrollLeft and scrollTop methods
jQuery.each( { scrollLeft: "pageXOffset", scrollTop: "pageYOffset" }, function( method, prop ) {
	var top = "pageYOffset" === prop;

	jQuery.fn[ method ] = function( val ) {
		return access( this, function( elem, method, val ) {

			// Coalesce documents and windows
			var win;
			if ( isWindow( elem ) ) {
				win = elem;
			} else if ( elem.nodeType === 9 ) {
				win = elem.defaultView;
			}

			if ( val === undefined ) {
				return win ? win[ prop ] : elem[ method ];
			}

			if ( win ) {
				win.scrollTo(
					!top ? val : win.pageXOffset,
					top ? val : win.pageYOffset
				);

			} else {
				elem[ method ] = val;
			}
		}, method, val, arguments.length );
	};
} );

// Support: Safari <=7 - 9.1, Chrome <=37 - 49
// Add the top/left cssHooks using jQuery.fn.position
// Webkit bug: https://bugs.webkit.org/show_bug.cgi?id=29084
// Blink bug: https://bugs.chromium.org/p/chromium/issues/detail?id=589347
// getComputedStyle returns percent when specified for top/left/bottom/right;
// rather than make the css module depend on the offset module, just check for it here
jQuery.each( [ "top", "left" ], function( _i, prop ) {
	jQuery.cssHooks[ prop ] = addGetHookIf( support.pixelPosition,
		function( elem, computed ) {
			if ( computed ) {
				computed = curCSS( elem, prop );

				// If curCSS returns percentage, fallback to offset
				return rnumnonpx.test( computed ) ?
					jQuery( elem ).position()[ prop ] + "px" :
					computed;
			}
		}
	);
} );


// Create innerHeight, innerWidth, height, width, outerHeight and outerWidth methods
jQuery.each( { Height: "height", Width: "width" }, function( name, type ) {
	jQuery.each( { padding: "inner" + name, content: type, "": "outer" + name },
		function( defaultExtra, funcName ) {

		// Margin is only for outerHeight, outerWidth
		jQuery.fn[ funcName ] = function( margin, value ) {
			var chainable = arguments.length && ( defaultExtra || typeof margin !== "boolean" ),
				extra = defaultExtra || ( margin === true || value === true ? "margin" : "border" );

			return access( this, function( elem, type, value ) {
				var doc;

				if ( isWindow( elem ) ) {

					// $( window ).outerWidth/Height return w/h including scrollbars (gh-1729)
					return funcName.indexOf( "outer" ) === 0 ?
						elem[ "inner" + name ] :
						elem.document.documentElement[ "client" + name ];
				}

				// Get document width or height
				if ( elem.nodeType === 9 ) {
					doc = elem.documentElement;

					// Either scroll[Width/Height] or offset[Width/Height] or client[Width/Height],
					// whichever is greatest
					return Math.max(
						elem.body[ "scroll" + name ], doc[ "scroll" + name ],
						elem.body[ "offset" + name ], doc[ "offset" + name ],
						doc[ "client" + name ]
					);
				}

				return value === undefined ?

					// Get width or height on the element, requesting but not forcing parseFloat
					jQuery.css( elem, type, extra ) :

					// Set width or height on the element
					jQuery.style( elem, type, value, extra );
			}, type, chainable ? margin : undefined, chainable );
		};
	} );
} );


jQuery.each( [
	"ajaxStart",
	"ajaxStop",
	"ajaxComplete",
	"ajaxError",
	"ajaxSuccess",
	"ajaxSend"
], function( _i, type ) {
	jQuery.fn[ type ] = function( fn ) {
		return this.on( type, fn );
	};
} );




jQuery.fn.extend( {

	bind: function( types, data, fn ) {
		return this.on( types, null, data, fn );
	},
	unbind: function( types, fn ) {
		return this.off( types, null, fn );
	},

	delegate: function( selector, types, data, fn ) {
		return this.on( types, selector, data, fn );
	},
	undelegate: function( selector, types, fn ) {

		// ( namespace ) or ( selector, types [, fn] )
		return arguments.length === 1 ?
			this.off( selector, "**" ) :
			this.off( types, selector || "**", fn );
	},

	hover: function( fnOver, fnOut ) {
		return this.mouseenter( fnOver ).mouseleave( fnOut || fnOver );
	}
} );

jQuery.each( ( "blur focus focusin focusout resize scroll click dblclick " +
	"mousedown mouseup mousemove mouseover mouseout mouseenter mouseleave " +
	"change select submit keydown keypress keyup contextmenu" ).split( " " ),
	function( _i, name ) {

		// Handle event binding
		jQuery.fn[ name ] = function( data, fn ) {
			return arguments.length > 0 ?
				this.on( name, null, data, fn ) :
				this.trigger( name );
		};
	} );




// Support: Android <=4.0 only
// Make sure we trim BOM and NBSP
var rtrim = /^[\s\uFEFF\xA0]+|[\s\uFEFF\xA0]+$/g;

// Bind a function to a context, optionally partially applying any
// arguments.
// jQuery.proxy is deprecated to promote standards (specifically Function#bind)
// However, it is not slated for removal any time soon
jQuery.proxy = function( fn, context ) {
	var tmp, args, proxy;

	if ( typeof context === "string" ) {
		tmp = fn[ context ];
		context = fn;
		fn = tmp;
	}

	// Quick check to determine if target is callable, in the spec
	// this throws a TypeError, but we will just return undefined.
	if ( !isFunction( fn ) ) {
		return undefined;
	}

	// Simulated bind
	args = slice.call( arguments, 2 );
	proxy = function() {
		return fn.apply( context || this, args.concat( slice.call( arguments ) ) );
	};

	// Set the guid of unique handler to the same of original handler, so it can be removed
	proxy.guid = fn.guid = fn.guid || jQuery.guid++;

	return proxy;
};

jQuery.holdReady = function( hold ) {
	if ( hold ) {
		jQuery.readyWait++;
	} else {
		jQuery.ready( true );
	}
};
jQuery.isArray = Array.isArray;
jQuery.parseJSON = JSON.parse;
jQuery.nodeName = nodeName;
jQuery.isFunction = isFunction;
jQuery.isWindow = isWindow;
jQuery.camelCase = camelCase;
jQuery.type = toType;

jQuery.now = Date.now;

jQuery.isNumeric = function( obj ) {

	// As of jQuery 3.0, isNumeric is limited to
	// strings and numbers (primitives or objects)
	// that can be coerced to finite numbers (gh-2662)
	var type = jQuery.type( obj );
	return ( type === "number" || type === "string" ) &&

		// parseFloat NaNs numeric-cast false positives ("")
		// ...but misinterprets leading-number strings, particularly hex literals ("0x...")
		// subtraction forces infinities to NaN
		!isNaN( obj - parseFloat( obj ) );
};

jQuery.trim = function( text ) {
	return text == null ?
		"" :
		( text + "" ).replace( rtrim, "" );
};



// Register as a named AMD module, since jQuery can be concatenated with other
// files that may use define, but not via a proper concatenation script that
// understands anonymous AMD modules. A named AMD is safest and most robust
// way to register. Lowercase jquery is used because AMD module names are
// derived from file names, and jQuery is normally delivered in a lowercase
// file name. Do this after creating the global so that if an AMD module wants
// to call noConflict to hide this version of jQuery, it will work.

// Note that for maximum portability, libraries that are not jQuery should
// declare themselves as anonymous modules, and avoid setting a global if an
// AMD loader is present. jQuery is a special case. For more information, see
// https://github.com/jrburke/requirejs/wiki/Updating-existing-libraries#wiki-anon

if ( typeof define === "function" && define.amd ) {
	define( "jquery", [], function() {
		return jQuery;
	} );
}




var

	// Map over jQuery in case of overwrite
	_jQuery = window.jQuery,

	// Map over the $ in case of overwrite
	_$ = window.$;

jQuery.noConflict = function( deep ) {
	if ( window.$ === jQuery ) {
		window.$ = _$;
	}

	if ( deep && window.jQuery === jQuery ) {
		window.jQuery = _jQuery;
	}

	return jQuery;
};

// Expose jQuery and $ identifiers, even in AMD
// (#7102#comment:10, https://github.com/jquery/jquery/pull/557)
// and CommonJS for browser emulators (#13566)
if ( typeof noGlobal === "undefined" ) {
	window.jQuery = window.$ = jQuery;
}




return jQuery;
} );

/**
 * CLDR JavaScript Library v0.5.4
 * http://jquery.com/
 *
 * Copyright 2013 Rafael Xavier de Souza
 * Released under the MIT license
 * http://jquery.org/license
 *
 * Date: 2020-10-22T15:56Z
 */
/*!
 * CLDR JavaScript Library v0.5.4 2020-10-22T15:56Z MIT license © Rafael Xavier
 * http://git.io/h4lmVg
 */
(function( root, factory ) {

	if ( typeof define === "function" && define.amd ) {
		// AMD.
		define( factory );
	} else if ( typeof module === "object" && typeof module.exports === "object" ) {
		// Node. CommonJS.
		module.exports = factory();
	} else {
		// Global
		root.Cldr = factory();
	}

}( this, function() {


	var arrayIsArray = Array.isArray || function( obj ) {
		return Object.prototype.toString.call( obj ) === "[object Array]";
	};




	var pathNormalize = function( path, attributes ) {
		if ( arrayIsArray( path ) ) {
			path = path.join( "/" );
		}
		if ( typeof path !== "string" ) {
			throw new Error( "invalid path \"" + path + "\"" );
		}
		// 1: Ignore leading slash `/`
		// 2: Ignore leading `cldr/`
		path = path
			.replace( /^\// , "" ) /* 1 */
			.replace( /^cldr\// , "" ); /* 2 */

		// Replace {attribute}'s
		path = path.replace( /{[a-zA-Z]+}/g, function( name ) {
			name = name.replace( /^{([^}]*)}$/, "$1" );
			return attributes[ name ];
		});

		return path.split( "/" );
	};




	var arraySome = function( array, callback ) {
		var i, length;
		if ( array.some ) {
			return array.some( callback );
		}
		for ( i = 0, length = array.length; i < length; i++ ) {
			if ( callback( array[ i ], i, array ) ) {
				return true;
			}
		}
		return false;
	};




	/**
	 * Return the maximized language id as defined in
	 * http://www.unicode.org/reports/tr35/#Likely_Subtags
	 * 1. Canonicalize.
	 * 1.1 Make sure the input locale is in canonical form: uses the right
	 * separator, and has the right casing.
	 * TODO Right casing? What df? It seems languages are lowercase, scripts are
	 * Capitalized, territory is uppercase. I am leaving this as an exercise to
	 * the user.
	 *
	 * 1.2 Replace any deprecated subtags with their canonical values using the
	 * <alias> data in supplemental metadata. Use the first value in the
	 * replacement list, if it exists. Language tag replacements may have multiple
	 * parts, such as "sh" ➞ "sr_Latn" or mo" ➞ "ro_MD". In such a case, the
	 * original script and/or region are retained if there is one. Thus
	 * "sh_Arab_AQ" ➞ "sr_Arab_AQ", not "sr_Latn_AQ".
	 * TODO What <alias> data?
	 *
	 * 1.3 If the tag is grandfathered (see <variable id="$grandfathered"
	 * type="choice"> in the supplemental data), then return it.
	 * TODO grandfathered?
	 *
	 * 1.4 Remove the script code 'Zzzz' and the region code 'ZZ' if they occur.
	 * 1.5 Get the components of the cleaned-up source tag (languages, scripts,
	 * and regions), plus any variants and extensions.
	 * 2. Lookup. Lookup each of the following in order, and stop on the first
	 * match:
	 * 2.1 languages_scripts_regions
	 * 2.2 languages_regions
	 * 2.3 languages_scripts
	 * 2.4 languages
	 * 2.5 und_scripts
	 * 3. Return
	 * 3.1 If there is no match, either return an error value, or the match for
	 * "und" (in APIs where a valid language tag is required).
	 * 3.2 Otherwise there is a match = languagem_scriptm_regionm
	 * 3.3 Let xr = xs if xs is not empty, and xm otherwise.
	 * 3.4 Return the language tag composed of languager _ scriptr _ regionr +
	 * variants + extensions.
	 *
	 * @subtags [Array] normalized language id subtags tuple (see init.js).
	 */
	var coreLikelySubtags = function( Cldr, cldr, subtags, options ) {
		var match, matchFound,
			language = subtags[ 0 ],
			script = subtags[ 1 ],
			sep = Cldr.localeSep,
			territory = subtags[ 2 ],
			variants = subtags.slice( 3, 4 );
		options = options || {};

		// Skip if (language, script, territory) is not empty [3.3]
		if ( language !== "und" && script !== "Zzzz" && territory !== "ZZ" ) {
			return [ language, script, territory ].concat( variants );
		}

		// Skip if no supplemental likelySubtags data is present
		if ( typeof cldr.get( "supplemental/likelySubtags" ) === "undefined" ) {
			return;
		}

		// [2]
		matchFound = arraySome([
			[ language, script, territory ],
			[ language, territory ],
			[ language, script ],
			[ language ],
			[ "und", script ]
		], function( test ) {
			return match = !(/\b(Zzzz|ZZ)\b/).test( test.join( sep ) ) /* [1.4] */ && cldr.get( [ "supplemental/likelySubtags", test.join( sep ) ] );
		});

		// [3]
		if ( matchFound ) {
			// [3.2 .. 3.4]
			match = match.split( sep );
			return [
				language !== "und" ? language : match[ 0 ],
				script !== "Zzzz" ? script : match[ 1 ],
				territory !== "ZZ" ? territory : match[ 2 ]
			].concat( variants );
		} else if ( options.force ) {
			// [3.1.2]
			return cldr.get( "supplemental/likelySubtags/und" ).split( sep );
		} else {
			// [3.1.1]
			return;
		}
	};



	/**
	 * Given a locale, remove any fields that Add Likely Subtags would add.
	 * http://www.unicode.org/reports/tr35/#Likely_Subtags
	 * 1. First get max = AddLikelySubtags(inputLocale). If an error is signaled,
	 * return it.
	 * 2. Remove the variants from max.
	 * 3. Then for trial in {language, language _ region, language _ script}. If
	 * AddLikelySubtags(trial) = max, then return trial + variants.
	 * 4. If you do not get a match, return max + variants.
	 * 
	 * @maxLanguageId [Array] maxLanguageId tuple (see init.js).
	 */
	var coreRemoveLikelySubtags = function( Cldr, cldr, maxLanguageId ) {
		var match, matchFound,
			language = maxLanguageId[ 0 ],
			script = maxLanguageId[ 1 ],
			territory = maxLanguageId[ 2 ],
			variants = maxLanguageId[ 3 ];

		// [3]
		matchFound = arraySome([
			[ [ language, "Zzzz", "ZZ" ], [ language ] ],
			[ [ language, "Zzzz", territory ], [ language, territory ] ],
			[ [ language, script, "ZZ" ], [ language, script ] ]
		], function( test ) {
			var result = coreLikelySubtags( Cldr, cldr, test[ 0 ] );
			match = test[ 1 ];
			return result && result[ 0 ] === maxLanguageId[ 0 ] &&
				result[ 1 ] === maxLanguageId[ 1 ] &&
				result[ 2 ] === maxLanguageId[ 2 ];
		});

		if ( matchFound ) {
			if ( variants ) {
				match.push( variants );
			}
			return match;
		}

		// [4]
		return maxLanguageId;
	};




	/**
	 * subtags( locale )
	 *
	 * @locale [String]
	 */
	var coreSubtags = function( locale ) {
		var aux, unicodeLanguageId,
			subtags = [];

		locale = locale.replace( /_/, "-" );

		// Unicode locale extensions.
		aux = locale.split( "-u-" );
		if ( aux[ 1 ] ) {
			aux[ 1 ] = aux[ 1 ].split( "-t-" );
			locale = aux[ 0 ] + ( aux[ 1 ][ 1 ] ? "-t-" + aux[ 1 ][ 1 ] : "");
			subtags[ 4 /* unicodeLocaleExtensions */ ] = aux[ 1 ][ 0 ];
		}

		// TODO normalize transformed extensions. Currently, skipped.
		// subtags[ x ] = locale.split( "-t-" )[ 1 ];
		unicodeLanguageId = locale.split( "-t-" )[ 0 ];

		// unicode_language_id = "root"
		//   | unicode_language_subtag         
		//     (sep unicode_script_subtag)? 
		//     (sep unicode_region_subtag)?
		//     (sep unicode_variant_subtag)* ;
		//
		// Although unicode_language_subtag = alpha{2,8}, I'm using alpha{2,3}. Because, there's no language on CLDR lengthier than 3.
		aux = unicodeLanguageId.match( /^(([a-z]{2,3})(-([A-Z][a-z]{3}))?(-([A-Z]{2}|[0-9]{3}))?)((-([a-zA-Z0-9]{5,8}|[0-9][a-zA-Z0-9]{3}))*)$|^(root)$/ );
		if ( aux === null ) {
			return [ "und", "Zzzz", "ZZ" ];
		}
		subtags[ 0 /* language */ ] = aux[ 10 ] /* root */ || aux[ 2 ] || "und";
		subtags[ 1 /* script */ ] = aux[ 4 ] || "Zzzz";
		subtags[ 2 /* territory */ ] = aux[ 6 ] || "ZZ";
		if ( aux[ 7 ] && aux[ 7 ].length ) {
			subtags[ 3 /* variant */ ] = aux[ 7 ].slice( 1 ) /* remove leading "-" */;
		}

		// 0: language
		// 1: script
		// 2: territory (aka region)
		// 3: variant
		// 4: unicodeLocaleExtensions
		return subtags;
	};




	var arrayForEach = function( array, callback ) {
		var i, length;
		if ( array.forEach ) {
			return array.forEach( callback );
		}
		for ( i = 0, length = array.length; i < length; i++ ) {
			callback( array[ i ], i, array );
		}
	};




	/**
	 * bundleLookup( minLanguageId )
	 *
	 * @Cldr [Cldr class]
	 *
	 * @cldr [Cldr instance]
	 *
	 * @minLanguageId [String] requested languageId after applied remove likely subtags.
	 */
	var bundleLookup = function( Cldr, cldr, minLanguageId ) {
		var availableBundleMap = Cldr._availableBundleMap,
			availableBundleMapQueue = Cldr._availableBundleMapQueue;

		if ( availableBundleMapQueue.length ) {
			arrayForEach( availableBundleMapQueue, function( bundle, i ) {
				var existing, maxBundle, minBundle, subtags;
				subtags = coreSubtags( bundle );
				maxBundle = coreLikelySubtags( Cldr, cldr, subtags );
				if ( maxBundle === undefined ) {
					availableBundleMapQueue.splice( i, 1 );
					throw new Error( "Could not find likelySubtags for " + bundle );
				}
				minBundle = coreRemoveLikelySubtags( Cldr, cldr, maxBundle );
				minBundle = minBundle.join( Cldr.localeSep );
				existing = availableBundleMap[ minBundle ];
				if ( existing && existing.length < bundle.length ) {
					return;
				}
				availableBundleMap[ minBundle ] = bundle;
			});
			Cldr._availableBundleMapQueue = [];
		}

		return availableBundleMap[ minLanguageId ] || null;
	};




	var objectKeys = function( object ) {
		var i,
			result = [];

		if ( Object.keys ) {
			return Object.keys( object );
		}

		for ( i in object ) {
			result.push( i );
		}

		return result;
	};




	var createError = function( code, attributes ) {
		var error, message;

		message = code + ( attributes && JSON ? ": " + JSON.stringify( attributes ) : "" );
		error = new Error( message );
		error.code = code;

		// extend( error, attributes );
		arrayForEach( objectKeys( attributes ), function( attribute ) {
			error[ attribute ] = attributes[ attribute ];
		});

		return error;
	};




	var validate = function( code, check, attributes ) {
		if ( !check ) {
			throw createError( code, attributes );
		}
	};




	var validatePresence = function( value, name ) {
		validate( "E_MISSING_PARAMETER", typeof value !== "undefined", {
			name: name
		});
	};




	var validateType = function( value, name, check, expected ) {
		validate( "E_INVALID_PAR_TYPE", check, {
			expected: expected,
			name: name,
			value: value
		});
	};




	var validateTypePath = function( value, name ) {
		validateType( value, name, typeof value === "string" || arrayIsArray( value ), "String or Array" );
	};




	/**
	 * Function inspired by jQuery Core, but reduced to our use case.
	 */
	var isPlainObject = function( obj ) {
		return obj !== null && "" + obj === "[object Object]";
	};




	var validateTypePlainObject = function( value, name ) {
		validateType( value, name, typeof value === "undefined" || isPlainObject( value ), "Plain Object" );
	};




	var validateTypeString = function( value, name ) {
		validateType( value, name, typeof value === "string", "a string" );
	};




	// @path: normalized path
	var resourceGet = function( data, path ) {
		var i,
			node = data,
			length = path.length;

		for ( i = 0; i < length - 1; i++ ) {
			node = node[ path[ i ] ];
			if ( !node ) {
				return undefined;
			}
		}
		return node[ path[ i ] ];
	};




	/**
	 * setAvailableBundles( Cldr, json )
	 *
	 * @Cldr [Cldr class]
	 *
	 * @json resolved/unresolved cldr data.
	 *
	 * Set available bundles queue based on passed json CLDR data. Considers a bundle as any String at /main/{bundle}.
	 */
	var coreSetAvailableBundles = function( Cldr, json ) {
		var bundle,
			availableBundleMapQueue = Cldr._availableBundleMapQueue,
			main = resourceGet( json, [ "main" ] );

		if ( main ) {
			for ( bundle in main ) {
				if ( main.hasOwnProperty( bundle ) && bundle !== "root" &&
							availableBundleMapQueue.indexOf( bundle ) === -1 ) {
					availableBundleMapQueue.push( bundle );
				}
			}
		}
	};



	var alwaysArray = function( somethingOrArray ) {
		return arrayIsArray( somethingOrArray ) ?  somethingOrArray : [ somethingOrArray ];
	};


	var jsonMerge = (function() {

	// Returns new deeply merged JSON.
	//
	// Eg.
	// merge( { a: { b: 1, c: 2 } }, { a: { b: 3, d: 4 } } )
	// -> { a: { b: 3, c: 2, d: 4 } }
	//
	// @arguments JSON's
	// 
	var merge = function() {
		var destination = {},
			sources = [].slice.call( arguments, 0 );
		arrayForEach( sources, function( source ) {
			var prop;
			for ( prop in source ) {
				if ( prop in destination && typeof destination[ prop ] === "object" && !arrayIsArray( destination[ prop ] ) ) {

					// Merge Objects
					destination[ prop ] = merge( destination[ prop ], source[ prop ] );

				} else {

					// Set new values
					destination[ prop ] = source[ prop ];

				}
			}
		});
		return destination;
	};

	return merge;

}());


	/**
	 * load( Cldr, source, jsons )
	 *
	 * @Cldr [Cldr class]
	 *
	 * @source [Object]
	 *
	 * @jsons [arguments]
	 */
	var coreLoad = function( Cldr, source, jsons ) {
		var i, j, json;

		validatePresence( jsons[ 0 ], "json" );

		// Support arbitrary parameters, e.g., `Cldr.load({...}, {...})`.
		for ( i = 0; i < jsons.length; i++ ) {

			// Support array parameters, e.g., `Cldr.load([{...}, {...}])`.
			json = alwaysArray( jsons[ i ] );

			for ( j = 0; j < json.length; j++ ) {
				validateTypePlainObject( json[ j ], "json" );
				source = jsonMerge( source, json[ j ] );
				coreSetAvailableBundles( Cldr, json[ j ] );
			}
		}

		return source;
	};



	var itemGetResolved = function( Cldr, path, attributes ) {
		// Resolve path
		var normalizedPath = pathNormalize( path, attributes );

		return resourceGet( Cldr._resolved, normalizedPath );
	};




	/**
	 * new Cldr()
	 */
	var Cldr = function( locale ) {
		this.init( locale );
	};

	// Build optimization hack to avoid duplicating functions across modules.
	Cldr._alwaysArray = alwaysArray;
	Cldr._coreLoad = coreLoad;
	Cldr._createError = createError;
	Cldr._itemGetResolved = itemGetResolved;
	Cldr._jsonMerge = jsonMerge;
	Cldr._pathNormalize = pathNormalize;
	Cldr._resourceGet = resourceGet;
	Cldr._validatePresence = validatePresence;
	Cldr._validateType = validateType;
	Cldr._validateTypePath = validateTypePath;
	Cldr._validateTypePlainObject = validateTypePlainObject;

	Cldr._availableBundleMap = {};
	Cldr._availableBundleMapQueue = [];
	Cldr._resolved = {};

	// Allow user to override locale separator "-" (default) | "_". According to http://www.unicode.org/reports/tr35/#Unicode_language_identifier, both "-" and "_" are valid locale separators (eg. "en_GB", "en-GB"). According to http://unicode.org/cldr/trac/ticket/6786 its usage must be consistent throughout the data set.
	Cldr.localeSep = "-";

	/**
	 * Cldr.load( json [, json, ...] )
	 *
	 * @json [JSON] CLDR data or [Array] Array of @json's.
	 *
	 * Load resolved cldr data.
	 */
	Cldr.load = function() {
		Cldr._resolved = coreLoad( Cldr, Cldr._resolved, arguments );
	};

	/**
	 * .init() automatically run on instantiation/construction.
	 */
	Cldr.prototype.init = function( locale ) {
		var attributes, language, maxLanguageId, minLanguageId, script, subtags, territory, unicodeLocaleExtensions, variant,
			sep = Cldr.localeSep,
			unicodeLocaleExtensionsRaw = "";

		validatePresence( locale, "locale" );
		validateTypeString( locale, "locale" );

		subtags = coreSubtags( locale );

		if ( subtags.length === 5 ) {
			unicodeLocaleExtensions = subtags.pop();
			unicodeLocaleExtensionsRaw = sep + "u" + sep + unicodeLocaleExtensions;
			// Remove trailing null when there is unicodeLocaleExtensions but no variants.
			if ( !subtags[ 3 ] ) {
				subtags.pop();
			}
		}
		variant = subtags[ 3 ];

		// Normalize locale code.
		// Get (or deduce) the "triple subtags": language, territory (also aliased as region), and script subtags.
		// Get the variant subtags (calendar, collation, currency, etc).
		// refs:
		// - http://www.unicode.org/reports/tr35/#Field_Definitions
		// - http://www.unicode.org/reports/tr35/#Language_and_Locale_IDs
		// - http://www.unicode.org/reports/tr35/#Unicode_locale_identifier

		// When a locale id does not specify a language, or territory (region), or script, they are obtained by Likely Subtags.
		maxLanguageId = coreLikelySubtags( Cldr, this, subtags, { force: true } ) || subtags;
		language = maxLanguageId[ 0 ];
		script = maxLanguageId[ 1 ];
		territory = maxLanguageId[ 2 ];

		minLanguageId = coreRemoveLikelySubtags( Cldr, this, maxLanguageId ).join( sep );

		// Set attributes
		this.attributes = attributes = {
			bundle: bundleLookup( Cldr, this, minLanguageId ),

			// Unicode Language Id
			minLanguageId: minLanguageId + unicodeLocaleExtensionsRaw,
			maxLanguageId: maxLanguageId.join( sep ) + unicodeLocaleExtensionsRaw,

			// Unicode Language Id Subtabs
			language: language,
			script: script,
			territory: territory,
			region: territory, /* alias */
			variant: variant
		};

		// Unicode locale extensions.
		unicodeLocaleExtensions && ( "-" + unicodeLocaleExtensions ).replace( /-[a-z]{3,8}|(-[a-z]{2})-([a-z]{3,8})/g, function( attribute, key, type ) {

			if ( key ) {

				// Extension is in the `keyword` form.
				attributes[ "u" + key ] = type;
			} else {

				// Extension is in the `attribute` form.
				attributes[ "u" + attribute ] = true;
			}
		});

		this.locale = locale;
	};

	/**
	 * .get()
	 */
	Cldr.prototype.get = function( path ) {

		validatePresence( path, "path" );
		validateTypePath( path, "path" );

		return itemGetResolved( Cldr, path, this.attributes );
	};

	/**
	 * .main()
	 */
	Cldr.prototype.main = function( path ) {
		validatePresence( path, "path" );
		validateTypePath( path, "path" );

		validate( "E_MISSING_BUNDLE", this.attributes.bundle !== null, {
			locale: this.locale
		});

		path = alwaysArray( path );
		return this.get( [ "main/{bundle}" ].concat( path ) );
	};

	return Cldr;




}));

/**
 * CLDR JavaScript Library v0.5.4
 * http://jquery.com/
 *
 * Copyright 2013 Rafael Xavier de Souza
 * Released under the MIT license
 * http://jquery.org/license
 *
 * Date: 2020-10-22T15:56Z
 */
/*!
 * CLDR JavaScript Library v0.5.4 2020-10-22T15:56Z MIT license © Rafael Xavier
 * http://git.io/h4lmVg
 */
(function( factory ) {

	if ( typeof define === "function" && define.amd ) {
		// AMD.
		define( [ "../cldr" ], factory );
	} else if ( typeof module === "object" && typeof module.exports === "object" ) {
		// Node. CommonJS.
		module.exports = factory( require( "../cldr" ) );
	} else {
		// Global
		factory( Cldr );
	}

}(function( Cldr ) {

	// Build optimization hack to avoid duplicating functions across modules.
	var pathNormalize = Cldr._pathNormalize,
		validatePresence = Cldr._validatePresence,
		validateType = Cldr._validateType;

/*!
 * EventEmitter v4.2.7 - git.io/ee
 * Oliver Caldwell
 * MIT license
 * @preserve
 */

var EventEmitter;
/* jshint ignore:start */
EventEmitter = (function () {


	/**
	 * Class for managing events.
	 * Can be extended to provide event functionality in other classes.
	 *
	 * @class EventEmitter Manages event registering and emitting.
	 */
	function EventEmitter() {}

	// Shortcuts to improve speed and size
	var proto = EventEmitter.prototype;
	var exports = {};
	

	/**
	 * Finds the index of the listener for the event in it's storage array.
	 *
	 * @param {Function[]} listeners Array of listeners to search through.
	 * @param {Function} listener Method to look for.
	 * @return {Number} Index of the specified listener, -1 if not found
	 * @api private
	 */
	function indexOfListener(listeners, listener) {
		var i = listeners.length;
		while (i--) {
			if (listeners[i].listener === listener) {
				return i;
			}
		}

		return -1;
	}

	/**
	 * Alias a method while keeping the context correct, to allow for overwriting of target method.
	 *
	 * @param {String} name The name of the target method.
	 * @return {Function} The aliased method
	 * @api private
	 */
	function alias(name) {
		return function aliasClosure() {
			return this[name].apply(this, arguments);
		};
	}

	/**
	 * Returns the listener array for the specified event.
	 * Will initialise the event object and listener arrays if required.
	 * Will return an object if you use a regex search. The object contains keys for each matched event. So /ba[rz]/ might return an object containing bar and baz. But only if you have either defined them with defineEvent or added some listeners to them.
	 * Each property in the object response is an array of listener functions.
	 *
	 * @param {String|RegExp} evt Name of the event to return the listeners from.
	 * @return {Function[]|Object} All listener functions for the event.
	 */
	proto.getListeners = function getListeners(evt) {
		var events = this._getEvents();
		var response;
		var key;

		// Return a concatenated array of all matching events if
		// the selector is a regular expression.
		if (evt instanceof RegExp) {
			response = {};
			for (key in events) {
				if (events.hasOwnProperty(key) && evt.test(key)) {
					response[key] = events[key];
				}
			}
		}
		else {
			response = events[evt] || (events[evt] = []);
		}

		return response;
	};

	/**
	 * Takes a list of listener objects and flattens it into a list of listener functions.
	 *
	 * @param {Object[]} listeners Raw listener objects.
	 * @return {Function[]} Just the listener functions.
	 */
	proto.flattenListeners = function flattenListeners(listeners) {
		var flatListeners = [];
		var i;

		for (i = 0; i < listeners.length; i += 1) {
			flatListeners.push(listeners[i].listener);
		}

		return flatListeners;
	};

	/**
	 * Fetches the requested listeners via getListeners but will always return the results inside an object. This is mainly for internal use but others may find it useful.
	 *
	 * @param {String|RegExp} evt Name of the event to return the listeners from.
	 * @return {Object} All listener functions for an event in an object.
	 */
	proto.getListenersAsObject = function getListenersAsObject(evt) {
		var listeners = this.getListeners(evt);
		var response;

		if (listeners instanceof Array) {
			response = {};
			response[evt] = listeners;
		}

		return response || listeners;
	};

	/**
	 * Adds a listener function to the specified event.
	 * The listener will not be added if it is a duplicate.
	 * If the listener returns true then it will be removed after it is called.
	 * If you pass a regular expression as the event name then the listener will be added to all events that match it.
	 *
	 * @param {String|RegExp} evt Name of the event to attach the listener to.
	 * @param {Function} listener Method to be called when the event is emitted. If the function returns true then it will be removed after calling.
	 * @return {Object} Current instance of EventEmitter for chaining.
	 */
	proto.addListener = function addListener(evt, listener) {
		var listeners = this.getListenersAsObject(evt);
		var listenerIsWrapped = typeof listener === 'object';
		var key;

		for (key in listeners) {
			if (listeners.hasOwnProperty(key) && indexOfListener(listeners[key], listener) === -1) {
				listeners[key].push(listenerIsWrapped ? listener : {
					listener: listener,
					once: false
				});
			}
		}

		return this;
	};

	/**
	 * Alias of addListener
	 */
	proto.on = alias('addListener');

	/**
	 * Semi-alias of addListener. It will add a listener that will be
	 * automatically removed after it's first execution.
	 *
	 * @param {String|RegExp} evt Name of the event to attach the listener to.
	 * @param {Function} listener Method to be called when the event is emitted. If the function returns true then it will be removed after calling.
	 * @return {Object} Current instance of EventEmitter for chaining.
	 */
	proto.addOnceListener = function addOnceListener(evt, listener) {
		return this.addListener(evt, {
			listener: listener,
			once: true
		});
	};

	/**
	 * Alias of addOnceListener.
	 */
	proto.once = alias('addOnceListener');

	/**
	 * Defines an event name. This is required if you want to use a regex to add a listener to multiple events at once. If you don't do this then how do you expect it to know what event to add to? Should it just add to every possible match for a regex? No. That is scary and bad.
	 * You need to tell it what event names should be matched by a regex.
	 *
	 * @param {String} evt Name of the event to create.
	 * @return {Object} Current instance of EventEmitter for chaining.
	 */
	proto.defineEvent = function defineEvent(evt) {
		this.getListeners(evt);
		return this;
	};

	/**
	 * Uses defineEvent to define multiple events.
	 *
	 * @param {String[]} evts An array of event names to define.
	 * @return {Object} Current instance of EventEmitter for chaining.
	 */
	proto.defineEvents = function defineEvents(evts) {
		for (var i = 0; i < evts.length; i += 1) {
			this.defineEvent(evts[i]);
		}
		return this;
	};

	/**
	 * Removes a listener function from the specified event.
	 * When passed a regular expression as the event name, it will remove the listener from all events that match it.
	 *
	 * @param {String|RegExp} evt Name of the event to remove the listener from.
	 * @param {Function} listener Method to remove from the event.
	 * @return {Object} Current instance of EventEmitter for chaining.
	 */
	proto.removeListener = function removeListener(evt, listener) {
		var listeners = this.getListenersAsObject(evt);
		var index;
		var key;

		for (key in listeners) {
			if (listeners.hasOwnProperty(key)) {
				index = indexOfListener(listeners[key], listener);

				if (index !== -1) {
					listeners[key].splice(index, 1);
				}
			}
		}

		return this;
	};

	/**
	 * Alias of removeListener
	 */
	proto.off = alias('removeListener');

	/**
	 * Adds listeners in bulk using the manipulateListeners method.
	 * If you pass an object as the second argument you can add to multiple events at once. The object should contain key value pairs of events and listeners or listener arrays. You can also pass it an event name and an array of listeners to be added.
	 * You can also pass it a regular expression to add the array of listeners to all events that match it.
	 * Yeah, this function does quite a bit. That's probably a bad thing.
	 *
	 * @param {String|Object|RegExp} evt An event name if you will pass an array of listeners next. An object if you wish to add to multiple events at once.
	 * @param {Function[]} [listeners] An optional array of listener functions to add.
	 * @return {Object} Current instance of EventEmitter for chaining.
	 */
	proto.addListeners = function addListeners(evt, listeners) {
		// Pass through to manipulateListeners
		return this.manipulateListeners(false, evt, listeners);
	};

	/**
	 * Removes listeners in bulk using the manipulateListeners method.
	 * If you pass an object as the second argument you can remove from multiple events at once. The object should contain key value pairs of events and listeners or listener arrays.
	 * You can also pass it an event name and an array of listeners to be removed.
	 * You can also pass it a regular expression to remove the listeners from all events that match it.
	 *
	 * @param {String|Object|RegExp} evt An event name if you will pass an array of listeners next. An object if you wish to remove from multiple events at once.
	 * @param {Function[]} [listeners] An optional array of listener functions to remove.
	 * @return {Object} Current instance of EventEmitter for chaining.
	 */
	proto.removeListeners = function removeListeners(evt, listeners) {
		// Pass through to manipulateListeners
		return this.manipulateListeners(true, evt, listeners);
	};

	/**
	 * Edits listeners in bulk. The addListeners and removeListeners methods both use this to do their job. You should really use those instead, this is a little lower level.
	 * The first argument will determine if the listeners are removed (true) or added (false).
	 * If you pass an object as the second argument you can add/remove from multiple events at once. The object should contain key value pairs of events and listeners or listener arrays.
	 * You can also pass it an event name and an array of listeners to be added/removed.
	 * You can also pass it a regular expression to manipulate the listeners of all events that match it.
	 *
	 * @param {Boolean} remove True if you want to remove listeners, false if you want to add.
	 * @param {String|Object|RegExp} evt An event name if you will pass an array of listeners next. An object if you wish to add/remove from multiple events at once.
	 * @param {Function[]} [listeners] An optional array of listener functions to add/remove.
	 * @return {Object} Current instance of EventEmitter for chaining.
	 */
	proto.manipulateListeners = function manipulateListeners(remove, evt, listeners) {
		var i;
		var value;
		var single = remove ? this.removeListener : this.addListener;
		var multiple = remove ? this.removeListeners : this.addListeners;

		// If evt is an object then pass each of it's properties to this method
		if (typeof evt === 'object' && !(evt instanceof RegExp)) {
			for (i in evt) {
				if (evt.hasOwnProperty(i) && (value = evt[i])) {
					// Pass the single listener straight through to the singular method
					if (typeof value === 'function') {
						single.call(this, i, value);
					}
					else {
						// Otherwise pass back to the multiple function
						multiple.call(this, i, value);
					}
				}
			}
		}
		else {
			// So evt must be a string
			// And listeners must be an array of listeners
			// Loop over it and pass each one to the multiple method
			i = listeners.length;
			while (i--) {
				single.call(this, evt, listeners[i]);
			}
		}

		return this;
	};

	/**
	 * Removes all listeners from a specified event.
	 * If you do not specify an event then all listeners will be removed.
	 * That means every event will be emptied.
	 * You can also pass a regex to remove all events that match it.
	 *
	 * @param {String|RegExp} [evt] Optional name of the event to remove all listeners for. Will remove from every event if not passed.
	 * @return {Object} Current instance of EventEmitter for chaining.
	 */
	proto.removeEvent = function removeEvent(evt) {
		var type = typeof evt;
		var events = this._getEvents();
		var key;

		// Remove different things depending on the state of evt
		if (type === 'string') {
			// Remove all listeners for the specified event
			delete events[evt];
		}
		else if (evt instanceof RegExp) {
			// Remove all events matching the regex.
			for (key in events) {
				if (events.hasOwnProperty(key) && evt.test(key)) {
					delete events[key];
				}
			}
		}
		else {
			// Remove all listeners in all events
			delete this._events;
		}

		return this;
	};

	/**
	 * Alias of removeEvent.
	 *
	 * Added to mirror the node API.
	 */
	proto.removeAllListeners = alias('removeEvent');

	/**
	 * Emits an event of your choice.
	 * When emitted, every listener attached to that event will be executed.
	 * If you pass the optional argument array then those arguments will be passed to every listener upon execution.
	 * Because it uses `apply`, your array of arguments will be passed as if you wrote them out separately.
	 * So they will not arrive within the array on the other side, they will be separate.
	 * You can also pass a regular expression to emit to all events that match it.
	 *
	 * @param {String|RegExp} evt Name of the event to emit and execute listeners for.
	 * @param {Array} [args] Optional array of arguments to be passed to each listener.
	 * @return {Object} Current instance of EventEmitter for chaining.
	 */
	proto.emitEvent = function emitEvent(evt, args) {
		var listeners = this.getListenersAsObject(evt);
		var listener;
		var i;
		var key;
		var response;

		for (key in listeners) {
			if (listeners.hasOwnProperty(key)) {
				i = listeners[key].length;

				while (i--) {
					// If the listener returns true then it shall be removed from the event
					// The function is executed either with a basic call or an apply if there is an args array
					listener = listeners[key][i];

					if (listener.once === true) {
						this.removeListener(evt, listener.listener);
					}

					response = listener.listener.apply(this, args || []);

					if (response === this._getOnceReturnValue()) {
						this.removeListener(evt, listener.listener);
					}
				}
			}
		}

		return this;
	};

	/**
	 * Alias of emitEvent
	 */
	proto.trigger = alias('emitEvent');

	/**
	 * Subtly different from emitEvent in that it will pass its arguments on to the listeners, as opposed to taking a single array of arguments to pass on.
	 * As with emitEvent, you can pass a regex in place of the event name to emit to all events that match it.
	 *
	 * @param {String|RegExp} evt Name of the event to emit and execute listeners for.
	 * @param {...*} Optional additional arguments to be passed to each listener.
	 * @return {Object} Current instance of EventEmitter for chaining.
	 */
	proto.emit = function emit(evt) {
		var args = Array.prototype.slice.call(arguments, 1);
		return this.emitEvent(evt, args);
	};

	/**
	 * Sets the current value to check against when executing listeners. If a
	 * listeners return value matches the one set here then it will be removed
	 * after execution. This value defaults to true.
	 *
	 * @param {*} value The new value to check for when executing listeners.
	 * @return {Object} Current instance of EventEmitter for chaining.
	 */
	proto.setOnceReturnValue = function setOnceReturnValue(value) {
		this._onceReturnValue = value;
		return this;
	};

	/**
	 * Fetches the current value to check against when executing listeners. If
	 * the listeners return value matches this one then it should be removed
	 * automatically. It will return true by default.
	 *
	 * @return {*|Boolean} The current value to check for or the default, true.
	 * @api private
	 */
	proto._getOnceReturnValue = function _getOnceReturnValue() {
		if (this.hasOwnProperty('_onceReturnValue')) {
			return this._onceReturnValue;
		}
		else {
			return true;
		}
	};

	/**
	 * Fetches the events object and creates one if required.
	 *
	 * @return {Object} The events storage object.
	 * @api private
	 */
	proto._getEvents = function _getEvents() {
		return this._events || (this._events = {});
	};

	/**
	 * Reverts the global {@link EventEmitter} to its previous value and returns a reference to this version.
	 *
	 * @return {Function} Non conflicting EventEmitter class.
	 */
	EventEmitter.noConflict = function noConflict() {
		exports.EventEmitter = originalGlobalValue;
		return EventEmitter;
	};

	return EventEmitter;
}());
/* jshint ignore:end */



	var validateTypeFunction = function( value, name ) {
		validateType( value, name, typeof value === "undefined" || typeof value === "function", "Function" );
	};




	var superGet, superInit,
		globalEe = new EventEmitter();

	function validateTypeEvent( value, name ) {
		validateType( value, name, typeof value === "string" || value instanceof RegExp, "String or RegExp" );
	}

	function validateThenCall( method, self ) {
		return function( event, listener ) {
			validatePresence( event, "event" );
			validateTypeEvent( event, "event" );

			validatePresence( listener, "listener" );
			validateTypeFunction( listener, "listener" );

			return self[ method ].apply( self, arguments );
		};
	}

	function off( self ) {
		return validateThenCall( "off", self );
	}

	function on( self ) {
		return validateThenCall( "on", self );
	}

	function once( self ) {
		return validateThenCall( "once", self );
	}

	Cldr.off = off( globalEe );
	Cldr.on = on( globalEe );
	Cldr.once = once( globalEe );

	/**
	 * Overload Cldr.prototype.init().
	 */
	superInit = Cldr.prototype.init;
	Cldr.prototype.init = function() {
		var ee;
		this.ee = ee = new EventEmitter();
		this.off = off( ee );
		this.on = on( ee );
		this.once = once( ee );
		superInit.apply( this, arguments );
	};

	/**
	 * getOverload is encapsulated, because of cldr/unresolved. If it's loaded
	 * after cldr/event (and note it overwrites .get), it can trigger this
	 * overload again.
	 */
	function getOverload() {

		/**
		 * Overload Cldr.prototype.get().
		 */
		superGet = Cldr.prototype.get;
		Cldr.prototype.get = function( path ) {
			var value = superGet.apply( this, arguments );
			path = pathNormalize( path, this.attributes ).join( "/" );
			globalEe.trigger( "get", [ path, value ] );
			this.ee.trigger( "get", [ path, value ] );
			return value;
		};
	}

	Cldr._eventInit = getOverload;
	getOverload();

	return Cldr;




}));

/**
 * CLDR JavaScript Library v0.5.4
 * http://jquery.com/
 *
 * Copyright 2013 Rafael Xavier de Souza
 * Released under the MIT license
 * http://jquery.org/license
 *
 * Date: 2020-10-22T15:56Z
 */
/*!
 * CLDR JavaScript Library v0.5.4 2020-10-22T15:56Z MIT license © Rafael Xavier
 * http://git.io/h4lmVg
 */
(function( factory ) {

	if ( typeof define === "function" && define.amd ) {
		// AMD.
		define( [ "../cldr" ], factory );
	} else if ( typeof module === "object" && typeof module.exports === "object" ) {
		// Node. CommonJS.
		module.exports = factory( require( "../cldr" ) );
	} else {
		// Global
		factory( Cldr );
	}

}(function( Cldr ) {

	// Build optimization hack to avoid duplicating functions across modules.
	var alwaysArray = Cldr._alwaysArray;



	var supplementalMain = function( cldr ) {

		var prepend, supplemental;
		
		prepend = function( prepend ) {
			return function( path ) {
				path = alwaysArray( path );
				return cldr.get( [ prepend ].concat( path ) );
			};
		};

		supplemental = prepend( "supplemental" );

		// Week Data
		// http://www.unicode.org/reports/tr35/tr35-dates.html#Week_Data
		supplemental.weekData = prepend( "supplemental/weekData" );

		supplemental.weekData.firstDay = function() {
			return cldr.get( "supplemental/weekData/firstDay/{territory}" ) ||
				cldr.get( "supplemental/weekData/firstDay/001" );
		};

		supplemental.weekData.minDays = function() {
			var minDays = cldr.get( "supplemental/weekData/minDays/{territory}" ) ||
				cldr.get( "supplemental/weekData/minDays/001" );
			return parseInt( minDays, 10 );
		};

		// Time Data
		// http://www.unicode.org/reports/tr35/tr35-dates.html#Time_Data
		supplemental.timeData = prepend( "supplemental/timeData" );

		supplemental.timeData.allowed = function() {
			return cldr.get( "supplemental/timeData/{territory}/_allowed" ) ||
				cldr.get( "supplemental/timeData/001/_allowed" );
		};

		supplemental.timeData.preferred = function() {
			return cldr.get( "supplemental/timeData/{territory}/_preferred" ) ||
				cldr.get( "supplemental/timeData/001/_preferred" );
		};

		return supplemental;

	};




	var initSuper = Cldr.prototype.init;

	/**
	 * .init() automatically ran on construction.
	 *
	 * Overload .init().
	 */
	Cldr.prototype.init = function() {
		initSuper.apply( this, arguments );
		this.supplemental = supplementalMain( this );
	};

	return Cldr;




}));

/**
 * CLDR JavaScript Library v0.5.4
 * http://jquery.com/
 *
 * Copyright 2013 Rafael Xavier de Souza
 * Released under the MIT license
 * http://jquery.org/license
 *
 * Date: 2020-10-22T15:56Z
 */
/*!
 * CLDR JavaScript Library v0.5.4 2020-10-22T15:56Z MIT license © Rafael Xavier
 * http://git.io/h4lmVg
 */
(function( factory ) {

	if ( typeof define === "function" && define.amd ) {
		// AMD.
		define( [ "../cldr" ], factory );
	} else if ( typeof module === "object" && typeof module.exports === "object" ) {
		// Node. CommonJS.
		module.exports = factory( require( "../cldr" ) );
	} else {
		// Global
		factory( Cldr );
	}

}(function( Cldr ) {

	// Build optimization hack to avoid duplicating functions across modules.
	var coreLoad = Cldr._coreLoad;
	var jsonMerge = Cldr._jsonMerge;
	var pathNormalize = Cldr._pathNormalize;
	var resourceGet = Cldr._resourceGet;
	var validatePresence = Cldr._validatePresence;
	var validateTypePath = Cldr._validateTypePath;



	var bundleParentLookup = function( Cldr, locale ) {
		var normalizedPath, parent;

		if ( locale === "root" ) {
			return;
		}

		// First, try to find parent on supplemental data.
		normalizedPath = pathNormalize( [ "supplemental/parentLocales/parentLocale", locale ] );
		parent = resourceGet( Cldr._resolved, normalizedPath ) || resourceGet( Cldr._raw, normalizedPath );
		if ( parent ) {
			return parent;
		}

		// Or truncate locale.
		parent = locale.substr( 0, locale.lastIndexOf( Cldr.localeSep ) );
		if ( !parent ) {
			return "root";
		}

		return parent;
	};




	// @path: normalized path
	var resourceSet = function( data, path, value ) {
		var i,
			node = data,
			length = path.length;

		for ( i = 0; i < length - 1; i++ ) {
			if ( !node[ path[ i ] ] ) {
				node[ path[ i ] ] = {};
			}
			node = node[ path[ i ] ];
		}
		node[ path[ i ] ] = value;
	};


	var itemLookup = (function() {

	var lookup;

	lookup = function( Cldr, locale, path, attributes, childLocale ) {
		var normalizedPath, parent, value;

		// 1: Finish recursion
		// 2: Avoid infinite loop
		if ( typeof locale === "undefined" /* 1 */ || locale === childLocale /* 2 */ ) {
			return;
		}

		// Resolve path
		normalizedPath = pathNormalize( path, attributes );

		// Check resolved (cached) data first
		// 1: Due to #16, never use the cached resolved non-leaf nodes. It may not
		//    represent its leafs in its entirety.
		value = resourceGet( Cldr._resolved, normalizedPath );
		if ( value !== undefined && typeof value !== "object" /* 1 */ ) {
			return value;
		}

		// Check raw data
		value = resourceGet( Cldr._raw, normalizedPath );

		if ( value === undefined ) {
			// Or, lookup at parent locale
			parent = bundleParentLookup( Cldr, locale );
			value = lookup( Cldr, parent, path, jsonMerge( attributes, { bundle: parent }), locale );
		}

		if ( value !== undefined ) {
			// Set resolved (cached)
			resourceSet( Cldr._resolved, normalizedPath, value );
		}

		return value;
	};

	return lookup;

}());


	Cldr._raw = {};

	/**
	 * Cldr.load( json [, json, ...] )
	 *
	 * @json [JSON] CLDR data or [Array] Array of @json's.
	 *
	 * Load resolved or unresolved cldr data.
	 * Overwrite Cldr.load().
	 */
	Cldr.load = function() {
		Cldr._raw = coreLoad( Cldr, Cldr._raw, arguments );
	};

	/**
	 * Overwrite Cldr.prototype.get().
	 */
	Cldr.prototype.get = function( path ) {
		validatePresence( path, "path" );
		validateTypePath( path, "path" );

		// 1: use bundle as locale on item lookup for simplification purposes, because no other extended subtag is used anyway on bundle parent lookup.
		// 2: during init(), this method is called, but bundle is yet not defined. Use "" as a workaround in this very specific scenario.
		return itemLookup( Cldr, this.attributes && this.attributes.bundle /* 1 */ || "" /* 2 */, path, this.attributes );
	};

	// In case cldr/unresolved is loaded after cldr/event, we trigger its overloads again. Because, .get is overwritten in here.
	if ( Cldr._eventInit ) {
		Cldr._eventInit();
	}

	return Cldr;




}));

/**
 * Globalize v1.6.0
 *
 * http://github.com/jquery/globalize
 *
 * Copyright jQuery Foundation and other contributors
 * Released under the MIT license
 * http://jquery.org/license
 *
 * Date: 2020-09-08T11:54Z
 */
/*!
 * Globalize v1.6.0 2020-09-08T11:54Z Released under the MIT license
 * http://git.io/TrdQbw
 */
(function( root, factory ) {

	// UMD returnExports
	if ( typeof define === "function" && define.amd ) {

		// AMD
		define([
			"cldr",
			"cldr/event"
		], factory );
	} else if ( typeof exports === "object" ) {

		// Node, CommonJS
		module.exports = factory( require( "cldrjs" ) );
	} else {

		// Global
		root.Globalize = factory( root.Cldr );
	}
}( this, function( Cldr ) {


/**
 * A toString method that outputs meaningful values for objects or arrays and
 * still performs as fast as a plain string in case variable is string, or as
 * fast as `"" + number` in case variable is a number.
 * Ref: http://jsperf.com/my-stringify
 */
var toString = function( variable ) {
	return typeof variable === "string" ? variable : ( typeof variable === "number" ? "" +
		variable : JSON.stringify( variable ) );
};




/**
 * formatMessage( message, data )
 *
 * @message [String] A message with optional {vars} to be replaced.
 *
 * @data [Array or JSON] Object with replacing-variables content.
 *
 * Return the formatted message. For example:
 *
 * - formatMessage( "{0} second", [ 1 ] ); // 1 second
 *
 * - formatMessage( "{0}/{1}", ["m", "s"] ); // m/s
 *
 * - formatMessage( "{name} <{email}>", {
 *     name: "Foo",
 *     email: "bar@baz.qux"
 *   }); // Foo <bar@baz.qux>
 */
var formatMessage = function( message, data ) {

	// Replace {attribute}'s
	message = message.replace( /{[0-9a-zA-Z-_. ]+}/g, function( name ) {
		name = name.replace( /^{([^}]*)}$/, "$1" );
		return toString( data[ name ] );
	});

	return message;
};




var objectExtend = function() {
	var destination = arguments[ 0 ],
		sources = [].slice.call( arguments, 1 );

	sources.forEach(function( source ) {
		var prop;
		for ( prop in source ) {
			destination[ prop ] = source[ prop ];
		}
	});

	return destination;
};




var createError = function( code, message, attributes ) {
	var error;

	message = code + ( message ? ": " + formatMessage( message, attributes ) : "" );
	error = new Error( message );
	error.code = code;

	objectExtend( error, attributes );

	return error;
};




/**
 * Pushes part to parts array, concat two consecutive parts of the same type.
 */
var partsPush = function( parts, type, value ) {

		// Concat two consecutive parts of same type
		if ( parts.length && parts[ parts.length - 1 ].type === type ) {
			parts[ parts.length - 1 ].value += value;
			return;
		}

		parts.push( { type: type, value: value } );
};




/**
 * formatMessage( message, data )
 *
 * @message [String] A message with optional {vars} to be replaced.
 *
 * @data [Array or JSON] Object with replacing-variables content.
 *
 * Return the formatted message. For example:
 *
 * - formatMessage( "{0} second", [ 1 ] );
 * > [{type: "variable", value: "1", name: "0"}, {type: "literal", value: " second"}]
 *
 * - formatMessage( "{0}/{1}", ["m", "s"] );
 * > [
 *     { type: "variable", value: "m", name: "0" },
 *     { type: "literal", value: " /" },
 *     { type: "variable", value: "s", name: "1" }
 *   ]
 */
var formatMessageToParts = function( message, data ) {

	var lastOffset = 0,
		parts = [];

	// Create parts.
	message.replace( /{[0-9a-zA-Z-_. ]+}/g, function( nameIncludingBrackets, offset ) {
		var name = nameIncludingBrackets.slice( 1, -1 );
		partsPush( parts, "literal", message.slice( lastOffset, offset ));
		partsPush( parts, "variable", data[ name ] );
		parts[ parts.length - 1 ].name = name;
		lastOffset += offset + nameIncludingBrackets.length;
	});

	// Skip empty ones such as `{ type: 'literal', value: '' }`.
	return parts.filter(function( part ) {
		return part.value !== "";
	});
};




/**
 * Returns joined parts values.
 */
var partsJoin = function( parts ) {
	return parts.map( function( part ) {
		return part.value;
	}).join( "" );
};




var runtimeStringify = function( args ) {
	return JSON.stringify( args, function( key, value ) {
		if ( value && value.runtimeKey ) {
			return value.runtimeKey;
		}
		return value;
	} );
};




// Based on http://stackoverflow.com/questions/7616461/generate-a-hash-from-string-in-javascript-jquery
var stringHash = function( str ) {
	return [].reduce.call( str, function( hash, i ) {
		var chr = i.charCodeAt( 0 );
		hash = ( ( hash << 5 ) - hash ) + chr;
		return hash | 0;
	}, 0 );
};




var runtimeKey = function( fnName, locale, args, argsStr ) {
	var hash;
	argsStr = argsStr || runtimeStringify( args );
	hash = stringHash( fnName + locale + argsStr );
	return hash > 0 ? "a" + hash : "b" + Math.abs( hash );
};




var functionName = function( fn ) {
	if ( fn.name !== undefined ) {
		return fn.name;
	}

	// fn.name is not supported by IE.
	var matches = /^function\s+([\w\$]+)\s*\(/.exec( fn.toString() );

	if ( matches && matches.length > 0 ) {
		return matches[ 1 ];
	}
};




var runtimeBind = function( args, cldr, fn, runtimeArgs ) {

	var argsStr = runtimeStringify( args ),
		fnName = functionName( fn ),
		locale = cldr.locale;

	// If name of the function is not available, this is most likely due to uglification,
	// which most likely means we are in production, and runtimeBind here is not necessary.
	if ( !fnName ) {
		return fn;
	}

	fn.runtimeKey = runtimeKey( fnName, locale, null, argsStr );

	fn.generatorString = function() {
		return "Globalize(\"" + locale + "\")." + fnName + "(" + argsStr.slice( 1, -1 ) + ")";
	};

	fn.runtimeArgs = runtimeArgs;

	return fn;
};




var validate = function( code, message, check, attributes ) {
	if ( !check ) {
		throw createError( code, message, attributes );
	}
};




var alwaysArray = function( stringOrArray ) {
	return Array.isArray( stringOrArray ) ? stringOrArray : stringOrArray ? [ stringOrArray ] : [];
};




var validateCldr = function( path, value, options ) {
	var skipBoolean;
	options = options || {};

	skipBoolean = alwaysArray( options.skip ).some(function( pathRe ) {
		return pathRe.test( path );
	});

	validate( "E_MISSING_CLDR", "Missing required CLDR content `{path}`.", value || skipBoolean, {
		path: path
	});
};




var validateDefaultLocale = function( value ) {
	validate( "E_DEFAULT_LOCALE_NOT_DEFINED", "Default locale has not been defined.",
		value !== undefined, {} );
};




var validateParameterPresence = function( value, name ) {
	validate( "E_MISSING_PARAMETER", "Missing required parameter `{name}`.",
		value !== undefined, { name: name });
};




/**
 * range( value, name, minimum, maximum )
 *
 * @value [Number].
 *
 * @name [String] name of variable.
 *
 * @minimum [Number]. The lowest valid value, inclusive.
 *
 * @maximum [Number]. The greatest valid value, inclusive.
 */
var validateParameterRange = function( value, name, minimum, maximum ) {
	validate(
		"E_PAR_OUT_OF_RANGE",
		"Parameter `{name}` has value `{value}` out of range [{minimum}, {maximum}].",
		value === undefined || value >= minimum && value <= maximum,
		{
			maximum: maximum,
			minimum: minimum,
			name: name,
			value: value
		}
	);
};




var validateParameterType = function( value, name, check, expected ) {
	validate(
		"E_INVALID_PAR_TYPE",
		"Invalid `{name}` parameter ({value}). {expected} expected.",
		check,
		{
			expected: expected,
			name: name,
			value: value
		}
	);
};




var validateParameterTypeLocale = function( value, name ) {
	validateParameterType(
		value,
		name,
		value === undefined || typeof value === "string" || value instanceof Cldr,
		"String or Cldr instance"
	);
};




/**
 * Function inspired by jQuery Core, but reduced to our use case.
 */
var isPlainObject = function( obj ) {
	return obj !== null && "" + obj === "[object Object]";
};




var validateParameterTypePlainObject = function( value, name ) {
	validateParameterType(
		value,
		name,
		value === undefined || isPlainObject( value ),
		"Plain Object"
	);
};




var alwaysCldr = function( localeOrCldr ) {
	return localeOrCldr instanceof Cldr ? localeOrCldr : new Cldr( localeOrCldr );
};




// ref: https://developer.mozilla.org/en-US/docs/Web/JavaScript/Guide/Regular_Expressions?redirectlocale=en-US&redirectslug=JavaScript%2FGuide%2FRegular_Expressions
var regexpEscape = function( string ) {
	return string.replace( /([.*+?^=!:${}()|\[\]\/\\])/g, "\\$1" );
};




var stringPad = function( str, count, right ) {
	var length;
	if ( typeof str !== "string" ) {
		str = String( str );
	}
	for ( length = str.length; length < count; length += 1 ) {
		str = ( right ? ( str + "0" ) : ( "0" + str ) );
	}
	return str;
};




function validateLikelySubtags( cldr ) {
	cldr.once( "get", validateCldr );
	cldr.get( "supplemental/likelySubtags" );
}

/**
 * [new] Globalize( locale|cldr )
 *
 * @locale [String]
 *
 * @cldr [Cldr instance]
 *
 * Create a Globalize instance.
 */
function Globalize( locale ) {
	if ( !( this instanceof Globalize ) ) {
		return new Globalize( locale );
	}

	validateParameterPresence( locale, "locale" );
	validateParameterTypeLocale( locale, "locale" );

	this.cldr = alwaysCldr( locale );

	validateLikelySubtags( this.cldr );
}

/**
 * Globalize.load( json, ... )
 *
 * @json [JSON]
 *
 * Load resolved or unresolved cldr data.
 * Somewhat equivalent to previous Globalize.addCultureInfo(...).
 */
Globalize.load = function() {

	// validations are delegated to Cldr.load().
	Cldr.load.apply( Cldr, arguments );
};

/**
 * Globalize.locale( [locale|cldr] )
 *
 * @locale [String]
 *
 * @cldr [Cldr instance]
 *
 * Set default Cldr instance if locale or cldr argument is passed.
 *
 * Return the default Cldr instance.
 */
Globalize.locale = function( locale ) {
	validateParameterTypeLocale( locale, "locale" );

	if ( arguments.length ) {
		this.cldr = alwaysCldr( locale );
		validateLikelySubtags( this.cldr );
	}
	return this.cldr;
};

/**
 * Optimization to avoid duplicating some internal functions across modules.
 */
Globalize._alwaysArray = alwaysArray;
Globalize._createError = createError;
Globalize._formatMessage = formatMessage;
Globalize._formatMessageToParts = formatMessageToParts;
Globalize._isPlainObject = isPlainObject;
Globalize._objectExtend = objectExtend;
Globalize._partsJoin = partsJoin;
Globalize._partsPush = partsPush;
Globalize._regexpEscape = regexpEscape;
Globalize._runtimeBind = runtimeBind;
Globalize._stringPad = stringPad;
Globalize._validate = validate;
Globalize._validateCldr = validateCldr;
Globalize._validateDefaultLocale = validateDefaultLocale;
Globalize._validateParameterPresence = validateParameterPresence;
Globalize._validateParameterRange = validateParameterRange;
Globalize._validateParameterTypePlainObject = validateParameterTypePlainObject;
Globalize._validateParameterType = validateParameterType;

return Globalize;




}));

/**
 * Globalize v1.6.0
 *
 * http://github.com/jquery/globalize
 *
 * Copyright jQuery Foundation and other contributors
 * Released under the MIT license
 * http://jquery.org/license
 *
 * Date: 2020-09-08T11:54Z
 */
/*!
 * Globalize v1.6.0 2020-09-08T11:54Z Released under the MIT license
 * http://git.io/TrdQbw
 */
(function( root, factory ) {

	// UMD returnExports
	if ( typeof define === "function" && define.amd ) {

		// AMD
		define([
			"cldr",
			"../globalize",
			"cldr/event"
		], factory );
	} else if ( typeof exports === "object" ) {

		// Node, CommonJS
		module.exports = factory( require( "cldrjs" ), require( "../globalize" ) );
	} else {

		// Extend global
		factory( root.Cldr, root.Globalize );
	}
}(this, function( Cldr, Globalize ) {

var alwaysArray = Globalize._alwaysArray,
	createError = Globalize._createError,
	isPlainObject = Globalize._isPlainObject,
	runtimeBind = Globalize._runtimeBind,
	validateDefaultLocale = Globalize._validateDefaultLocale,
	validate = Globalize._validate,
	validateParameterPresence = Globalize._validateParameterPresence,
	validateParameterType = Globalize._validateParameterType,
	validateParameterTypePlainObject = Globalize._validateParameterTypePlainObject;
var MessageFormat;
/* jshint ignore:start */
MessageFormat = (function() {
MessageFormat._parse = (function() {

  /*
   * Generated by PEG.js 0.8.0.
   *
   * http://pegjs.majda.cz/
   */

  function peg$subclass(child, parent) {
    function ctor() { this.constructor = child; }
    ctor.prototype = parent.prototype;
    child.prototype = new ctor();
  }

  function SyntaxError(message, expected, found, offset, line, column) {
    this.message  = message;
    this.expected = expected;
    this.found    = found;
    this.offset   = offset;
    this.line     = line;
    this.column   = column;

    this.name     = "SyntaxError";
  }

  peg$subclass(SyntaxError, Error);

  function parse(input) {
    var options = arguments.length > 1 ? arguments[1] : {},

        peg$FAILED = {},

        peg$startRuleFunctions = { start: peg$parsestart },
        peg$startRuleFunction  = peg$parsestart,

        peg$c0 = [],
        peg$c1 = function(st) {
              return { type: 'messageFormatPattern', statements: st };
            },
        peg$c2 = peg$FAILED,
        peg$c3 = "{",
        peg$c4 = { type: "literal", value: "{", description: "\"{\"" },
        peg$c5 = null,
        peg$c6 = ",",
        peg$c7 = { type: "literal", value: ",", description: "\",\"" },
        peg$c8 = "}",
        peg$c9 = { type: "literal", value: "}", description: "\"}\"" },
        peg$c10 = function(argIdx, efmt) {
              var res = {
                type: "messageFormatElement",
                argumentIndex: argIdx
              };
              if (efmt && efmt.length) {
                res.elementFormat = efmt[1];
              } else {
                res.output = true;
              }
              return res;
            },
        peg$c11 = "plural",
        peg$c12 = { type: "literal", value: "plural", description: "\"plural\"" },
        peg$c13 = function(t, s) {
              return { type: "elementFormat", key: t, val: s };
            },
        peg$c14 = "selectordinal",
        peg$c15 = { type: "literal", value: "selectordinal", description: "\"selectordinal\"" },
        peg$c16 = "select",
        peg$c17 = { type: "literal", value: "select", description: "\"select\"" },
        peg$c18 = function(t, p) {
              return { type: "elementFormat", key: t, val: p };
            },
        peg$c19 = function(op, pf) {
              return { type: "pluralFormatPattern", pluralForms: pf, offset: op || 0 };
            },
        peg$c20 = "offset",
        peg$c21 = { type: "literal", value: "offset", description: "\"offset\"" },
        peg$c22 = ":",
        peg$c23 = { type: "literal", value: ":", description: "\":\"" },
        peg$c24 = function(d) { return d; },
        peg$c25 = function(k, mfp) {
              return { key: k, val: mfp };
            },
        peg$c26 = function(i) { return i; },
        peg$c27 = "=",
        peg$c28 = { type: "literal", value: "=", description: "\"=\"" },
        peg$c29 = function(pf) { return { type: "selectFormatPattern", pluralForms: pf }; },
        peg$c30 = function(p) { return p; },
        peg$c31 = "#",
        peg$c32 = { type: "literal", value: "#", description: "\"#\"" },
        peg$c33 = function() { return {type: 'octothorpe'}; },
        peg$c34 = function(s) { return { type: "string", val: s.join('') }; },
        peg$c35 = { type: "other", description: "identifier" },
        peg$c36 = /^[0-9a-zA-Z$_]/,
        peg$c37 = { type: "class", value: "[0-9a-zA-Z$_]", description: "[0-9a-zA-Z$_]" },
        peg$c38 = /^[^ \t\n\r,.+={}]/,
        peg$c39 = { type: "class", value: "[^ \\t\\n\\r,.+={}]", description: "[^ \\t\\n\\r,.+={}]" },
        peg$c40 = function(s) { return s; },
        peg$c41 = function(chars) { return chars.join(''); },
        peg$c42 = /^[^{}#\\\0-\x1F \t\n\r]/,
        peg$c43 = { type: "class", value: "[^{}#\\\\\\0-\\x1F \\t\\n\\r]", description: "[^{}#\\\\\\0-\\x1F \\t\\n\\r]" },
        peg$c44 = function(x) { return x; },
        peg$c45 = "\\\\",
        peg$c46 = { type: "literal", value: "\\\\", description: "\"\\\\\\\\\"" },
        peg$c47 = function() { return "\\"; },
        peg$c48 = "\\#",
        peg$c49 = { type: "literal", value: "\\#", description: "\"\\\\#\"" },
        peg$c50 = function() { return "#"; },
        peg$c51 = "\\{",
        peg$c52 = { type: "literal", value: "\\{", description: "\"\\\\{\"" },
        peg$c53 = function() { return "\u007B"; },
        peg$c54 = "\\}",
        peg$c55 = { type: "literal", value: "\\}", description: "\"\\\\}\"" },
        peg$c56 = function() { return "\u007D"; },
        peg$c57 = "\\u",
        peg$c58 = { type: "literal", value: "\\u", description: "\"\\\\u\"" },
        peg$c59 = function(h1, h2, h3, h4) {
              return String.fromCharCode(parseInt("0x" + h1 + h2 + h3 + h4));
            },
        peg$c60 = /^[0-9]/,
        peg$c61 = { type: "class", value: "[0-9]", description: "[0-9]" },
        peg$c62 = function(ds) {
            //the number might start with 0 but must not be interpreted as an octal number
            //Hence, the base is passed to parseInt explicitely
            return parseInt((ds.join('')), 10);
          },
        peg$c63 = /^[0-9a-fA-F]/,
        peg$c64 = { type: "class", value: "[0-9a-fA-F]", description: "[0-9a-fA-F]" },
        peg$c65 = { type: "other", description: "whitespace" },
        peg$c66 = function(w) { return w.join(''); },
        peg$c67 = /^[ \t\n\r]/,
        peg$c68 = { type: "class", value: "[ \\t\\n\\r]", description: "[ \\t\\n\\r]" },

        peg$currPos          = 0,
        peg$reportedPos      = 0,
        peg$cachedPos        = 0,
        peg$cachedPosDetails = { line: 1, column: 1, seenCR: false },
        peg$maxFailPos       = 0,
        peg$maxFailExpected  = [],
        peg$silentFails      = 0,

        peg$result;

    if ("startRule" in options) {
      if (!(options.startRule in peg$startRuleFunctions)) {
        throw new Error("Can't start parsing from rule \"" + options.startRule + "\".");
      }

      peg$startRuleFunction = peg$startRuleFunctions[options.startRule];
    }

    function text() {
      return input.substring(peg$reportedPos, peg$currPos);
    }

    function offset() {
      return peg$reportedPos;
    }

    function line() {
      return peg$computePosDetails(peg$reportedPos).line;
    }

    function column() {
      return peg$computePosDetails(peg$reportedPos).column;
    }

    function expected(description) {
      throw peg$buildException(
        null,
        [{ type: "other", description: description }],
        peg$reportedPos
      );
    }

    function error(message) {
      throw peg$buildException(message, null, peg$reportedPos);
    }

    function peg$computePosDetails(pos) {
      function advance(details, startPos, endPos) {
        var p, ch;

        for (p = startPos; p < endPos; p++) {
          ch = input.charAt(p);
          if (ch === "\n") {
            if (!details.seenCR) { details.line++; }
            details.column = 1;
            details.seenCR = false;
          } else if (ch === "\r" || ch === "\u2028" || ch === "\u2029") {
            details.line++;
            details.column = 1;
            details.seenCR = true;
          } else {
            details.column++;
            details.seenCR = false;
          }
        }
      }

      if (peg$cachedPos !== pos) {
        if (peg$cachedPos > pos) {
          peg$cachedPos = 0;
          peg$cachedPosDetails = { line: 1, column: 1, seenCR: false };
        }
        advance(peg$cachedPosDetails, peg$cachedPos, pos);
        peg$cachedPos = pos;
      }

      return peg$cachedPosDetails;
    }

    function peg$fail(expected) {
      if (peg$currPos < peg$maxFailPos) { return; }

      if (peg$currPos > peg$maxFailPos) {
        peg$maxFailPos = peg$currPos;
        peg$maxFailExpected = [];
      }

      peg$maxFailExpected.push(expected);
    }

    function peg$buildException(message, expected, pos) {
      function cleanupExpected(expected) {
        var i = 1;

        expected.sort(function(a, b) {
          if (a.description < b.description) {
            return -1;
          } else if (a.description > b.description) {
            return 1;
          } else {
            return 0;
          }
        });

        while (i < expected.length) {
          if (expected[i - 1] === expected[i]) {
            expected.splice(i, 1);
          } else {
            i++;
          }
        }
      }

      function buildMessage(expected, found) {
        function stringEscape(s) {
          function hex(ch) { return ch.charCodeAt(0).toString(16).toUpperCase(); }

          return s
            .replace(/\\/g,   '\\\\')
            .replace(/"/g,    '\\"')
            .replace(/\x08/g, '\\b')
            .replace(/\t/g,   '\\t')
            .replace(/\n/g,   '\\n')
            .replace(/\f/g,   '\\f')
            .replace(/\r/g,   '\\r')
            .replace(/[\x00-\x07\x0B\x0E\x0F]/g, function(ch) { return '\\x0' + hex(ch); })
            .replace(/[\x10-\x1F\x80-\xFF]/g,    function(ch) { return '\\x'  + hex(ch); })
            .replace(/[\u0180-\u0FFF]/g,         function(ch) { return '\\u0' + hex(ch); })
            .replace(/[\u1080-\uFFFF]/g,         function(ch) { return '\\u'  + hex(ch); });
        }

        var expectedDescs = new Array(expected.length),
            expectedDesc, foundDesc, i;

        for (i = 0; i < expected.length; i++) {
          expectedDescs[i] = expected[i].description;
        }

        expectedDesc = expected.length > 1
          ? expectedDescs.slice(0, -1).join(", ")
              + " or "
              + expectedDescs[expected.length - 1]
          : expectedDescs[0];

        foundDesc = found ? "\"" + stringEscape(found) + "\"" : "end of input";

        return "Expected " + expectedDesc + " but " + foundDesc + " found.";
      }

      var posDetails = peg$computePosDetails(pos),
          found      = pos < input.length ? input.charAt(pos) : null;

      if (expected !== null) {
        cleanupExpected(expected);
      }

      return new SyntaxError(
        message !== null ? message : buildMessage(expected, found),
        expected,
        found,
        pos,
        posDetails.line,
        posDetails.column
      );
    }

    function peg$parsestart() {
      var s0;

      s0 = peg$parsemessageFormatPattern();

      return s0;
    }

    function peg$parsemessageFormatPattern() {
      var s0, s1, s2;

      s0 = peg$currPos;
      s1 = [];
      s2 = peg$parsemessageFormatElement();
      if (s2 === peg$FAILED) {
        s2 = peg$parsestring();
        if (s2 === peg$FAILED) {
          s2 = peg$parseoctothorpe();
        }
      }
      while (s2 !== peg$FAILED) {
        s1.push(s2);
        s2 = peg$parsemessageFormatElement();
        if (s2 === peg$FAILED) {
          s2 = peg$parsestring();
          if (s2 === peg$FAILED) {
            s2 = peg$parseoctothorpe();
          }
        }
      }
      if (s1 !== peg$FAILED) {
        peg$reportedPos = s0;
        s1 = peg$c1(s1);
      }
      s0 = s1;

      return s0;
    }

    function peg$parsemessageFormatElement() {
      var s0, s1, s2, s3, s4, s5, s6;

      s0 = peg$currPos;
      if (input.charCodeAt(peg$currPos) === 123) {
        s1 = peg$c3;
        peg$currPos++;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c4); }
      }
      if (s1 !== peg$FAILED) {
        s2 = peg$parse_();
        if (s2 !== peg$FAILED) {
          s3 = peg$parseid();
          if (s3 !== peg$FAILED) {
            s4 = peg$currPos;
            if (input.charCodeAt(peg$currPos) === 44) {
              s5 = peg$c6;
              peg$currPos++;
            } else {
              s5 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c7); }
            }
            if (s5 !== peg$FAILED) {
              s6 = peg$parseelementFormat();
              if (s6 !== peg$FAILED) {
                s5 = [s5, s6];
                s4 = s5;
              } else {
                peg$currPos = s4;
                s4 = peg$c2;
              }
            } else {
              peg$currPos = s4;
              s4 = peg$c2;
            }
            if (s4 === peg$FAILED) {
              s4 = peg$c5;
            }
            if (s4 !== peg$FAILED) {
              s5 = peg$parse_();
              if (s5 !== peg$FAILED) {
                if (input.charCodeAt(peg$currPos) === 125) {
                  s6 = peg$c8;
                  peg$currPos++;
                } else {
                  s6 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$c9); }
                }
                if (s6 !== peg$FAILED) {
                  peg$reportedPos = s0;
                  s1 = peg$c10(s3, s4);
                  s0 = s1;
                } else {
                  peg$currPos = s0;
                  s0 = peg$c2;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$c2;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$c2;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$c2;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$c2;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$c2;
      }

      return s0;
    }

    function peg$parseelementFormat() {
      var s0, s1, s2, s3, s4, s5, s6, s7;

      s0 = peg$currPos;
      s1 = peg$parse_();
      if (s1 !== peg$FAILED) {
        if (input.substr(peg$currPos, 6) === peg$c11) {
          s2 = peg$c11;
          peg$currPos += 6;
        } else {
          s2 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c12); }
        }
        if (s2 !== peg$FAILED) {
          s3 = peg$parse_();
          if (s3 !== peg$FAILED) {
            if (input.charCodeAt(peg$currPos) === 44) {
              s4 = peg$c6;
              peg$currPos++;
            } else {
              s4 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c7); }
            }
            if (s4 !== peg$FAILED) {
              s5 = peg$parse_();
              if (s5 !== peg$FAILED) {
                s6 = peg$parsepluralFormatPattern();
                if (s6 !== peg$FAILED) {
                  s7 = peg$parse_();
                  if (s7 !== peg$FAILED) {
                    peg$reportedPos = s0;
                    s1 = peg$c13(s2, s6);
                    s0 = s1;
                  } else {
                    peg$currPos = s0;
                    s0 = peg$c2;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$c2;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$c2;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$c2;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$c2;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$c2;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$c2;
      }
      if (s0 === peg$FAILED) {
        s0 = peg$currPos;
        s1 = peg$parse_();
        if (s1 !== peg$FAILED) {
          if (input.substr(peg$currPos, 13) === peg$c14) {
            s2 = peg$c14;
            peg$currPos += 13;
          } else {
            s2 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c15); }
          }
          if (s2 !== peg$FAILED) {
            s3 = peg$parse_();
            if (s3 !== peg$FAILED) {
              if (input.charCodeAt(peg$currPos) === 44) {
                s4 = peg$c6;
                peg$currPos++;
              } else {
                s4 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$c7); }
              }
              if (s4 !== peg$FAILED) {
                s5 = peg$parse_();
                if (s5 !== peg$FAILED) {
                  s6 = peg$parsepluralFormatPattern();
                  if (s6 !== peg$FAILED) {
                    s7 = peg$parse_();
                    if (s7 !== peg$FAILED) {
                      peg$reportedPos = s0;
                      s1 = peg$c13(s2, s6);
                      s0 = s1;
                    } else {
                      peg$currPos = s0;
                      s0 = peg$c2;
                    }
                  } else {
                    peg$currPos = s0;
                    s0 = peg$c2;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$c2;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$c2;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$c2;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$c2;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$c2;
        }
        if (s0 === peg$FAILED) {
          s0 = peg$currPos;
          s1 = peg$parse_();
          if (s1 !== peg$FAILED) {
            if (input.substr(peg$currPos, 6) === peg$c16) {
              s2 = peg$c16;
              peg$currPos += 6;
            } else {
              s2 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c17); }
            }
            if (s2 !== peg$FAILED) {
              s3 = peg$parse_();
              if (s3 !== peg$FAILED) {
                if (input.charCodeAt(peg$currPos) === 44) {
                  s4 = peg$c6;
                  peg$currPos++;
                } else {
                  s4 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$c7); }
                }
                if (s4 !== peg$FAILED) {
                  s5 = peg$parse_();
                  if (s5 !== peg$FAILED) {
                    s6 = peg$parseselectFormatPattern();
                    if (s6 !== peg$FAILED) {
                      s7 = peg$parse_();
                      if (s7 !== peg$FAILED) {
                        peg$reportedPos = s0;
                        s1 = peg$c13(s2, s6);
                        s0 = s1;
                      } else {
                        peg$currPos = s0;
                        s0 = peg$c2;
                      }
                    } else {
                      peg$currPos = s0;
                      s0 = peg$c2;
                    }
                  } else {
                    peg$currPos = s0;
                    s0 = peg$c2;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$c2;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$c2;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$c2;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$c2;
          }
          if (s0 === peg$FAILED) {
            s0 = peg$currPos;
            s1 = peg$parse_();
            if (s1 !== peg$FAILED) {
              s2 = peg$parseid();
              if (s2 !== peg$FAILED) {
                s3 = [];
                s4 = peg$parseargStylePattern();
                while (s4 !== peg$FAILED) {
                  s3.push(s4);
                  s4 = peg$parseargStylePattern();
                }
                if (s3 !== peg$FAILED) {
                  peg$reportedPos = s0;
                  s1 = peg$c18(s2, s3);
                  s0 = s1;
                } else {
                  peg$currPos = s0;
                  s0 = peg$c2;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$c2;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$c2;
            }
          }
        }
      }

      return s0;
    }

    function peg$parsepluralFormatPattern() {
      var s0, s1, s2, s3;

      s0 = peg$currPos;
      s1 = peg$parseoffsetPattern();
      if (s1 === peg$FAILED) {
        s1 = peg$c5;
      }
      if (s1 !== peg$FAILED) {
        s2 = [];
        s3 = peg$parsepluralForm();
        if (s3 !== peg$FAILED) {
          while (s3 !== peg$FAILED) {
            s2.push(s3);
            s3 = peg$parsepluralForm();
          }
        } else {
          s2 = peg$c2;
        }
        if (s2 !== peg$FAILED) {
          peg$reportedPos = s0;
          s1 = peg$c19(s1, s2);
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$c2;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$c2;
      }

      return s0;
    }

    function peg$parseoffsetPattern() {
      var s0, s1, s2, s3, s4, s5, s6, s7;

      s0 = peg$currPos;
      s1 = peg$parse_();
      if (s1 !== peg$FAILED) {
        if (input.substr(peg$currPos, 6) === peg$c20) {
          s2 = peg$c20;
          peg$currPos += 6;
        } else {
          s2 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c21); }
        }
        if (s2 !== peg$FAILED) {
          s3 = peg$parse_();
          if (s3 !== peg$FAILED) {
            if (input.charCodeAt(peg$currPos) === 58) {
              s4 = peg$c22;
              peg$currPos++;
            } else {
              s4 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c23); }
            }
            if (s4 !== peg$FAILED) {
              s5 = peg$parse_();
              if (s5 !== peg$FAILED) {
                s6 = peg$parsedigits();
                if (s6 !== peg$FAILED) {
                  s7 = peg$parse_();
                  if (s7 !== peg$FAILED) {
                    peg$reportedPos = s0;
                    s1 = peg$c24(s6);
                    s0 = s1;
                  } else {
                    peg$currPos = s0;
                    s0 = peg$c2;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$c2;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$c2;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$c2;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$c2;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$c2;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$c2;
      }

      return s0;
    }

    function peg$parsepluralForm() {
      var s0, s1, s2, s3, s4, s5, s6, s7, s8;

      s0 = peg$currPos;
      s1 = peg$parse_();
      if (s1 !== peg$FAILED) {
        s2 = peg$parsepluralKey();
        if (s2 !== peg$FAILED) {
          s3 = peg$parse_();
          if (s3 !== peg$FAILED) {
            if (input.charCodeAt(peg$currPos) === 123) {
              s4 = peg$c3;
              peg$currPos++;
            } else {
              s4 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c4); }
            }
            if (s4 !== peg$FAILED) {
              s5 = peg$parse_();
              if (s5 !== peg$FAILED) {
                s6 = peg$parsemessageFormatPattern();
                if (s6 !== peg$FAILED) {
                  s7 = peg$parse_();
                  if (s7 !== peg$FAILED) {
                    if (input.charCodeAt(peg$currPos) === 125) {
                      s8 = peg$c8;
                      peg$currPos++;
                    } else {
                      s8 = peg$FAILED;
                      if (peg$silentFails === 0) { peg$fail(peg$c9); }
                    }
                    if (s8 !== peg$FAILED) {
                      peg$reportedPos = s0;
                      s1 = peg$c25(s2, s6);
                      s0 = s1;
                    } else {
                      peg$currPos = s0;
                      s0 = peg$c2;
                    }
                  } else {
                    peg$currPos = s0;
                    s0 = peg$c2;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$c2;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$c2;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$c2;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$c2;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$c2;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$c2;
      }

      return s0;
    }

    function peg$parsepluralKey() {
      var s0, s1, s2;

      s0 = peg$currPos;
      s1 = peg$parseid();
      if (s1 !== peg$FAILED) {
        peg$reportedPos = s0;
        s1 = peg$c26(s1);
      }
      s0 = s1;
      if (s0 === peg$FAILED) {
        s0 = peg$currPos;
        if (input.charCodeAt(peg$currPos) === 61) {
          s1 = peg$c27;
          peg$currPos++;
        } else {
          s1 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c28); }
        }
        if (s1 !== peg$FAILED) {
          s2 = peg$parsedigits();
          if (s2 !== peg$FAILED) {
            peg$reportedPos = s0;
            s1 = peg$c24(s2);
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$c2;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$c2;
        }
      }

      return s0;
    }

    function peg$parseselectFormatPattern() {
      var s0, s1, s2;

      s0 = peg$currPos;
      s1 = [];
      s2 = peg$parseselectForm();
      if (s2 !== peg$FAILED) {
        while (s2 !== peg$FAILED) {
          s1.push(s2);
          s2 = peg$parseselectForm();
        }
      } else {
        s1 = peg$c2;
      }
      if (s1 !== peg$FAILED) {
        peg$reportedPos = s0;
        s1 = peg$c29(s1);
      }
      s0 = s1;

      return s0;
    }

    function peg$parseselectForm() {
      var s0, s1, s2, s3, s4, s5, s6, s7, s8;

      s0 = peg$currPos;
      s1 = peg$parse_();
      if (s1 !== peg$FAILED) {
        s2 = peg$parseid();
        if (s2 !== peg$FAILED) {
          s3 = peg$parse_();
          if (s3 !== peg$FAILED) {
            if (input.charCodeAt(peg$currPos) === 123) {
              s4 = peg$c3;
              peg$currPos++;
            } else {
              s4 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c4); }
            }
            if (s4 !== peg$FAILED) {
              s5 = peg$parse_();
              if (s5 !== peg$FAILED) {
                s6 = peg$parsemessageFormatPattern();
                if (s6 !== peg$FAILED) {
                  s7 = peg$parse_();
                  if (s7 !== peg$FAILED) {
                    if (input.charCodeAt(peg$currPos) === 125) {
                      s8 = peg$c8;
                      peg$currPos++;
                    } else {
                      s8 = peg$FAILED;
                      if (peg$silentFails === 0) { peg$fail(peg$c9); }
                    }
                    if (s8 !== peg$FAILED) {
                      peg$reportedPos = s0;
                      s1 = peg$c25(s2, s6);
                      s0 = s1;
                    } else {
                      peg$currPos = s0;
                      s0 = peg$c2;
                    }
                  } else {
                    peg$currPos = s0;
                    s0 = peg$c2;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$c2;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$c2;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$c2;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$c2;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$c2;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$c2;
      }

      return s0;
    }

    function peg$parseargStylePattern() {
      var s0, s1, s2, s3, s4, s5;

      s0 = peg$currPos;
      s1 = peg$parse_();
      if (s1 !== peg$FAILED) {
        if (input.charCodeAt(peg$currPos) === 44) {
          s2 = peg$c6;
          peg$currPos++;
        } else {
          s2 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c7); }
        }
        if (s2 !== peg$FAILED) {
          s3 = peg$parse_();
          if (s3 !== peg$FAILED) {
            s4 = peg$parseid();
            if (s4 !== peg$FAILED) {
              s5 = peg$parse_();
              if (s5 !== peg$FAILED) {
                peg$reportedPos = s0;
                s1 = peg$c30(s4);
                s0 = s1;
              } else {
                peg$currPos = s0;
                s0 = peg$c2;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$c2;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$c2;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$c2;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$c2;
      }

      return s0;
    }

    function peg$parseoctothorpe() {
      var s0, s1;

      s0 = peg$currPos;
      if (input.charCodeAt(peg$currPos) === 35) {
        s1 = peg$c31;
        peg$currPos++;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c32); }
      }
      if (s1 !== peg$FAILED) {
        peg$reportedPos = s0;
        s1 = peg$c33();
      }
      s0 = s1;

      return s0;
    }

    function peg$parsestring() {
      var s0, s1, s2;

      s0 = peg$currPos;
      s1 = [];
      s2 = peg$parsechars();
      if (s2 === peg$FAILED) {
        s2 = peg$parsewhitespace();
      }
      if (s2 !== peg$FAILED) {
        while (s2 !== peg$FAILED) {
          s1.push(s2);
          s2 = peg$parsechars();
          if (s2 === peg$FAILED) {
            s2 = peg$parsewhitespace();
          }
        }
      } else {
        s1 = peg$c2;
      }
      if (s1 !== peg$FAILED) {
        peg$reportedPos = s0;
        s1 = peg$c34(s1);
      }
      s0 = s1;

      return s0;
    }

    function peg$parseid() {
      var s0, s1, s2, s3, s4, s5, s6;

      peg$silentFails++;
      s0 = peg$currPos;
      s1 = peg$parse_();
      if (s1 !== peg$FAILED) {
        s2 = peg$currPos;
        s3 = peg$currPos;
        if (peg$c36.test(input.charAt(peg$currPos))) {
          s4 = input.charAt(peg$currPos);
          peg$currPos++;
        } else {
          s4 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c37); }
        }
        if (s4 !== peg$FAILED) {
          s5 = [];
          if (peg$c38.test(input.charAt(peg$currPos))) {
            s6 = input.charAt(peg$currPos);
            peg$currPos++;
          } else {
            s6 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c39); }
          }
          while (s6 !== peg$FAILED) {
            s5.push(s6);
            if (peg$c38.test(input.charAt(peg$currPos))) {
              s6 = input.charAt(peg$currPos);
              peg$currPos++;
            } else {
              s6 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c39); }
            }
          }
          if (s5 !== peg$FAILED) {
            s4 = [s4, s5];
            s3 = s4;
          } else {
            peg$currPos = s3;
            s3 = peg$c2;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$c2;
        }
        if (s3 !== peg$FAILED) {
          s3 = input.substring(s2, peg$currPos);
        }
        s2 = s3;
        if (s2 !== peg$FAILED) {
          s3 = peg$parse_();
          if (s3 !== peg$FAILED) {
            peg$reportedPos = s0;
            s1 = peg$c40(s2);
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$c2;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$c2;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$c2;
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c35); }
      }

      return s0;
    }

    function peg$parsechars() {
      var s0, s1, s2;

      s0 = peg$currPos;
      s1 = [];
      s2 = peg$parsechar();
      if (s2 !== peg$FAILED) {
        while (s2 !== peg$FAILED) {
          s1.push(s2);
          s2 = peg$parsechar();
        }
      } else {
        s1 = peg$c2;
      }
      if (s1 !== peg$FAILED) {
        peg$reportedPos = s0;
        s1 = peg$c41(s1);
      }
      s0 = s1;

      return s0;
    }

    function peg$parsechar() {
      var s0, s1, s2, s3, s4, s5;

      s0 = peg$currPos;
      if (peg$c42.test(input.charAt(peg$currPos))) {
        s1 = input.charAt(peg$currPos);
        peg$currPos++;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c43); }
      }
      if (s1 !== peg$FAILED) {
        peg$reportedPos = s0;
        s1 = peg$c44(s1);
      }
      s0 = s1;
      if (s0 === peg$FAILED) {
        s0 = peg$currPos;
        if (input.substr(peg$currPos, 2) === peg$c45) {
          s1 = peg$c45;
          peg$currPos += 2;
        } else {
          s1 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c46); }
        }
        if (s1 !== peg$FAILED) {
          peg$reportedPos = s0;
          s1 = peg$c47();
        }
        s0 = s1;
        if (s0 === peg$FAILED) {
          s0 = peg$currPos;
          if (input.substr(peg$currPos, 2) === peg$c48) {
            s1 = peg$c48;
            peg$currPos += 2;
          } else {
            s1 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c49); }
          }
          if (s1 !== peg$FAILED) {
            peg$reportedPos = s0;
            s1 = peg$c50();
          }
          s0 = s1;
          if (s0 === peg$FAILED) {
            s0 = peg$currPos;
            if (input.substr(peg$currPos, 2) === peg$c51) {
              s1 = peg$c51;
              peg$currPos += 2;
            } else {
              s1 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c52); }
            }
            if (s1 !== peg$FAILED) {
              peg$reportedPos = s0;
              s1 = peg$c53();
            }
            s0 = s1;
            if (s0 === peg$FAILED) {
              s0 = peg$currPos;
              if (input.substr(peg$currPos, 2) === peg$c54) {
                s1 = peg$c54;
                peg$currPos += 2;
              } else {
                s1 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$c55); }
              }
              if (s1 !== peg$FAILED) {
                peg$reportedPos = s0;
                s1 = peg$c56();
              }
              s0 = s1;
              if (s0 === peg$FAILED) {
                s0 = peg$currPos;
                if (input.substr(peg$currPos, 2) === peg$c57) {
                  s1 = peg$c57;
                  peg$currPos += 2;
                } else {
                  s1 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$c58); }
                }
                if (s1 !== peg$FAILED) {
                  s2 = peg$parsehexDigit();
                  if (s2 !== peg$FAILED) {
                    s3 = peg$parsehexDigit();
                    if (s3 !== peg$FAILED) {
                      s4 = peg$parsehexDigit();
                      if (s4 !== peg$FAILED) {
                        s5 = peg$parsehexDigit();
                        if (s5 !== peg$FAILED) {
                          peg$reportedPos = s0;
                          s1 = peg$c59(s2, s3, s4, s5);
                          s0 = s1;
                        } else {
                          peg$currPos = s0;
                          s0 = peg$c2;
                        }
                      } else {
                        peg$currPos = s0;
                        s0 = peg$c2;
                      }
                    } else {
                      peg$currPos = s0;
                      s0 = peg$c2;
                    }
                  } else {
                    peg$currPos = s0;
                    s0 = peg$c2;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$c2;
                }
              }
            }
          }
        }
      }

      return s0;
    }

    function peg$parsedigits() {
      var s0, s1, s2;

      s0 = peg$currPos;
      s1 = [];
      if (peg$c60.test(input.charAt(peg$currPos))) {
        s2 = input.charAt(peg$currPos);
        peg$currPos++;
      } else {
        s2 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c61); }
      }
      if (s2 !== peg$FAILED) {
        while (s2 !== peg$FAILED) {
          s1.push(s2);
          if (peg$c60.test(input.charAt(peg$currPos))) {
            s2 = input.charAt(peg$currPos);
            peg$currPos++;
          } else {
            s2 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c61); }
          }
        }
      } else {
        s1 = peg$c2;
      }
      if (s1 !== peg$FAILED) {
        peg$reportedPos = s0;
        s1 = peg$c62(s1);
      }
      s0 = s1;

      return s0;
    }

    function peg$parsehexDigit() {
      var s0;

      if (peg$c63.test(input.charAt(peg$currPos))) {
        s0 = input.charAt(peg$currPos);
        peg$currPos++;
      } else {
        s0 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c64); }
      }

      return s0;
    }

    function peg$parse_() {
      var s0, s1, s2;

      peg$silentFails++;
      s0 = peg$currPos;
      s1 = [];
      s2 = peg$parsewhitespace();
      while (s2 !== peg$FAILED) {
        s1.push(s2);
        s2 = peg$parsewhitespace();
      }
      if (s1 !== peg$FAILED) {
        peg$reportedPos = s0;
        s1 = peg$c66(s1);
      }
      s0 = s1;
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c65); }
      }

      return s0;
    }

    function peg$parsewhitespace() {
      var s0;

      if (peg$c67.test(input.charAt(peg$currPos))) {
        s0 = input.charAt(peg$currPos);
        peg$currPos++;
      } else {
        s0 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c68); }
      }

      return s0;
    }

    peg$result = peg$startRuleFunction();

    if (peg$result !== peg$FAILED && peg$currPos === input.length) {
      return peg$result;
    } else {
      if (peg$result !== peg$FAILED && peg$currPos < input.length) {
        peg$fail({ type: "end", description: "end of input" });
      }

      throw peg$buildException(null, peg$maxFailExpected, peg$maxFailPos);
    }
  }

  return {
    SyntaxError: SyntaxError,
    parse:       parse
  };
}()).parse;


/** @file messageformat.js - ICU PluralFormat + SelectFormat for JavaScript
 *  @author Alex Sexton - @SlexAxton
 *  @version 0.3.0-1
 *  @copyright 2012-2015 Alex Sexton, Eemeli Aro, and Contributors
 *  @license To use or fork, MIT. To contribute back, Dojo CLA  */


/** Utility function for quoting an Object's key value iff required
 *  @private  */
function propname(key, obj) {
  if (/^[A-Z_$][0-9A-Z_$]*$/i.test(key)) {
    return obj ? obj + '.' + key : key;
  } else {
    var jkey = JSON.stringify(key);
    return obj ? obj + '[' + jkey + ']' : jkey;
  }
};


/** Create a new message formatter
 *
 *  @class
 *  @global
 *  @param {string|string[]} [locale="en"] - The locale to use, with fallbacks
 *  @param {function} [pluralFunc] - Optional custom pluralization function
 *  @param {function[]} [formatters] - Optional custom formatting functions  */
function MessageFormat(locale, pluralFunc, formatters) {
  this.lc = [locale];  
  this.runtime.pluralFuncs = {};
  this.runtime.pluralFuncs[this.lc[0]] = pluralFunc;
  this.runtime.fmt = {};
  if (formatters) for (var f in formatters) {
    this.runtime.fmt[f] = formatters[f];
  }
}




/** Parse an input string to its AST
 *
 *  Precompiled from `lib/messageformat-parser.pegjs` by
 *  {@link http://pegjs.org/ PEG.js}. Included in MessageFormat object
 *  to enable testing.
 *
 *  @private  */



/** Pluralization functions from
 *  {@link http://github.com/eemeli/make-plural.js make-plural}
 *
 *  @memberof MessageFormat
 *  @type Object.<string,function>  */
MessageFormat.plurals = {};


/** Default number formatting functions in the style of ICU's
 *  {@link http://icu-project.org/apiref/icu4j/com/ibm/icu/text/MessageFormat.html simpleArg syntax}
 *  implemented using the
 *  {@link https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Intl Intl}
 *  object defined by ECMA-402.
 *
 *  **Note**: Intl is not defined in default Node until 0.11.15 / 0.12.0, so
 *  earlier versions require a {@link https://www.npmjs.com/package/intl polyfill}.
 *  Therefore {@link MessageFormat.withIntlSupport} needs to be true for these
 *  functions to be available for inclusion in the output.
 *
 *  @see MessageFormat#setIntlSupport
 *
 *  @namespace
 *  @memberof MessageFormat
 *  @property {function} number - Represent a number as an integer, percent or currency value
 *  @property {function} date - Represent a date as a full/long/default/short string
 *  @property {function} time - Represent a time as a full/long/default/short string
 *
 *  @example
 *  > var MessageFormat = require('messageformat');
 *  > var mf = (new MessageFormat('en')).setIntlSupport(true);
 *  > mf.currency = 'EUR';
 *  > var mfunc = mf.compile("The total is {V,number,currency}.");
 *  > mfunc({V:5.5})
 *  "The total is €5.50."
 *
 *  @example
 *  > var MessageFormat = require('messageformat');
 *  > var mf = new MessageFormat('en', null, {number: MessageFormat.number});
 *  > mf.currency = 'EUR';
 *  > var mfunc = mf.compile("The total is {V,number,currency}.");
 *  > mfunc({V:5.5})
 *  "The total is €5.50."  */
MessageFormat.formatters = {};

/** Enable or disable support for the default formatters, which require the
 *  `Intl` object. Note that this can't be autodetected, as the environment
 *  in which the formatted text is compiled into Javascript functions is not
 *  necessarily the same environment in which they will get executed.
 *
 *  @see MessageFormat.formatters
 *
 *  @memberof MessageFormat
 *  @param {boolean} [enable=true]
 *  @returns {Object} The MessageFormat instance, to allow for chaining
 *  @example
 *  > var Intl = require('intl');
 *  > var MessageFormat = require('messageformat');
 *  > var mf = (new MessageFormat('en')).setIntlSupport(true);
 *  > mf.currency = 'EUR';
 *  > mf.compile("The total is {V,number,currency}.")({V:5.5});
 *  "The total is €5.50."  */



/** A set of utility functions that are called by the compiled Javascript
 *  functions, these are included locally in the output of {@link
 *  MessageFormat#compile compile()}.
 *
 *  @namespace
 *  @memberof MessageFormat  */
MessageFormat.prototype.runtime = {

  /** Utility function for `#` in plural rules
   *
   *  @param {number} value - The value to operate on
   *  @param {number} [offset=0] - An optional offset, set by the surrounding context  */
  number: function(value, offset) {
    if (isNaN(value)) throw new Error("'" + value + "' isn't a number.");
    return value - (offset || 0);
  },

  /** Utility function for `{N, plural|selectordinal, ...}`
   *
   *  @param {number} value - The key to use to find a pluralization rule
   *  @param {number} offset - An offset to apply to `value`
   *  @param {function} lcfunc - A locale function from `pluralFuncs`
   *  @param {Object.<string,string>} data - The object from which results are looked up
   *  @param {?boolean} isOrdinal - If true, use ordinal rather than cardinal rules
   *  @returns {string} The result of the pluralization  */
  plural: function(value, offset, lcfunc, data, isOrdinal) {
    if ({}.hasOwnProperty.call(data, value)) return data[value]();
    if (offset) value -= offset;
    var key = lcfunc(value, isOrdinal);
    if (key in data) return data[key]();
    return data.other();
  },

  /** Utility function for `{N, select, ...}`
   *
   *  @param {number} value - The key to use to find a selection
   *  @param {Object.<string,string>} data - The object from which results are looked up
   *  @returns {string} The result of the select statement  */
  select: function(value, data) {
    if ({}.hasOwnProperty.call(data, value)) return data[value]();
    return data.other()
  },

  /** Pluralization functions included in compiled output
   *  @instance
   *  @type Object.<string,function>  */
  pluralFuncs: {},

  /** Custom formatting functions called by `{var, fn[, args]*}` syntax
   *
   *  For examples, see {@link MessageFormat.formatters}
   *
   *  @instance
   *  @see MessageFormat.formatters
   *  @type Object.<string,function>  */
  fmt: {},

  /** Custom stringifier to clean up browser inconsistencies
   *  @instance  */
  toString: function () {
    var _stringify = function(o, level) {
      if (typeof o != 'object') {
        var funcStr = o.toString().replace(/^(function )\w*/, '$1');
        var indent = /([ \t]*)\S.*$/.exec(funcStr);
        return indent ? funcStr.replace(new RegExp('^' + indent[1], 'mg'), '') : funcStr;
      }
      var s = [];
      for (var i in o) if (i != 'toString') {
        if (level == 0) s.push('var ' + i + ' = ' + _stringify(o[i], level + 1) + ';\n');
        else s.push(propname(i) + ': ' + _stringify(o[i], level + 1));
      }
      if (level == 0) return s.join('');
      if (s.length == 0) return '{}';
      var indent = '  '; while (--level) indent += '  ';
      return '{\n' + s.join(',\n').replace(/^/gm, indent) + '\n}';
    };
    return _stringify(this, 0);
  }
};


/** Recursively map an AST to its resulting string
 *
 *  @memberof MessageFormat
 *
 *  @param ast - the Ast node for which the JS code should be generated
 *
 *  @private  */
MessageFormat.prototype._precompile = function(ast, data) {
  data = data || { keys: {}, offset: {} };
  var r = [], i, tmp, args = [];

  switch ( ast.type ) {
    case 'messageFormatPattern':
      for ( i = 0; i < ast.statements.length; ++i ) {
        r.push(this._precompile( ast.statements[i], data ));
      }
      tmp = r.join(' + ') || '""';
      return data.pf_count ? tmp : 'function(d) { return ' + tmp + '; }';

    case 'messageFormatElement':
      data.pf_count = data.pf_count || 0;
      if ( ast.output ) {
        return propname(ast.argumentIndex, 'd');
      }
      else {
        data.keys[data.pf_count] = ast.argumentIndex;
        return this._precompile( ast.elementFormat, data );
      }
      return '';

    case 'elementFormat':
      args = [ propname(data.keys[data.pf_count], 'd') ];
      switch (ast.key) {
        case 'select':
          args.push(this._precompile(ast.val, data));
          return 'select(' + args.join(', ') + ')';
        case 'selectordinal':
          args = args.concat([ 0, propname(this.lc[0], 'pluralFuncs'), this._precompile(ast.val, data), 1 ]);
          return 'plural(' + args.join(', ') + ')';
        case 'plural':
          data.offset[data.pf_count || 0] = ast.val.offset || 0;
          args = args.concat([ data.offset[data.pf_count] || 0, propname(this.lc[0], 'pluralFuncs'), this._precompile(ast.val, data) ]);
          return 'plural(' + args.join(', ') + ')';
        default:
          if (this.withIntlSupport && !(ast.key in this.runtime.fmt) && (ast.key in MessageFormat.formatters)) {
            tmp = MessageFormat.formatters[ast.key];
            this.runtime.fmt[ast.key] = (typeof tmp(this) == 'function') ? tmp(this) : tmp;
          }
          args.push(JSON.stringify(this.lc));
          if (ast.val && ast.val.length) args.push(JSON.stringify(ast.val.length == 1 ? ast.val[0] : ast.val));
          return 'fmt.' + ast.key + '(' + args.join(', ') + ')';
      }

    case 'pluralFormatPattern':
    case 'selectFormatPattern':
      data.pf_count = data.pf_count || 0;
      if (ast.type == 'selectFormatPattern') data.offset[data.pf_count] = 0;
      var needOther = true;
      for (i = 0; i < ast.pluralForms.length; ++i) {
        var key = ast.pluralForms[i].key;
        if (key === 'other') needOther = false;
        var data_copy = JSON.parse(JSON.stringify(data));
        data_copy.pf_count++;
        r.push(propname(key) + ': function() { return ' + this._precompile(ast.pluralForms[i].val, data_copy) + ';}');
      }
      if (needOther) throw new Error("No 'other' form found in " + ast.type + " " + data.pf_count);
      return '{ ' + r.join(', ') + ' }';

    case 'string':
      return JSON.stringify(ast.val || "");

    case 'octothorpe':
      if (!data.pf_count) return '"#"';
      args = [ propname(data.keys[data.pf_count-1], 'd') ];
      if (data.offset[data.pf_count-1]) args.push(data.offset[data.pf_count-1]);
      return 'number(' + args.join(', ') + ')';

    default:
      throw new Error( 'Bad AST type: ' + ast.type );
  }
};

/** Compile messages into an executable function with clean string
 *  representation.
 *
 *  If `messages` is a single string including ICU MessageFormat declarations,
 *  `opt` is ignored and the returned function takes a single Object parameter
 *  `d` representing each of the input's defined variables. The returned
 *  function will be defined in a local scope that includes all the required
 *  runtime variables.
 *
 *  If `messages` is a map of keys to strings, or a map of namespace keys to
 *  such key/string maps, the returned function will fill the specified global
 *  with javascript functions matching the structure of the input. In such use,
 *  the output of `compile()` is expected to be serialized using `.toString()`,
 *  and will include definitions of the runtime functions. If `opt.global` is
 *  null, calling the output function will return the object itself.
 *
 *  Together, the input parameters should match the following patterns:
 *  ```js
 *  messages = "string" || { key0: "string0", key1: "string1", ... } || {
 *    ns0: { key0: "string0", key1: "string1", ...  },
 *    ns1: { key0: "string0", key1: "string1", ...  },
 *    ...
 *  }
 *
 *  opt = null || {
 *    locale: null || {
 *      ns0: "lc0" || [ "lc0", ... ],
 *      ns1: "lc1" || [ "lc1", ... ],
 *      ...
 *    },
 *    global: null || "module.exports" || "exports" || "i18n" || ...
 *  }
 *  ```
 *
 *  @memberof MessageFormat
 *  @param {string|Object}
 *      messages - The input message(s) to be compiled, in ICU MessageFormat
 *  @param {Object} [opt={}] - Options controlling output for non-simple intput
 *  @param {Object} [opt.locale] - The locales to use for the messages, with a
 *      structure matching that of `messages`
 *  @param {string} [opt.global=""] - The global variable that the output
 *      function should use, or a null string for none. "exports" and
 *      "module.exports" are recognised as special cases.
 *  @returns {function} The first match found for the given locale(s)
 *
 *  @example
 * > var MessageFormat = require('messageformat'),
 * ...   mf = new MessageFormat('en'),
 * ...   mfunc0 = mf.compile('A {TYPE} example.');
 * > mfunc0({TYPE:'simple'})
 * 'A simple example.'
 * > mfunc0.toString()
 * 'function (d) { return "A " + d.TYPE + " example."; }'
 *
 *  @example
 * > var msgSet = { a: 'A {TYPE} example.',
 * ...              b: 'This has {COUNT, plural, one{one member} other{# members}}.' },
 * ...   mfuncSet = mf.compile(msgSet);
 * > mfuncSet().a({TYPE:'more complex'})
 * 'A more complex example.'
 * > mfuncSet().b({COUNT:2})
 * 'This has 2 members.'
 *
 * > console.log(mfuncSet.toString())
 * function anonymous() {
 * var number = function (value, offset) {
 *   if (isNaN(value)) throw new Error("'" + value + "' isn't a number.");
 *   return value - (offset || 0);
 * };
 * var plural = function (value, offset, lcfunc, data, isOrdinal) {
 *   if ({}.hasOwnProperty.call(data, value)) return data[value]();
 *   if (offset) value -= offset;
 *   var key = lcfunc(value, isOrdinal);
 *   if (key in data) return data[key]();
 *   return data.other();
 * };
 * var select = function (value, data) {
 *   if ({}.hasOwnProperty.call(data, value)) return data[value]();
 *   return data.other()
 * };
 * var pluralFuncs = {
 *   en: function (n, ord) {
 *     var s = String(n).split('.'), v0 = !s[1], t0 = Number(s[0]) == n,
 *         n10 = t0 && s[0].slice(-1), n100 = t0 && s[0].slice(-2);
 *     if (ord) return (n10 == 1 && n100 != 11) ? 'one'
 *         : (n10 == 2 && n100 != 12) ? 'two'
 *         : (n10 == 3 && n100 != 13) ? 'few'
 *         : 'other';
 *     return (n == 1 && v0) ? 'one' : 'other';
 *   }
 * };
 * var fmt = {};
 *
 * return {
 *   a: function(d) { return "A " + d.TYPE + " example."; },
 *   b: function(d) { return "This has " + plural(d.COUNT, 0, pluralFuncs.en, { one: function() { return "one member";}, other: function() { return number(d.COUNT)+" members";} }) + "."; }
 * }
 * }
 *
 *  @example
 * > mf.runtime.pluralFuncs.fi = MessageFormat.plurals.fi;
 * > var multiSet = { en: { a: 'A {TYPE} example.',
 * ...                      b: 'This is the {COUNT, selectordinal, one{#st} two{#nd} few{#rd} other{#th}} example.' },
 * ...                fi: { a: '{TYPE} esimerkki.',
 * ...                      b: 'Tämä on {COUNT, selectordinal, other{#.}} esimerkki.' } },
 * ...   multiSetLocales = { en: 'en', fi: 'fi' },
 * ...   mfuncSet = mf.compile(multiSet, { locale: multiSetLocales, global: 'i18n' });
 * > mfuncSet(this);
 * > i18n.en.b({COUNT:3})
 * 'This is the 3rd example.'
 * > i18n.fi.b({COUNT:3})
 * 'Tämä on 3. esimerkki.'  */
MessageFormat.prototype.compile = function ( messages, opt ) {
  var r = {}, lc0 = this.lc,
      compileMsg = function(self, msg) {
        try {
          var ast = MessageFormat._parse(msg);
          return self._precompile(ast);
        } catch (e) {
          throw new Error((ast ? 'Precompiler' : 'Parser') + ' error: ' + e.toString());
        }
      },
      stringify = function(r, level) {
        if (!level) level = 0;
        if (typeof r != 'object') return r;
        var o = [], indent = '';
        for (var i = 0; i < level; ++i) indent += '  ';
        for (var k in r) o.push('\n' + indent + '  ' + propname(k) + ': ' + stringify(r[k], level + 1));
        return '{' + o.join(',') + '\n' + indent + '}';
      };

  if (typeof messages == 'string') {
    var f = new Function(
        'number, plural, select, pluralFuncs, fmt',
        'return ' + compileMsg(this, messages));
    return f(this.runtime.number, this.runtime.plural, this.runtime.select,
        this.runtime.pluralFuncs, this.runtime.fmt);
  }

  opt = opt || {};

  for (var ns in messages) {
    if (opt.locale) this.lc = opt.locale[ns] && [].concat(opt.locale[ns]) || lc0;
    if (typeof messages[ns] == 'string') {
      try { r[ns] = compileMsg(this, messages[ns]); }
      catch (e) { e.message = e.message.replace(':', ' with `' + ns + '`:'); throw e; }
    } else {
      r[ns] = {};
      for (var key in messages[ns]) {
        try { r[ns][key] = compileMsg(this, messages[ns][key]); }
        catch (e) { e.message = e.message.replace(':', ' with `' + key + '` in `' + ns + '`:'); throw e; }
      }
    }
  }

  this.lc = lc0;
  var s = this.runtime.toString() + '\n';
  switch (opt.global || '') {
    case 'exports':
      var o = [];
      for (var k in r) o.push(propname(k, 'exports') + ' = ' + stringify(r[k]));
      return new Function(s + o.join(';\n'));
    case 'module.exports':
      return new Function(s + 'module.exports = ' + stringify(r));
    case '':
      return new Function(s + 'return ' + stringify(r));
    default:
      return new Function('G', s + propname(opt.global, 'G') + ' = ' + stringify(r));
  }
};


return MessageFormat;
}());
/* jshint ignore:end */


var createErrorPluralModulePresence = function() {
	return createError( "E_MISSING_PLURAL_MODULE", "Plural module not loaded." );
};




var validateMessageBundle = function( cldr ) {
	validate(
		"E_MISSING_MESSAGE_BUNDLE",
		"Missing message bundle for locale `{locale}`.",
		cldr.attributes.bundle && cldr.get( "globalize-messages/{bundle}" ) !== undefined,
		{
			locale: cldr.locale
		}
	);
};




var validateMessagePresence = function( path, value ) {
	path = path.join( "/" );
	validate( "E_MISSING_MESSAGE", "Missing required message content `{path}`.",
		value !== undefined, { path: path } );
};




var validateMessageType = function( path, value ) {
	path = path.join( "/" );
	validate(
		"E_INVALID_MESSAGE",
		"Invalid message content `{path}`. {expected} expected.",
		typeof value === "string",
		{
			expected: "a string",
			path: path
		}
	);
};




var validateParameterTypeMessageVariables = function( value, name ) {
	validateParameterType(
		value,
		name,
		value === undefined || isPlainObject( value ) || Array.isArray( value ),
		"Array or Plain Object"
	);
};




var messageFormatterFn = function( formatter ) {
	return function messageFormatter( variables ) {
		if ( typeof variables === "number" || typeof variables === "string" ) {
			variables = [].slice.call( arguments, 0 );
		}
		validateParameterTypeMessageVariables( variables, "variables" );
		return formatter( variables );
	};
};




var messageFormatterRuntimeBind = function( cldr, messageformatter ) {
	var locale = cldr.locale,
		origToString = messageformatter.toString;

	messageformatter.toString = function() {
		var argNames, argValues, output,
			args = {};

		// Properly adjust SlexAxton/messageformat.js compiled variables with Globalize variables:
		output = origToString.call( messageformatter );

		if ( /number\(/.test( output ) ) {
			args.number = "messageFormat.number";
		}

		if ( /plural\(/.test( output ) ) {
			args.plural = "messageFormat.plural";
		}

		if ( /select\(/.test( output ) ) {
			args.select = "messageFormat.select";
		}

		output.replace( /pluralFuncs(\[([^\]]+)\]|\.([a-zA-Z]+))/, function( match ) {
			args.pluralFuncs = "{" +
				"\"" + locale + "\": Globalize(\"" + locale + "\").pluralGenerator()" +
				"}";
			return match;
		});

		argNames = Object.keys( args ).join( ", " );
		argValues = Object.keys( args ).map(function( key ) {
			return args[ key ];
		}).join( ", " );

		return "(function( " + argNames + " ) {\n" +
			"  return " + output + "\n" +
			"})(" + argValues + ")";
	};

	return messageformatter;
};




var slice = [].slice;

/**
 * .loadMessages( json )
 *
 * @json [JSON]
 *
 * Load translation data.
 */
Globalize.loadMessages = function( json ) {
	var locale,
		customData = {
			"globalize-messages": json,
			"main": {}
		};

	validateParameterPresence( json, "json" );
	validateParameterTypePlainObject( json, "json" );

	// Set available bundles by populating customData main dataset.
	for ( locale in json ) {
		if ( json.hasOwnProperty( locale ) ) {
			customData.main[ locale ] = {};
		}
	}

	Cldr.load( customData );
};

/**
 * .messageFormatter( path )
 *
 * @path [String or Array]
 *
 * Format a message given its path.
 */
Globalize.messageFormatter =
Globalize.prototype.messageFormatter = function( path ) {
	var cldr, formatter, message, pluralGenerator, returnFn,
		args = slice.call( arguments, 0 );

	validateParameterPresence( path, "path" );
	validateParameterType( path, "path", typeof path === "string" || Array.isArray( path ),
		"a String nor an Array" );

	path = alwaysArray( path );
	cldr = this.cldr;

	validateDefaultLocale( cldr );
	validateMessageBundle( cldr );

	message = cldr.get( [ "globalize-messages/{bundle}" ].concat( path ) );
	validateMessagePresence( path, message );

	// If message is an Array, concatenate it.
	if ( Array.isArray( message ) ) {
		message = message.join( " " );
	}
	validateMessageType( path, message );

	// Is plural module present? Yes, use its generator. Nope, use an error generator.
	pluralGenerator = this.plural !== undefined ?
		this.pluralGenerator() :
		createErrorPluralModulePresence;

	formatter = new MessageFormat( cldr.locale, pluralGenerator ).compile( message );

	returnFn = messageFormatterFn( formatter );

	runtimeBind( args, cldr, returnFn,
		[ messageFormatterRuntimeBind( cldr, formatter ), pluralGenerator ] );

	return returnFn;
};

/**
 * .formatMessage( path [, variables] )
 *
 * @path [String or Array]
 *
 * @variables [Number, String, Array or Object]
 *
 * Format a message given its path.
 */
Globalize.formatMessage =
Globalize.prototype.formatMessage = function( path /* , variables */ ) {
	return this.messageFormatter( path ).apply( {}, slice.call( arguments, 1 ) );
};

return Globalize;




}));

/**
 * Globalize v1.6.0
 *
 * http://github.com/jquery/globalize
 *
 * Copyright jQuery Foundation and other contributors
 * Released under the MIT license
 * http://jquery.org/license
 *
 * Date: 2020-09-08T11:54Z
 */
/*!
 * Globalize v1.6.0 2020-09-08T11:54Z Released under the MIT license
 * http://git.io/TrdQbw
 */
(function( root, factory ) {

	// UMD returnExports
	if ( typeof define === "function" && define.amd ) {

		// AMD
		define([
			"cldr",
			"../globalize",
			"cldr/event",
			"cldr/supplemental"
		], factory );
	} else if ( typeof exports === "object" ) {

		// Node, CommonJS
		module.exports = factory( require( "cldrjs" ), require( "../globalize" ) );
	} else {

		// Global
		factory( root.Cldr, root.Globalize );
	}
}(this, function( Cldr, Globalize ) {

var createError = Globalize._createError,
	partsJoin = Globalize._partsJoin,
	partsPush = Globalize._partsPush,
	regexpEscape = Globalize._regexpEscape,
	runtimeBind = Globalize._runtimeBind,
	stringPad = Globalize._stringPad,
	validateCldr = Globalize._validateCldr,
	validateDefaultLocale = Globalize._validateDefaultLocale,
	validateParameterPresence = Globalize._validateParameterPresence,
	validateParameterRange = Globalize._validateParameterRange,
	validateParameterType = Globalize._validateParameterType,
	validateParameterTypePlainObject = Globalize._validateParameterTypePlainObject;


var createErrorUnsupportedFeature = function( feature ) {
	return createError( "E_UNSUPPORTED", "Unsupported {feature}.", {
		feature: feature
	});
};




var validateParameterTypeNumber = function( value, name ) {
	validateParameterType(
		value,
		name,
		value === undefined || typeof value === "number",
		"Number"
	);
};




var validateParameterTypeString = function( value, name ) {
	validateParameterType(
		value,
		name,
		value === undefined || typeof value === "string",
		"a string"
	);
};




var numberFormatterFn = function( numberToPartsFormatter ) {
	return function numberFormatter( value ) {
		return partsJoin( numberToPartsFormatter( value ));
	};
};




/**
 * NumberingSystem( cldr )
 *
 * - http://www.unicode.org/reports/tr35/tr35-numbers.html#otherNumberingSystems
 * - http://cldr.unicode.org/index/bcp47-extension
 * - http://www.unicode.org/reports/tr35/#u_Extension
 */
var numberNumberingSystem = function( cldr ) {
	var nu = cldr.attributes[ "u-nu" ];

	if ( nu ) {
		if ( nu === "traditio" ) {
			nu = "traditional";
		}
		if ( [ "native", "traditional", "finance" ].indexOf( nu ) !== -1 ) {

			// Unicode locale extension `u-nu` is set using either (native, traditional or
			// finance). So, lookup the respective locale's numberingSystem and return it.
			return cldr.main([ "numbers/otherNumberingSystems", nu ]);
		}

		// Unicode locale extension `u-nu` is set with an explicit numberingSystem. Return it.
		return nu;
	}

	// Return the default numberingSystem.
	return cldr.main( "numbers/defaultNumberingSystem" );
};




/**
 * Compact( name, cldr )
 *
 * @compactType [String] Compact mode, `short` or `long`.
 *
 * @cldr [Cldr instance].
 *
 * Return the localized compact map for the given compact mode.
 */
var numberCompact = function( compactType, cldr ) {
	var maxExponent = 0;

	var object = cldr.main([
		"numbers/decimalFormats-numberSystem-" + numberNumberingSystem( cldr ),
		compactType,
		"decimalFormat"
	]);

	object = Object.keys( object ).reduce(function( newObject, compactKey ) {
		var numberExponent = compactKey.split( "0" ).length - 1;
		var pluralForm = compactKey.split( "-" )[ 2 ];
		newObject[ numberExponent ] = newObject[ numberExponent ] || {};
		newObject[ numberExponent ][ pluralForm ] = object[ compactKey ];
		maxExponent = Math.max( numberExponent, maxExponent );
		return newObject;
	}, {});

	object.maxExponent = maxExponent;

	return object;
};




/**
 * nuMap( cldr )
 *
 * @cldr [Cldr instance].
 *
 * Return digits map if numbering system is different than `latn`.
 */
var numberNumberingSystemDigitsMap = function( cldr ) {
	var aux,
		nu = numberNumberingSystem( cldr );

	if ( nu === "latn" ) {
		return;
	}

	aux = cldr.supplemental([ "numberingSystems", nu ]);

	if ( aux._type !== "numeric" ) {
		throw createErrorUnsupportedFeature( "`" + aux._type + "` numbering system" );
	}

	return aux._digits;
};




/**
 * EBNF representation:
 *
 * number_pattern_re =        prefix?
 *                            padding?
 *                            (integer_fraction_pattern | significant_pattern)
 *                            scientific_notation?
 *                            suffix?
 *
 * prefix =                   non_number_stuff
 *
 * padding =                  "*" regexp(.)
 *
 * integer_fraction_pattern = integer_pattern
 *                            fraction_pattern?
 *
 * integer_pattern =          regexp([#,]*[0,]*0+)
 *
 * fraction_pattern =         "." regexp(0*[0-9]*#*)
 *
 * significant_pattern =      regexp([#,]*@+#*)
 *
 * scientific_notation =      regexp(E\+?0+)
 *
 * suffix =                   non_number_stuff
 *
 * non_number_stuff =         regexp(('[^']+'|''|[^*#@0,.E])*)
 *
 *
 * Regexp groups:
 *
 *  0: number_pattern_re
 *  1: prefix
 *  2: -
 *  3: -
 *  4: padding
 *  5: (integer_fraction_pattern | significant_pattern)
 *  6: integer_fraction_pattern
 *  7: integer_pattern
 *  8: fraction_pattern
 *  9: significant_pattern
 * 10: scientific_notation
 * 11: suffix
 * 12: -
 */
var numberPatternRe = ( /^(('([^']|'')*'|[^*#@0,.E])*)(\*.)?((([#,]*[0,]*0+)(\.0*[0-9]*#*)?)|([#,]*@+#*))(E\+?0+)?(('[^']+'|''|[^*#@0,.E])*)$/ );




/**
 * format( number, pattern )
 *
 * @number [Number].
 *
 * @pattern [String] raw pattern for numbers.
 *
 * Return the formatted number.
 * ref: http://www.unicode.org/reports/tr35/tr35-numbers.html
 */
var numberPatternProperties = function( pattern ) {
	var aux1, aux2, fractionPattern, integerFractionOrSignificantPattern, integerPattern,
		maximumFractionDigits, maximumSignificantDigits, minimumFractionDigits,
		minimumIntegerDigits, minimumSignificantDigits, padding, prefix, primaryGroupingSize,
		roundIncrement, scientificNotation, secondaryGroupingSize, significantPattern, suffix;

	pattern = pattern.match( numberPatternRe );
	if ( !pattern ) {
		throw new Error( "Invalid pattern: " + pattern );
	}

	prefix = pattern[ 1 ];
	padding = pattern[ 4 ];
	integerFractionOrSignificantPattern = pattern[ 5 ];
	significantPattern = pattern[ 9 ];
	scientificNotation = pattern[ 10 ];
	suffix = pattern[ 11 ];

	// Significant digit format
	if ( significantPattern ) {
		significantPattern.replace( /(@+)(#*)/, function( match, minimumSignificantDigitsMatch, maximumSignificantDigitsMatch ) {
			minimumSignificantDigits = minimumSignificantDigitsMatch.length;
			maximumSignificantDigits = minimumSignificantDigits +
				maximumSignificantDigitsMatch.length;
		});

	// Integer and fractional format
	} else {
		fractionPattern = pattern[ 8 ];
		integerPattern = pattern[ 7 ];

		if ( fractionPattern ) {

			// Minimum fraction digits, and rounding.
			fractionPattern.replace( /[0-9]+/, function( match ) {
				minimumFractionDigits = match;
			});
			if ( minimumFractionDigits ) {
				roundIncrement = +( "0." + minimumFractionDigits );
				minimumFractionDigits = minimumFractionDigits.length;
			} else {
				minimumFractionDigits = 0;
			}

			// Maximum fraction digits
			// 1: ignore decimal character
			maximumFractionDigits = fractionPattern.length - 1 /* 1 */;
		} else {
			minimumFractionDigits = 0;
			maximumFractionDigits = 0;
		}

		// Minimum integer digits
		integerPattern.replace( /0+$/, function( match ) {
			minimumIntegerDigits = match.length;
		});
	}

	// Scientific notation
	if ( scientificNotation ) {
		throw createErrorUnsupportedFeature({
			feature: "scientific notation (not implemented)"
		});
	}

	// Padding
	if ( padding ) {
		throw createErrorUnsupportedFeature({
			feature: "padding (not implemented)"
		});
	}

	// Grouping
	if ( ( aux1 = integerFractionOrSignificantPattern.lastIndexOf( "," ) ) !== -1 ) {

		// Primary grouping size is the interval between the last group separator and the end of
		// the integer (or the end of the significant pattern).
		aux2 = integerFractionOrSignificantPattern.split( "." )[ 0 ];
		primaryGroupingSize = aux2.length - aux1 - 1;

		// Secondary grouping size is the interval between the last two group separators.
		if ( ( aux2 = integerFractionOrSignificantPattern.lastIndexOf( ",", aux1 - 1 ) ) !== -1 ) {
			secondaryGroupingSize = aux1 - 1 - aux2;
		}
	}

	// Return:
	//  0: @prefix String
	//  1: @padding Array [ <character>, <count> ] TODO
	//  2: @minimumIntegerDigits non-negative integer Number value indicating the minimum integer
	//        digits to be used. Numbers will be padded with leading zeroes if necessary.
	//  3: @minimumFractionDigits and
	//  4: @maximumFractionDigits are non-negative integer Number values indicating the minimum and
	//        maximum fraction digits to be used. Numbers will be rounded or padded with trailing
	//        zeroes if necessary.
	//  5: @minimumSignificantDigits and
	//  6: @maximumSignificantDigits are positive integer Number values indicating the minimum and
	//        maximum fraction digits to be shown. Either none or both of these properties are
	//        present; if they are, they override minimum and maximum integer and fraction digits
	//        – the formatter uses however many integer and fraction digits are required to display
	//        the specified number of significant digits.
	//  7: @roundIncrement Decimal round increment or null
	//  8: @primaryGroupingSize
	//  9: @secondaryGroupingSize
	// 10: @suffix String
	return [
		prefix,
		padding,
		minimumIntegerDigits,
		minimumFractionDigits,
		maximumFractionDigits,
		minimumSignificantDigits,
		maximumSignificantDigits,
		roundIncrement,
		primaryGroupingSize,
		secondaryGroupingSize,
		suffix
	];
};




/**
 * Symbol( name, cldr )
 *
 * @name [String] Symbol name.
 *
 * @cldr [Cldr instance].
 *
 * Return the localized symbol given its name.
 */
var numberSymbol = function( name, cldr ) {
	return cldr.main([
		"numbers/symbols-numberSystem-" + numberNumberingSystem( cldr ),
		name
	]);
};




var numberSymbolName = {
	".": "decimal",
	",": "group",
	"%": "percentSign",
	"+": "plusSign",
	"-": "minusSign",
	"E": "exponential",
	"\u2030": "perMille"
};




/**
 * symbolMap( cldr )
 *
 * @cldr [Cldr instance].
 *
 * Return the (localized symbol, pattern symbol) key value pair, eg. {
 *   ".": "٫",
 *   ",": "٬",
 *   "%": "٪",
 *   ...
 * };
 */
var numberSymbolMap = function( cldr ) {
	var symbol,
		symbolMap = {};

	for ( symbol in numberSymbolName ) {
		symbolMap[ symbol ] = numberSymbol( numberSymbolName[ symbol ], cldr );
	}

	return symbolMap;
};




var numberTruncate = function( value ) {
	if ( isNaN( value ) ) {
		return NaN;
	}
	return Math[ value < 0 ? "ceil" : "floor" ]( value );
};




/**
 * round( method )
 *
 * @method [String] with either "round", "ceil", "floor", or "truncate".
 *
 * Return function( value, incrementOrExp ):
 *
 *   @value [Number] eg. 123.45.
 *
 *   @incrementOrExp [Number] optional, eg. 0.1; or
 *     [Object] Either { increment: <value> } or { exponent: <value> }
 *
 *   Return the rounded number, eg:
 *   - round( "round" )( 123.45 ): 123;
 *   - round( "ceil" )( 123.45 ): 124;
 *   - round( "floor" )( 123.45 ): 123;
 *   - round( "truncate" )( 123.45 ): 123;
 *   - round( "round" )( 123.45, 0.1 ): 123.5;
 *   - round( "round" )( 123.45, 10 ): 120;
 *
 *   Based on https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Math/round
 *   Ref: #376
 */
var numberRound = function( method ) {
	method = method || "round";
	method = method === "truncate" ? numberTruncate : Math[ method ];

	return function( value, incrementOrExp ) {
		var exp, increment;

		value = +value;

		// If the value is not a number, return NaN.
		if ( isNaN( value ) ) {
			return NaN;
		}

		// Exponent given.
		if ( typeof incrementOrExp === "object" && incrementOrExp.exponent ) {
			exp = +incrementOrExp.exponent;
			increment = 1;

			if ( exp === 0 ) {
				return method( value );
			}

			// If the exp is not an integer, return NaN.
			if ( !( typeof exp === "number" && exp % 1 === 0 ) ) {
				return NaN;
			}

		// Increment given.
		} else {
			increment = +incrementOrExp || 1;

			if ( increment === 1 ) {
				return method( value );
			}

			// If the increment is not a number, return NaN.
			if ( isNaN( increment ) ) {
				return NaN;
			}

			increment = increment.toExponential().split( "e" );
			exp = +increment[ 1 ];
			increment = +increment[ 0 ];
		}

		// Shift & Round
		value = value.toString().split( "e" );
		value[ 0 ] = +value[ 0 ] / increment;
		value[ 1 ] = value[ 1 ] ? ( +value[ 1 ] - exp ) : -exp;
		value = method( +( value[ 0 ] + "e" + value[ 1 ] ) );

		// Shift back
		value = value.toString().split( "e" );
		value[ 0 ] = +value[ 0 ] * increment;
		value[ 1 ] = value[ 1 ] ? ( +value[ 1 ] + exp ) : exp;
		return +( value[ 0 ] + "e" + value[ 1 ] );
	};
};




/**
 * formatProperties( pattern, cldr [, options] )
 *
 * @pattern [String] raw pattern for numbers.
 *
 * @cldr [Cldr instance].
 *
 * @options [Object]:
 * - minimumIntegerDigits [Number]
 * - minimumFractionDigits, maximumFractionDigits [Number]
 * - minimumSignificantDigits, maximumSignificantDigits [Number]
 * - round [String] "ceil", "floor", "round" (default), or "truncate".
 * - useGrouping [Boolean] default true.
 *
 * Return the processed properties that will be used in number/format.
 * ref: http://www.unicode.org/reports/tr35/tr35-numbers.html
 */
var numberFormatProperties = function( pattern, cldr, options ) {
	var negativePattern, negativePrefix, negativeProperties, negativeSuffix, positivePattern,
		roundFn, properties;

	function getOptions( attribute, propertyIndex ) {
		if ( attribute in options ) {
			properties[ propertyIndex ] = options[ attribute ];
		}
	}

	options = options || {};
	pattern = pattern.split( ";" );

	positivePattern = pattern[ 0 ];

	negativePattern = pattern[ 1 ] || "-" + positivePattern;
	negativeProperties = numberPatternProperties( negativePattern );
	negativePrefix = negativeProperties[ 0 ];
	negativeSuffix = negativeProperties[ 10 ];

	// Have runtime code to refer to numberRound() instead of including it explicitly.
	roundFn = numberRound( options.round );
	roundFn.generatorString = function() {
		return "numberRound(" + ( options.round ? "\"" + options.round + "\"" : "" ) + ")";
	};

	properties = numberPatternProperties( positivePattern ).concat([
		positivePattern,
		negativePrefix + positivePattern + negativeSuffix,
		negativePrefix,
		negativeSuffix,
		roundFn,
		numberSymbol( "infinity", cldr ),
		numberSymbol( "nan", cldr ),
		numberSymbolMap( cldr ),
		numberNumberingSystemDigitsMap( cldr )
	]);

	if ( options.compact ) {

		// The compact digits number pattern is always `0+`, so override the following properties.
		// Note: minimumIntegerDigits would actually range from `0` to `000` based on the scale of
		// the value to be formatted, though we're always using 1 as a simplification, because the
		// number won't be zero-padded since we chose the right format based on the scale, i.e.,
		// we'd never see something like `003M` anyway.
		properties[ 2 ] = 1; // minimumIntegerDigits
		properties[ 3 ] = 0; // minimumFractionDigits
		properties[ 4 ] = 0; // maximumFractionDigits
		properties[ 5 ] = // minimumSignificantDigits &
			properties[ 6 ] = undefined ; // maximumSignificantDigits

		properties[20] = numberCompact( options.compact, cldr );
	}

	getOptions( "minimumIntegerDigits", 2 );
	getOptions( "minimumFractionDigits", 3 );
	getOptions( "maximumFractionDigits", 4 );
	getOptions( "minimumSignificantDigits", 5 );
	getOptions( "maximumSignificantDigits", 6 );

	// Grouping separators
	if ( options.useGrouping === false ) {
		properties[ 8 ] = null;
	}

	// Normalize number of digits if only one of either minimumFractionDigits or
	// maximumFractionDigits is passed in as an option
	if ( "minimumFractionDigits" in options && !( "maximumFractionDigits" in options ) ) {

		// maximumFractionDigits = Math.max( minimumFractionDigits, maximumFractionDigits );
		properties[ 4 ] = Math.max( properties[ 3 ], properties[ 4 ] );
	} else if ( !( "minimumFractionDigits" in options ) &&
			"maximumFractionDigits" in options ) {

		// minimumFractionDigits = Math.min( minimumFractionDigits, maximumFractionDigits );
		properties[ 3 ] = Math.min( properties[ 3 ], properties[ 4 ] );
	}

	// Return:
	// 0-10: see number/pattern-properties.
	// 11: @positivePattern [String] Positive pattern.
	// 12: @negativePattern [String] Negative pattern.
	// 13: @negativePrefix [String] Negative prefix.
	// 14: @negativeSuffix [String] Negative suffix.
	// 15: @round [Function] Round function.
	// 16: @infinitySymbol [String] Infinity symbol.
	// 17: @nanSymbol [String] NaN symbol.
	// 18: @symbolMap [Object] A bunch of other symbols.
	// 19: @nuDigitsMap [Array] Digits map if numbering system is different than `latn`.
	// 20: @compactMap [Object] Map of per-digit-count format patterns for specified compact mode.
	return properties;
};




/**
 * Generated by:
 *
 * var regenerate = require( "regenerate" );
 * var formatSymbols = require( * "unicode-8.0.0/General_Category/Format/symbols" );
 * regenerate().add( formatSymbols ).toString();
 *
 * https://github.com/mathiasbynens/regenerate
 * https://github.com/mathiasbynens/unicode-8.0.0
 */
var regexpCfG = /[\xAD\u0600-\u0605\u061C\u06DD\u070F\u180E\u200B-\u200F\u202A-\u202E\u2060-\u2064\u2066-\u206F\uFEFF\uFFF9-\uFFFB]|\uD804\uDCBD|\uD82F[\uDCA0-\uDCA3]|\uD834[\uDD73-\uDD7A]|\uDB40[\uDC01\uDC20-\uDC7F]/g;




/**
 * Generated by:
 *
 * var regenerate = require( "regenerate" );
 * var dashSymbols = require( * "unicode-8.0.0/General_Category/Dash_Punctuation/symbols" );
 * regenerate().add( dashSymbols ).toString();
 *
 * https://github.com/mathiasbynens/regenerate
 * https://github.com/mathiasbynens/unicode-8.0.0
 *
 * NOTE: In addition to [:dash:],  the below includes MINUS SIGN U+2212.
 */
var regexpDashG = /[\-\u058A\u05BE\u1400\u1806\u2010-\u2015\u2E17\u2E1A\u2E3A\u2E3B\u2E40\u301C\u3030\u30A0\uFE31\uFE32\uFE58\uFE63\uFF0D\u2212]/g;




/**
 * Generated by:
 *
 * var regenerate = require( "regenerate" );
 * var spaceSeparatorSymbols = require( "unicode-8.0.0/General_Category/Space_Separator/symbols" );
 * regenerate().add( spaceSeparatorSymbols ).toString();
 *
 * https://github.com/mathiasbynens/regenerate
 * https://github.com/mathiasbynens/unicode-8.0.0
 */
var regexpZsG = /[ \xA0\u1680\u2000-\u200A\u202F\u205F\u3000]/g;




/**
 * Loose Matching:
 * - Ignore all format characters, which includes RLM, LRM or ALM used to control BIDI
 *   formatting.
 * - Map all characters in [:Zs:] to U+0020 SPACE;
 * - Map all characters in [:Dash:] to U+002D HYPHEN-MINUS;
 */
var looseMatching = function( value ) {
	return value
		.replace( regexpCfG, "" )
		.replace( regexpDashG, "-" )
		.replace( regexpZsG, " " );
};




/**
 * parse( value, properties )
 *
 * @value [String].
 *
 * @properties [Object] Parser properties is a reduced pre-processed cldr
 * data set returned by numberParserProperties().
 *
 * Return the parsed Number (including Infinity) or NaN when value is invalid.
 * ref: http://www.unicode.org/reports/tr35/tr35-numbers.html
 */
var numberParse = function( value, properties ) {
	var grammar, invertedNuDigitsMap, invertedSymbolMap, negative, number, prefix, prefixNSuffix,
		suffix, tokenizer, valid;

	// Grammar:
	// - Value <=           NaN | PositiveNumber | NegativeNumber
	// - PositiveNumber <=  PositivePrefix NumberOrInf PositiveSufix
	// - NegativeNumber <=  NegativePrefix NumberOrInf
	// - NumberOrInf <=     Number | Inf
	grammar = [
		[ "nan" ],
		[ "prefix", "infinity", "suffix" ],
		[ "prefix", "number", "suffix" ],
		[ "negativePrefix", "infinity", "negativeSuffix" ],
		[ "negativePrefix", "number", "negativeSuffix" ]
	];

	invertedSymbolMap = properties[ 0 ];
	invertedNuDigitsMap = properties[ 1 ] || {};
	tokenizer = properties[ 2 ];

	value = looseMatching( value );

	function parse( type ) {
		return function( lexeme ) {

			// Reverse localized symbols and numbering system.
			lexeme = lexeme.split( "" ).map(function( character ) {
				return invertedSymbolMap[ character ] ||
					invertedNuDigitsMap[ character ] ||
					character;
			}).join( "" );

			switch ( type ) {
				case "infinity":
					number = Infinity;
					break;

				case "nan":
					number = NaN;
					break;

				case "number":

					// Remove grouping separators.
					lexeme = lexeme.replace( /,/g, "" );

					number = +lexeme;
					break;

				case "prefix":
				case "negativePrefix":
					prefix = lexeme;
					break;

				case "suffix":
					suffix = lexeme;
					break;

				case "negativeSuffix":
					suffix = lexeme;
					negative = true;
					break;

				// This should never be reached.
				default:
					throw new Error( "Internal error" );
			}
			return "";
		};
	}

	function tokenizeNParse( _value, grammar ) {
		return grammar.some(function( statement ) {
			var value = _value;

			// The whole grammar statement should be used (i.e., .every() return true) and value be
			// entirely consumed (i.e., !value.length).
			return statement.every(function( type ) {
				if ( value.match( tokenizer[ type ] ) === null ) {
					return false;
				}

				// Consume and parse it.
				value = value.replace( tokenizer[ type ], parse( type ) );
				return true;
			}) && !value.length;
		});
	}

	valid = tokenizeNParse( value, grammar );

	// NaN
	if ( !valid || isNaN( number ) ) {
		return NaN;
	}

	prefixNSuffix = "" + prefix + suffix;

	// Percent
	if ( prefixNSuffix.indexOf( "%" ) !== -1 ) {
		number /= 100;

	// Per mille
	} else if ( prefixNSuffix.indexOf( "\u2030" ) !== -1 ) {
		number /= 1000;
	}

	// Negative number
	if ( negative ) {
		number *= -1;
	}

	return number;
};




var numberParserFn = function( properties ) {
	return function numberParser( value ) {
		validateParameterPresence( value, "value" );
		validateParameterTypeString( value, "value" );

		return numberParse( value, properties );
	};

};




/**
 * symbolMap( cldr )
 *
 * @cldr [Cldr instance].
 *
 * Return the (localized symbol, pattern symbol) key value pair, eg. {
 *   "٫": ".",
 *   "٬": ",",
 *   "٪": "%",
 *   ...
 * };
 */
var numberSymbolInvertedMap = function( cldr ) {
	var symbol,
		symbolMap = {};

	for ( symbol in numberSymbolName ) {
		symbolMap[ numberSymbol( numberSymbolName[ symbol ], cldr ) ] = symbol;
	}

	return symbolMap;
};




/**
 * objectMap( object, fn)
 *
 * - object
 *
 * - fn( pair ) => pair
 */
var objectMap = function( object, fn ) {
	return Object.keys( object ).map(function( key ) {
		return fn([ key, object[ key ] ]);
	}).reduce(function( object, pair ) {
		object[ pair[ 0 ] ] = pair[ 1 ];
		return object;
	}, {});
};




/**
 * removeLiteralQuotes( string )
 *
 * Return:
 * - `'` if input string is `''`.
 * - `o'clock` if input string is `'o''clock'`.
 * - `foo` if input string is `foo`, i.e., return the same value in case it isn't a single-quoted
 *   string.
 */
var removeLiteralQuotes = function( string ) {
	if ( string[ 0 ] + string[ string.length - 1 ] !== "''" ) {
		return string;
	}
	if ( string === "''" ) {
		return "'";
	}
	return string.replace( /''/g, "'" ).slice( 1, -1 );
};




/**
 * parseProperties( pattern, cldr )
 *
 * @pattern [String] raw pattern for numbers.
 *
 * @cldr [Cldr instance].
 *
 * Return parser properties, used to feed parser function.
 *
 * TODO:
 * - Scientific_notation;
 * - Padding;
 */
var numberParseProperties = function( pattern, cldr, options ) {
	var aux, decimalSymbolRe, digitsRe, groupingSeparatorRe, infinitySymbol, invertedNuDigitsMap,
		invertedSymbolMap, maximumFractionDigits, maximumSignificantDigits,
		minimumSignificantDigits, nanSymbol, negativePrefix, negativeSuffix, nuDigitsMap,
		numberTokenizer, prefix, primaryGroupingSize, secondaryGroupingSize, suffix, symbolMap,
		formatProperties = numberFormatProperties( pattern, cldr, options );

	prefix = looseMatching( formatProperties[ 0 ] );
	maximumFractionDigits = formatProperties[ 4 ];
	minimumSignificantDigits = formatProperties[ 5 ];
	maximumSignificantDigits = formatProperties[ 6 ];
	primaryGroupingSize = formatProperties[ 8 ];
	secondaryGroupingSize = formatProperties[ 9 ];
	suffix = looseMatching( formatProperties[ 10 ] );
	negativePrefix = looseMatching( formatProperties[ 13 ] );
	negativeSuffix = looseMatching( formatProperties[ 14 ] );
	infinitySymbol = looseMatching( formatProperties[ 16 ] );
	nanSymbol = looseMatching( formatProperties[ 17 ] );
	symbolMap = objectMap( formatProperties[ 18 ], function( pair ) {
		return [ pair[ 0 ], looseMatching( pair[ 1 ] ) ];
	});
	nuDigitsMap = formatProperties[ 19 ];

	invertedSymbolMap = objectMap( numberSymbolInvertedMap( cldr ), function( pair ) {
		return [ looseMatching( pair[ 0 ] ), pair[ 1 ] ];
	});

	digitsRe = nuDigitsMap ? "[" + nuDigitsMap + "]" : "\\d";
	groupingSeparatorRe = regexpEscape( symbolMap[ "," ] );
	decimalSymbolRe = regexpEscape( symbolMap[ "." ] );

	if ( nuDigitsMap ) {
		invertedNuDigitsMap = nuDigitsMap.split( "" ).reduce(function( object, localizedDigit, i ) {
			object[ localizedDigit ] = String( i );
			return object;
		}, {} );
	}

	aux = [ prefix, suffix, negativePrefix, negativeSuffix ].map(function( value ) {
		return value.replace( /('([^']|'')+'|'')|./g, function( character, literal ) {

			// Literals
			if ( literal ) {
				return removeLiteralQuotes( literal );
			}

			// Symbols
			character = character.replace( /[\-+E%\u2030]/, function( symbol ) {
				return symbolMap[ symbol ];
			});

			return character;
		});
	});

	prefix = aux[ 0 ];
	suffix = aux[ 1 ];
	negativePrefix = aux[ 2 ];
	negativeSuffix = aux[ 3 ];

	// Number
	//
	// number_re =                       integer fraction?
	//
	// integer =                         digits | digits_using_grouping_separators
	//
	// fraction =                        regexp((.\d+)?)
	//
	// digits =                          regexp(\d+)
	//
	// digits_w_grouping_separators =    digits_w_1_grouping_separators |
	//                                   digits_w_2_grouping_separators
	//
	// digits_w_1_grouping_separators =  regexp(\d{1,3}(,\d{3})+)
	//
	// digits_w_2_grouping_separators =  regexp(\d{1,2}((,\d{2})*(,\d{3})))

	// Integer part
	numberTokenizer = digitsRe + "+";

	// Grouping separators
	if ( primaryGroupingSize ) {
		if ( secondaryGroupingSize ) {
			aux = digitsRe + "{1," + secondaryGroupingSize + "}((" + groupingSeparatorRe +
				digitsRe + "{" + secondaryGroupingSize + "})*(" + groupingSeparatorRe +
				digitsRe + "{" + primaryGroupingSize + "}))";
		} else {
			aux = digitsRe + "{1," + primaryGroupingSize + "}(" + groupingSeparatorRe +
				digitsRe + "{" + primaryGroupingSize + "})+";
		}
		numberTokenizer = "(" + aux + "|" + numberTokenizer + ")";
	}

	// Fraction part? Only included if 1 or 2.
	// 1: Using significant digit format.
	// 2: Using integer and fractional format && it has a maximumFractionDigits.
	if ( !isNaN( minimumSignificantDigits * maximumSignificantDigits ) || /* 1 */
				maximumFractionDigits /* 2 */ ) {

		// 1: Handle trailing decimal separator, e.g., `"1." => `1``.
		aux = decimalSymbolRe + digitsRe + "+";
		numberTokenizer = numberTokenizer + "(" + aux + "|" + decimalSymbolRe /* 1 */ + ")?" +

			// Handle non-padded decimals, e.g., `".12"` => `0.12` by making the integer part
			// optional.
			"|(" + numberTokenizer + ")?" + aux;

		numberTokenizer = "(" + numberTokenizer + ")";
	}

	// 0: @invertedSymbolMap [Object] Inverted symbol map.
	// 1: @invertedNuDigitsMap [Object] Inverted digits map if numbering system is different than
	//    `latn`.
	// 2: @tokenizer [Object] Tokenizer map, used by parser to consume input.
	return [
		invertedSymbolMap,
		invertedNuDigitsMap,
		{
			infinity: new RegExp( "^" + regexpEscape( infinitySymbol ) ),
			nan:  new RegExp( "^" + regexpEscape( nanSymbol ) ),
			negativePrefix: new RegExp( "^" + regexpEscape( negativePrefix ) ),
			negativeSuffix: new RegExp( "^" + regexpEscape( negativeSuffix ) ),
			number: new RegExp( "^" + numberTokenizer ),
			prefix: new RegExp( "^" + regexpEscape( prefix ) ),
			suffix: new RegExp( "^" + regexpEscape( suffix ) )
		}
	];

};




/**
 * Pattern( style )
 *
 * @style [String] "decimal" (default) or "percent".
 *
 * @cldr [Cldr instance].
 */
var numberPattern = function( style, cldr ) {
	if ( style !== "decimal" && style !== "percent" ) {
		throw new Error( "Invalid style" );
	}

	return cldr.main([
		"numbers",
		style + "Formats-numberSystem-" + numberNumberingSystem( cldr ),
		"standard"
	]);
};




/**
 * EBNF representation:
 *
 * compact_pattern_re =       prefix?
 *                            number_pattern_re
 *                            suffix?
 *
 * number_pattern_re =        0+
 *
 * Regexp groups:
 *
 *  0: compact_pattern_re
 *  1: prefix
 *  2: number_pattern_re (the number pattern to use in compact mode)
 *  3: suffix
 */
var numberCompactPatternRe = ( /^([^0]*)(0+)([^0]*)$/ );




/**
 * goupingSeparator( number, primaryGroupingSize, secondaryGroupingSize )
 *
 * @number [Number].
 *
 * @primaryGroupingSize [Number]
 *
 * @secondaryGroupingSize [Number]
 *
 * Return the formatted number with group separator.
 */
var numberFormatGroupingSeparator = function( number, primaryGroupingSize, secondaryGroupingSize ) {
	var index,
		currentGroupingSize = primaryGroupingSize,
		ret = "",
		sep = ",",
		switchToSecondary = secondaryGroupingSize ? true : false;

	number = String( number ).split( "." );
	index = number[ 0 ].length;

	while ( index > currentGroupingSize ) {
		ret = number[ 0 ].slice( index - currentGroupingSize, index ) +
			( ret.length ? sep : "" ) + ret;
		index -= currentGroupingSize;
		if ( switchToSecondary ) {
			currentGroupingSize = secondaryGroupingSize;
			switchToSecondary = false;
		}
	}

	number[ 0 ] = number[ 0 ].slice( 0, index ) + ( ret.length ? sep : "" ) + ret;
	return number.join( "." );
};




/**
 * integerFractionDigits( number, minimumIntegerDigits, minimumFractionDigits,
 * maximumFractionDigits, round, roundIncrement )
 *
 * @number [Number]
 *
 * @minimumIntegerDigits [Number]
 *
 * @minimumFractionDigits [Number]
 *
 * @maximumFractionDigits [Number]
 *
 * @round [Function]
 *
 * @roundIncrement [Function]
 *
 * Return the formatted integer and fraction digits.
 */
var numberFormatIntegerFractionDigits = function( number, minimumIntegerDigits, minimumFractionDigits, maximumFractionDigits, round,
	roundIncrement ) {

	// Fraction
	if ( maximumFractionDigits ) {

		// Rounding
		if ( roundIncrement ) {
			number = round( number, roundIncrement );

		// Maximum fraction digits
		} else {
			number = round( number, { exponent: -maximumFractionDigits } );
		}

	} else {
		number = round( number );
	}

	number = String( number );

	// Maximum integer digits (post string phase)
	if ( maximumFractionDigits && /e-/.test( number ) ) {

		// Use toFixed( maximumFractionDigits ) to make sure small numbers like 1e-7 are
		// displayed using plain digits instead of scientific notation.
		// 1: Remove leading decimal zeros.
		// 2: Remove leading decimal separator.
		// Note: String() is still preferred so it doesn't mess up with a number precision
		// unnecessarily, e.g., (123456789.123).toFixed(10) === "123456789.1229999959",
		// String(123456789.123) === "123456789.123".
		number = ( +number ).toFixed( maximumFractionDigits )
			.replace( /0+$/, "" ) /* 1 */
			.replace( /\.$/, "" ) /* 2 */;
	}

	// Minimum fraction digits (post string phase)
	if ( minimumFractionDigits ) {
		number = number.split( "." );
		number[ 1 ] = stringPad( number[ 1 ] || "", minimumFractionDigits, true );
		number = number.join( "." );
	}

	// Minimum integer digits
	if ( minimumIntegerDigits ) {
		number = number.split( "." );
		number[ 0 ] = stringPad( number[ 0 ], minimumIntegerDigits );
		number = number.join( "." );
	}

	return number;
};




/**
 * toPrecision( number, precision, round )
 *
 * @number (Number)
 *
 * @precision (Number) significant figures precision (not decimal precision).
 *
 * @round (Function)
 *
 * Return number.toPrecision( precision ) using the given round function.
 */
var numberToPrecision = function( number, precision, round ) {
	var roundOrder;

	if ( number === 0 ) {  // Fix #706
		return number;
	}

	roundOrder = Math.ceil( Math.log( Math.abs( number ) ) / Math.log( 10 ) );
	roundOrder -= precision;

	return round( number, { exponent: roundOrder } );
};




/**
 * toPrecision( number, minimumSignificantDigits, maximumSignificantDigits, round )
 *
 * @number [Number]
 *
 * @minimumSignificantDigits [Number]
 *
 * @maximumSignificantDigits [Number]
 *
 * @round [Function]
 *
 * Return the formatted significant digits number.
 */
var numberFormatSignificantDigits = function( number, minimumSignificantDigits, maximumSignificantDigits, round ) {
	var atMinimum, atMaximum;

	// Sanity check.
	if ( minimumSignificantDigits > maximumSignificantDigits ) {
		maximumSignificantDigits = minimumSignificantDigits;
	}

	atMinimum = numberToPrecision( number, minimumSignificantDigits, round );
	atMaximum = numberToPrecision( number, maximumSignificantDigits, round );

	// Use atMaximum only if it has more significant digits than atMinimum.
	number = +atMinimum === +atMaximum ? atMinimum : atMaximum;

	// Expand integer numbers, eg. 123e5 to 12300.
	number = ( +number ).toString( 10 );

	if ( ( /e/ ).test( number ) ) {
		throw createErrorUnsupportedFeature({
			feature: "integers out of (1e21, 1e-7)"
		});
	}

	// Add trailing zeros if necessary.
	if ( minimumSignificantDigits - number.replace( /^0+|\./g, "" ).length > 0 ) {
		number = number.split( "." );
		number[ 1 ] = stringPad( number[ 1 ] || "", minimumSignificantDigits - number[ 0 ].replace( /^0+/, "" ).length, true );
		number = number.join( "." );
	}

	return number;
};




/**
 * format( number, properties )
 *
 * @number [Number].
 *
 * @properties [Object] Output of number/format-properties.
 *
 * Return the formatted number.
 * ref: http://www.unicode.org/reports/tr35/tr35-numbers.html
 */
var numberFormat = function( number, properties, pluralGenerator ) {
	var aux, compactMap, infinitySymbol, maximumFractionDigits, maximumSignificantDigits,
		minimumFractionDigits, minimumIntegerDigits, minimumSignificantDigits, nanSymbol,
		nuDigitsMap, padding, prefix, primaryGroupingSize, pattern, round, roundIncrement,
		secondaryGroupingSize, stringToParts, suffix, symbolMap;

	padding = properties[ 1 ];
	minimumIntegerDigits = properties[ 2 ];
	minimumFractionDigits = properties[ 3 ];
	maximumFractionDigits = properties[ 4 ];
	minimumSignificantDigits = properties[ 5 ];
	maximumSignificantDigits = properties[ 6 ];
	roundIncrement = properties[ 7 ];
	primaryGroupingSize = properties[ 8 ];
	secondaryGroupingSize = properties[ 9 ];
	round = properties[ 15 ];
	infinitySymbol = properties[ 16 ];
	nanSymbol = properties[ 17 ];
	symbolMap = properties[ 18 ];
	nuDigitsMap = properties[ 19 ];
	compactMap = properties[ 20 ];

	// NaN
	if ( isNaN( number ) ) {
		return [ { type: "nan", value: nanSymbol } ];
	}

	if ( number < 0 ) {
		pattern = properties[ 12 ];
		prefix = properties[ 13 ];
		suffix = properties[ 14 ];
	} else {
		pattern = properties[ 11 ];
		prefix = properties[ 0 ];
		suffix = properties[ 10 ];
	}

	// For prefix, suffix, and number parts.
	stringToParts = function( string ) {
		var numberType = "integer",
			parts = [];

		// TODO Move the tokenization of all parts that don't depend on number into
		// format-properties.
		string.replace( /('([^']|'')+'|'')|./g, function( character, literal ) {

			// Literals
			if ( literal ) {
				partsPush( parts, "literal", removeLiteralQuotes( literal ) );
				return;
			}

			// Currency symbol
			if ( character === "\u00A4" ) {
				partsPush( parts, "currency", character );
				return;
			}

			// Symbols
			character = character.replace( /[.,\-+E%\u2030]/, function( symbol ) {
				if ( symbol === "." ) {
					numberType = "fraction";
				}
				partsPush( parts, numberSymbolName[symbol], symbolMap[ symbol ] );

				// "Erase" handled character.
				return "";
			});

			// Number
			character = character.replace( /[0-9]/, function( digit ) {

				// Numbering system
				if ( nuDigitsMap ) {
					digit = nuDigitsMap[ +digit ];
				}
				partsPush( parts, numberType, digit );

				// "Erase" handled character.
				return "";
			});

			// Etc
			character.replace( /./, function( etc ) {
				partsPush( parts, "literal", etc );
			});
		});
		return parts;
	};

	prefix = stringToParts( prefix );
	suffix = stringToParts( suffix );

	// Infinity
	if ( !isFinite( number ) ) {
		return prefix.concat(
			{ type: "infinity", value: infinitySymbol },
			suffix
		);
	}

	// Percent
	if ( pattern.indexOf( "%" ) !== -1 ) {
		number *= 100;

	// Per mille
	} else if ( pattern.indexOf( "\u2030" ) !== -1 ) {
		number *= 1000;
	}

	var compactPattern, compactDigits, compactProperties, divisor, numberExponent, pluralForm;

	// Compact mode: initial number digit processing
	if ( compactMap ) {
		numberExponent = Math.abs( Math.floor( number ) ).toString().length - 1;
		numberExponent = Math.min( numberExponent, compactMap.maxExponent );

		// Use default plural form to perform initial decimal shift
		if ( numberExponent >= 3 ) {
			compactPattern = compactMap[ numberExponent ] && compactMap[ numberExponent ].other;
		}

		if ( compactPattern === "0" ) {
			compactPattern = null;
		} else if ( compactPattern ) {
			compactDigits = compactPattern.split( "0" ).length - 1;
			divisor = numberExponent - ( compactDigits - 1 );
			number = number / Math.pow( 10, divisor );
		}
	}

	// Significant digit format
	if ( !isNaN( minimumSignificantDigits * maximumSignificantDigits ) ) {
		number = numberFormatSignificantDigits( number, minimumSignificantDigits,
			maximumSignificantDigits, round );

	// Integer and fractional format
	} else {
		number = numberFormatIntegerFractionDigits( number, minimumIntegerDigits,
			minimumFractionDigits, maximumFractionDigits, round, roundIncrement );
	}

	// Compact mode: apply formatting
	if ( compactMap && compactPattern ) {

		// Get plural form after possible roundings
		pluralForm = pluralGenerator ? pluralGenerator( +number ) : "other";

		compactPattern = compactMap[ numberExponent ][ pluralForm ] || compactPattern;
		compactProperties = compactPattern.match( numberCompactPatternRe );

		// TODO Move the tokenization of all parts that don't depend on number into
		// format-properties.
		aux = function( string ) {
			var parts = [];
			string.replace( /(\s+)|([^\s0]+)/g, function( garbage, space, compact ) {

				// Literals
				if ( space ) {
					partsPush( parts, "literal", space );
					return;
				}

				// Compact value
				if ( compact ) {
					partsPush( parts, "compact", compact );
					return;
				}
			});
			return parts;
		};

		// update prefix/suffix with compact prefix/suffix
		prefix = prefix.concat( aux( compactProperties[ 1 ] ) );
		suffix = aux( compactProperties[ 3 ] ).concat( suffix );
	}

	// Remove the possible number minus sign
	number = number.replace( /^-/, "" );

	// Grouping separators
	if ( primaryGroupingSize ) {
		number = numberFormatGroupingSeparator( number, primaryGroupingSize,
			secondaryGroupingSize );
	}

	// Scientific notation
	// TODO implement here

	// Padding/'([^']|'')+'|''|[.,\-+E%\u2030]/g
	// TODO implement here

	return prefix.concat(
		stringToParts( number ),
		suffix
	);
};




var numberToPartsFormatterFn = function( properties, pluralGenerator ) {
	return function numberToPartsFormatter( value ) {
		validateParameterPresence( value, "value" );
		validateParameterTypeNumber( value, "value" );

		return numberFormat( value, properties, pluralGenerator );
	};
};




function validateDigits( properties ) {
	var minimumIntegerDigits = properties[ 2 ],
		minimumFractionDigits = properties[ 3 ],
		maximumFractionDigits = properties[ 4 ],
		minimumSignificantDigits = properties[ 5 ],
		maximumSignificantDigits = properties[ 6 ];

	// Validate significant digit format properties
	if ( !isNaN( minimumSignificantDigits * maximumSignificantDigits ) ) {
		validateParameterRange( minimumSignificantDigits, "minimumSignificantDigits", 1, 21 );
		validateParameterRange( maximumSignificantDigits, "maximumSignificantDigits",
			minimumSignificantDigits, 21 );

	} else if ( !isNaN( minimumSignificantDigits ) || !isNaN( maximumSignificantDigits ) ) {
		throw new Error( "Neither or both the minimum and maximum significant digits must be " +
			"present" );

	// Validate integer and fractional format
	} else {
		validateParameterRange( minimumIntegerDigits, "minimumIntegerDigits", 1, 21 );
		validateParameterRange( minimumFractionDigits, "minimumFractionDigits", 0, 20 );
		validateParameterRange( maximumFractionDigits, "maximumFractionDigits",
			minimumFractionDigits, 20 );
	}
}

/**
 * .numberFormatter( [options] )
 *
 * @options [Object]:
 * - style: [String] "decimal" (default) or "percent".
 * - see also number/format options.
 *
 * Return a function that formats a number according to the given options and default/instance
 * locale.
 */
Globalize.numberFormatter =
Globalize.prototype.numberFormatter = function( options ) {
	var args, numberToPartsFormatter, returnFn;

	validateParameterTypePlainObject( options, "options" );

	options = options || {};
	args = [ options ];

	numberToPartsFormatter = this.numberToPartsFormatter( options );
	returnFn = numberFormatterFn( numberToPartsFormatter );
	runtimeBind( args, this.cldr, returnFn, [ numberToPartsFormatter ] );

	return returnFn;
};

/**
 * .numberToPartsFormatter( [options] )
 *
 * @options [Object]:
 * - style: [String] "symbol" (default), "accounting", "code" or "name".
 * - see also number/format options.
 *
 * Return a function that formats a number to parts according to the given options and
 * default/instance locale.
 */
Globalize.numberToPartsFormatter =
Globalize.prototype.numberToPartsFormatter = function( options ) {
	var args, cldr, fnArgs, pattern, properties, returnFn;

	validateParameterTypePlainObject( options, "options" );

	options = options || {};
	cldr = this.cldr;

	args = [ options ];

	validateDefaultLocale( cldr );

	cldr.on( "get", validateCldr );
	try {
		if ( options.raw ) {
			pattern = options.raw;
		} else {
			pattern = numberPattern( options.style || "decimal", cldr );
		}

		properties = numberFormatProperties( pattern, cldr, options );
		fnArgs = [ properties ];
	} finally {
		cldr.off( "get", validateCldr );
	}

	validateDigits( properties );

	if ( options.compact ) {
		fnArgs.push( this.pluralGenerator() );
	}
	returnFn = numberToPartsFormatterFn.apply( null, fnArgs );
	runtimeBind( args, cldr, returnFn, fnArgs );

	return returnFn;
};

/**
 * .numberParser( [options] )
 *
 * @options [Object]:
 * - style: [String] "decimal" (default) or "percent".
 *
 * Return the number parser according to the default/instance locale.
 */
Globalize.numberParser =
Globalize.prototype.numberParser = function( options ) {
	var args, cldr, pattern, properties, returnFn;

	validateParameterTypePlainObject( options, "options" );

	options = options || {};
	cldr = this.cldr;

	args = [ options ];

	validateDefaultLocale( cldr );
	if ( options.compact ) {
		throw createErrorUnsupportedFeature({
			feature: "compact number parsing (not implemented)"
		});
	}

	cldr.on( "get", validateCldr );

	if ( options.raw ) {
		pattern = options.raw;
	} else {
		pattern = numberPattern( options.style || "decimal", cldr );
	}

	properties = numberParseProperties( pattern, cldr, options );

	cldr.off( "get", validateCldr );

	returnFn = numberParserFn( properties );

	runtimeBind( args, cldr, returnFn, [ properties ] );

	return returnFn;
};

/**
 * .formatNumber( value [, options] )
 *
 * @value [Number] number to be formatted.
 *
 * @options [Object]: see number/format-properties.
 *
 * Format a number according to the given options and default/instance locale.
 */
Globalize.formatNumber =
Globalize.prototype.formatNumber = function( value, options ) {
	validateParameterPresence( value, "value" );
	validateParameterTypeNumber( value, "value" );

	return this.numberFormatter( options )( value );
};

/**
 * .formatNumberToParts( value [, options] )
 *
 * @value [Number] number to be formatted.
 *
 * @options [Object]: see number/format-properties.
 *
 * Format a number to pars according to the given options and default/instance locale.
 */
Globalize.formatNumberToParts =
Globalize.prototype.formatNumberToParts = function( value, options ) {
	validateParameterPresence( value, "value" );
	validateParameterTypeNumber( value, "value" );

	return this.numberToPartsFormatter( options )( value );
};

/**
 * .parseNumber( value [, options] )
 *
 * @value [String]
 *
 * @options [Object]: See numberParser().
 *
 * Return the parsed Number (including Infinity) or NaN when value is invalid.
 */
Globalize.parseNumber =
Globalize.prototype.parseNumber = function( value, options ) {
	validateParameterPresence( value, "value" );
	validateParameterTypeString( value, "value" );

	return this.numberParser( options )( value );
};

/**
 * Optimization to avoid duplicating some internal functions across modules.
 */
Globalize._createErrorUnsupportedFeature = createErrorUnsupportedFeature;
Globalize._numberNumberingSystem = numberNumberingSystem;
Globalize._numberNumberingSystemDigitsMap = numberNumberingSystemDigitsMap;
Globalize._numberPattern = numberPattern;
Globalize._numberSymbol = numberSymbol;
Globalize._looseMatching = looseMatching;
Globalize._removeLiteralQuotes = removeLiteralQuotes;
Globalize._stringPad = stringPad;
Globalize._validateParameterTypeNumber = validateParameterTypeNumber;
Globalize._validateParameterTypeString = validateParameterTypeString;

return Globalize;




}));

/*!
 * Globalize v1.6.0
 *
 * http://github.com/jquery/globalize
 *
 * Copyright jQuery Foundation and other contributors
 * Released under the MIT license
 * http://jquery.org/license
 *
 * Date: 2020-09-08T11:54Z
 */
(function( root, factory ) {

	// UMD returnExports
	if ( typeof define === "function" && define.amd ) {

		// AMD
		define([
			"cldr",
			"../globalize",
			"./number",
			"cldr/event",
			"cldr/supplemental"
		], factory );
	} else if ( typeof exports === "object" ) {

		// Node, CommonJS
		module.exports = factory( require( "cldrjs" ), require( "../globalize" ) );
	} else {

		// Global
		factory( root.Cldr, root.Globalize );
	}
}(this, function( Cldr, Globalize ) {

var alwaysArray = Globalize._alwaysArray,
	createError = Globalize._createError,
	formatMessageToParts = Globalize._formatMessageToParts,
	numberNumberingSystem = Globalize._numberNumberingSystem,
	numberPattern = Globalize._numberPattern,
	partsJoin = Globalize._partsJoin,
	partsPush = Globalize._partsPush,
	runtimeBind = Globalize._runtimeBind,
	stringPad = Globalize._stringPad,
	validateCldr = Globalize._validateCldr,
	validateDefaultLocale = Globalize._validateDefaultLocale,
	validateParameterPresence = Globalize._validateParameterPresence,
	validateParameterType = Globalize._validateParameterType,
	validateParameterTypeNumber = Globalize._validateParameterTypeNumber,
	validateParameterTypePlainObject = Globalize._validateParameterTypePlainObject;


var createErrorPluralModulePresence = function() {
	return createError( "E_MISSING_PLURAL_MODULE", "Plural module not loaded." );
};




var validateParameterTypeCurrency = function( value, name ) {
	validateParameterType(
		value,
		name,
		value === undefined || typeof value === "string" && ( /^[A-Za-z]{3}$/ ).test( value ),
		"3-letter currency code string as defined by ISO 4217"
	);
};




var currencyFormatterFn = function( currencyToPartsFormatter ) {
	return function currencyFormatter( value ) {
		return partsJoin( currencyToPartsFormatter( value ));
	};
};




/**
 * supplementalOverride( currency, pattern, cldr )
 *
 * Return pattern with fraction digits overriden by supplemental currency data.
 */
var currencySupplementalOverride = function( currency, pattern, cldr ) {
	var digits,
		fraction = "",
		fractionData = cldr.supplemental([ "currencyData/fractions", currency ]) ||
			cldr.supplemental( "currencyData/fractions/DEFAULT" );

	digits = +fractionData._digits;

	if ( digits ) {
		fraction = "." + stringPad( "0", digits ).slice( 0, -1 ) + fractionData._rounding;
	}

	return pattern.replace( /\.(#+|0*[0-9]|0+[0-9]?)/g, fraction );
};




var objectFilter = function( object, testRe ) {
	var key,
		copy = {};

	for ( key in object ) {
		if ( testRe.test( key ) ) {
			copy[ key ] = object[ key ];
		}
	}

	return copy;
};




var currencyUnitPatterns = function( cldr ) {
	return objectFilter( cldr.main([
		"numbers",
		"currencyFormats-numberSystem-" + numberNumberingSystem( cldr )
	]), /^unitPattern/ );
};




/**
 * nameProperties( currency, cldr )
 *
 * Return number pattern with the appropriate currency code in as literal.
 */
var currencyNameProperties = function( currency, cldr ) {
	var pattern = numberPattern( "decimal", cldr );

	// The number of decimal places and the rounding for each currency is not locale-specific. Those
	// values overridden by Supplemental Currency Data.
	pattern = currencySupplementalOverride( currency, pattern, cldr );

	return {
		displayNames: objectFilter( cldr.main([
			"numbers/currencies",
			currency
		]), /^displayName/ ),
		pattern: pattern,
		unitPatterns: currencyUnitPatterns( cldr )
	};
};




/**
 * Unicode regular expression for: everything except math symbols, currency signs, dingbats, and
 * box-drawing characters.
 *
 * Generated by:
 *
 * regenerate()
 *   .addRange( 0x0, 0x10FFFF )
 *   .remove( require( "unicode-7.0.0/categories/S/symbols" ) ).toString();
 *
 * https://github.com/mathiasbynens/regenerate
 * https://github.com/mathiasbynens/unicode-7.0.0
 */
var regexpNotS = /[\0-#%-\*,-;\?-\]_a-\{\}\x7F-\xA1\xA7\xAA\xAB\xAD\xB2\xB3\xB5-\xB7\xB9-\xD6\xD8-\xF6\xF8-\u02C1\u02C6-\u02D1\u02E0-\u02E4\u02EC\u02EE\u0300-\u0374\u0376-\u0383\u0386-\u03F5\u03F7-\u0481\u0483-\u058C\u0590-\u0605\u0609\u060A\u060C\u060D\u0610-\u06DD\u06DF-\u06E8\u06EA-\u06FC\u06FF-\u07F5\u07F7-\u09F1\u09F4-\u09F9\u09FC-\u0AF0\u0AF2-\u0B6F\u0B71-\u0BF2\u0BFB-\u0C7E\u0C80-\u0D78\u0D7A-\u0E3E\u0E40-\u0F00\u0F04-\u0F12\u0F14\u0F18\u0F19\u0F20-\u0F33\u0F35\u0F37\u0F39-\u0FBD\u0FC6\u0FCD\u0FD0-\u0FD4\u0FD9-\u109D\u10A0-\u138F\u139A-\u17DA\u17DC-\u193F\u1941-\u19DD\u1A00-\u1B60\u1B6B-\u1B73\u1B7D-\u1FBC\u1FBE\u1FC2-\u1FCC\u1FD0-\u1FDC\u1FE0-\u1FEC\u1FF0-\u1FFC\u1FFF-\u2043\u2045-\u2051\u2053-\u2079\u207D-\u2089\u208D-\u209F\u20BE-\u20FF\u2102\u2107\u210A-\u2113\u2115\u2119-\u211D\u2124\u2126\u2128\u212A-\u212D\u212F-\u2139\u213C-\u213F\u2145-\u2149\u214E\u2150-\u218F\u2308-\u230B\u2329\u232A\u23FB-\u23FF\u2427-\u243F\u244B-\u249B\u24EA-\u24FF\u2768-\u2793\u27C5\u27C6\u27E6-\u27EF\u2983-\u2998\u29D8-\u29DB\u29FC\u29FD\u2B74\u2B75\u2B96\u2B97\u2BBA-\u2BBC\u2BC9\u2BD2-\u2CE4\u2CEB-\u2E7F\u2E9A\u2EF4-\u2EFF\u2FD6-\u2FEF\u2FFC-\u3003\u3005-\u3011\u3014-\u301F\u3021-\u3035\u3038-\u303D\u3040-\u309A\u309D-\u318F\u3192-\u3195\u31A0-\u31BF\u31E4-\u31FF\u321F-\u3229\u3248-\u324F\u3251-\u325F\u3280-\u3289\u32B1-\u32BF\u32FF\u3400-\u4DBF\u4E00-\uA48F\uA4C7-\uA6FF\uA717-\uA71F\uA722-\uA788\uA78B-\uA827\uA82C-\uA835\uA83A-\uAA76\uAA7A-\uAB5A\uAB5C-\uD7FF\uDC00-\uFB28\uFB2A-\uFBB1\uFBC2-\uFDFB\uFDFE-\uFE61\uFE63\uFE67\uFE68\uFE6A-\uFF03\uFF05-\uFF0A\uFF0C-\uFF1B\uFF1F-\uFF3D\uFF3F\uFF41-\uFF5B\uFF5D\uFF5F-\uFFDF\uFFE7\uFFEF-\uFFFB\uFFFE\uFFFF]|\uD800[\uDC00-\uDD36\uDD40-\uDD78\uDD8A\uDD8B\uDD8D-\uDD8F\uDD9C-\uDD9F\uDDA1-\uDDCF\uDDFD-\uDFFF]|[\uD801\uD803-\uD819\uD81B-\uD82E\uD830-\uD833\uD836-\uD83A\uD83F-\uDBFF][\uDC00-\uDFFF]|\uD802[\uDC00-\uDC76\uDC79-\uDEC7\uDEC9-\uDFFF]|\uD81A[\uDC00-\uDF3B\uDF40-\uDF44\uDF46-\uDFFF]|\uD82F[\uDC00-\uDC9B\uDC9D-\uDFFF]|\uD834[\uDCF6-\uDCFF\uDD27\uDD28\uDD65-\uDD69\uDD6D-\uDD82\uDD85-\uDD8B\uDDAA-\uDDAD\uDDDE-\uDDFF\uDE42-\uDE44\uDE46-\uDEFF\uDF57-\uDFFF]|\uD835[\uDC00-\uDEC0\uDEC2-\uDEDA\uDEDC-\uDEFA\uDEFC-\uDF14\uDF16-\uDF34\uDF36-\uDF4E\uDF50-\uDF6E\uDF70-\uDF88\uDF8A-\uDFA8\uDFAA-\uDFC2\uDFC4-\uDFFF]|\uD83B[\uDC00-\uDEEF\uDEF2-\uDFFF]|\uD83C[\uDC2C-\uDC2F\uDC94-\uDC9F\uDCAF\uDCB0\uDCC0\uDCD0\uDCF6-\uDD0F\uDD2F\uDD6C-\uDD6F\uDD9B-\uDDE5\uDE03-\uDE0F\uDE3B-\uDE3F\uDE49-\uDE4F\uDE52-\uDEFF\uDF2D-\uDF2F\uDF7E\uDF7F\uDFCF-\uDFD3\uDFF8-\uDFFF]|\uD83D[\uDCFF\uDD4B-\uDD4F\uDD7A\uDDA4\uDE43\uDE44\uDED0-\uDEDF\uDEED-\uDEEF\uDEF4-\uDEFF\uDF74-\uDF7F\uDFD5-\uDFFF]|\uD83E[\uDC0C-\uDC0F\uDC48-\uDC4F\uDC5A-\uDC5F\uDC88-\uDC8F\uDCAE-\uDFFF]|[\uD800-\uDBFF]/;




/**
 * symbolProperties( currency, cldr )
 *
 * Return pattern replacing `¤` with the appropriate currency symbol literal.
 */
var currencySymbolProperties = function( currency, cldr, options ) {
	var currencySpacing, pattern, symbol, symbolEntries,
		regexp = {
			"[:digit:]": /\d/,
			"[:^S:]": regexpNotS
		};

	if ( options.style === "code" ) {
		symbol = currency;
	} else {
		symbolEntries = [ "symbol" ];

		// If options.symbolForm === "narrow" was passed, prepend it.
		if ( options.symbolForm === "narrow" ) {
			symbolEntries.unshift( "symbol-alt-narrow" );
		}

		symbolEntries.some(function( symbolEntry ) {
			return symbol = cldr.main([
				"numbers/currencies",
				currency,
				symbolEntry
			]);
		});
	}

	currencySpacing = [ "beforeCurrency", "afterCurrency" ].map(function( position ) {
		return cldr.main([
			"numbers",
			"currencyFormats-numberSystem-" + numberNumberingSystem( cldr ),
			"currencySpacing",
			position
		]);
	});

	pattern = cldr.main([
		"numbers",
		"currencyFormats-numberSystem-" + numberNumberingSystem( cldr ),
		options.style === "accounting" ? "accounting" : "standard"
	]);

	pattern =

		// The number of decimal places and the rounding for each currency is not locale-specific.
		// Those values are overridden by Supplemental Currency Data.
		currencySupplementalOverride( currency, pattern, cldr )

		// Replace "¤" (\u00A4) with the appropriate symbol literal.
		.split( ";" ).map(function( pattern ) {

			return pattern.split( "\u00A4" ).map(function( part, i ) {
				var currencyMatch = regexp[ currencySpacing[ i ].currencyMatch ],
					surroundingMatch = regexp[ currencySpacing[ i ].surroundingMatch ],
					insertBetween = "";

				// For currencyMatch and surroundingMatch definitions, read [1].
				// When i === 0, beforeCurrency is being handled. Otherwise, afterCurrency.
				// 1: http://www.unicode.org/reports/tr35/tr35-numbers.html#Currencies
				currencyMatch = currencyMatch.test( symbol.charAt( i ? symbol.length - 1 : 0 ) );
				surroundingMatch = surroundingMatch.test(
					part.charAt( i ? 0 : part.length - 1 ).replace( /[#@,.]/g, "0" )
				);

				if ( currencyMatch && part && surroundingMatch ) {
					insertBetween = currencySpacing[ i ].insertBetween;
				}

				return ( i ? insertBetween : "" ) + part + ( i ? "" : insertBetween );
			}).join( "\u00A4" );
		}).join( ";" );

	return {
		pattern: pattern,
		symbol: symbol
	};
};




/**
 * nameFormat( formattedNumber, pluralForm, properties )
 *
 * Return the appropriate name form currency format.
 */
var currencyNameFormat = function( formattedNumber, pluralForm, properties ) {
	var displayName, unitPattern,
		parts = [],
		displayNames = properties.displayNames || {},
		unitPatterns = properties.unitPatterns;

	displayName = displayNames[ "displayName-count-" + pluralForm ] ||
		displayNames[ "displayName-count-other" ] ||
		displayNames.displayName ||
		properties.currency;
	unitPattern = unitPatterns[ "unitPattern-count-" + pluralForm ] ||
		unitPatterns[ "unitPattern-count-other" ];

	formatMessageToParts( unitPattern, [ formattedNumber, displayName ]).forEach(function( part ) {
		if ( part.type === "variable" && part.name === "0" ) {
			part.value.forEach(function( part ) {
				partsPush( parts, part.type, part.value );
			});
		} else if ( part.type === "variable" && part.name === "1" ) {
			partsPush( parts, "currency", part.value );
		} else {
			partsPush( parts, "literal", part.value );
		}
	});

	return parts;
};




/**
 * symbolFormat( parts, symbol )
 *
 * Return the appropriate symbol/account form format.
 */
var currencySymbolFormat = function( parts, symbol ) {
	parts.forEach(function( part ) {
		if ( part.type === "currency" ) {
			part.value = symbol;
		}
	});
	return parts;
};




var currencyToPartsFormatterFn = function( numberToPartsFormatter, pluralGenerator, properties ) {
	var fn;

	// Return formatter when style is "name".
	if ( pluralGenerator && properties ) {
		fn = function currencyToPartsFormatter( value ) {
			validateParameterPresence( value, "value" );
			validateParameterTypeNumber( value, "value" );
			return currencyNameFormat(
				numberToPartsFormatter( value ),
				pluralGenerator( value ),
				properties
			);
		};

	// Return formatter when style is "symbol", "accounting", or "code".
	} else {
		fn = function currencyToPartsFormatter( value ) {

			// 1: Reusing pluralGenerator argument, but in this case it is actually `symbol`
			return currencySymbolFormat( numberToPartsFormatter( value ), pluralGenerator /* 1 */ );
		};
	}

	return fn;
};




/**
 * objectOmit( object, keys )
 *
 * Return a copy of the object, filtered to omit the blacklisted key or array of keys.
 */
var objectOmit = function( object, keys ) {
	var key,
		copy = {};

	keys = alwaysArray( keys );

	for ( key in object ) {
		if ( keys.indexOf( key ) === -1 ) {
			copy[ key ] = object[ key ];
		}
	}

	return copy;
};




function validateRequiredCldr( path, value ) {
	validateCldr( path, value, {
		skip: [
			/numbers\/currencies\/[^/]+\/symbol-alt-/,
			/supplemental\/currencyData\/fractions\/[A-Za-z]{3}$/
		]
	});
}

/**
 * .currencyFormatter( currency [, options] )
 *
 * @currency [String] 3-letter currency code as defined by ISO 4217.
 *
 * @options [Object]:
 * - style: [String] "symbol" (default), "accounting", "code" or "name".
 * - see also number/format options.
 *
 * Return a function that formats a currency according to the given options and default/instance
 * locale.
 */
Globalize.currencyFormatter =
Globalize.prototype.currencyFormatter = function( currency, options ) {
	var args, currencyToPartsFormatter, returnFn;

	validateParameterPresence( currency, "currency" );
	validateParameterTypeCurrency( currency, "currency" );

	validateParameterTypePlainObject( options, "options" );

	options = options || {};
	args = [ currency, options ];

	currencyToPartsFormatter = this.currencyToPartsFormatter( currency, options );
	returnFn = currencyFormatterFn( currencyToPartsFormatter );
	runtimeBind( args, this.cldr, returnFn, [ currencyToPartsFormatter ] );

	return returnFn;
};

/**
 * .currencyToPartsFormatter( currency [, options] )
 *
 * @currency [String] 3-letter currency code as defined by ISO 4217.
 *
 * @options [Object]:
 * - style: [String] "symbol" (default), "accounting", "code" or "name".
 * - see also number/format options.
 *
 * Return a currency formatter function (of the form below) according to the given options and the
 * default/instance locale.
 *
 * fn( value )
 *
 * @value [Number]
 *
 * Return a function that formats a currency to parts according to the given options
 * and the default/instance locale.
 */
Globalize.currencyToPartsFormatter =
Globalize.prototype.currencyToPartsFormatter = function( currency, options ) {
	var args, cldr, numberToPartsFormatter, pluralGenerator, properties, returnFn, style;

	validateParameterPresence( currency, "currency" );
	validateParameterTypeCurrency( currency, "currency" );

	validateParameterTypePlainObject( options, "options" );

	cldr = this.cldr;
	options = options || {};

	args = [ currency, options ];
	style = options.style || "symbol";

	validateDefaultLocale( cldr );

	// Get properties given style ("symbol" default, "code" or "name").
	cldr.on( "get", validateRequiredCldr );
	try {
		properties = ({
			accounting: currencySymbolProperties,
			code: currencySymbolProperties,
			name: currencyNameProperties,
			symbol: currencySymbolProperties
		}[ style ] )( currency, cldr, options );
	} finally {
		cldr.off( "get", validateRequiredCldr );
	}

	// options = options minus style, plus raw pattern.
	options = objectOmit( options, "style" );
	options.raw = properties.pattern;

	// Return formatter when style is "symbol", "accounting", or "code".
	if ( style === "symbol" || style === "accounting" || style === "code" ) {
		numberToPartsFormatter = this.numberToPartsFormatter( options );

		returnFn = currencyToPartsFormatterFn( numberToPartsFormatter, properties.symbol );

		runtimeBind( args, cldr, returnFn, [ numberToPartsFormatter, properties.symbol ] );

	// Return formatter when style is "name".
	} else {
		numberToPartsFormatter = this.numberToPartsFormatter( options );

		// Is plural module present? Yes, use its generator. Nope, use an error generator.
		pluralGenerator = this.plural !== undefined ?
			this.pluralGenerator() :
			createErrorPluralModulePresence;

		returnFn = currencyToPartsFormatterFn(
			numberToPartsFormatter,
			pluralGenerator,
			properties
		);

		runtimeBind( args, cldr, returnFn, [
			numberToPartsFormatter,
			pluralGenerator,
			properties
		]);
	}

	return returnFn;
};

/**
 * .currencyParser( currency [, options] )
 *
 * @currency [String] 3-letter currency code as defined by ISO 4217.
 *
 * @options [Object] see currencyFormatter.
 *
 * Return the currency parser according to the given options and the default/instance locale.
 */
Globalize.currencyParser =
Globalize.prototype.currencyParser = function( /* currency, options */ ) {

	// TODO implement parser.

};

/**
 * .formatCurrency( value, currency [, options] )
 *
 * @value [Number] number to be formatted.
 *
 * @currency [String] 3-letter currency code as defined by ISO 4217.
 *
 * @options [Object] see currencyFormatter.
 *
 * Format a currency according to the given options and the default/instance locale.
 */
Globalize.formatCurrency =
Globalize.prototype.formatCurrency = function( value, currency, options ) {
	validateParameterPresence( value, "value" );
	validateParameterTypeNumber( value, "value" );
	return this.currencyFormatter( currency, options )( value );
};

/**
 * .formatCurrencyToParts( value, currency [, options] )
 *
 * @value [Number] number to be formatted.
 *
 * @currency [String] 3-letter currency code as defined by ISO 4217.
 *
 * @options [Object] see currencyFormatter.
 *
 * Format a currency to parts according to the given options and the default/instance locale.
 */
Globalize.formatCurrencyToParts =
Globalize.prototype.formatCurrencyToParts = function( value, currency, options ) {
	validateParameterPresence( value, "value" );
	validateParameterTypeNumber( value, "value" );
	return this.currencyToPartsFormatter( currency, options )( value );
};

/**
 * .parseCurrency( value, currency [, options] )
 *
 * @value [String]
 *
 * @currency [String] 3-letter currency code as defined by ISO 4217.
 *
 * @options [Object]: See currencyFormatter.
 *
 * Return the parsed currency or NaN when value is invalid.
 */
Globalize.parseCurrency =
Globalize.prototype.parseCurrency = function( /* value, currency, options */ ) {
};

return Globalize;




}));

/**
 * Globalize v1.6.0
 *
 * http://github.com/jquery/globalize
 *
 * Copyright jQuery Foundation and other contributors
 * Released under the MIT license
 * http://jquery.org/license
 *
 * Date: 2020-09-08T11:54Z
 */
/*!
 * Globalize v1.6.0 2020-09-08T11:54Z Released under the MIT license
 * http://git.io/TrdQbw
 */
(function( root, factory ) {

	// UMD returnExports
	if ( typeof define === "function" && define.amd ) {

		// AMD
		define([
			"cldr",
			"../globalize",
			"./number",
			"cldr/event",
			"cldr/supplemental"
		], factory );
	} else if ( typeof exports === "object" ) {

		// Node, CommonJS
		module.exports = factory( require( "cldrjs" ), require( "../globalize" ) );
	} else {

		// Extend global
		factory( root.Cldr, root.Globalize );
	}
}(this, function( Cldr, Globalize ) {

var createError = Globalize._createError,
	createErrorUnsupportedFeature = Globalize._createErrorUnsupportedFeature,
	formatMessage = Globalize._formatMessage,
	isPlainObject = Globalize._isPlainObject,
	looseMatching = Globalize._looseMatching,
	numberNumberingSystemDigitsMap = Globalize._numberNumberingSystemDigitsMap,
	numberSymbol = Globalize._numberSymbol,
	partsJoin = Globalize._partsJoin,
	partsPush = Globalize._partsPush,
	regexpEscape = Globalize._regexpEscape,
	removeLiteralQuotes = Globalize._removeLiteralQuotes,
	runtimeBind = Globalize._runtimeBind,
	stringPad = Globalize._stringPad,
	validate = Globalize._validate,
	validateCldr = Globalize._validateCldr,
	validateDefaultLocale = Globalize._validateDefaultLocale,
	validateParameterPresence = Globalize._validateParameterPresence,
	validateParameterType = Globalize._validateParameterType,
	validateParameterTypePlainObject = Globalize._validateParameterTypePlainObject,
	validateParameterTypeString = Globalize._validateParameterTypeString;


var validateParameterTypeDate = function( value, name ) {
	validateParameterType( value, name, value === undefined || value instanceof Date, "Date" );
};




var createErrorInvalidParameterValue = function( name, value ) {
	return createError( "E_INVALID_PAR_VALUE", "Invalid `{name}` value ({value}).", {
		name: name,
		value: value
	});
};




/**
 * Create a map between the skeleton fields and their positions, e.g.,
 * {
 *   G: 0
 *   y: 1
 *   ...
 * }
 */
var validateSkeletonFieldsPosMap = "GyYuUrQqMLlwWEecdDFghHKkmsSAzZOvVXx".split( "" ).reduce(function( memo, item, i ) {
	memo[ item ] = i;
	return memo;
}, {});




/**
 * validateSkeleton( skeleton )
 *
 * skeleton: Assume `j` has already been converted into a localized hour field.
 */
var validateSkeleton = function validateSkeleton( skeleton ) {
	var last,

		// Using easier to read variable.
		fieldsPosMap = validateSkeletonFieldsPosMap;

	// "The fields are from the Date Field Symbol Table in Date Format Patterns"
	// Ref: http://www.unicode.org/reports/tr35/tr35-dates.html#availableFormats_appendItems
	// I.e., check for invalid characters.
	skeleton.replace( /[^GyYuUrQqMLlwWEecdDFghHKkmsSAzZOvVXx]/, function( field ) {
		throw createError(
			"E_INVALID_OPTIONS", "Invalid field `{invalidField}` of skeleton `{value}`",
			{
				invalidField: field,
				type: "skeleton",
				value: skeleton
			}
		);
	});

	// "The canonical order is from top to bottom in that table; that is, yM not My".
	// http://www.unicode.org/reports/tr35/tr35-dates.html#availableFormats_appendItems
	// I.e., check for invalid order.
	skeleton.split( "" ).every(function( field ) {
		if ( fieldsPosMap[ field ] < last ) {
			throw createError(
				"E_INVALID_OPTIONS", "Invalid order `{invalidField}` of skeleton `{value}`",
				{
					invalidField: field,
					type: "skeleton",
					value: skeleton
				}
			);
		}
		last = fieldsPosMap[ field ];
		return true;
	});
};




/**
 * Returns a new object created by using `object`'s values as keys, and the keys as values.
 */
var objectInvert = function( object, fn ) {
	fn = fn || function( object, key, value ) {
		object[ value ] = key;
		return object;
	};
	return Object.keys( object ).reduce(function( newObject, key ) {
		return fn( newObject, key, object[ key ] );
	}, {});
};




// Invert key and values, e.g., {"e": "eEc"} ==> {"e": "e", "E": "e", "c": "e"}.
var dateExpandPatternSimilarFieldsMap = objectInvert({
	"e": "eEc",
	"L": "ML"
}, function( object, key, value ) {
	value.split( "" ).forEach(function( field ) {
		object[ field ] = key;
	});
	return object;
});




var dateExpandPatternNormalizePatternType = function( character ) {
	return dateExpandPatternSimilarFieldsMap[ character ] || character;
};




var datePatternRe = ( /([a-z])\1*|'([^']|'')+'|''|./ig );




var stringRepeat = function( str, count ) {
	var i, result = "";
	for ( i = 0; i < count; i++ ) {
		result = result + str;
	}
	return result;
};




function expandBestMatchFormat( skeletonWithoutFractionalSeconds, bestMatchFormat ) {
	var i, j, bestMatchFormatParts, matchedType, matchedLength, requestedType,
		requestedLength, requestedSkeletonParts,

		// Using an easier to read variable.
		normalizePatternType = dateExpandPatternNormalizePatternType;

	requestedSkeletonParts = skeletonWithoutFractionalSeconds.match( datePatternRe );
	bestMatchFormatParts = bestMatchFormat.match( datePatternRe );

	for ( i = 0; i < bestMatchFormatParts.length; i++ ) {
		matchedType = bestMatchFormatParts[i].charAt( 0 );
		matchedLength = bestMatchFormatParts[i].length;
		for ( j = 0; j < requestedSkeletonParts.length; j++ ) {
			requestedType = requestedSkeletonParts[j].charAt( 0 );
			requestedLength = requestedSkeletonParts[j].length;
			if ( normalizePatternType( matchedType ) === normalizePatternType( requestedType ) &&
				matchedLength < requestedLength
			) {
				bestMatchFormatParts[i] = stringRepeat( matchedType, requestedLength );
			}
		}
	}

	return bestMatchFormatParts.join( "" );
}

// See: http://www.unicode.org/reports/tr35/tr35-dates.html#Matching_Skeletons
var dateExpandPatternAugmentFormat = function( requestedSkeleton, bestMatchFormat, decimalSeparator ) {
	var countOfFractionalSeconds, fractionalSecondMatch, lastSecondIdx,
		skeletonWithoutFractionalSeconds;

	fractionalSecondMatch = requestedSkeleton.match( /S/g );
	countOfFractionalSeconds = fractionalSecondMatch ? fractionalSecondMatch.length : 0;
	skeletonWithoutFractionalSeconds = requestedSkeleton.replace( /S/g, "" );

	bestMatchFormat = expandBestMatchFormat( skeletonWithoutFractionalSeconds, bestMatchFormat );

	lastSecondIdx = bestMatchFormat.lastIndexOf( "s" );
	if ( lastSecondIdx !== -1 && countOfFractionalSeconds !== 0 ) {
		bestMatchFormat =
			bestMatchFormat.slice( 0, lastSecondIdx + 1 ) +
			decimalSeparator +
			stringRepeat( "S", countOfFractionalSeconds ) +
			bestMatchFormat.slice( lastSecondIdx + 1 );
	}
	return bestMatchFormat;
};




var dateExpandPatternCompareFormats = function( formatA, formatB ) {
	var a, b, distance, lenA, lenB, typeA, typeB, i, j,

		// Using easier to read variables.
		normalizePatternType = dateExpandPatternNormalizePatternType;

	if ( formatA === formatB ) {
		return 0;
	}

	formatA = formatA.match( datePatternRe );
	formatB = formatB.match( datePatternRe );

	if ( formatA.length !== formatB.length ) {
		return -1;
	}

	distance = 1;
	for ( i = 0; i < formatA.length; i++ ) {
		a = formatA[ i ].charAt( 0 );
		typeA = normalizePatternType( a );
		typeB = null;
		for ( j = 0; j < formatB.length; j++ ) {
			b = formatB[ j ].charAt( 0 );
			typeB = normalizePatternType( b );
			if ( typeA === typeB ) {
				break;
			} else {
				typeB = null;
			}
		}
		if ( typeB === null ) {
			return -1;
		}
		lenA = formatA[ i ].length;
		lenB = formatB[ j ].length;
		distance = distance + Math.abs( lenA - lenB );

		// Most symbols have a small distance from each other, e.g., M ≅ L; E ≅ c; a ≅ b ≅ B;
		// H ≅ k ≅ h ≅ K; ...
		if ( a !== b ) {
			distance += 1;
		}

		// Numeric (l<3) and text fields (l>=3) are given a larger distance from each other.
		if ( ( lenA < 3 && lenB >= 3 ) || ( lenA >= 3 && lenB < 3 ) ) {
			distance += 20;
		}
	}
	return distance;
};




var dateExpandPatternGetBestMatchPattern = function( cldr, askedSkeleton ) {
	var availableFormats, decimalSeparator, pattern, ratedFormats, skeleton,
		path = "dates/calendars/gregorian/dateTimeFormats/availableFormats",

		// Using easier to read variables.
		augmentFormat = dateExpandPatternAugmentFormat,
		compareFormats = dateExpandPatternCompareFormats;

	pattern = cldr.main([ path, askedSkeleton ]);

	if ( askedSkeleton && !pattern ) {
		availableFormats = cldr.main([ path ]);
		ratedFormats = [];

		for ( skeleton in availableFormats ) {
			ratedFormats.push({
				skeleton: skeleton,
				pattern: availableFormats[ skeleton ],
				rate: compareFormats( askedSkeleton, skeleton )
			});
		}

		ratedFormats = ratedFormats
			.filter( function( format ) {
				return format.rate > -1;
			} )
			.sort( function( formatA, formatB ) {
				return formatA.rate - formatB.rate;
			});

		if ( ratedFormats.length ) {
			decimalSeparator = numberSymbol( "decimal", cldr );
			pattern = augmentFormat( askedSkeleton, ratedFormats[0].pattern, decimalSeparator );
		}
	}

	return pattern;
};




/**
 * expandPattern( options, cldr )
 *
 * @options [Object] if String, it's considered a skeleton. Object accepts:
 * - skeleton: [String] lookup availableFormat;
 * - date: [String] ( "full" | "long" | "medium" | "short" );
 * - time: [String] ( "full" | "long" | "medium" | "short" );
 * - datetime: [String] ( "full" | "long" | "medium" | "short" );
 * - raw: [String] For more info see datetime/format.js.
 *
 * @cldr [Cldr instance].
 *
 * Return the corresponding pattern.
 * Eg for "en":
 * - "GyMMMd" returns "MMM d, y G";
 * - { skeleton: "GyMMMd" } returns "MMM d, y G";
 * - { date: "full" } returns "EEEE, MMMM d, y";
 * - { time: "full" } returns "h:mm:ss a zzzz";
 * - { datetime: "full" } returns "EEEE, MMMM d, y 'at' h:mm:ss a zzzz";
 * - { raw: "dd/mm" } returns "dd/mm";
 */
var dateExpandPattern = function( options, cldr ) {
	var dateSkeleton, result, skeleton, timeSkeleton, type,

		// Using easier to read variables.
		getBestMatchPattern = dateExpandPatternGetBestMatchPattern;

	function combineDateTime( type, datePattern, timePattern ) {
		return formatMessage(
			cldr.main([
				"dates/calendars/gregorian/dateTimeFormats",
				type
			]),
			[ timePattern, datePattern ]
		);
	}

	switch ( true ) {
		case "skeleton" in options:
			skeleton = options.skeleton;

			// Preferred hour (j).
			skeleton = skeleton.replace( /j/g, function() {
				return cldr.supplemental.timeData.preferred();
			});

			validateSkeleton( skeleton );

			// Try direct map (note that getBestMatchPattern handles it).
			// ... or, try to "best match" the whole skeleton.
			result = getBestMatchPattern(
				cldr,
				skeleton
			);
			if ( result ) {
				break;
			}

			// ... or, try to "best match" the date and time parts individually.
			timeSkeleton = skeleton.split( /[^hHKkmsSAzZOvVXx]/ ).slice( -1 )[ 0 ];
			dateSkeleton = skeleton.split( /[^GyYuUrQqMLlwWdDFgEec]/ )[ 0 ];
			dateSkeleton = getBestMatchPattern(
				cldr,
				dateSkeleton
			);
			timeSkeleton = getBestMatchPattern(
				cldr,
				timeSkeleton
			);

			if ( /(MMMM|LLLL).*[Ec]/.test( dateSkeleton ) ) {
				type = "full";
			} else if ( /MMMM|LLLL/.test( dateSkeleton ) ) {
				type = "long";
			} else if ( /MMM|LLL/.test( dateSkeleton ) ) {
				type = "medium";
			} else {
				type = "short";
			}

			if ( dateSkeleton && timeSkeleton ) {
				result = combineDateTime( type, dateSkeleton, timeSkeleton );
			} else {
				result = dateSkeleton || timeSkeleton;
			}

			break;

		case "date" in options:
		case "time" in options:
			result = cldr.main([
				"dates/calendars/gregorian",
				"date" in options ? "dateFormats" : "timeFormats",
				( options.date || options.time )
			]);
			break;

		case "datetime" in options:
			result = combineDateTime( options.datetime,
				cldr.main([ "dates/calendars/gregorian/dateFormats", options.datetime ]),
				cldr.main([ "dates/calendars/gregorian/timeFormats", options.datetime ])
			);
			break;

		case "raw" in options:
			result = options.raw;
			break;

		default:
			throw createErrorInvalidParameterValue({
				name: "options",
				value: options
			});
	}

	return result;
};




var dateWeekDays = [ "sun", "mon", "tue", "wed", "thu", "fri", "sat" ];




/**
 * firstDayOfWeek
 */
var dateFirstDayOfWeek = function( cldr ) {
	return dateWeekDays.indexOf( cldr.supplemental.weekData.firstDay() );
};




/**
 * getTimeZoneName( length, type )
 */
var dateGetTimeZoneName = function( length, type, timeZone, cldr ) {
	var metaZone, result;

	if ( !timeZone ) {
		return;
	}

	result = cldr.main([
		"dates/timeZoneNames/zone",
		timeZone,
		length < 4 ? "short" : "long",
		type
	]);

	if ( result ) {
		return result;
	}

	// The latest metazone data of the metazone array.
	// TODO expand to support the historic metazones based on the given date.
	metaZone = cldr.supplemental([
		"metaZones/metazoneInfo/timezone", timeZone, 0,
		"usesMetazone/_mzone"
	]);

	return cldr.main([
		"dates/timeZoneNames/metazone",
		metaZone,
		length < 4 ? "short" : "long",
		type
	]);
};




/**
 * timezoneHourFormatShortH( hourFormat )
 *
 * @hourFormat [String]
 *
 * Unofficial deduction of the short hourFormat given time zone `hourFormat` element.
 * Official spec is pending resolution: http://unicode.org/cldr/trac/ticket/8293
 *
 * Example:
 * - "+HH.mm;-HH.mm" => "+H;-H"
 * - "+HH:mm;-HH:mm" => "+H;-H"
 * - "+HH:mm;−HH:mm" => "+H;−H" (Note MINUS SIGN \u2212)
 * - "+HHmm;-HHmm" => "+H:-H"
 */
var dateTimezoneHourFormatH = function( hourFormat ) {
	return hourFormat
		.split( ";" )
		.map(function( format ) {
			return format.slice( 0, format.indexOf( "H" ) + 1 );
		})
		.join( ";" );
};




/**
 * timezoneHourFormatLongHm( hourFormat )
 *
 * @hourFormat [String]
 *
 * Unofficial deduction of the short hourFormat given time zone `hourFormat` element.
 * Official spec is pending resolution: http://unicode.org/cldr/trac/ticket/8293
 *
 * Example (hFormat === "H"): (used for short Hm)
 * - "+HH.mm;-HH.mm" => "+H.mm;-H.mm"
 * - "+HH:mm;-HH:mm" => "+H:mm;-H:mm"
 * - "+HH:mm;−HH:mm" => "+H:mm;−H:mm" (Note MINUS SIGN \u2212)
 * - "+HHmm;-HHmm" => "+Hmm:-Hmm"
 *
 * Example (hFormat === "HH": (used for long Hm)
 * - "+HH.mm;-HH.mm" => "+HH.mm;-HH.mm"
 * - "+HH:mm;-HH:mm" => "+HH:mm;-HH:mm"
 * - "+H:mm;-H:mm"   => "+HH:mm;-HH:mm"
 * - "+HH:mm;−HH:mm" => "+HH:mm;−HH:mm" (Note MINUS SIGN \u2212)
 * - "+HHmm;-HHmm" => "+HHmm:-HHmm"
 */
var dateTimezoneHourFormatHm = function( hourFormat, hFormat ) {
	return hourFormat
		.split( ";" )
		.map(function( format ) {
			var parts = format.split( /H+/ );
			parts.splice( 1, 0, hFormat );
			return parts.join( "" );
		})
		.join( ";" );
};




var runtimeCacheDataBind = function( key, data ) {
	var fn = function() {
		return data;
	};
	fn.dataCacheKey = key;
	return fn;
};




/**
 * properties( pattern, cldr )
 *
 * @pattern [String] raw pattern.
 * ref: http://www.unicode.org/reports/tr35/tr35-dates.html#Date_Format_Patterns
 *
 * @cldr [Cldr instance].
 *
 * Return the properties given the pattern and cldr.
 *
 * TODO Support other calendar types.
 */
var dateFormatProperties = function( pattern, cldr, timeZone ) {
	var properties = {
			numberFormatters: {},
			pattern: pattern,
			timeSeparator: numberSymbol( "timeSeparator", cldr )
		},
		widths = [ "abbreviated", "wide", "narrow" ];

	function setNumberFormatterPattern( pad ) {
		properties.numberFormatters[ pad ] = stringPad( "", pad );
	}

	if ( timeZone ) {
		properties.timeZoneData = runtimeCacheDataBind( "iana/" + timeZone, {
			offsets: cldr.get([ "globalize-iana/zoneData", timeZone, "offsets" ]),
			untils: cldr.get([ "globalize-iana/zoneData", timeZone, "untils" ]),
			isdsts: cldr.get([ "globalize-iana/zoneData", timeZone, "isdsts" ])
		});
	}

	pattern.replace( datePatternRe, function( current ) {
		var aux, chr, daylightTzName, formatNumber, genericTzName, length, standardTzName;

		chr = current.charAt( 0 );
		length = current.length;

		if ( chr === "j" ) {

			// Locale preferred hHKk.
			// http://www.unicode.org/reports/tr35/tr35-dates.html#Time_Data
			properties.preferredTime = chr = cldr.supplemental.timeData.preferred();
		}

		// ZZZZ: same as "OOOO".
		if ( chr === "Z" && length === 4 ) {
			chr = "O";
			length = 4;
		}

		// z...zzz: "{shortRegion}", eg. "PST" or "PDT".
		// zzzz: "{regionName} {Standard Time}" or "{regionName} {Daylight Time}",
		//       e.g., "Pacific Standard Time" or "Pacific Daylight Time".
		// http://unicode.org/reports/tr35/tr35-dates.html#Date_Format_Patterns
		if ( chr === "z" ) {
			standardTzName = dateGetTimeZoneName( length, "standard", timeZone, cldr );
			daylightTzName = dateGetTimeZoneName( length, "daylight", timeZone, cldr );
			if ( standardTzName ) {
				properties.standardTzName = standardTzName;
			}
			if ( daylightTzName ) {
				properties.daylightTzName = daylightTzName;
			}

			// Fall through the "O" format in case one name is missing.
			if ( !standardTzName || !daylightTzName ) {
				chr = "O";
				if ( length < 4 ) {
					length = 1;
				}
			}
		}

		// v...vvv: "{shortRegion}", eg. "PT".
		// vvvv: "{regionName} {Time}" or "{regionName} {Time}",
		// e.g., "Pacific Time"
		// http://unicode.org/reports/tr35/tr35-dates.html#Date_Format_Patterns
		if ( chr === "v" ) {
			genericTzName = dateGetTimeZoneName( length, "generic", timeZone, cldr );

			// Fall back to "V" format.
			if ( !genericTzName ) {
				chr = "V";
				length = 4;
			}
		}

		switch ( chr ) {

			// Era
			case "G":
				properties.eras = cldr.main([
					"dates/calendars/gregorian/eras",
					length <= 3 ? "eraAbbr" : ( length === 4 ? "eraNames" : "eraNarrow" )
				]);
				break;

			// Year
			case "y":

				// Plain year.
				formatNumber = true;
				break;

			case "Y":

				// Year in "Week of Year"
				properties.firstDay = dateFirstDayOfWeek( cldr );
				properties.minDays = cldr.supplemental.weekData.minDays();
				formatNumber = true;
				break;

			case "u": // Extended year. Need to be implemented.
			case "U": // Cyclic year name. Need to be implemented.
				throw createErrorUnsupportedFeature({
					feature: "year pattern `" + chr + "`"
				});

			// Quarter
			case "Q":
			case "q":
				if ( length > 2 ) {
					if ( !properties.quarters ) {
						properties.quarters = {};
					}
					if ( !properties.quarters[ chr ] ) {
						properties.quarters[ chr ] = {};
					}
					properties.quarters[ chr ][ length ] = cldr.main([
						"dates/calendars/gregorian/quarters",
						chr === "Q" ? "format" : "stand-alone",
						widths[ length - 3 ]
					]);
				} else {
					formatNumber = true;
				}
				break;

			// Month
			case "M":
			case "L":
				if ( length > 2 ) {
					if ( !properties.months ) {
						properties.months = {};
					}
					if ( !properties.months[ chr ] ) {
						properties.months[ chr ] = {};
					}
					properties.months[ chr ][ length ] = cldr.main([
						"dates/calendars/gregorian/months",
						chr === "M" ? "format" : "stand-alone",
						widths[ length - 3 ]
					]);
				} else {
					formatNumber = true;
				}
				break;

			// Week - Week of Year (w) or Week of Month (W).
			case "w":
			case "W":
				properties.firstDay = dateFirstDayOfWeek( cldr );
				properties.minDays = cldr.supplemental.weekData.minDays();
				formatNumber = true;
				break;

			// Day
			case "d":
			case "D":
			case "F":
				formatNumber = true;
				break;

			case "g":

				// Modified Julian day. Need to be implemented.
				throw createErrorUnsupportedFeature({
					feature: "Julian day pattern `g`"
				});

			// Week day
			case "e":
			case "c":
				if ( length <= 2 ) {
					properties.firstDay = dateFirstDayOfWeek( cldr );
					formatNumber = true;
					break;
				}

			/* falls through */
			case "E":
				if ( !properties.days ) {
					properties.days = {};
				}
				if ( !properties.days[ chr ] ) {
					properties.days[ chr ] = {};
				}
				if ( length === 6 ) {

					// If short day names are not explicitly specified, abbreviated day names are
					// used instead.
					// http://www.unicode.org/reports/tr35/tr35-dates.html#months_days_quarters_eras
					// http://unicode.org/cldr/trac/ticket/6790
					properties.days[ chr ][ length ] = cldr.main([
							"dates/calendars/gregorian/days",
							chr === "c" ? "stand-alone" : "format",
							"short"
						]) || cldr.main([
							"dates/calendars/gregorian/days",
							chr === "c" ? "stand-alone" : "format",
							"abbreviated"
						]);
				} else {
					properties.days[ chr ][ length ] = cldr.main([
						"dates/calendars/gregorian/days",
						chr === "c" ? "stand-alone" : "format",
						widths[ length < 3 ? 0 : length - 3 ]
					]);
				}
				break;

			// Period (AM or PM)
			case "a":
				properties.dayPeriods = {
					am: cldr.main(
						"dates/calendars/gregorian/dayPeriods/format/wide/am"
					),
					pm: cldr.main(
						"dates/calendars/gregorian/dayPeriods/format/wide/pm"
					)
				};
				break;

			// Hour
			case "h": // 1-12
			case "H": // 0-23
			case "K": // 0-11
			case "k": // 1-24

			// Minute
			case "m":

			// Second
			case "s":
			case "S":
			case "A":
				formatNumber = true;
				break;

			// Zone
			case "v":
				if ( length !== 1 && length !== 4 ) {
					throw createErrorUnsupportedFeature({
						feature: "timezone pattern `" + pattern + "`"
					});
				}
				properties.genericTzName = genericTzName;
				break;

			case "V":

				if ( length === 1 ) {
					throw createErrorUnsupportedFeature({
						feature: "timezone pattern `" + pattern + "`"
					});
				}

				if ( timeZone ) {
					if ( length === 2 ) {
						properties.timeZoneName = timeZone;
						break;
					}

					var timeZoneName,
						exemplarCity = cldr.main([
							"dates/timeZoneNames/zone", timeZone, "exemplarCity"
						]);

					if ( length === 3 ) {
						if ( !exemplarCity ) {
							exemplarCity = cldr.main([
								"dates/timeZoneNames/zone/Etc/Unknown/exemplarCity"
							]);
						}
						timeZoneName = exemplarCity;
					}

					if ( exemplarCity && length === 4 ) {
						timeZoneName = formatMessage(
							cldr.main(
								"dates/timeZoneNames/regionFormat"
							),
							[ exemplarCity ]
						);
					}

					if ( timeZoneName ) {
						properties.timeZoneName = timeZoneName;
						break;
					}
				}

				if ( current === "v" ) {
					length = 1;
				}

			/* falls through */
			case "O":

				// O: "{gmtFormat}+H;{gmtFormat}-H" or "{gmtZeroFormat}", eg. "GMT-8" or "GMT".
				// OOOO: "{gmtFormat}{hourFormat}" or "{gmtZeroFormat}", eg. "GMT-08:00" or "GMT".
				properties.gmtFormat = cldr.main( "dates/timeZoneNames/gmtFormat" );
				properties.gmtZeroFormat = cldr.main( "dates/timeZoneNames/gmtZeroFormat" );

				// Unofficial deduction of the hourFormat variations.
				// Official spec is pending resolution: http://unicode.org/cldr/trac/ticket/8293
				aux = cldr.main( "dates/timeZoneNames/hourFormat" );
				properties.hourFormat = length < 4 ?
					[ dateTimezoneHourFormatH( aux ), dateTimezoneHourFormatHm( aux, "H" ) ] :
					dateTimezoneHourFormatHm( aux, "HH" );

			/* falls through */
			case "Z":
			case "X":
			case "x":
				setNumberFormatterPattern( 1 );
				setNumberFormatterPattern( 2 );
				break;
		}

		if ( formatNumber ) {
			setNumberFormatterPattern( length );
		}
	});

	return properties;
};




var dateFormatterFn = function( dateToPartsFormatter ) {
	return function dateFormatter( value ) {
		return partsJoin( dateToPartsFormatter( value ));
	};
};




/**
 * parseProperties( cldr )
 *
 * @cldr [Cldr instance].
 *
 * @timeZone [String] FIXME.
 *
 * Return parser properties.
 */
var dateParseProperties = function( cldr, timeZone ) {
	var properties = {
		preferredTimeData: cldr.supplemental.timeData.preferred()
	};

	if ( timeZone ) {
		properties.timeZoneData = runtimeCacheDataBind( "iana/" + timeZone, {
			offsets: cldr.get([ "globalize-iana/zoneData", timeZone, "offsets" ]),
			untils: cldr.get([ "globalize-iana/zoneData", timeZone, "untils" ]),
			isdsts: cldr.get([ "globalize-iana/zoneData", timeZone, "isdsts" ])
		});
	}

	return properties;
};


var ZonedDateTime = (function() {
function definePrivateProperty(object, property, value) {
  Object.defineProperty(object, property, {
    value: value
  });
}

function getUntilsIndex(original, untils) {
  var index = 0;
  var originalTime = original.getTime();

  // TODO Should we do binary search for improved performance?
  while (index < untils.length - 1 && originalTime >= untils[index]) {
    index++;
  }
  return index;
}

function setWrap(fn) {
  var offset1 = this.getTimezoneOffset();
  var ret = fn();
  this.original.setTime(new Date(this.getTime()));
  var offset2 = this.getTimezoneOffset();
  if (offset2 - offset1) {
    this.original.setMinutes(this.original.getMinutes() + offset2 - offset1);
  }
  return ret;
}

var ZonedDateTime = function(date, timeZoneData) {
  definePrivateProperty(this, "original", new Date(date.getTime()));
  definePrivateProperty(this, "local", new Date(date.getTime()));
  definePrivateProperty(this, "timeZoneData", timeZoneData);
  definePrivateProperty(this, "setWrap", setWrap);
  if (!(timeZoneData.untils && timeZoneData.offsets && timeZoneData.isdsts)) {
    throw new Error("Invalid IANA data");
  }
  this.setTime(this.local.getTime() - this.getTimezoneOffset() * 60 * 1000);
};

ZonedDateTime.prototype.clone = function() {
  return new ZonedDateTime(this.original, this.timeZoneData);
};

// Date field getters.
["getFullYear", "getMonth", "getDate", "getDay", "getHours", "getMinutes",
"getSeconds", "getMilliseconds"].forEach(function(method) {
  // Corresponding UTC method, e.g., "getUTCFullYear" if method === "getFullYear".
  var utcMethod = "getUTC" + method.substr(3);
  ZonedDateTime.prototype[method] = function() {
    return this.local[utcMethod]();
  };
});

// Note: Define .valueOf = .getTime for arithmetic operations like date1 - date2.
ZonedDateTime.prototype.valueOf =
ZonedDateTime.prototype.getTime = function() {
  return this.local.getTime() + this.getTimezoneOffset() * 60 * 1000;
};

ZonedDateTime.prototype.getTimezoneOffset = function() {
  var index = getUntilsIndex(this.original, this.timeZoneData.untils);
  return this.timeZoneData.offsets[index];
};

// Date field setters.
["setFullYear", "setMonth", "setDate", "setHours", "setMinutes", "setSeconds", "setMilliseconds"].forEach(function(method) {
  // Corresponding UTC method, e.g., "setUTCFullYear" if method === "setFullYear".
  var utcMethod = "setUTC" + method.substr(3);
  ZonedDateTime.prototype[method] = function(value) {
    var local = this.local;
    // Note setWrap is needed for seconds and milliseconds just because
    // abs(value) could be >= a minute.
    return this.setWrap(function() {
      return local[utcMethod](value);
    });
  };
});

ZonedDateTime.prototype.setTime = function(time) {
  return this.local.setTime(time);
};

ZonedDateTime.prototype.isDST = function() {
  var index = getUntilsIndex(this.original, this.timeZoneData.untils);
  return Boolean(this.timeZoneData.isdsts[index]);
};

ZonedDateTime.prototype.inspect = function() {
  var index = getUntilsIndex(this.original, this.timeZoneData.untils);
  var abbrs = this.timeZoneData.abbrs;
  return this.local.toISOString().replace(/Z$/, "") + " " +
    (abbrs && abbrs[index] + " " || (this.getTimezoneOffset() * -1) + " ") +
    (this.isDST() ? "(daylight savings)" : "");
};

ZonedDateTime.prototype.toDate = function() {
  return new Date(this.getTime());
};

// Type cast getters.
["toISOString", "toJSON", "toUTCString"].forEach(function(method) {
  ZonedDateTime.prototype[method] = function() {
    return this.toDate()[method]();
  };
});

return ZonedDateTime;
}());


/**
 * isLeapYear( year )
 *
 * @year [Number]
 *
 * Returns an indication whether the specified year is a leap year.
 */
var dateIsLeapYear = function( year ) {
	return new Date( year, 1, 29 ).getMonth() === 1;
};




/**
 * lastDayOfMonth( date )
 *
 * @date [Date]
 *
 * Return the last day of the given date's month
 */
var dateLastDayOfMonth = function( date ) {
	return new Date( date.getFullYear(), date.getMonth() + 1, 0 ).getDate();
};




/**
 * startOf changes the input to the beginning of the given unit.
 *
 * For example, starting at the start of a day, resets hours, minutes
 * seconds and milliseconds to 0. Starting at the month does the same, but
 * also sets the date to 1.
 *
 * Returns the modified date
 */
var dateStartOf = function( date, unit ) {
	date = date instanceof ZonedDateTime ? date.clone() : new Date( date.getTime() );
	switch ( unit ) {
		case "year":
			date.setMonth( 0 );
		/* falls through */
		case "month":
			date.setDate( 1 );
		/* falls through */
		case "day":
			date.setHours( 0 );
		/* falls through */
		case "hour":
			date.setMinutes( 0 );
		/* falls through */
		case "minute":
			date.setSeconds( 0 );
		/* falls through */
		case "second":
			date.setMilliseconds( 0 );
	}
	return date;
};




/**
 * Differently from native date.setDate(), this function returns a date whose
 * day remains inside the month boundaries. For example:
 *
 * setDate( FebDate, 31 ): a "Feb 28" date.
 * setDate( SepDate, 31 ): a "Sep 30" date.
 */
var dateSetDate = function( date, day ) {
	var lastDay = new Date( date.getFullYear(), date.getMonth() + 1, 0 ).getDate();

	date.setDate( day < 1 ? 1 : day < lastDay ? day : lastDay );
};




/**
 * Differently from native date.setMonth(), this function adjusts date if
 * needed, so final month is always the one set.
 *
 * setMonth( Jan31Date, 1 ): a "Feb 28" date.
 * setDate( Jan31Date, 8 ): a "Sep 30" date.
 */
var dateSetMonth = function( date, month ) {
	var originalDate = date.getDate();

	date.setDate( 1 );
	date.setMonth( month );
	dateSetDate( date, originalDate );
};




var outOfRange = function( value, low, high ) {
	return value < low || value > high;
};




/**
 * parse( value, tokens, properties )
 *
 * @value [String] string date.
 *
 * @tokens [Object] tokens returned by date/tokenizer.
 *
 * @properties [Object] output returned by date/tokenizer-properties.
 *
 * ref: http://www.unicode.org/reports/tr35/tr35-dates.html#Date_Format_Patterns
 */
var dateParse = function( value, tokens, properties ) {
	var amPm, day, daysOfYear, month, era, hour, hour12, timezoneOffset, valid,
		YEAR = 0,
		MONTH = 1,
		DAY = 2,
		HOUR = 3,
		MINUTE = 4,
		SECOND = 5,
		MILLISECONDS = 6,
		date = new Date(),
		truncateAt = [],
		units = [ "year", "month", "day", "hour", "minute", "second", "milliseconds" ];

	// Create globalize date with given timezone data.
	if ( properties.timeZoneData ) {
		date = new ZonedDateTime( date, properties.timeZoneData() );
	}

	if ( !tokens.length ) {
		return null;
	}

	valid = tokens.every(function( token ) {
		var century, chr, value, length;

		if ( token.type === "literal" ) {

			// continue
			return true;
		}

		chr = token.type.charAt( 0 );
		length = token.type.length;

		if ( chr === "j" ) {

			// Locale preferred hHKk.
			// http://www.unicode.org/reports/tr35/tr35-dates.html#Time_Data
			chr = properties.preferredTimeData;
		}

		switch ( chr ) {

			// Era
			case "G":
				truncateAt.push( YEAR );
				era = +token.value;
				break;

			// Year
			case "y":
				value = token.value;
				if ( length === 2 ) {
					if ( outOfRange( value, 0, 99 ) ) {
						return false;
					}

					// mimic dojo/date/locale: choose century to apply, according to a sliding
					// window of 80 years before and 20 years after present year.
					century = Math.floor( date.getFullYear() / 100 ) * 100;
					value += century;
					if ( value > date.getFullYear() + 20 ) {
						value -= 100;
					}
				}
				date.setFullYear( value );
				truncateAt.push( YEAR );
				break;

			case "Y": // Year in "Week of Year"
				throw createErrorUnsupportedFeature({
					feature: "year pattern `" + chr + "`"
				});

			// Quarter (skip)
			case "Q":
			case "q":
				break;

			// Month
			case "M":
			case "L":
				if ( length <= 2 ) {
					value = token.value;
				} else {
					value = +token.value;
				}
				if ( outOfRange( value, 1, 12 ) ) {
					return false;
				}

				// Setting the month later so that we have the correct year and can determine
				// the correct last day of February in case of leap year.
				month = value;
				truncateAt.push( MONTH );
				break;

			// Week (skip)
			case "w": // Week of Year.
			case "W": // Week of Month.
				break;

			// Day
			case "d":
				day = token.value;
				truncateAt.push( DAY );
				break;

			case "D":
				daysOfYear = token.value;
				truncateAt.push( DAY );
				break;

			case "F":

				// Day of Week in month. eg. 2nd Wed in July.
				// Skip
				break;

			// Week day
			case "e":
			case "c":
			case "E":

				// Skip.
				// value = arrayIndexOf( dateWeekDays, token.value );
				break;

			// Period (AM or PM)
			case "a":
				amPm = token.value;
				break;

			// Hour
			case "h": // 1-12
				value = token.value;
				if ( outOfRange( value, 1, 12 ) ) {
					return false;
				}
				hour = hour12 = true;
				date.setHours( value === 12 ? 0 : value );
				truncateAt.push( HOUR );
				break;

			case "K": // 0-11
				value = token.value;
				if ( outOfRange( value, 0, 11 ) ) {
					return false;
				}
				hour = hour12 = true;
				date.setHours( value );
				truncateAt.push( HOUR );
				break;

			case "k": // 1-24
				value = token.value;
				if ( outOfRange( value, 1, 24 ) ) {
					return false;
				}
				hour = true;
				date.setHours( value === 24 ? 0 : value );
				truncateAt.push( HOUR );
				break;

			case "H": // 0-23
				value = token.value;
				if ( outOfRange( value, 0, 23 ) ) {
					return false;
				}
				hour = true;
				date.setHours( value );
				truncateAt.push( HOUR );
				break;

			// Minute
			case "m":
				value = token.value;
				if ( outOfRange( value, 0, 59 ) ) {
					return false;
				}
				date.setMinutes( value );
				truncateAt.push( MINUTE );
				break;

			// Second
			case "s":
				value = token.value;
				if ( outOfRange( value, 0, 59 ) ) {
					return false;
				}
				date.setSeconds( value );
				truncateAt.push( SECOND );
				break;

			case "A":
				date.setHours( 0 );
				date.setMinutes( 0 );
				date.setSeconds( 0 );

			/* falls through */
			case "S":
				value = Math.round( token.value * Math.pow( 10, 3 - length ) );
				date.setMilliseconds( value );
				truncateAt.push( MILLISECONDS );
				break;

			// Zone
			case "z":
			case "Z":
			case "O":
			case "v":
			case "V":
			case "X":
			case "x":
				if ( typeof token.value === "number" ) {
					timezoneOffset = token.value;
				}
				break;
		}

		return true;
	});

	if ( !valid ) {
		return null;
	}

	// 12-hour format needs AM or PM, 24-hour format doesn't, ie. return null
	// if amPm && !hour12 || !amPm && hour12.
	if ( hour && !( !amPm ^ hour12 ) ) {
		return null;
	}

	if ( era === 0 ) {

		// 1 BC = year 0
		date.setFullYear( date.getFullYear() * -1 + 1 );
	}

	if ( month !== undefined ) {
		dateSetMonth( date, month - 1 );
	}

	if ( day !== undefined ) {
		if ( outOfRange( day, 1, dateLastDayOfMonth( date ) ) ) {
			return null;
		}
		date.setDate( day );
	} else if ( daysOfYear !== undefined ) {
		if ( outOfRange( daysOfYear, 1, dateIsLeapYear( date.getFullYear() ) ? 366 : 365 ) ) {
			return null;
		}
		date.setMonth( 0 );
		date.setDate( daysOfYear );
	}

	if ( hour12 && amPm === "pm" ) {
		date.setHours( date.getHours() + 12 );
	}

	if ( timezoneOffset !== undefined ) {
		date.setMinutes( date.getMinutes() + timezoneOffset - date.getTimezoneOffset() );
	}

	// Truncate date at the most precise unit defined. Eg.
	// If value is "12/31", and pattern is "MM/dd":
	// => new Date( <current Year>, 12, 31, 0, 0, 0, 0 );
	truncateAt = Math.max.apply( null, truncateAt );
	date = dateStartOf( date, units[ truncateAt ] );

	// Get date back from globalize date.
	if ( date instanceof ZonedDateTime ) {
		date = date.toDate();
	}

	return date;
};




/**
 * tokenizer( value, numberParser, properties )
 *
 * @value [String] string date.
 *
 * @numberParser [Function]
 *
 * @properties [Object] output returned by date/tokenizer-properties.
 *
 * Returns an Array of tokens, eg. value "5 o'clock PM", pattern "h 'o''clock' a":
 * [{
 *   type: "h",
 *   lexeme: "5"
 * }, {
 *   type: "literal",
 *   lexeme: " "
 * }, {
 *   type: "literal",
 *   lexeme: "o'clock"
 * }, {
 *   type: "literal",
 *   lexeme: " "
 * }, {
 *   type: "a",
 *   lexeme: "PM",
 *   value: "pm"
 * }]
 *
 * OBS: lexeme's are always String and may return invalid ranges depending of the token type.
 * Eg. "99" for month number.
 *
 * Return an empty Array when not successfully parsed.
 */
var dateTokenizer = function( value, numberParser, properties ) {
	var digitsRe, valid,
		tokens = [],
		widths = [ "abbreviated", "wide", "narrow" ];

	digitsRe = properties.digitsRe;
	value = looseMatching( value );

	valid = properties.pattern.match( datePatternRe ).every(function( current ) {
		var aux, chr, length, numeric, tokenRe,
			token = {};

		function hourFormatParse( tokenRe, numberParser ) {
			var aux, isPositive,
				match = value.match( tokenRe );
			numberParser = numberParser || function( value ) {
				return +value;
			};

			if ( !match ) {
				return false;
			}

			isPositive = match[ 1 ];

			// hourFormat containing H only, e.g., `+H;-H`
			if ( match.length < 6 ) {
				aux = isPositive ? 1 : 3;
				token.value = numberParser( match[ aux ] ) * 60;

			// hourFormat containing H and m, e.g., `+HHmm;-HHmm`
			} else if ( match.length < 10 ) {
				aux = isPositive ? [ 1, 3 ] : [ 5, 7 ];
				token.value = numberParser( match[ aux[ 0 ] ] ) * 60 +
					numberParser( match[ aux[ 1 ] ] );

			// hourFormat containing H, m, and s e.g., `+HHmmss;-HHmmss`
			} else {
				aux = isPositive ? [ 1, 3, 5 ] : [ 7, 9, 11 ];
				token.value = numberParser( match[ aux[ 0 ] ] ) * 60 +
					numberParser( match[ aux[ 1 ] ] ) +
					numberParser( match[ aux[ 2 ] ] ) / 60;
			}

			if ( isPositive ) {
				token.value *= -1;
			}

			return true;
		}

		function oneDigitIfLengthOne() {
			if ( length === 1 ) {

				// Unicode equivalent to /\d/
				numeric = true;
				return tokenRe = digitsRe;
			}
		}

		function oneOrTwoDigitsIfLengthOne() {
			if ( length === 1 ) {

				// Unicode equivalent to /\d\d?/
				numeric = true;
				return tokenRe = new RegExp( "^(" + digitsRe.source + "){1,2}" );
			}
		}

		function oneOrTwoDigitsIfLengthOneOrTwo() {
			if ( length === 1 || length === 2 ) {

				// Unicode equivalent to /\d\d?/
				numeric = true;
				return tokenRe = new RegExp( "^(" + digitsRe.source + "){1,2}" );
			}
		}

		function twoDigitsIfLengthTwo() {
			if ( length === 2 ) {

				// Unicode equivalent to /\d\d/
				numeric = true;
				return tokenRe = new RegExp( "^(" + digitsRe.source + "){2}" );
			}
		}

		// Brute-force test every locale entry in an attempt to match the given value.
		// Return the first found one (and set token accordingly), or null.
		function lookup( path ) {
			var array = properties[ path.join( "/" ) ];

			if ( !array ) {
				return null;
			}

			// array of pairs [key, value] sorted by desc value length.
			array.some(function( item ) {
				var valueRe = item[ 1 ];
				if ( valueRe.test( value ) ) {
					token.value = item[ 0 ];
					tokenRe = item[ 1 ];
					return true;
				}
			});
			return null;
		}

		token.type = current;
		chr = current.charAt( 0 );
		length = current.length;

		if ( chr === "Z" ) {

			// Z..ZZZ: same as "xxxx".
			if ( length < 4 ) {
				chr = "x";
				length = 4;

			// ZZZZ: same as "OOOO".
			} else if ( length < 5 ) {
				chr = "O";
				length = 4;

			// ZZZZZ: same as "XXXXX"
			} else {
				chr = "X";
				length = 5;
			}
		}

		if ( chr === "z" ) {
			if ( properties.standardOrDaylightTzName ) {
				token.value = null;
				tokenRe = properties.standardOrDaylightTzName;
			}
		}

		// v...vvv: "{shortRegion}", eg. "PT".
		// vvvv: "{regionName} {Time}" or "{regionName} {Time}",
		// e.g., "Pacific Time"
		// http://unicode.org/reports/tr35/tr35-dates.html#Date_Format_Patterns
		if ( chr === "v" ) {
			if ( properties.genericTzName ) {
				token.value = null;
				tokenRe = properties.genericTzName;

			// Fall back to "V" format.
			} else {
				chr = "V";
				length = 4;
			}
		}

		if ( chr === "V" && properties.timeZoneName ) {
			token.value = length === 2 ? properties.timeZoneName : null;
			tokenRe = properties.timeZoneNameRe;
		}

		switch ( chr ) {

			// Era
			case "G":
				lookup([
					"gregorian/eras",
					length <= 3 ? "eraAbbr" : ( length === 4 ? "eraNames" : "eraNarrow" )
				]);
				break;

			// Year
			case "y":
			case "Y":
				numeric = true;

				// number l=1:+, l=2:{2}, l=3:{3,}, l=4:{4,}, ...
				if ( length === 1 ) {

					// Unicode equivalent to /\d+/.
					tokenRe = new RegExp( "^(" + digitsRe.source + ")+" );
				} else if ( length === 2 ) {

					// Lenient parsing: there's no year pattern to indicate non-zero-padded 2-digits
					// year, so parser accepts both zero-padded and non-zero-padded for `yy`.
					//
					// Unicode equivalent to /\d\d?/
					tokenRe = new RegExp( "^(" + digitsRe.source + "){1,2}" );
				} else {

					// Unicode equivalent to /\d{length,}/
					tokenRe = new RegExp( "^(" + digitsRe.source + "){" + length + ",}" );
				}
				break;

			// Quarter
			case "Q":
			case "q":

				// number l=1:{1}, l=2:{2}.
				// lookup l=3...
				oneDigitIfLengthOne() || twoDigitsIfLengthTwo() ||
					lookup([
						"gregorian/quarters",
						chr === "Q" ? "format" : "stand-alone",
						widths[ length - 3 ]
					]);
				break;

			// Month
			case "M":
			case "L":

				// number l=1:{1,2}, l=2:{2}.
				// lookup l=3...
				//
				// Lenient parsing: skeleton "yMd" (i.e., one M) may include MM for the pattern,
				// therefore parser accepts both zero-padded and non-zero-padded for M and MM.
				// Similar for L.
				oneOrTwoDigitsIfLengthOneOrTwo() || lookup([
					"gregorian/months",
					chr === "M" ? "format" : "stand-alone",
					widths[ length - 3 ]
				]);
				break;

			// Day
			case "D":

				// number {l,3}.
				if ( length <= 3 ) {

					// Equivalent to /\d{length,3}/
					numeric = true;
					tokenRe = new RegExp( "^(" + digitsRe.source + "){" + length + ",3}" );
				}
				break;

			case "W":
			case "F":

				// number l=1:{1}.
				oneDigitIfLengthOne();
				break;

			// Week day
			case "e":
			case "c":

				// number l=1:{1}, l=2:{2}.
				// lookup for length >=3.
				if ( length <= 2 ) {
					oneDigitIfLengthOne() || twoDigitsIfLengthTwo();
					break;
				}

			/* falls through */
			case "E":
				if ( length === 6 ) {

					// Note: if short day names are not explicitly specified, abbreviated day
					// names are used instead http://www.unicode.org/reports/tr35/tr35-dates.html#months_days_quarters_eras
					lookup([
						"gregorian/days",
						[ chr === "c" ? "stand-alone" : "format" ],
						"short"
					]) || lookup([
						"gregorian/days",
						[ chr === "c" ? "stand-alone" : "format" ],
						"abbreviated"
					]);
				} else {
					lookup([
						"gregorian/days",
						[ chr === "c" ? "stand-alone" : "format" ],
						widths[ length < 3 ? 0 : length - 3 ]
					]);
				}
				break;

			// Period (AM or PM)
			case "a":
				lookup([
					"gregorian/dayPeriods/format/wide"
				]);
				break;

			// Week
			case "w":

				// number l1:{1,2}, l2:{2}.
				oneOrTwoDigitsIfLengthOne() || twoDigitsIfLengthTwo();
				break;

			// Day, Hour, Minute, or Second
			case "d":
			case "h":
			case "H":
			case "K":
			case "k":
			case "j":
			case "m":
			case "s":

				// number l1:{1,2}, l2:{2}.
				//
				// Lenient parsing:
				// - skeleton "hms" (i.e., one m) always includes mm for the pattern, i.e., it's
				//   impossible to use a different skeleton to parse non-zero-padded minutes,
				//   therefore parser accepts both zero-padded and non-zero-padded for m. Similar
				//   for seconds s.
				// - skeleton "hms" (i.e., one h) may include h or hh for the pattern, i.e., it's
				//   impossible to use a different skeleton to parser non-zero-padded hours for some
				//   locales, therefore parser accepts both zero-padded and non-zero-padded for h.
				//   Similar for d (in skeleton yMd).
				oneOrTwoDigitsIfLengthOneOrTwo();
				break;

			case "S":

				// number {l}.

				// Unicode equivalent to /\d{length}/
				numeric = true;
				tokenRe = new RegExp( "^(" + digitsRe.source + "){" + length + "}" );
				break;

			case "A":

				// number {l+5}.

				// Unicode equivalent to /\d{length+5}/
				numeric = true;
				tokenRe = new RegExp( "^(" + digitsRe.source + "){" + ( length + 5 ) + "}" );
				break;

			// Zone
			case "v":
			case "V":
			case "z":
				if ( tokenRe && tokenRe.test( value ) ) {
					break;
				}
				if ( chr === "V" && length === 2 ) {
					break;
				}

			/* falls through */
			case "O":

				// O: "{gmtFormat}+H;{gmtFormat}-H" or "{gmtZeroFormat}", eg. "GMT-8" or "GMT".
				// OOOO: "{gmtFormat}{hourFormat}" or "{gmtZeroFormat}", eg. "GMT-08:00" or "GMT".
				if ( value === properties[ "timeZoneNames/gmtZeroFormat" ] ) {
					token.value = 0;
					tokenRe = properties[ "timeZoneNames/gmtZeroFormatRe" ];
				} else {
					aux = properties[ "timeZoneNames/hourFormat" ].some(function( hourFormatRe ) {
						if ( hourFormatParse( hourFormatRe, numberParser ) ) {
							tokenRe = hourFormatRe;
							return true;
						}
					});
					if ( !aux ) {
						return null;
					}
				}
				break;

			case "X":

				// Same as x*, except it uses "Z" for zero offset.
				if ( value === "Z" ) {
					token.value = 0;
					tokenRe = /^Z/;
					break;
				}

			/* falls through */
			case "x":

				// x: hourFormat("+HH[mm];-HH[mm]")
				// xx: hourFormat("+HHmm;-HHmm")
				// xxx: hourFormat("+HH:mm;-HH:mm")
				// xxxx: hourFormat("+HHmm[ss];-HHmm[ss]")
				// xxxxx: hourFormat("+HH:mm[:ss];-HH:mm[:ss]")
				aux = properties.x.some(function( hourFormatRe ) {
					if ( hourFormatParse( hourFormatRe ) ) {
						tokenRe = hourFormatRe;
						return true;
					}
				});
				if ( !aux ) {
					return null;
				}
				break;

			case "'":
				token.type = "literal";
				tokenRe = new RegExp( "^" + regexpEscape( removeLiteralQuotes( current ) ) );
				break;

			default:
				token.type = "literal";
				tokenRe = new RegExp( "^" + regexpEscape( current ) );
		}

		if ( !tokenRe ) {
			return false;
		}

		// Get lexeme and consume it.
		value = value.replace( tokenRe, function( lexeme ) {
			token.lexeme = lexeme;
			if ( numeric ) {
				token.value = numberParser( lexeme );
			}
			return "";
		});

		if ( !token.lexeme ) {
			return false;
		}

		if ( numeric && isNaN( token.value ) ) {
			return false;
		}

		tokens.push( token );
		return true;
	});

	if ( value !== "" ) {
		valid = false;
	}

	return valid ? tokens : [];
};




var dateParserFn = function( numberParser, parseProperties, tokenizerProperties ) {
	return function dateParser( value ) {
		var tokens;

		validateParameterPresence( value, "value" );
		validateParameterTypeString( value, "value" );

		tokens = dateTokenizer( value, numberParser, tokenizerProperties );
		return dateParse( value, tokens, parseProperties ) || null;
	};
};




var objectFilter = function( object, testRe ) {
	var key,
		copy = {};

	for ( key in object ) {
		if ( testRe.test( key ) ) {
			copy[ key ] = object[ key ];
		}
	}

	return copy;
};




/**
 * tokenizerProperties( pattern, cldr )
 *
 * @pattern [String] raw pattern.
 *
 * @cldr [Cldr instance].
 *
 * Return Object with data that will be used by tokenizer.
 */
var dateTokenizerProperties = function( pattern, cldr, timeZone ) {
	var digitsReSource,
		properties = {
			pattern: looseMatching( pattern )
		},
		timeSeparator = numberSymbol( "timeSeparator", cldr ),
		widths = [ "abbreviated", "wide", "narrow" ];

	digitsReSource = numberNumberingSystemDigitsMap( cldr );
	digitsReSource = digitsReSource ? "[" + digitsReSource + "]" : "\\d";
	properties.digitsRe = new RegExp( digitsReSource );

	// Transform:
	// - "+H;-H" -> /\+(\d\d?)|-(\d\d?)/
	// - "+HH;-HH" -> /\+(\d\d)|-(\d\d)/
	// - "+HHmm;-HHmm" -> /\+(\d\d)(\d\d)|-(\d\d)(\d\d)/
	// - "+HH:mm;-HH:mm" -> /\+(\d\d):(\d\d)|-(\d\d):(\d\d)/
	//
	// If gmtFormat is GMT{0}, the regexp must fill {0} in each side, e.g.:
	// - "+H;-H" -> /GMT\+(\d\d?)|GMT-(\d\d?)/
	function hourFormatRe( hourFormat, gmtFormat, digitsReSource, timeSeparator ) {
		var re;

		if ( !digitsReSource ) {
			digitsReSource = "\\d";
		}
		if ( !gmtFormat ) {
			gmtFormat = "{0}";
		}

		re = hourFormat
			.replace( "+", "\\+" )

			// Unicode equivalent to (\\d\\d)
			.replace( /HH|mm|ss/g, "((" + digitsReSource + "){2})" )

			// Unicode equivalent to (\\d\\d?)
			.replace( /H|m/g, "((" + digitsReSource + "){1,2})" );

		if ( timeSeparator ) {
			re = re.replace( /:/g, timeSeparator );
		}

		re = re.split( ";" ).map(function( part ) {
			return gmtFormat.replace( "{0}", part );
		}).join( "|" );

		return new RegExp( "^" + re );
	}

	function populateProperties( path, value ) {

		// Skip
		var skipRe = /(timeZoneNames\/zone|supplemental\/metaZones|timeZoneNames\/metazone|timeZoneNames\/regionFormat|timeZoneNames\/gmtFormat)/;
		if ( skipRe.test( path ) ) {
			return;
		}

		if ( !value ) {
			return;
		}

		// The `dates` and `calendars` trim's purpose is to reduce properties' key size only.
		path = path.replace( /^.*\/dates\//, "" ).replace( /calendars\//, "" );

		// Specific filter for "gregorian/dayPeriods/format/wide".
		if ( path === "gregorian/dayPeriods/format/wide" ) {
			value = objectFilter( value, /^am|^pm/ );
		}

		// Transform object into array of pairs [key, /value/], sort by desc value length.
		if ( isPlainObject( value ) ) {
			value = Object.keys( value ).map(function( key ) {
				return [ key, new RegExp( "^" + regexpEscape( looseMatching( value[ key ] ) ) ) ];
			}).sort(function( a, b ) {
				return b[ 1 ].source.length - a[ 1 ].source.length;
			});

		// If typeof value === "string".
		} else {
			value = looseMatching( value );
		}
		properties[ path ] = value;
	}

	function regexpSourceSomeTerm( terms ) {
		return "(" + terms.filter(function( item ) {
			return item;
		}).reduce(function( memo, item ) {
			return memo + "|" + item;
		}) + ")";
	}

	cldr.on( "get", populateProperties );

	pattern.match( datePatternRe ).forEach(function( current ) {
		var aux, chr, daylightTzName, gmtFormat, length, standardTzName;

		chr = current.charAt( 0 );
		length = current.length;

		if ( chr === "Z" ) {
			if ( length < 5 ) {
				chr = "O";
				length = 4;
			} else {
				chr = "X";
				length = 5;
			}
		}

		// z...zzz: "{shortRegion}", eg. "PST" or "PDT".
		// zzzz: "{regionName} {Standard Time}" or "{regionName} {Daylight Time}",
		//       e.g., "Pacific Standard Time" or "Pacific Daylight Time".
		// http://unicode.org/reports/tr35/tr35-dates.html#Date_Format_Patterns
		if ( chr === "z" ) {
			standardTzName = dateGetTimeZoneName( length, "standard", timeZone, cldr );
			daylightTzName = dateGetTimeZoneName( length, "daylight", timeZone, cldr );
			if ( standardTzName ) {
				standardTzName = regexpEscape( looseMatching( standardTzName ) );
			}
			if ( daylightTzName ) {
				daylightTzName = regexpEscape( looseMatching( daylightTzName ) );
			}
			if ( standardTzName || daylightTzName ) {
				properties.standardOrDaylightTzName = new RegExp(
					"^" + regexpSourceSomeTerm([ standardTzName, daylightTzName ])
				);
			}

			// Fall through the "O" format in case one name is missing.
			if ( !standardTzName || !daylightTzName ) {
				chr = "O";
				if ( length < 4 ) {
					length = 1;
				}
			}
		}

		// v...vvv: "{shortRegion}", eg. "PT".
		// vvvv: "{regionName} {Time}" or "{regionName} {Time}",
		// e.g., "Pacific Time"
		// http://unicode.org/reports/tr35/tr35-dates.html#Date_Format_Patterns
		if ( chr === "v" ) {
			if ( length !== 1 && length !== 4 ) {
				throw createErrorUnsupportedFeature({
					feature: "timezone pattern `" + pattern + "`"
				});
			}
			var genericTzName = dateGetTimeZoneName( length, "generic", timeZone, cldr );
			if ( genericTzName ) {
				properties.genericTzName = new RegExp(
					"^" + regexpEscape( looseMatching( genericTzName ) )
				);
				chr = "O";

			// Fall back to "V" format.
			} else {
				chr = "V";
				length = 4;
			}
		}

		switch ( chr ) {

			// Era
			case "G":
				cldr.main([
					"dates/calendars/gregorian/eras",
					length <= 3 ? "eraAbbr" : ( length === 4 ? "eraNames" : "eraNarrow" )
				]);
				break;

			// Year
			case "u": // Extended year. Need to be implemented.
			case "U": // Cyclic year name. Need to be implemented.
				throw createErrorUnsupportedFeature({
					feature: "year pattern `" + chr + "`"
				});

			// Quarter
			case "Q":
			case "q":
				if ( length > 2 ) {
					cldr.main([
						"dates/calendars/gregorian/quarters",
						chr === "Q" ? "format" : "stand-alone",
						widths[ length - 3 ]
					]);
				}
				break;

			// Month
			case "M":
			case "L":

				// number l=1:{1,2}, l=2:{2}.
				// lookup l=3...
				if ( length > 2 ) {
					cldr.main([
						"dates/calendars/gregorian/months",
						chr === "M" ? "format" : "stand-alone",
						widths[ length - 3 ]
					]);
				}
				break;

			// Day
			case "g":

				// Modified Julian day. Need to be implemented.
				throw createErrorUnsupportedFeature({
					feature: "Julian day pattern `g`"
				});

			// Week day
			case "e":
			case "c":

				// lookup for length >=3.
				if ( length <= 2 ) {
					break;
				}

			/* falls through */
			case "E":
				if ( length === 6 ) {

					// Note: if short day names are not explicitly specified, abbreviated day
					// names are used instead http://www.unicode.org/reports/tr35/tr35-dates.html#months_days_quarters_eras
					cldr.main([
						"dates/calendars/gregorian/days",
						[ chr === "c" ? "stand-alone" : "format" ],
						"short"
					]) || cldr.main([
						"dates/calendars/gregorian/days",
						[ chr === "c" ? "stand-alone" : "format" ],
						"abbreviated"
					]);
				} else {
					cldr.main([
						"dates/calendars/gregorian/days",
						[ chr === "c" ? "stand-alone" : "format" ],
						widths[ length < 3 ? 0 : length - 3 ]
					]);
				}
				break;

			// Period (AM or PM)
			case "a":
				cldr.main(
					"dates/calendars/gregorian/dayPeriods/format/wide"
				);
				break;

			// Zone
			case "V":

				if ( length === 1 ) {
					throw createErrorUnsupportedFeature({
						feature: "timezone pattern `" + pattern + "`"
					});
				}

				if ( timeZone ) {
					if ( length === 2 ) {

						// Skip looseMatching processing since timeZone is a canonical posix value.
						properties.timeZoneName = timeZone;
						properties.timeZoneNameRe = new RegExp( "^" + regexpEscape( timeZone ) );
						break;
					}

					var timeZoneName,
						exemplarCity = cldr.main([
							"dates/timeZoneNames/zone", timeZone, "exemplarCity"
						]);

					if ( length === 3 ) {
						if ( !exemplarCity ) {
							exemplarCity = cldr.main([
								"dates/timeZoneNames/zone/Etc/Unknown/exemplarCity"
							]);
						}
						timeZoneName = exemplarCity;
					}

					if ( exemplarCity && length === 4 ) {
						timeZoneName = formatMessage(
							cldr.main(
								"dates/timeZoneNames/regionFormat"
							),
							[ exemplarCity ]
						);
					}

					if ( timeZoneName ) {
						timeZoneName = looseMatching( timeZoneName );
						properties.timeZoneName = timeZoneName;
						properties.timeZoneNameRe = new RegExp(
							"^" + regexpEscape( timeZoneName )
						);
					}
				}

				if ( current === "v" ) {
					length = 1;
				}

			/* falls through */
			case "z":
			case "O":
				gmtFormat = cldr.main( "dates/timeZoneNames/gmtFormat" );
				cldr.main( "dates/timeZoneNames/gmtZeroFormat" );
				cldr.main( "dates/timeZoneNames/hourFormat" );
				properties[ "timeZoneNames/gmtZeroFormatRe" ] =
					new RegExp( "^" + regexpEscape( properties[ "timeZoneNames/gmtZeroFormat" ] ) );
				aux = properties[ "timeZoneNames/hourFormat" ];
				properties[ "timeZoneNames/hourFormat" ] = (
					length < 4 ?
						[ dateTimezoneHourFormatHm( aux, "H" ), dateTimezoneHourFormatH( aux ) ] :
						[ dateTimezoneHourFormatHm( aux, "HH" ) ]
				).map(function( hourFormat ) {
					return hourFormatRe(
						hourFormat,
						gmtFormat,
						digitsReSource,
						timeSeparator
					);
				});

			/* falls through */
			case "X":
			case "x":

				// x: hourFormat("+HH[mm];-HH[mm]")
				// xx: hourFormat("+HHmm;-HHmm")
				// xxx: hourFormat("+HH:mm;-HH:mm")
				// xxxx: hourFormat("+HHmm[ss];-HHmm[ss]")
				// xxxxx: hourFormat("+HH:mm[:ss];-HH:mm[:ss]")
				properties.x = [
					[ "+HHmm;-HHmm", "+HH;-HH" ],
					[ "+HHmm;-HHmm" ],
					[ "+HH:mm;-HH:mm" ],
					[ "+HHmmss;-HHmmss", "+HHmm;-HHmm" ],
					[ "+HH:mm:ss;-HH:mm:ss", "+HH:mm;-HH:mm" ]
				][ length - 1 ].map(function( hourFormat ) {
					return hourFormatRe( hourFormat );
				});
		}
	});

	cldr.off( "get", populateProperties );

	return properties;
};




/**
 * dayOfWeek( date, firstDay )
 *
 * @date
 *
 * @firstDay the result of `dateFirstDayOfWeek( cldr )`
 *
 * Return the day of the week normalized by the territory's firstDay [0-6].
 * Eg for "mon":
 * - return 0 if territory is GB, or BR, or DE, or FR (week starts on "mon");
 * - return 1 if territory is US (week starts on "sun");
 * - return 2 if territory is EG (week starts on "sat");
 */
var dateDayOfWeek = function( date, firstDay ) {
	return ( date.getDay() - firstDay + 7 ) % 7;
};




/**
 * distanceInDays( from, to )
 *
 * Return the distance in days between from and to Dates.
 */
var dateDistanceInDays = function( from, to ) {
	var inDays = 864e5;
	return ( to.getTime() - from.getTime() ) / inDays;
};




/**
 * dayOfYear
 *
 * Return the distance in days of the date to the begin of the year [0-d].
 */
var dateDayOfYear = function( date ) {
	return Math.floor( dateDistanceInDays( dateStartOf( date, "year" ), date ) );
};




// Invert key and values, e.g., {"year": "yY"} ==> {"y": "year", "Y": "year"}
var dateFieldsMap = objectInvert({
	"era": "G",
	"year": "yY",
	"quarter": "qQ",
	"month": "ML",
	"week": "wW",
	"day": "dDF",
	"weekday": "ecE",
	"dayperiod": "a",
	"hour": "hHkK",
	"minute": "m",
	"second": "sSA",
	"zone": "zvVOxX"
}, function( object, key, value ) {
	value.split( "" ).forEach(function( symbol ) {
		object[ symbol ] = key;
	});
	return object;
});




/**
 * millisecondsInDay
 */
var dateMillisecondsInDay = function( date ) {

	// TODO Handle daylight savings discontinuities
	return date - dateStartOf( date, "day" );
};




/**
 * hourFormat( date, format, timeSeparator, formatNumber )
 *
 * Return date's timezone offset according to the format passed.
 * Eg for format when timezone offset is 180:
 * - "+H;-H": -3
 * - "+HHmm;-HHmm": -0300
 * - "+HH:mm;-HH:mm": -03:00
 * - "+HH:mm:ss;-HH:mm:ss": -03:00:00
 */
var dateTimezoneHourFormat = function( date, format, timeSeparator, formatNumber ) {
	var absOffset,
		offset = date.getTimezoneOffset();

	absOffset = Math.abs( offset );
	formatNumber = formatNumber || {
		1: function( value ) {
			return stringPad( value, 1 );
		},
		2: function( value ) {
			return stringPad( value, 2 );
		}
	};

	return format

		// Pick the correct sign side (+ or -).
		.split( ";" )[ offset > 0 ? 1 : 0 ]

		// Localize time separator
		.replace( ":", timeSeparator )

		// Update hours offset.
		.replace( /HH?/, function( match ) {
			return formatNumber[ match.length ]( Math.floor( absOffset / 60 ) );
		})

		// Update minutes offset and return.
		.replace( /mm/, function() {
			return formatNumber[ 2 ]( Math.floor( absOffset % 60 ) );
		})

		// Update minutes offset and return.
		.replace( /ss/, function() {
			return formatNumber[ 2 ]( Math.floor( absOffset % 1 * 60 ) );
		});
};




/**
 * format( date, properties )
 *
 * @date [Date instance].
 *
 * @properties
 *
 * TODO Support other calendar types.
 *
 * Disclosure: this function borrows excerpts of dojo/date/locale.
 */
var dateFormat = function( date, numberFormatters, properties ) {
	var parts = [];

	var timeSeparator = properties.timeSeparator;

	// create globalize date with given timezone data
	if ( properties.timeZoneData ) {
		date = new ZonedDateTime( date, properties.timeZoneData() );
	}

	properties.pattern.replace( datePatternRe, function( current ) {
		var aux, dateField, type, value,
			chr = current.charAt( 0 ),
			length = current.length;

		if ( chr === "j" ) {

			// Locale preferred hHKk.
			// http://www.unicode.org/reports/tr35/tr35-dates.html#Time_Data
			chr = properties.preferredTime;
		}

		if ( chr === "Z" ) {

			// Z..ZZZ: same as "xxxx".
			if ( length < 4 ) {
				chr = "x";
				length = 4;

			// ZZZZ: same as "OOOO".
			} else if ( length < 5 ) {
				chr = "O";
				length = 4;

			// ZZZZZ: same as "XXXXX"
			} else {
				chr = "X";
				length = 5;
			}
		}

		// z...zzz: "{shortRegion}", e.g., "PST" or "PDT".
		// zzzz: "{regionName} {Standard Time}" or "{regionName} {Daylight Time}",
		//       e.g., "Pacific Standard Time" or "Pacific Daylight Time".
		if ( chr === "z" ) {
			if ( date.isDST ) {
				value = date.isDST() ? properties.daylightTzName : properties.standardTzName;
			}

			// Fall back to "O" format.
			if ( !value ) {
				chr = "O";
				if ( length < 4 ) {
					length = 1;
				}
			}
		}

		switch ( chr ) {

			// Era
			case "G":
				value = properties.eras[ date.getFullYear() < 0 ? 0 : 1 ];
				break;

			// Year
			case "y":

				// Plain year.
				// The length specifies the padding, but for two letters it also specifies the
				// maximum length.
				value = date.getFullYear();
				if ( length === 2 ) {
					value = String( value );
					value = +value.substr( value.length - 2 );
				}
				break;

			case "Y":

				// Year in "Week of Year"
				// The length specifies the padding, but for two letters it also specifies the
				// maximum length.
				// yearInWeekofYear = date + DaysInAWeek - (dayOfWeek - firstDay) - minDays
				value = new Date( date.getTime() );
				value.setDate(
					value.getDate() + 7 -
					dateDayOfWeek( date, properties.firstDay ) -
					properties.firstDay -
					properties.minDays
				);
				value = value.getFullYear();
				if ( length === 2 ) {
					value = String( value );
					value = +value.substr( value.length - 2 );
				}
				break;

			// Quarter
			case "Q":
			case "q":
				value = Math.ceil( ( date.getMonth() + 1 ) / 3 );
				if ( length > 2 ) {
					value = properties.quarters[ chr ][ length ][ value ];
				}
				break;

			// Month
			case "M":
			case "L":
				value = date.getMonth() + 1;
				if ( length > 2 ) {
					value = properties.months[ chr ][ length ][ value ];
				}
				break;

			// Week
			case "w":

				// Week of Year.
				// woy = ceil( ( doy + dow of 1/1 ) / 7 ) - minDaysStuff ? 1 : 0.
				// TODO should pad on ww? Not documented, but I guess so.
				value = dateDayOfWeek( dateStartOf( date, "year" ), properties.firstDay );
				value = Math.ceil( ( dateDayOfYear( date ) + value ) / 7 ) -
					( 7 - value >= properties.minDays ? 0 : 1 );
				break;

			case "W":

				// Week of Month.
				// wom = ceil( ( dom + dow of `1/month` ) / 7 ) - minDaysStuff ? 1 : 0.
				value = dateDayOfWeek( dateStartOf( date, "month" ), properties.firstDay );
				value = Math.ceil( ( date.getDate() + value ) / 7 ) -
					( 7 - value >= properties.minDays ? 0 : 1 );
				break;

			// Day
			case "d":
				value = date.getDate();
				break;

			case "D":
				value = dateDayOfYear( date ) + 1;
				break;

			case "F":

				// Day of Week in month. eg. 2nd Wed in July.
				value = Math.floor( date.getDate() / 7 ) + 1;
				break;

			// Week day
			case "e":
			case "c":
				if ( length <= 2 ) {

					// Range is [1-7] (deduced by example provided on documentation)
					// TODO Should pad with zeros (not specified in the docs)?
					value = dateDayOfWeek( date, properties.firstDay ) + 1;
					break;
				}

			/* falls through */
			case "E":
				value = dateWeekDays[ date.getDay() ];
				value = properties.days[ chr ][ length ][ value ];
				break;

			// Period (AM or PM)
			case "a":
				value = properties.dayPeriods[ date.getHours() < 12 ? "am" : "pm" ];
				break;

			// Hour
			case "h": // 1-12
				value = ( date.getHours() % 12 ) || 12;
				break;

			case "H": // 0-23
				value = date.getHours();
				break;

			case "K": // 0-11
				value = date.getHours() % 12;
				break;

			case "k": // 1-24
				value = date.getHours() || 24;
				break;

			// Minute
			case "m":
				value = date.getMinutes();
				break;

			// Second
			case "s":
				value = date.getSeconds();
				break;

			case "S":
				value = Math.round( date.getMilliseconds() * Math.pow( 10, length - 3 ) );
				break;

			case "A":
				value = Math.round( dateMillisecondsInDay( date ) * Math.pow( 10, length - 3 ) );
				break;

			// Zone
			case "z":
				break;

			case "v":

				// v...vvv: "{shortRegion}", eg. "PT".
				// vvvv: "{regionName} {Time}",
				//       e.g., "Pacific Time".
				if ( properties.genericTzName ) {
					value = properties.genericTzName;
					break;
				}

			/* falls through */
			case "V":

				//VVVV: "{explarCity} {Time}", e.g., "Los Angeles Time"
				if ( properties.timeZoneName ) {
					value = properties.timeZoneName;
					break;
				}

				if ( current === "v" ) {
					length = 1;
				}

			/* falls through */
			case "O":

				// O: "{gmtFormat}+H;{gmtFormat}-H" or "{gmtZeroFormat}", eg. "GMT-8" or "GMT".
				// OOOO: "{gmtFormat}{hourFormat}" or "{gmtZeroFormat}", eg. "GMT-08:00" or "GMT".
				if ( date.getTimezoneOffset() === 0 ) {
					value = properties.gmtZeroFormat;
				} else {

					// If O..OOO and timezone offset has non-zero minutes, show minutes.
					if ( length < 4 ) {
						aux = date.getTimezoneOffset();
						aux = properties.hourFormat[ aux % 60 - aux % 1 === 0 ? 0 : 1 ];
					} else {
						aux = properties.hourFormat;
					}

					value = dateTimezoneHourFormat(
						date,
						aux,
						timeSeparator,
						numberFormatters
					);
					value = properties.gmtFormat.replace( /\{0\}/, value );
				}
				break;

			case "X":

				// Same as x*, except it uses "Z" for zero offset.
				if ( date.getTimezoneOffset() === 0 ) {
					value = "Z";
					break;
				}

			/* falls through */
			case "x":

				// x: hourFormat("+HH[mm];-HH[mm]")
				// xx: hourFormat("+HHmm;-HHmm")
				// xxx: hourFormat("+HH:mm;-HH:mm")
				// xxxx: hourFormat("+HHmm[ss];-HHmm[ss]")
				// xxxxx: hourFormat("+HH:mm[:ss];-HH:mm[:ss]")
				aux = date.getTimezoneOffset();

				// If x and timezone offset has non-zero minutes, use xx (i.e., show minutes).
				if ( length === 1 && aux % 60 - aux % 1 !== 0 ) {
					length += 1;
				}

				// If (xxxx or xxxxx) and timezone offset has zero seconds, use xx or xxx
				// respectively (i.e., don't show optional seconds).
				if ( ( length === 4 || length === 5 ) && aux % 1 === 0 ) {
					length -= 2;
				}

				value = [
					"+HH;-HH",
					"+HHmm;-HHmm",
					"+HH:mm;-HH:mm",
					"+HHmmss;-HHmmss",
					"+HH:mm:ss;-HH:mm:ss"
				][ length - 1 ];

				value = dateTimezoneHourFormat( date, value, ":" );
				break;

			// timeSeparator
			case ":":
				value = timeSeparator;
				break;

			// ' literals.
			case "'":
				value = removeLiteralQuotes( current );
				break;

			// Anything else is considered a literal, including [ ,:/.@#], chinese, japonese, and
			// arabic characters.
			default:
				value = current;

		}
		if ( typeof value === "number" ) {
			value = numberFormatters[ length ]( value );
		}

		dateField = dateFieldsMap[ chr ];
		type = dateField ? dateField : "literal";

		partsPush( parts, type, value );
	});

	return parts;

};




var dateToPartsFormatterFn = function( numberFormatters, properties ) {
	return function dateToPartsFormatter( value ) {
		validateParameterPresence( value, "value" );
		validateParameterTypeDate( value, "value" );

		return dateFormat( value, numberFormatters, properties );
	};

};




function optionsHasStyle( options ) {
	return options.skeleton !== undefined ||
		options.date !== undefined ||
		options.time !== undefined ||
		options.datetime !== undefined ||
		options.raw !== undefined;
}

function validateRequiredCldr( path, value ) {
	validateCldr( path, value, {
		skip: [
			/dates\/calendars\/gregorian\/dateTimeFormats\/availableFormats/,
			/dates\/calendars\/gregorian\/days\/.*\/short/,
			/dates\/timeZoneNames\/zone/,
			/dates\/timeZoneNames\/metazone/,
			/globalize-iana/,
			/supplemental\/metaZones/,
			/supplemental\/timeData\/(?!001)/,
			/supplemental\/weekData\/(?!001)/
		]
	});
}

function validateOptionsPreset( options ) {
	validateOptionsPresetEach( "date", options );
	validateOptionsPresetEach( "time", options );
	validateOptionsPresetEach( "datetime", options );
}

function validateOptionsPresetEach( type, options ) {
	var value = options[ type ];
	validate(
		"E_INVALID_OPTIONS",
		"Invalid `{{type}: \"{value}\"}`.",
		value === undefined || [ "short", "medium", "long", "full" ].indexOf( value ) !== -1,
		{ type: type, value: value }
	);
}

function validateOptionsSkeleton( pattern, skeleton ) {
	validate(
		"E_INVALID_OPTIONS",
		"Invalid `{skeleton: \"{value}\"}` based on provided CLDR.",
		skeleton === undefined || ( typeof pattern === "string" && pattern ),
		{ type: "skeleton", value: skeleton }
	);
}

function validateRequiredIana( timeZone ) {
	return function( path, value ) {

		if ( !/globalize-iana/.test( path ) ) {
			return;
		}

		validate(
			"E_MISSING_IANA_TZ",
			"Missing required IANA timezone content for `{timeZone}`: `{path}`.",
			value,
			{
				path: path.replace( /globalize-iana\//, "" ),
				timeZone: timeZone
			}
		);
	};
}

/**
 * .loadTimeZone( json )
 *
 * @json [JSON]
 *
 * Load IANA timezone data.
 */
Globalize.loadTimeZone = function( json ) {
	var customData = {
			"globalize-iana": json
		};

	validateParameterPresence( json, "json" );
	validateParameterTypePlainObject( json, "json" );

	Cldr.load( customData );
};

/**
 * .dateFormatter( options )
 *
 * @options [Object] see date/expand_pattern for more info.
 *
 * Return a date formatter function (of the form below) according to the given options and the
 * default/instance locale.
 *
 * fn( value )
 *
 * @value [Date]
 *
 * Return a function that formats a date according to the given `format` and the default/instance
 * locale.
 */
Globalize.dateFormatter =
Globalize.prototype.dateFormatter = function( options ) {
	var args, dateToPartsFormatter, returnFn;

	validateParameterTypePlainObject( options, "options" );

	options = options || {};
	if ( !optionsHasStyle( options ) ) {
		options.skeleton = "yMd";
	}
	args = [ options ];

	dateToPartsFormatter = this.dateToPartsFormatter( options );
	returnFn = dateFormatterFn( dateToPartsFormatter );
	runtimeBind( args, this.cldr, returnFn, [ dateToPartsFormatter ] );

	return returnFn;
};

/**
 * .dateToPartsFormatter( options )
 *
 * @options [Object] see date/expand_pattern for more info.
 *
 * Return a date formatter function (of the form below) according to the given options and the
 * default/instance locale.
 *
 * fn( value )
 *
 * @value [Date]
 *
 * Return a function that formats a date to parts according to the given `format`
 * and the default/instance
 * locale.
 */
Globalize.dateToPartsFormatter =
Globalize.prototype.dateToPartsFormatter = function( options ) {
	var args, cldr, numberFormatters, pad, pattern, properties, returnFn,
		timeZone, ianaListener;

	validateParameterTypePlainObject( options, "options" );

	cldr = this.cldr;
	options = options || {};
	if ( !optionsHasStyle( options ) ) {
		options.skeleton = "yMd";
	}

	validateOptionsPreset( options );
	validateDefaultLocale( cldr );

	timeZone = options.timeZone;
	validateParameterTypeString( timeZone, "options.timeZone" );

	args = [ options ];

	cldr.on( "get", validateRequiredCldr );
	if ( timeZone ) {
		ianaListener = validateRequiredIana( timeZone );
		cldr.on( "get", ianaListener );
	}
	try {
		pattern = dateExpandPattern( options, cldr );
		validateOptionsSkeleton( pattern, options.skeleton );
		properties = dateFormatProperties( pattern, cldr, timeZone );
	} finally {
		cldr.off( "get", validateRequiredCldr );
		if ( ianaListener ) {
			cldr.off( "get", ianaListener );
		}
	}

	// Create needed number formatters.
	numberFormatters = properties.numberFormatters;
	delete properties.numberFormatters;
	for ( pad in numberFormatters ) {
		numberFormatters[ pad ] = this.numberFormatter({
			raw: numberFormatters[ pad ]
		});
	}

	returnFn = dateToPartsFormatterFn( numberFormatters, properties );

	runtimeBind( args, cldr, returnFn, [ numberFormatters, properties ] );

	return returnFn;
};

/**
 * .dateParser( options )
 *
 * @options [Object] see date/expand_pattern for more info.
 *
 * Return a function that parses a string date according to the given `formats` and the
 * default/instance locale.
 */
Globalize.dateParser =
Globalize.prototype.dateParser = function( options ) {
	var args, cldr, numberParser, parseProperties, pattern, returnFn, timeZone,
		tokenizerProperties;

	validateParameterTypePlainObject( options, "options" );

	cldr = this.cldr;
	options = options || {};
	if ( !optionsHasStyle( options ) ) {
		options.skeleton = "yMd";
	}

	validateOptionsPreset( options );
	validateDefaultLocale( cldr );

	timeZone = options.timeZone;
	validateParameterTypeString( timeZone, "options.timeZone" );

	args = [ options ];

	try {
		cldr.on( "get", validateRequiredCldr );
		if ( timeZone ) {
			cldr.on( "get", validateRequiredIana( timeZone ) );
		}
		pattern = dateExpandPattern( options, cldr );
		validateOptionsSkeleton( pattern, options.skeleton );
		tokenizerProperties = dateTokenizerProperties( pattern, cldr, timeZone );
		parseProperties = dateParseProperties( cldr, timeZone );
	} finally {
		cldr.off( "get", validateRequiredCldr );
		if ( timeZone ) {
			cldr.off( "get", validateRequiredIana( timeZone ) );
		}
	}
	numberParser = this.numberParser({ raw: "0" });

	returnFn = dateParserFn( numberParser, parseProperties, tokenizerProperties );

	runtimeBind( args, cldr, returnFn, [ numberParser, parseProperties, tokenizerProperties ] );

	return returnFn;
};

/**
 * .formatDate( value, options )
 *
 * @value [Date]
 *
 * @options [Object] see date/expand_pattern for more info.
 *
 * Formats a date or number according to the given options string and the default/instance locale.
 */
Globalize.formatDate =
Globalize.prototype.formatDate = function( value, options ) {
	validateParameterPresence( value, "value" );
	validateParameterTypeDate( value, "value" );

	return this.dateFormatter( options )( value );
};

/**
 * .formatDateToParts( value, options )
 *
 * @value [Date]
 *
 * @options [Object] see date/expand_pattern for more info.
 *
 * Formats a date or number to parts according to the given options and the default/instance locale.
 */
Globalize.formatDateToParts =
Globalize.prototype.formatDateToParts = function( value, options ) {
	validateParameterPresence( value, "value" );
	validateParameterTypeDate( value, "value" );

	return this.dateToPartsFormatter( options )( value );
};

/**
 * .parseDate( value, options )
 *
 * @value [String]
 *
 * @options [Object] see date/expand_pattern for more info.
 *
 * Return a Date instance or null.
 */
Globalize.parseDate =
Globalize.prototype.parseDate = function( value, options ) {
	validateParameterPresence( value, "value" );
	validateParameterTypeString( value, "value" );

	return this.dateParser( options )( value );
};

return Globalize;




}));

/*!
* DevExtreme (dx.all.js)
* Version: 19.2.11
* Build date: Mon Dec 14 2020
*
* Copyright (c) 2012 - 2020 Developer Express Inc. ALL RIGHTS RESERVED
* Read about DevExtreme licensing here: https://js.devexpress.com/Licensing/
*/
"use strict";!function(e){function t(i){if(n[i])return n[i].exports;var o=n[i]={i:i,l:!1,exports:{}};return e[i].call(o.exports,o,o.exports,t),o.l=!0,o.exports}var n={};return t.m=e,t.c=n,t.d=function(e,n,i){t.o(e,n)||Object.defineProperty(e,n,{configurable:!1,enumerable:!0,get:i})},t.n=function(e){var n=e&&e.__esModule?function(){return e.default}:function(){return e};return t.d(n,"a",n),n},t.o=function(e,t){return Object.prototype.hasOwnProperty.call(e,t)},t.p="",t(t.s=894)}([function(e,t,n){var i=n(1).isPlainObject,o=function(e,t,n){e=e||{};for(var i in t)if(Object.prototype.hasOwnProperty.call(t,i)){var o=t[i];i in e&&!n||(e[i]=o)}return e},a=function e(t){t=t||{};var n=1,o=!1;for("boolean"==typeof t&&(o=t,t=arguments[1]||{},n++);n<arguments.length;n++){var a=arguments[n];if(null!=a)for(var r in a){var s,l=t[r],u=a[r],c=!1;"__proto__"!==r&&t!==u&&(o&&u&&(i(u)||(c=Array.isArray(u)))?(s=c?l&&Array.isArray(l)?l:[]:l&&i(l)?l:{},t[r]=e(o,s,u)):void 0!==u&&(t[r]=u))}}return t};t.extend=a,t.extendFromObject=o},function(e,t,n){function i(e){"@babel/helpers - typeof";return(i="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}var o={"[object Array]":"array","[object Date]":"date","[object Object]":"object","[object String]":"string","[object Null]":"null"},a=function(e){var t=Object.prototype.toString.call(e);return"object"===i(e)?o[t]||"object":i(e)},r=function(e){return"boolean"==typeof e},s=function(e){return h(e)&&e.toString().indexOf("e")!==-1},l=function(e){return"date"===a(e)},u=function(e){return null!==e&&void 0!==e},c=function(e){return"function"==typeof e},d=function(e){return"string"==typeof e},h=function(e){return"number"==typeof e&&isFinite(e)||!isNaN(e-parseFloat(e))},f=function(e){return"object"===a(e)},p=function(e){var t;for(t in e)return!1;return!0},g=function(e){if(!e||"[object Object]"!==Object.prototype.toString.call(e))return!1;var t=Object.getPrototypeOf(e),n=Object.hasOwnProperty.call(t,"constructor")&&t.constructor;return"function"==typeof n&&Object.toString.call(n)===Object.toString.call(Object)},_=function(e){return["object","array","function"].indexOf(a(e))===-1},m=function(e){return null!=e&&e===e.window},v=function(e){return!(!e.jquery&&!e.dxRenderer)},y=function(e){return e&&c(e.then)},b=function(e){return e&&c(e.done)&&c(e.fail)};t.isBoolean=r,t.isExponential=s,t.isDate=l,t.isDefined=u,t.isFunction=c,t.isString=d,t.isNumeric=h,t.isObject=f,t.isEmptyObject=p,t.isPlainObject=g,t.isPrimitive=_,t.isWindow=m,t.isRenderer=v,t.isPromise=y,t.isDeferred=b,t.type=a},function(e,t,n){var i=n(216);e.exports=i.get()},function(e,t,n){var i=function(e,t){if(Array.isArray(e))return e.map(t);var n=[];for(var i in e)n.push(t(e[i],i));return n},o=function(e,t){if(e){if("length"in e)for(var n=0;n<e.length&&t.call(e[n],n,e[n])!==!1;n++);else for(var i in e)if(t.call(e[i],i,e[i])===!1)break;return e}},a=function(e,t){if(e&&"length"in e&&0!==e.length)for(var n=e.length-1;n>=0&&t.call(e[n],n,e[n])!==!1;n--);};t.map=i,t.each=o,t.reverseEach=a},function(e,t,n){function i(e){return e&&e.__esModule?e:{"default":e}}var o,a=n(28),r=i(a),s=n(35),l=i(s),u=n(6),c=n(20),d=n(3),h=n(1),f=function(e,t){return(0,h.isDefined)(e)?e:t},p=function(e,t){var n=new u.Deferred,i=t||this,o={promise:n.promise(),abort:function(){clearTimeout(r),n.rejectWith(i)}},a=function(){var t=e.call(i);t&&t.done&&(0,h.isFunction)(t.done)?t.done(function(){n.resolveWith(i)}):n.resolveWith(i)},r=(arguments[2]||setTimeout)(a,"number"==typeof t?t:0);return o},g=[],_=[],m=[],v=function(e,t,n){if(o&&o!==e)return g.push(t),_.push(e),n=n||new u.Deferred,m.push(n),n;var i=o,a=m.length;o=e;var r=t();return r||(m.length>a?r=u.when.apply(this,m.slice(a)):n&&n.resolve()),o=i,n&&r&&r.done&&r.done(n.resolve).fail(n.reject),!o&&g.length&&("render"===_.shift()?y:b)(g.shift(),m.shift()),r||(0,u.when)()},y=function(e,t){return v("render",e,t)},b=function(e,t){return v("update",e,t)},x=function(e){return function(){var t=this;return v("render",function(){return e.call(t)})}},w=function(e){return function(){var t=this;return v("update",function(){return e.call(t)})}},C=function(e,t,n){var i=[],o=0;return(0,d.each)(t,function(t,a){var r=0,s=n?n(a):a;(0,d.each)(e,function(e,t){var n=s[e];if(void 0!==n)return k(n,t)?void r++:(r=-1,!1)}),r<o||(r>o&&(i.length=0,o=r),i.push(a))}),i},k=function(e,t){if(Array.isArray(e)&&Array.isArray(t)){var n=!1;return(0,d.each)(e,function(e,i){if(i!==t[e])return n=!0,!1}),!n}return e===t},S=function(e){var t,n;switch((0,h.type)(e)){case"string":return e.split(/\s+/,2);case"object":return[null!==(t=e.x)&&void 0!==t?t:e.h,null!==(n=e.y)&&void 0!==n?n:e.v];case"number":return[e];case"array":return e;default:return null}},I=function(e){var t=(0,h.isString)(e)?e:e.toString(),n=t.match(/[^a-zA-Z0-9_]/g);return n&&(0,d.each)(n,function(e,n){t=t.replace(n,"__"+n.charCodeAt()+"__")}),t},D=function(e){var t=e.match(/__\d+__/g);return t&&t.forEach(function(t){var n=parseInt(t.replace("__",""));e=e.replace(t,String.fromCharCode(n))}),e},T=function(e,t){var n=S(e),i=t?parseFloat(n&&n[0]):parseInt(n&&n[0],10),o=t?parseFloat(n&&n[1]):parseInt(n&&n[1],10);return isFinite(i)||(i=0),isFinite(o)||(o=i),{h:i,v:o}},E=function(e){if(e instanceof l.default)return e.toString();if((0,h.isObject)(e)||Array.isArray(e))try{var t=JSON.stringify(e);return"{}"===t?e:t}catch(t){return e}return e},A=function(e){return e.replace(/[[\]{}\-()*+?.\\^$|\s]/g,"\\$&")},O=function(e){var t=(0,r.default)().serverDecimalSeparator;return(0,h.isDefined)(e)&&(e=e.toString().replace(".",t)),e},P=function(){},R=function(){return(new u.Deferred).resolve().promise()},B=function(e,t,n){for(var i=[],o=!n,a=0;a<e.length;a++){var r=!!t(e[a],a);r===o&&i.push(e[a])}return i},M=function(e,t,n){if(e.length!==t.length)return!1;for(var i=0;i<e.length;i++)if(!L(e[i],t[i],n+1))return!1;return!0},V=function(e,t,n,i){for(var o in e)if(Object.prototype.hasOwnProperty.call(e,o)&&!L(e[o],t[o],n+1,i))return!1;for(var a in t)if(!(a in e))return!1;return!0},F=3,L=function(e,t){var n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:0,i=!(arguments.length>3&&void 0!==arguments[3])||arguments[3];e=(0,c.toComparable)(e,!0),t=(0,c.toComparable)(t,!0);var o=i?e===t:e==t;return!!(o||n>=F)||((0,h.isObject)(e)&&(0,h.isObject)(t)?V(e,t,n,i):!(!Array.isArray(e)||!Array.isArray(t))&&M(e,t,n))};t.ensureDefined=f,t.executeAsync=p,t.deferRender=y,t.deferRenderer=x,t.deferUpdate=b,t.deferUpdater=w,t.pairToObject=T,t.splitPair=S,t.findBestMatches=C,t.normalizeKey=I,t.denormalizeKey=D,t.getKeyHash=E,t.escapeRegExp=A,t.applyServerDecimalSeparator=O,t.noop=P,t.asyncNoop=R,t.grep=B,t.equalByValue=L},function(e,t,n){function i(e){"@babel/helpers - typeof";return(i="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}var o,a=n(114),r=n(0).extend,s=n(11),l=n(7),u=l.getWindow(),c=n(55),d=n(1),h=n(27),f=d.isWindow,p=d.isFunction,g=d.isString,_=n(21),m=n(181),v=n(217),y=n(62),b="dxEmptyEventType",x={mouseenter:"mouseover",mouseleave:"mouseout",pointerenter:"pointerover",pointerleave:"pointerout"},w={focusin:"focus",focusout:"blur"},C=["blur","focus","load"],k=["touchmove","wheel","mousewheel","touchstart"],S=function(e,t){return!f(e)&&"#document"!==e.nodeName&&s.elementMatches(e,t)},I=new m,D=0,T=function(){var e={};return a.add(function(t,n){e[t]=n}),{getField:function(t,n){return e[t]&&e[t][n]},callMethod:function(t,n,i,o){return e[t]&&e[t][n]&&e[t][n].apply(i,o)}}}(),E=function e(t,n){var i=t[0];if(i)if(s.isNode(i)||f(i))n.apply(W,t);else{if(g(i)||!("length"in i))throw _.Error("E0025");var o=Array.prototype.slice.call(t,0);Array.prototype.forEach.call(i,function(t){o[0]=t,e(o,n)})}},A=function(e){return function(){E(arguments,e)}},O=function(){var e=!1;try{var t=Object.defineProperty({},"passive",{get:function(){return e=!0,!0}});u.addEventListener("test",null,t)}catch(e){}return e},P=y(O),R=function(e,t){var n=I.get(e);t=t||"";var i=t.split("."),a=i.slice(1),r=!!i[0];t=i[0]||b,n||(n={},I.set(e,n)),n[t]||(n[t]={handleObjects:[],nativeHandler:null});var l=n[t];return{addHandler:function(n,i,u){var c=function(i,o){var a,r,s=[i],l=i.currentTarget,c=i.relatedTarget;t in x&&(a=c&&l&&(c===l||l.contains(c))),void 0!==o&&s.push(o),T.callMethod(t,"handle",e,[i,u]),a||(r=n.apply(l,s)),r===!1&&(i.preventDefault(),i.stopPropagation())},d=function(t,n){if(!o||t.type!==o)if(t.data=u,t.delegateTarget=e,i)for(var a=t.target;a&&a!==e;)S(a,i)&&(t.currentTarget=a,c(t,n)),a=a.parentNode;else t.currentTarget=t.delegateTarget||t.target,c(t,n)},h={handler:n,wrappedHandler:d,selector:i,type:t,data:u,namespace:a.join("."),namespaces:a,guid:++D};l.handleObjects.push(h);var f,p=1===l.handleObjects.length,g=p&&r;g&&(g=!T.callMethod(t,"setup",e,[u,a,n])),g&&(l.nativeHandler=B(t),P()&&k.indexOf(t)>-1&&(f={passive:!1}),l.removeListener=s.listen(e,x[t]||t,l.nativeHandler,f)),T.callMethod(t,"add",e,[h])},removeHandler:function(i,o){var s=function(t){var r=n[t];if(!r.handleObjects.length)return void delete n[t];var s;r.handleObjects=r.handleObjects.filter(function(n){var r=a.length&&!M(n.namespaces,a)||i&&n.handler!==i||o&&n.selector!==o;return r||(s=n.handler,T.callMethod(t,"remove",e,[n])),r});var l=!r.handleObjects.length,u=l&&t!==b;u&&(T.callMethod(t,"teardown",e,[a,s]),r.nativeHandler&&r.removeListener(),delete n[t])};if(r)s(t);else for(var l in n)s(l);var u=0===Object.keys(n).length;u&&I.delete(e)},callHandlers:function(e,t){var i=!1,o=function(n){i||a.length&&!M(n.namespaces,a)||(n.wrappedHandler(e,t),i=e.isImmediatePropagationStopped())};l.handleObjects.forEach(o),a.length&&n[b]&&n[b].handleObjects.forEach(o)}}},B=function(e){return function(t,n){var i=R(this,e);t=W.Event(t),i.callHandlers(t,n)}},M=function(e,t){for(var n=0;n<t.length;n++)if(e.indexOf(t[n])<0)return!1;return!0},V=function(e){return function(t,n,i,o,a){a||(a=o,o=void 0),"string"!=typeof i&&(o=i,i=void 0),a||"string"!=typeof n||(a=o||i,i=void 0,o=void 0),e(t,n,i,o,a)}},F=function(e){return function(t,n,i,o){"function"==typeof i&&(o=i,i=void 0),e(t,n,i,o)}},L=function(e){return function(t,n,i){"string"==typeof n&&(n={type:n}),n.target||(n.target=t),n.currentTarget=t,n.delegateTarget||(n.delegateTarget=t),!n.type&&n.originalEvent&&(n.type=n.originalEvent.type),e(t,n instanceof W.Event?n:W.Event(n),i)}},H=function(e){return function(t,n){return this instanceof W.Event?(t||(t={}),"string"==typeof t&&(t={type:t}),n||(n={}),void e.call(this,t,n)):new W.Event(t,n)}},z=function(e){var t=function(t,n){if(n&&n.indexOf(" ")>-1){var i=Array.prototype.slice.call(arguments,0);n.split(" ").forEach(function(t){i[1]=t,e.apply(this,i)})}else e.apply(this,arguments)};return function(e,n){if("object"===i(n)){var o=Array.prototype.slice.call(arguments,0);for(var a in n)o[1]=a,o[o.length-1]=n[a],t.apply(this,o)}else t.apply(this,arguments)}},N=function(e,t){var n=w[e]||e,i=function(e,t){return"click"===e&&"a"===t.localName};i(e,t)||p(t[n])&&(o=e,t[n](),o=void 0)},$=function(e){var t=function(e){var t=/^(?:mouse|pointer|contextmenu|drag|drop)|click/;return!e.which&&void 0!==e.button&&t.test(e.type)},n=function(e){return null==e.which&&0===e.type.indexOf("key")};if(n(e))return null!=e.charCode?e.charCode:e.keyCode;if(t(e)){var i={1:1,2:3,3:1,4:2};return i[e.button]}return e.which},W=c({on:A(V(z(function(e,t,n,i,o){var a=R(e,t);a.addHandler(o,n,i)}))),one:A(V(function(e,t,n,i,o){var a=function i(){W.off(e,t,n,i),o.apply(this,arguments)};W.on(e,t,n,i,a)})),off:A(F(z(function(e,t,n,i){var o=R(e,t);o.removeHandler(i,n)}))),trigger:A(L(function(e,t,n){var i=t.type,o=R(e,t.type);T.callMethod(i,"trigger",e,[t,n]),o.callHandlers(t,n);var a=T.getField(i,"noBubble")||t.isPropagationStopped()||C.indexOf(i)!==-1;if(!a){var s=[],l=function e(t){var n=t.parentNode;n&&(s.push(n),e(n))};l(e),s.push(u);for(var c=0;s[c]&&!t.isPropagationStopped();){var d=R(s[c],t.type);d.callHandlers(r(t,{currentTarget:s[c]}),n),c++}}(e.nodeType||f(e))&&(T.callMethod(i,"_default",e,[t,n]),N(i,e))})),triggerHandler:A(L(function(e,t,n){var i=R(e,t.type);i.callHandlers(t,n)}))}),G=function(e){e&&(W.Event=e,W.Event.prototype=e.prototype)};G(H(function(e,t){var n=this,i=!1,o=!1,a=!1;r(n,e),(e instanceof W.Event||l.hasWindow()&&e instanceof u.Event)&&(n.originalEvent=e,n.currentTarget=void 0),e instanceof W.Event||r(n,{isPropagationStopped:function(){return!!(i||n.originalEvent&&n.originalEvent.propagationStopped)},stopPropagation:function(){i=!0,n.originalEvent&&n.originalEvent.stopPropagation()},isImmediatePropagationStopped:function(){return o},stopImmediatePropagation:function(){this.stopPropagation(),o=!0,n.originalEvent&&n.originalEvent.stopImmediatePropagation()},isDefaultPrevented:function(){return!!(a||n.originalEvent&&n.originalEvent.defaultPrevented)},preventDefault:function(){a=!0,n.originalEvent&&n.originalEvent.preventDefault()}}),j("which",$,n),0===e.type.indexOf("touch")&&(delete t.pageX,delete t.pageY),r(n,t),n.guid=++D}));var j=function(e,t,n){Object.defineProperty(n||W.Event.prototype,e,{enumerable:!0,configurable:!0,get:function(){return this.originalEvent&&t(this.originalEvent)},set:function(t){Object.defineProperty(this,e,{enumerable:!0,configurable:!0,writable:!0,value:t})}})};v(j);var q=h(),K=h();W.set=function(e){q.fire(),W.inject(e),G(e.Event),K.fire()},W.subscribeGlobal=function(){E(arguments,V(function(){var e=arguments;W.on.apply(this,e),q.add(function(){var t=Array.prototype.slice.call(e,0);t.splice(3,1),W.off.apply(this,t)}),K.add(function(){W.on.apply(this,e)})}))},W.forcePassiveFalseEventNames=k,W.passiveEventHandlersSupported=P,e.exports=W},function(e,t,n){var i=n(1),o=i.isPromise,a=i.isDeferred,r=n(0).extend,s=n(27),l=[{method:"resolve",handler:"done",state:"resolved"},{method:"reject",handler:"fail",state:"rejected"},{method:"notify",handler:"progress"}],u=function(){var e=this;this._state="pending",this._promise={},l.forEach(function(t){var n=t.method;this[n+"Callbacks"]=new s,this[n]=function(){return this[n+"With"](this._promise,arguments)}.bind(this),this._promise[t.handler]=function(t){if(!t)return this;var i=e[n+"Callbacks"];return i.fired()?t.apply(e[n+"Context"],e[n+"Args"]):i.add(function(e,n){t.apply(e,n)}.bind(this)),this}}.bind(this)),this._promise.always=function(e){return this.done(e).fail(e)},this._promise.catch=function(e){return this.then(null,e)},this._promise.then=function(e,t){var n=new u;return["done","fail"].forEach(function(r){var s="done"===r?e:t;this[r](function(){if(!s)return void n["done"===r?"resolve":"reject"].apply(this,arguments);var e=s&&s.apply(this,arguments);a(e)?e.done(n.resolve).fail(n.reject):o(e)?e.then(n.resolve,n.reject):n.resolve.apply(this,i.isDefined(e)?[e]:arguments)})}.bind(this)),n.promise()},this._promise.state=function(){return e._state},this._promise.promise=function(t){return t?r(t,e._promise):e._promise},this._promise.promise(this)};l.forEach(function(e){var t=e.method,n=e.state;u.prototype[t+"With"]=function(e,i){var o=this[t+"Callbacks"];return"pending"===this.state()&&(this[t+"Args"]=i,this[t+"Context"]=e,n&&(this._state=n),o.fire(e,i)),this}}),t.fromPromise=function(e,t){if(a(e))return e;if(o(e)){var n=new u;return e.then(function(){n.resolveWith.apply(n,[t].concat([[].slice.call(arguments)]))},function(){n.rejectWith.apply(n,[t].concat([[].slice.call(arguments)]))}),n}return(new u).resolveWith(t,[e])};var c=function(){if(1===arguments.length)return t.fromPromise(arguments[0]);for(var e=[].slice.call(arguments),n=[],i=0,o=new u,r=function(t){return function(a){n[t]=this,e[t]=arguments.length>1?[].slice.call(arguments):a,i++,i===e.length&&o.resolveWith(n,e)}},s=0;s<e.length;s++)a(e[s])?e[s].promise().done(r(s)).fail(o.reject):i++;return i===e.length&&o.resolveWith(n,e),o.promise()};t.setStrategy=function(e){u=e.Deferred,c=e.when},t.Deferred=function(){return new u},t.when=function(){return c.apply(this,arguments)}},function(e,t,n){var i=n(11),o="undefined"!=typeof window,a=o&&window;a||(a={},a.window=a),e.exports={hasWindow:function(){return o},getWindow:function(){return a},hasProperty:function(e){return this.hasWindow()&&e in a},defaultScreenFactorFunc:function(e){return e<768?"xs":e<992?"sm":e<1200?"md":"lg"},getCurrentScreenFactor:function(e){var t=e||this.defaultScreenFactorFunc,n=i.getDocumentElement().clientWidth;return t(n)},getNavigator:function(){return this.hasWindow()?a.navigator:{userAgent:""}}}},function(e,t,n){function i(e){return e&&e.__esModule?e:{"default":e}}var o=n(2),a=i(o),r=n(5),s=i(r),l=n(21),u=i(l),c=n(66),d=n(0),h=n(3),f={backspace:"backspace",tab:"tab",enter:"enter",escape:"escape",pageup:"pageUp",pagedown:"pageDown",end:"end",home:"home",arrowleft:"leftArrow",arrowup:"upArrow",arrowright:"rightArrow",arrowdown:"downArrow","delete":"del"," ":"space",f:"F",a:"A","*":"asterisk","-":"minus",alt:"alt",control:"control",shift:"shift",left:"leftArrow",up:"upArrow",right:"rightArrow",down:"downArrow",multiply:"asterisk",spacebar:"space",del:"del",subtract:"minus",esc:"escape"},p={8:"backspace",9:"tab",13:"enter",27:"escape",33:"pageUp",34:"pageDown",35:"end",36:"home",37:"leftArrow",38:"upArrow",39:"rightArrow",40:"downArrow",46:"del",32:"space",70:"F",65:"A",106:"asterisk",109:"minus",189:"minus",173:"minus",16:"shift",17:"control",18:"alt"},g=function(){var e={dx:/^dx/i,mouse:/(mouse|wheel)/i,touch:/^touch/i,keyboard:/^key/i,pointer:/^(ms)?pointer/i};return function(t){var n="other";return(0,h.each)(e,function(e){if(this.test(t.type))return n=e,!1}),n}}(),_=function(e){return"dx"===g(e)},m=function(e){return"mouse"===g(e)},v=function(e){return"touch"===g(e)},y=function(e){return"pointer"===g(e)},b=function(e){return m(e)||(y(e)||_(e))&&"mouse"===e.pointerType},x=function(e){return e&&"dxmousewheel"===e.type},w=function(e){return v(e)||(y(e)||_(e))&&"touch"===e.pointerType},C=function(e){return"keyboard"===g(e)},k=function(e){return 0===e.screenX&&!e.offsetX&&0===e.pageX},S=function(e){return{x:e.pageX,y:e.pageY,time:e.timeStamp}},I=function(e,t){return{x:t.x-e.x,y:t.y-e.y,time:t.time-e.time||1}},D=function(e){return v(e)?(e.originalEvent.touches||[]).length:_(e)?(e.pointers||[]).length:0},T=function(e){var t=e.target,n=(0,a.default)(t),i=n.is("input, textarea, select");if(n.is(".dx-skip-gesture-event *, .dx-skip-gesture-event"))return!0;if(x(e)){var o=n.is("textarea")&&n.hasClass("dx-texteditor-input");if(o)return!1;var r=t.isContentEditable||t.hasAttribute("contenteditable");if(r)return!1;var s=n.is("input[type='number'], textarea, select")&&n.is(":focus");return s}return b(e)?i||e.which>1:w(e)?i&&(0,c.focused)(n):void 0},E=function(e){return e},A=function(e){E=e},O=function(e){return E(s.default.Event(e,e),e)},P=function(e,t){var n=O(e);return t&&(0,d.extend)(n,t),n},R=function(e){var t=P(e.originalEvent,e);return s.default.trigger(e.delegateTarget||t.target,t),t},B=function e(t,n){if(!n)throw u.default.Error("E0017");return"string"==typeof t?t.indexOf(" ")===-1?t+"."+n:e(t.split(/\s+/g),n):((0,h.each)(t,function(e,i){t[e]=i+"."+n}),t.join(" "))},M=function(e){var t=!!e.key,n=t?e.key:e.which;if(n)return n=t?f[n.toLowerCase()]||n:p[n]||String.fromCharCode(n)},V=function(e){return e.key||String.fromCharCode(e.which)};e.exports={eventSource:g,isPointerEvent:y,isMouseEvent:b,isDxMouseWheelEvent:x,isTouchEvent:w,isKeyboardEvent:C,isFakeClickEvent:k,hasTouches:D,eventData:S,eventDelta:I,needSkipEvent:T,createEvent:P,fireEvent:R,addNamespace:B,setEventFixMethod:A,normalizeKeyName:M,getChar:V}},function(e,t,n){var i=n(2),o=n(154),a=n(21),r=n(131),s=function(e,t,n){n?t[e]=n:n=t,r.name(n,e),o.fire(e,n)},l=function(e,t){i.fn[e]=function(n){var i,o="string"==typeof n;if(o){var r=n,s=[].slice.call(arguments).slice(1);this.each(function(){var n=t.getInstance(this);if(!n)throw a.Error("E0009",e);var o=n[r],l=o.apply(n,s);void 0===i&&(i=l)})}else this.each(function(){var e=t.getInstance(this);e?e.option(n):new t(this,n)}),i=this;return i}};o.add(l),e.exports=s},function(e,t,n){function i(e){return e&&e.__esModule?e:{"default":e}}var o=n(2),a=i(o),r=n(55),s=i(r),l=n(0),u=n(3),c=n(43),d=n(33),h=n(77),f=i(h),p=n(463),g=i(p),_=(0,l.extend)(!0,{},g.default),m=function(e,t){return e[t]||{}},v={},y=(0,s.default)({engine:function(){return"base"},_dictionary:_,load:function(e){(0,l.extend)(!0,this._dictionary,e)},_localizablePrefix:"@",setup:function(e){this._localizablePrefix=e},localizeString:function(e){var t=this,n=new RegExp("(^|[^a-zA-Z_0-9"+t._localizablePrefix+"-]+)("+t._localizablePrefix+"{1,2})([a-zA-Z_0-9-]+)","g"),i=t._localizablePrefix+t._localizablePrefix;return e.replace(n,function(e,n,o,a){var r,s=t._localizablePrefix+a;return o!==i&&(r=t.format(a)),r||(v[a]=(0,d.humanize)(a)),n+(r||s)})},localizeNode:function(e){var t=this;(0,a.default)(e).each(function(e,n){n.nodeType&&(3===n.nodeType?n.nodeValue=t.localizeString(n.nodeValue):(0,a.default)(n).is("iframe")||((0,u.each)(n.attributes||[],function(e,n){if("string"==typeof n.value){var i=t.localizeString(n.value);n.value!==i&&(n.value=i)}}),(0,a.default)(n).contents().each(function(e,n){t.localizeNode(n)})))})},getMessagesByLocales:function(){return this._dictionary},getDictionary:function(e){return e?v:(0,l.extend)({},v,this.getMessagesByLocales()[f.default.locale()])},getFormatter:function(e){return this._getFormatterBase(e)||this._getFormatterBase(e,"en")},_getFormatterBase:function(e,t){var n=this,i=f.default.getValueByClosestLocale(function(t){return m(n._dictionary,t)[e]});if(i)return function(){var e=1===arguments.length&&Array.isArray(arguments[0])?arguments[0].slice(0):Array.prototype.slice.call(arguments,0);return e.unshift(i),c.format.apply(this,e)}},format:function(e){var t=this.getFormatter(e),n=Array.prototype.slice.call(arguments,1);return t&&t.apply(this,n)||""}});e.exports=y},function(e,t,n){function i(e){return e&&e.__esModule?e:{"default":e}}function o(e){"@babel/helpers - typeof";return(o="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}var a=n(55),r=i(a),s=n(4),l=1,u=3,c=9,d={querySelectorAll:function(e,t){return e.querySelectorAll(t)},elementMatches:function(e,t){var n=this,i=e.matches||e.matchesSelector||e.mozMatchesSelector||e.msMatchesSelector||e.oMatchesSelector||e.webkitMatchesSelector||function(t){var i=e.document||e.ownerDocument;if(!i)return!1;for(var o=n.querySelectorAll(i,t),a=0;a<o.length;a++)if(o[a]===e)return!0};return i.call(e,t)},createElement:function(e,t){return t=t||this._document,t.createElement(e)},createElementNS:function(e,t,n){return n=n||this._document,n.createElementNS(e,t)},createTextNode:function(e,t){return t=t||this._document,t.createTextNode(e)},isNode:function(e){return"object"===o(e)&&"nodeType"in e},isElementNode:function(e){return e&&e.nodeType===l},isTextNode:function(e){return e&&e.nodeType===u},isDocument:function(e){return e&&e.nodeType===c},removeElement:function(e){var t=e&&e.parentNode;t&&t.removeChild(e)},insertElement:function(e,t,n){e&&t&&e!==t&&(n?e.insertBefore(t,n):e.appendChild(t))},getAttribute:function(e,t){return e.getAttribute(t)},setAttribute:function(e,t,n){e.setAttribute(t,n)},removeAttribute:function(e,t){e.removeAttribute(t)},setProperty:function(e,t,n){e[t]=n},setText:function(e,t){e&&(e.textContent=t)},setClass:function(e,t,n){if(1===e.nodeType&&t)if(e.classList)n?e.classList.add(t):e.classList.remove(t);else{var i,o="string"==typeof e.className,a=o?e.className:this.getAttribute(e,"class")||"",r=a.split(" "),s=r.indexOf(t);n&&s<0&&(i=a?a+" "+t:t),!n&&s>=0&&(r.splice(s,1),i=r.join(" ")),void 0!==i&&(o?e.className=i:this.setAttribute(e,"class",i))}},setStyle:function(e,t,n){e.style[t]=n||""},_document:"undefined"==typeof document?void 0:document,getDocument:function(){return this._document},getActiveElement:function(){return this._document.activeElement},getBody:function(){return this._document.body},createDocumentFragment:function(){return this._document.createDocumentFragment()},getDocumentElement:function(){return this._document.documentElement},getLocation:function(){return this._document.location},getSelection:function(){return this._document.selection},getReadyState:function(){return this._document.readyState},getHead:function(){return this._document.head},hasDocumentProperty:function(e){return e in this._document},listen:function(e,t,n,i){return e&&"addEventListener"in e?(e.addEventListener(t,n,i),function(){e.removeEventListener(t,n)}):s.noop}};e.exports=(0,r.default)(d)},function(e,t,n){var i,o=n(2),a=n(28),r=n(11),s=n(7),l=s.getWindow(),u=n(5),c=n(14).inArray,d=n(1),h=d.isDefined,f=d.isRenderer,p=n(218),g=function(){var e=r.getActiveElement(),t=r.getBody();if(e&&e!==t&&e.blur)try{e.blur()}catch(e){t.blur()}},_=function(){var e=l.getSelection();if(e&&"Caret"!==e.type)if(e.empty)e.empty();else if(e.removeAllRanges)try{e.removeAllRanges()}catch(e){}},m=function(e,t){var n=o(e),i=o(t);if(n[0]===i[0])return n[0];for(var a=n.parents(),r=i.parents(),s=Math.min(a.length,r.length),l=-s;l<0;l++)if(a.get(l)===r.get(l))return a.get(l)},v=function(e){var t=".dx-visibility-change-handler";return function(n){for(var i=o(n||"body"),a=i.filter(t).add(i.find(t)),r=0;r<a.length;r++)u.triggerHandler(a[r],e)}},y=function(){var e=0;return function(t){return(t||"")+e++}}(),b="data-options",x=function(e){var t=o(e).attr(b)||"";return a().optionsParser(t)},w=function(e,t){var n=[],i="["+b+"]",a=e.find(i).add(e.filter(i));return a.each(function(e,i){var a=o(i),r=x(i);for(var s in r)(!t||c(s,t)>-1)&&a[s]&&(a[s](r[s]),n.push(a[s]("instance")))}),n},C=function(e){if(!l.WinJS)return o(p.parseHTML(e));var t=o("<div>");return l.WinJS.Utilities.setInnerHTMLUnsafe(t.get(0),e),t.contents()},k=function(e){e=o(e);var t=e.length&&e.filter(function(){var e=o(this);return e.is("script[type]")&&e.attr("type").indexOf("script")<0});return t.length?t.eq(0).html():(e=o("<div>").append(e),e.html())},S=function e(t){var n=h(t)&&(t.nodeType||f(t))?o(t):o("<div>").html(t).contents();return 1===n.length&&(n.is("script")?n=e(n.html().trim()):n.is("table")&&(n=n.children("tbody").contents())),n},I=function(e,t){var n=e.originalEvent&&e.originalEvent.clipboardData||l.clipboardData;return 1===arguments.length?n&&n.getData("Text"):void(n&&n.setData("Text",t))},D=function(e,t){return!!t&&(t=r.isTextNode(t)?t.parentNode:t,r.isDocument(e)?e.documentElement.contains(t):e.contains(t))},T=function(e){return i(e)},E=function(e){i=e};E(function(e){return e&&e.get(0)});var A=function(e,t,n){var i=l.getComputedStyle(o(e).get(0)),a=n&&n.includePaddings;return o("<div>").text(t).css({fontStyle:i.fontStyle,fontVariant:i.fontVariant,fontWeight:i.fontWeight,fontSize:i.fontSize,fontFamily:i.fontFamily,letterSpacing:i.letterSpacing,border:i.border,paddingTop:a?i.paddingTop:"",paddingRight:a?i.paddingRight:"",paddingBottom:a?i.paddingBottom:"",paddingLeft:a?i.paddingLeft:"",visibility:"hidden",whiteSpace:"nowrap",position:"absolute","float":"left"})};t.setPublicElementWrapper=E,t.resetActiveElement=g,t.createMarkupFromString=C,t.triggerShownEvent=v("dxshown"),t.triggerHidingEvent=v("dxhiding"),t.triggerResizeEvent=v("dxresize"),t.getElementOptions=x,t.createComponents=w,t.extractTemplateMarkup=k,t.normalizeTemplateElement=S,t.clearSelection=_,t.uniqueId=y,t.closestCommonParent=m,t.clipboardText=I,t.contains=D,t.getPublicElement=T,t.createTextElementHiddenCopy=A},function(e,t,n){function i(e,t){for(var n,i=0,o=e.length,a=[];i<o;)n=t(e[i],i),null!==n&&a.push(n),i++;return a}function o(e,t){return i(t,function(t){return e[t]?e[t]:null})}function a(e,t,n,i){var o=i;return C(t,function(t,i){e[i]&&(e[i]-=n,o-=n)}),o}function r(e){return String(e).toLowerCase()}function s(e){return e&&(e.originalTop=e.top,e.originalBottom=e.bottom,e.originalLeft=e.left,e.originalRight=e.right),e}function l(e){return-M<e&&e<+M?e:0}function u(e){var t=l($(e.x)),n=l($(e.y)),i=l(W(e.width+e.x)),o=l(W(e.height+e.y)),a={x:t,y:n,width:i-t,height:o-n};return a.isEmpty=!(a.x||a.y||a.width||a.height),a}function c(e,t,n){var i=q(L(n*V).toFixed(3)),o=q(H(n*V).toFixed(3)),a=e.width/2,r=e.height/2,s=e.x+a,l=e.y+r,c=z(a*i)+z(r*o),d=z(a*o)+z(r*i),h=t[0]+(s-t[0])*i+(l-t[1])*o,f=t[1]-(s-t[0])*o+(l-t[1])*i;return u({x:h-c,y:f-d,width:2*c,height:2*d})}function d(e){return Array.isArray(e)?{startValue:e[0],endValue:e[1]}:e||{}}function h(e,t){return t?e:[e.startValue,e.endValue]}function f(e,t){return"datetime"===e.dataType?function(e,t){var n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:1;return new Date(e.getTime()+n*t)}:"logarithmic"===e.axisType?function(t,n){var i=arguments.length>2&&void 0!==arguments[2]?arguments[2]:1,o=g(t,e.base)+i*n;return _(o,e.base)}:function(e,n){var i=arguments.length>2&&void 0!==arguments[2]?arguments[2]:1,o=e+i*n;return t&&o*e<=0?0:o}}function p(e,n,i,o){var a=x.isDefined(n.startValue),r=x.isDefined(n.endValue),s="discrete"!==e.axisType;o=o||i;var l=f(e,!1),u=a?n.startValue:o.min,c=r?n.endValue:o.max,d=n.length,h=o.categories;if(s&&!x.isDefined(u)&&!x.isDefined(c))return{startValue:u,endValue:c};if(T(d))if(s)"datetime"!==e.dataType||E(d)||(d=S(d)),r&&!a||!r&&!a?(T(i.max)&&(c=c>i.max?i.max:c),u=l(c,d,-1)):a&&!r&&(T(i.min)&&(u=u<i.min?i.min:u),c=l(u,d));else if(d=parseInt(d),!isNaN(d)&&isFinite(d))if(d--,r||a){if(a&&!r){var p=t.getCategoriesInfo(h,u,void 0);c=p.categories[d]}else if(!a&&r){var g=t.getCategoriesInfo(h,void 0,c);u=g.categories[g.categories.length-1-d]}}else c=h[h.length-1],u=h[h.length-1-d];return s&&(T(i.max)&&c>i.max&&(c=i.max),T(i.min)&&u<i.min&&(u=i.min)),{startValue:u,endValue:c}}function g(e,t){var n=arguments.length>2&&void 0!==arguments[2]&&arguments[2],i=arguments.length>3?arguments[3]:void 0;if(!n)return Z(e,t);if(0===e)return 0;var o=Z(Math.abs(e),t)-(i-1);return o<0?0:U(Y(e)*o,Number(Math.pow(t,i-1).toFixed(Math.abs(i))))}function _(e,t){var n=arguments.length>2&&void 0!==arguments[2]&&arguments[2],i=arguments.length>3?arguments[3]:void 0;if(!n)return J(e,t);if(0===e)return 0;var o=J(Math.abs(e)+(i-1),t);return o<0?0:U(Y(e)*o,Number(Math.pow(t,i).toFixed(Math.abs(i))))}function m(e,t){return Array.isArray(t)?e.length===t.length&&e.every(function(e,n){return v(e)===v(t[n])}):v(e.startValue)===v(t.startValue)&&v(e.endValue)===v(t.endValue)}function v(e){return e&&e.valueOf()}function y(e,t,n){return t>=e.left&&t<=e.right&&n>=e.top&&n<=e.bottom}var b=n(4).noop,x=n(1),w=n(0).extend,C=n(3).each,k=n(31),S=n(25).dateToMilliseconds,I=n(11),D=n(87),T=x.isDefined,E=x.isNumeric,A=x.isExponential,O=Math,P=O.round,R=Math.sqrt,B=Math.PI,M=1e10,V=B/180,F=Math.LN10,L=Math.cos,H=Math.sin,z=Math.abs,N=Math.log,$=Math.floor,W=Math.ceil,G=Math.max,j=isNaN,q=Number,K=NaN,U=k.adjust,Y=k.sign,X=10,Z=function(e,t){return e?Math.log(e)/Math.log(t):K},Q=function(e){return U(Z(e,10))},J=function(e,t){return Math.pow(t,e)},ee=function(e){return(e%360+360)%360},te=function(e){return 90-e},ne=function(e){return B*e/180},ie=function(e){var t=ne(e);return{cos:L(t),sin:H(t)}},oe=1e-14,ae=function(e,t,n,i){var o=n-e,a=i-t;return Math.sqrt(a*a+o*o)},re=function(e){var t,n=z(e);return j(n)?K:n>0?(n=N(n)/F,t=W(n),t-n<oe?t:$(n)):0},se=function(e,t,n){var i,o=G(re(e),re(t)),a=-re(z(t-e)/n);return j(o)||j(a)?null:(z(o)<=4?(i="fixedPoint",a<0&&(a=0),a>4&&(a=4)):(i="exponential",a+=o-1,a>3&&(a=3)),{type:i,precision:a})},le=function(e,t){if(t>20&&(t=20),E(e))return q(A(e)?e.toExponential(t):e.toFixed(t))},ue=function(e){return e.toExponential().split("e")[1]};w(t,{decreaseGaps:function(e,t,n){var i;do i=o(e,t),i.push(O.ceil(n/i.length)),n=a(e,t,O.min.apply(null,i),n);while(n>0&&i.length>1);return n},normalizeEnum:r,parseScalar:function(e,t){return void 0!==e?e:t},enumParser:function(e){var t,n,i={};for(t=0,n=e.length;t<n;++t)i[r(e[t])]=1;return function(e,t){var n=r(e);return i[n]?n:t}},patchFontOptions:function(e){
var t={};return C(e||{},function(n,i){if(/^(cursor)$/i.test(n));else if("opacity"===n)i=null;else if("color"===n){if(n="fill","opacity"in e){var o=new D(i);i="rgba(".concat(o.r,",").concat(o.g,",").concat(o.b,",").concat(e.opacity,")")}}else n="font-"+n;t[n]=i}),t},checkElementHasPropertyFromStyleSheet:function(e,t){var n=Array.prototype.slice,i=n.call(I.getDocument().styleSheets).reduce(function(e,t){return e.concat(n.call(t.cssRules||t.rules))},[]),o=i.filter(function(t){try{return I.elementMatches(e,t.selectorText)}catch(e){return!1}});return o.some(function(e){return!!e.style[t]})},convertPolarToXY:function(e,t,n,i){var o=90,a=i>0?i:0;n=T(n)?n+t-o:0;var r=ie(n);return{x:P(e.x+a*r.cos),y:P(e.y+a*r.sin)}},convertXYToPolar:function(e,t,n){var i=ae(e.x,e.y,t,n),o=O.atan2(n-e.y,t-e.x);return{phi:P(ee(180*o/O.PI)),r:P(i)}},processSeriesTemplate:function(e,t){var n,o,a,r=x.isFunction(e.customizeSeries)?e.customizeSeries:b,s=e.nameField,l={},u=[],c=0;for(t=t||[],o=t.length;c<o;c++)a=t[c],s in a&&(n=l[a[s]],n||(n=l[a[s]]={name:a[s],nameFieldValue:a[s]},u.push(n.name)));return i(u,function(e){var t=l[e];return w(t,r.call(null,t.name))})},getCategoriesInfo:function(e,t,n){if(0===e.length)return{categories:[]};t=T(t)?t:e[0],n=T(n)?n:e[e.length-1];var o,a=i(e,function(e){return T(e)?e.valueOf():null}),r=a.indexOf(t.valueOf()),s=a.indexOf(n.valueOf()),l=!1;r<0&&(r=0),s<0&&(s=e.length-1),s<r&&(o=s,s=r,r=o,l=!0);var u=e.slice(r,s+1),c=u.length-1;return{categories:u,start:u[l?c:0],end:u[l?0:c],inverted:l}},setCanvasValues:s,normalizePanesHeight:function(e){e.forEach(function(e){var t=e.height,n=0,i=parseFloat(t)||void 0;(x.isString(t)&&t.indexOf("px")>-1||x.isNumeric(t)&&t>1)&&(i=P(i),n=1),!n&&i&&(x.isString(t)&&t.indexOf("%")>-1?i/=100:i<0&&(i=i<-1?1:O.abs(i))),e.height=i,e.unit=n});var t=e.filter(function(e){return!e.unit}).reduce(function(e,t){return e+(t.height||0)},0),n=e.filter(function(e){return!e.unit}).length,i=e.filter(function(e){return!e.unit&&!e.height}).length;if(t<1&&i)e.filter(function(e){return!e.unit&&!e.height}).forEach(function(e){return e.height=(1-t)/i});else if(t>1||t<1&&!i||1===t&&i){if(i){var o=t/n,a=i*o;e.filter(function(e){return!e.unit&&e.height}).forEach(function(e){return e.height*=(t-a)/t}),e.filter(function(e){return!e.unit&&!e.height}).forEach(function(e){return e.height=o})}e.forEach(function(e){return!e.unit&&(e.height*=1/t)})}},updatePanesCanvases:function(e,t,n){var i=0,o=X,a=n?t.width-t.left-t.right:t.height-t.top-t.bottom,r=a-o*(e.length-1),l=n?"left":"top",u=n?"right":"bottom",c=e.reduce(function(e,t){return e+(t.unit?t.height:0)},0);r-=c,e.forEach(function(e){var n=e.unit?e.height:P(e.height*r);e.canvas=e.canvas||{},w(e.canvas,t),e.canvas[l]=t[l]+i,e.canvas[u]=t[u]+(a-n-i),i=i+n+o,s(e.canvas)})},unique:function(e){var t={};return i(e,function(e){var n=t[e]?null:e;return t[e]=!0,n})},map:i,getVerticallyShiftedAngularCoords:function(e,t,n){var i=e.x+e.width/2>=n.x,o=(i?e.x:e.x+e.width)-n.x,a=e.y-n.y,r=a+t,s=P(R(o*o+a*a-r*r)),l=(i?+s:-s)||o;return{x:n.x+(i?l:l-e.width),y:e.y+t}},mergeMarginOptions:function(e,t){return{checkInterval:e.checkInterval||t.checkInterval,size:Math.max(e.size||0,t.size||0),percentStick:e.percentStick||t.percentStick,sizePointNormalState:Math.max(e.sizePointNormalState||0,t.sizePointNormalState||0)}}}),t.getVizRangeObject=d,t.convertVisualRangeObject=h,t.adjustVisualRange=p,t.getAddFunction=f,t.getLog=Z,t.getLogExt=g,t.getAdjustedLog10=Q,t.raiseTo=J,t.raiseToExt=_,t.normalizeAngle=ee,t.convertAngleToRendererSpace=te,t.degreesToRadians=ne,t.getCosAndSin=ie,t.getDecimalOrder=re,t.getAppropriateFormat=se,t.getDistance=ae,t.roundValue=le,t.getPower=ue,t.valueOf=v,t.rotateBBox=c,t.normalizeBBox=u,t.PANE_PADDING=X,t.rangesAreEqual=m,t.pointInCanvas=y},function(e,t,n){var i=n(1).isDefined,o=n(3).each,a=n(48),r=n(28),s=function(e){return Array.isArray(e)&&!e.length},l=function(e){return Array.isArray(e)?e:[e]},u=function(e,t){if(!Array.isArray(e)||0===e.length||!Array.isArray(t)||0===t.length)return[];var n=[];return o(e,function(e,i){var o=h(i,t);o!==-1&&n.push(i)}),n},c=function(e,t){if(!Array.isArray(e)||0===e.length)return[];if(!Array.isArray(t)||0===t.length)return e.slice();var n=[];return o(e,function(e,i){var o=h(i,t);o===-1&&n.push(i)}),n},d=function(e,t,n,s){var l={},u=0,c=r().useLegacyVisibleIndex;return o(e,function(e,i){e=i[t],e>=0?(l[e]=l[e]||[],i===n?l[e].unshift(i):l[e].push(i)):i[t]=void 0}),c||o(e,function(){if(!i(this[t])&&(!s||s(this))){for(;l[u];)u++;l[u]=[this],u++}}),u=0,a.orderEach(l,function(e,n){o(n,function(){e>=0&&(this[t]=u++)})}),c&&o(e,function(){i(this[t])||s&&!s(this)||(this[t]=u++)}),u},h=function(e,t){if(!t)return-1;var n=Array.isArray(t)?t:t.toArray();return n.indexOf(e)},f=function(e,t){for(var n=0;n<t.length;n++)e[e.length]=t[n];return e},p=function(e,t){for(var n=0;n<e.length;n++)if(t(e[n]))return e[n]};t.isEmpty=s,t.wrapToArray=l,t.intersection=u,t.removeDuplicates=c,t.normalizeIndexes=d,t.inArray=h,t.merge=f,t.find=p},function(e,t,n){var i=n(21),o=n(1),a=function(e,t,n){return function(){var i=this.callBase;this.callBase=e[t];try{return n.apply(this,arguments)}finally{this.callBase=i}}},r=function(e){var t=function(){};return t.prototype=e.prototype,new t},s=function(e){var t,n,i,o=this;if(!e)return o;for(n in e)i=e[n],t="function"==typeof o.prototype[n]&&"function"==typeof i,o.prototype[n]=t?a(o.parent.prototype,n,i):i;return o},l=function(){var e,t,n,i=this,o=Object.prototype.hasOwnProperty.bind(i),a=!o("_includedCtors")&&!o("_includedPostCtors");for(a&&(i._includedCtors=i._includedCtors.slice(0),i._includedPostCtors=i._includedPostCtors.slice(0)),n=0;n<arguments.length;n++){e=arguments[n],e.ctor&&i._includedCtors.push(e.ctor),e.postCtor&&i._includedPostCtors.push(e.postCtor);for(t in e)"ctor"!==t&&"postCtor"!==t&&(i.prototype[t]=e[t])}return i},u=function(e){var t=Object.prototype.hasOwnProperty.bind(this)("parent"),n=!t&&this.parent;if(n){var i=Object.getPrototypeOf(this);return i===e||i.subclassOf(e)}return this.parent===e||!(!this.parent||!this.parent.subclassOf)&&this.parent.subclassOf(e)},c=function(){throw i.Error("E0001")},d=function(){var e=Object.prototype.hasOwnProperty;return function(t,n){for(var i in t){if(!e.call(t,i))return;n[i]=t[i]}}}(),h=function(){};h.inherit=function(e){var t=function(){if(!this||o.isWindow(this)||"function"!=typeof this.constructor)throw i.Error("E0003");var e,t=this,n=t.ctor,a=t.constructor._includedCtors,r=t.constructor._includedPostCtors;for(e=0;e<a.length;e++)a[e].call(t);for(n&&n.apply(t,arguments),e=0;e<r.length;e++)r[e].call(t)};return t.prototype=r(this),d(this,t),t.inherit=this.inherit,t.abstract=c,t.redefine=s,t.include=l,t.subclassOf=u,t.parent=this,t._includedCtors=this._includedCtors?this._includedCtors.slice(0):[],t._includedPostCtors=this._includedPostCtors?this._includedPostCtors.slice(0):[],t.prototype.constructor=t,t.redefine(e),t},h.abstract=c,e.exports=h},function(e,t,n){var i=n(2),o=n(7),a=o.getNavigator(),r=o.getWindow(),s=n(0).extend,l=n(1).isPlainObject,u=n(3).each,c=n(15),d=n(21),h=n(27),f=n(130),p=n(83),g=n(291).sessionStorage,_=n(74),m=n(28),v={iPhone:"iPhone",iPhone5:"iPhone",iPhone6:"iPhone",iPhone6plus:"iPhone",iPad:"iPad",iPadMini:"iPad Mini",androidPhone:"Android Mobile",androidTablet:"Android",msSurface:"Windows ARM Tablet PC",desktop:"desktop"},y={deviceType:"desktop",platform:"generic",version:[],phone:!1,tablet:!1,android:!1,ios:!1,generic:!0,grade:"A",mac:!1},b={generic:function(e){var t=/windows phone/i.test(e)||e.match(/WPDesktop/),n=!t&&/Windows(.*)arm(.*)Tablet PC/i.test(e),i=!t&&!n&&/msapphost/i.test(e),o=/((intel|ppc) mac os x)/.test(e.toLowerCase());if(t||n||i||o)return{deviceType:t?"phone":n?"tablet":"desktop",platform:"generic",version:[],grade:"A",mac:o}},ios:function(e){if(/ip(hone|od|ad)/i.test(e)){var t=/ip(hone|od)/i.test(e),n=e.match(/os (\d+)_(\d+)_?(\d+)?/i),i=n?[parseInt(n[1],10),parseInt(n[2],10),parseInt(n[3]||0,10)]:[],o=480===r.screen.height,a=o?"B":"A";return{deviceType:t?"phone":"tablet",platform:"ios",version:i,grade:a}}},android:function(e){if(/android|htc_|silk/i.test(e)){var t=/mobile/i.test(e),n=e.match(/android (\d+)\.?(\d+)?\.?(\d+)?/i),i=n?[parseInt(n[1],10),parseInt(n[2]||0,10),parseInt(n[3]||0,10)]:[],o=i.length>1&&(i[0]<4||4===i[0]&&i[1]<4),a=o?"B":"A";return{deviceType:t?"phone":"tablet",platform:"android",version:i,grade:a}}}},x=c.inherit({ctor:function(e){this._window=e&&e.window||r,this._realDevice=this._getDevice(),this._currentDevice=void 0,this._currentOrientation=void 0,this.changed=h(),o.hasWindow()&&(this._recalculateOrientation(),f.add(this._recalculateOrientation.bind(this)))},current:function(e){if(e)return this._currentDevice=this._getDevice(e),this._forced=!0,void this.changed.fire();if(!this._currentDevice){e=void 0;try{e=this._getDeviceOrNameFromWindowScope()}catch(t){e=this._getDeviceNameFromSessionStorage()}finally{e||(e=this._getDeviceNameFromSessionStorage()),e&&(this._forced=!0)}this._currentDevice=this._getDevice(e)}return this._currentDevice},real:function(){return s({},this._realDevice)},orientation:function(){return this._currentOrientation},isForced:function(){return this._forced},isRippleEmulator:function(){return!!this._window.tinyHippos},_getCssClasses:function(e){var t=[],n=this._realDevice;return e=e||this.current(),e.deviceType&&(t.push("dx-device-"+e.deviceType),"desktop"!==e.deviceType&&t.push("dx-device-mobile")),t.push("dx-device-"+n.platform),n.version&&n.version.length&&t.push("dx-device-"+n.platform+"-"+n.version[0]),w.isSimulator()&&t.push("dx-simulator"),m().rtlEnabled&&t.push("dx-rtl"),t},attachCssClasses:function(e,t){this._deviceClasses=this._getCssClasses(t).join(" "),i(e).addClass(this._deviceClasses)},detachCssClasses:function(e){i(e).removeClass(this._deviceClasses)},isSimulator:function(){try{return this._isSimulator||o.hasWindow()&&this._window.top!==this._window.self&&this._window.top["dx-force-device"]||this.isRippleEmulator()}catch(e){return!1}},forceSimulator:function(){this._isSimulator=!0},_getDevice:function(e){if("genericPhone"===e&&(e={deviceType:"phone",platform:"generic",generic:!0}),l(e))return this._fromConfig(e);var t;if(e){if(t=v[e],!t)throw d.Error("E0005")}else t=a.userAgent;return this._fromUA(t)},_getDeviceOrNameFromWindowScope:function(){var e;return o.hasWindow()&&(this._window.top["dx-force-device-object"]||this._window.top["dx-force-device"])&&(e=this._window.top["dx-force-device-object"]||this._window.top["dx-force-device"]),e},_getDeviceNameFromSessionStorage:function(){var e=g();if(e){var t=e.getItem("dx-force-device");try{return JSON.parse(t)}catch(e){return t}}},_fromConfig:function(e){var t=s({},y,this._currentDevice,e),n={phone:"phone"===t.deviceType,tablet:"tablet"===t.deviceType,android:"android"===t.platform,ios:"ios"===t.platform,generic:"generic"===t.platform};return s(t,n)},_fromUA:function(e){var t;return u(b,function(n,i){return t=i(e),!t}),t?this._fromConfig(t):y},_changeOrientation:function(){var e=i(this._window),t=e.height()>e.width()?"portrait":"landscape";this._currentOrientation!==t&&(this._currentOrientation=t,this.fireEvent("orientationChanged",[{orientation:t}]))},_recalculateOrientation:function(){var e=i(this._window).width();this._currentWidth!==e&&(this._currentWidth=e,this._changeOrientation())}}).include(p),w=new x;_.changeCallback.add(function(e,t){w.detachCssClasses(t),w.attachCssClasses(e)}),e.exports=w},function(e,t,n){var i=n(2),o=n(5),a=n(110),r=n(0).extend,s=n(14).inArray,l=n(3).each,u=n(4),c=n(1),d=n(11),h=n(162),f=n(163),p=n(66),g=n(8),_=n(140),m=n(133),v=n(19),y="UIFeedback",b="dx-widget",x="dx-state-active",w="dx-state-disabled",C="dx-state-invisible",k="dx-state-hover",S="dx-state-focused",I=30,D=400,T="Focus",E=h.inherit({_supportedKeys:function(){return{}},_getDefaultOptions:function(){return r(this.callBase(),{disabled:!1,visible:!0,hint:void 0,activeStateEnabled:!1,onContentReady:null,hoverStateEnabled:!1,focusStateEnabled:!1,tabIndex:0,accessKey:null,onFocusIn:null,onFocusOut:null,_keyboardProcessor:void 0,ignoreParentReadOnly:!1})},_feedbackShowTimeout:I,_feedbackHideTimeout:D,_init:function(){this.callBase(),this._initContentReadyAction()},_clearInnerOptionCache:function(e){this[e+"Cache"]={}},_cacheInnerOptions:function(e,t){var n=e+"Cache";this[n]=r(this[n],t)},_getOptionsFromContainer:function(e){var t=e.name,n=e.fullName,i=e.value,o={};if(t===n)o=i;else{var a=n.split(".").pop();o[a]=i}return o},_innerOptionChanged:function(e,t){var n=this._getOptionsFromContainer(t);e&&e.option(n),this._cacheInnerOptions(t.name,n)},_getInnerOptionsCache:function(e){return this[e+"Cache"]},_initInnerOptionCache:function(e){this._clearInnerOptionCache(e),this._cacheInnerOptions(e,this.option(e))},_bindInnerWidgetOptions:function(e,t){this._options[t]=r({},e.option()),e.on("optionChanged",function(e){this._options[t]=r({},e.component.option())}.bind(this))},_getAriaTarget:function(){return this._focusTarget()},_initContentReadyAction:function(){this._contentReadyAction=this._createActionByOption("onContentReady",{excludeValidators:["disabled","readOnly"]})},_initMarkup:function(){this.$element().addClass(b),this._toggleDisabledState(this.option("disabled")),this._toggleVisibility(this.option("visible")),this._renderHint(),this._isFocusable()&&this._renderFocusTarget(),this.callBase()},_render:function(){this.callBase(),this._renderContent(),this._renderFocusState(),this._attachFeedbackEvents(),this._attachHoverEvents(),this._toggleIndependentState()},_renderHint:function(){var e=this.option("hint");this.$element().attr("title",e?e:null)},_renderContent:function(){var e=this;u.deferRender(function(){if(!e._disposed)return e._renderContentImpl()}).done(function(){e._disposed||e._fireContentReadyAction()})},_renderContentImpl:u.noop,_fireContentReadyAction:u.deferRenderer(function(){this._contentReadyAction()}),_dispose:function(){this._contentReadyAction=null,this.callBase()},_resetActiveState:function(){this._toggleActiveState(this._eventBindingTarget(),!1)},_clean:function(){this._cleanFocusState(),this._resetActiveState(),this.callBase(),this.$element().empty()},_toggleVisibility:function(e){this.$element().toggleClass(C,!e),this.setAria("hidden",!e||void 0)},_renderFocusState:function(){this._attachKeyboardEvents(),this._isFocusable()&&(this._renderFocusTarget(),this._attachFocusEvents(),this._renderAccessKey())},_renderAccessKey:function(){var e=this._focusTarget();e.attr("accesskey",this.option("accessKey"));var t=g.addNamespace(v.name,y);o.off(e,t),this.option("accessKey")&&o.on(e,t,function(e){g.isFakeClickEvent(e)&&(e.stopImmediatePropagation(),this.focus())}.bind(this))},_isFocusable:function(){return this.option("focusStateEnabled")&&!this.option("disabled")},_eventBindingTarget:function(){return this.$element()},_focusTarget:function(){return this._getActiveElement()},_getActiveElement:function(){var e=this._eventBindingTarget();return this._activeStateUnit&&(e=e.find(this._activeStateUnit).not("."+w)),e},_renderFocusTarget:function(){this._focusTarget().attr("tabIndex",this.option("tabIndex"))},_keyboardEventBindingTarget:function(){return this._eventBindingTarget()},_detachFocusEvents:function(){var e=this._focusEventTarget(),t=this.NAME+T,n=g.addNamespace("focusin",t);n=n+" "+g.addNamespace("focusout",t),d.hasDocumentProperty("onbeforeactivate")&&(n=n+" "+g.addNamespace("beforeactivate",t)),o.off(e,n)},_attachFocusEvents:function(){var e=this.NAME+T,t=g.addNamespace("focusin",e),n=g.addNamespace("focusout",e),a=this._focusEventTarget();if(o.on(a,t,this._focusInHandler.bind(this)),o.on(a,n,this._focusOutHandler.bind(this)),d.hasDocumentProperty("onbeforeactivate")){var r=g.addNamespace("beforeactivate",e);o.on(this._focusEventTarget(),r,function(e){i(e.target).is(p.focusable)||e.preventDefault()})}},_refreshFocusEvent:function(){this._detachFocusEvents(),this._attachFocusEvents()},_focusEventTarget:function(){return this._focusTarget()},_focusInHandler:function(e){if(!e.isDefaultPrevented()){var t=this;t._createActionByOption("onFocusIn",{beforeExecute:function(){t._updateFocusState(e,!0)},excludeValidators:["readOnly"]})({event:e})}},_focusOutHandler:function(e){if(!e.isDefaultPrevented()){var t=this;t._createActionByOption("onFocusOut",{beforeExecute:function(){t._updateFocusState(e,!1)},excludeValidators:["readOnly","disabled"]})({event:e})}},_updateFocusState:function(e,t){var n=e.target;s(n,this._focusTarget())!==-1&&this._toggleFocusClass(t,i(n))},_toggleFocusClass:function(e,t){var n=t&&t.length?t:this._focusTarget();n.toggleClass(S,e)},_hasFocusClass:function(e){var t=i(e||this._focusTarget());return t.hasClass(S)},_isFocused:function(){return this._hasFocusClass()},_attachKeyboardEvents:function(){var e=this.option("_keyboardProcessor");e?this._keyboardProcessor=e.reinitialize(this._keyboardHandler,this):this.option("focusStateEnabled")&&(this._disposeKeyboardProcessor(),this._keyboardProcessor=new f({element:this._keyboardEventBindingTarget(),handler:this._keyboardHandler,focusTarget:this._focusTarget(),context:this}))},_keyboardHandler:function(e){var t=e.originalEvent,n=e.keyName,i=e.which,o=this._supportedKeys(t),a=o[n]||o[i];if(void 0!==a){var r=a.bind(this);return r(t)||!1}return!0},_refreshFocusState:function(){this._cleanFocusState(),this._renderFocusState()},_cleanFocusState:function(){var e=this._focusTarget();this._detachFocusEvents(),this._toggleFocusClass(!1),e.removeAttr("tabIndex"),this._disposeKeyboardProcessor()},_disposeKeyboardProcessor:function(){this._keyboardProcessor&&(this._keyboardProcessor.dispose(),delete this._keyboardProcessor)},_attachHoverEvents:function(){var e=this,t=e._activeStateUnit,n=g.addNamespace(_.start,y),r=g.addNamespace(_.end,y);if(o.off(e._eventBindingTarget(),n,t),o.off(e._eventBindingTarget(),r,t),e.option("hoverStateEnabled")){var s=new a(function(t){e._hoverStartHandler(t.event),e._refreshHoveredElement(i(t.element))},{excludeValidators:["readOnly"]}),l=e._eventBindingTarget();o.on(l,n,t,function(e){s.execute({element:i(e.target),event:e})}),o.on(l,r,t,function(t){e._hoverEndHandler(t),e._forgetHoveredElement()})}else e._toggleHoverClass(!1)},_hoverStartHandler:u.noop,_hoverEndHandler:u.noop,_attachFeedbackEvents:function(){var e,t,n=this,r=n._activeStateUnit,s=g.addNamespace(m.active,y),l=g.addNamespace(m.inactive,y);if(o.off(n._eventBindingTarget(),s,r),o.off(n._eventBindingTarget(),l,r),n.option("activeStateEnabled")){var u=function(e){var t=i(e.element),o=e.value,a=e.event;n._toggleActiveState(t,o,a)};o.on(n._eventBindingTarget(),s,r,{timeout:n._feedbackShowTimeout},function(t){e=e||new a(u),e.execute({element:i(t.currentTarget),value:!0,event:t})}),o.on(n._eventBindingTarget(),l,r,{timeout:n._feedbackHideTimeout},function(e){t=t||new a(u,{excludeValidators:["disabled","readOnly"]}),t.execute({element:i(e.currentTarget),value:!1,event:e})})}},_toggleActiveState:function(e,t){this._toggleHoverClass(!t),e.toggleClass(x,t)},_refreshHoveredElement:function(e){var t=this._activeStateUnit||this._eventBindingTarget();this._forgetHoveredElement(),this._hoveredElement=e.closest(t),this._toggleHoverClass(!0)},_forgetHoveredElement:function(){this._toggleHoverClass(!1),delete this._hoveredElement},_toggleHoverClass:function(e){this._hoveredElement&&this._hoveredElement.toggleClass(k,e&&this.option("hoverStateEnabled"))},_toggleDisabledState:function(e){this.$element().toggleClass(w,Boolean(e)),this._toggleHoverClass(!e),this.setAria("disabled",e||void 0)},_toggleIndependentState:function(){this.$element().toggleClass("dx-state-independent",this.option("ignoreParentReadOnly"))},_setWidgetOption:function(e,t){if(this[e]){if(c.isPlainObject(t[0]))return void l(t[0],function(t,n){this._setWidgetOption(e,[t,n])}.bind(this));var n=t[0],i=t[1];1===t.length&&(i=this.option(n));var o=this[e+"OptionMap"];this[e].option(o?o(n):n,i)}},_optionChanged:function(e){switch(e.name){case"disabled":this._toggleDisabledState(e.value),this._refreshFocusState();break;case"hint":this._renderHint();break;case"ignoreParentReadOnly":this._toggleIndependentState();break;case"activeStateEnabled":this._attachFeedbackEvents();break;case"hoverStateEnabled":this._attachHoverEvents();break;case"tabIndex":case"_keyboardProcessor":case"focusStateEnabled":this._refreshFocusState();break;case"onFocusIn":case"onFocusOut":break;case"accessKey":this._renderAccessKey();break;case"visible":var t=e.value;this._toggleVisibility(t),this._isVisibilityChangeSupported()&&this._checkVisibilityChanged(e.value?"shown":"hiding");break;case"onContentReady":this._initContentReadyAction();break;default:this.callBase(e)}},_isVisible:function(){return this.callBase()&&this.option("visible")},beginUpdate:function(){this._ready(!1),this.callBase()},endUpdate:function(){this.callBase(),this._initialized&&this._ready(!0)},_ready:function(e){return 0===arguments.length?this._isReady:void(this._isReady=e)},setAria:function(){var e=function(e){var t="role"===e.name||"id"===e.name?e.name:"aria-"+e.name,n=e.value;n=c.isDefined(n)?n.toString():null,e.target.attr(t,n)};if(c.isPlainObject(arguments[0])){var t=arguments[1]||this._getAriaTarget();l(arguments[0],function(n,i){e({name:n,value:i,target:t})})}else e({name:arguments[0],value:arguments[1],target:arguments[2]||this._getAriaTarget()})},isReady:function(){return this._ready()},repaint:function(){this._refresh()},focus:function(){o.trigger(this._focusTarget(),"focus")},registerKeyHandler:function(e,t){var n=this._supportedKeys(),i={};i[e]=t,this._supportedKeys=function(){return r(n,i)}}});e.exports=E},function(e,t,n){var i=n(128),o=n(21);e.exports=i(o.ERROR_MESSAGES,{E1001:"Module '{0}'. Controller '{1}' is already registered",E1002:"Module '{0}'. Controller '{1}' does not inherit from DevExpress.ui.dxDataGrid.Controller",E1003:"Module '{0}'. View '{1}' is already registered",E1004:"Module '{0}'. View '{1}' does not inherit from DevExpress.ui.dxDataGrid.View",E1005:"Public method '{0}' is already registered",E1006:"Public method '{0}.{1}' does not exist",E1007:"State storing cannot be provided due to the restrictions of the browser",E1010:"The template does not contain the TextBox widget",E1011:'Items cannot be deleted from the List. Implement the "remove" function in the data store',E1012:"Editing type '{0}' with the name '{1}' is unsupported",E1016:"Unexpected type of data source is provided for a lookup column",E1018:"The 'collapseAll' method cannot be called if you use a remote data source",E1019:"Search mode '{0}' is unavailable",E1020:"The type cannot be changed after initialization",E1021:"{0} '{1}' you are trying to remove does not exist",E1022:'The "markers" option is given an invalid value. Assign an array instead',E1023:'The "routes" option is given an invalid value. Assign an array instead',E1025:"This layout is too complex to render",E1026:'The "calculateCustomSummary" function is missing from a field whose "summaryType" option is set to "custom"',E1030:"Unknown ScrollView refresh strategy: '{0}'",E1031:"Unknown subscription in the Scheduler widget: '{0}'",E1032:"Unknown start date in an appointment: '{0}'",E1033:"Unknown step in the date navigator: '{0}'",E1034:"The browser does not implement an API for saving files",E1035:"The editor cannot be created because of an internal error: {0}",E1037:"Invalid structure of grouped data",E1038:"The browser does not support local storages for local web pages",E1039:"A cell's position cannot be calculated",E1040:"The '{0}' key value is not unique within the data array",E1041:"The '{0}' script is referenced after the DevExtreme scripts or not referenced at all",E1042:"{0} requires the key field to be specified",E1043:"Changes cannot be processed due to the incorrectly set key",E1044:"The key field specified by the keyExpr option does not match the key field specified in the data store",E1045:"Editing requires the key field to be specified in the data store",E1046:"The '{0}' key field is not found in data objects",E1047:'The "{0}" field is not found in the fields array',E1048:'The "{0}" operation is not found in the filterOperations array',E1049:"Column '{0}': filtering is allowed but the 'dataField' or 'name' option is not specified",E1050:"The validationRules option does not apply to third-party editors defined in the editCellTemplate",E1051:'HtmlEditor\'s valueType is "{0}", but the {0} converter was not imported.',E1052:'{0} should have the "dataSource" option specified',E1053:'The "buttons" option accepts an array that contains only objects or string values',E1054:"All text editor buttons must have names",E1055:'One or several text editor buttons have invalid or non-unique "name" values',E1056:'The {0} widget does not support buttons of the "{1}" type',E1057:'The {0} widget does not support asynchronous validation rules in the "{1}" edit mode',E1058:'The "startDayHour" must be earlier than the "endDayHour"',W1001:'The "key" option cannot be modified after initialization',W1002:"An item with the key '{0}' does not exist",W1003:"A group with the key '{0}' in which you are trying to select items does not exist",W1004:"The item '{0}' you are trying to select in the group '{1}' does not exist",W1005:"Due to column data types being unspecified, data has been loaded twice in order to apply initial filter settings. To resolve this issue, specify data types for all grid columns.",W1006:"The map service returned the following error: '{0}'",W1007:"No item with key {0} was found in the data source, but this key was used as the parent key for item {1}",W1008:"Cannot scroll to the '{0}' date because it does not exist on the current view",W1009:"Searching works only if data is specified using the dataSource option",W1010:"The capability to select all items works with source data of plain structure only",W1011:'The "keyExpr" option is not applied when dataSource is not an array',W1012:"The '{0}' key field is not found in data objects",W1013:'The "message" field in the dialog component was renamed to "messageHtml". Change your code correspondingly. In addition, if you used HTML code in the message, make sure that it is secure',W1014:"The Floating Action Button exceeds the recommended speed dial action count. If you need to display more speed dial actions, increase the maxSpeedDialActionCount option value in the global config.",W1015:'The "cellDuration" should divide the range from the "startDayHour" to the "endDayHour" into even intervals'})},function(e,t,n){var i=n(2),o=n(5),a=n(16),r=n(11),s=n(12),l=n(113),u=n(8),c=n(24),d=n(116),h=n(91),f=n(53).compare,p="dxclick",g=10,_=Math.abs,m=function(e){return i(e).is("input, textarea, select, button ,:focus, :focus *")},v={requestAnimationFrame:l.requestAnimationFrame,cancelAnimationFrame:l.cancelAnimationFrame},y=d.inherit({ctor:function(e){this.callBase(e),this._makeElementClickable(i(e))},_makeElementClickable:function(e){e.attr("onclick")||e.attr("onclick","void(0)")},start:function(e){this._blurPrevented=e.isDefaultPrevented(),this._startTarget=e.target,this._startEventData=u.eventData(e)},end:function(e){return this._eventOutOfElement(e,this.getElement().get(0))||e.type===c.cancel?void this._cancel(e):(m(e.target)||this._blurPrevented||s.resetActiveElement(),this._accept(e),void(this._clickAnimationFrame=v.requestAnimationFrame(function(){this._fireClickEvent(e)}.bind(this))))},_eventOutOfElement:function(e,t){var n=e.target,i=!s.contains(t,n)&&t!==n,o=u.eventDelta(u.eventData(e),this._startEventData),a=_(o.x)>g||_(o.y)>g;return i||a},_fireClickEvent:function(e){this._fireEvent(p,e,{target:s.closestCommonParent(this._startTarget,e.target)})},dispose:function(){v.cancelAnimationFrame(this._clickAnimationFrame)}});!function(){var e="dx-native-click",t=a.real(),n=t.generic||t.ios&&f(t.version,[9,3])>=0||t.android&&f(t.version,[5])>=0,r=function(t){return n||i(t).closest("."+e).length},s=null,l=null,c=function(e){var t=e.originalEvent,n=l===t||t&&t.DXCLICK_FIRED,i=!e.which||1===e.which;i&&!s&&r(e.target)&&!n&&(t&&(t.DXCLICK_FIRED=!0),l=t,u.fireEvent({type:p,originalEvent:e}))};y=y.inherit({_makeElementClickable:function(e){r(e)||this.callBase(e),o.on(e,"click",c)},configure:function(t){this.callBase(t),t.useNative&&this.getElement().addClass(e)},start:function(e){s=null,r(e.target)||this.callBase(e)},end:function(e){r(e.target)||this.callBase(e)},cancel:function(){s=!0},dispose:function(){this.callBase(),o.off(this.getElement(),"click",c)}})}(),function(){var e=a.real().generic;if(!e){var t=null,n=!1,l=function(e){t=e.target,n=e.isDefaultPrevented()},d=function(e){var o=i(e.target);n||!t||o.is(t)||i(t).is("label")||!m(o)||s.resetActiveElement(),t=null,n=!1},h="NATIVE_CLICK_FIXER",f=r.getDocument();o.subscribeGlobal(f,u.addNamespace(c.down,h),l),o.subscribeGlobal(f,u.addNamespace("click",h),d)}}(),h({emitter:y,bubble:!0,events:[p]}),t.name=p},function(e,t,n){var i=n(21),o=n(15),a=n(48),r=n(1),s=n(3).each,l=n(90),u=l.unwrap,c=l.isWrapped,d=l.assign,h=function(e){return e.replace(/\[/g,".").replace(/\]/g,"")},f=function(e,t,n){return n=n||{},"this"===t?_(e,n):_(e[t],n)},p=function(e,t,n,o){if("this"===t)throw new i.Error("E4016");var a=e[t];o.unwrapObservables&&c(a)?d(a,n):e[t]=n},g=function(e){return e=e||{},e.unwrapObservables=void 0===e.unwrapObservables||e.unwrapObservables,e},_=function(e,t){return t.unwrapObservables?u(e):e},m=function(e){if(arguments.length>1&&(e=[].slice.call(arguments)),!e||"this"===e)return function(e){return e};if("string"==typeof e){e=h(e);var t=e.split(".");return function(e,n){n=g(n);for(var i=n.functionsAsIs,o=("defaultValue"in n),a=_(e,n),s=0;s<t.length;s++){if(!a){if(null==a&&o)return n.defaultValue;break}var l=t[s];if(o&&r.isObject(a)&&!(l in a))return n.defaultValue;var u=_(a[l],n);!i&&r.isFunction(u)&&(u=u.call(a)),a=u}return a}}return Array.isArray(e)?v(e):r.isFunction(e)?e:void 0},v=function(e){for(var t={},n=0,i=e.length;n<i;n++){var o=e[n];t[o]=m(o)}return function(e,n){var i;return s(t,function(t){var o,a=this(e,n);if(void 0!==a){o=i||(i={});for(var r=t.split("."),s=r.length-1,l=0;l<s;l++){var u=r[l];u in o||(o[u]={}),o=o[u]}o[r[s]]=a}}),i}},y=function(e,t,n,i){if(r.isDefined(n))return n;var o={};return p(e,t,o,i),o},b=function(e){e=h(e||"this").split(".");var t=e.length-1;return function(n,i,o){o=g(o);var s=_(n,o);e.forEach(function(e,n){var l=f(s,e,o),u=!o.functionsAsIs&&r.isFunction(l)&&!c(l);n===t?o.merge&&r.isPlainObject(i)&&(!r.isDefined(l)||r.isPlainObject(l))?(l=y(s,e,l,o),a.deepExtendArraySafe(l,i,!1,!0)):u?s[e](i):p(s,e,i,o):(l=y(s,e,l,o),u&&(l=l.call(s)),s=l)})}},x=function(e,t){return e instanceof Date?e.getTime():e&&e instanceof o&&e.valueOf?e.valueOf():t||"string"!=typeof e?e:e.toLowerCase()};t.compileGetter=m,t.compileSetter=b,t.toComparable=x,t.bracketsToDots=h},function(e,t,n){var i=n(128);e.exports=i({E0001:"Method is not implemented",E0002:"Member name collision: {0}",E0003:"A class must be instantiated using the 'new' keyword",E0004:"The NAME property of the component is not specified",E0005:"Unknown device",E0006:"Unknown endpoint key is requested",E0007:"'Invalidate' method is called outside the update transaction",E0008:"Type of the option name is not appropriate to create an action",E0009:"Component '{0}' has not been initialized for an element",E0010:"Animation configuration with the '{0}' type requires '{1}' configuration as {2}",E0011:"Unknown animation type '{0}'",E0012:"jQuery version is too old. Please upgrade jQuery to 1.10.0 or later",E0013:"KnockoutJS version is too old. Please upgrade KnockoutJS to 2.3.0 or later",E0014:"The 'release' method shouldn't be called for an unlocked Lock object",E0015:"Queued task returned an unexpected result",E0017:"Event namespace is not defined",E0018:"DevExpress.ui.DevExpressPopup widget is required",E0020:"Template engine '{0}' is not supported",E0021:"Unknown theme is set: {0}",E0022:"LINK[rel=DevExpress-theme] tags must go before DevExpress included scripts",E0023:"Template name is not specified",E0024:"DevExtreme bundle already included",E0025:"Unexpected argument type",
E0100:"Unknown validation type is detected",E0101:"Misconfigured range validation rule is detected",E0102:"Misconfigured comparison validation rule is detected",E0103:"validationCallback of an asynchronous rule should return a jQuery or a native promise",E0110:"Unknown validation group is detected",E0120:"Adapter for a DevExpressValidator component cannot be configured",E0121:"The 'customItem' field of the 'onCustomItemCreating' function's parameter should contain a custom item or Promise that is resolved after the item is created.",W0000:"'{0}' is deprecated in {1}. {2}",W0001:"{0} - '{1}' option is deprecated in {2}. {3}",W0002:"{0} - '{1}' method is deprecated in {2}. {3}",W0003:"{0} - '{1}' property is deprecated in {2}. {3}",W0004:"Timeout for theme loading is over: {0}",W0005:"'{0}' event is deprecated in {1}. {2}",W0006:"Invalid recurrence rule: '{0}'",W0007:"'{0}' Globalize culture is not defined",W0008:"Invalid view name: '{0}'",W0009:"Invalid time zone name: '{0}'",W0010:"{0} is deprecated in {1}. {2}",W0011:"Number parsing is invoked while the parser is not defined",W0012:"Date parsing is invoked while the parser is not defined",W0013:"'{0}' file is deprecated in {1}. {2}",W0014:"{0} - '{1}' type is deprecated in {2}. {3}",W0015:"Instead of returning a value from the '{0}' function, write it into the '{1}' field of the function's parameter.",W0016:'The "{0}" option does not accept the "{1}" value since v.{2}. {3}.'})},function(e,t,n){function i(e){return e&&e.__esModule?e:{"default":e}}var o=n(28),a=i(o),r=n(1),s=i(r),l=function(e){var t=null!==e&&void 0!==e?e:(0,a.default)().rtlEnabled;return t?"right":"left"},u=function(e){if(s.default.isWindow(e))return{width:e.outerWidth,height:e.outerHeight};var t;try{t=e.getBoundingClientRect()}catch(e){t={width:0,height:0,bottom:0,top:0,left:0,right:0}}return t};t.getDefaultAlignment=l,t.getBoundingRect=u},function(e,t,n){var i=n(0).extend,o=n(7),a=o.getNavigator(),r=/(webkit)[ \/]([\w.]+)/,s=/(msie) (\d{1,2}\.\d)/,l=/(trident).*rv:(\d{1,2}\.\d)/,u=/(edge)\/((\d+)?[\w.]+)/,c=/(mozilla)(?:.*? rv:([\w.]+))/,d=function(e){e=e.toLowerCase();var t={},n=s.exec(e)||l.exec(e)||u.exec(e)||e.indexOf("compatible")<0&&c.exec(e)||r.exec(e)||[],i=n[1],o=n[2];return"webkit"===i&&(t.webkit=!0,e.indexOf("chrome")>=0||e.indexOf("crios")>=0?(i="chrome",o=/(?:chrome|crios)\/(\d+\.\d+)/.exec(e),o=o&&o[1]):e.indexOf("fxios")>=0?(i="mozilla",o=/fxios\/(\d+\.\d+)/.exec(e),o=o&&o[1]):e.indexOf("safari")>=0&&/version|phantomjs/.test(e)?(i="safari",o=/(?:version|phantomjs)\/([0-9.]+)/.exec(e),o=o&&o[1]):(i="unknown",o=/applewebkit\/([0-9.]+)/.exec(e),o=o&&o[1])),"trident"!==i&&"edge"!==i||(i="msie"),i&&(t[i]=!0,t.version=o),t};e.exports=i({_fromUA:d},d(a.userAgent))},function(e,t,n){function i(e){return e&&e.__esModule?e:{"default":e}}var o=n(45),a=i(o),r=n(3),s=n(23),l=i(s),u=n(16),c=i(u),d=n(69),h=i(d),f=n(230),p=i(f),g=n(467),_=i(g),m=n(232),v=i(m),y=n(468),b=i(y),x=function(e,t,n){if(e.pointerEvents&&n.msie)return _.default;var i=t.tablet,o=t.phone;return!e.touch||i||o?e.touch?p.default:v.default:b.default},w=x(a.default,c.default.real(),l.default);(0,r.each)(w.map,function(e,t){(0,h.default)(e,new w(e,t))});var C={down:"dxpointerdown",up:"dxpointerup",move:"dxpointermove",cancel:"dxpointercancel",enter:"dxpointerenter",leave:"dxpointerleave",over:"dxpointerover",out:"dxpointerout"};e.exports=C},function(e,t,n){function i(e,t,n){return i=o()?Reflect.construct:function(e,t,n){var i=[null];i.push.apply(i,t);var o=Function.bind.apply(e,i),r=new o;return n&&a(r,n.prototype),r},i.apply(null,arguments)}function o(){if("undefined"==typeof Reflect||!Reflect.construct)return!1;if(Reflect.construct.sham)return!1;if("function"==typeof Proxy)return!0;try{return Date.prototype.toString.call(Reflect.construct(Date,[],function(){})),!0}catch(e){return!1}}function a(e,t){return(a=Object.setPrototypeOf||function(e,t){return e.__proto__=t,e})(e,t)}function r(e){return I[S(e)]||""}function s(e,t,n){var i=new Date(e.getTime()),o=f(t)?j(t.toLowerCase()):l.isNumeric(t)?w(t):t;return o.years&&i.setFullYear(i.getFullYear()+o.years*n),o.quarters&&i.setMonth(i.getMonth()+3*o.quarters*n),o.months&&i.setMonth(i.getMonth()+o.months*n),o.weeks&&i.setDate(i.getDate()+7*o.weeks*n),o.days&&i.setDate(i.getDate()+o.days*n),o.hours&&i.setTime(i.getTime()+36e5*o.hours*n),o.minutes&&i.setTime(i.getTime()+6e4*o.minutes*n),o.seconds&&i.setTime(i.getTime()+1e3*o.seconds*n),o.milliseconds&&i.setTime(i.getTime()+o.milliseconds*n),i}var l=n(1),u=n(31).adjust,c=n(3).each,d=n(33).camelize,h=l.isObject,f=l.isString,p=l.isDate,g=l.isDefined,_=n(23),m=_.msie&&parseInt(_.version)<=11,v=["millisecond","second","minute","hour","day","week","month","quarter","year"],y=function e(t){switch(t){case"millisecond":return 1;case"second":return 1e3*e("millisecond");case"minute":return 60*e("second");case"hour":return 60*e("minute");case"day":return 24*e("hour");case"week":return 7*e("day");case"month":return 30*e("day");case"quarter":return 3*e("month");case"year":return 365*e("day");default:return 0}},b=function(e,t,n){var i=t.getTime()-e.getTime(),o=y(n)||1;return Math.floor(i/o)},x=function(e,t){var n=S(e);switch(n){case"millisecond":return"second";case"second":return"minute";case"minute":return"hour";case"hour":return"day";case"day":return t?"week":"month";case"week":return"month";case"month":return"quarter";case"quarter":return"year";case"year":return"year";default:return 0}},w=function(e){for(var t=["millisecond","second","minute","hour","day","month","year"],n={},i=t.length-1;i>=0;i--){var o=t[i],a=Math.floor(e/y(o));a>0&&(n[o+"s"]=a,e-=k(o,a))}return n},C=function(e){var t=0;return h(e)&&c(e,function(e,n){t+=k(e.substr(0,e.length-1),n)}),f(e)&&(t=k(e,1)),t},k=function(e,t){return y(e)*t},S=function(e){var t=-1;return f(e)?e:h(e)?(c(e,function(e,n){for(var i=0;i<v.length;i++)n&&(e===v[i]+"s"||e===v[i])&&t<i&&(t=i)}),v[t]):""},I={millisecond:"millisecond",second:"longtime",minute:"shorttime",hour:"shorttime",day:"day",week:"day",month:"month",quarter:"quarter",year:"year"},D=function(e){return Math.floor(e/3)},T=function(e){return 3*D(e)},E=function(e,t,n,i){e=new Date(e.getTime());var o=new Date(e.getTime()),a=S(t);switch(a){case"second":e=new Date(1e3*Math.floor(o.getTime()/1e3));break;case"minute":e=new Date(6e4*Math.floor(o.getTime()/6e4));break;case"hour":e=new Date(36e5*Math.floor(o.getTime()/36e5));break;case"year":e.setMonth(0);case"month":e.setDate(1);case"day":e.setHours(0,0,0,0);break;case"week":e=ne(e,i||0),e.setHours(0,0,0,0);break;case"quarter":var r=T(e.getMonth()),s=e.getMonth();e.setDate(1),e.setHours(0,0,0,0),s!==r&&e.setMonth(r)}return n&&"hour"!==a&&"minute"!==a&&"second"!==a&&le(o,e),e},A=function(e){return ge.correctDateWithUnitBeginning(e,"day")},O=function(e){var t=ge.trimTime(e);return t.setDate(t.getDate()+1),new Date(t.getTime()-1)},P=function(e,t){var n=0,i={year:e.getFullYear()!==t.getFullYear(),month:e.getMonth()!==t.getMonth(),day:e.getDate()!==t.getDate(),hour:e.getHours()!==t.getHours(),minute:e.getMinutes()!==t.getMinutes(),second:e.getSeconds()!==t.getSeconds(),millisecond:e.getMilliseconds()!==t.getMilliseconds()};return c(i,function(e,t){t&&n++}),0===n&&0!==ce(e,t)&&(i.hour=!0,n++),i.count=n,i},R=function(e,t,n){var i=n?-1:1;return p(e)?s(e,t,i):u(e+t*i,t)},B=function(e,t,n){var i,o=[];for(o.push(p(e)?new Date(e.getTime()):e),i=e;i<t;)i=R(i,n),o.push(i);return o},M=function(e,t){return"month"===e?pe(t.getFullYear(),t.getMonth(),1):"year"===e?pe(t.getFullYear(),0,t.getDate()):"decade"===e?pe(Q(t),t.getMonth(),t.getDate()):"century"===e?pe(Z(t),t.getMonth(),t.getDate()):void 0},V=function(e,t){return"month"===e?pe(t.getFullYear(),t.getMonth(),H(t)):"year"===e?pe(t.getFullYear(),11,t.getDate()):"decade"===e?pe(Q(t)+9,t.getMonth(),t.getDate()):"century"===e?pe(Z(t)+90,t.getMonth(),t.getDate()):void 0},F=function(e,t){var n=pe(t.getFullYear(),t.getMonth(),1);return"month"===e?n:(n.setMonth(0),"year"===e?n:("decade"===e&&n.setFullYear(Q(t)),"century"===e&&n.setFullYear(Z(t)),n))},L=function(e,t){var n=new Date(t);return n.setDate(H(t)),"month"===e?n:(n.setMonth(11),n.setDate(H(n)),"year"===e?n:("decade"===e&&n.setFullYear(Q(t)+9),"century"===e&&n.setFullYear(Z(t)+99),n))},H=function(e){var t=pe(e.getFullYear(),e.getMonth()+1,0);return t.getDate()},z=function(e,t,n){return ge[d("same "+e)](t,n)},N=function(e){switch(e){case"month":return"year";case"year":return"decade";case"decade":return"century"}},$=function(e){switch(e){case"century":return"decade";case"decade":return"year";case"year":return"month"}},W=function(e){var t=1;return"year"===e&&(t=12),"decade"===e&&(t=120),"century"===e&&(t=1200),t},G=function(e){var t=1;return"decade"===e&&(t=12),"century"===e&&(t=120),t},j=function(e){var t={};switch(e){case"year":t.years=1;break;case"month":t.months=1;break;case"quarter":t.months=3;break;case"week":t.weeks=1;break;case"day":t.days=1;break;case"hour":t.hours=1;break;case"minute":t.minutes=1;break;case"second":t.seconds=1;break;case"millisecond":t.milliseconds=1}return t},q=function(e,t){return K(e,t)&&e.getDate()===t.getDate()},K=function(e,t){return U(e,t)&&e.getMonth()===t.getMonth()},U=function(e,t){return e&&t&&e.getFullYear()===t.getFullYear()},Y=function(e,t){if(g(e)&&g(t)){var n=e.getFullYear()-e.getFullYear()%10,i=t.getFullYear()-t.getFullYear()%10;return e&&t&&n===i}},X=function(e,t){if(g(e)&&g(t)){var n=e.getFullYear()-e.getFullYear()%100,i=t.getFullYear()-t.getFullYear()%100;return e&&t&&n===i}},Z=function(e){return e&&e.getFullYear()-e.getFullYear()%100},Q=function(e){return e&&e.getFullYear()-e.getFullYear()%10},J=function(){return"yyyy/MM/dd"},ee=function(e){if(g(e))return pe(e.getFullYear(),e.getMonth(),1)},te=function(e){if(g(e))return pe(e.getFullYear(),e.getMonth()+1,0)},ne=function(e,t){var n=(e.getDay()-t+7)%7,i=new Date(e);return i.setDate(e.getDate()-n),i},ie=function(e,t){var n=ge.getDatesInterval(e,t,"day"),i=new Date(e);return n>=6&&(i=new Date(i.setDate(i.getDate()+7))),i},oe=function(e,t,n,i){return"date"===i&&(t=t&&ge.correctDateWithUnitBeginning(t,"day"),n=n&&ge.correctDateWithUnitBeginning(n,"day"),e=e&&ge.correctDateWithUnitBeginning(e,"day")),se(e,t,n)===e},ae=function(e){var t=Math.floor(e),n=e%1*60;return{hours:t,minutes:n}},re=function(e,t){var n=this.dateTimeFromDecimal(t),i=new Date(e);return(e.getHours()===n.hours&&e.getMinutes()<n.minutes||e.getHours()<n.hours)&&i.setHours(n.hours,n.minutes,0,0),i},se=function(e,t,n){var i=e;return g(e)?(g(t)&&e<t&&(i=t),g(n)&&e>n&&(i=n),i):e},le=function(e,t){if(g(e)){var n=t.getHours()-e.getHours();if(0!==n){var i=1===n||n===-23?-1:1,o=new Date(t.getTime()+36e5*i);(i>0||o.getDate()===t.getDate())&&t.setTime(o.getTime())}}},ue=function(e){return e.setHours(e.getHours()+1),e.setMinutes(0),e},ce=function(e,t){return 60*(t.getTimezoneOffset()-e.getTimezoneOffset())*1e3},de=function(e){return new Date(e)},he=function(e,t,n){var i=[],o=new Date(e.getTime());for(e.getTime()===t.getTime()&&i.push(new Date(e.getTime()));o<t;)i.push(new Date(o.getTime())),o=this.addInterval(o,n);return i},fe=function(e){return new Date(m&&p(e)?e.getTime():e)},pe=function(e){var t=i(Date,Array.prototype.slice.call(arguments));return t.setFullYear(e),t},ge={dateUnitIntervals:v,convertMillisecondsToDateUnits:w,dateToMilliseconds:C,getNextDateUnit:x,convertDateUnitToMilliseconds:k,getDateUnitInterval:S,getDateFormatByTickInterval:r,getDatesDifferences:P,correctDateWithUnitBeginning:E,trimTime:A,setToDayEnd:O,roundDateByStartDayHour:re,dateTimeFromDecimal:ae,addDateInterval:s,addInterval:R,getSequenceByInterval:B,getDateIntervalByString:j,sameDate:q,sameMonthAndYear:K,sameMonth:K,sameYear:U,sameDecade:Y,sameCentury:X,sameView:z,getDifferenceInMonth:W,getDifferenceInMonthForCells:G,getFirstYearInDecade:Q,getFirstDecadeInCentury:Z,getShortDateFormat:J,getViewFirstCellDate:M,getViewLastCellDate:V,getViewDown:$,getViewUp:N,getLastMonthDay:H,getLastMonthDate:te,getFirstMonthDate:ee,getFirstWeekDate:ne,normalizeDateByWeek:ie,getQuarter:D,getFirstQuarterMonth:T,dateInRange:oe,roundToHour:ue,normalizeDate:se,getViewMinBoundaryDate:F,getViewMaxBoundaryDate:L,fixTimezoneGap:le,getTimezonesDifference:ce,makeDate:de,getDatesInterval:b,getDatesOfInterval:he,createDate:fe,createDateWithFullYear:pe};e.exports=ge},function(e,t,n){function i(e){return e&&e.__esModule?e:{"default":e}}var o=n(0),a=n(34),r=i(a),s=n(41),l=i(s);(0,o.extend)(t,l.default,r.default,{modules:[]})},function(e,t,n){var i=function(e){this._options=e||{},this._list=[],this._queue=[],this._firing=!1,this._fired=!1,this._firingIndexes=[]};i.prototype._fireCore=function(e,t){var n=this._firingIndexes,i=this._list,o=this._options.stopOnFalse,a=n.length;for(n[a]=0;n[a]<i.length;n[a]++){var r=i[n[a]].apply(e,t);if(r===!1&&o)break}n.pop()},i.prototype.add=function(e){return"function"!=typeof e||this._options.unique&&this.has(e)||this._list.push(e),this},i.prototype.remove=function(e){var t=this._list,n=this._firingIndexes,i=t.indexOf(e);if(i>-1&&(t.splice(i,1),this._firing&&n.length))for(var o=0;o<n.length;o++)i<=n[o]&&n[o]--;return this},i.prototype.has=function(e){var t=this._list;return e?t.indexOf(e)>-1:!!t.length},i.prototype.empty=function(e){return this._list=[],this},i.prototype.fireWith=function(e,t){var n=this._queue;if(t=t||[],t=t.slice?t.slice():t,this._options.syncStrategy)this._firing=!0,this._fireCore(e,t);else{if(n.push([e,t]),this._firing)return;for(this._firing=!0;n.length;){var i=n.shift();this._fireCore(i[0],i[1])}}return this._firing=!1,this._fired=!0,this},i.prototype.fire=function(){this.fireWith(this,arguments)},i.prototype.fired=function(){return this._fired};var o=function(e){return new i(e)};e.exports=o},function(e,t,n){function i(e){return e&&e.__esModule?e:{"default":e}}var o=n(0),a=i(o),r=n(21),s=i(r),l={rtlEnabled:!1,defaultCurrency:"USD",oDataFilterToLower:!0,serverDecimalSeparator:".",decimalSeparator:".",thousandsSeparator:",",forceIsoDateParsing:!0,wrapActionsBeforeExecute:!0,useLegacyStoreResult:!1,useJQuery:void 0,editorStylingMode:void 0,useLegacyVisibleIndex:!1,floatingActionButtonConfig:{icon:"add",closeIcon:"close",label:"",position:{at:"right bottom",my:"right bottom",offset:{x:-16,y:-16}},maxSpeedDialActionCount:5,shading:!1,direction:"auto"},optionsParser:function(e){"{"!==e.trim().charAt(0)&&(e="{"+e+"}");try{return new Function("return "+e)()}catch(t){throw s.default.Error("E3018",t,e)}}},u=["decimalSeparator","thousandsSeparator"],c=function(){if(!arguments.length)return l;var e=arguments.length<=0?void 0:arguments[0];u.forEach(function(t){if(e[t]){var n="Now, the ".concat(t," is selected based on the specified locale.");s.default.log("W0003","config",t,"19.2",n)}}),a.default.extend(l,e)};"undefined"!=typeof DevExpress&&DevExpress.config&&c(DevExpress.config),e.exports=c},function(e,t,n){var i=n(39),o=n(1).type,a="dxTranslator",r=/matrix(3d)?\((.+?)\)/,s=/translate(?:3d)?\((.+?)\)/,l=function(e){var t=d(e);return{left:t.x,top:t.y}},u=function(e,t){var n,i=t.left,o=t.top;void 0===i?(n=d(e),n.y=o||0):void 0===o?(n=d(e),n.x=i||0):(n={x:i||0,y:o||0,z:0},h(e,n)),e.css({transform:_(n)}),(c(i)||c(o))&&f(e)},c=function(e){return"string"===o(e)&&"%"===e[e.length-1]},d=function(e){var t=e.length?i.data(e.get(0),a):null;if(!t){var n=e.css("transform")||_({x:0,y:0}),o=n.match(r),s=o&&o[1];o?(o=o[2].split(","),"3d"===s?o=o.slice(12,15):(o.push(0),o=o.slice(4,7))):o=[0,0,0],t={x:parseFloat(o[0]),y:parseFloat(o[1]),z:parseFloat(o[2])},h(e,t)}return t},h=function(e,t){e.length&&i.data(e.get(0),a,t)},f=function(e){e.length&&i.removeData(e.get(0),a)},p=function(e,t){var n,i={left:0,top:0,transform:"none"};t&&(n=e.css("transition"),i.transition="none"),e.css(i),f(e),t&&(e.get(0).offsetHeight,e.css("transition",n))},g=function(e){var t=e.match(s);if(t&&t[1])return t=t[1].split(","),t={x:parseFloat(t[0]),y:parseFloat(t[1]),z:parseFloat(t[2])}},_=function(e){e.x=e.x||0,e.y=e.y||0;var t=c(e.x)?e.x:e.x+"px",n=c(e.y)?e.y:e.y+"px";return"translate("+t+", "+n+")"};t.move=u,t.locate=l,t.clearCache=f,t.parseTranslate=g,t.getTranslate=d,t.getTranslateCss=_,t.resetPosition=p},function(e,t,n){function i(e){return e&&e.__esModule?e:{"default":e}}var o=n(0),a=n(41),r=i(a);(0,o.extend)(t,r.default,{modules:[],foreachNodes:function(e,t){for(var n=0;n<e.length;n++)t(e[n])!==!1&&e[n].hasChildren&&e[n].children.length&&this.foreachNodes(e[n].children,t)}})},function(e,t,n){function i(e){return Math.abs(parseInt(e.toExponential().split("e")[1]))}function o(){var e=3e-4,t="0.000300",n=3;return t!==e.toPrecision(n)}function a(e,t){var n=r(t||0)+2,a=e.toString().split("."),s=e,l=Math.abs(e),c=u(e),d=l>1?10:0;if(1===a.length)return e;if(c||(u(t)&&(n=a[0].length+i(t)),e=l,e=e-Math.floor(e)+d),n=o()&&i(e)>6||n>7?15:7,!c){var h=parseFloat(e.toPrecision(n)).toString().split(".");if(h[0]===d.toString())return parseFloat(a[0]+"."+h[1])}return parseFloat(s.toPrecision(n))}function r(e){var t=e.toString();if(t.indexOf(".")<0)return 0;var n=t.split("."),i=n[1].indexOf("e");return i>=0?i:n[1].length}function s(e,t){if(e<0&&t%2!==1)return NaN;var n=Math.pow(Math.abs(e),1/t);return t%2===1&&e<0?-n:n}function l(e,t,n,i){var o=1e-8;if(Math.abs(e)<o){if(e=t,t=n,n=i,Math.abs(e)<o)return e=t,t=n,Math.abs(e)<o?[]:[-t/e];var a=t*t-4*e*n;return Math.abs(a)<o?[-t/(2*e)]:a>0?[(-t+Math.sqrt(a))/(2*e),(-t-Math.sqrt(a))/(2*e)]:[]}var r,l,u=(3*e*n-t*t)/(3*e*e),c=(2*t*t*t-9*e*t*n+27*e*e*i)/(27*e*e*e);if(Math.abs(u)<o)r=[s(-c,3)];else if(Math.abs(c)<o)r=[0].concat(u<0?[Math.sqrt(-u),-Math.sqrt(-u)]:[]);else{var d=c*c/4+u*u*u/27;if(Math.abs(d)<o)r=[-1.5*c/u,3*c/u];else if(d>0)l=s(-c/2-Math.sqrt(d),3),r=[l-u/(3*l)];else{l=2*Math.sqrt(-u/3);var h=Math.acos(3*c/u/l)/3,f=2*Math.PI/3;r=[l*Math.cos(h),l*Math.cos(h-f),l*Math.cos(h-2*f)]}}for(var p=0;p<r.length;p++)r[p]-=t/(3*e);return r}var u=n(1).isExponential,c=function(e){return 0===e?0:e/Math.abs(e)},d=function(e,t,n){var i=!t&&0!==t,o=!n&&0!==n;return i&&(t=o?e:Math.min(e,n)),o&&(n=i?e:Math.max(e,t)),Math.min(Math.max(e,t),n)},h=function(e,t,n){return e>=t&&e<=n};t.sign=c,t.fitIntoRange=d,t.inRange=h,t.adjust=a,t.getPrecision=r,t.getExponent=i,t.getRoot=s,t.solveCubicEquation=l},function(e,t,n){function i(){if(!R.hasWindow())return null;var e,t=O("<div>",k).addClass("dx-theme-marker").appendTo(k.documentElement);try{return(e=t.css("fontFamily"))?(e=e.replace(/["']/g,""),e.substr(0,Z.length)!==Z?null:e.substr(Z.length)):null}finally{t.remove()}}function o(e){function t(){T=null,W.fire(),W.empty()}var n;T=e,a()?t():(n=Date.now(),E=setInterval(function(){var e=a(),i=!e&&Date.now()-n>15e3;i&&V.log("W0004",T),(e||i)&&(clearInterval(E),E=void 0,t())},10))}function a(){return!T||i()===T}function r(){var e=O(K,k);e.length&&(I={},S=O(F.createMarkupFromString("<link rel=stylesheet>"),k),e.each(function(){var e=O(this,k),t=e.attr(U),n=e.attr("href"),i="true"===e.attr(Y);I[t]={url:n,isActive:i}}),e.last().after(S),e.remove())}function s(e){var t=e?e.split("."):[],n=null;if(I){if(e in I)return e;z(I,function(e,i){var o=e.split(".");if(!(t[0]&&o[0]!==t[0]||t[1]&&t[1]!==o[1]||t[2]&&t[2]!==o[2]))return n&&!i.isActive||(n=e),!i.isActive&&void 0})}return n}function l(e){try{e!==k&&(I=null)}catch(e){I=null}k=e}function u(e){e=e||{},l(e.context||P.getDocument()),k&&(r(),D=void 0,c(e))}function c(e){if(!arguments.length)return D=D||i();f(G()),e=e||{},"string"==typeof e&&(e={theme:e});var t,n=e._autoInit,a=e.loadCallback;if(D=s(e.theme||D),D&&(t=I[D]),a&&W.add(a),t)S.attr("href",I[D].url),!W.has()&&!e._forceTimeout||E?T&&(T=D):o(D);else{if(!n)throw V.Error("E0021",D);W.fire(),W.empty()}b(),h($.originalViewPort(),D)}function d(e){e=e||c();var t=[],n=e&&e.split(".");return n&&(t.push("dx-theme-"+n[0],"dx-theme-"+n[0]+"-typography"),n.length>1&&t.push("dx-color-scheme-"+n[1]+(_(e)?"-"+n[2]:""))),t}function h(e,t){A=d(t).join(" "),O(e).addClass(A);var n=function(){var t=R.hasWindow()&&B.devicePixelRatio;if(t&&!(t<2)){var n=O("<div>");n.css("border",".5px solid transparent"),O("body").append(n),1===n.outerHeight()&&(O(e).addClass(X),A+=" "+X),n.remove()}};n()}function f(e){O(e).removeClass(A)}function p(e){W.add(e)}function g(e,t){return t||(t=D||i()),new RegExp(e).test(t)}function _(e){return g("material",e)}function m(e){return g("ios7",e)}function v(e){return g("generic",e)}function y(e){return g("dark",e)}function b(){m()&&V.log("W0010","The 'ios7' theme","19.1","Use the 'generic' theme instead.")}function x(e,t){var n="Roboto, RobotoFallback, Arial",i="Arial",o=P.getDocument(),a=o.createElement("span");a.style.position="absolute",a.style.top="-9999px",a.style.left="-9999px",a.style.visibility="hidden",a.style.fontFamily=i,a.style.fontSize="250px",a.style.fontWeight=t,a.innerHTML=e,o.body.appendChild(a);var r=a.offsetWidth;a.style.fontFamily=n;var s=a.offsetWidth;return a.parentNode.removeChild(a),r!==s}function w(e,t){var n=15,i=2e3;return new j(function(o){var a=function(){x(e,t)&&r()},r=function(){clearInterval(s),clearTimeout(l),o()},s=setInterval(a,n),l=setTimeout(r,i)})}function C(){if(u({_autoInit:!0,_forceTimeout:!0}),O(K,k).length)throw V.Error("E0022");Q.resolve()}var k,S,I,D,T,E,A,O=n(2),P=n(11),R=n(7),B=R.getWindow(),M=n(6).Deferred,V=n(18),F=n(12),L=n(52),H=L.add,z=n(3).each,N=n(16),$=n(74),W=n(234),G=$.value,j=n(68),q=$.changeCallback,K="link[rel=dx-theme]",U="data-theme",Y="data-active",X="dx-hairlines",Z="dx.",Q=new M;R.hasWindow()?C():H(C),q.add(function(e,t){Q.done(function(){f(t),h(e)})}),N.changed.add(function(){u({_autoInit:!0})}),t.current=c,t.ready=p,t.init=u,t.attachCssClasses=h,t.detachCssClasses=f,t.waitForThemeLoad=o,t.isMaterial=_,t.isIos7=m,t.isGeneric=v,t.isDark=y,t.isWebFontLoaded=x,t.waitWebFont=w,t.resetTheme=function(){S&&S.attr("href","about:blank"),D=null,T=null}},function(e,t,n){var i=n(3).map,o=function(e){return void 0===e||null===e?"":String(e)},a=function(e){return o(e).charAt(0).toUpperCase()+e.substr(1)},r=function(e){return o(e).replace(/([a-z\d])([A-Z])/g,"$1 $2").split(/[\s_-]+/)},s=function(e){return i(r(e),function(e){return e.toLowerCase()}).join("-")},l=function(e){return s(e).replace(/-/g,"_")},u=function(e,t){return i(r(e),function(e,n){return e=e.toLowerCase(),(t||n>0)&&(e=a(e)),e}).join("")},c=function(e){return a(s(e).replace(/-/g," "))},d=function(e){return i(r(e),function(e){return a(e.toLowerCase())}).join(" ")},h=["0","1","2","3","4","5","6","7","8","9"],f=function(e){var t,n,i=[],o=!1,a=!1;for(t=0;t<e.length;t++)n=e.charAt(t),a=n===n.toUpperCase()&&"-"!==n&&")"!==n&&"/"!==n||n in h,"_"===n||"."===n?(n=" ",a=!0):0===t?(n=n.toUpperCase(),a=!0):!o&&a&&i.length>0&&i.push(" "),i.push(n),o=a;return i.join("")};t.dasherize=s,t.camelize=u,t.humanize=c,t.titleize=d,t.underscore=l,t.captionize=f},function(e,t,n){function i(e){return e&&e.__esModule?e:{"default":e}}var o=n(2),a=i(o),r=n(1),s=n(6),l=n(171),u=n(43),c=n(3),d=n(0),h=n(22),f=n(20),p=n(4),g=n(168),_=i(g),m=n(42),v=n(65),y=i(v),b=n(48),x=n(7),w=n(5),C=i(w),k="dx-selection-disabled",S="dx-datagrid-group-opened",I="dx-datagrid-group-closed",D="dx-datagrid-expand",T="nodata",E={year:function(e){return e&&e.getFullYear()},month:function(e){return e&&e.getMonth()+1},day:function(e){return e&&e.getDate()},quarter:function(e){return e&&Math.floor(e.getMonth()/3)+1},hour:function(e){return e&&e.getHours()},minute:function(e){return e&&e.getMinutes()},second:function(e){return e&&e.getSeconds()}};e.exports=function(){var t=function(){var e=arguments[1],t=this.calculateCellValue(e);if(!(0,r.isDefined)(t))return null;if(i(this.dataType)){var n=arguments[0];return E[n](t)}if("number"===this.dataType){var o=arguments[0];return Math.floor(Number(t)/o)*o}},n=function(e,t){return(0,r.isFunction)(e)&&(0,r.isFunction)(t)&&e.originalCallback&&t.originalCallback?e.originalCallback===t.originalCallback&&e.columnIndex===t.columnIndex:e===t},i=function(e){return"date"===e||"datetime"===e},o=function(e){e.get(0).textContent="\xa0"},g=function(e){var t=e.data&&e.data(),n=t&&t.dxComponents,i=n&&n[0];return i&&t[i]};return{renderNoDataText:function(e){var t=this;if(e=e||this.element()){var n=t.addWidgetPrefix(T),i=e.find("."+n).last(),o=this._dataController.isEmpty(),r=this._dataController.isLoading();i.length||(i=(0,a.default)("<span>").addClass(n).appendTo(e)),o&&!r?i.removeClass("dx-hidden").text(t._getNoDataText()):i.addClass("dx-hidden")}},renderLoadPanel:function(e,t,n){var i,o=this;o._loadPanel&&o._loadPanel.$element().remove(),i=o.option("loadPanel"),i&&("auto"===i.enabled?!n:i.enabled)?(i=(0,d.extend)({shading:!1,message:i.text,position:function(){var t=(0,a.default)((0,x.getWindow)());return e.height()>t.height()?{of:t,boundary:e,collision:"fit"}:{of:e}},container:t},i),o._loadPanel=o._createComponent((0,a.default)("<div>").appendTo(t),_.default,i)):o._loadPanel=null},getIndexByKey:function(e,t,n){var i=-1;if(void 0!==e&&Array.isArray(t)){n=arguments.length<=2?"key":n;for(var o=0;o<t.length;o++){var a=(0,r.isDefined)(n)?t[o][n]:t[o];if((0,p.equalByValue)(e,a)){i=o;break}}}return i},combineFilters:function(e,t){var n=[];t=t||"and";for(var i=0;i<e.length;i++)e[i]&&(n.length&&n.push(t),n.push(e[i]));if(1===n.length&&(n=n[0]),n.length)return n},checkChanges:function(e,t){for(var n=0,i=0;i<t.length;i++)e[t[i]]&&n++;return e.length&&e.length===n},equalFilterParameters:function(t,n){if(Array.isArray(t)&&Array.isArray(n)){if(t.length!==n.length)return!1;for(var i=0;i<t.length;i++)if(!e.exports.equalFilterParameters(t[i],n[i]))return!1;return!0}return(0,r.isFunction)(t)&&t.columnIndex>=0&&(0,r.isFunction)(n)&&n.columnIndex>=0?t.columnIndex===n.columnIndex&&(0,f.toComparable)(t.filterValue)===(0,f.toComparable)(n.filterValue):(0,f.toComparable)(t)==(0,f.toComparable)(n)},proxyMethod:function(e,t,n){e[t]||(e[t]=function(){var e=this._dataSource;return e?e[t].apply(e,arguments):n})},formatValue:function(e,t){var n=y.default.format(e,t.format)||e&&e.toString()||"",i={value:e,valueText:t.getDisplayFormat?t.getDisplayFormat(n):n,target:t.target||"row",groupInterval:t.groupInterval};return t.customizeText?t.customizeText.call(t,i):i.valueText},getFormatOptionsByColumn:function(e,t){return{format:e.format,getDisplayFormat:e.getDisplayFormat,customizeText:e.customizeText,target:t,trueText:e.trueText,falseText:e.falseText}},getDisplayValue:function(e,t,n,i){return e.displayValueMap&&void 0!==e.displayValueMap[t]?e.displayValueMap[t]:e.calculateDisplayValue&&n&&"group"!==i?e.calculateDisplayValue(n):!e.lookup||"group"===i&&(e.calculateGroupValue||e.calculateDisplayValue)?t:e.lookup.calculateCellValue(t)},getGroupRowSummaryText:function(t,n){for(var i="(",o=0;o<t.length;o++){var a=t[o];i+=(o>0?", ":"")+e.exports.getSummaryText(a,n)}return i+=")"},getSummaryText:function(e,t){var n=e.displayFormat||e.columnCaption&&t[e.summaryType+"OtherColumn"]||t[e.summaryType];return this.formatValue(e.value,{format:e.valueFormat,getDisplayFormat:function(t){return n?(0,u.format)(n,t,e.columnCaption):t},customizeText:e.customizeText})},normalizeSortingInfo:function(e){e=e||[];for(var t=(0,m.normalizeSortingInfo)(e),n=0;n<e.length;n++)e&&e[n]&&void 0!==e[n].isExpanded&&(t[n].isExpanded=e[n].isExpanded),e&&e[n]&&void 0!==e[n].groupInterval&&(t[n].groupInterval=e[n].groupInterval);return t},getFormatByDataType:function(e){switch(e){case"date":return"shortDate";case"datetime":return"shortDateShortTime"}},getHeaderFilterGroupParameters:function(e,n){var i=[],o=e.dataField||e.name,a=(0,l.getGroupInterval)(e);return a?((0,c.each)(a,function(r,s){i.push(n?{selector:o,groupInterval:s,isExpanded:r<a.length-1}:t.bind(e,s))}),i):(n?i=[{selector:o,isExpanded:!1}]:(i=function t(n){var t=e.calculateCellValue(n);return void 0!==t&&""!==t||(t=null),t},e.sortingMethod&&(i=[{selector:i,compare:e.sortingMethod.bind(e)}])),i)},equalSortParameters:function(t,i,o){if(t=e.exports.normalizeSortingInfo(t),i=e.exports.normalizeSortingInfo(i),Array.isArray(t)&&Array.isArray(i)){if(t.length!==i.length)return!1;for(var a=0;a<t.length;a++)if(!n(t[a].selector,i[a].selector)||t[a].desc!==i[a].desc||t[a].groupInterval!==i[a].groupInterval||!o&&Boolean(t[a].isExpanded)!==Boolean(i[a].isExpanded))return!1;return!0}return(!t||!t.length)==(!i||!i.length)},getPointsByColumns:function(e,t,n,i){for(var o,a,r,s=e.length,l=!1,u=i||0,c=[],d=0;d<=s;d++){d<s&&(o=e.eq(d),a=o.offset(),r="rtl"===o.css("direction"));var f={index:u,x:a?a.left+(!n&&r^d===s?(0,h.getBoundingRect)(o[0]).width:0):0,y:a?a.top+(n&&d===s?(0,h.getBoundingRect)(o[0]).height:0):0,columnIndex:u};if(!n&&d>0){var p=e.eq(d-1).offset();p.top<f.y&&(f.y=p.top)}t&&(l=t(f)),l||c.push(f),u++}return c},createObjectWithChanges:function(e,t){var n=e?Object.create(Object.getPrototypeOf(e)):{},i=(0,d.extendFromObject)({},e);return(0,b.deepExtendArraySafe)(n,i,!0,!0),(0,b.deepExtendArraySafe)(n,t,!0,!0)},getExpandCellTemplate:function(){return{allowRenderToDetachedContainer:!0,render:function(e,t){var n=(0,a.default)(e);if(!(0,r.isDefined)(t.value)||t.data&&t.data.isContinuation||t.row.isNewRow)o(n);else{var i=t.component.getView("rowsView");n.addClass(D).addClass(k),(0,a.default)("<div>").addClass(t.value?S:I).appendTo(n),i.setAria("label",t.value?i.localize("dxDataGrid-ariaCollapse"):i.localize("dxDataGrid-ariaExpand"),n)}}}},setEmptyText:o,isDateType:i,getSelectionRange:function(e){try{if(e)return{selectionStart:e.selectionStart,selectionEnd:e.selectionEnd}}catch(e){}return{}},setSelectionRange:function(e,t){try{e&&e.setSelectionRange&&e.setSelectionRange(t.selectionStart,t.selectionEnd)}catch(e){}},focusAndSelectElement:function(e,t){C.default.trigger(t,"focus");var n=e.option("editing.selectTextOnEditStart"),i=e.getController("keyboardNavigation"),o=i&&i._isFastEditingStarted();if(n&&!o&&t.is(".dx-texteditor-input")){var a=g(t.closest(".dx-texteditor"));(0,s.when)(a&&a._loadItemDeferred).done(function(){t.get(0).select()})}},getWidgetInstance:g,getLastResizableColumnIndex:function(e,t){for(var n=e.some(function(e){return e&&!e.command&&!e.fixed&&e.allowResizing!==!1}),i=e.length-1;e[i];i--){var o=e[i],a=t&&t[i],r=!n||o.allowResizing!==!1;if(!o.command&&!o.fixed&&"adaptiveHidden"!==a&&r)break}return i},isElementInCurrentGrid:function(e,t){if(t&&t.length){var n=t.closest("."+e.getWidgetContainerClass()).parent();return n.is(e.component.$element())}return!1}}}()},function(e,t,n){var i=n(15),o=i.inherit({ctor:function(e){e&&(e=String(e)),this._value=this._normalize(e||this._generate())},_normalize:function(e){for(e=e.replace(/[^a-f0-9]/gi,"").toLowerCase();e.length<32;)e+="0";return[e.substr(0,8),e.substr(8,4),e.substr(12,4),e.substr(16,4),e.substr(20,12)].join("-")},_generate:function(){for(var e="",t=0;t<32;t++)e+=Math.round(15*Math.random()).toString(16);return e},toString:function(){return this._value},valueOf:function(){return this._value},toJSON:function(){return this._value}});e.exports=o},function(e,t,n){function i(e){"@babel/helpers - typeof";return(i="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}function o(e){return e&&e.__esModule?e:{"default":e}}function a(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}function r(e,t){for(var n=0;n<t.length;n++){var i=t[n];i.enumerable=i.enumerable||!1,i.configurable=!0,"value"in i&&(i.writable=!0),Object.defineProperty(e,i.key,i)}}function s(e,t,n){return t&&r(e.prototype,t),n&&r(e,n),e}function l(e,t,n){return(l="undefined"!=typeof Reflect&&Reflect.get?Reflect.get:function(e,t,n){var i=u(e,t);if(i){var o=Object.getOwnPropertyDescriptor(i,t);return o.get?o.get.call(n):o.value}})(e,t,n||e)}function u(e,t){for(;!Object.prototype.hasOwnProperty.call(e,t)&&(e=_(e),null!==e););return e}function c(e,t){if("function"!=typeof t&&null!==t)throw new TypeError("Super expression must either be null or a function");e.prototype=Object.create(t&&t.prototype,{constructor:{value:e,writable:!0,configurable:!0}}),t&&d(e,t)}function d(e,t){return(d=Object.setPrototypeOf||function(e,t){return e.__proto__=t,
e})(e,t)}function h(e){var t=g();return function(){var n,i=_(e);if(t){var o=_(this).constructor;n=Reflect.construct(i,arguments,o)}else n=i.apply(this,arguments);return f(this,n)}}function f(e,t){return!t||"object"!==i(t)&&"function"!=typeof t?p(e):t}function p(e){if(void 0===e)throw new ReferenceError("this hasn't been initialised - super() hasn't been called");return e}function g(){if("undefined"==typeof Reflect||!Reflect.construct)return!1;if(Reflect.construct.sham)return!1;if("function"==typeof Proxy)return!0;try{return Date.prototype.toString.call(Reflect.construct(Date,[],function(){})),!0}catch(e){return!1}}function _(e){return(_=Object.setPrototypeOf?Object.getPrototypeOf:function(e){return e.__proto__||Object.getPrototypeOf(e)})(e)}var m=n(2),v=o(m),y=n(16),b=o(y),x=n(5),w=o(x),C=n(75),k=o(C),S=n(9),I=o(S),D=n(32),T=o(D),E=n(88),A=o(E),O=n(17),P=o(O),R=n(8),B=n(0),M=n(111),V=n(58),F=n(12),L=n(19),H=function(e){function t(){var e;a(this,t);for(var i=arguments.length,o=new Array(i),r=0;r<i;r++)o[r]=arguments[r];return e=n.call.apply(n,[this].concat(o)),e._feedbackHideTimeout=100,e}c(t,e);var n=h(t);return s(t,[{key:"_clean",value:function(){delete this._inkRipple,delete this._$content,l(_(t.prototype),"_clean",this).call(this)}},{key:"_defaultOptionsRules",value:function(){return l(_(t.prototype),"_defaultOptionsRules",this).call(this).concat([{device:function(){return"desktop"===b.default.real().deviceType&&!b.default.isSimulator()},options:{focusStateEnabled:!0}},{device:function(){return T.default.isMaterial(T.default.current())},options:{useInkRipple:!0}}])}},{key:"_executeClickAction",value:function(e){this._clickAction({validationGroup:this._validationGroupConfig,event:e})}},{key:"_findGroup",value:function(){var e=this.$element();return this.option("validationGroup")||A.default.findGroup(e,this._modelByElement(e))}},{key:"_getAnonymousTemplateName",value:function(){return"content"}},{key:"_getContentData",value:function(){var e=this.option(),t=e.icon,n=e.text,i=e.type,o=e._templateData;return(0,B.extend)({icon:"back"!==i||t?t:"back",text:n},o)}},{key:"_getDefaultOptions",value:function(){return(0,B.extend)(l(_(t.prototype),"_getDefaultOptions",this).call(this),{hoverStateEnabled:!0,onClick:null,type:"normal",text:"",icon:"",iconPosition:"left",validationGroup:void 0,activeStateEnabled:!0,template:"content",useSubmitBehavior:!1,useInkRipple:!1,_templateData:{},stylingMode:"contained"})}},{key:"_getSubmitAction",value:function(){var e=this;return this._createAction(function(t){var n=t.event;if(e._needValidate){var i=e._validationGroupConfig;if(i){var o=i.validate(),a=o.status,r=o.complete;e._validationStatus=a,"pending"===a&&(e._needValidate=!1,e._setDisabled(!0),e._waitForValidationCompleting(r))}}"valid"!==e._validationStatus&&n.preventDefault(),n.stopPropagation()})}},{key:"_initMarkup",value:function(){this.$element().addClass("dx-button"),this._renderType(),this._renderStylingMode(),this.option("useInkRipple")&&this._renderInkRipple(),this._renderClick(),this.setAria("role","button"),this._updateAriaLabel(),l(_(t.prototype),"_initMarkup",this).call(this),this._updateContent()}},{key:"_initTemplates",value:function(){var e=this;l(_(t.prototype),"_initTemplates",this).call(this),this._defaultTemplates.content=new M.FunctionTemplate(function(t){var n=t.model,i=void 0===n?{}:n,o=t.container,a=i.text,r=i.icon,s=(0,V.getImageContainer)(r),l=a&&(0,v.default)("<span>").text(a).addClass("dx-button-text"),u=(0,v.default)(o);u.append(l),"left"===e.option("iconPosition")?u.prepend(s):(s.addClass("dx-icon-right"),u.append(s))})}},{key:"_optionChanged",value:function(e){var n=e.name,i=e.previousValue;switch(n){case"onClick":this._renderClick();break;case"icon":case"text":this._updateContent(),this._updateAriaLabel();break;case"type":this._refreshType(i),this._updateContent(),this._updateAriaLabel();break;case"_templateData":break;case"template":case"iconPosition":this._updateContent();break;case"stylingMode":this._renderStylingMode();break;case"useInkRipple":case"useSubmitBehavior":this._invalidate();break;default:l(_(t.prototype),"_optionChanged",this).call(this,e)}}},{key:"_refreshType",value:function(e){var t=this.option("type"),n=this.$element();e&&n.removeClass("dx-button-".concat(e)).addClass("dx-button-".concat(t)),n.hasClass("dx-button-has-icon")||"back"!==t||this._updateContent()}},{key:"_renderClick",value:function(){var e={excludeValidators:["readOnly"]};this.option("useSubmitBehavior")&&(e.afterExecute=function(e){var t=e.component;return setTimeout(function(){return t._$submitInput.get(0).click()})}),this._clickAction=this._createActionByOption("onClick",e);var t=this.$element(),n=(0,R.addNamespace)(L.name,this.NAME);w.default.off(t,n),w.default.on(t,n,this._executeClickAction.bind(this))}},{key:"_renderInkRipple",value:function(){var e=this.option(),t=e.text,n=e.icon,i=e.type,o=!t&&n||"back"===i,a={};o&&(0,B.extend)(a,{waveSizeCoefficient:1,useHoldAnimation:!1,isCentered:!0}),this._inkRipple=k.default.render(a)}},{key:"_renderStylingMode",value:function(){var e=this.$element(),t=this.option("stylingMode"),n="dx-button-mode-".concat(t);if(["dx-button-mode-contained","dx-button-mode-text","dx-button-mode-outlined"].forEach(e.removeClass.bind(e)),["contained","text","outlined"].indexOf(t)===-1){var i=this._getDefaultOptions().stylingMode;n="dx-button-mode-".concat(i)}e.addClass(n)}},{key:"_renderSubmitInput",value:function(){var e=this._getSubmitAction();this._needValidate=!0,this._validationStatus="valid",this._$submitInput=(0,v.default)("<input>").attr("type","submit").attr("tabindex",-1).addClass("dx-button-submit-input").appendTo(this._$content),w.default.on(this._$submitInput,"click",function(t){return e({event:t})})}},{key:"_renderType",value:function(){var e=this.option("type");e&&this.$element().addClass("dx-button-".concat(e))}},{key:"_setDisabled",value:function(e){this.option("disabled",e)}},{key:"_supportedKeys",value:function(){var e=this,n=function(t){t.preventDefault(),e._executeClickAction(t)};return(0,B.extend)(l(_(t.prototype),"_supportedKeys",this).call(this),{space:n,enter:n})}},{key:"_toggleActiveState",value:function(e,n,i){if(l(_(t.prototype),"_toggleActiveState",this).call(this,e,n,i),this._inkRipple){var o={element:this._$content,event:i};n?this._inkRipple.showWave(o):this._inkRipple.hideWave(o)}}},{key:"_updateAriaLabel",value:function(){var e=this.option("icon"),t=this.option("text");"image"===(0,V.getImageSourceType)(e)&&(e=e.indexOf("base64")===-1?e.replace(/.+\/([^.]+)\..+$/,"$1"):"Base64");var n=t||e||"";n=n.toString().trim(),this.setAria("label",n.length?n:null)}},{key:"_updateContent",value:function(){var e=this.$element(),t=this._getContentData(),n=t.icon,i=t.text;this._$content?this._$content.empty():this._$content=(0,v.default)("<div>").addClass("dx-button-content").appendTo(e),e.toggleClass("dx-button-has-icon",!!n).toggleClass("dx-button-icon-right",!!n&&"left"!==this.option("iconPosition")).toggleClass("dx-button-has-text",!!i);var o=this._getAnonymousTemplateName()===this.option("template"),a=this._getTemplateByOption("template"),r=(0,v.default)(a.render({model:t,container:(0,F.getPublicElement)(this._$content),transclude:o}));r.hasClass("dx-template-wrapper")&&(this._$content.replaceWith(r),this._$content=r,this._$content.addClass("dx-button-content")),this.option("useSubmitBehavior")&&this._renderSubmitInput()}},{key:"_waitForValidationCompleting",value:function(e){var t=this;e.then(function(e){return t._validationStatus=e.status,t._setDisabled(!1),"valid"===t._validationStatus&&t._$submitInput.get(0).click(),t._needValidate=!0,e})}},{key:"_validationGroupConfig",get:function(){return A.default.getGroupConfig(this._findGroup())}}]),t}(P.default);(0,I.default)("dxButton",H),e.exports=H},function(e,t,n){function i(e){return e&&e.__esModule?e:{"default":e}}var o=n(55),a=i(o),r=n(1),s=n(3),l=i(s),u=n(14),c=n(21),d=i(c),h=n(221),f=n(189),p=n(213),g=n(222),_=i(g),m=n(451),v=i(m),y=n(77),b=n(49),x=i(b),w=n(452),C=i(w),k=0,S="undefined"!=typeof Intl,I={shortdate:"M/d/y",shorttime:"h:mm a",longdate:"EEEE, MMMM d, y",longtime:"h:mm:ss a",monthandday:"MMMM d",monthandyear:"MMMM y",quarterandyear:"QQQ y",day:"d",year:"y",shortdateshorttime:"M/d/y, h:mm a",longdatelongtime:"EEEE, MMMM d, y, h:mm:ss a",month:"LLLL",shortyear:"yy",dayofweek:"EEEE",quarter:"QQQ",hour:"HH",minute:"mm",second:"ss",millisecond:"SSS","datetime-local":"yyyy-MM-ddTHH':'mm':'ss"},D={year:["y","yy","yyyy"],day:["d","dd"],month:["M","MM","MMM","MMMM"],hours:["H","HH","h","hh","ah"],minutes:["m","mm"],seconds:["s","ss"],milliseconds:["S","SS","SSS"]},T=(0,a.default)({engine:function(){return"base"},_getPatternByFormat:function(e){return I[e.toLowerCase()]},_expandPattern:function(e){return this._getPatternByFormat(e)||e},formatUsesMonthName:function(e){return this._expandPattern(e).indexOf("MMMM")!==-1},formatUsesDayName:function(e){return this._expandPattern(e).indexOf("EEEE")!==-1},getFormatParts:function(e){var t=this._getPatternByFormat(e)||e,n=[];return l.default.each(t.split(/\W+/),function(e,t){l.default.each(D,function(e,i){(0,u.inArray)(t,i)>-1&&n.push(e)})}),n},getMonthNames:function(e){return _.default.getMonthNames(e)},getDayNames:function(e){return _.default.getDayNames(e)},getQuarterNames:function(e){return _.default.getQuarterNames(e)},getPeriodNames:function(e){return _.default.getPeriodNames(e)},getTimeSeparator:function(){return":"},is24HourFormat:function(e){for(var t=new Date(2017,0,20,11,0,0,0),n=new Date(2017,0,20,23,0,0,0),i=this.format(t,e),o=this.format(n,e),a=0;a<i.length;a++)if(i[a]!==o[a])return!isNaN(parseInt(i[a]))},format:function(e,t){if(e){if(!t)return e;var n;if("function"==typeof t)n=t;else if(t.formatter)n=t.formatter;else if(t=t.type||t,(0,r.isString)(t))return t=I[t.toLowerCase()]||t,x.default.convertDigits((0,h.getFormatter)(t,this)(e));if(n)return n(e)}},parse:function(e,t){var n,i=this;if(e){if(!t)return this.parse(e,"shortdate");if(t.parser)return t.parser(e);if("string"!=typeof t||I[t.toLowerCase()]){var o=function(e){var n=i.format(e,t);return x.default.convertDigits(n,!0)};try{n=(0,f.getFormat)(o)}catch(e){}}else n=t;if(n)return e=x.default.convertDigits(e,!0),(0,p.getParser)(n,this)(e);d.default.log("W0012");var a=new Date(e);if(a&&!isNaN(a.getTime()))return a}},firstDayOfWeekIndex:function(){var e=(0,y.getValueByClosestLocale)(function(e){return v.default[e]});return void 0===e?k:e}});S&&T.inject(C.default),e.exports=T},function(e,t,n){var i=n(128),o=n(21),a={},r=i(o.ERROR_MESSAGES,{E4000:"[DevExpress.data]: {0}",E4001:"Unknown aggregating function is detected: '{0}'",E4002:"Unsupported OData protocol version is used",E4003:"Unknown filter operation is used: {0}",E4004:"The thenby() method is called before the sortby() method",E4005:"Store requires a key expression for this operation",E4006:"ArrayStore 'data' option must be an array",E4007:"Compound keys cannot be auto-generated",E4008:"Attempt to insert an item with the a duplicated key",E4009:"Data item cannot be found",E4010:"CustomStore does not support creating queries",E4011:"Custom Store method is not implemented or is not a function: {0}",E4012:"Custom Store method returns an invalid value: {0}",E4013:"Local Store requires the 'name' configuration option is specified",E4014:"Unknown data type is specified for ODataStore: {0}",E4015:"Unknown entity name or alias is used: {0}",E4016:"The compileSetter(expr) method is called with 'self' passed as a parameter",E4017:"Keys cannot be modified",E4018:"The server has returned a non-numeric value in a response to an item count request",E4019:"Mixing of group operators inside a single group of filter expression is not allowed",E4020:"Unknown store type is detected: {0}",E4021:"The server response does not provide the totalCount value",E4022:"The server response does not provide the groupCount value",E4023:"Could not parse the following XML: {0}",E4024:"String function {0} cannot be used with the data field {1} of type {2}.",W4000:"Data returned from the server has an incorrect structure",W4001:'The {0} field is listed in both "keyType" and "fieldTypes". The value of "fieldTypes" is used.',W4002:"Data loading has failed for some cells due to the following error: {0}"}),s=null,l=function(e){a.errorHandler&&a.errorHandler(e)};a={errors:r,errorHandler:s,_errorHandler:l},e.exports=a},function(e,t,n){var i,o=n(181),a=n(11),r=n(5),s=n(182),l=new o,u=new s,c=function(){},d=function(){},h=t.setDataStrategy=function(e){u.fire(e),i=e;var t=i.cleanData;i.cleanData=function(e){c(e);var n=t.call(this,e);return d(e),n}};h({data:function(){var e=arguments[0],t=arguments[1],n=arguments[2];if(e){var i=l.get(e);return i||(i={},l.set(e,i)),void 0===t?i:2===arguments.length?i[t]:(i[t]=n,n)}},removeData:function(e,t){if(e)if(void 0===t)l.delete(e);else{var n=l.get(e);n&&delete n[t]}},cleanData:function(e){for(var t=0;t<e.length;t++)r.off(e[t]),l.delete(e[t])}}),t.setDataStrategy=h,t.getDataStrategy=function(){return i},t.data=function(){return i.data.apply(this,arguments)},t.strategyChanging=u,t.beforeCleanData=function(e){c=e},t.afterCleanData=function(e){d=e},t.cleanData=function(e){return i.cleanData.call(this,e)},t.removeData=function(e,t){return i.removeData.call(this,e,t)},t.cleanDataRecursive=function(e,t){if(a.isElementNode(e)){var n=e.getElementsByTagName("*");i.cleanData(n),t&&i.cleanData([e])}}},function(e,t,n){function i(e){"@babel/helpers - typeof";return(i="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}var o=n(2),a=n(7).getWindow(),r=n(5),s=n(21),l=n(12).getPublicElement,u=n(0).extend,c=n(1),d=n(3),h=n(29),f=n(229),p=n(113),g=n(45),_=n(79),m=n(137),v=n(8),y=n(6),b=y.when,x=y.Deferred,w=v.addNamespace(m,"dxFX"),C=c.isFunction,k=c.isPlainObject,S=n(4).noop,I=/^([+-])=(.*)/i,D="dxAnimData",T="dxAnimQueue",E="transform",A={initAnimation:function(e,t){e.css({transitionProperty:"none"}),"string"==typeof t.from?e.addClass(t.from):ue(e,t.from);var n=this,i=new x,o=t.cleanupWhen;t.transitionAnimation={deferred:i,finish:function(){n._finishTransition(e),o?b(i,o).always(function(){n._cleanup(e,t)}):n._cleanup(e,t),i.resolveWith(e,[t,e])}},this._completeAnimationCallback(e,t).done(function(){t.transitionAnimation.finish()}).fail(function(){i.rejectWith(e,[t,e])}),t.duration||t.transitionAnimation.finish(),e.css("transform")},animate:function(e,t){return this._startAnimation(e,t),t.transitionAnimation.deferred.promise()},_completeAnimationCallback:function(e,t){var n,i=this,o=Date.now()+t.delay,a=new x,s=new x,l=new x,u=g.transitionEndEventName()+".dxFX";t.transitionAnimation.cleanup=function(){clearTimeout(n),clearTimeout(c),r.off(e,u),r.off(e,w)},r.one(e,u,function(){Date.now()-o>=t.duration&&s.reject()}),r.off(e,w),r.on(e,w,function(){i.stop(e,t),a.reject()});var c=setTimeout(function(){n=setTimeout(function(){l.reject()},t.duration+t.delay+de._simulatedTransitionEndDelay),b(s,l).fail(function(){a.resolve()}.bind(this))});return a.promise()},_startAnimation:function(e,t){e.css({transitionProperty:"all",transitionDelay:t.delay+"ms",transitionDuration:t.duration+"ms",transitionTimingFunction:t.easing}),"string"==typeof t.to?e[0].className+=" "+t.to:t.to&&ue(e,t.to)},_finishTransition:function(e){e.css("transition","none")},_cleanup:function(e,t){t.transitionAnimation.cleanup(),"string"==typeof t.from&&(e.removeClass(t.from),e.removeClass(t.to))},stop:function(e,t,n){t&&(n?t.transitionAnimation.finish():(k(t.to)&&d.each(t.to,function(t){e.css(t,e.css(t))}),this._finishTransition(e),this._cleanup(e,t)))}},O={initAnimation:function(e,t){ue(e,t.from)},animate:function(e,t){var n=new x,i=this;return t?(d.each(t.to,function(n){void 0===t.from[n]&&(t.from[n]=i._normalizeValue(e.css(n)))}),t.to[E]&&(t.from[E]=i._parseTransform(t.from[E]),t.to[E]=i._parseTransform(t.to[E])),t.frameAnimation={to:t.to,from:t.from,currentValue:t.from,easing:f.convertTransitionTimingFuncToEasing(t.easing),duration:t.duration,startTime:(new Date).valueOf(),finish:function(){this.currentValue=this.to,this.draw(),p.cancelAnimationFrame(t.frameAnimation.animationFrameId),n.resolve()},draw:function(){if(t.draw)return void t.draw(this.currentValue);var n=u({},this.currentValue);n[E]&&(n[E]=d.map(n[E],function(e,t){return"translate"===t?h.getTranslateCss(e):"scale"===t?"scale("+e+")":"rotate"===t.substr(0,t.length-1)?t+"("+e+"deg)":void 0}).join(" ")),e.css(n)}},t.delay?(t.frameAnimation.startTime+=t.delay,t.frameAnimation.delayTimeout=setTimeout(function(){i._startAnimation(e,t)},t.delay)):i._startAnimation(e,t),n.promise()):n.reject().promise()},_startAnimation:function(e,t){r.off(e,w),r.on(e,w,function(){t.frameAnimation&&p.cancelAnimationFrame(t.frameAnimation.animationFrameId)}),this._animationStep(e,t)},_parseTransform:function(e){var t={};return d.each(e.match(/(\w|\d)+\([^)]*\)\s*/g),function(e,n){var i=h.parseTranslate(n),o=n.match(/scale\((.+?)\)/),a=n.match(/(rotate.)\((.+)deg\)/);i&&(t.translate=i),o&&o[1]&&(t.scale=parseFloat(o[1])),a&&a[1]&&(t[a[1]]=parseFloat(a[2]))}),t},stop:function(e,t,n){var i=t&&t.frameAnimation;i&&(p.cancelAnimationFrame(i.animationFrameId),clearTimeout(i.delayTimeout),n&&i.finish(),delete t.frameAnimation)},_animationStep:function(e,t){var n=t&&t.frameAnimation;if(n){var i=(new Date).valueOf();if(i>=n.startTime+n.duration)return void n.finish();n.currentValue=this._calcStepValue(n,i-n.startTime),n.draw();var o=this;n.animationFrameId=p.requestAnimationFrame(function(){o._animationStep(e,t)})}},_calcStepValue:function(e,t){var n=function n(o,a){var r=Array.isArray(a)?[]:{},s=function(n){var i=t/e.duration,r=t,s=1*o[n],l=a[n]-o[n],u=e.duration;return f.getEasing(e.easing)(i,r,s,l,u)};return d.each(a,function(e,t){return"string"==typeof t&&parseFloat(t,10)===!1||void(r[e]="object"===i(t)?n(o[e],t):s(e))}),r};return n(e.from,e.to)},_normalizeValue:function(e){var t=parseFloat(e,10);return t===!1?e:t}},P={initAnimation:function(){},animate:function(){return(new x).resolve().promise()},stop:S,isSynchronous:!0},R=function(e){e=e||{};var t={transition:g.transition()?A:O,frame:O,noAnimation:P},n=e.strategy||"transition";return"css"!==e.type||g.transition()||(n="noAnimation"),t[n]},B=function(e,t,n,i){d.each(["from","to"],function(){if(!n(e[this]))throw s.Error("E0010",t,this,i)})},M=function(e,t){return B(e,t,function(e){return k(e)},"a plain object")},V=function(e,t){return B(e,t,function(e){return"string"==typeof e},"a string")},F={setup:function(){}},L={validateConfig:function(e){V(e,"css")},setup:function(){}},H={top:{my:"bottom center",at:"top center"},bottom:{my:"top center",at:"bottom center"},right:{my:"left center",at:"right center"},left:{my:"right center",at:"left center"}},z={validateConfig:function(e){M(e,"slide")},setup:function(e,t){var n=h.locate(e);if("slide"!==t.type){var i="slideIn"===t.type?t.from:t.to;i.position=u({of:a},H[t.direction]),le(e,i)}this._setUpConfig(n,t.from),this._setUpConfig(n,t.to),h.clearCache(e)},_setUpConfig:function(e,t){t.left="left"in t?t.left:"+=0",t.top="top"in t?t.top:"+=0",this._initNewPosition(e,t)},_initNewPosition:function(e,t){var n={left:t.left,top:t.top};delete t.left,delete t.top;var i=this._getRelativeValue(n.left);void 0!==i?n.left=i+e.left:t.left=0,i=this._getRelativeValue(n.top),void 0!==i?n.top=i+e.top:t.top=0,t[E]=h.getTranslateCss({x:n.left,y:n.top})},_getRelativeValue:function(e){var t;if("string"==typeof e&&(t=I.exec(e)))return parseInt(t[1]+"1")*t[2]}},N={setup:function(e,t){var n,i=t.from,o=k(i)?t.skipElementInitialStyles?0:e.css("opacity"):String(i);switch(t.type){case"fadeIn":n=1;break;case"fadeOut":n=0;break;default:n=String(t.to)}t.from={visibility:"visible",opacity:o},t.to={opacity:n}}},$={validateConfig:function(e){M(e,"pop")},setup:function(e,t){var n=t.from,i=t.to,o="opacity"in n?n.opacity:e.css("opacity"),a="opacity"in i?i.opacity:1,r="scale"in n?n.scale:0,s="scale"in i?i.scale:1;t.from={opacity:o};var l=h.getTranslate(e);t.from[E]=this._getCssTransform(l,r),t.to={opacity:a},t.to[E]=this._getCssTransform(l,s)},_getCssTransform:function(e,t){return h.getTranslateCss(e)+"scale("+t+")"}},W={custom:F,slide:z,slideIn:z,slideOut:z,fade:N,fadeIn:N,fadeOut:N,pop:$,css:L},G=function(e){var t=W[e.type];if(!t)throw s.Error("E0011",e.type);return t},j={type:"custom",from:{},to:{},duration:400,start:S,complete:S,easing:"ease",delay:0},q={duration:400,easing:"ease",delay:0},K=function(){var e=this,t=e.element,n=e.config;if(le(t,n.from),le(t,n.to),e.configurator.setup(t,n),t.data(D,e),de.off&&(n.duration=0,n.delay=0),e.strategy.initAnimation(t,n),n.start){var i=l(t);n.start.apply(this,[i,n])}},U=function(e){var t=e.element,n=e.config;if(t.removeData(D),n.complete){var i=l(t);n.complete.apply(this,[i,n])}e.deferred.resolveWith(this,[t,n])},Y=function(){var e=this,t=e.element,n=e.config;return e.isStarted=!0,e.strategy.animate(t,n).done(function(){U(e)}).fail(function(){e.deferred.rejectWith(this,[t,n])})},X=function(e){var t=this,n=t.element,i=t.config;clearTimeout(t.startTimeout),t.isStarted||t.start(),t.strategy.stop(n,i,e)},Z=v.addNamespace(m,"dxFXStartAnimation"),Q=function(e){r.off(e.element,Z),r.on(e.element,Z,function(){de.stop(e.element)}),e.deferred.always(function(){r.off(e.element,Z)})},J=function(e,t){var n="css"===t.type?q:j,i=u(!0,{},n,t),a=G(i),r=R(i),s={element:o(e),config:i,configurator:a,strategy:r,isSynchronous:r.isSynchronous,setup:K,start:Y,stop:X,deferred:new x};return C(a.validateConfig)&&a.validateConfig(i),Q(s),s},ee=function(e,t){var n=o(e);if(!n.length)return(new x).resolve().promise();var i=J(n,t);return te(n,i),i.deferred.promise()},te=function(e,t){var n=ne(e);ie(e,n),n.push(t),ae(e)||re(e,n)},ne=function(e){return e.data(T)||[]},ie=function(e,t){e.data(T,t)},oe=function(e){e.removeData(T)},ae=function(e){return!!e.data(D)},re=function e(t,n){if(n=ne(t),n.length){var i=n.shift();0===n.length&&oe(t),se(i).done(function(){ae(t)||e(t)})}},se=function(e){return e.setup(),de.off||e.isSynchronous?e.start():e.startTimeout=setTimeout(function(){e.start()}),e.deferred.promise()},le=function(e,t){if(t&&t.position){var n=o(a),i=0,r=0,s=_.calculate(e,t.position),l=e.offset(),c=e.position();c.top>l.top&&(r=n.scrollTop()),c.left>l.left&&(i=n.scrollLeft()),u(t,{left:s.h.location-l.left+c.left-i,top:s.v.location-l.top+c.top-r}),delete t.position}},ue=function(e,t){d.each(t,function(t,n){try{e.css(t,c.isFunction(n)?n():n)}catch(e){}})},ce=function(e,t){var n=o(e),i=ne(n);d.each(i,function(e,t){t.config.delay=0,t.config.duration=0,t.isSynchronous=!0}),ae(n)||re(n,i);var a=n.data(D);a&&a.stop(t),n.removeData(D),oe(n)},de={off:!1,animationTypes:W,animate:ee,createAnimation:J,isAnimating:ae,stop:ce,_simulatedTransitionEndDelay:100};e.exports=de},function(e,t,n){function i(e){return e&&e.__esModule?e:{"default":e}}var o=n(2),a=i(o),r=n(5),s=i(r),l=n(15),u=i(l),c=n(27),d=i(c),h=n(4),f=n(1),p=n(14),g=n(3),_=n(18),m=i(_),v=n(10),y=i(v),b=n(7),x="dxDataGrid",w=u.default.inherit({_endUpdateCore:function(){},ctor:function(e){var t=this;t._updateLockCount=0,t.component=e,t._actions={},t._actionConfigs={},(0,g.each)(this.callbackNames()||[],function(e,n){var i=t.callbackFlags(n)||{};i.unique=!0,i.syncStrategy=!0,t[this]=(0,d.default)(i)})},init:function(){},callbackNames:function(){},callbackFlags:function(){},publicMethods:function(){},beginUpdate:function(){this._updateLockCount++},endUpdate:function(){this._updateLockCount>0&&(this._updateLockCount--,this._updateLockCount||this._endUpdateCore())},option:function(e){var t=this.component,n=t._optionCache;return 1===arguments.length&&n?(e in n||(n[e]=t.option(e)),n[e]):t.option.apply(t,arguments)},localize:function(e){var t=this.component._optionCache;return t?(e in t||(t[e]=y.default.format(e)),t[e]):y.default.format(e)},on:function(){return this.component.on.apply(this.component,arguments)},off:function(){return this.component.off.apply(this.component,arguments)},optionChanged:function(e){e.name in this._actions&&(this.createAction(e.name,this._actionConfigs[e.name]),e.handled=!0)},getAction:function(e){return this._actions[e]},setAria:function(e,t,n){var i=n.get(0),o="role"!==e&&"id"!==e?"aria-":"";i.setAttribute?i.setAttribute(o+e,t):n.attr(o+e,t)},_createComponent:function(){return this.component._createComponent.apply(this.component,arguments)},getController:function(e){return this.component._controllers[e]},createAction:function(e,t){if((0,f.isFunction)(e)){var n=this.component._createAction(e.bind(this),t);return function(e){n({event:e})}}this._actions[e]=this.component._createActionByOption(e,t),this._actionConfigs[e]=t},executeAction:function(e,t){var n=this._actions[e];return n&&n(t)},dispose:function(){var e=this;(0,g.each)(e.callbackNames()||[],function(){e[this].empty()})},addWidgetPrefix:function(e){var t=this.component.NAME;return"dx-"+t.slice(2).toLowerCase()+(e?"-"+e:"")},getWidgetContainerClass:function(){var e=this.component.NAME===x?null:"container";return this.addWidgetPrefix(e)}}),C=w,k=C.inherit({getView:function(e){return this.component._views[e]},getViews:function(){return this.component._views}}),S=w.inherit({_isReady:function(){return this.component.isReady()},_endUpdateCore:function(){this.callBase(),!this._isReady()&&this._requireReady&&(this._requireRender=!1,this.component._requireResize=!1),this._requireRender&&(this._requireRender=!1,this.render(this._$parent))},_invalidate:function(e,t){this._requireRender=!0,this.component._requireResize=(0,b.hasWindow)()&&(this.component._requireResize||e),this._requireReady=this._requireReady||t},_renderCore:function(){},_resizeCore:function(){},_afterRender:function(){},_parentElement:function(){return this._$parent},ctor:function(e){this.callBase(e),this.renderCompleted=(0,d.default)(),this.resizeCompleted=(0,d.default)()},element:function(){return this._$element},getElementHeight:function(){var e=this.element();if(!e)return 0;var t=parseFloat(e.css("marginTop"))||0,n=parseFloat(e.css("marginBottom"))||0,i=e.get(0).offsetHeight;return i+t+n},isVisible:function(){return!0},getTemplate:function(e){return this.component._getTemplate(e)},render:function(e,t){var n=this._$element,i=this.isVisible();(n||e)&&(this._requireReady=!1,n||(n=this._$element=(0,a.default)("<div>").appendTo(e),this._$parent=e),n.toggleClass("dx-hidden",!i),i&&(this.component._optionCache={},this._renderCore(t),this.component._optionCache=void 0,this._afterRender(e),this.renderCompleted.fire(t)))},resize:function(){this.isResizing=!0,this._resizeCore(),this.resizeCompleted.fire(),this.isResizing=!1},focus:function(){s.default.trigger(this.element(),"focus")}}),I=1e6,D=function(e,t){var n=t.modules,i=t.modulesOrder,o=t.controllerTypes||{},a=t.viewTypes||{};t.controllerTypes||(i&&n.sort(function(e,t){var n=(0,p.inArray)(e.name,i),o=(0,p.inArray)(t.name,i);return n<0&&(n=I),o<0&&(o=I),n-o}),(0,g.each)(n,function(){var e=this.controllers,t=this.name,n=this.views;e&&(0,g.each)(e,function(e,n){if(o[e])throw m.default.Error("E1001",t,e);if(!(n&&n.subclassOf&&n.subclassOf(C)))throw n.subclassOf(C),m.default.Error("E1002",t,e);o[e]=n}),n&&(0,g.each)(n,function(e,n){if(a[e])throw m.default.Error("E1003",t,e);if(!(n&&n.subclassOf&&n.subclassOf(S)))throw m.default.Error("E1004",t,e);a[e]=n})}),(0,g.each)(n,function(){var e=this.extenders;e&&(e.controllers&&(0,g.each)(e.controllers,function(e,t){o[e]&&(o[e]=o[e].inherit(t))}),e.views&&(0,g.each)(e.views,function(e,t){a[e]&&(a[e]=a[e].inherit(t))}))}),t.controllerTypes=o,t.viewTypes=a);var r=function(e,t,n){var i=n.publicMethods();i&&(0,g.each)(i,function(i,o){if(!n[o])throw m.default.Error("E1006",t,o);if(e[o])throw m.default.Error("E1005",o);e[o]=function(){return n[o].apply(n,arguments)}})},s=function(t){var n={};return(0,g.each)(t,function(t,i){var o=new i(e);o.name=t,r(e,t,o),n[t]=o}),n};e._controllers=s(o),e._views=s(a)},T=function(e,t,n){n=n||[],e._controllers&&(0,g.each)(e._controllers,function(){this[t]&&this[t].apply(this,n)}),e._views&&(0,g.each)(e._views,function(){this[t]&&this[t].apply(this,n)})};e.exports={modules:[],View:S,ViewController:k,Controller:C,registerModule:function(e,t){for(var n=this.modules,i=0;i<n.length;i++)if(n[i].name===e)return;t.name=e,n.push(t),delete this.controllerTypes,delete this.viewTypes},registerModulesOrder:function(e){this.modulesOrder=e},unregisterModule:function(e){this.modules=(0,h.grep)(this.modules,function(t){return t.name!==e}),delete this.controllerTypes,delete this.viewTypes},processModules:D,callModuleItemsMethod:T}},function(e,t,n){function i(e){return e&&e.__esModule?e:{"default":e}}function o(e){return l(e)||s(e)||r(e)||a()}function a(){throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}function r(e,t){if(e){if("string"==typeof e)return u(e,t);var n=Object.prototype.toString.call(e).slice(8,-1);return"Object"===n&&e.constructor&&(n=e.constructor.name),"Map"===n||"Set"===n?Array.from(e):"Arguments"===n||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)?u(e,t):void 0}}function s(e){if("undefined"!=typeof Symbol&&Symbol.iterator in Object(e))return Array.from(e)}function l(e){if(Array.isArray(e))return u(e)}function u(e,t){(null==t||t>e.length)&&(t=e.length);for(var n=0,i=new Array(t);n<t;n++)i[n]=e[n];return i}function c(e){return/^(or|\|\||\|)$/i.test(e)}function d(e){return/^(and|&&|&)$/i.test(e)}function h(e,t){var n,i;return function(){var o=this;return i=arguments,n||(n=setTimeout(function(){n=void 0,i&&e.call(o,i)},(0,p.isFunction)(t)?t():t)),n}}function f(e,t){var n=[],i=h(function(){e.call(this,n),n=[]},t);return function(e){if(Array.isArray(e)){var t;(t=n).push.apply(t,o(e))}return i.call(this,n)}}var p=n(1),g=i(p),_=n(11),m=i(_),v=n(52),y=n(7),b=n(3),x=n(6),w=n(4),C="DEVEXTREME_XHR_ERROR_UNLOAD",k=function(e){return[e[0],e.length<3?"=":String(e[1]).toLowerCase(),e.length<2||e[e.length-1]]},S=function(e){return Array.isArray(e)||(e=[e]),(0,b.map)(e,function(e){var t={selector:(0,p.isFunction)(e)||"string"==typeof e?e:e.getter||e.field||e.selector,desc:!(!e.desc&&"d"!==String(e.dir).charAt(0).toLowerCase())};return e.compare&&(t.compare=e.compare),t})},I=function(){var e,t={timeout:"Network connection timeout",error:"Unspecified network error",parsererror:"Unexpected server response"},n=function(e){var n=t[e];return n?n:e};return(0,v.add)(function(){var t=(0,y.getWindow)();m.default.listen(t,"beforeunload",function(){e=!0})}),function(t,i){return e?C:t.status<400?n(i):t.statusText}}(),D={count:{seed:0,step:function(e){return 1+e}},sum:{seed:0,step:function(e,t){return e+t}},min:{step:function(e,t){return t<e?t:e}},max:{step:function(e,t){return t>e?t:e}},avg:{seed:[0,0],step:function(e,t){return[e[0]+t,e[1]+1]},finalize:function(e){return e[1]?e[0]/e[1]:NaN}}},T=function(){var e,t=0,n=function(){0===t&&(e=new x.Deferred),t++},i=function(){t--,t<1&&e.resolve()},o=function(){var n=0===t?(new x.Deferred).resolve():e;return n.promise()},a=function(){t=0,e&&e.resolve()};return{obtain:n,release:i,promise:o,reset:a}}(),E=function(e,t){return(0,w.equalByValue)(e,t,0,!1)},A="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=",O=function(e){function t(e){return A.charAt(e)}Array.isArray(e)||(e=P(String(e)));for(var n="",i=0;i<e.length;i+=3){var o=e[i],a=e[i+1],r=e[i+2];n+=(0,b.map)([o>>2,(3&o)<<4|a>>4,isNaN(a)?64:(15&a)<<2|r>>6,isNaN(r)?64:63&r],t).join("")}return n},P=function(e){var t,n,i=[];for(n=0;n<e.length;n++)t=e.charCodeAt(n),t<128?i.push(t):t<2048?i.push(192+(t>>6),128+(63&t)):t<65536?i.push(224+(t>>12),128+(t>>6&63),128+(63&t)):t<2097152&&i.push(240+(t>>18),128+(t>>12&63),128+(t>>6&63),128+(63&t));return i},R=function(e){return"!"===e[0]&&Array.isArray(e[1])},B=function(e){return"and"===e||"or"===e},M=function(e){var t=e[0],n=e[1];return!!Array.isArray(t)||!(!g.default.isFunction(t)||!(Array.isArray(n)||g.default.isFunction(n)||B(n)));
},V=function(){var e=new x.Deferred;return e.resolve.apply(e,arguments).promise()},F=function(){var e=new x.Deferred;return e.reject.apply(e,arguments).promise()},L={XHR_ERROR_UNLOAD:C,normalizeBinaryCriterion:k,normalizeSortingInfo:S,errorMessageFromXhr:I,aggregators:D,keysEqual:E,throttleChanges:f,trivialPromise:V,rejectedPromise:F,isDisjunctiveOperator:c,isConjunctiveOperator:d,processRequestResultLock:T,isUnaryOperation:R,isGroupCriterion:M,base64_encode:O};e.exports=L},function(e,t,n){function i(e){"@babel/helpers - typeof";return(i="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}var o=n(1),a=function(){var e=[new RegExp("&","g"),new RegExp('"',"g"),new RegExp("'","g"),new RegExp("<","g"),new RegExp(">","g")];return function(t){return String(t).replace(e[0],"&amp;").replace(e[1],"&quot;").replace(e[2],"&#39;").replace(e[3],"&lt;").replace(e[4],"&gt;")}}(),r=function(e){switch(i(e)){case"string":return e.split(/\s+/,4);case"object":return[e.x||e.h||e.left,e.y||e.v||e.top,e.x||e.h||e.right,e.y||e.v||e.bottom];case"number":return[e];default:return e}},s=function(e){var t=r(e),n=parseInt(t&&t[0],10),i=parseInt(t&&t[1],10),o=parseInt(t&&t[2],10),a=parseInt(t&&t[3],10);return isFinite(n)||(n=0),isFinite(i)||(i=n),isFinite(o)||(o=n),isFinite(a)||(a=i),{top:i,right:o,bottom:a,left:n}},l=function(){var e,t,n,i=arguments[0],a=[].slice.call(arguments).slice(1);if(o.isFunction(i))return i.apply(this,a);for(var r=0;r<a.length;r++)t=new RegExp("\\{"+r+"\\}","gm"),n=a[r],"string"===o.type(n)&&n.indexOf("$")>=0&&(e="$".replace("$","$$").length,n=n.replace("$",1===e?"$$$$":"$$")),i=i.replace(t,n);return i},u=function(){var e=function(e){return(e+"").replace(/([+*?.[^\]$(){}><|=!:])/g,"\\$1")};return function(t,n,i){return t.replace(new RegExp("("+e(n)+")","gi"),i)}}(),c=function(){var e=/\s/g;return function(t){return!t||!t.replace(e,"")}}();t.encodeHtml=a,t.quadToObject=s,t.format=l,t.replaceAll=u,t.isEmpty=c},function(e,t,n){var i=n(157),o=n(488),a={array:i,remote:o},r=function(){var e=Array.isArray(arguments[0])?"array":"remote";return a[e].apply(this,arguments)};e.exports=r,e.exports.queryImpl=a},function(e,t,n){function i(e){return e&&e.__esModule?e:{"default":e}}var o=n(14),a=n(11),r=n(4),s=n(62),l=i(s),u=n(7),c=i(u),d=n(16),h=i(d),f=n(89),p=i(f),g=c.default.getNavigator(),_=g.maxTouchPoints,m=g.msMaxTouchPoints,v=g.pointerEnabled,y=c.default.hasProperty.bind(c.default),b={webkitTransition:"webkitTransitionEnd",MozTransition:"transitionend",OTransition:"oTransitionEnd",msTransition:"MsTransitionEnd",transition:"transitionend"},x=function(e){return!!p.default.styleProp(e)},w=function(){var e=h.default.real(),t=e.platform,n=e.version,i=e.mac,a=n&&n[0]<4&&"android"===t,r=!a&&(0,o.inArray)(t,["ios","android"])>-1||i;return r},C=function(e){if("text"===e)return!0;var t=(0,a.createElement)("input");try{return t.setAttribute("type",e),t.value="wrongValue",!t.value}catch(e){return!1}},k=function(e,t){return(e("ontouchstart")||!!t)&&!e("callPhantom")},S=function(e,t){var n=(0,r.ensureDefined)(t,!0),i=(0,r.ensureDefined)(t,!1);return e("PointerEvent")&&n||i},I=k(y,_),D=S(y,v),T=!!_||!!m;t.touchEvents=I,t.pointerEvents=D,t.touch=I||D&&T,t.transition=(0,l.default)(function(){return x("transition")}),t.transitionEndEventName=(0,l.default)(function(){return b[p.default.styleProp("transition")]}),t.animation=(0,l.default)(function(){return x("animation")}),t.nativeScrolling=w(),t.styleProp=p.default.styleProp,t.stylePropPrefix=p.default.stylePropPrefix,t.supportProp=x,t.inputType=C},function(e,t,n){function i(e){return e&&e.__esModule?e:{"default":e}}var o=n(29),a=i(o),r=n(9),s=i(r),l=n(16),u=i(l),c=n(12),d=i(c),h=n(2),f=i(h),p=n(99),g=n(14),_=n(23),m=i(_),v=n(4),y=n(0),b=n(33),x=n(3),w=n(178),C=i(w),k=n(22),S=n(1),I=n(53),D=n(7),T=i(D),E=n(10),A=i(E),O=n(36),P=i(O),R=n(60),B=i(R),M=n(32),V=i(M),F=T.default.getWindow();n(301);var L="dx-popup",H="dx-popup-wrapper",z="dx-popup-fullscreen",N="dx-popup-fullscreen-width",$="dx-popup-normal",W="dx-popup-content",G="dx-popup-draggable",j="dx-popup-title",q="dx-closebutton",K="dx-popup-bottom",U="dx-template-wrapper",Y="dx-popup-flex-height",X="dx-popup-inherit-height",Z=["cancel","clear","done"],Q="default",J="normal",ee="text",te="contained",ne=m.default.msie&&11===parseInt(m.default.version),ie=m.default.safari&&(0,I.compare)(m.default.version,[11])<0,oe={"static":"",inherit:X,flex:Y},ae=function(e){var t=u.default.current(),n=t.platform,i="bottom",o="before";if("ios"===n)switch(e){case"cancel":i="top";break;case"clear":i="top",o="after";break;case"done":o="after"}else if("android"===n&&t.version&&parseInt(t.version[0])>4)switch(e){case"cancel":o="after";break;case"done":o="after"}else"android"===n&&(o="center");return{toolbar:i,location:o}},re=B.default.inherit({_getDefaultOptions:function(){return(0,y.extend)(this.callBase(),{fullScreen:!1,title:"",showTitle:!0,titleTemplate:"title",onTitleRendered:null,dragEnabled:!1,toolbarItems:[],showCloseButton:!1,bottomTemplate:"bottom",useDefaultToolbarButtons:!1,useFlatToolbarButtons:!1,autoResizeEnabled:!0})},_defaultOptionsRules:function(){var e=V.default.current();return this.callBase().concat([{device:{platform:"ios"},options:{animation:this._iosAnimation}},{device:{platform:"android"},options:{animation:this._androidAnimation}},{device:{platform:"generic"},options:{showCloseButton:!0}},{device:function(e){return"desktop"===u.default.real().deviceType&&"generic"===e.platform},options:{dragEnabled:!0}},{device:function(){return"desktop"===u.default.real().deviceType&&!u.default.isSimulator()},options:{focusStateEnabled:!0}},{device:function(){return V.default.isMaterial(e)},options:{useDefaultToolbarButtons:!0,useFlatToolbarButtons:!0}}])},_iosAnimation:{show:{type:"slide",duration:400,from:{position:{my:"top",at:"bottom"}},to:{position:{my:"center",at:"center"}}},hide:{type:"slide",duration:400,from:{opacity:1,position:{my:"center",at:"center"}},to:{opacity:1,position:{my:"top",at:"bottom"}}}},_androidAnimation:function(){var e={show:{type:"slide",duration:300,from:{top:"30%",opacity:0},to:{top:0,opacity:1}},hide:{type:"slide",duration:300,from:{top:0,opacity:1},to:{top:"30%",opacity:0}}},t={show:{type:"fade",duration:400,from:0,to:1},hide:{type:"fade",duration:400,from:1,to:0}};return this.option("fullScreen")?e:t},_init:function(){this.callBase(),this.$element().addClass(L),this._wrapper().addClass(H),this._$popupContent=this._$content.wrapInner((0,f.default)("<div>").addClass(W)).children().eq(0)},_render:function(){var e=this.option("fullScreen");this._toggleFullScreenClass(e),this.callBase()},_toggleFullScreenClass:function(e){this._$content.toggleClass(z,e).toggleClass($,!e)},_initTemplates:function(){this.callBase(),this._defaultTemplates.title=new p.EmptyTemplate,this._defaultTemplates.bottom=new p.EmptyTemplate},_renderContentImpl:function(){this._renderTitle(),this.callBase(),this._renderBottom()},_renderTitle:function(){var e=this._getToolbarItems("top"),t=this.option("title"),n=this.option("showTitle");if(n&&t&&e.unshift({location:u.default.current().ios?"center":"before",text:t}),n||e.length>0){this._$title&&this._$title.remove();var i=(0,f.default)("<div>").addClass(j).insertBefore(this.$content());this._$title=this._renderTemplateByType("titleTemplate",e,i).addClass(j),this._renderDrag(),this._executeTitleRenderAction(this._$title)}else this._$title&&this._$title.detach()},_renderTemplateByType:function(e,t,n,i){var o=this._getTemplateByOption(e),a=o instanceof p.EmptyTemplate;if(a){var r=(0,y.extend)({},this.option("integrationOptions"),{skipTemplates:["content","title"]}),s=(0,y.extend)(i,{items:t,rtlEnabled:this.option("rtlEnabled"),useDefaultButtons:this.option("useDefaultToolbarButtons"),useFlatButtons:this.option("useFlatToolbarButtons"),integrationOptions:r});this._getTemplate("dx-polymorph-widget").render({container:n,model:{widget:"dxToolbarBase",options:s}});var l=n.children("div");return n.replaceWith(l),l}var u=(0,f.default)(o.render({container:(0,c.getPublicElement)(n)}));return u.hasClass(U)&&(n.replaceWith(u),n=u),n},_executeTitleRenderAction:function(e){this._getTitleRenderAction()({titleElement:(0,c.getPublicElement)(e)})},_getTitleRenderAction:function(){return this._titleRenderAction||this._createTitleRenderAction()},_createTitleRenderAction:function(){return this._titleRenderAction=this._createActionByOption("onTitleRendered",{element:this.element(),excludeValidators:["disabled","readOnly"]})},_getCloseButton:function(){return{toolbar:"top",location:"after",template:this._getCloseButtonRenderer()}},_getCloseButtonRenderer:function(){return function(e,t,n){var i=(0,f.default)("<div>").addClass(q);this._createComponent(i,P.default,{icon:"close",onClick:this._createToolbarItemAction(void 0),integrationOptions:{}}),(0,f.default)(n).append(i)}.bind(this)},_getToolbarItems:function(e){var t=this.option("toolbarItems"),n=[];this._toolbarItemClasses=[];var i=u.default.current().platform,o=0;return(0,x.each)(t,function(t,a){var r=(0,S.isDefined)(a.shortcut),s=r?ae(a.shortcut):a;if(r&&"ios"===i&&o<2&&(s.toolbar="top",o++),s.toolbar=a.toolbar||s.toolbar||"top",s&&s.toolbar===e){r&&(0,y.extend)(s,{location:a.location},this._getToolbarItemByAlias(a));var l="generic"===i;"done"===a.shortcut&&l||"cancel"===a.shortcut&&!l?n.unshift(s):n.push(s)}}.bind(this)),"top"===e&&this.option("showCloseButton")&&this.option("showTitle")&&n.push(this._getCloseButton()),n},_getLocalizationKey:function(e){return"done"===e.toLowerCase()?"OK":(0,b.camelize)(e,!0)},_getToolbarItemByAlias:function(e){var t=this,n=e.shortcut;if((0,g.inArray)(n,Z)<0)return!1;var i=(0,y.extend)({text:A.default.format(this._getLocalizationKey(n)),onClick:this._createToolbarItemAction(e.onClick),integrationOptions:{},type:t.option("useDefaultToolbarButtons")?Q:J,stylingMode:t.option("useFlatToolbarButtons")?ee:te},e.options||{}),o=L+"-"+n;return this._toolbarItemClasses.push(o),{template:function(e,n,a){var r=(0,f.default)("<div>").addClass(o).appendTo(a);t._createComponent(r,P.default,i)}}},_createToolbarItemAction:function(e){return this._createAction(e,{afterExecute:function(e){e.component.hide()}})},_renderBottom:function(){var e=this._getToolbarItems("bottom");if(e.length){this._$bottom&&this._$bottom.remove();var t=(0,f.default)("<div>").addClass(K).insertAfter(this.$content());this._$bottom=this._renderTemplateByType("bottomTemplate",e,t,{compactMode:!0}).addClass(K),this._toggleClasses()}else this._$bottom&&this._$bottom.detach()},_toggleClasses:function(){var e=Z;(0,x.each)(e,function(e,t){var n=L+"-"+t;(0,g.inArray)(n,this._toolbarItemClasses)>=0?(this._wrapper().addClass(n+"-visible"),this._$bottom.addClass(n)):(this._wrapper().removeClass(n+"-visible"),this._$bottom.removeClass(n))}.bind(this))},_getContainer:function(){return this.option("fullScreen")?(0,f.default)(F):this.callBase()},_getDragTarget:function(){return this.topToolbar()},_renderGeometryImpl:function(e){e||this._resetContentHeight(),this.callBase.apply(this,arguments),this._setContentHeight()},_resetContentHeight:function(){this._$popupContent.css({height:"auto",maxHeight:"none"})},_renderDrag:function(){this.callBase(),this._$content.toggleClass(G,this.option("dragEnabled"))},_renderResize:function(){this.callBase(),this._resizable.option("onResize",function(){this._setContentHeight(),this._actions.onResize(arguments)}.bind(this))},_setContentHeight:function(){(this.option("forceApplyBindings")||v.noop)();var e=this.overlayContent().get(0),t=this._chooseHeightStrategy(e);this.$content().css(this._getHeightCssStyles(t,e)),this._setHeightClasses(this.overlayContent(),t)},_heightStrategyChangeOffset:function(e,t){return e===oe.flex?-t:0},_chooseHeightStrategy:function(e){var t="auto"===e.style.width||""===e.style.width,n=oe.static;return this._isAutoHeight()&&this.option("autoResizeEnabled")&&(t||ie?ne||(n=oe.inherit):n=oe.flex),n},_getHeightCssStyles:function(e,t){var n={},i=this._getOptionValue("maxHeight",t),o=this._getOptionValue("minHeight",t),a=this._splitPopupHeight(),r=a.header+a.footer+a.contentVerticalOffsets+a.popupVerticalOffsets+this._heightStrategyChangeOffset(e,a.popupVerticalPaddings);if(e===oe.static){if(!this._isAutoHeight()||i||o){var s=this.option("fullScreen")?Math.min((0,k.getBoundingRect)(t).height,T.default.getWindow().innerHeight):(0,k.getBoundingRect)(t).height,l=s-r;n={height:Math.max(0,l),minHeight:"auto",maxHeight:"auto"}}}else{var u=(0,f.default)(this._getContainer()).get(0),c=C.default.addOffsetToMaxHeight(i,-r,u),d=C.default.addOffsetToMinHeight(o,-r,u);n={height:"auto",minHeight:d,maxHeight:c}}return n},_setHeightClasses:function(e,t){var n="";for(var i in oe)oe[i]!==t&&(n+=" "+oe[i]);e.removeClass(n).addClass(t)},_isAutoHeight:function(){return"auto"===this.overlayContent().get(0).style.height},_splitPopupHeight:function(){var e=this.topToolbar(),t=this.bottomToolbar();return{header:C.default.getVisibleHeight(e&&e.get(0)),footer:C.default.getVisibleHeight(t&&t.get(0)),contentVerticalOffsets:C.default.getVerticalOffsets(this.overlayContent().get(0),!0),popupVerticalOffsets:C.default.getVerticalOffsets(this.$content().get(0),!0),popupVerticalPaddings:C.default.getVerticalOffsets(this.$content().get(0),!1)}},_useFixedPosition:function(){return this.callBase()||this.option("fullScreen")},_toggleSafariFullScreen:function(e){var t=this._useFixedPosition()&&e&&!this._isShown;t?this._bodyScrollTop=e?F.pageYOffset:void 0:this._toggleSafariScrolling(!e)},_renderDimensions:function(){this.option("fullScreen")?this._$content.css({width:"100%",height:"100%",minWidth:"",maxWidth:"",minHeight:"",maxHeight:""}):this.callBase.apply(this,arguments),T.default.hasWindow()&&this._renderFullscreenWidthClass()},_renderFullscreenWidthClass:function(){this.overlayContent().toggleClass(N,this.overlayContent().outerWidth()===(0,f.default)(F).width())},refreshPosition:function(){this._renderPosition()},_renderPosition:function(){return this.option("fullScreen")?void a.default.move(this._$content,{top:0,left:0}):((this.option("forceApplyBindings")||v.noop)(),this.callBase.apply(this,arguments))},_optionChanged:function(e){switch(e.name){case"showTitle":case"title":case"titleTemplate":this._renderTitle(),this._renderGeometry();break;case"bottomTemplate":this._renderBottom(),this._renderGeometry();break;case"onTitleRendered":this._createTitleRenderAction(e.value);break;case"toolbarItems":case"useDefaultToolbarButtons":case"useFlatToolbarButtons":var t=!e.fullName.match(/^toolbarItems((\[\d+\])(\.(options|visible).*)?)?$/);this._renderTitle(),this._renderBottom(),t&&this._renderGeometry();break;case"dragEnabled":this._renderDrag();break;case"autoResizeEnabled":this._renderGeometry(),d.default.triggerResizeEvent(this._$content);break;case"fullScreen":this._toggleFullScreenClass(e.value),this._toggleSafariFullScreen(e.value),this._renderGeometry(),d.default.triggerResizeEvent(this._$content);break;case"showCloseButton":this._renderTitle();break;default:this.callBase(e)}},bottomToolbar:function(){return this._$bottom},topToolbar:function(){return this._$title},$content:function(){return this._$popupContent},content:function(){return(0,c.getPublicElement)(this._$popupContent)},overlayContent:function(){return this._$content}});(0,s.default)("dxPopup",re),e.exports=re},function(e,t,n){function i(e,t){var n=Object.keys(e);if(Object.getOwnPropertySymbols){var i=Object.getOwnPropertySymbols(e);t&&(i=i.filter(function(t){return Object.getOwnPropertyDescriptor(e,t).enumerable})),n.push.apply(n,i)}return n}function o(e){for(var t=1;t<arguments.length;t++){var n=null!=arguments[t]?arguments[t]:{};t%2?i(Object(n),!0).forEach(function(t){a(e,t,n[t])}):Object.getOwnPropertyDescriptors?Object.defineProperties(e,Object.getOwnPropertyDescriptors(n)):i(Object(n)).forEach(function(t){Object.defineProperty(e,t,Object.getOwnPropertyDescriptor(n,t))})}return e}function a(e,t,n){return t in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}function r(e,t){if(null==e)return{};var n,i,o=s(e,t);if(Object.getOwnPropertySymbols){var a=Object.getOwnPropertySymbols(e);for(i=0;i<a.length;i++)n=a[i],t.indexOf(n)>=0||Object.prototype.propertyIsEnumerable.call(e,n)&&(o[n]=e[n])}return o}function s(e,t){if(null==e)return{};var n,i,o={},a=Object.keys(e);for(i=0;i<a.length;i++)n=a[i],t.indexOf(n)>=0||(o[n]=e[n]);return o}function l(){this._counter=-1,this._deferreds={}}function u(e){return"pending"===e.state()}function c(e,t){function n(){var t={};return v.each(["useDefaultSearch","key","load","loadMode","cacheRawData","byKey","lookup","totalCount","insert","update","remove"],function(){t[this]=e[this],delete e[this]}),new S(t)}function i(e){var t=e.type;return delete e.type,C.create(t,e)}function o(e){return new S({load:function(){return y.sendRequest({url:e,dataType:"json"})},loadMode:t&&t.fromUrlLoadMode})}var a;return"string"==typeof e&&(e={paginate:!1,store:o(e)}),void 0===e&&(e=[]),e=Array.isArray(e)||e instanceof C?{store:e}:_({},e),void 0===e.store&&(e.store=[]),a=e.store,"load"in e?a=n():Array.isArray(a)?a=new k(a):b.isPlainObject(a)&&(a=i(_({},a))),e.store=a,e}function d(e){switch(e.length){case 0:return;case 1:return e[0]}return[].slice.call(e)}function h(e){return function(){var t=d(arguments);return void 0===t?this._storeLoadOptions[e]:void(this._storeLoadOptions[e]=t)}}function f(e,t,n){function i(e,n){return Array.isArray(e)?n?a(e,n):v.map(e,t):e}function a(e,n){return v.map(e,function(e){var a=e.items,s=r(e,["items"]);return o(o({},s),{},{items:i(a,n-1,t)})})}return i(e,n?x.normalizeSortingInfo(n).length:0)}function p(e,t){return e&&!Array.isArray(e)&&e.data&&(t=e,e=e.data),Array.isArray(e)||(e=[e]),{data:e,extra:t}}var g=n(15),_=n(0).extend,m=n(4),v=n(3),y=n(63),b=n(1),x=n(42),w=n(138),C=n(92),k=n(72),S=n(141),I=n(83),D=n(38).errors,T=n(14),E=n(228),A=n(6),O=A.when,P=A.Deferred,R=b.isString,B=b.isNumeric,M=b.isBoolean,V=b.isDefined,F="canceled";l.prototype.constructor=l,l.prototype.add=function(e){return this._counter+=1,this._deferreds[this._counter]=e,this._counter},l.prototype.remove=function(e){return delete this._deferreds[e]},l.prototype.cancel=function(e){return e in this._deferreds&&(this._deferreds[e].reject(F),!0)},l.prototype.cancelAll=function(){for(;this._counter>-1;)this.cancel(this._counter),this._counter--};var L=g.inherit({ctor:function(e){var t=this,n=this;e=c(e);var i=0!==e.pushAggregationTimeout?x.throttleChanges(this._onPush,function(){return void 0===e.pushAggregationTimeout?5*n._changedTime:e.pushAggregationTimeout}):this._onPush;this._changedTime=0,this._onPushHandler=function(e){t._aggregationTimeoutId=i.call(t,e)},this._store=e.store,this._store.on("push",this._onPushHandler),this._storeLoadOptions=this._extractLoadOptions(e),this._mapFunc=e.map,this._postProcessFunc=e.postProcess,this._pageIndex=void 0!==e.pageIndex?e.pageIndex:0,this._pageSize=void 0!==e.pageSize?e.pageSize:20,this._loadingCount=0,this._loadQueue=this._createLoadQueue(),this._searchValue="searchValue"in e?e.searchValue:null,this._searchOperation=e.searchOperation||"contains",this._searchExpr=e.searchExpr,this._paginate=e.paginate,this._reshapeOnPush=!!V(e.reshapeOnPush)&&e.reshapeOnPush,v.each(["onChanged","onLoadError","onLoadingChanged","onCustomizeLoadResult","onCustomizeStoreLoadOptions"],function(t,i){i in e&&n.on(i.substr(2,1).toLowerCase()+i.substr(3),e[i])}),this._operationManager=new l,this._init()},_init:function(){this._items=[],this._userData={},this._totalCount=-1,this._isLoaded=!1,V(this._paginate)||(this._paginate=!this.group()),this._isLastPage=!this._paginate},dispose:function(){this._store.off("push",this._onPushHandler),this._disposeEvents(),clearTimeout(this._aggregationTimeoutId),delete this._store,this._delayedLoadTask&&this._delayedLoadTask.abort(),this._operationManager.cancelAll(),this._disposed=!0},_extractLoadOptions:function(e){var t={},n=["sort","filter","select","group","requireTotalCount"],i=this._store._customLoadOptions();return i&&(n=n.concat(i)),v.each(n,function(){t[this]=e[this]}),t},loadOptions:function(){return this._storeLoadOptions},items:function(){return this._items},pageIndex:function(e){return B(e)?(this._pageIndex=e,void(this._isLastPage=!this._paginate)):this._pageIndex},paginate:function(e){return M(e)?void(this._paginate!==e&&(this._paginate=e,this.pageIndex(0))):this._paginate},pageSize:function(e){return B(e)?void(this._pageSize=e):this._pageSize},isLastPage:function(){return this._isLastPage},sort:h("sort"),filter:function(){var e=d(arguments);return void 0===e?this._storeLoadOptions.filter:(this._storeLoadOptions.filter=e,void this.pageIndex(0))},group:h("group"),select:h("select"),requireTotalCount:function(e){return M(e)?void(this._storeLoadOptions.requireTotalCount=e):this._storeLoadOptions.requireTotalCount},searchValue:function(e){return arguments.length<1?this._searchValue:(this._searchValue=e,void this.pageIndex(0))},searchOperation:function(e){return R(e)?(this._searchOperation=e,void this.pageIndex(0)):this._searchOperation},searchExpr:function(e){var t=arguments.length;return 0===t?this._searchExpr:(t>1&&(e=[].slice.call(arguments)),this._searchExpr=e,void this.pageIndex(0))},store:function(){return this._store},key:function(){return this._store&&this._store.key()},totalCount:function(){return this._totalCount},isLoaded:function(){return this._isLoaded},isLoading:function(){return this._loadingCount>0},beginLoading:function(){this._changeLoadingCount(1)},endLoading:function(){this._changeLoadingCount(-1)},_createLoadQueue:function(){return E.create()},_changeLoadingCount:function(e){var t=this.isLoading();this._loadingCount+=e;var n=this.isLoading();t^n&&this.fireEvent("loadingChanged",[n])},_scheduleLoadCallbacks:function(e){var t=this;t.beginLoading(),e.always(function(){t.endLoading()})},_scheduleFailCallbacks:function(e){var t=this;e.fail(function(){arguments[0]!==F&&t.fireEvent("loadError",arguments)})},_fireChanged:function(e){var t=new Date;this.fireEvent("changed",e),this._changedTime=new Date-t},_scheduleChangedCallbacks:function(e){var t=this;e.done(function(){t._fireChanged()})},loadSingle:function(e,t){function n(){return r instanceof S&&!r._byKeyViaLoad()}var i=this,o=new P,a=this.key(),r=this._store,s=this._createStoreLoadOptions(),l=function(e){!V(e)||T.isEmpty(e)?o.reject(new D.Error("E4009")):(Array.isArray(e)||(e=[e]),o.resolve(i._applyMapFunction(e)[0]))};return this._scheduleFailCallbacks(o),arguments.length<2&&(t=e,e=a),delete s.skip,delete s.group,delete s.refresh,delete s.pageIndex,delete s.searchString,function(){return e===a||n()?r.byKey(t,s):(s.take=1,s.filter=s.filter?[s.filter,[e,t]]:[e,t],r.load(s))}().fail(o.reject).done(l),o.promise()},load:function(){function e(){if(!t._disposed&&u(n))return t._loadFromStore(i,n)}var t=this,n=new P;this._scheduleLoadCallbacks(n),this._scheduleFailCallbacks(n),this._scheduleChangedCallbacks(n);var i=this._createLoadOperation(n);return this.fireEvent("customizeStoreLoadOptions",[i]),this._loadQueue.add(function(){return"number"==typeof i.delay?t._delayedLoadTask=m.executeAsync(e,i.delay):e(),n.promise()}),n.promise({operationId:i.operationId})},_onPush:function(e){var t=this;if(this._reshapeOnPush)this.load();else{this.fireEvent("changing",[{changes:e}]);var n=this.group(),i=this.items(),o=0,a=this.paginate()||n?e.filter(function(e){return"update"===e.type}):e;n&&(o=Array.isArray(n)?n.length:1),this._mapFunc&&a.forEach(function(e){"insert"===e.type&&(e.data=t._mapFunc(e.data))}),w.applyBatch(this.store(),i,a,o,!0),this._fireChanged([{changes:e}])}},_createLoadOperation:function(e){var t=this._operationManager.add(e),n=this._createStoreLoadOptions();return e.always(function(){this._operationManager.remove(t)}.bind(this)),{operationId:t,storeLoadOptions:n}},reload:function(){var e=this.store();return e instanceof S&&e.clearRawDataCache(),this._init(),this.load()},cancel:function(e){return this._operationManager.cancel(e)},cancelAll:function(){return this._operationManager.cancelAll()},_addSearchOptions:function(e){this._disposed||(this.store()._useDefaultSearch?this._addSearchFilter(e):(e.searchOperation=this._searchOperation,e.searchValue=this._searchValue,e.searchExpr=this._searchExpr))},_createStoreLoadOptions:function(){var e=_({},this._storeLoadOptions);return this._addSearchOptions(e),this._paginate&&this._pageSize&&(e.skip=this._pageIndex*this._pageSize,e.take=this._pageSize),e.userData=this._userData,e},_addSearchFilter:function(e){var t=this._searchValue,n=this._searchOperation,i=this._searchExpr,o=[];t&&(i||(i="this"),Array.isArray(i)||(i=[i]),v.each(i,function(e,i){o.length&&o.push("or"),o.push([i,n,t])}),e.filter?e.filter=[o,e.filter]:e.filter=o)},_loadFromStore:function(e,t){function n(n,o){function a(){var a=_(p(n,o),e);i.fireEvent("customizeLoadResult",[a]),O(a.data).done(function(e){a.data=e,i._processStoreLoadResult(a,t)}).fail(t.reject)}i._disposed||u(t)&&a()}var i=this;return e.data?(new P).resolve(e.data).done(n):this.store().load(e.storeLoadOptions).done(n).fail(t.reject)},_processStoreLoadResult:function(e,t){function n(){return o._isLoaded=!0,o._totalCount=isFinite(r.totalCount)?r.totalCount:-1,t.resolve(a,r)}function i(){o.store().totalCount(s).done(function(e){r.totalCount=e,n()}).fail(t.reject)}var o=this,a=e.data,r=e.extra,s=e.storeLoadOptions;o._disposed||(a=o._applyPostProcessFunction(o._applyMapFunction(a)),b.isPlainObject(r)||(r={}),o._items=a,(!a.length||!o._paginate||o._pageSize&&a.length<o._pageSize)&&(o._isLastPage=!0),s.requireTotalCount&&!isFinite(r.totalCount)?i():n())},_applyMapFunction:function(e){return this._mapFunc?f(e,this._mapFunc,this.group()):e},_applyPostProcessFunction:function(e){return this._postProcessFunc?this._postProcessFunc(e):e}}).include(I);t.DataSource=L,t.normalizeDataSourceOptions=c,t.normalizeLoadResult=p},function(e,t,n){var i=n(1),o=n(90),a=function(){function e(){}return function(t){return e.prototype=t,new e}}(),r=function(e,t){var n,o,a=[];for(n in e)Object.prototype.hasOwnProperty.call(e,n)&&a.push(n);for(a.sort(function(e,t){var n=i.isNumeric(e),o=i.isNumeric(t);return n&&o?e-t:n&&!o?-1:!n&&o?1:e<t?-1:e>t?1:0}),o=0;o<a.length;o++)n=a[o],t(n,e[n])},s=function(e,t,n,i){!i&&o.isWrapped(e[t])?o.assign(e[t],n):e[t]=n},l=function e(t,n,o,a){var r,l;for(var u in n)if(r=t[u],l=n[u],"__proto__"!==u&&t!==l){if(i.isPlainObject(l)){var c=o?i.isObject(r):i.isPlainObject(r);l=e(c?r:{},l,o,a)}void 0!==l&&r!==l&&s(t,u,l,a)}return t};t.clone=a,t.orderEach=r,t.deepExtendArraySafe=l},function(e,t,n){function i(e){return e&&e.__esModule?e:{"default":e}}function o(e,t){return u(e)||l(e,t)||r(e,t)||a()}function a(){throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}function r(e,t){if(e){if("string"==typeof e)return s(e,t);var n=Object.prototype.toString.call(e).slice(8,-1);return"Object"===n&&e.constructor&&(n=e.constructor.name),"Map"===n||"Set"===n?Array.from(e):"Arguments"===n||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)?s(e,t):void 0}}function s(e,t){(null==t||t>e.length)&&(t=e.length);for(var n=0,i=new Array(t);n<t;n++)i[n]=e[n];return i}function l(e,t){if("undefined"!=typeof Symbol&&Symbol.iterator in Object(e)){var n=[],i=!0,o=!1,a=void 0;try{for(var r,s=e[Symbol.iterator]();!(i=(r=s.next()).done)&&(n.push(r.value),!t||n.length!==t);i=!0);}catch(e){o=!0,a=e}finally{try{i||null==s.return||s.return()}finally{if(o)throw a}}return n}}function u(e){if(Array.isArray(e))return e}var c=n(55),d=i(c),h=n(14),f=n(4),p=n(3),g=n(1),_=n(289),m=i(_),v=n(28),y=i(v),b=n(21),x=i(b),w=n(219),C=n(115),k=i(C),S=n(447),I=i(S),D="undefined"!=typeof Intl,T=4,E=10,A=["currency","fixedpoint","exponential","percent","decimal"],O={1:"K",2:"M",3:"B",4:"T"},P={largenumber:"auto",thousands:1,millions:2,billions:3,trillions:4},R=(0,d.default)({engine:function(){return"base"},numericFormats:A,defaultLargeNumberFormatPostfixes:O,_parseNumberFormatString:function(e){var t={};if(e&&"string"==typeof e){var n=e.toLowerCase().split(" ");return(0,p.each)(n,function(e,n){(0,h.inArray)(n,A)>-1?t.formatType=n:n in P&&(t.power=P[n])}),t.power&&!t.formatType&&(t.formatType="fixedpoint"),t.formatType?t:void 0}},_calculateNumberPower:function(e,t,n,i){var o=Math.abs(e),a=0;if(o>1)for(;o&&o>=t&&(void 0===i||a<i);)a++,o/=t;else if(o>0&&o<1)for(;o<1&&(void 0===n||a>n);)a--,o*=t;return a},_getNumberByPower:function(e,t,n){for(var i=e;t>0;)i/=n,t--;for(;t<0;)i*=n,t++;return i},_formatNumber:function(e,t,n){var i;"auto"===t.power&&(t.power=this._calculateNumberPower(e,1e3,0,T)),t.power&&(e=this._getNumberByPower(e,t.power,1e3));var o=this.defaultLargeNumberFormatPostfixes[t.power]||"";return i=this._formatNumberCore(e,t.formatType,n),i=i.replace(/(\d|.$)(\D*)$/,"$1"+o+"$2")},_formatNumberExponential:function(e,t){var n=this._calculateNumberPower(e,E),i=this._getNumberByPower(e,n,E);void 0===t.precision&&(t.precision=1),i.toFixed(t.precision||0)>=E&&(n++,i/=E);var o=(n>=0?"+":"")+n.toString();return this._formatNumberCore(i,"fixedpoint",t)+"E"+o},_addZeroes:function(e,t){var n=Math.pow(10,t),i=e<0?"-":"";e=(Math.abs(e)*n>>>0)/n;for(var o=e.toString();o.length<t;)o="0"+o;return i+o},_addGroupSeparators:function(e){var t=e.toString().split(".");return t[0].replace(/\B(?=(\d{3})+(?!\d))/g,(0,y.default)().thousandsSeparator)+(t[1]?(0,y.default)().decimalSeparator+t[1]:"")},_formatNumberCore:function(e,t,n){return"exponential"===t?this._formatNumberExponential(e,n):("decimal"!==t&&null!==n.precision&&(n.precision=n.precision||0),"percent"===t&&(e=100*e),void 0!==n.precision&&(e="decimal"===t?this._addZeroes(e,n.precision):null===n.precision?e.toPrecision():(0,w.toFixed)(e,n.precision)),e="decimal"!==t?this._addGroupSeparators(e):e.toString().replace(".",(0,y.default)().decimalSeparator),"percent"===t&&(e+="%"),e)},_normalizeFormat:function(e){return e?"function"==typeof e?e:((0,g.isPlainObject)(e)||(e={type:e}),e):{}},_getSeparators:function(){return{decimalSeparator:this.getDecimalSeparator(),thousandsSeparator:this.getThousandsSeparator()}},getThousandsSeparator:function(){return this.format(1e4,"fixedPoint")[2]},getDecimalSeparator:function(){return this.format(1.2,{type:"fixedPoint",precision:1})[1]},convertDigits:function(e,t){var n=this.format(90,"decimal");if("string"!=typeof e||"0"===n[1])return e;var i=t?n[1]:"0",o=t?"0":n[1],a=t?n[0]:"9",r=new RegExp("["+i+"-"+a+"]","g");return e.replace(r,function(e){return String.fromCharCode(e.charCodeAt(0)+(o.charCodeAt(0)-i.charCodeAt(0)))})},getNegativeEtalonRegExp:function(e){var t=this._getSeparators(),n=new RegExp("[0-9"+(0,f.escapeRegExp)(t.decimalSeparator+t.thousandsSeparator)+"]+","g"),i=["\\","(",")","[","]","*","+","$","^","?","|","{","}"],o=this.format(-1,e).replace(n,"1");return i.forEach(function(e){o=o.replace(e,"\\".concat(e))}),o=o.replace(" ","\\s"),o=o.replace("1",".+"),new RegExp(o,"g")},getSign:function(e,t){if("-"===e.replace(/[^0-9-]/g,"").charAt(0))return-1;if(!t)return 1;var n=this.getNegativeEtalonRegExp(t);return e.match(n)?-1:1},format:function(e,t){if("number"!=typeof e)return e;if("number"==typeof t)return e;if(t=t&&t.formatter||t,"function"==typeof t)return t(e);t=this._normalizeFormat(t),t.type||(t.type="decimal");var n=this._parseNumberFormatString(t.type);return n?this._formatNumber(e,n,t):this.convertDigits(m.default.getFormatter(t.type,this._getSeparators())(e))},parse:function(e,t){if(e){if(t&&t.parser)return t.parser(e);e=this.convertDigits(e,!0),t&&"string"!=typeof t&&x.default.log("W0011");var n=this.getDecimalSeparator(),i=new RegExp("[^0-9"+(0,f.escapeRegExp)(n)+"]","g"),o=e.replace(i,"").replace(n,".").replace(/\.$/g,"");if("."===o||""===o)return null;if(this._calcSignificantDigits(o)>15)return NaN;var a=+o;return a*this.getSign(e,t)}},_calcSignificantDigits:function(e){
var t=e.split("."),n=o(t,2),i=n[0],a=n[1],r=function(e){for(var t=-1,n=0;n<e.length;n++)if("0"!==e[n]){t=n;break}return t>-1?e.length-t:0},s=0;return i&&(s+=r(i.split(""))),a&&(s+=r(a.split("").reverse())),s}});R.inject(k.default),D&&R.inject(I.default),e.exports=R},function(e,t,n){function i(e){return e&&e.__esModule?e:{"default":e}}var o=n(2),a=i(o),r=n(39),s=i(r),l=n(27),u=i(l),c=n(4),d=i(c),h=n(7),f=i(h),p=n(8),g=n(22),_=n(0),m=n(35),v=i(m),y=n(17),b=i(y),x=n(60),w=i(x),C=n(88),k=i(C),S=n(5),I=i(S),D=n(43),T="dx-state-readonly",E="dx-invalid",A="dx-invalid-message",O="dx-invalid-message-content",P="dx-invalid-message-auto",R="dx-invalid-message-always",B="dx-show-invalid-badge",M="dx-validation-target",V=100,F="valid",L="invalid",H="editorReadOnly",z=function(e){var t="";return e&&e.forEach(function(e){e.message&&(t+=(t?"<br />":"")+(0,D.encodeHtml)(e.message))}),t},N=b.default.inherit({ctor:function(){this.showValidationMessageTimeout=null,this.validationRequest=(0,u.default)(),this.callBase.apply(this,arguments)},_createElement:function(e){this.callBase(e);var t=this.$element();t&&s.default.data(t[0],M,this)},_initOptions:function(e){this.callBase.apply(this,arguments),this.option(k.default.initValidationOptions(e))},_init:function(){this.callBase(),this._initInnerOptionCache("validationTooltipOptions");var e=this.$element();e.addClass(B)},_getDefaultOptions:function(){return(0,_.extend)(this.callBase(),{value:null,name:"",onValueChanged:null,readOnly:!1,isValid:!0,validationError:null,validationErrors:null,validationStatus:F,validationMessageMode:"auto",validationBoundary:void 0,validationMessageOffset:{h:0,v:0},validationTooltipOptions:{}})},_attachKeyboardEvents:function(){this.option("readOnly")||(this.callBase(),this._keyboardProcessor&&this._attachChildKeyboardEvents())},_attachChildKeyboardEvents:d.default.noop,_setOptionsByReference:function(){this.callBase(),(0,_.extend)(this._optionsByReference,{validationError:!0})},_createValueChangeAction:function(){this._valueChangeAction=this._createActionByOption("onValueChanged",{excludeValidators:["disabled","readOnly"]})},_suppressValueChangeAction:function(){this._valueChangeActionSuppressed=!0},_resumeValueChangeAction:function(){this._valueChangeActionSuppressed=!1},_initMarkup:function(){this._toggleReadOnlyState(),this._setSubmitElementName(this.option("name")),this.callBase(),this._renderValidationState()},_raiseValueChangeAction:function(e,t){this._valueChangeAction||this._createValueChangeAction(),this._valueChangeAction(this._valueChangeArgs(e,t))},_valueChangeArgs:function(e,t){return{value:e,previousValue:t,event:this._valueChangeEventInstance}},_saveValueChangeEvent:function(e){this._valueChangeEventInstance=e},_focusInHandler:function(e){var t=this,n="auto"===this.option("validationMessageMode");return this._canValueBeChangedByClick()&&n&&(this._$validationMessage&&this._$validationMessage.removeClass(P),clearTimeout(this.showValidationMessageTimeout),this.showValidationMessageTimeout=setTimeout(function(){return t._$validationMessage&&t._$validationMessage.addClass(P)},150)),this.callBase(e)},_canValueBeChangedByClick:function(){return!1},_renderValidationState:function(){var e=this.option("isValid")&&this.option("validationStatus")!==L,t=this.option("validationMessageMode"),n=this.$element(),i=this.option("validationErrors");if(!i&&this.option("validationError")&&(i=[this.option("validationError")]),n.toggleClass(E,!e),this.setAria(L,!e||void 0),f.default.hasWindow()){this._$validationMessage&&(this._$validationMessage.remove(),this.setAria("describedby",null),this._$validationMessage=null);var o=z(i);if(!e&&o){this._$validationMessage=(0,a.default)("<div>").addClass(A).html(o).appendTo(n);var r=this._getValidationMessageTarget();this._validationMessage=this._createComponent(this._$validationMessage,w.default,(0,_.extend)({integrationOptions:{},templatesRenderAsynchronously:!1,target:r,shading:!1,width:"auto",height:"auto",container:n,position:this._getValidationMessagePosition("below"),closeOnOutsideClick:!1,closeOnTargetScroll:!1,animation:null,visible:!0,propagateOutsideClick:!0,_checkParentVisibility:!1},this._getInnerOptionsCache("validationTooltipOptions"))),this._$validationMessage.toggleClass(P,"auto"===t).toggleClass(R,"always"===t);var s="dx-"+new v.default;this._validationMessage.$content().addClass(O).attr("id",s),this.setAria("describedby",s),this._setValidationMessageMaxWidth(),this._bindInnerWidgetOptions(this._validationMessage,"validationTooltipOptions")}}},_setValidationMessageMaxWidth:function(){if(this._validationMessage){if(0===this._getValidationMessageTarget().outerWidth())return void this._validationMessage.option("maxWidth","100%");var e=Math.max(V,this._getValidationMessageTarget().outerWidth());this._validationMessage.option("maxWidth",e)}},_getValidationMessageTarget:function(){return this.$element()},_getValidationMessagePosition:function(e){var t=this.option("rtlEnabled"),n=(0,g.getDefaultAlignment)(t),i=this.option("validationMessageOffset"),o={h:i.h,v:i.v},a="below"===e?[" top"," bottom"]:[" bottom"," top"];return t&&(o.h=-o.h),"below"!==e&&(o.v=-o.v),{offset:o,boundary:this.option("validationBoundary"),my:n+a[0],at:n+a[1],collision:"none flip"}},_toggleReadOnlyState:function(){var e=this.option("readOnly");this._toggleBackspaceHandler(e),this.$element().toggleClass(T,!!e),this.setAria("readonly",e||void 0)},_toggleBackspaceHandler:function(e){var t=this._keyboardEventBindingTarget(),n=(0,p.addNamespace)("keydown",H);I.default.off(t,n),e&&I.default.on(t,n,function(e){"backspace"===(0,p.normalizeKeyName)(e)&&e.preventDefault()})},_dispose:function(){var e=this.$element()[0];s.default.data(e,M,null),clearTimeout(this.showValidationMessageTimeout),this.callBase()},_setSubmitElementName:function(e){var t=this._getSubmitElement();t&&(e.length>0?t.attr("name",e):t.removeAttr("name"))},_getSubmitElement:function(){return null},_optionChanged:function(e){switch(e.name){case"onValueChanged":this._createValueChangeAction();break;case"isValid":case"validationError":this.option(k.default.synchronizeValidationOptions(e,this.option()));break;case"validationErrors":case"validationStatus":this.option(k.default.synchronizeValidationOptions(e,this.option())),this._renderValidationState();break;case"validationBoundary":case"validationMessageMode":this._renderValidationState();break;case"validationTooltipOptions":this._innerOptionChanged(this._validationMessage,e);break;case"readOnly":this._toggleReadOnlyState(),this._refreshFocusState();break;case"value":e.value!=e.previousValue&&this.validationRequest.fire({value:e.value,editor:this}),this._valueChangeActionSuppressed||(this._raiseValueChangeAction(e.value,e.previousValue),this._saveValueChangeEvent(void 0));break;case"width":this.callBase(e),this._setValidationMessageMaxWidth();break;case"name":this._setSubmitElementName(e.value);break;default:this.callBase(e)}},reset:function(){var e=this._getDefaultOptions();this.option("value",e.value)}});e.exports=N},function(e,t,n){function i(e){var t=E(e);return k[t]||k[S[t]||r()]}function o(e,t){return S[e+"."+t]||I[e+"."+t]||S[e]}function a(e,t,n){return o(e+t,n)||o(e,n)}function r(e,t){if(!arguments.length)return A||o(C.current())||y;var n=E(t);return A=(e&&e.platform?a(E(e.platform),e.version,n):o(E(e),n))||A,this}function s(e,t){var n=e.indexOf(t);return n>0?{name:e.substring(0,n),scheme:e.substring(n+1)}:null}function l(e,t){var n=s(e,".")||{name:e},i=n.name,o=n.scheme;o?(S[i]=S[i]||t,S[i+"."+o]=t):S[i]=t}function u(e,t){var n=E(e&&e.name);n&&(e.isDefault&&(y=n),l(n,n),k[n]=D(!0,{},i(t),f(e)))}function c(e,t){I[e]=t}function d(e,t,n,i){var o=n?n[t]:i;void 0!==o&&void 0===e[t]&&(e[t]=o)}function h(e,t,n,i){var o=n?n[t]:i;void 0!==o&&(e[t]=D(!0,{},o,e[t]))}function f(e){return e=D(!0,{loadingIndicator:{font:{}},"export":{font:{}},legend:{font:{},border:{}},title:{font:{}},tooltip:{font:{}},"chart:common":{},"chart:common:axis":{grid:{},minorGrid:{},tick:{},minorTick:{},title:{font:{}},label:{font:{}}},chart:{commonSeriesSettings:{candlestick:{}}},pie:{},polar:{},gauge:{scale:{tick:{},minorTick:{},label:{font:{}}}},barGauge:{},funnel:{},sankey:{},map:{background:{}},treeMap:{tile:{selectionStyle:{border:{}}},group:{border:{},selectionStyle:{border:{}},label:{font:{}}}},rangeSelector:{scale:{tick:{},minorTick:{},label:{font:{}}},chart:{}},sparkline:{},bullet:{}},e),d(e.loadingIndicator,"backgroundColor",e),d(e.chart.commonSeriesSettings.candlestick,"innerColor",null,e.backgroundColor),d(e.map.background,"color",null,e.backgroundColor),d(e.title.font,"color",null,e.primaryTitleColor),h(e.title,"subtitle",null,e.title),d(e.legend.font,"color",null,e.secondaryTitleColor),d(e.legend.border,"color",null,e.gridColor),p(e),T(["chart","pie","polar","gauge","barGauge","map","treeMap","funnel","rangeSelector","sparkline","bullet","sankey"],function(t,n){d(e[n],"redrawOnResize",e),d(e[n],"containerBackgroundColor",null,e.backgroundColor),h(e[n],"tooltip",e),h(e[n],"export",e)}),T(["chart","pie","polar","gauge","barGauge","map","treeMap","funnel","rangeSelector","sankey"],function(t,n){h(e[n],"loadingIndicator",e),h(e[n],"legend",e),h(e[n],"title",e)}),T(["chart","pie","polar"],function(t,n){h(e,n,null,e["chart:common"])}),T(["chart","polar"],function(t,n){e[n]=e[n]||{},h(e[n],"commonAxisSettings",null,e["chart:common:axis"])}),h(e.rangeSelector.chart,"commonSeriesSettings",e.chart),h(e.rangeSelector.chart,"dataPrepareSettings",e.chart),d(e.treeMap.group.border,"color",null,e.gridColor),d(e.treeMap.tile.selectionStyle.border,"color",null,e.primaryTitleColor),d(e.treeMap.group.selectionStyle.border,"color",null,e.primaryTitleColor),d(e.map.legend,"backgroundColor",e),g(e),e}function p(e){var t=e["chart:common:axis"],n="color";T([t.grid,t.minorGrid],function(t,i){d(i,n,null,e.gridColor)}),T([t,t.tick,t.minorTick,t.label.font],function(t,i){d(i,n,null,e.axisColor)}),d(t.title.font,n,null,e.secondaryTitleColor),d(e.gauge.scale.label.font,n,null,e.axisColor),d(e.gauge.scale.tick,n,null,e.backgroundColor),d(e.gauge.scale.minorTick,n,null,e.backgroundColor),d(e.rangeSelector.scale.label.font,n,null,e.axisColor)}function g(e){var t=e.map;T(["area","line","marker"],function(e,n){h(t,"layer:"+n,null,t.layer)}),T(["dot","bubble","pie","image"],function(e,n){h(t,"layer:marker:"+n,null,t["layer:marker"])})}function _(e){var t=++O;e._cache=t,P[t]=e}function m(e){delete P[e._cache]}function v(){return T(P,function(){this.refresh()}),this}var y,b=n(0).extend,x=n(3).each,w=n(13),C=n(32),k={},S={},I={},D=b,T=x,E=w.normalizeEnum,A=null,O=0,P={};D(t,{currentTheme:r,registerTheme:u,getTheme:i,registerThemeSchemeAlias:c,refreshTheme:v,addCacheItem:_,removeCacheItem:m})},function(e,t,n){var i=n(11),o=n(55),a=n(7),r=n(62),s=[],l=function(){return"complete"===i.getReadyState()||"loading"!==i.getReadyState()&&!i.getDocumentElement().doScroll},u=r(function(){var e=i.listen(i.getDocument(),"DOMContentLoaded",function(){c.fire(),e()})}),c={add:function(e){var t=a.hasWindow();t&&l()?e():(s.push(e),t&&u())},fire:function(){s.forEach(function(e){return e()}),s=[]}};e.exports=o(c)},function(e,t,n){t.compare=function(e,t,n){function i(e){return"string"==typeof e?e.split("."):"number"==typeof e?[e]:e}e=i(e),t=i(t);var o=Math.max(e.length,t.length);isFinite(n)&&(o=Math.min(o,n));for(var a=0;a<o;a++){var r=parseInt(e[a]||0,10),s=parseInt(t[a]||0,10);if(r<s)return-1;if(r>s)return 1}return 0}},function(e,t,n){function i(e){return+e||0}function o(e){var t=D(e)===p,n=!c(e)&&Date.parse(e);if((!n||x)&&t){var o=e.match(y);if(o){var a=new Date(i(o[1]),i(o[2]),i(o[3]));return a.setFullYear(i(o[1])),a.setMonth(i(o[2])-1),a.setDate(i(o[3])),a}}return d(n)?new Date(n):e}var a=n(28),r=n(221).getFormatter,s=n(222),l=n(1),u=l.isString,c=l.isDate,d=l.isNumeric,h=n(23),f="number",p="yyyy/MM/dd",g="yyyy/MM/dd HH:mm:ss",_=/^(\d{4,})(-)?(\d{2})(-)?(\d{2})(?:T(\d{2})(:)?(\d{2})?(:)?(\d{2}(?:\.(\d{1,3})\d*)?)?)?(Z|([+-])(\d{2})(:)?(\d{2})?)?$/,m=/^(\d{2}):(\d{2})(:(\d{2}))?$/,v=["","yyyy","","MM","","dd","THH","","mm","","ss",".SSS"],y=/^(\d{4})\/(\d{2})\/(\d{2})$/,b=3,x=h.msie&&parseInt(h.version)<=11,w=function(e,t){var n;return u(e)&&!t&&(n=C(e)),n||o(e)},C=function(e){var t=e.match(_);{if(t){var n=t[1],o=--t[3],a=t[5],r=0,s=0;r=i(t[14]),s=i(t[16]),"-"===t[13]&&(r=-r,s=-s);var l=i(t[6])-r,u=i(t[8])-s,c=i(t[10]),d=function(e){return e=e||"",i(e)*Math.pow(10,b-e.length)},h=d(t[11]);return t[12]?new Date(Date.UTC(n,o,a,l,u,c,h)):new Date(n,o,a,l,u,c,h)}if(t=e.match(m))return new Date(0,0,0,i(t[1]),i(t[2]),i(t[4]))}},k=function(e,t){var n=e.match(_),i="";if(n){for(var o=1;o<v.length;o++)n[o]&&(i+=v[o]||n[o]);return"Z"===n[12]&&(i+="'Z'"),n[14]&&(i+=n[15]?"xxx":n[16]?"xx":"x"),i}if(n=e.match(m))return n[3]?"HH:mm:ss":"HH:mm"},S=function(e){return"number"==typeof e?new Date(e):w(e,!a().forceIsoDateParsing)},I=function(e,t){return t?c(e)?t===f?e&&e.valueOf?e.valueOf():null:r(t,s)(e):null:e},D=function(e){if("number"==typeof e)return f;if(u(e)){var t;return a().forceIsoDateParsing&&(t=k(e)),t?t:e.indexOf(":")>=0?g:p}return e?null:void 0};e.exports={dateParser:w,deserializeDate:S,serializeDate:I,getDateSerializationFormat:D}},function(e,t,n){e.exports=function(e){var t=n(0).extend,i=n(1).isFunction,o=n(3).each,a=n(15),r=a.inherit(e),s=r,l=new s(e),u={},c=function(t,n){o(t,function(t){i(l[t])?!n&&e[t]||(e[t]=function(){return l[t].apply(e,arguments)}):(n&&(u[t]=e[t]),e[t]=l[t])})};return c(e,!0),e.inject=function(e){s=s.inherit(e),l=new s,c(e)},e.resetInjection=function(){t(e,u),s=r,l=new r},e}},function(e,t){e.exports=window.jQuery},function(e,t,n){function i(e){return e&&e.__esModule?e:{"default":e}}function o(e){return l(e)||s(e)||r(e)||a()}function a(){throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}function r(e,t){if(e){if("string"==typeof e)return u(e,t);var n=Object.prototype.toString.call(e).slice(8,-1);return"Object"===n&&e.constructor&&(n=e.constructor.name),"Map"===n||"Set"===n?Array.from(e):"Arguments"===n||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)?u(e,t):void 0}}function s(e){if("undefined"!=typeof Symbol&&Symbol.iterator in Object(e))return Array.from(e)}function l(e){if(Array.isArray(e))return u(e)}function u(e,t){(null==t||t>e.length)&&(t=e.length);for(var n=0,i=new Array(t);n<t;n++)i[n]=e[n];return i}var c=n(2),d=i(c),h=n(5),f=i(h),p=n(487),g=i(p),_=n(18),m=i(_),v=n(0),y=n(3),b=n(4),x=n(1),w=n(191),C=i(w),k=n(20),S=n(47),I=n(294),D=i(I),T=n(6),E="dxItemDeleting",A=-1,O=function(e){return e!==A},P=g.default.inherit({_setOptionsByReference:function(){this.callBase(),(0,v.extend)(this._optionsByReference,{selectedItem:!0})},_getDefaultOptions:function(){return(0,v.extend)(this.callBase(),{selectionMode:"none",selectionRequired:!1,selectionByClick:!0,selectedItems:[],selectedItemKeys:[],maxFilterLengthInRequest:1500,keyExpr:null,selectedIndex:A,selectedItem:null,onSelectionChanged:null,onItemReordered:null,onItemDeleting:null,onItemDeleted:null})},ctor:function(e,t){this._userOptions=t||{},this.callBase(e,t)},_init:function(){this._initEditStrategy(),this.callBase(),this._initKeyGetter(),this._initSelectionModule(),"multi"===this.option("selectionMode")&&this._showDeprecatedSelectionMode()},_initKeyGetter:function(){this._keyGetter=(0,k.compileGetter)(this.option("keyExpr"))},_getKeysByItems:function(e){return this._editStrategy.getKeysByItems(e)},_getItemsByKeys:function(e,t){return this._editStrategy.getItemsByKeys(e,t)},_getKeyByIndex:function(e){return this._editStrategy.getKeyByIndex(e)},_getIndexByKey:function(e){return this._editStrategy.getIndexByKey(e)},_getIndexByItemData:function(e){return this._editStrategy.getIndexByItemData(e)},_isKeySpecified:function(){return!(!this._dataSource||!this._dataSource.key())},_getCombinedFilter:function(){return this._dataSource&&this._dataSource.filter()},key:function(){return this.option("keyExpr")?this.option("keyExpr"):this._dataSource&&this._dataSource.key()},keyOf:function(e){var t=e,n=this._dataSource&&this._dataSource.store();return this.option("keyExpr")?t=this._keyGetter(e):n&&(t=n.keyOf(e)),t},_nullValueSelectionSupported:function(){return!1},_initSelectionModule:function(){var e=this,t=e._editStrategy.itemsGetter;this._selection=new D.default({allowNullValue:this._nullValueSelectionSupported(),mode:this.option("selectionMode"),maxFilterLengthInRequest:this.option("maxFilterLengthInRequest"),equalByReference:!this._isKeySpecified(),onSelectionChanged:function(t){(t.addedItemKeys.length||t.removedItemKeys.length)&&(e.option("selectedItems",e._getItemsByKeys(t.selectedItemKeys,t.selectedItems)),e._updateSelectedItems(t))},filter:e._getCombinedFilter.bind(e),totalCount:function(){var t=e.option("items"),n=e._dataSource;return n&&n.totalCount()>=0?n.totalCount():t.length},key:e.key.bind(e),keyOf:e.keyOf.bind(e),load:function(t){if(e._dataSource){var n=e._dataSource.loadOptions();t.customQueryParams=n.customQueryParams,t.userData=e._dataSource._userData}var i=e._dataSource&&e._dataSource.store();return i?i.load(t).done(function(t){if(!e._disposed){var n=(0,S.normalizeLoadResult)(t).data;e._dataSource._applyMapFunction(n)}}):(new T.Deferred).resolve(this.plainItems())},dataFields:function(){return e._dataSource&&e._dataSource.select()},plainItems:t.bind(e._editStrategy)})},_initEditStrategy:function(){var e=C.default;this._editStrategy=new e(this)},_getSelectedItemIndices:function(e){var t=this,n=[];return e=e||this._selection.getSelectedItemKeys(),t._editStrategy.beginCache(),(0,y.each)(e,function(e,i){var o=t._getIndexByKey(i);O(o)&&n.push(o)}),t._editStrategy.endCache(),n},_initMarkup:function(){var e=this;this._rendering=!0,this._dataSource&&this._dataSource.isLoading()||this._syncSelectionOptions().done(function(){return e._normalizeSelectedItems()}),this.callBase()},_render:function(){this.callBase(),this._rendering=!1},_fireContentReadyAction:function(){this._rendering=!1,this._rendered=!0,this.callBase.apply(this,arguments)},_syncSelectionOptions:function(e){e=e||this._chooseSelectOption();var t,n,i,o;switch(e){case"selectedIndex":t=this._editStrategy.getItemDataByIndex(this.option("selectedIndex")),(0,x.isDefined)(t)?(this._setOptionSilent("selectedItems",[t]),this._setOptionSilent("selectedItem",t),this._setOptionSilent("selectedItemKeys",this._editStrategy.getKeysByItems([t]))):(this._setOptionSilent("selectedItems",[]),this._setOptionSilent("selectedItemKeys",[]),this._setOptionSilent("selectedItem",null));break;case"selectedItems":if(o=this.option("selectedItems")||[],n=this._editStrategy.getIndexByItemData(o[0]),this.option("selectionRequired")&&!O(n))return this._syncSelectionOptions("selectedIndex");this._setOptionSilent("selectedItem",o[0]),this._setOptionSilent("selectedIndex",n),this._setOptionSilent("selectedItemKeys",this._editStrategy.getKeysByItems(o));break;case"selectedItem":if(t=this.option("selectedItem"),n=this._editStrategy.getIndexByItemData(t),this.option("selectionRequired")&&!O(n))return this._syncSelectionOptions("selectedIndex");(0,x.isDefined)(t)?(this._setOptionSilent("selectedItems",[t]),this._setOptionSilent("selectedIndex",n),this._setOptionSilent("selectedItemKeys",this._editStrategy.getKeysByItems([t]))):(this._setOptionSilent("selectedItems",[]),this._setOptionSilent("selectedItemKeys",[]),this._setOptionSilent("selectedIndex",A));break;case"selectedItemKeys":if(i=this.option("selectedItemKeys"),this.option("selectionRequired")){var a=this._getIndexByKey(i[0]);if(!O(a))return this._syncSelectionOptions("selectedIndex")}return this._selection.setSelection(i)}return(new T.Deferred).resolve().promise()},_chooseSelectOption:function(){var e="selectedIndex",t=function(e){var t=this.option(e),n=(0,x.isDefined)(t)&&t.length;return n||e in this._userOptions}.bind(this);return t("selectedItems")?e="selectedItems":t("selectedItem")?e="selectedItem":t("selectedItemKeys")&&(e="selectedItemKeys"),e},_compareKeys:function(e,t){if(e.length!==t.length)return!1;for(var n=0;n<t.length;n++)if(e[n]!==t[n])return!1;return!0},_normalizeSelectedItems:function(){if("none"===this.option("selectionMode"))this._setOptionSilent("selectedItems",[]),this._syncSelectionOptions("selectedItems");else if("single"===this.option("selectionMode")){var e=this.option("selectedItems");if(e.length>1||!e.length&&this.option("selectionRequired")&&this.option("items")&&this.option("items").length){var t=this._selection.getSelectedItems(),n=void 0===e[0]?t[0]:e[0];return void 0===n&&(n=this._editStrategy.itemsGetter()[0]),this.option("grouped")&&n&&n.items&&(n.items=[n.items[0]]),this._selection.setSelection(this._getKeysByItems([n])),this._setOptionSilent("selectedItems",[n]),this._syncSelectionOptions("selectedItems")}this._selection.setSelection(this._getKeysByItems(e))}else{var i=this._getKeysByItems(this.option("selectedItems")),o=this._selection.getSelectedItemKeys();this._compareKeys(o,i)||this._selection.setSelection(i)}return(new T.Deferred).resolve().promise()},_itemClickHandler:function(e){this._createAction(function(e){this._itemSelectHandler(e.event)}.bind(this),{validatingTargetName:"itemElement"})({itemElement:(0,d.default)(e.currentTarget),event:e}),this.callBase.apply(this,arguments)},_itemSelectHandler:function(e){if(this.option("selectionByClick")){var t=e.currentTarget;this.isItemSelected(t)?this.unselectItem(e.currentTarget):this.selectItem(e.currentTarget)}},_selectedItemElement:function(e){return this._itemElements().eq(e)},_postprocessRenderItem:function(e){if("none"!==this.option("selectionMode")){var t=(0,d.default)(e.itemElement),n=this._editStrategy.getNormalizedIndex(t),i=this._isItemSelected(n);this._processSelectableItem(t,i)}},_processSelectableItem:function(e,t){e.toggleClass(this._selectedItemClass(),t),this._setAriaSelected(e,String(t))},_updateSelectedItems:function(e){var t=this,n=e.addedItemKeys,i=e.removedItemKeys;if(t._rendered&&(n.length||i.length)){var o=t._selectionChangePromise;if(!t._rendering){var a,r=[],s=[];t._editStrategy.beginCache();for(var l=0;l<n.length;l++)a=t._getIndexByKey(n[l]),r.push(a),t._addSelection(a);for(var u=0;u<i.length;u++)a=t._getIndexByKey(i[u]),s.push(a),t._removeSelection(a);t._editStrategy.endCache(),t._updateSelection(r,s)}(0,T.when)(o).done(function(){t._fireSelectionChangeEvent(e.addedItems,e.removedItems)})}},_fireSelectionChangeEvent:function(e,t){this._createActionByOption("onSelectionChanged",{excludeValidators:["disabled","readOnly"]})({addedItems:e,removedItems:t})},_updateSelection:b.noop,_setAriaSelected:function(e,t){this.setAria("selected",t,e)},_removeSelection:function(e){var t=this._editStrategy.getItemElement(e);O(e)&&(this._processSelectableItem(t,!1),f.default.triggerHandler(t,"stateChanged",!1))},_showDeprecatedSelectionMode:function(){m.default.log("W0001",this.NAME,"selectionMode: 'multi'","16.1","Use selectionMode: 'multiple' instead"),this.option("selectionMode","multiple")},_addSelection:function(e){var t=this._editStrategy.getItemElement(e);O(e)&&(this._processSelectableItem(t,!0),f.default.triggerHandler(t,"stateChanged",!0))},_isItemSelected:function(e){var t=this._getKeyByIndex(e);return this._selection.isItemSelected(t)},_optionChanged:function(e){var t=this;switch(e.name){case"selectionMode":"multi"===e.value?this._showDeprecatedSelectionMode():this._invalidate();break;case"dataSource":(!e.value||Array.isArray(e.value)&&!e.value.length)&&this.option("selectedItemKeys",[]),this.callBase(e);break;case"selectedIndex":case"selectedItem":case"selectedItems":case"selectedItemKeys":this._syncSelectionOptions(e.name).done(function(){return t._normalizeSelectedItems()});break;case"keyExpr":this._initKeyGetter();break;case"selectionRequired":this._normalizeSelectedItems();break;case"selectionByClick":case"onSelectionChanged":case"onItemDeleting":case"onItemDeleted":case"onItemReordered":case"maxFilterLengthInRequest":break;default:this.callBase(e)}},_clearSelectedItems:function(){this._setOptionSilent("selectedItems",[]),this._syncSelectionOptions("selectedItems")},_waitDeletingPrepare:function(e){if(e.data(E))return(new T.Deferred).resolve().promise();e.data(E,!0);var t=new T.Deferred,n={cancel:!1},i=this._itemEventHandler(e,"onItemDeleting",n,{excludeValidators:["disabled","readOnly"]});return(0,T.when)(i).always(function(o){var a=!i,r=!a&&"resolved"===i.state(),s=!!arguments.length,l=a||r&&!s||r&&o;(0,T.when)((0,T.fromPromise)(n.cancel)).always(function(){e.data(E,!1)}).done(function(e){l&&!e?t.resolve():t.reject()}).fail(t.reject)}.bind(this)),t.promise()},_deleteItemFromDS:function(e){if(!this._dataSource)return(new T.Deferred).resolve().promise();var t=new T.Deferred,n=this.option("disabled"),i=this._dataSource.store();if(this.option("disabled",!0),!i.remove)throw m.default.Error("E1011");return i.remove(i.keyOf(this._getItemData(e))).done(function(e){void 0!==e?t.resolve():t.reject()}).fail(function(){t.reject()}),t.always(function(){this.option("disabled",n)}.bind(this)),t},_tryRefreshLastPage:function(){var e=new T.Deferred;return this._isLastPage()||this.option("grouped")?e.resolve():this._refreshLastPage().done(function(){e.resolve()}),e.promise()},_refreshLastPage:function(){return this._expectLastItemLoading(),this._dataSource.load()},_updateSelectionAfterDelete:function(e){var t=this._getKeyByIndex(e);this._selection.deselect([t])},_updateIndicesAfterIndex:function(e){for(var t=this._itemElements(),n=e+1;n<t.length;n++)(0,d.default)(t[n]).data(this._itemIndexKey(),n-1)},_simulateOptionChange:function(e){var t=this.option(e);t instanceof S.DataSource||this._optionChangedAction({name:e,fullName:e,value:t})},isItemSelected:function(e){return this._isItemSelected(this._editStrategy.getNormalizedIndex(e))},selectItem:function(e){if("none"!==this.option("selectionMode")){var t=this._editStrategy.getNormalizedIndex(e);if(O(t)){var n=this._getKeyByIndex(t);if(!this._selection.isItemSelected(n))if("single"===this.option("selectionMode"))this._selection.setSelection([n]);else{var i=this.option("selectedItemKeys")||[];this._selection.setSelection([].concat(o(i),[n]))}}}},unselectItem:function(e){var t=this._editStrategy.getNormalizedIndex(e);if(O(t)){var n=this._selection.getSelectedItemKeys();if(!(this.option("selectionRequired")&&n.length<=1)){var i=this._getKeyByIndex(t);this._selection.isItemSelected(i)&&this._selection.deselect([i])}}},_deleteItemElementByIndex:function(e){this._updateSelectionAfterDelete(e),this._updateIndicesAfterIndex(e),this._editStrategy.deleteItemAtIndex(e)},_afterItemElementDeleted:function(e,t){var n=this._dataSource?"dataSource":"items";this._simulateOptionChange(n),this._itemEventHandler(e,"onItemDeleted",t,{beforeExecute:function(){e.remove()},excludeValidators:["disabled","readOnly"]}),this._renderEmptyMessage()},deleteItem:function(e){var t=this,n=new T.Deferred,i=this._editStrategy.getItemElement(e),o=this._editStrategy.getNormalizedIndex(e),a=this._itemResponseWaitClass();return O(o)?this._waitDeletingPrepare(i).done(function(){i.addClass(a);var e=t._extendActionArgs(i);t._deleteItemFromDS(i).done(function(){t._deleteItemElementByIndex(o),t._afterItemElementDeleted(i,e),t._tryRefreshLastPage().done(function(){n.resolveWith(t)})}).fail(function(){i.removeClass(a),n.rejectWith(t)})}).fail(function(){n.rejectWith(t)}):n.rejectWith(t),n.promise()},reorderItem:function(e,t){var n=new T.Deferred,i=this,o=this._editStrategy,a=o.getItemElement(e),r=o.getItemElement(t),s=o.getNormalizedIndex(e),l=o.getNormalizedIndex(t),u=this._dataSource?"dataSource":"items",c=O(s)&&O(l)&&s!==l;return c?n.resolveWith(this):n.rejectWith(this),n.promise().done(function(){r[o.itemPlacementFunc(s,l)](a),o.moveItemAtIndexToIndex(s,l),this._updateIndicesAfterIndex(s),i.option("selectedItems",i._getItemsByKeys(i._selection.getSelectedItemKeys(),i._selection.getSelectedItems())),"items"===u&&i._simulateOptionChange(u),i._itemEventHandler(a,"onItemReordered",{fromIndex:o.getIndex(s),toIndex:o.getIndex(l)},{excludeValidators:["disabled","readOnly"]})})}});e.exports=P},function(e,t,n){function i(e){return e&&e.__esModule?e:{"default":e}}var o=n(2),a=i(o),r="dx-icon",s="dx-svg-icon",l=function(e){return!(!e||"string"!=typeof e)&&(/^\s*<svg[^>]*>(.|\r\n|\r|\n)*?<\/svg>\s*$/i.test(e)?"svg":/data:.*base64|\.|[^<\s]\//.test(e)?"image":/^[\w-_]+$/.test(e)?"dxIcon":!!/^\s?([\w-_]\s?)+$/.test(e)&&"fontIcon")},u=function(e){switch(l(e)){case"image":return(0,a.default)("<img>").attr("src",e).addClass(r);case"fontIcon":return(0,a.default)("<i>").addClass("".concat(r," ").concat(e));case"dxIcon":return(0,a.default)("<i>").addClass("".concat(r," ").concat(r,"-").concat(e));case"svg":return(0,a.default)("<i>").addClass("".concat(r," ").concat(s)).append(e);default:return null}};t.getImageSourceType=l,t.getImageContainer=u},function(e,t,n){function i(e){return e&&e.__esModule?e:{"default":e}}function o(){return r||(r=a()),r}function a(){var e=(0,u.getWindow)(),t=e&&e.Quill||n(328);if(!t)throw l.default.Error("E1041","Quill");return t}Object.defineProperty(t,"__esModule",{value:!0}),t.getQuill=void 0;var r,s=n(18),l=i(s),u=n(7);t.getQuill=o},function(e,t,n){e.exports=n(484)},function(e,t){e.exports=window.ko},function(e,t,n){var i=function(e){var t,n=function(){return t=e.apply(this,arguments),n=function(){return t},t};return function(){return n.apply(this,arguments)}};e.exports=i},function(e,t,n){var i=n(6).Deferred,o=n(11),a=n(459),r=n(7),s=r.getWindow(),l=n(0).extendFromObject,u=n(1).isDefined,c=n(68),d=n(55),h="success",f="error",p="timeout",g="nocontent",_="parsererror",m=function(e){return 200<=e&&e<300},v=function(e){return 204!==e},y=function(e){var t=[];for(var n in e){var i=e[n];void 0!==i&&(null===i&&(i=""),t.push(encodeURIComponent(n)+"="+encodeURIComponent(i)))}return t.join("&")},b=function(e){var t=o.createElement("script");for(var n in e)t[n]=e[n];return t},x=function(e){e.parentNode.removeChild(e)},w=function(e){return o.getHead().appendChild(e)},C=function(e){var t=b({text:e});w(t),x(t)},k=function(e){var t=b({src:e});return new c(function(e,n){var i={load:e,error:n},a=function(e){i[e.type](),x(t)};for(var r in i)o.listen(t,r,a);w(t)})},S=function(e){var t=e.dataType||"*",n="text/javascript, application/javascript, application/ecmascript, application/x-ecmascript",i={"*":"*/*",text:"text/plain",html:"text/html",xml:"application/xml, text/xml",json:"application/json, text/javascript",jsonp:n,script:n};return l(i,e.accepts,!0),i[t]?i[t]+("*"!==t?", */*; q=0.01":""):i["*"]},I=function(e){var t;return e.data&&!e.upload&&"GET"!==R(e)&&(t="application/x-www-form-urlencoded;charset=utf-8"),e.contentType||t},D=function(e){return e.responseType&&"text"!==e.responseType||"string"!=typeof e.responseText?e.response:e.responseText},T=function(e,t,n){var i=D(t);switch(n){case"jsonp":C(i);break;case"script":C(i),e.resolve(i,h,t);break;case"json":try{e.resolve(JSON.parse(i),h,t)}catch(n){e.reject(t,_,n)}break;default:e.resolve(i,h,t)}},E=function(e){if(!r.hasWindow())return!0;var t=!1,n=o.createElement("a"),i=o.createElement("a");n.href=s.location.href;try{i.href=e,i.href=i.href,t=n.protocol+"//"+n.host!=i.protocol+"//"+i.host}catch(e){t=!0}return t},A=function(e,t){return e&&setTimeout(function(){t.customStatus=p,t.abort()},e)},O=function(e){if("jsonp"===e.dataType){var t=Math.random().toString().replace(/\D/g,""),n=e.jsonpCallback||"dxCallback"+Date.now()+"_"+t,i=e.jsonp||"callback";return e.data=e.data||{},e.data[i]=n,n}},P=function(e,t){var n=e.data,i="string"==typeof n,o=e.url||s.location.href;return i||e.cache||(n=n||{},n._=Date.now()),n&&!e.upload&&(i||(n=y(n)),"GET"===R(e)?(""!==n&&(o+=(o.indexOf("?")>-1?"&":"?")+n),n=null):t["Content-Type"]&&t["Content-Type"].indexOf("application/x-www-form-urlencoded")>-1&&(n=n.replace(/%20/g,"+"))),{url:o,parameters:n}},R=function(e){return(e.method||"GET").toUpperCase()},B=function(e){var t=e.headers||{};return t["Content-Type"]=t["Content-Type"]||I(e),t.Accept=t.Accept||S(e),
e.crossDomain||t["X-Requested-With"]||(t["X-Requested-With"]="XMLHttpRequest"),t},M=function(e){var t,n=a.getXhr(),o=new i,r=o.promise(),l=!u(e.async)||e.async,c=e.dataType,d=e.timeout||0;e.crossDomain=E(e.url);var p="jsonp"===c||"script"===c;void 0===e.cache&&(e.cache=!p);var _=O(e),y=B(e),b=P(e,y),x=b.url,w=b.parameters;if(_&&(s[_]=function(e){o.resolve(e,h,n)}),e.crossDomain&&p){var C=function(){o.reject(n,f)},S=function(){"jsonp"!==c&&o.resolve(null,h,n)};return k(x).then(S,C),r}if(e.crossDomain&&!("withCredentials"in n))return o.reject(n,f),r;if(n.open(R(e),x,l,e.username,e.password),l&&(n.timeout=d,t=A(d,n,o)),n.onreadystatechange=function(e){4===n.readyState&&(clearTimeout(t),m(n.status)?v(n.status)?T(o,n,c):o.resolve(null,g,n):o.reject(n,n.customStatus||f))},e.upload&&(n.upload.onprogress=e.upload.onprogress,n.upload.onloadstart=e.upload.onloadstart,n.upload.onabort=e.upload.onabort),e.xhrFields)for(var I in e.xhrFields)n[I]=e.xhrFields[I];"arraybuffer"===e.responseType&&(n.responseType=e.responseType);for(var D in y)Object.prototype.hasOwnProperty.call(y,D)&&u(y[D])&&n.setRequestHeader(D,y[D]);return e.beforeSend&&e.beforeSend(n),n.send(w),r.abort=function(){n.abort()},r};e.exports=d({sendRequest:M})},function(e,t,n){var i=n(1).isFunction,o=function(){},a=function(e){return"undefined"!=typeof console&&i(console[e])?console[e].bind(console):o},r={info:a("info"),warn:a("warn"),error:a("error")},s=function(){function e(e,t){if(!e)throw new Error(t)}function t(t,n){e(null!==t&&void 0!==t,n)}return{assert:e,assertParam:t}}();t.logger=r,t.debug=s},function(e,t,n){var i=n(1),o=n(25),a=n(49),r=n(37),s=n(55);n(115),e.exports=s({format:function(e,t){var n=i.isString(t)&&""!==t||i.isPlainObject(t)||i.isFunction(t),o=i.isNumeric(e)||i.isDate(e);return n&&o?i.isFunction(t)?t(e):(i.isString(t)&&(t={type:t}),i.isNumeric(e)?a.format(e,t):i.isDate(e)?r.format(e,t):void 0):i.isDefined(e)?e.toString():""},getTimeFormat:function(e){return e?"longtime":"shorttime"},_normalizeFormat:function(e){return Array.isArray(e)?1===e.length?e[0]:function(t){return e.map(function(e){return r.format(t,e)}).join(" ")}:e},getDateFormatByDifferences:function(e,t){var n=[],i=t&&e.millisecond&&!(e.year||e.month||e.day);if(i){var o=function(e){return e.getSeconds()+e.getMilliseconds()/1e3+"s"};n.push(o)}else e.millisecond&&n.push("millisecond");if((e.hour||e.minute||!i&&e.second)&&n.unshift(this.getTimeFormat(e.second)),e.year&&e.month&&e.day)return t&&"month"===t?"monthandyear":(n.unshift("shortdate"),this._normalizeFormat(n));if(e.year&&e.month)return"monthandyear";if(e.year&&e.quarter)return"quarterandyear";if(e.year)return"year";if(e.quarter)return"quarter";if(e.month&&e.day){if(t){var a=function(e){return r.getMonthNames("abbreviated")[e.getMonth()]+" "+r.format(e,"day")};n.unshift(a)}else n.unshift("monthandday");return this._normalizeFormat(n)}if(e.month)return"month";if(e.day){if(t)n.unshift("day");else{var s=function(e){return r.format(e,"dayofweek")+", "+r.format(e,"day")};n.unshift(s)}return this._normalizeFormat(n)}return this._normalizeFormat(n)},getDateFormatByTicks:function(e){var t;if(e.length>1){t=o.getDatesDifferences(e[0],e[1]);for(var n=1;n<e.length-1;n++){var i=o.getDatesDifferences(e[n],e[n+1]);t.count<i.count&&(t=i)}}else t={year:!0,month:!0,day:!0,hour:e[0].getHours()>0,minute:e[0].getMinutes()>0,second:e[0].getSeconds()>0,millisecond:e[0].getMilliseconds()>0};var a=this.getDateFormatByDifferences(t);return a},getDateFormatByTickInterval:function(e,t,n){var a,r={week:"day"},s=function(e,t,n){switch(t){case"year":case"quarter":e.month=n;case"month":e.day=n;case"week":case"day":e.hour=n;case"hour":e.minute=n;case"minute":e.second=n;case"second":e.millisecond=n}},l=function(e,t,n){!n.getMilliseconds()&&n.getSeconds()?n.getSeconds()-t.getSeconds()===1&&(e.millisecond=!0,e.second=!1):!n.getSeconds()&&n.getMinutes()?n.getMinutes()-t.getMinutes()===1&&(e.second=!0,e.minute=!1):!n.getMinutes()&&n.getHours()?n.getHours()-t.getHours()===1&&(e.minute=!0,e.hour=!1):!n.getHours()&&n.getDate()>1?n.getDate()-t.getDate()===1&&(e.hour=!0,e.day=!1):1===n.getDate()&&n.getMonth()?n.getMonth()-t.getMonth()===1&&(e.day=!0,e.month=!1):!n.getMonth()&&n.getFullYear()&&n.getFullYear()-t.getFullYear()===1&&(e.month=!0,e.year=!1)};n=i.isString(n)?n.toLowerCase():n;var u=o.getDatesDifferences(e,t);e!==t&&l(u,e>t?t:e,e>t?e:t),a=o.getDateUnitInterval(u),s(u,a,!0),a=o.getDateUnitInterval(n||"second"),s(u,a,!1),u[r[a]||a]=!0;var c=this.getDateFormatByDifferences(u);return c}})},function(e,t,n){var i=n(2),o=n(11),a=function(e,t){if(!r(e))return!1;var n=e.nodeName.toLowerCase(),i=!isNaN(t),o=e.disabled,a=/^(input|select|textarea|button|object|iframe)$/.test(n),s="a"===n,l=!0,u=e.isContentEditable;return l=a||u?!o:s?e.href||i:i},r=function(e){var t=i(e);return t.is(":visible")&&"hidden"!==t.css("visibility")&&"hidden"!==t.parents().css("visibility")};e.exports={focusable:function(e,t){return a(t,i(t).attr("tabIndex"))},tabbable:function(e,t){var n=i(t).attr("tabIndex");return(isNaN(n)||n>=0)&&a(t,n)},focused:function(e){var t=i(e).get(0);return o.getActiveElement()===t}}},function(e,t,n){function i(e){"@babel/helpers - typeof";return(i="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}function o(e){return e&&e.__esModule?e:{"default":e}}function a(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}function r(e,t){for(var n=0;n<t.length;n++){var i=t[n];i.enumerable=i.enumerable||!1,i.configurable=!0,"value"in i&&(i.writable=!0),Object.defineProperty(e,i.key,i)}}function s(e,t,n){return t&&r(e.prototype,t),n&&r(e,n),e}function l(e,t){if("function"!=typeof t&&null!==t)throw new TypeError("Super expression must either be null or a function");e.prototype=Object.create(t&&t.prototype,{constructor:{value:e,writable:!0,configurable:!0}}),t&&u(e,t)}function u(e,t){return(u=Object.setPrototypeOf||function(e,t){return e.__proto__=t,e})(e,t)}function c(e){var t=f();return function(){var n,i=p(e);if(t){var o=p(this).constructor;n=Reflect.construct(i,arguments,o)}else n=i.apply(this,arguments);return d(this,n)}}function d(e,t){return!t||"object"!==i(t)&&"function"!=typeof t?h(e):t}function h(e){if(void 0===e)throw new ReferenceError("this hasn't been initialised - super() hasn't been called");return e}function f(){if("undefined"==typeof Reflect||!Reflect.construct)return!1;if(Reflect.construct.sham)return!1;if("function"==typeof Proxy)return!0;try{return Date.prototype.toString.call(Reflect.construct(Date,[],function(){})),!0}catch(e){return!1}}function p(e){return(p=Object.setPrototypeOf?Object.getPrototypeOf:function(e){return e.__proto__||Object.getPrototypeOf(e)})(e)}Object.defineProperty(t,"__esModule",{value:!0}),t.BindableTemplate=void 0;var g=n(2),_=o(g),m=n(70),v=n(5),y=n(137),b=o(y),x=n(1),w=function(){var e=function(e,t,n){return t(function(){return e},n)},t=function(e,t,n,i,o){var a={},r=n.slice(),s=n.map(function(n){var s=i[n];return t(s?function(){return s(e)}:function(){return e[n]},function(e){if(a[n]=e,r.length){var t=r.indexOf(n);t>=0&&r.splice(t,1)}r.length||o(a)})});return function(){s.forEach(function(e){return e()})}};return function(n,i,o,a,r){var s,l=e(n,i,function(e){return s&&s(),(0,x.isPrimitive)(e)?void r(e):void(s=t(e,i,o,a,r))});return function(){s&&s(),l&&l()}}}();t.BindableTemplate=function(e){function t(e,i,o,r){var s;return a(this,t),s=n.call(this),s._render=e,s._fields=i,s._fieldsMap=r||{},s._watchMethod=o,s}l(t,e);var n=c(t);return s(t,[{key:"_renderCore",value:function(e){var t=this,n=(0,_.default)(e.container),i=w(e.model,this._watchMethod,this._fields,this._fieldsMap,function(i){n.empty(),t._render(n,i,e.model)});return(0,v.on)(n,b.default,i),n.contents()}}]),t}(m.TemplateBase)},function(e,t,n){var i=n(6),o=n(7),a=i.Deferred,r=i.when,s=o.hasWindow()?o.getWindow().Promise:Promise;s||(s=function(e){var t=new a;return e(t.resolve.bind(this),t.reject.bind(this)),t.promise()},s.resolve=function(e){return(new a).resolve(e).promise()},s.reject=function(e){return(new a).reject(e).promise()},s.all=function(e){return r.apply(this,e).then(function(){return[].slice.call(arguments)})}),e.exports=s},function(e,t,n){var i=n(3).each,o=n(114),a=function(e,t){var n={};"noBubble"in t&&(n.noBubble=t.noBubble),"bindType"in t&&(n.bindType=t.bindType),"delegateType"in t&&(n.delegateType=t.delegateType),i(["setup","teardown","add","remove","trigger","handle","_default","dispose"],function(e,i){t[i]&&(n[i]=function(){var e=[].slice.call(arguments);return e.unshift(this),t[i].apply(t,e)})}),o.fire(e,n)};a.callbacks=o,e.exports=a},function(e,t,n){function i(e){return e&&e.__esModule?e:{"default":e}}function o(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}function a(e,t){for(var n=0;n<t.length;n++){var i=t[n];i.enumerable=i.enumerable||!1,i.configurable=!0,"value"in i&&(i.writable=!0),Object.defineProperty(e,i.key,i)}}function r(e,t,n){return t&&a(e.prototype,t),n&&a(e,n),e}Object.defineProperty(t,"__esModule",{value:!0}),t.TemplateBase=t.renderedCallbacks=void 0;var s=n(2),l=i(s),u=n(11),c=n(27),d=i(c),h=n(12),f=n(21),p=i(f),g=t.renderedCallbacks=(0,d.default)({syncStrategy:!0});t.TemplateBase=function(){function e(){o(this,e)}return r(e,[{key:"render",value:function(e){e=e||{};var t=e.onRendered;delete e.onRendered;var n=this._renderCore(e);return this._ensureResultInContainer(n,e.container),g.fire(n,e.container),t&&t(),n}},{key:"_ensureResultInContainer",value:function(e,t){if(t){var n=(0,l.default)(t),i=(0,h.contains)(n.get(0),e.get(0));if(n.append(e),!i){var o=(0,u.getBody)().contains(n.get(0));o&&(0,h.triggerShownEvent)(e)}}}},{key:"_renderCore",value:function(){throw p.default.Error("E0001")}}]),e}()},function(e,t,n){var i=n(2),o=n(39),a=n(14).wrapToArray,r=n(14).inArray,s=n(3),l=n(12).contains,u=n(69),c=n(8),d=n(159),h=n(91),f="dxdragstart",p="dxdrag",g="dxdragend",_="dxdragenter",m="dxdragleave",v="dxdrop",y="dxDragEventsCount",b=[],x=[],w=[],C={setup:function(e,t){var n=r(e,b)!==-1;n||(b.push(e),x.push([]),w.push(t||{}))},add:function(e,t){var n=r(e,b);this.updateEventsCounter(e,t.type,1);var i=t.selector;r(i,x[n])===-1&&x[n].push(i)},updateEventsCounter:function(e,t,n){if([_,m,v].indexOf(t)>-1){var i=o.data(e,y)||0;o.data(e,y,Math.max(0,i+n))}},remove:function(e,t){this.updateEventsCounter(e,t.type,-1)},teardown:function(e){var t=o.data(e,y);if(!t){var n=r(e,b);b.splice(n,1),x.splice(n,1),w.splice(n,1),o.removeData(e,y)}}};u(_,C),u(m,C),u(v,C);var k=function(e){var t=r(e.get(0),b),n=x[t].filter(function(e){return e}),i=e.find(n.join(", "));return r(void 0,x[t])!==-1&&(i=i.add(e)),i},S=function(e){var t=r(e.get(0),b);return w[t]},I=function(e,t){return e.itemPositionFunc?e.itemPositionFunc(t):t.offset()},D=function(e,t){return e.itemSizeFunc?e.itemSizeFunc(t):{width:t.get(0).getBoundingClientRect().width,height:t.get(0).getBoundingClientRect().height}},T=d.inherit({ctor:function(e){this.callBase(e),this.direction="both"},_init:function(e){this._initEvent=e},_start:function(e){e=this._fireEvent(f,this._initEvent),this._maxLeftOffset=e.maxLeftOffset,this._maxRightOffset=e.maxRightOffset,this._maxTopOffset=e.maxTopOffset,this._maxBottomOffset=e.maxBottomOffset;var t=a(e.targetElements||(null===e.targetElements?[]:b));this._dropTargets=s.map(t,function(e){return i(e).get(0)})},_move:function(e){var t=c.eventData(e),n=this._calculateOffset(t);e=this._fireEvent(p,e,{offset:n}),this._processDropTargets(e),e._cancelPreventDefault||e.preventDefault()},_calculateOffset:function(e){return{x:this._calculateXOffset(e),y:this._calculateYOffset(e)}},_calculateXOffset:function(e){if("vertical"!==this.direction){var t=e.x-this._startEventData.x;return this._fitOffset(t,this._maxLeftOffset,this._maxRightOffset)}return 0},_calculateYOffset:function(e){if("horizontal"!==this.direction){var t=e.y-this._startEventData.y;return this._fitOffset(t,this._maxTopOffset,this._maxBottomOffset)}return 0},_fitOffset:function(e,t,n){return null!=t&&(e=Math.max(e,-t)),null!=n&&(e=Math.min(e,n)),e},_processDropTargets:function(e){var t=this._findDropTarget(e),n=t===this._currentDropTarget;n||(this._fireDropTargetEvent(e,m),this._currentDropTarget=t,this._fireDropTargetEvent(e,_))},_fireDropTargetEvent:function(e,t){if(this._currentDropTarget){var n={type:t,originalEvent:e,draggingElement:this._$element.get(0),target:this._currentDropTarget};c.fireEvent(n)}},_findDropTarget:function(e){var t,n=this;return s.each(b,function(o,a){if(n._checkDropTargetActive(a)){var r=i(a);s.each(k(r),function(o,a){var s=i(a);n._checkDropTarget(S(r),s,e)&&(t=a)})}}),t},_checkDropTargetActive:function(e){var t=!1;return s.each(this._dropTargets,function(n,i){return t=t||i===e||l(i,e),!t}),t},_checkDropTarget:function(e,t,n){var o=t.get(0)===i(n.target).get(0);if(o)return!1;var a=I(e,t);if(n.pageX<a.left)return!1;if(n.pageY<a.top)return!1;var r=D(e,t);return!(n.pageX>a.left+r.width)&&(!(n.pageY>a.top+r.height)&&(!(e.checkDropTarget&&!e.checkDropTarget(t,n))&&t))},_end:function(e){var t=c.eventData(e);this._fireEvent(g,e,{offset:this._calculateOffset(t)}),this._fireDropTargetEvent(e,v),delete this._currentDropTarget}});h({emitter:T,events:[f,p,g]}),t.move=p,t.start=f,t.end=g,t.enter=_,t.leave=m,t.drop=v},function(e,t,n){function i(e){return e&&e.__esModule?e:{"default":e}}var o=n(42),a=n(44),r=i(a),s=n(38),l=n(92),u=i(l),c=n(138),d=i(c),h=u.default.inherit({ctor:function(e){e=Array.isArray(e)?{data:e}:e||{},this.callBase(e);var t=e.data;if(t&&!Array.isArray(t))throw s.errors.Error("E4006");this._array=t||[]},createQuery:function(){return(0,r.default)(this._array,{errorHandler:this._errorHandler})},_byKeyImpl:function(e){var t=d.default.indexByKey(this,this._array,e);return t===-1?(0,o.rejectedPromise)(s.errors.Error("E4009")):(0,o.trivialPromise)(this._array[t])},_insertImpl:function(e){return d.default.insert(this,this._array,e)},_pushImpl:function(e){d.default.applyBatch(this,this._array,e)},_updateImpl:function(e,t){return d.default.update(this,this._array,e,t)},_removeImpl:function(e){return d.default.remove(this,this._array,e)},clear:function(){this.fireEvent("modifying"),this._array=[],this.fireEvent("modified")}},"array");e.exports=h},function(e,t){e.exports=window.Globalize},function(e,t,n){var i=n(2),o=n(52),a=o.add,r=n(27)(),s=i(),l=function(){var e;return function(t){if(!arguments.length)return e;var n=i(t);s=n;var o=!!n.length,a=l();e=o?n:i("body"),r.fire(o?l():i(),a)}}();a(function(){l(".dx-viewport")}),t.value=l,t.changeCallback=r,t.originalViewPort=function(){return s}},function(e,t,n){var i=n(2),o="dx-inkripple",a="dx-inkripple-wave",r="dx-inkripple-showing",s="dx-inkripple-hiding",l=2,u=4e3,c=300,d=1e3,h=0,f=function(e){e=e||{},void 0===e.useHoldAnimation&&(e.useHoldAnimation=!0);var t={waveSizeCoefficient:e.waveSizeCoefficient||l,isCentered:e.isCentered||!1,wavesNumber:e.wavesNumber||1,durations:y(e.useHoldAnimation)};return{showWave:m.bind(this,t),hideWave:x.bind(this,t)}},p=function(e){var t=e.children("."+o);return 0===t.length&&(t=i("<div>").addClass(o).appendTo(e)),t},g=function(e,t){for(var n=p(e),o=n.children("."+a).toArray(),r=o.length;r<t;r++){var s=i("<div>").appendTo(n).addClass(a);o.push(s[0])}return i(o)},_=function(e,t){var n,i,o=t.element,a=o.outerWidth(),r=o.outerHeight(),s=parseInt(Math.sqrt(a*a+r*r)),l=Math.min(u,parseInt(s*e.waveSizeCoefficient));if(e.isCentered)n=(a-l)/2,i=(r-l)/2;else{var c=t.event,d=t.element.offset(),h=c.pageX-d.left,f=c.pageY-d.top;n=h-l/2,i=f-l/2}return{left:n,top:i,height:l,width:l}},m=function(e,t){var n=g(t.element,e.wavesNumber).eq(t.wave||h);e.hidingTimeout&&clearTimeout(e.hidingTimeout),b(n),n.css(_(e,t)),e.showingTimeout=setTimeout(v.bind(this,e,n),0)},v=function(e,t){var n=e.durations.showingScale+"ms";t.addClass(r).css("transitionDuration",n)},y=function(e){return{showingScale:e?d:c,hidingScale:c,hidingOpacity:c}},b=function(e){e.removeClass(s).css("transitionDuration","")},x=function(e,t){e.showingTimeout&&clearTimeout(e.showingTimeout);var n=g(t.element,t.wavesNumber).eq(t.wave||h),i=e.durations,o=i.hidingScale+"ms, "+i.hidingOpacity+"ms";n.addClass(s).removeClass(r).css("transitionDuration",o);var a=Math.max(i.hidingScale,i.hidingOpacity);e.hidingTimeout=setTimeout(b.bind(this,n),a)};e.exports={render:f}},function(e,t,n){function i(e){return e&&e.__esModule?e:{"default":e}}function o(e){return e>0?Math.round(e):0}function a(e,t,n,i){var o,r=[],s=i.nodes,l=t.length,u=0;for(o=0;o<l;++o){var c=t[o],d=new x.default;d._id=s.length,d.ctx=i.ctx,d.parent=e,d.level=n,d.index=r.length,d.data=c,i.buildNode(d),s.push(d),r.push(d);var h=c[i.itemsField];h&&h.length&&a(d,h,n+1,i),c[i.valueField]>0&&(d.value=Number(c[i.valueField])),u+=d.value}e.nodes=r,e.value=u}function r(e,t,n){var i,o=t.nodes,a=o.length;for(i=0;i<a;++i){var s=o[i];n(e,s),s.isNode()&&r(e,s,n)}}function s(e,t){t.color=t.data[e.colorField]||e.getColor(t)||t.parent.color,t.updateStyles(),t.tile=!t.ctx.forceReset&&t.tile||O[Number(t.isNode())](e,t),t.applyState()}function l(e,t){var n=e.renderer.simpleRect().append(e.group);return e.setTrackerData(t,n),n}function u(e,t){var n=e.renderer.simpleRect().append(e.group),i=e.renderer.simpleRect().append(e.group);return e.setTrackerData(t,i),{outer:n,inner:i}}function c(e,t){t.updateLabelStyle(),t.labelState.visible&&d(e,t,t.labelState,t.labelParams)}function d(e,t,n,i){var o=t.data[e.labelField];t.label=o?String(o):null,o=t.customLabel||t.label,o&&(t.text=e.renderer.text(o).attr(n.attr).css(n.css).append(e.group),e.setTrackerData(t,t.text))}function h(e,t){var n,i=t.nodes,o=[],a=[],r=0,s=o.length=a.length=i.length;for(n=0;n<s;++n)r+=i[n].value,o[n]={value:i[n].value,i:n};for(r>0&&e.algorithm({items:o.slice(),sum:r,rect:t.innerRect.slice(),isRotated:1&i[0].level,directions:e.directions}),n=0;n<s;++n)a[n]=o[n].rect||P;t.rects=a}function f(e,t){var n=t.parent.rects[t.index],i=e.rectOffsets;if(t.isNode()){_(t.tile.outer,g(n,t.parent.innerRect,i.headerEdge,i.headerInner)),n=p(n,e.groupPadding);var o=Math.min(e.headerHeight,n[3]-n[1]);t.rect=[n[0],n[1],n[2],n[1]+o],_(t.tile.inner,p(t.rect,i.headerEdge)),n[1]+=o,t.innerRect=n,h(e,t)}else t.rect=n,_(t.tile,g(n,t.parent.innerRect,i.tileEdge,i.tileInner))}function p(e,t){return[e[0]+t,e[1]+t,e[2]-t,e[3]-t]}function g(e,t,n,i){return[e[0]+(e[0]===t[0]?n:+i),e[1]+(e[1]===t[1]?n:+i),e[2]-(e[2]===t[2]?n:-i),e[3]-(e[3]===t[3]?n:-i)]}function _(e,t){e.attr({x:t[0],y:t[1],width:T(t[2]-t[0],0),height:T(t[3]-t[1],0)})}function m(e,t){t.text&&t.labelState.visible&&v(t,t.labelParams)}function v(e,t){var n=e.rect,i=e.text,o=i.getBBox(),a=t.paddingLeftRight,r=t.paddingTopBottom,s=n[2]-n[0]-2*a,l=o.height+r<=n[3]-n[1],u=o.width<=s,c=t.resolveLabelOverflow,d=t.groupLabelOverflow,h=t.tileLabelOverflow,f=t.tileLabelWordWrap;(0,I.isDefined)(c)?"ellipsis"===c&&l&&(i.setMaxSize(s,void 0,{wordWrap:"none",textOverflow:"ellipsis"}),u||(o=i.getBBox(),u=o.width<=s)):(u=!0,l=!0,i.setMaxSize(s,n[3]-n[1]-r,e.isNode()?{textOverflow:d,wordWrap:"none"}:{textOverflow:h,wordWrap:f,hideOverflowEllipsis:!0})),i.attr({visibility:l&&u?"visible":"hidden"}),l&&u&&i.move(t.rtlEnabled?n[2]-a-o.x-o.width:n[0]+a-o.x,n[1]+r-o.y)}var y=n(287),b=n(175),x=i(b),w=n(126),C=n(127),k=n(13),S=n(4),I=n(1),D=n(0),T=Math.max,E={lefttoprightbottom:[1,1],leftbottomrighttop:[1,-1],righttopleftbottom:[-1,1],rightbottomlefttop:[-1,-1]};n(435),n(126).setDefaultAlgorithm("squarified"),n(437),n(127).setDefaultColorizer("discrete");var A=n(98).inherit({_handlers:{beginBuildNodes:S.noop,buildNode:S.noop,endBuildNodes:S.noop,setTrackerData:S.noop,calculateState:function(e){return(0,y.buildRectAppearance)(e)}},_rootClass:"dxtm-tree-map",_rootClassPrefix:"dxtm",_getDefaultSize:function(){return{width:400,height:400}},_setDeprecatedOptions:function(){this.callBase.apply(this,arguments),(0,D.extend)(this._deprecatedOptions,{resolveLabelOverflow:{since:"19.1",message:"Use the 'tile.label.overflow' and 'group.label.textOverflow' option instead"}})},_themeSection:"treeMap",_fontFields:["tile.label.font","group.label.font"],_init:function(){var e=this;e._rectOffsets={},e._handlers=Object.create(e._handlers),e._context={suspend:function(){e._applyingChanges||e._suspendChanges()},resume:function(){e._applyingChanges||e._resumeChanges()},change:function(t){e._change(t)},settings:[{},{}],calculateState:e._handlers.calculateState,calculateLabelState:y.buildTextAppearance},e._root=e._topNode={nodes:[]},e.callBase.apply(e,arguments)},_initialChanges:["DATA_SOURCE"],_initCore:function(){var e=this,t=e._renderer;e._createProxyType(),e._tilesGroup=t.g().linkOn(t.root,"tiles").linkAppend(),e._labelsGroup=t.g().linkOn(t.root,"labels").linkAppend()},_createProxyType:S.noop,_disposeCore:function(){var e=this;e._filter&&e._filter.dispose(),e._labelsGroup.linkOff(),e._tilesGroup.linkOff()},_applySize:function(e){this._tilingRect=e.slice(),this._change(["TILING"])},_optionChangesMap:{dataSource:"DATA_SOURCE",valueField:"NODES_CREATE",childrenField:"NODES_CREATE",colorField:"TILES",colorizer:"TILES",labelField:"LABELS",tile:"TILE_SETTINGS",group:"GROUP_SETTINGS",maxDepth:"MAX_DEPTH",layoutAlgorithm:"TILING",layoutDirection:"TILING",resolveLabelOverflow:"LABEL_OVERFLOW"},_themeDependentChanges:["TILE_SETTINGS","GROUP_SETTINGS","MAX_DEPTH"],_changeDataSource:function(){var e=this;e._isDataExpected=e._isSyncData=!0,e._updateDataSource(),e._isSyncData=!1,e._isDataExpected&&e._suspendChanges()},_dataSourceChangedHandler:function(){var e=this;e._isDataExpected?(e._isDataExpected=!1,e._change(["NODES_CREATE"]),e._isSyncData||e._resumeChanges()):e._requestChange(["NODES_CREATE"])},_optionChangesOrder:["DATA_SOURCE","TILE_SETTINGS","GROUP_SETTINGS","MAX_DEPTH","LABEL_OVERFLOW"],_change_DATA_SOURCE:function(){this._changeDataSource()},_change_TILE_SETTINGS:function(){this._changeTileSettings()},_change_GROUP_SETTINGS:function(){this._changeGroupSettings()},_change_LABEL_OVERFLOW:function(){this._changeTileSettings(),this._changeGroupSettings()},_change_MAX_DEPTH:function(){this._changeMaxDepth()},_customChangesOrder:["NODES_CREATE","NODES_RESET","TILES","LABELS","TILING","LABELS_LAYOUT"],_change_NODES_CREATE:function(){this._buildNodes()},_change_NODES_RESET:function(){this._resetNodes()},_change_TILES:function(){this._applyTilesAppearance()},_change_LABELS:function(){this._applyLabelsAppearance()},_change_TILING:function(){this._performTiling()},_change_LABELS_LAYOUT:function(){this._performLabelsLayout()},_applyChanges:function(){var e=this;e.callBase.apply(e,arguments),e._isDataExpected||e._drawn(),e._context.forceReset=!1},_buildNodes:function(){var e=this,t=e._root=e._topNode=new x.default;t._id=0,t.parent={},t.data={},t.level=t.index=-1,t.ctx=e._context,t.label=null,e._nodes=[t],e._handlers.beginBuildNodes();var n=e._processDataSourceItems(e._dataSourceItems()||[]);a(t,n.items,0,{itemsField:!n.isPlain&&e._getOption("childrenField",!0)||"items",valueField:e._getOption("valueField",!0)||"value",buildNode:e._handlers.buildNode,ctx:e._context,nodes:e._nodes}),e._onNodesCreated(),e._handlers.endBuildNodes(),e._change(["NODES_RESET"])},_onNodesCreated:S.noop,_processDataSourceItems:function(e){return{items:e,isPlain:!1}},_changeTileSettings:function(){var e=this,t=e._getOption("tile"),n=e._rectOffsets,i=o(t.border.width),a=i/2,r=1&i?.5:0,s=t.label,l=e._context.settings[0];e._change(["TILES","LABELS"]),l.state=e._handlers.calculateState(t),e._filter=e._filter||e._renderer.shadowFilter("-50%","-50%","200%","200%"),e._filter.attr(s.shadow),e._calculateLabelSettings(l,s,e._filter.id),n.tileEdge===a&&n.tileInner===r||(n.tileEdge=a,n.tileInner=r,e._change(["TILING"]))},_changeGroupSettings:function(){var e=this,t=e._getOption("group"),n=t.label,i=e._rectOffsets,a=o(t.border.width),r=a/2,s=1&a?.5:0,l=0,u=o(t.padding),c=e._context.settings[1];e._change(["TILES","LABELS"]),c.state=e._handlers.calculateState(t),e._calculateLabelSettings(c,n),l=t.headerHeight>=0?o(t.headerHeight):c.labelParams.height+2*o(n.paddingTopBottom),e._headerHeight!==l&&(e._headerHeight=l,e._change(["TILING"])),e._groupPadding!==u&&(e._groupPadding=u,e._change(["TILING"])),i.headerEdge===r&&i.headerInner===s||(i.headerEdge=r,i.headerInner=s,e._change(["TILING"]))},_calculateLabelSettings:function(e,t,n){var i=this._getTextBBox(t.font),a=o(t.paddingLeftRight),r=o(t.paddingTopBottom),s=this._getOption("tile.label"),l=this._getOption("group.label");e.labelState=(0,y.buildTextAppearance)(t,n),e.labelState.visible=!("visible"in t&&!t.visible),e.labelParams={height:i.height,rtlEnabled:this._getOption("rtlEnabled",!0),paddingTopBottom:r,paddingLeftRight:a,resolveLabelOverflow:this._getOptionByStealth("resolveLabelOverflow"),tileLabelWordWrap:s.wordWrap,tileLabelOverflow:s.textOverflow,groupLabelOverflow:l.textOverflow}},_changeMaxDepth:function(){var e=this._getOption("maxDepth",!0);e=e>=1?Math.round(e):1/0,this._maxDepth!==e&&(this._maxDepth=e,this._change(["NODES_RESET"]))},_resetNodes:function(){var e=this;e._tilesGroup.clear(),e._renderer.initHatching(),e._context.forceReset=!0,e._context.minLevel=e._topNode.level+1,e._context.maxLevel=e._context.minLevel+e._maxDepth-1,e._change(["TILES","LABELS","TILING"])},_processNodes:function(e,t){r(e,this._topNode,t)},_applyTilesAppearance:function(){var e=this,t=(0,C.getColorizer)(e._getOption("colorizer"),e._themeManager,e._topNode);e._processNodes({renderer:e._renderer,group:e._tilesGroup,setTrackerData:e._handlers.setTrackerData,colorField:e._getOption("colorField",!0)||"color",getColor:t},s)},_applyLabelsAppearance:function(){var e=this;e._labelsGroup.clear(),e._processNodes({renderer:e._renderer,group:e._labelsGroup,setTrackerData:e._handlers.setTrackerData,labelField:e._getOption("labelField",!0)||"name"},c),e._change(["LABELS_LAYOUT"])},_performTiling:function(){var e=this,t={algorithm:(0,w.getAlgorithm)(e._getOption("layoutAlgorithm",!0)),directions:E[String(e._getOption("layoutDirection",!0)).toLowerCase()]||E.lefttoprightbottom,headerHeight:e._headerHeight,groupPadding:e._groupPadding,rectOffsets:e._rectOffsets};e._topNode.innerRect=e._tilingRect,h(t,e._topNode),e._processNodes(t,f),e._change(["LABELS_LAYOUT"]),e._onTilingPerformed()},_onTilingPerformed:S.noop,_performLabelsLayout:function(){this._processNodes(null,m)},_getTextBBox:function(e){var t=this._renderer,n=this._textForCalculations||t.text("0",0,0);this._textForCalculations=n,n.css((0,k.patchFontOptions)(e)).append(t.root);var i=n.getBBox();return n.remove(),i}}),O=[l,u],P=[0,0,0,0];n(9)("dxTreeMap",A),e.exports=A,A.addPlugin(n(151).plugin)},function(e,t,n){function i(e){return e&&e.__esModule?e:{"default":e}}var o=n(55),a=i(o),r=n(448),s=i(r),l=n(449),u=i(l),c="en";e.exports=(0,a.default)({locale:function(){var e=c;return function(t){return t?void(e=t):e}}(),getValueByClosestLocale:function(e){for(var t,n=this.locale(),i=e(n);!i&&!t;)n=(0,u.default)(s.default,n),n?i=e(n):t=!0;return void 0===i&&n!==c?e(c):i}})},function(e,t,n){Object.defineProperty(t,"__esModule",{value:!0});var i=n(1),o={toXml:function(e,t,n){var o=["<",e];for(var a in t){var r=t[a];(0,i.isDefined)(r)&&o.push(" ",a,'="',r,'"')}return(0,i.isDefined)(n)&&""!==n?o.push(">",n,"</",e,">"):o.push(" />"),o.join("")}};t.default=o},function(e,t,n){var i,o=n(2),a=n(4),r=n(3).each,s=n(7),l=s.getWindow(),u=n(11),c=n(1).isWindow,d=n(0).extend,h=n(22).getBoundingRect,f=n(23),p=n(29),g=n(45),_=/left|right/,m=/top|bottom/,v=/fit|flip|none/,y=f.safari,b=function(e){var t={h:"center",v:"center"},n=a.splitPair(e);return n&&r(n,function(){var e=String(this).toLowerCase();_.test(e)?t.h=e:m.test(e)&&(t.v=e)}),t},x=function(e){return a.pairToObject(e)},w=function(e){var t=a.splitPair(e),n=String(t&&t[0]).toLowerCase(),i=String(t&&t[1]).toLowerCase();return v.test(n)||(n="none"),v.test(i)||(i=n),{h:n,v:i}},C=function(e){switch(e){case"center":return.5;case"right":case"bottom":return 1;default:return 0}},k=function(e){switch(e){case"left":return"right";case"right":return"left";case"top":return"bottom";case"bottom":return"top";default:return e}},S=function(e,t){var n=0;return e.myLocation<t.min&&(n+=t.min-e.myLocation),e.myLocation>t.max&&(n+=e.myLocation-t.max),n},I=function(e,t,n){return t.myLocation<n.min?"h"===e?"left":"top":t.myLocation>n.max?"h"===e?"right":"bottom":"none"},D=function(e){e.myLocation=e.atLocation+C(e.atAlign)*e.atSize-C(e.myAlign)*e.mySize+e.offset},T={fit:function(e,t){var n=!1;e.myLocation>t.max&&(e.myLocation=t.max,n=!0),e.myLocation<t.min&&(e.myLocation=t.min,n=!0),e.fit=n},flip:function(e,t){if(e.flip=!1,("center"!==e.myAlign||"center"!==e.atAlign)&&(e.myLocation<t.min||e.myLocation>t.max)){var n=d({},e,{myAlign:k(e.myAlign),atAlign:k(e.atAlign),offset:-e.offset});D(n),n.oversize=S(n,t),(n.myLocation>=t.min&&n.myLocation<=t.max||e.oversize>n.oversize)&&(e.myLocation=n.myLocation,e.oversize=n.oversize,e.flip=!0)}},flipfit:function(e,t){this.flip(e,t),this.fit(e,t)},none:function(e){e.oversize=0}},E=function(){var e=o("<div>").css({width:100,height:100,overflow:"scroll",position:"absolute",top:-9999}).appendTo(o("body")),t=e.get(0).offsetWidth-e.get(0).clientWidth;e.remove(),i=t},A={h:{location:0,flip:!1,fit:!1,oversize:0},v:{location:0,flip:!1,fit:!1,oversize:0}},O=function(e,t){var n=o(e),a=n.offset(),r=d(!0,{},A,{h:{location:a.left},v:{location:a.top}});if(!t)return r;var s=b(t.my),f=b(t.at),p=o(t.of).length&&t.of||l,_=x(t.offset),m=w(t.collision),v=t.boundary,C=x(t.boundaryOffset),k={mySize:n.outerWidth(),myAlign:s.h,atAlign:f.h,offset:_.h,collision:m.h,boundaryOffset:C.h},O={mySize:n.outerHeight(),myAlign:s.v,atAlign:f.v,offset:_.v,collision:m.v,boundaryOffset:C.v};if(p.preventDefault)k.atLocation=p.pageX,O.atLocation=p.pageY,k.atSize=0,O.atSize=0;else if(p=o(p),c(p[0]))k.atLocation=p.scrollLeft(),O.atLocation=p.scrollTop(),k.atSize=p[0].innerWidth>=p[0].outerWidth?p[0].innerWidth:p.width(),O.atSize=p[0].innerHeight>=p[0].outerHeight||y?p[0].innerHeight:p.height();else if(9===p[0].nodeType)k.atLocation=0,O.atLocation=0,k.atSize=p.width(),O.atSize=p.height();else{var P=h(p.get(0)),R=p.offset();k.atLocation=R.left,O.atLocation=R.top,k.atSize=P.width,O.atSize=P.height}D(k),D(O);var B=function(){var e=o(l),t=e.width(),n=e.height(),a=e.scrollLeft(),r=e.scrollTop(),s=u.getDocumentElement(),c=g.touch?s.clientWidth/t:1,d=g.touch?s.clientHeight/n:1;void 0===i&&E();var h=t,f=n;if(v){var p=o(v),_=p.offset();a=_.left,r=_.top,h=p.width(),f=p.height()}return{h:{min:a+k.boundaryOffset,max:a+h/c-k.mySize-k.boundaryOffset},v:{min:r+O.boundaryOffset,max:r+f/d-O.mySize-O.boundaryOffset}}}();k.oversize=S(k,B.h),O.oversize=S(O,B.v),k.collisionSide=I("h",k,B.h),O.collisionSide=I("v",O,B.v),T[k.collision]&&T[k.collision](k,B.h),T[O.collision]&&T[O.collision](O,B.v);var M=function(e){return t.precise?e:Math.round(e)};return d(!0,r,{h:{location:M(k.myLocation),oversize:M(k.oversize),fit:k.fit,flip:k.flip,collisionSide:k.collisionSide},v:{location:M(O.myLocation),oversize:M(O.oversize),fit:O.fit,flip:O.flip,collisionSide:O.collisionSide},precise:t.precise}),r},P=function(e,t){var n=o(e);if(!t)return n.offset();p.resetPosition(n,!0);var i=n.offset(),a=t.h&&t.v?t:O(n,t),r=function(e){return t.precise?e:Math.round(e)};return p.move(n,{left:a.h.location-r(i.left),top:a.v.location-r(i.top)}),a},R=function(e){return e=o(e).get(0),c(e)?null:e&&"pageY"in e&&"pageX"in e?{top:e.pageY,left:e.pageX}:o(e).offset()};P.inverseAlign||(P.inverseAlign=k),P.normalizeAlign||(P.normalizeAlign=b),e.exports={calculateScrollbarWidth:E,calculate:O,setup:P,offset:R}},function(e,t,n){var i=n(56),o=n(28),a=o().useJQuery;i&&a!==!1&&o({useJQuery:!0}),e.exports=function(){return i&&o().useJQuery}},function(e,t,n){var i=n(2),o=n(7),a=o.getNavigator(),r=n(45),s=n(32),l=n(0).extend,u=n(16),c=n(9),d=n(17),h="dx-loadindicator",f="dx-loadindicator-wrapper",p="dx-loadindicator-content",g="dx-loadindicator-icon",_="dx-loadindicator-segment",m="dx-loadindicator-segment-inner",v="dx-loadindicator-image",y=d.inherit({
_getDefaultOptions:function(){return l(this.callBase(),{indicatorSrc:"",activeStateEnabled:!1,hoverStateEnabled:!1,_animatingSegmentCount:1,_animatingSegmentInner:!1})},_defaultOptionsRules:function(){var e=s.current();return this.callBase().concat([{device:function(){var e=u.real(),t="android"===e.platform&&!/chrome/i.test(a.userAgent);return t},options:{viaImage:!0}},{device:function(){return s.isIos7(e)},options:{_animatingSegmentCount:11}},{device:function(){return s.isMaterial(e)},options:{_animatingSegmentCount:2,_animatingSegmentInner:!0}},{device:function(){return s.isGeneric(e)},options:{_animatingSegmentCount:7}}])},_init:function(){this.callBase(),this.$element().addClass(h)},_initMarkup:function(){this.callBase(),this._renderWrapper(),this._renderIndicatorContent(),this._renderMarkup()},_renderWrapper:function(){this._$wrapper=i("<div>").addClass(f),this.$element().append(this._$wrapper)},_renderIndicatorContent:function(){this._$content=i("<div>").addClass(p),this._$wrapper.append(this._$content)},_renderMarkup:function(){!r.animation()||this.option("viaImage")||this.option("indicatorSrc")?this._renderMarkupForImage():this._renderMarkupForAnimation()},_renderMarkupForAnimation:function(){var e=this.option("_animatingSegmentInner");this._$indicator=i("<div>").addClass(g),this._$content.append(this._$indicator);for(var t=this.option("_animatingSegmentCount");t>=0;--t){var n=i("<div>").addClass(_).addClass(_+t);e&&n.append(i("<div>").addClass(m)),this._$indicator.append(n)}},_renderMarkupForImage:function(){var e=this.option("indicatorSrc");this._$wrapper.addClass(v),e&&this._$wrapper.css("backgroundImage","url("+e+")")},_renderDimensions:function(){this.callBase(),this._updateContentSizeForAnimation()},_updateContentSizeForAnimation:function(){if(this._$indicator){var e=this.option("width"),t=this.option("height");if(e||t){e=this.$element().width(),t=this.$element().height();var n=Math.min(t,e);this._$wrapper.css({height:n,width:n,fontSize:n})}}},_clean:function(){this.callBase(),this._removeMarkupForAnimation(),this._removeMarkupForImage()},_removeMarkupForAnimation:function(){this._$indicator&&(this._$indicator.remove(),delete this._$indicator)},_removeMarkupForImage:function(){this._$wrapper.css("backgroundImage","none")},_optionChanged:function(e){switch(e.name){case"_animatingSegmentCount":case"_animatingSegmentInner":case"indicatorSrc":this._invalidate();break;default:this.callBase(e)}}});c("dxLoadIndicator",y),e.exports=y},function(e,t,n){function i(e){return e&&e.__esModule?e:{"default":e}}function o(e){var t=function t(n,i,o,a,r,s){function l(e,r,s){(0,m.when)(t(n,i,o,a,r,s)).done(e.resolve)}a=a||[],n=n||[];var u,c;for(r=r||0,u=r;u<n.length;u++){if(e&&u>r&&u%1e4===0&&new Date-y>=300)return y=new Date,c=new m.Deferred,setTimeout(l(c,u,!1),0),c;var d=n[u];if(!s){if(a.unshift(d),o&&i(a,u)===!1)return;if(d.children){var h=t(d.children,i,o,a);if(e&&h)return c=new m.Deferred,h.done(l(c,u,!0)),c}}if(s=!1,!o&&i(a,u)===!1)return;a.shift(),n[u]!==d&&u--}};return t}function a(e){return(0,c.map)(["year","quarter","month"],function(t,n){return(0,d.extend)({},e,{groupInterval:t,groupIndex:n})})}function r(e,t,n,i){var o=[];return Object.keys(t||[]).forEach(function(l){if(!l||0!==l.indexOf("__")){for(var c,d=1,h=n.length?n+"."+l:l,f=i[h],p=(0,u.compileGetter)(h),g=t[l];!(0,s.isDefined)(g)&&e[d];)g=p(e[d]),d++;!f&&(0,s.isDefined)(g)&&(f=(0,s.type)(g)),c=[{dataField:h,dataType:f,groupName:"date"===f?l:void 0,groupInterval:void 0,displayFolder:n}],"date"===f?c=c.concat(a(c[0])):"object"===f&&(c=r(e,g,h,i)),o.push.apply(o,c)}}),o}var s=n(1),l=n(63),u=n(20),c=n(3),d=n(0),h=n(37),f=n(65),p=n(47),g=n(72),_=i(g),m=n(6),v=t.setFieldProperty=function(e,t,n,i){var o=e._initProperties=e._initProperties||{},a=i?n:e[t];Object.prototype.hasOwnProperty.call(o,t)&&!i||(o[t]=a),e[t]=n};t.sendRequest=function(e){return(0,l.sendRequest)(e)};var y=new Date;t.foreachTree=o(!1),t.foreachTreeAsync=o(!0),t.findField=function(e,t){if(e&&(0,s.isDefined)(t))for(var n=0;n<e.length;n++){var i=e[n];if(i.name===t||i.caption===t||i.dataField===t||i.index===t)return n}return-1},t.formatValue=function(e,t){var n=e===e&&(0,f.format)(e,t.format),i={value:e,valueText:n||""};return t.customizeText?t.customizeText.call(t,i):i.valueText},t.getCompareFunction=function(e){return function(t,n){var i=0,o=e(t),a=e(n),r=(0,s.isDefined)(o),l=(0,s.isDefined)(a);return r&&l&&(o>a?i=1:o<a&&(i=-1)),r&&!l&&(i=1),!r&&l&&(i=-1),i}},t.createPath=function(e){for(var t=[],n=e.length-1;n>=0;n--)t.push(e[n].key||e[n].value);return t},t.foreachDataLevel=function e(t,n,i,o){i=i||0,o=o||"children",t.length&&n(t,i);for(var a=0;a<t.length;a++){var r=t[a];r[o]&&r[o].length&&e(r[o],n,i+1,o)}},t.mergeArraysByMaxValue=function(e,t){for(var n=[],i=0;i<e.length;i++)n.push(Math.max(e[i]||0,t[i]||0));return n},t.getExpandedLevel=function(e,t){var n=e[t],i=0,o=("columns"===t?e.columnExpandedPaths:e.rowExpandedPaths)||[];for(e.headerName===t?i=e.path.length:e.headerName&&e.headerName!==t&&e.oppositePath?i=e.oppositePath.length:(0,c.each)(o,function(e,t){i=Math.max(i,t.length)});n[i+1]&&n[i].expanded;)i++;return i},t.discoverObjectFields=function(e,n){var i=t.getFieldsDataType(n);return r(e,e[0],"",i)},t.getFieldsDataType=function(e){var t={};return(0,c.each)(e,function(e,n){t[n.dataField]=t[n.dataField]||n.dataType}),t};var b={month:function(e){return(0,h.getMonthNames)()[e-1]},quarter:function(e){return(0,h.format)(new Date(2e3,3*e-1),"quarter")},dayOfWeek:function(e){return(0,h.getDayNames)()[e]}};t.setDefaultFieldValueFormatting=function(e){if("date"===e.dataType)e.format||v(e,"format",b[e.groupInterval]);else if("number"===e.dataType){var t=(0,s.isNumeric)(e.groupInterval)&&e.groupInterval>0&&e.groupInterval;t&&!e.customizeText&&v(e,"customizeText",function(n){var i=n.value+t,o=(0,f.format)(i,e.format);return n.valueText&&o?n.valueText+" - "+o:""})}},t.getFiltersByPath=function(e,t){var n=[];t=t||[];for(var i=0;i<t.length;i++)n.push((0,d.extend)({},e[i],{groupIndex:null,groupName:null,filterType:"include",filterValues:[t[i]]}));return n},t.storeDrillDownMixin={createDrillDownDataSource:function(e,t){function n(e){return function(t){var n;return i?n=i[e](t):(n=new m.Deferred,(0,m.when)(o).done(function(i){var o=new _.default(i);o[e](t).done(n.resolve).fail(n.reject)}).fail(n.reject)),n}}var i,o=this.getDrillDownItems(e,t),a=new p.DataSource({load:n("load"),totalCount:n("totalCount"),key:this.key()});return a}},t.capitalizeFirstLetter=function(e){return e.charAt(0).toUpperCase()+e.slice(1)}},function(e,t,n){var i=n(465),o=n(3).each,a=n(1).isPlainObject;e.exports={ctor:function(){this._events={},this.setEventsStrategy(new i(this))},setEventsStrategy:function(e){"function"==typeof e&&(e=e(this)),this._eventsStrategy=e},hasEvent:function(e){return this._eventsStrategy.hasEvent(e)},fireEvent:function(e,t){return this._eventsStrategy.fireEvent(e,t),this},on:function(e,t){return a(e)?o(e,function(e,t){this.on(e,t)}.bind(this)):this._eventsStrategy.on(e,t),this},off:function(e,t){return this._eventsStrategy.off(e,t),this},_disposeEvents:function(){this._eventsStrategy.dispose()}}},function(e,t,n){var i=n(47).DataSource,o=n(0).extend,a=n(47).normalizeDataSourceOptions,r="_dataSourceOptions",s="_dataSourceChangedHandler",l="_dataSourceLoadErrorHandler",u="_dataSourceLoadingChangedHandler",c="_dataSourceFromUrlLoadMode",d="_getSpecificDataSourceOption",h="_normalizeDataSource",f={postCtor:function(){this.on("disposing",function(){this._disposeDataSource()}.bind(this))},_refreshDataSource:function(){this._initDataSource(),this._loadDataSource()},_initDataSource:function(){var e,t,n=d in this?this[d]():this.option("dataSource");this._disposeDataSource(),n&&(n instanceof i?(this._isSharedDataSource=!0,this._dataSource=n):(e=r in this?this[r]():{},t=this._dataSourceType?this._dataSourceType():i,n=a(n,{fromUrlLoadMode:c in this&&this[c]()}),this._dataSource=new t(o(!0,{},e,n))),h in this&&(this._dataSource=this[h](this._dataSource)),this._addDataSourceHandlers())},_addDataSourceHandlers:function(){s in this&&this._addDataSourceChangeHandler(),l in this&&this._addDataSourceLoadErrorHandler(),u in this&&this._addDataSourceLoadingChangedHandler(),this._addReadyWatcher()},_addReadyWatcher:function(){this._dataSource.on("loadingChanged",function(e){this._ready&&this._ready(!e)}.bind(this))},_addDataSourceChangeHandler:function(){var e=this._dataSource;this._proxiedDataSourceChangedHandler=function(t){this[s](e.items(),t)}.bind(this),e.on("changed",this._proxiedDataSourceChangedHandler)},_addDataSourceLoadErrorHandler:function(){this._proxiedDataSourceLoadErrorHandler=this[l].bind(this),this._dataSource.on("loadError",this._proxiedDataSourceLoadErrorHandler)},_addDataSourceLoadingChangedHandler:function(){this._proxiedDataSourceLoadingChangedHandler=this[u].bind(this),this._dataSource.on("loadingChanged",this._proxiedDataSourceLoadingChangedHandler)},_loadDataSource:function(){if(this._dataSource){var e=this._dataSource;e.isLoaded()?this._proxiedDataSourceChangedHandler&&this._proxiedDataSourceChangedHandler():e.load()}},_loadSingle:function(e,t){return e="this"===e?this._dataSource.key()||"this":e,this._dataSource.loadSingle(e,t)},_isLastPage:function(){return!this._dataSource||this._dataSource.isLastPage()||!this._dataSource._pageSize},_isDataSourceLoading:function(){return this._dataSource&&this._dataSource.isLoading()},_disposeDataSource:function(){this._dataSource&&(this._isSharedDataSource?(delete this._isSharedDataSource,this._proxiedDataSourceChangedHandler&&this._dataSource.off("changed",this._proxiedDataSourceChangedHandler),this._proxiedDataSourceLoadErrorHandler&&this._dataSource.off("loadError",this._proxiedDataSourceLoadErrorHandler),this._proxiedDataSourceLoadingChangedHandler&&this._dataSource.off("loadingChanged",this._proxiedDataSourceLoadingChangedHandler)):this._dataSource.dispose(),delete this._dataSource,delete this._proxiedDataSourceChangedHandler,delete this._proxiedDataSourceLoadErrorHandler,delete this._proxiedDataSourceLoadingChangedHandler)},getDataSource:function(){return this._dataSource||null}};e.exports=f},function(e,t,n){function i(e,t){return e=e.groupBy(t[0].selector),t.length>1&&(e=e.select(function(e){return s({},e,{items:i(u(e.items),t.slice(1)).toArray()})})),e}function o(e,t){var n=[];return l(e,function(e,i){var o=r(t,function(e){return i.selector===e.selector});o.length<1&&n.push(i)}),n.concat(t)}function a(e,t,n){t=t||{};var a=t.filter;if(a&&(e=e.filter(a)),n)return e;var r=t.sort,s=t.select,u=t.group,d=t.skip,h=t.take;return u&&(u=c(u),u.keepInitialKeyOrder=!!t.group.keepInitialKeyOrder),(r||u)&&(r=c(r||[]),u&&!u.keepInitialKeyOrder&&(r=o(u,r)),l(r,function(t){e=e[t?"thenBy":"sortBy"](this.selector,this.desc,this.compare)})),s&&(e=e.select(s)),u&&(e=i(e,u)),(h||d)&&(e=e.slice(d||0,h)),e}var r=n(4).grep,s=n(0).extend,l=n(3).each,u=n(157),c=n(42).normalizeSortingInfo;e.exports={multiLevelGroup:i,arrangeSortingInfo:o,queryByOptions:a}},function(e,t,n){function i(e){return e&&e.__esModule?e:{"default":e}}var o=n(2),a=i(o),r=n(5),s=i(r),l=n(7),u=i(l),c=n(0),d=n(28),h=i(d),f=n(21),p=i(f),g=n(12),_=n(130),m=i(_),v=n(4),y=i(v),b=n(3),x=n(1),w=n(14),C=n(131),k=i(C),S=n(39),I=i(S),D=n(112),T=i(D),E=T.default.abstract,A="dx-rtl",O="dx-visibility-change-handler",P="VisibilityChange",R=T.default.inherit({_getDefaultOptions:function(){return(0,c.extend)(this.callBase(),{width:void 0,height:void 0,rtlEnabled:(0,h.default)().rtlEnabled,elementAttr:{},disabled:!1,integrationOptions:{}})},ctor:function(e,t){this._createElement(e),k.default.attachInstanceToElement(this._$element,this,this._dispose),this.callBase(t)},_createElement:function(e){this._$element=(0,a.default)(e)},_getSynchronizableOptionsForCreateComponent:function(){return["rtlEnabled","disabled","templatesRenderAsynchronously"]},_visibilityChanged:E,_dimensionChanged:E,_init:function(){this.callBase(),this._attachWindowResizeCallback()},_setOptionsByDevice:function(e){this.callBase([].concat(this.constructor._classCustomRules||[],e||[]))},_isInitialOptionValue:function(e){var t=this.constructor._classCustomRules&&Object.prototype.hasOwnProperty.call(this._convertRulesToOptions(this.constructor._classCustomRules),e);return!t&&this.callBase(e)},_attachWindowResizeCallback:function(){if(this._isDimensionChangeSupported()){var e=this._windowResizeCallBack=this._dimensionChanged.bind(this);m.default.add(e)}},_isDimensionChangeSupported:function(){return this._dimensionChanged!==E},_renderComponent:function(){this._initMarkup(),u.default.hasWindow()&&this._render()},_initMarkup:function(){this._renderElementAttributes(),this._toggleRTLDirection(this.option("rtlEnabled")),this._renderVisibilityChange(),this._renderDimensions()},_render:function(){this._attachVisibilityChangeHandlers()},_renderElementAttributes:function(){var e=(0,c.extend)({},this.option("elementAttr")),t=e.class;delete e.class,this.$element().attr(e).addClass(t)},_renderVisibilityChange:function(){this._isDimensionChangeSupported()&&this._attachDimensionChangeHandlers(),this._isVisibilityChangeSupported()&&this.$element().addClass(O)},_renderDimensions:function(){var e=this.$element(),t=e.get(0),n=this._getOptionValue("width",t),i=this._getOptionValue("height",t);this._isCssUpdateRequired(t,i,n)&&e.css({width:null===n?"":n,height:null===i?"":i})},_isCssUpdateRequired:function(e,t,n){return!!((0,x.isDefined)(n)||(0,x.isDefined)(t)||e.style.width||e.style.height)},_attachDimensionChangeHandlers:function(){var e=this,t="dxresize."+this.NAME+P;s.default.off(e.$element(),t),s.default.on(e.$element(),t,function(){e._dimensionChanged()})},_attachVisibilityChangeHandlers:function(){if(this._isVisibilityChangeSupported()){var e=this,t="dxhiding."+this.NAME+P,n="dxshown."+this.NAME+P;e._isHidden=!e._isVisible(),s.default.off(e.$element(),t),s.default.on(e.$element(),t,function(){e._checkVisibilityChanged("hiding")}),s.default.off(e.$element(),n),s.default.on(e.$element(),n,function(){e._checkVisibilityChanged("shown")})}},_isVisible:function(){return this.$element().is(":visible")},_checkVisibilityChanged:function(e){"hiding"===e&&this._isVisible()&&!this._isHidden?(this._visibilityChanged(!1),this._isHidden=!0):"shown"===e&&this._isVisible()&&this._isHidden&&(this._isHidden=!1,this._visibilityChanged(!0))},_isVisibilityChangeSupported:function(){return this._visibilityChanged!==E&&u.default.hasWindow()},_clean:y.default.noop,_modelByElement:function(){var e=this.option("modelByElement")||y.default.noop;return e(this.$element())},_invalidate:function(){if(!this._updateLockCount)throw p.default.Error("E0007");this._requireRefresh=!0},_refresh:function(){this._clean(),this._renderComponent()},_dispose:function(){this.callBase(),this._clean(),this._detachWindowResizeCallback()},_detachWindowResizeCallback:function(){this._isDimensionChangeSupported()&&m.default.remove(this._windowResizeCallBack)},_toggleRTLDirection:function(e){this.$element().toggleClass(A,e)},_createComponent:function(e,t,n){var i=this,o=this;n=n||{};var r=y.default.grep(this._getSynchronizableOptionsForCreateComponent(),function(e){return!(e in n)}),s=o.option("nestedComponentOptions")||y.default.noop,l=(0,c.extend)({integrationOptions:this.option("integrationOptions")},s(this));r.forEach(function(e){l[e]=i.option(e)}),o._extendConfig(n,l);var u;if((0,x.isString)(t)){var d=(0,a.default)(e)[t](n);u=d[t]("instance")}else e&&(u=t.getInstance(e),u?u.option(n):u=new t(e,n));if(u){var h=function(e){(0,w.inArray)(e.name,r)>=0&&u.option(e.name,e.value)};o.on("optionChanged",h),u.on("disposing",function(){o.off("optionChanged",h)})}return u},_extendConfig:function(e,t){(0,b.each)(t,function(t,n){e[t]=Object.prototype.hasOwnProperty.call(e,t)?e[t]:n})},_defaultActionConfig:function(){return(0,c.extend)(this.callBase(),{context:this._modelByElement(this.$element())})},_defaultActionArgs:function(){var e=this._modelByElement(this.$element());return(0,c.extend)(this.callBase(),{element:this.element(),model:e})},_optionChanged:function(e){switch(e.name){case"width":case"height":this._renderDimensions();break;case"rtlEnabled":this._invalidate();break;case"elementAttr":this._renderElementAttributes();break;case"disabled":case"integrationOptions":break;default:this.callBase(e)}},_removeAttributes:function(e){for(var t=e.attributes.length-1;t>=0;t--){var n=e.attributes[t];if(!n)return;var i=n.name;0!==i.indexOf("aria-")&&i.indexOf("dx-")===-1&&"role"!==i&&"style"!==i&&"tabindex"!==i||e.removeAttribute(i)}},_removeClasses:function(e){var t=e.className.split(" ").filter(function(e){return 0!==e.lastIndexOf("dx-",0)});e.className=t.join(" ")},endUpdate:function(){var e=!this._initializing&&!this._initialized;this.callBase.apply(this,arguments),this._updateLockCount||(e?this._renderComponent():this._requireRefresh&&(this._requireRefresh=!1,this._refresh()))},$element:function(){return this._$element},element:function(){return(0,g.getPublicElement)(this.$element())},dispose:function(){var e=this.$element().get(0);I.default.cleanDataRecursive(e,!0),e.textContent="",this._removeAttributes(e),this._removeClasses(e)},resetOption:function(e){this.callBase(e),"width"!==e&&"height"!==e||(0,x.isDefined)(this.initialOption(e))||this.$element().css(e,"")}});R.getInstance=function(e){return k.default.getInstanceByElement((0,a.default)(e),this)},R.defaultOptions=function(e){this._classCustomRules=this._classCustomRules||[],this._classCustomRules.push(e)},e.exports=R},function(e,t,n){function i(e){this.baseColor=e;var t;e&&(t=String(e).toLowerCase().replace(/ /g,""),t=m[t]?"#"+m[t]:t,t=o(t)),t||(this.colorIsInvalid=!0),t=t||{},this.r=a(t[0]),this.g=a(t[1]),this.b=a(t[2]),this.a=a(t[3],1,1),t[4]?this.hsv={h:t[4][0],s:t[4][1],v:t[4][2]}:this.hsv=s(this.r,this.g,this.b),t[5]?this.hsl={h:t[5][0],s:t[5][1],l:t[5][2]}:this.hsl=c(this.r,this.g,this.b)}function o(e){if("transparent"===e)return[0,0,0,0];for(var t,n=0,i=v.length;n<i;++n)if(t=v[n].re.exec(e))return v[n].process(t);return null}function a(e,t,n){return t=t||0,n=n||255,e<0||isNaN(e)?t:e>n?n:e}function r(e,t,n){return"#"+(16777216|e<<16|t<<8|n).toString(16).slice(1)}function s(e,t,n){var i,o,a,r=Math.max(e,t,n),s=Math.min(e,t,n),l=r-s;if(a=r,o=0===r?0:1-s/r,r===s)i=0;else switch(r){case e:i=60*((t-n)/l),t<n&&(i+=360);break;case t:i=60*((n-e)/l)+120;break;case n:i=60*((e-t)/l)+240}return o*=100,a*=100/255,{h:Math.round(i),s:Math.round(o),v:Math.round(a)}}function l(e,t,n){var i,o,a,r=Math.floor(e%360/60),s=(100-t)*n/100,l=(n-s)*(e%60/60),u=s+l,c=n-l;switch(r){case 0:i=n,o=u,a=s;break;case 1:i=c,o=n,a=s;break;case 2:i=s,o=n,a=u;break;case 3:i=s,o=c,a=n;break;case 4:i=u,o=s,a=n;break;case 5:i=n,o=s,a=c}return[Math.round(2.55*i),Math.round(2.55*o),Math.round(2.55*a)]}function u(e,t,n,i){var o=Math.max(e,t,n);switch(o){case e:return(t-n)/i+(t<n?6:0);case t:return(n-e)/i+2;case n:return(e-t)/i+4}}function c(e,t,n){e=g(e,255),t=g(t,255),n=g(n,255);var i,o,a=Math.max(e,t,n),r=Math.min(e,t,n),s=a+r,l=s/2;if(a===r)i=o=0;else{var c=a-r;o=l>.5?c/(2-s):c/s,i=u(e,t,n,c),i/=6}return{h:y(360*i),s:y(100*o),l:y(100*l)}}function d(e,t){var n=t;return"r"===e&&(n=t+1/3),"b"===e&&(n=t-1/3),n}function h(e){return e<0&&(e+=1),e>1&&(e-=1),e}function f(e,t,n){return n=h(n),n<1/6?e+6*(t-e)*n:n<.5?t:n<2/3?e+(t-e)*(2/3-n)*6:e}function p(e,t,n){var i,o,a;if(e=g(e,360),t=g(t,100),n=g(n,100),0===t)i=o=a=n;else{var r=n<.5?n*(1+t):n+t-n*t,s=2*n-r;i=f(s,r,d("r",e)),o=f(s,r,d("g",e)),a=f(s,r,d("b",e))}return[y(255*i),y(255*o),y(255*a)]}function g(e,t){return e=Math.min(t,Math.max(0,parseFloat(e))),Math.abs(e-t)<1e-6?1:e%t/parseFloat(t)}function _(e,t,n){return t=t||0,n=n||255,!(e%1!==0||e<t||e>n||"number"!=typeof e||isNaN(e))}var m={aliceblue:"f0f8ff",antiquewhite:"faebd7",aqua:"00ffff",aquamarine:"7fffd4",azure:"f0ffff",beige:"f5f5dc",bisque:"ffe4c4",black:"000000",blanchedalmond:"ffebcd",blue:"0000ff",blueviolet:"8a2be2",brown:"a52a2a",burlywood:"deb887",cadetblue:"5f9ea0",chartreuse:"7fff00",chocolate:"d2691e",coral:"ff7f50",cornflowerblue:"6495ed",cornsilk:"fff8dc",crimson:"dc143c",cyan:"00ffff",darkblue:"00008b",darkcyan:"008b8b",darkgoldenrod:"b8860b",darkgray:"a9a9a9",darkgreen:"006400",darkkhaki:"bdb76b",darkmagenta:"8b008b",darkolivegreen:"556b2f",darkorange:"ff8c00",darkorchid:"9932cc",darkred:"8b0000",darksalmon:"e9967a",darkseagreen:"8fbc8f",darkslateblue:"483d8b",darkslategray:"2f4f4f",darkturquoise:"00ced1",darkviolet:"9400d3",deeppink:"ff1493",deepskyblue:"00bfff",dimgray:"696969",dodgerblue:"1e90ff",feldspar:"d19275",firebrick:"b22222",floralwhite:"fffaf0",forestgreen:"228b22",fuchsia:"ff00ff",gainsboro:"dcdcdc",ghostwhite:"f8f8ff",gold:"ffd700",goldenrod:"daa520",gray:"808080",green:"008000",greenyellow:"adff2f",honeydew:"f0fff0",hotpink:"ff69b4",indianred:"cd5c5c",indigo:"4b0082",ivory:"fffff0",khaki:"f0e68c",lavender:"e6e6fa",lavenderblush:"fff0f5",lawngreen:"7cfc00",lemonchiffon:"fffacd",lightblue:"add8e6",lightcoral:"f08080",lightcyan:"e0ffff",lightgoldenrodyellow:"fafad2",lightgrey:"d3d3d3",lightgreen:"90ee90",lightpink:"ffb6c1",lightsalmon:"ffa07a",lightseagreen:"20b2aa",lightskyblue:"87cefa",lightslateblue:"8470ff",lightslategray:"778899",lightsteelblue:"b0c4de",lightyellow:"ffffe0",lime:"00ff00",limegreen:"32cd32",linen:"faf0e6",magenta:"ff00ff",maroon:"800000",mediumaquamarine:"66cdaa",mediumblue:"0000cd",mediumorchid:"ba55d3",mediumpurple:"9370d8",mediumseagreen:"3cb371",mediumslateblue:"7b68ee",mediumspringgreen:"00fa9a",mediumturquoise:"48d1cc",mediumvioletred:"c71585",midnightblue:"191970",mintcream:"f5fffa",mistyrose:"ffe4e1",moccasin:"ffe4b5",navajowhite:"ffdead",navy:"000080",oldlace:"fdf5e6",olive:"808000",olivedrab:"6b8e23",orange:"ffa500",orangered:"ff4500",orchid:"da70d6",palegoldenrod:"eee8aa",palegreen:"98fb98",paleturquoise:"afeeee",palevioletred:"d87093",papayawhip:"ffefd5",peachpuff:"ffdab9",peru:"cd853f",pink:"ffc0cb",plum:"dda0dd",powderblue:"b0e0e6",purple:"800080",rebeccapurple:"663399",red:"ff0000",rosybrown:"bc8f8f",royalblue:"4169e1",saddlebrown:"8b4513",salmon:"fa8072",sandybrown:"f4a460",seagreen:"2e8b57",seashell:"fff5ee",sienna:"a0522d",silver:"c0c0c0",skyblue:"87ceeb",slateblue:"6a5acd",slategray:"708090",snow:"fffafa",springgreen:"00ff7f",steelblue:"4682b4",tan:"d2b48c",teal:"008080",thistle:"d8bfd8",tomato:"ff6347",turquoise:"40e0d0",violet:"ee82ee",violetred:"d02090",wheat:"f5deb3",white:"ffffff",whitesmoke:"f5f5f5",yellow:"ffff00",yellowgreen:"9acd32"},v=[{re:/^rgb\((\d{1,3}),\s*(\d{1,3}),\s*(\d{1,3})\)$/,process:function(e){return[parseInt(e[1],10),parseInt(e[2],10),parseInt(e[3],10)]}},{re:/^rgba\((\d{1,3}),\s*(\d{1,3}),\s*(\d{1,3}),\s*(\d*\.*\d+)\)$/,process:function(e){return[parseInt(e[1],10),parseInt(e[2],10),parseInt(e[3],10),parseFloat(e[4])]}},{re:/^#([a-f0-9]{2})([a-f0-9]{2})([a-f0-9]{2})$/,process:function(e){return[parseInt(e[1],16),parseInt(e[2],16),parseInt(e[3],16)]}},{re:/^#([a-f0-9]{1})([a-f0-9]{1})([a-f0-9]{1})$/,process:function(e){return[parseInt(e[1]+e[1],16),parseInt(e[2]+e[2],16),parseInt(e[3]+e[3],16)]}},{re:/^hsv\((\d{1,3}),\s*(\d{1,3}),\s*(\d{1,3})\)$/,process:function(e){var t=parseInt(e[1],10),n=parseInt(e[2],10),i=parseInt(e[3],10),o=l(t,n,i);return[o[0],o[1],o[2],1,[t,n,i]]}},{re:/^hsl\((\d{1,3}),\s*(\d{1,3}),\s*(\d{1,3})\)$/,process:function(e){var t=parseInt(e[1],10),n=parseInt(e[2],10),i=parseInt(e[3],10),o=p(t,n,i);return[o[0],o[1],o[2],1,null,[t,n,i]]}}],y=Math.round;i.prototype={constructor:i,highlight:function(e){return e=e||10,this.alter(e).toHex()},darken:function(e){return e=e||10,this.alter(-e).toHex()},alter:function(e){var t=new i;return t.r=a(this.r+e),t.g=a(this.g+e),t.b=a(this.b+e),t},blend:function(e,t){var n=e instanceof i?e:new i(e),o=new i;return o.r=a(y(this.r*(1-t)+n.r*t)),o.g=a(y(this.g*(1-t)+n.g*t)),o.b=a(y(this.b*(1-t)+n.b*t)),o},toHex:function(){return r(this.r,this.g,this.b)},getPureColor:function(){var e=l(this.hsv.h,100,100);return new i("rgb("+e.join(",")+")")},isValidHex:function(e){return/(^#[0-9A-F]{6}$)|(^#[0-9A-F]{3}$)/i.test(e)},isValidRGB:function(e,t,n){return!!(_(e)&&_(t)&&_(n))},isValidAlpha:function(e){return!(isNaN(e)||e<0||e>1||"number"!=typeof e)},colorIsInvalid:!1,fromHSL:function(e){var t=new i,n=p(e.h,e.s,e.l);return t.r=n[0],t.g=n[1],t.b=n[2],t}},e.exports=i},function(e,t,n){function i(e){"@babel/helpers - typeof";return(i="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}function o(e){return e&&e.__esModule?e:{"default":e}}function a(e,t){if("function"!=typeof t&&null!==t)throw new TypeError("Super expression must either be null or a function");e.prototype=Object.create(t&&t.prototype,{constructor:{value:e,writable:!0,configurable:!0}}),t&&r(e,t)}function r(e,t){return(r=Object.setPrototypeOf||function(e,t){return e.__proto__=t,e})(e,t)}function s(e){var t=c();return function(){var n,i=d(e);if(t){var o=d(this).constructor;n=Reflect.construct(i,arguments,o)}else n=i.apply(this,arguments);return l(this,n)}}function l(e,t){return!t||"object"!==i(t)&&"function"!=typeof t?u(e):t}function u(e){if(void 0===e)throw new ReferenceError("this hasn't been initialised - super() hasn't been called");return e}function c(){if("undefined"==typeof Reflect||!Reflect.construct)return!1;if(Reflect.construct.sham)return!1;if("function"==typeof Proxy)return!0;try{return Date.prototype.toString.call(Reflect.construct(Date,[],function(){})),!0}catch(e){return!1}}function d(e){return(d=Object.setPrototypeOf?Object.getPrototypeOf:function(e){return e.__proto__||Object.getPrototypeOf(e)})(e)}function h(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}function f(e,t){for(var n=0;n<t.length;n++){var i=t[n];i.enumerable=i.enumerable||!1,i.configurable=!0,"value"in i&&(i.writable=!0),Object.defineProperty(e,i.key,i)}}function p(e,t,n){return t&&f(e.prototype,t),n&&f(e,n),e}var g=n(15),_=o(g),m=n(0),v=n(14),y=n(3),b=n(83),x=o(b),w=n(21),C=o(w),k=n(4),S=n(1),I=o(S),D=n(49),T=o(D),E=n(10),A=o(E),O=n(68),P=o(O),R=n(6),B={valid:"valid",invalid:"invalid",pending:"pending"},M=function(){function e(){h(this,e),this.NAME="base"}return p(e,[{key:"defaultMessage",value:function(e){return A.default.getFormatter("validation-".concat(this.NAME))(e)}},{key:"defaultFormattedMessage",value:function(e){return A.default.getFormatter("validation-".concat(this.NAME,"-formatted"))(e)}},{key:"_isValueEmpty",value:function(e){return!j.required.validate(e,{})}},{key:"validate",value:function(e,t){var n=this,i=Array.isArray(e)?e:[e],o=!0;return i.length?i.every(function(e){return o=n._validate(e,t)}):o=this._validate(null,t),o}}]),e}(),V=function(e){function t(){var e;return h(this,t),e=n.call(this),e.NAME="required",e}a(t,e);var n=s(t);return p(t,[{key:"_validate",value:function(e,t){return!!I.default.isDefined(e)&&(e!==!1&&(e=String(e),!t.trim&&I.default.isDefined(t.trim)||(e=e.trim()),""!==e))}}]),t}(M),F=function(e){function t(){var e;return h(this,t),e=n.call(this),e.NAME="numeric",e}a(t,e);var n=s(t);return p(t,[{key:"_validate",value:function(e,t){return!(t.ignoreEmptyValue===!1||!this._isValueEmpty(e))||(t.useCultureSettings&&I.default.isString(e)?!isNaN(T.default.parse(e)):I.default.isNumeric(e))}}]),t}(M),L=function(e){function t(){var e;return h(this,t),e=n.call(this),e.NAME="range",e}a(t,e);var n=s(t);return p(t,[{key:"_validate",value:function(e,t){if(t.ignoreEmptyValue!==!1&&this._isValueEmpty(e))return!0;var n=j.numeric.validate(e,t),i=I.default.isDefined(e)&&""!==e,o=n?parseFloat(e):i&&e.valueOf(),a=t.min,r=t.max;if(!n&&!I.default.isDate(e)&&!i)return!1;if(I.default.isDefined(a))return I.default.isDefined(r)?o>=a&&o<=r:o>=a;if(I.default.isDefined(r))return o<=r;throw C.default.Error("E0101")}}]),t}(M),H=function(e){function t(){var e;return h(this,t),e=n.call(this),e.NAME="stringLength",e}a(t,e);var n=s(t);return p(t,[{key:"_validate",value:function(e,t){return e=I.default.isDefined(e)?String(e):"",!t.trim&&I.default.isDefined(t.trim)||(e=e.trim()),!(!t.ignoreEmptyValue||!this._isValueEmpty(e))||j.range.validate(e.length,(0,m.extend)({},t))}}]),t}(M),z=function(e){function t(){var e;return h(this,t),e=n.call(this),e.NAME="custom",e}a(t,e);var n=s(t);return p(t,[{key:"validate",value:function(e,t){if(t.ignoreEmptyValue&&this._isValueEmpty(e))return!0;var n=t.validator,i=n&&I.default.isFunction(n.option)&&n.option("dataGetter"),o=I.default.isFunction(i)&&i(),a={value:e,validator:n,rule:t};return o&&(0,m.extend)(a,o),t.validationCallback(a)}}]),t}(M),N=function(e){function t(){var e;return h(this,t),e=n.call(this),e.NAME="async",e}a(t,e);var n=s(t);return p(t,[{key:"validate",value:function(e,t){if(I.default.isDefined(t.reevaluate)||(0,m.extend)(t,{reevaluate:!0}),t.ignoreEmptyValue&&this._isValueEmpty(e))return!0;var n=t.validator,i=n&&I.default.isFunction(n.option)&&n.option("dataGetter"),o=I.default.isFunction(i)&&i(),a={value:e,validator:n,rule:t};o&&(0,m.extend)(a,o);var r=t.validationCallback(a);if(!I.default.isPromise(r))throw C.default.Error("E0103");return this._getWrappedPromise((0,R.fromPromise)(r).promise())}},{key:"_getWrappedPromise",value:function(e){var t=new R.Deferred;return e.then(function(e){t.resolve(e)},function(e){var n={isValid:!1};I.default.isDefined(e)&&(I.default.isString(e)?n.message=e:I.default.isObject(e)&&I.default.isDefined(e.message)&&I.default.isString(e.message)&&(n.message=e.message)),t.resolve(n)}),t.promise()}}]),t}(z),$=function(e){function t(){var e;return h(this,t),e=n.call(this),e.NAME="compare",e}a(t,e);var n=s(t);return p(t,[{key:"_validate",value:function(e,t){if(!t.comparisonTarget)throw C.default.Error("E0102");if(t.ignoreEmptyValue&&this._isValueEmpty(e))return!0;(0,m.extend)(t,{reevaluate:!0});var n=t.comparisonTarget(),i=t.comparisonType||"==";switch(i){case"==":return e==n;case"!=":return e!=n;case"===":return e===n;case"!==":return e!==n;case">":return e>n;case">=":return e>=n;case"<":return e<n;case"<=":return e<=n}}}]),t}(M),W=function(e){function t(){var e;return h(this,t),e=n.call(this),e.NAME="pattern",e}a(t,e);var n=s(t);return p(t,[{key:"_validate",value:function(e,t){if(t.ignoreEmptyValue!==!1&&this._isValueEmpty(e))return!0;var n=t.pattern;return I.default.isString(n)&&(n=new RegExp(n)),n.test(e)}}]),t}(M),G=function(e){function t(){var e;return h(this,t),e=n.call(this),e.NAME="email",e}a(t,e);var n=s(t);return p(t,[{key:"_validate",value:function(e,t){return!(t.ignoreEmptyValue===!1||!this._isValueEmpty(e))||j.pattern.validate(e,(0,m.extend)({},t,{pattern:/^[\d\w._-]+@([\d\w._-]+\.)+[\w]+$/i}))}}]),t}(M),j={required:new V,numeric:new F,range:new L,stringLength:new H,custom:new z,async:new N,compare:new $,pattern:new W,email:new G},q=_.default.inherit({ctor:function(e){this.group=e,this.validators=[],this._pendingValidators=[],this._onValidatorStatusChanged=this._onValidatorStatusChanged.bind(this),this._resetValidationInfo()},validate:function(){var e=this,t={isValid:!0,brokenRules:[],validators:[],status:B.valid,complete:null};return this._unsubscribeFromAllChangeEvents(),this._pendingValidators=[],this._resetValidationInfo(),(0,y.each)(this.validators,function(n,i){var o=i.validate();t.isValid=t.isValid&&o.isValid,o.brokenRules&&(t.brokenRules=t.brokenRules.concat(o.brokenRules)),t.validators.push(i),o.status===B.pending&&e._addPendingValidator(i),e._subscribeToChangeEvents(i)}),this._pendingValidators.length?t.status=B.pending:(t.status=t.isValid?B.valid:B.invalid,this._unsubscribeFromAllChangeEvents(),this._raiseValidatedEvent(t)),this._updateValidationInfo(t),(0,m.extend)({},this._validationInfo.result)},_subscribeToChangeEvents:function(e){e.on("validating",this._onValidatorStatusChanged),e.on("validated",this._onValidatorStatusChanged)},_unsubscribeFromChangeEvents:function(e){e.off("validating",this._onValidatorStatusChanged),e.off("validated",this._onValidatorStatusChanged)},_unsubscribeFromAllChangeEvents:function(){var e=this;(0,y.each)(this.validators,function(t,n){
e._unsubscribeFromChangeEvents(n)})},_updateValidationInfo:function(e){this._validationInfo.result=e,e.status===B.pending&&(this._validationInfo.deferred||(this._validationInfo.deferred=new R.Deferred,this._validationInfo.result.complete=this._validationInfo.deferred.promise()))},_addPendingValidator:function(e){var t=(0,k.grep)(this._pendingValidators,function(t){return t===e})[0];t||this._pendingValidators.push(e)},_removePendingValidator:function(e){var t=(0,v.inArray)(e,this._pendingValidators);t>=0&&this._pendingValidators.splice(t,1)},_orderBrokenRules:function(e){var t=[];return(0,y.each)(this.validators,function(n,i){var o=(0,k.grep)(e,function(e){return e.validator===i});o.length&&(t=t.concat(o))}),t},_updateBrokenRules:function(e){if(this._validationInfo.result){var t=this._validationInfo.result.brokenRules,n=(0,k.grep)(t,function(t){return t.validator!==e.validator});e.brokenRules&&(t=n.concat(e.brokenRules)),this._validationInfo.result.brokenRules=this._orderBrokenRules(t)}},_onValidatorStatusChanged:function(e){return e.status===B.pending?void this._addPendingValidator(e.validator):void this._resolveIfComplete(e)},_resolveIfComplete:function(e){if(this._removePendingValidator(e.validator),this._updateBrokenRules(e),!this._pendingValidators.length){if(this._unsubscribeFromAllChangeEvents(),!this._validationInfo.result)return;this._validationInfo.result.status=0===this._validationInfo.result.brokenRules.length?B.valid:B.invalid,this._validationInfo.result.isValid=this._validationInfo.result.status===B.valid;var t=(0,m.extend)({},this._validationInfo.result,{complete:null}),n=this._validationInfo.deferred;this._resetValidationInfo(),this._raiseValidatedEvent(t),n&&setTimeout(function(){n.resolve(t)})}},_raiseValidatedEvent:function(e){this.fireEvent("validated",[e])},_resetValidationInfo:function(){this._validationInfo={result:null,deferred:null}},_synchronizeValidationInfo:function(){this._validationInfo.result&&(this._validationInfo.result.validators=this.validators)},removeRegisteredValidator:function(e){var t=(0,v.inArray)(e,this.validators);t>-1&&(this.validators.splice(t,1),this._synchronizeValidationInfo(),this._resolveIfComplete({validator:e}))},registerValidator:function(e){(0,v.inArray)(e,this.validators)<0&&(this.validators.push(e),this._synchronizeValidationInfo())},reset:function(){(0,y.each)(this.validators,function(e,t){t.reset()}),this._pendingValidators=[],this._resetValidationInfo()}}).include(x.default),K={groups:[],getGroupConfig:function(e){var t=(0,k.grep)(this.groups,function(t){return t.group===e});if(t.length)return t[0]},findGroup:function(e,t){var n=e.parents(".dx-validationgroup").first();return n.length?n.dxValidationGroup("instance"):t},initGroups:function(){this.groups=[],this.addGroup()},addGroup:function(e){var t=this.getGroupConfig(e);return t||(t=new q(e),this.groups.push(t)),t},removeGroup:function(e){var t=this.getGroupConfig(e),n=(0,v.inArray)(t,this.groups);return n>-1&&this.groups.splice(n,1),t},_setDefaultMessage:function(e){var t=e.rule,n=e.validator,i=e.name;I.default.isDefined(t.message)||(n.defaultFormattedMessage&&I.default.isDefined(i)?t.message=n.defaultFormattedMessage(i):t.message=n.defaultMessage())},_addBrokenRule:function(e){var t=e.result,n=e.rule;t.brokenRule||(t.brokenRule=n),t.brokenRules||(t.brokenRules=[]),t.brokenRules.push(n)},validate:function(e,t,n){var i=this,o={name:n,value:e,brokenRule:null,brokenRules:null,isValid:!0,validationRules:t,pendingRules:null,status:B.valid,complete:null},a=[];return(0,y.each)(t||[],function(t,r){var s,l=j[r.type];if(!l)throw C.default.Error("E0100");return I.default.isDefined(r.isValid)&&r.value===e&&!r.reevaluate?!!r.isValid||(o.isValid=!1,i._addBrokenRule({result:o,rule:r}),!1):(r.value=e,"async"===r.type?(a.push({rule:r,ruleValidator:l}),!0):(s=l.validate(e,r),r.isValid=s,s||(o.isValid=!1,i._setDefaultMessage({rule:r,validator:l,name:n}),i._addBrokenRule({result:o,rule:r})),!!r.isValid&&void 0))}),o.isValid&&!o.brokenRules&&a.length&&(o=this._validateAsyncRules({value:e,items:a,result:o,name:n})),o.status=o.pendingRules?B.pending:o.isValid?B.valid:B.invalid,o},_validateAsyncRules:function(e){var t=this,n=e.result,i=e.value,o=e.items,a=e.name,r=[];return(0,y.each)(o,function(e,o){var s=o.ruleValidator.validate(i,o.rule);if(I.default.isPromise(s)){n.pendingRules||(n.pendingRules=[]),n.pendingRules.push(o.rule);var l=s.then(function(e){var n=t._getPatchedRuleResult(e);return t._updateRuleConfig({rule:o.rule,ruleResult:n,validator:o.ruleValidator,name:a}),n});r.push(l)}else t._updateRuleConfig({rule:o.rule,ruleResult:t._getPatchedRuleResult(s),validator:o.ruleValidator,name:a})}),r.length&&(n.complete=P.default.all(r).then(function(e){return t._getAsyncRulesResult({result:n,values:e})})),n},_updateRuleConfig:function(e){var t=e.rule,n=e.ruleResult,i=e.validator,o=e.name;t.isValid=n.isValid,n.isValid||(I.default.isDefined(n.message)&&I.default.isString(n.message)&&n.message.length?t.message=n.message:this._setDefaultMessage({rule:t,validator:i,name:o}))},_getPatchedRuleResult:function(e){var t,n=!0;return I.default.isObject(e)?(t=(0,m.extend)({},e),I.default.isDefined(t.isValid)||(t.isValid=n)):t={isValid:I.default.isBoolean(e)?e:n},t},_getAsyncRulesResult:function(e){var t=this,n=e.values,i=e.result;return(0,y.each)(n,function(e,n){if(n.isValid===!1){i.isValid=n.isValid;var o=i.pendingRules[e];t._addBrokenRule({result:i,rule:o})}}),i.pendingRules=null,i.complete=null,i.status=i.isValid?B.valid:B.invalid,i},registerValidatorInGroup:function(e,t){var n=K.addGroup(e);n.registerValidator.call(n,t)},_shouldRemoveGroup:function(e,t){var n=void 0===e,i=e&&"dxValidationGroup"===e.NAME;return!n&&!i&&!t.length},removeRegisteredValidator:function(e,t){var n=K.getGroupConfig(e);if(n){n.removeRegisteredValidator.call(n,t);var i=n.validators;this._shouldRemoveGroup(e,i)&&this.removeGroup(e)}},initValidationOptions:function(e){var t=this,n={};if(e){var i=["isValid","validationStatus","validationError","validationErrors"];i.forEach(function(i){i in e&&(0,m.extend)(n,t.synchronizeValidationOptions({name:i,value:e[i]},e))})}return n},synchronizeValidationOptions:function(e,t){var n=e.name,i=e.value;switch(n){case"validationStatus":var o=i===B.valid||i===B.pending;return t.isValid!==o?{isValid:o}:{};case"isValid":var a=t.validationStatus,r=a;return i&&a===B.invalid?r=B.valid:i||a===B.invalid||(r=B.invalid),r!==a?{validationStatus:r}:{};case"validationErrors":var s=i&&i.length?i[0]:null;return t.validationError!==s?{validationError:s}:{};case"validationError":var l=t.validationErrors;if(!i&&l)return{validationErrors:null};if(i&&!l)return{validationErrors:[i]};if(i&&l&&i!==l[0])return l[0]=i,{validationErrors:l.slice()}}return{}},validateGroup:function(e){var t=K.getGroupConfig(e);if(!t)throw C.default.Error("E0110");return t.validate()},resetGroup:function(e){var t=K.getGroupConfig(e);if(!t)throw C.default.Error("E0110");return t.reset()}};K.initGroups(),e.exports=K},function(e,t,n){var i=n(33).camelize,o=n(62),a=n(1),r=n(11),s=["","Webkit","Moz","O","Ms"],l={"":"",Webkit:"-webkit-",Moz:"-moz-",O:"-o-",ms:"-ms-"},u=o(function(){return r.createElement("dx").style}),c=function(e,t){e=i(e,!0);for(var n,o=0,a=s.length;o<a;o++){var r=s[o],l=r+e,u=i(l);if(n=t(u,r),void 0===n&&(n=t(l,r)),void 0!==n)break}return n||""},d=function(e){if(e in u())return e;var t=e;e=e.charAt(0).toUpperCase()+e.substr(1);for(var n=1;n<s.length;n++){var i=s[n].toLowerCase()+e;if(i in u())return i}return t},h=function(e){return c(e,function(e,t){if(e in u())return l[t]})},f=["fillOpacity","columnCount","flexGrow","flexShrink","fontWeight","lineHeight","opacity","zIndex","zoom"],p=function(e,t){return a.isNumeric(t)&&f.indexOf(e)===-1&&(t+="px"),t},g=function(e,t,n){if(e){n=a.isNumeric(n)?n+="px":n;for(var i=0;i<e.length;++i)e[i].style[t]=n}},_=function(e,t){g(e,"width",t)},m=function(e,t){g(e,"height",t)};t.styleProp=d,t.stylePropPrefix=h,t.normalizeStyleProp=p,t.setWidth=_,t.setHeight=m},function(e,t,n){var i=n(64).logger,o=n(55);e.exports=o({isWrapped:function(){return!1},isWritableWrapped:function(){return!1},wrap:function(e){return e},unwrap:function(e){return e},assign:function(){i.error("Method 'assign' should not be used for not wrapped variables. Use 'isWrapped' method for ensuring.")}})},function(e,t,n){var i=n(2),o=n(52),a=n(11),r=n(5),s=n(39),l=n(15),u=n(0).extend,c=n(14).inArray,d=n(3).each,h=n(69),f=n(8),p=n(24),g=n(132),_="dxEventManager",m="dxEmitter",v=l.inherit({ctor:function(){this._attachHandlers(),this.reset(),this._proxiedCancelHandler=this._cancelHandler.bind(this),this._proxiedAcceptHandler=this._acceptHandler.bind(this)},_attachHandlers:function(){o.add(function(){var e=a.getDocument();r.subscribeGlobal(e,f.addNamespace(p.down,_),this._pointerDownHandler.bind(this)),r.subscribeGlobal(e,f.addNamespace(p.move,_),this._pointerMoveHandler.bind(this)),r.subscribeGlobal(e,f.addNamespace([p.up,p.cancel].join(" "),_),this._pointerUpHandler.bind(this)),r.subscribeGlobal(e,f.addNamespace(g.name,_),this._mouseWheelHandler.bind(this))}.bind(this))},_eachEmitter:function(e){for(var t=this._activeEmitters||[],n=0;t.length>n;){var i=t[n];if(e(i)===!1)break;t[n]===i&&n++}},_applyToEmitters:function(e,t){this._eachEmitter(function(n){n[e].call(n,t)})},reset:function(){this._eachEmitter(this._proxiedCancelHandler),this._activeEmitters=[]},resetEmitter:function(e){this._proxiedCancelHandler(e)},_pointerDownHandler:function(e){f.isMouseEvent(e)&&e.which>1||this._updateEmitters(e)},_updateEmitters:function(e){this._isSetChanged(e)&&(this._cleanEmitters(e),this._fetchEmitters(e))},_isSetChanged:function(e){var t=this._closestEmitter(e),n=this._emittersSet||[],i=t.length!==n.length;return d(t,function(e,t){return i=i||n[e]!==t,!i}),this._emittersSet=t,i},_closestEmitter:function(e){function t(t,i){i&&i.validatePointers(e)&&i.validate(e)&&(i.addCancelCallback(n._proxiedCancelHandler),i.addAcceptCallback(n._proxiedAcceptHandler),o.push(i))}for(var n=this,o=[],a=i(e.target);a.length;){var r=s.data(a.get(0),m)||[];d(r,t),a=a.parent()}return o},_acceptHandler:function(e,t){var n=this;this._eachEmitter(function(i){i!==e&&n._cancelEmitter(i,t)})},_cancelHandler:function(e,t){this._cancelEmitter(e,t)},_cancelEmitter:function(e,t){var n=this._activeEmitters;t?e.cancel(t):e.reset(),e.removeCancelCallback(),e.removeAcceptCallback();var i=c(e,n);i>-1&&n.splice(i,1)},_cleanEmitters:function(e){this._applyToEmitters("end",e),this.reset(e)},_fetchEmitters:function(e){this._activeEmitters=this._emittersSet.slice(),this._applyToEmitters("start",e)},_pointerMoveHandler:function(e){this._applyToEmitters("move",e)},_pointerUpHandler:function(e){this._updateEmitters(e)},_mouseWheelHandler:function(e){this._allowInterruptionByMouseWheel()&&(e.pointers=[null],this._pointerDownHandler(e),this._adjustWheelEvent(e),this._pointerMoveHandler(e),e.pointers=[],this._pointerUpHandler(e))},_allowInterruptionByMouseWheel:function(){var e=!0;return this._eachEmitter(function(t){return e=t.allowInterruptionByMouseWheel()&&e}),e},_adjustWheelEvent:function(e){var t=null;if(this._eachEmitter(function(n){if(n.gesture){var i=n.getDirection(e);return"horizontal"!==i&&!e.shiftKey||"vertical"!==i&&e.shiftKey?(t=n,!1):void 0}}),t){var n=t.getDirection(e),i="both"===n&&!e.shiftKey||"vertical"===n,o=i?"pageY":"pageX";e[o]+=e.delta}},isActive:function(e){var t=!1;return this._eachEmitter(function(n){t=t||n.getElement().is(e)}),t}}),y=new v,b="dxEmitterSubscription",x=function(e){var t=e.emitter,n=e.events[0],i=e.events;d(i,function(o,a){h(a,{noBubble:!e.bubble,setup:function(e){var i=s.data(e,b)||{},o=s.data(e,m)||{},r=o[n]||new t(e);i[a]=!0,o[n]=r,s.data(e,m,o),s.data(e,b,i)},add:function(e,t){var i=s.data(e,m),o=i[n];o.configure(u({delegateSelector:t.selector},t.data),t.type)},teardown:function(e){var t=s.data(e,b),o=s.data(e,m),r=o[n];delete t[a];var l=!0;d(i,function(e,n){return l=l&&!t[n]}),l&&(y.isActive(e)&&y.resetEmitter(r),r&&r.dispose(),delete o[n])}})})};e.exports=x},function(e,t,n){var i=n(15),o=i.abstract,a=n(83),r=n(3).each,s=n(38),l=n(42),u=n(20).compileGetter,c=n(85),d=c.queryByOptions,h=n(6).Deferred,f=n(4).noop,p={},g=i.inherit({ctor:function(e){var t=this;e=e||{},r(["onLoaded","onLoading","onInserted","onInserting","onUpdated","onUpdating","onPush","onRemoved","onRemoving","onModified","onModifying"],function(n,i){i in e&&t.on(i.slice(2).toLowerCase(),e[i])}),this._key=e.key,this._errorHandler=e.errorHandler,this._useDefaultSearch=!0},_customLoadOptions:function(){return null},key:function(){return this._key},keyOf:function(e){return this._keyGetter||(this._keyGetter=u(this.key())),this._keyGetter(e)},_requireKey:function(){if(!this.key())throw s.errors.Error("E4005")},load:function(e){var t=this;return e=e||{},this.fireEvent("loading",[e]),this._withLock(this._loadImpl(e)).done(function(n){t.fireEvent("loaded",[n,e])})},_loadImpl:function(e){return d(this.createQuery(e),e).enumerate()},_withLock:function(e){var t=new h;return e.done(function(){var e=this,n=arguments;l.processRequestResultLock.promise().done(function(){t.resolveWith(e,n)})}).fail(function(){t.rejectWith(this,arguments)}),t},createQuery:o,totalCount:function(e){return this._totalCountImpl(e)},_totalCountImpl:function(e){return d(this.createQuery(e),e,!0).count()},byKey:function(e,t){return this._addFailHandlers(this._withLock(this._byKeyImpl(e,t)))},_byKeyImpl:o,insert:function(e){var t=this;return t.fireEvent("modifying"),t.fireEvent("inserting",[e]),t._addFailHandlers(t._insertImpl(e).done(function(e,n){t.fireEvent("inserted",[e,n]),t.fireEvent("modified")}))},_insertImpl:o,update:function(e,t){var n=this;return n.fireEvent("modifying"),n.fireEvent("updating",[e,t]),n._addFailHandlers(n._updateImpl(e,t).done(function(){n.fireEvent("updated",[e,t]),n.fireEvent("modified")}))},_updateImpl:o,push:function(e){this._pushImpl(e),this.fireEvent("push",[e])},_pushImpl:f,remove:function(e){var t=this;return t.fireEvent("modifying"),t.fireEvent("removing",[e]),t._addFailHandlers(t._removeImpl(e).done(function(e){t.fireEvent("removed",[e]),t.fireEvent("modified")}))},_removeImpl:o,_addFailHandlers:function(e){return e.fail(this._errorHandler).fail(s._errorHandler)}}).include(a);g.create=function(e,t){if(!(e in p))throw s.errors.Error("E4020",e);return new p[e](t)},g.registerClass=function(e,t){return t&&(p[t]=e),e},g.inherit=function(e){return function(t,n){var i=e.apply(this,[t]);return g.registerClass(i,n),i}}(g.inherit),e.exports=g},function(e,t,n){e.exports=n(521)},function(e,t,n){function i(e){return e&&e.__esModule?e:{"default":e}}var o=n(2),a=i(o),r=n(5),s=i(r),l=n(45),u=i(l),c=n(23),d=i(c),h=n(4),f=i(h),p=n(1),g=i(p),_=n(0),m=n(12),v=n(7),y=i(v),b=n(11),x=i(b),w=n(16),C=i(w),k=n(9),S=i(k),I=n(86),D=i(I),T=n(66),E=i(T),A=n(8),O=i(A),P=n(248),R=i(P),B=n(313),M=i(B),V=n(247),F=i(V),L=n(6),H="dxScrollable",z="dxScrollableStrategy",N="dx-scrollable",$="dx-scrollable-disabled",W="dx-scrollable-container",G="dx-scrollable-wrapper",j="dx-scrollable-content",q="dx-scrollable-customizable-scrollbars",K="vertical",U="horizontal",Y="both",X=function(){return[{device:function(){return!u.default.nativeScrolling},options:{useNative:!1}},{device:function(e){return!C.default.isSimulator()&&"desktop"===C.default.real().deviceType&&"generic"===e.platform},options:{bounceEnabled:!1,scrollByThumb:!0,scrollByContent:u.default.touch,showScrollbar:"onHover"}}]},Z=D.default.inherit({_getDefaultOptions:function(){return(0,_.extend)(this.callBase(),{disabled:!1,onScroll:null,direction:K,showScrollbar:"onScroll",useNative:!0,bounceEnabled:!0,scrollByContent:!0,scrollByThumb:!1,onUpdated:null,onStart:null,onEnd:null,onBounce:null,onStop:null,useSimulatedScrollbar:!1,useKeyboard:!0,inertiaEnabled:!0,pushBackValue:0,updateManually:!1})},_defaultOptionsRules:function(){return this.callBase().concat(X(),[{device:function(){return u.default.nativeScrolling&&"android"===C.default.real().platform&&!d.default.mozilla},options:{useSimulatedScrollbar:!0}},{device:function(){return"ios"===C.default.real().platform},options:{pushBackValue:1}}])},_initOptions:function(e){this.callBase(e),"useSimulatedScrollbar"in e||this._setUseSimulatedScrollbar()},_setUseSimulatedScrollbar:function(){this.initialOption("useSimulatedScrollbar")||this.option("useSimulatedScrollbar",!this.option("useNative"))},_init:function(){this.callBase(),this._initScrollableMarkup(),this._locked=!1},_visibilityChanged:function(e){e?(this.update(),this._updateRtlPosition(),this._savedScrollOffset&&this.scrollTo(this._savedScrollOffset),delete this._savedScrollOffset):this._savedScrollOffset=this.scrollOffset()},_initScrollableMarkup:function(){var e=this.$element().addClass(N),t=this._$container=(0,a.default)("<div>").addClass(W),n=this._$wrapper=(0,a.default)("<div>").addClass(G),i=this._$content=(0,a.default)("<div>").addClass(j);x.default.hasDocumentProperty("onbeforeactivate")&&d.default.msie&&d.default.version<12&&s.default.on(e,O.default.addNamespace("beforeactivate",H),function(e){(0,a.default)(e.target).is(E.default.focusable)||e.preventDefault()}),i.append(e.contents()).appendTo(t),t.appendTo(n),n.appendTo(e)},_dimensionChanged:function(){this.update()},_attachNativeScrollbarsCustomizationCss:function(){"desktop"!==C.default.real().deviceType||y.default.getNavigator().platform.indexOf("Mac")>-1&&d.default.webkit||this.$element().addClass(q)},_initMarkup:function(){this.callBase(),this._renderDirection()},_render:function(){this._renderStrategy(),this._attachNativeScrollbarsCustomizationCss(),this._attachEventHandlers(),this._renderDisabledState(),this._createActions(),this.update(),this.callBase(),this._updateRtlPosition()},_updateRtlPosition:function(){var e=this;this._updateBounds(),this.option("rtlEnabled")&&this.option("direction")!==K&&f.default.deferUpdate(function(){var t=e._container().get(0),n=t.scrollWidth-t.clientWidth;f.default.deferRender(function(){e.scrollTo({left:n})})})},_updateBounds:function(){this._strategy.updateBounds()},_attachEventHandlers:function(){var e=this._strategy,t={getDirection:e.getDirection.bind(e),validate:this._validate.bind(this),isNative:this.option("useNative"),scrollTarget:this._$container};s.default.off(this._$wrapper,"."+H),s.default.on(this._$wrapper,O.default.addNamespace(R.default.init,H),t,this._initHandler.bind(this)),s.default.on(this._$wrapper,O.default.addNamespace(R.default.start,H),e.handleStart.bind(e)),s.default.on(this._$wrapper,O.default.addNamespace(R.default.move,H),e.handleMove.bind(e)),s.default.on(this._$wrapper,O.default.addNamespace(R.default.end,H),e.handleEnd.bind(e)),s.default.on(this._$wrapper,O.default.addNamespace(R.default.cancel,H),e.handleCancel.bind(e)),s.default.on(this._$wrapper,O.default.addNamespace(R.default.stop,H),e.handleStop.bind(e)),s.default.off(this._$container,"."+H),s.default.on(this._$container,O.default.addNamespace("scroll",H),e.handleScroll.bind(e))},_validate:function(e){return!this._isLocked()&&(this._updateIfNeed(),this._strategy.validate(e))},_initHandler:function(){var e=this._strategy;e.handleInit.apply(e,arguments)},_renderDisabledState:function(){this.$element().toggleClass($,this.option("disabled")),this.option("disabled")?this._lock():this._unlock()},_renderDirection:function(){this.$element().removeClass("dx-scrollable-"+U).removeClass("dx-scrollable-"+K).removeClass("dx-scrollable-"+Y).addClass("dx-scrollable-"+this.option("direction"))},_renderStrategy:function(){this._createStrategy(),this._strategy.render(),this.$element().data(z,this._strategy)},_createStrategy:function(){this._strategy=this.option("useNative")?new F.default(this):new M.default.SimulatedStrategy(this)},_createActions:function(){this._strategy&&this._strategy.createActions()},_clean:function(){this._strategy&&this._strategy.dispose()},_optionChanged:function(e){switch(e.name){case"onStart":case"onEnd":case"onStop":case"onUpdated":case"onScroll":case"onBounce":this._createActions();break;case"direction":this._resetInactiveDirection(),this._invalidate();break;case"useNative":this._setUseSimulatedScrollbar(),this._invalidate();break;case"inertiaEnabled":case"scrollByContent":case"scrollByThumb":case"bounceEnabled":case"useKeyboard":case"showScrollbar":case"useSimulatedScrollbar":case"pushBackValue":this._invalidate();break;case"disabled":this._renderDisabledState(),this._strategy&&this._strategy.disabledChanged();break;case"updateManually":break;case"width":this.callBase(e),this._updateRtlPosition();break;default:this.callBase(e)}},_resetInactiveDirection:function(){var e=this._getInactiveProp();if(e&&y.default.hasWindow()){var t=this.scrollOffset();t[e]=0,this.scrollTo(t)}},_getInactiveProp:function(){var e=this.option("direction");return e===K?"left":e===U?"top":void 0},_location:function(){return this._strategy.location()},_normalizeLocation:function(e){if(g.default.isPlainObject(e)){var t=f.default.ensureDefined(e.left,e.x),n=f.default.ensureDefined(e.top,e.y);return{left:g.default.isDefined(t)?-t:void 0,top:g.default.isDefined(n)?-n:void 0}}var i=this.option("direction");return{left:i!==K?-e:void 0,top:i!==U?-e:void 0}},_isLocked:function(){return this._locked},_lock:function(){this._locked=!0},_unlock:function(){this.option("disabled")||(this._locked=!1)},_isDirection:function(e){var t=this.option("direction");return e===K?t!==U:e===U?t!==K:t===e},_updateAllowedDirection:function(){var e=this._strategy._allowedDirections();this._isDirection(Y)&&e.vertical&&e.horizontal?this._allowedDirectionValue=Y:this._isDirection(U)&&e.horizontal?this._allowedDirectionValue=U:this._isDirection(K)&&e.vertical?this._allowedDirectionValue=K:this._allowedDirectionValue=null},_allowedDirection:function(){return this._allowedDirectionValue},_container:function(){return this._$container},$content:function(){return this._$content},content:function(){return(0,m.getPublicElement)(this._$content)},scrollOffset:function(){var e=this._location();return{top:-e.top,left:-e.left}},scrollTop:function(){return this.scrollOffset().top},scrollLeft:function(){return this.scrollOffset().left},clientHeight:function(){return this._$container.height()},scrollHeight:function(){return this.$content().outerHeight()-2*this._strategy.verticalOffset()},clientWidth:function(){return this._$container.width()},scrollWidth:function(){return this.$content().outerWidth()},update:function(){if(this._strategy)return(0,L.when)(this._strategy.update()).done(function(){this._updateAllowedDirection()}.bind(this))},scrollBy:function(e){e=this._normalizeLocation(e),(e.top||e.left)&&(this._updateIfNeed(),this._strategy.scrollBy(e))},scrollTo:function(e){e=this._normalizeLocation(e),this._updateIfNeed();var t=this._location();this.option("useNative")||(e=this._strategy._applyScaleRatio(e),t=this._strategy._applyScaleRatio(t));var n=this._normalizeLocation({left:t.left-f.default.ensureDefined(e.left,t.left),top:t.top-f.default.ensureDefined(e.top,t.top)});(n.top||n.left)&&this._strategy.scrollBy(n)},scrollToElement:function(e,t){var n=(0,a.default)(e),i=this.$content().find(e).length,o=n.parents("."+N).length-n.parents("."+j).length===0;if(i&&o){var r={top:0,left:0},s=this.option("direction");s!==K&&(r.left=this.getScrollElementPosition(n,U,t)),s!==U&&(r.top=this.getScrollElementPosition(n,K,t)),this.scrollTo(r)}},getScrollElementPosition:function(e,t,n){n=n||{};var i=t===K,o=(i?n.top:n.left)||0,a=(i?n.bottom:n.right)||0,r=i?this._strategy.verticalOffset():0,s=this._elementPositionRelativeToContent(e,i?"top":"left"),l=s-r,u=e[i?"outerHeight":"outerWidth"](),c=i?this.scrollTop():this.scrollLeft(),d=i?this.clientHeight():this.clientWidth(),h=c-l+o,f=c-l-u+d-a;return h<=0&&f>=0?c:c-(Math.abs(h)>Math.abs(f)?f:h)},_elementPositionRelativeToContent:function(e,t){for(var n=0;this._hasScrollContent(e);)n+=e.position()[t],e=e.offsetParent();return n},_hasScrollContent:function(e){var t=this.$content();return e.closest(t).length&&!e.is(t)},_updateIfNeed:function(){this.option("updateManually")||this.update()}});(0,S.default)(H,Z),e.exports=Z,e.exports.deviceDependentOptions=X},function(e,t,n){var i=n(2),o=n(4),a=n(1),r=a.isDefined,s=a.isPromise,l=n(0).extend,u=n(14).inArray,c=n(3).each,d=n(6),h=n(12).getPublicElement,f=d.Deferred,p=n(21),g=n(11),_=n(75),m=n(10),v=n(9),y=n(245),b=n(8).normalizeKeyName,x=".dx-state-disabled",w="dx-selectbox",C="dx-selectbox-popup",k="dx-selectbox-container",S="dx-selectbox-popup-wrapper",I=y.inherit({_supportedKeys:function(){var e=this,t=this.callBase(),n=function(e){var t=this._isEditable();t?this._valueSubstituted()&&(this._preventFiltering=!0):this.option("showClearButton")&&(e.preventDefault(),this.reset()),this._preventSubstitution=!0},i=function(){e.option("searchEnabled")&&e._valueSubstituted()&&e._searchHandler()};return l({},t,{tab:function(){this.option("opened")&&"instantly"===this.option("applyValueMode")&&this._cleanInputSelection(),this._wasSearch()&&this._clearFilter(),t.tab&&t.tab.apply(this,arguments)},upArrow:function(e){if(t.upArrow&&t.upArrow.apply(this,arguments))return this.option("opened")||this._setNextValue(e),!0},downArrow:function(e){if(t.downArrow&&t.downArrow.apply(this,arguments))return this.option("opened")||this._setNextValue(e),!0},leftArrow:function(){i(),t.leftArrow&&t.leftArrow.apply(this,arguments)},rightArrow:function(){i(),t.rightArrow&&t.rightArrow.apply(this,arguments)},home:function(){i(),t.home&&t.home.apply(this,arguments)},end:function(){i(),t.end&&t.end.apply(this,arguments)},escape:function(){var e=t.escape&&t.escape.apply(this,arguments);return this._cancelEditing(),!r(e)||e},enter:function(e){var n=this.option("opened"),i=this._input().val().trim(),o=i&&this._list&&!this._list.option("focusedElement");if(!i&&r(this.option("value"))&&this.option("allowClearing"))this.option({selectedItem:null,value:null}),this.close();else{if(this.option("acceptCustomValue"))return e.preventDefault(),o&&(this._valueChangeEventHandler(e),n&&this._toggleOpenState()),n;if(t.enter&&t.enter.apply(this,arguments))return n}},space:function(e){var t=this.option("opened"),n=this.option("searchEnabled"),i=this.option("acceptCustomValue");if(t&&!n&&!i)return e.preventDefault(),this._valueChangeEventHandler(e),!0},backspace:n,del:n})},_getDefaultOptions:function(){return l(this.callBase(),{placeholder:m.format("Select"),fieldTemplate:null,valueChangeEvent:"change",acceptCustomValue:!1,onCustomItemCreating:function(e){r(e.customItem)||(e.customItem=e.text)},showSelectionControls:!1,autocompletionEnabled:!0,allowClearing:!0,tooltipEnabled:!1,openOnFieldClick:!0,showDropDownButton:!0,displayCustomValue:!1,_isAdaptablePopupPosition:!1,useInkRipple:!1,useHiddenSubmitElement:!0})},_init:function(){this.callBase(),this._initCustomItemCreatingAction()},_initMarkup:function(){this.$element().addClass(w),this._renderTooltip(),this.option("useInkRipple")&&this._renderInkRipple(),this.callBase(),this._$container.addClass(k)},_renderInkRipple:function(){this._inkRipple=_.render()},_toggleActiveState:function(e,t,n){if(this.callBase.apply(this,arguments),this._inkRipple&&!this._isEditable()){var i={element:this._inputWrapper(),event:n};t?this._inkRipple.showWave(i):this._inkRipple.hideWave(i)}},_createPopup:function(){this.callBase(),this._popup.$element().addClass(C),this._popup.overlayContent().attr("tabindex",-1)},_popupWrapperClass:function(){return this.callBase()+" "+S},_cancelEditing:function(){!this.option("searchEnabled")&&this._list&&(this._focusListElement(null),this._updateField(this.option("selectedItem")))},_renderOpenedState:function(){this.callBase(),this.option("opened")&&(this._scrollToSelectedItem(),this._focusSelectedElement())},_focusSelectedElement:function(){var e=this._searchValue();if(!e)return void this._focusListElement(null);var t=this._list._itemElements(),n=u(this.option("selectedItem"),this.option("items")),i=n>=0&&!this._isCustomItemSelected()?t.eq(n):null;this._focusListElement(i)},_renderFocusedElement:function(){if(this._list){var e=this._searchValue();if(!e||this.option("acceptCustomValue"))return void this._focusListElement(null);var t=this._list._itemElements(),n=t.not(x).eq(0);this._focusListElement(n)}},_focusListElement:function(e){this._preventInputValueRender=!0,this._list.option("focusedElement",h(e)),delete this._preventInputValueRender},_scrollToSelectedItem:function(){this._list&&this._list.scrollToItem(this._list.option("selectedItem"))},_listContentReadyHandler:function(){this.callBase();var e=this._dataSource&&this._dataSource.paginate();e&&this._needPopupRepaint()||this._scrollToSelectedItem()},_renderValue:function(){return this._renderInputValue(),this._setSubmitValue(),(new f).resolve()},_renderInputValue:function(){return this.callBase().always(function(){this._renderInputValueAsync()}.bind(this))},_renderInputValueAsync:function(){this._renderTooltip(),this._renderInputValueImpl().always(function(){this._refreshSelected()}.bind(this))},_renderInputValueImpl:function(){return this._renderField(),(new f).resolve()},_setNextItem:function(e){var t=this._calcNextItem(e),n=this._valueGetter(t);this._setValue(n)},_setNextValue:function(e){var t=this._dataSource.isLoaded()?(new f).resolve():this._dataSource.load();t.done(function(){var t=this._getSelectedIndex(),n=this._dataSource.pageSize(),i=this._dataSource.isLastPage(),o=t===this._items().length-1;this._saveValueChangeEvent(e);var a="downArrow"===b(e)?1:-1;n&&!i&&o&&a>0?(this._popup||this._createPopup(),this._dataSource.isLoading()||this._list._loadNextPage().done(this._setNextItem.bind(this,a))):this._setNextItem(a)}.bind(this))},_setSelectedItem:function(e){var t=!this._isCustomValueAllowed()&&void 0===e;this.callBase(t?null:e),t||this._isEditable()&&!this._isCustomItemSelected()||this._setListOption("selectedItem",this.option("selectedItem"))},_isCustomValueAllowed:function(){return this.option("acceptCustomValue")||this.callBase()},_displayValue:function(e){return e=!r(e)&&this._isCustomValueAllowed()?this.option("value"):e,this.callBase(e)},_listConfig:function(){var e=l(this.callBase(),{pageLoadMode:"scrollBottom",onSelectionChanged:this._getSelectionChangeHandler(),selectedItem:this.option("selectedItem"),onFocusedItemChanged:this._listFocusedItemChangeHandler.bind(this)});return this.option("showSelectionControls")&&l(e,{showSelectionControls:!0,selectionByClick:!0}),e},_listFocusedItemChangeHandler:function(e){if(!this._preventInputValueRender){var t=e.component,n=i(t.option("focusedElement")),o=t._getItemData(n);this._updateField(o)}},_updateField:function(e){var t=this._getTemplateByOption("fieldTemplate");if(!t||!this.option("fieldTemplate")){var n=this._displayGetter(e);return this.option("text",n),void this._renderDisplayText(n)}this._renderField()},_getSelectionChangeHandler:function(){return this.option("showSelectionControls")?this._selectionChangeHandler.bind(this):o.noop},_selectionChangeHandler:function(e){c(e.addedItems||[],function(e,t){this._setValue(this._valueGetter(t))}.bind(this))},_getActualSearchValue:function(){return this._dataSource.searchValue()},_toggleOpenState:function(e){if(!this.option("disabled")){if(e=arguments.length?e:!this.option("opened"),e||this._restoreInputText(!0),this._wasSearch()&&e){this._wasSearch(!1);var t=this.option("showDataBeforeSearch")||0===this.option("minSearchLength");if(t&&this._dataSource){if(this._searchTimer)return;var n=this._getActualSearchValue();n&&this._wasSearch(!0),this._filterDataSource(n||null)}else this._setListOption("items",[])}e&&this._scrollToSelectedItem(),this.callBase(e)}},_renderTooltip:function(){this.option("tooltipEnabled")&&this.$element().attr("title",this.option("displayValue"))},_renderDimensions:function(){this.callBase(),this._setPopupOption("width")},_isValueEqualInputText:function(){var e=this.option("selectedItem"),t=this._displayGetter(e),n=t?String(t):"",i=this._searchValue();return n===i},_popupHidingHandler:function(){this._isValueEqualInputText()&&this._cancelEditing(),this.callBase()},_restoreInputText:function(e){
this.option("readOnly")||this._loadItemDeferred&&this._loadItemDeferred.always(function(){var t=this.option("selectedItem");return this.option("acceptCustomValue")?void(e||(this._updateField(t),this._clearFilter())):this.option("searchEnabled")&&!this._searchValue()&&this.option("allowClearing")?void this._clearTextValue():void(this._isValueEqualInputText()||this._renderInputValue().always(function(e){var n=o.ensureDefined(e,t);this._setSelectedItem(n),this._updateField(n),this._clearFilter()}.bind(this)))}.bind(this))},_focusOutHandler:function(e){if(!this._preventNestedFocusEvent(e)){var t=this._isOverlayNestedTarget(e.relatedTarget);t||(this._restoreInputText(),this._clearSearchTimer());var n=this._wasSearch()&&!this.option("acceptCustomValue")&&this.option("searchEnabled")&&this.option("opened")&&!t;n&&this._searchCanceled()}this.callBase(e)},_isOverlayNestedTarget:function(e){return!!i(e).closest(".".concat(S)).length},_clearTextValue:function(){this.option("selectedItem")&&this.option("value",null)},_shouldOpenPopup:function(){return this._needPassDataSourceToList()},_isFocused:function(){var e=g.getActiveElement();return this.callBase()&&i(e).closest(this._input()).length>0},_renderValueChangeEvent:function(){this._isEditable()&&this.callBase()},_isEditable:function(){return this.option("acceptCustomValue")||this.option("searchEnabled")},_fieldRenderData:function(){var e=this._list&&this.option("opened")&&i(this._list.option("focusedElement"));return e&&e.length?this._list._getItemData(e):this.option("selectedItem")},_readOnlyPropValue:function(){return!this._isEditable()||this.option("readOnly")},_isSelectedValue:function(e){return this._isValueEquals(e,this.option("value"))},_shouldCloseOnItemClick:function(){return!(this.option("showSelectionControls")&&"single"!==this.option("selectionMode"))},_listItemClickHandler:function(e){var t=this._getCurrentValue();this._focusListElement(i(e.itemElement)),this._saveValueChangeEvent(e.event),this._shouldClearFilter()&&this._clearFilter(),this._completeSelection(this._valueGetter(e.itemData)),this._shouldCloseOnItemClick()&&this.option("opened",!1),this.option("searchEnabled")&&t===this._valueGetter(e.itemData)&&this._updateField(e.itemData)},_shouldClearFilter:function(){return this._wasSearch()},_completeSelection:function(e){this._setValue(e)},_loadItem:function(e,t){var n=this,i=new f;return this.callBase(e,t).done(function(e){i.resolve(e)}.bind(this)).fail(function(){var t=n.option("selectedItem");n.option("acceptCustomValue")&&e===n._valueGetter(t)?i.resolve(t):i.reject()}.bind(this)),i.promise()},_loadInputValue:function(e,t){return this._loadItemDeferred=this._loadItem(e).always(t),this._loadItemDeferred},_isCustomItemSelected:function(){var e=this.option("selectedItem"),t=this._searchValue(),n=this._displayGetter(e);return!n||t!==n.toString()},_valueChangeEventHandler:function(e){this.option("acceptCustomValue")&&this._isCustomItemSelected()&&!this._isValueChanging&&(this._isValueChanging=!0,this._customItemAddedHandler(e),this._isValueChanging=!1)},_initCustomItemCreatingAction:function(){this._customItemCreatingAction=this._createActionByOption("onCustomItemCreating")},_createCustomItem:function(e){var t={text:e},n=this._customItemCreatingAction(t),i=o.ensureDefined(n,t.customItem);return r(n)&&p.log("W0015","onCustomItemCreating","customItem"),i},_customItemAddedHandler:function(e){var t=this._searchValue(),n=this._createCustomItem(t);if(this._saveValueChangeEvent(e),void 0===n)throw this._renderValue(),p.Error("E0121");s(n)?d.fromPromise(n).done(this._setCustomItem.bind(this)).fail(this._setCustomItem.bind(this,null)):this._setCustomItem(n)},_setCustomItem:function(e){this._disposed||(e=e||null,this.option("selectedItem",e),this._shouldClearFilter()&&this._filterDataSource(null),this._setValue(this._valueGetter(e)),this._renderDisplayText(this._displayGetter(e)))},_clearValueHandler:function(e){return this.callBase(e),!1},_wasSearch:function(e){return arguments.length?void(this._wasSearchValue=e):this._wasSearchValue},_searchHandler:function(e){return this._preventFiltering?void delete this._preventFiltering:(this._needPassDataSourceToList()&&this._wasSearch(!0),void this.callBase(e))},_dataSourceFiltered:function(e){this.callBase(),null!==e&&(this._renderInputSubstitution(),this._renderFocusedElement())},_valueSubstituted:function(){var e=this._input().get(0),t=0===e.selectionStart&&e.selectionEnd===this._searchValue().length,n=e.selectionStart!==e.selectionEnd;return this._wasSearch()&&n&&!t},_shouldSubstitutionBeRendered:function(){return this.option("autocompletionEnabled")&&!this._preventSubstitution&&this.option("searchEnabled")&&!this.option("acceptCustomValue")&&"startswith"===this.option("searchMode")},_renderInputSubstitution:function(){if(!this._shouldSubstitutionBeRendered())return void delete this._preventSubstitution;var e=this._list&&this._getPlainItems(this._list.option("items"))[0];if(e){var t=this._input(),n=t.val().length;if(0!==n){var i=t.get(0),o=this._displayGetter(e).toString();i.value=o,this._caret({start:n,end:o.length})}}},_cleanInputSelection:function(){var e=this._input().get(0),t=e.value.length;e.selectionStart=t,e.selectionEnd=t},_dispose:function(){this._renderInputValueAsync=o.noop,delete this._loadItemDeferred,this.callBase()},_optionChanged:function(e){switch(e.name){case"_isAdaptablePopupPosition":case"autocompletionEnabled":break;case"onCustomItemCreating":this._initCustomItemCreatingAction();break;case"tooltipEnabled":this._renderTooltip();break;case"displayCustomValue":case"acceptCustomValue":case"showSelectionControls":case"useInkRipple":this._invalidate();break;case"allowClearing":break;default:this.callBase(e)}},_clean:function(){delete this._inkRipple,this.callBase()}});v("dxSelectBox",I),e.exports=I},function(e,t,n){function i(e){return e&&e.__esModule?e:{"default":e}}var o=n(340),a=i(o);e.exports=a.default},function(e,t,n){function i(e){return e&&e.__esModule?e:{"default":e}}function o(){var e=E.testFormats(j);return{unsupported:e.unsupported,supported:e.supported.concat(q)}}function a(e,t,n){return n=n||o(),e=String(e).toUpperCase(),n.supported.indexOf(e)!==-1?e:void(n.unsupported.indexOf(e)!==-1&&t&&t("W2108",[e]))}function r(e){return"SVG"===e?A.getData:"PDF"===e?O.getData:E.getData}function s(e,t){var n=(0,g.getWindow)().document,i=n.createElement("iframe");i.onload=l(e,t),i.style.visibility="hidden",i.style.position="fixed",i.style.right="0",i.style.bottom="0",n.body.appendChild(i)}function l(e,t){return function(){var t=this,n=this.contentWindow,i=n.document.createElement("img");n.document.body.appendChild(i);var o=function(){t.parentElement.removeChild(t)};i.addEventListener("load",function(){n.focus(),n.print()}),i.addEventListener("error",o),n.addEventListener("afterprint",function(){setTimeout(o,0)}),i.src=e}}function u(e,t,n){var i=R-V,o=R+M+z+n*H,a={rect:{width:V-2*z,height:H,x:i+z,y:o},text:{x:i+(e.rtl?V-L:L),y:o+H-F}};return"printing"===t&&(a.separator={stroke:e.button.default.borderColor,"stroke-width":z,cursor:"pointer",sharp:"v",d:"M "+i+" "+(o+H-z)+" L "+(i+V)+" "+(o+H-z)}),a}function c(e,t,n){var i={},o=n.type,a=n.format,r=u(t,o,n.itemIndex),s=(0,_.patchFontOptions)(t.font);s["pointer-events"]="none";var l=e.g().attr({"class":K+"-list-item"});i[U]=o,a&&(i[Y]=a);var c=e.rect();c.attr(r.rect).css({cursor:"pointer","pointer-events":"all"}).data(i),c.on(S.default.start+".export",function(){return c.attr({fill:t.button.hover.backgroundColor})}).on(S.default.end+".export",function(){return c.attr({fill:null})}),c.append(l);var d=e.text(n.text).css(s).attr(r.text).append(l);return"printing"===o&&e.path(null,"line").attr(r.separator).append(l),{g:l,rect:c,resetState:function(){return c.attr({fill:null})},fixPosition:function(){var e=d.getBBox();d.move(r.text.x-e.x-(t.rtl?e.width:0))}}}function d(e,t){var n=[];return t.printingEnabled&&n.push(c(e,t,{type:"printing",text:b.default.format("vizExport-printingButtonText"),itemIndex:n.length})),n=t.formats.reduce(function(n,i){return n.push(c(e,t,{type:"exporting",text:b.default.getFormatter("vizExport-exportButtonText")(i),format:i,itemIndex:n.length})),n},n)}function h(e){var t=X.exec(e);return t?t[1]:void 0}function f(e,t,n,i){return(i||t.format)&&(i=a(i||t.format,e._incidentOccurred)),{format:i||G,fileName:n||t.fileName||"file",proxyUrl:t.proxyUrl,backgroundColor:t.backgroundColor,width:e._canvas.width,height:e._canvas.height,margin:t.margin,svgToCanvas:t.svgToCanvas,forceProxy:t.forceProxy,exportingAction:e._createActionByOption("onExporting"),exportedAction:e._createActionByOption("onExported"),fileSavingAction:e._createActionByOption("onFileSaving")}}Object.defineProperty(t,"__esModule",{value:!0}),t.plugin=t.ExportMenu=t.combineMarkups=t.exportWidgets=t.getMarkup=t.exportFromMarkup=void 0;var p=n(0),g=n(7),_=n(13),m=n(177),v=i(m),y=n(10),b=i(y),x=n(1),w=n(51),C=i(w),k=n(140),S=i(k),I=n(24),D=i(I),T=n(64),E=v.default.image,A=v.default.svg,O=v.default.pdf,P=[D.default.down,D.default.move].join(" "),R=35,B=[[9,12,26,12,26,14,9,14],[9,17,26,17,26,19,9,19],[9,22,26,22,26,24,9,24]],M=4,V=120,F=8,L=15,H=30,z=1,N=10,$=2,W=3,G="PNG",j=[G,"JPEG","GIF"],q=["PDF","SVG"],K="dx-export-menu",U="export-element-type",Y="export-element-format",X=/data-backgroundcolor="([^"]*)"/,Z=t.exportFromMarkup=function(e,t){t.format=a(t.format)||G,t.fileName=t.fileName||"file",t.exportingAction=t.onExporting,t.exportedAction=t.onExported,t.fileSavingAction=t.onFileSaving,t.margin=(0,x.isDefined)(t.margin)?t.margin:N,t.backgroundColor=(0,x.isDefined)(t.backgroundColor)?t.backgroundColor:h(e)||C.default.getTheme().backgroundColor,v.default.export(e,t,r(t.format))},Q=(t.getMarkup=function(e){return Q(e).markup},t.exportWidgets=function(e,n){n=n||{};var i=t.combineMarkups(e,{gridLayout:n.gridLayout,verticalAlignment:n.verticalAlignment,horizontalAlignment:n.horizontalAlignment});n.width=i.width,n.height=i.height,Z(i.markup,n)},t.combineMarkups=function(e){var t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};Array.isArray(e)?Array.isArray(e[0])||(e=e.map(function(e){return[e]})):e=[[e]];var n=!t.gridLayout,i=e.reduce(function(e,t,i){var o=t.reduce(function(e,t,n){var o=t.getSize(),a=t.option("backgroundColor")||C.default.getTheme(t.option("theme")).backgroundColor;return a&&e.backgroundColors.indexOf(a)===-1&&e.backgroundColors.push(a),e.hOffset=e.width,e.width+=o.width,e.height=Math.max(e.height,o.height),e.itemWidth=Math.max(e.itemWidth,o.width),e.items.push({markup:t.svg(),width:o.width,height:o.height,c:n,r:i,hOffset:e.hOffset}),e},{items:[],height:0,itemWidth:0,hOffset:0,width:0,backgroundColors:e.backgroundColors});return e.rowOffsets.push(e.totalHeight),e.rowHeights.push(o.height),e.totalHeight+=o.height,e.items=e.items.concat(o.items),e.itemWidth=Math.max(e.itemWidth,o.itemWidth),e.maxItemLen=Math.max(e.maxItemLen,o.items.length),e.totalWidth=n?Math.max(e.totalWidth,o.width):e.maxItemLen*e.itemWidth,e},{items:[],rowOffsets:[],rowHeights:[],itemWidth:0,totalHeight:0,maxItemLen:0,totalWidth:0,backgroundColors:[]}),o='data-backgroundcolor="'.concat(1===i.backgroundColors.length?i.backgroundColors[0]:"",'" '),a=function(e){var n=t.verticalAlignment,o=i.rowHeights[e.r]-e.height;return i.rowOffsets[e.r]+("bottom"===n?o:"center"===n?o/2:0)},r=function(e){if(n)return e.hOffset;var o=t.horizontalAlignment,a=i.itemWidth,r=a-e.width;return e.c*a+("right"===o?r:"center"===o?r/2:0)},s=i.totalHeight,l=i.totalWidth;return{markup:"<svg "+o+'height="'+s+'" width="'+l+'" version="1.1" xmlns="http://www.w3.org/2000/svg">'+i.items.map(function(e){return'<g transform="translate('.concat(r(e),",").concat(a(e),')">').concat(e.markup,"</g>")}).join("")+"</svg>",width:l,height:s}}),J=t.ExportMenu=function(e){var t=this._renderer=e.renderer;this._incidentOccurred=e.incidentOccurred,this._exportTo=e.exportTo,this._print=e.print,this._shadow=t.shadowFilter("-50%","-50%","200%","200%",$,6,W),this._shadow.attr({opacity:.8}),this._group=t.g().attr({"class":K,"hidden-for-export":!0}).linkOn(t.root,{name:"export-menu",after:"peripheral"}),this._buttonGroup=t.g().attr({"class":K+"-button"}).append(this._group),this._listGroup=t.g().attr({"class":K+"-list"}).append(this._group),this._overlay=t.rect(-V+R,R+M,V,0),this._overlay.attr({"stroke-width":z,cursor:"pointer",rx:4,ry:4,filter:this._shadow.id}),this._overlay.data({"export-element-type":"list"}),this.validFormats=o(),this._subscribeEvents()};(0,p.extend)(J.prototype,{getLayoutOptions:function(){if(this._hiddenDueToLayout)return{width:0,height:0,cutSide:"vertical",cutLayoutSide:"top"};var e=this._buttonGroup.getBBox();return e.cutSide="vertical",e.cutLayoutSide="top",e.height+=N,e.position={vertical:"top",horizontal:"right"},e.verticalAlignment="top",e.horizontalAlignment="right",e},shift:function(e,t){this._group.attr({translateY:this._group.attr("translateY")+t})},draw:function(e,t,n){this._group.move(e-R-$-W+n.left,Math.floor(t/2-R/2));var i=this.getLayoutOptions();return(i.width>e||i.height>t)&&this.freeSpace(),this},show:function(){this._group.linkAppend()},hide:function(){this._group.linkRemove()},setOptions:function(e){var t=this;this._options=e,e.formats?e.formats=e.formats.reduce(function(e,n){return n=a(n,t._incidentOccurred,t.validFormats),n&&e.push(n),e},[]):e.formats=this.validFormats.supported.slice(),e.printingEnabled=void 0===e.printingEnabled||e.printingEnabled,e.enabled&&(e.formats.length||e.printingEnabled)?(this.show(),this._updateButton(),this._updateList(),this._hideList()):this.hide()},dispose:function(){this._unsubscribeEvents(),this._group.linkRemove().linkOff(),this._group.dispose(),this._shadow.dispose()},layoutOptions:function(){return this._options.enabled&&{horizontalAlignment:"right",verticalAlignment:"top",weak:!0}},measure:function(){this._fillSpace();var e=this._options.button.margin;return[R+e.left+e.right,R+e.top+e.bottom]},move:function(e){var t=this._options.button.margin;this._group.attr({translateX:Math.round(e[0])+t.left,translateY:Math.round(e[1])+t.top})},_fillSpace:function(){this._hiddenDueToLayout=!1,this.show()},freeSpace:function(){this._incidentOccurred("W2107"),this._hiddenDueToLayout=!0,this.hide()},_hideList:function(){this._listGroup.remove(),this._listShown=!1,this._setButtonState("default"),this._menuItems.forEach(function(e){return e.resetState()})},_showList:function(){this._listGroup.append(this._group),this._listShown=!0,this._menuItems.forEach(function(e){return e.fixPosition()})},_setButtonState:function(e){var t=this._options.button[e];this._button.attr({stroke:t.borderColor,fill:t.backgroundColor}),this._icon.attr({fill:t.color})},_subscribeEvents:function(){var e=this;this._renderer.root.on(D.default.up+".export",function(t){var n=t.target[U];return n?void("button"===n?e._listShown?(e._setButtonState("default"),e._hideList()):(e._setButtonState("focus"),e._showList()):"printing"===n?(e._print(),e._hideList()):"exporting"===n&&(e._exportTo(t.target[Y]),e._hideList())):void(e._button&&e._hideList())}),this._listGroup.on(P,function(e){return e.stopPropagation()}),this._buttonGroup.on(D.default.enter,function(){return e._setButtonState("hover")}),this._buttonGroup.on(D.default.leave,function(){return e._setButtonState(e._listShown?"focus":"default")}),this._buttonGroup.on(D.default.down+".export",function(){return e._setButtonState("active")})},_unsubscribeEvents:function(){this._renderer.root.off(".export"),this._listGroup.off(),this._buttonGroup.off()},_updateButton:function(){var e=this._renderer,t=this._options,n={"export-element-type":"button"};this._button||(this._button=e.rect(0,0,R,R).append(this._buttonGroup),this._button.attr({rx:4,ry:4,fill:t.button.default.backgroundColor,stroke:t.button.default.borderColor,"stroke-width":1,cursor:"pointer"}),this._button.data(n),this._icon=e.path(B).append(this._buttonGroup),this._icon.attr({fill:t.button.default.color,cursor:"pointer"}),this._icon.data(n),this._buttonGroup.setTitle(b.default.format("vizExport-titleMenuText")))},_updateList:function(){var e=this._options,t=e.button.default,n=this._listGroup,i=d(this._renderer,e);this._shadow.attr({color:e.shadowColor}),this._overlay.attr({height:i.length*H+2*z,fill:t.backgroundColor,stroke:t.borderColor}),n.clear(),this._overlay.append(n),i.forEach(function(e){return e.g.append(n)}),this._menuItems=i}});t.plugin={name:"export",init:function(){var e=this;this._exportMenu=new t.ExportMenu({renderer:this._renderer,incidentOccurred:this._incidentOccurred,print:function(){return e.print()},exportTo:function(t){return e.exportTo(void 0,t)}}),this._layout.add(this._exportMenu)},dispose:function(){this._exportMenu.dispose()},members:{_getExportMenuOptions:function(){return(0,p.extend)({},this._getOption("export"),{rtl:this._getOption("rtlEnabled",!0)})},_disablePointerEvents:function(){var e=this._renderer.root.attr("pointer-events");return this._renderer.root.attr({"pointer-events":"none"}),e},exportTo:function(e,t){var n=this,i=this._exportMenu,o=f(this,this._getOption("export")||{},e,t);i&&i.hide();var a=this._disablePointerEvents(),s=v.default.export(this._renderer.root.element,o,r(o.format)).fail(T.logger.error).always(function(){n._renderer.root.attr({"pointer-events":a})});return i&&i.show(),s},print:function(){var e=this,t=this._exportMenu,n=f(this,this._getOption("export")||{});n.exportingAction=null,n.exportedAction=null,n.margin=0,n.format="PNG",n.forceProxy=!0,n.fileSavingAction=function(e){s("data:image/png;base64,".concat(e.data),{__test:n.__test}),e.cancel=!0};var i=this._disablePointerEvents();t&&t.hide();var o=v.default.export(this._renderer.root.element,n,r(n.format)).fail(T.logger.error).always(function(){e._renderer.root.attr({"pointer-events":i})});return t&&t.show(),o}},customize:function(e){var t=e.prototype;e.addChange({code:"EXPORT",handler:function(){this._exportMenu.setOptions(this._getExportMenuOptions()),this._change(["LAYOUT"])},isThemeDependent:!0,isOptionChange:!0,option:"export"}),t._optionChangesMap.onExporting="EXPORT",t._optionChangesMap.onExported="EXPORT",t._optionChangesMap.onFileSaving="EXPORT"},fontFields:["export.font"]}},function(e,t,n){function i(){return!0}function o(){return!1}function a(e,t){return!(e.width===t.width&&e.height===t.height&&e.left===t.left&&e.top===t.top&&e.right===t.right&&e.bottom===t.bottom)}function r(e){var t,n=function(){clearTimeout(t),t=setTimeout(e,100)};return n.dispose=function(){return clearTimeout(t),this},n}function s(e){e.component.hasEvent("incidentOccurred")||T.apply(null,[e.target.id].concat(e.target.args||[]))}function l(e){return e.reduce(function(e,t){return t>0&&!e?t:e},0)}function u(e){return g.isDefined(e)&&e>0}function c(e,t){function n(n){var i=e[n];o[i.name]=t(n)}function i(e,t,n){o[e](t),n&&n()}var o={};_(e,function(e,t){t.name&&n(e)});var a;return i.change=function(t){var n=e[t];return n&&((a=a||{})[t]=n),!!n},i.applyChanges=function(){a&&(_(a,function(e,t){n(t.newName||e)}),a=null)},i.dispose=function(){e=t=o=null},i}var d=n(2),h=n(4).noop,f=n(7),p=n(11),g=n(1),_=n(3).each,m=n(129),v=n(130),y=n(43).format,b=n(1).isObject,x=n(0).extend,w=n(278),C=Math.floor,k=n(162),S=n(148),I=n(13).parseScalar,D=n(805),T=D.log,E=n(149),A=n(807),O=n(16),P=n(5),R="rtlEnabled",B="dx-sized-element",M=k.prototype.option,V=function(e,t){return function(n,i){t("incidentOccurred",{target:{id:n,type:"E"===n[0]?"error":"warning",args:i,text:y.apply(null,[D.ERROR_MESSAGES[n]].concat(i||[])),widget:e,version:m}})}},F=function(){var e={_initTemplates:function(){},ctor:function(e,t){this.callBase(e,t);var n=p.createElement("div"),i=t&&g.isNumeric(t.width)?t.width+"px":"100%",o=t&&g.isNumeric(t.height)?t.height+"px":this._getDefaultSize().height+"px";p.setStyle(n,"width",i),p.setStyle(n,"height",o),p.setClass(n,B),p.insertElement(e,n)}},t=k.inherit(e),n=t.inherit;return t.inherit=function(e){for(var t in e)(g.isFunction(e[t])&&"_"!==t.substr(0,1)||"_dispose"===t||"_optionChanged"===t)&&(e[t]=h);return n.call(this,e)},t},L=!f.hasWindow();e.exports=L?F():k.inherit({_eventsMap:{onIncidentOccurred:{name:"incidentOccurred"},onDrawn:{name:"drawn"}},_getDefaultOptions:function(){return x(this.callBase(),{onIncidentOccurred:s})},_extractAnonymousTemplate:function(){},_useLinks:!0,_init:function(){var e=this;e._$element.children("."+B).remove(),e.callBase.apply(e,arguments),e._changesLocker=0,e._optionChangedLocker=0,e._changes=S.changes(),e._suspendChanges(),e._themeManager=e._createThemeManager(),e._themeManager.setCallback(function(){e._requestChange(e._themeDependentChanges)}),e._renderElementAttributes(),e._initRenderer();var t=e._useLinks&&e._renderer.root;t&&t.enableLinks().virtualLink("core").virtualLink("peripheral"),e._renderVisibilityChange(),e._attachVisibilityChangeHandlers(),e._toggleParentsScrollSubscription(this._isVisible()),e._initEventTrigger(),e._incidentOccurred=V(e.NAME,e._eventTrigger),e._layout=new A,t&&t.linkAfter("core"),e._initPlugins(),e._initCore(),t&&t.linkAfter(),e._change(e._initialChanges)},_createThemeManager:function(){return new w.BaseThemeManager(this._getThemeManagerOptions())},_getThemeManagerOptions:function(){return{themeSection:this._themeSection,fontFields:this._fontFields}},_initialChanges:["LAYOUT","RESIZE_HANDLER","THEME","DISABLED"],_initPlugins:function(){var e=this;_(e._plugins,function(t,n){n.init.call(e)})},_disposePlugins:function(){var e=this;_(e._plugins.slice().reverse(),function(t,n){n.dispose.call(e)})},_change:function(e){this._changes.add(e)},_suspendChanges:function(){++this._changesLocker},_resumeChanges:function(){var e=this;0===--e._changesLocker&&e._changes.count()>0&&!e._applyingChanges&&(e._renderer.lock(),e._applyingChanges=!0,e._applyChanges(),e._changes.reset(),e._applyingChanges=!1,e._renderer.unlock(),e._optionsQueue&&e._applyQueuedOptions(),e._optionChangedLocker++,e._notify(),e._optionChangedLocker--)},_applyQueuedOptions:function(){var e=this,t=e._optionsQueue;e._optionsQueue=null,e.beginUpdate(),_(t,function(e,t){t()}),e.endUpdate()},_requestChange:function(e){this._suspendChanges(),this._change(e),this._resumeChanges()},_applyChanges:function(){var e,t=this,n=t._changes,i=t._totalChangesOrder,o=i.length;for(e=0;e<o;++e)n.has(i[e])&&t["_change_"+i[e]]()},_optionChangesOrder:["EVENTS","THEME","RENDERER","RESIZE_HANDLER"],_layoutChangesOrder:["ELEMENT_ATTR","CONTAINER_SIZE","LAYOUT"],_customChangesOrder:["DISABLED"],_change_EVENTS:function(){this._eventTrigger.applyChanges()},_change_THEME:function(){this._setThemeAndRtl()},_change_RENDERER:function(){this._setRendererOptions()},_change_RESIZE_HANDLER:function(){this._setupResizeHandler()},_change_ELEMENT_ATTR:function(){this._renderElementAttributes(),this._change(["CONTAINER_SIZE"])},_change_CONTAINER_SIZE:function(){this._updateSize()},_change_LAYOUT:function(){this._setContentSize()},_change_DISABLED:function(){var e=this._renderer,t=e.root;this.option("disabled")?(this._initDisabledState=t.attr("pointer-events"),t.attr({"pointer-events":"none",filter:e.getGrayScaleFilter().id})):"none"===t.attr("pointer-events")&&t.attr({"pointer-events":g.isDefined(this._initDisabledState)?this._initDisabledState:null,filter:null})},_themeDependentChanges:["RENDERER"],_initRenderer:function(){var e=this;e._canvas=e._calculateCanvas(),e._renderer=new E.Renderer({cssClass:e._rootClassPrefix+" "+e._rootClass,pathModified:e.option("pathModified"),container:e._$element[0]}),e._renderer.resize(e._canvas.width,e._canvas.height)},_disposeRenderer:function(){this._renderer.dispose()},_getAnimationOptions:h,render:function(){this._requestChange(["CONTAINER_SIZE"]);var e=this._isVisible();this._toggleParentsScrollSubscription(e),!e&&this._stopCurrentHandling()},_toggleParentsScrollSubscription:function(e){var t=d(this._renderer.root.element).parents(),n="scroll.viz_widgets";"generic"===O.real().platform&&(t=t.add(f.getWindow())),this._proxiedTargetParentsScrollHandler=this._proxiedTargetParentsScrollHandler||function(){this._stopCurrentHandling()}.bind(this),P.off(d().add(this._$prevRootParents),n,this._proxiedTargetParentsScrollHandler),e&&(P.on(t,n,this._proxiedTargetParentsScrollHandler),this._$prevRootParents=t)},_stopCurrentHandling:h,_dispose:function(){var e=this;e.callBase.apply(e,arguments),e._toggleParentsScrollSubscription(!1),e._removeResizeHandler(),e._layout.dispose(),e._eventTrigger.dispose(),e._disposeCore(),e._disposePlugins(),e._disposeRenderer(),e._themeManager.dispose(),e._themeManager=e._renderer=e._eventTrigger=null},_initEventTrigger:function(){var e=this;e._eventTrigger=c(e._eventsMap,function(t){return e._createActionByOption(t)})},_calculateCanvas:function(){var e=this,t=e.option("size")||{},n=e.option("margin")||{},i=e._getDefaultSize()||{},o=function(t,n){if(u(t[n])||!f.hasWindow())return 0;var i=e._$element[n]();return i<=1?0:i},a=o(t,"width"),r=o(t,"height"),s={width:t.width<=0?0:C(l([t.width,a,i.width])),height:t.height<=0?0:C(l([t.height,r,i.height])),left:l([n.left,i.left]),top:l([n.top,i.top]),right:l([n.right,i.right]),bottom:l([n.bottom,i.bottom])};return(s.width-s.left-s.right<=0||s.height-s.top-s.bottom<=0)&&(s={width:0,height:0}),s},_updateSize:function(){var e=this,t=e._calculateCanvas();e._renderer.fixPlacement(),(a(e._canvas,t)||e.__forceRender)&&(e._canvas=t,e._recreateSizeDependentObjects(!0),e._renderer.resize(t.width,t.height),e._change(["LAYOUT"]))},_recreateSizeDependentObjects:h,_getMinSize:function(){return[0,0]},_getAlignmentRect:h,_setContentSize:function(){var e=this._canvas,t=this._layout,n=e.width>0&&e.height>0?[e.left,e.top,e.width-e.right,e.height-e.bottom]:[0,0,0,0];n=t.forward(n,this._getMinSize());var i=this._applySize(n)||n;t.backward(i,this._getAlignmentRect()||i)},_getOption:function(e,t){var n=this._themeManager.theme(e),i=this.option(e);return t?void 0!==i?i:n:x(!0,{},n,i)},_setupResizeHandler:function(){var e=this,t=I(this._getOption("redrawOnResize",!0),!0);e._resizeHandler&&e._removeResizeHandler(),e._resizeHandler=r(function(){t?e._requestChange(["CONTAINER_SIZE"]):e._renderer.fixPlacement()}),v.add(e._resizeHandler)},_removeResizeHandler:function(){this._resizeHandler&&(v.remove(this._resizeHandler),this._resizeHandler.dispose(),this._resizeHandler=null)},_onBeginUpdate:h,beginUpdate:function(){var e=this;return e._initialized&&0===e._updateLockCount&&(e._onBeginUpdate(),e._suspendChanges()),e.callBase.apply(e,arguments),e},endUpdate:function(){var e=this;return e.callBase.apply(e,arguments),0===e._updateLockCount&&e._resumeChanges(),e},option:function(e){var t=this;return t._initialized&&t._applyingChanges&&(arguments.length>1||b(e))?(t._optionsQueue=t._optionsQueue||[],void t._optionsQueue.push(t._getActionForUpdating(arguments))):M.apply(t,arguments)},_getActionForUpdating:function(e){var t=this;return function(){M.apply(t,e)}},_clean:h,_render:h,_optionChanged:function(e){var t=this;if(!t._optionChangedLocker){var n=t.getPartialChangeOptionsName(e),i=[];n.length>0?n.forEach(function(e){return i.push(t._partialOptionChangesMap[e])}):i.push(t._optionChangesMap[e.name]),i=i.filter(function(e){return!!e}),t._eventTrigger.change(e.name)?t._change(["EVENTS"]):i.length>0?t._change(i):t.callBase.apply(t,arguments)}},_notify:h,_optionChangesMap:{size:"CONTAINER_SIZE",margin:"CONTAINER_SIZE",redrawOnResize:"RESIZE_HANDLER",theme:"THEME",rtlEnabled:"THEME",encodeHtml:"THEME",elementAttr:"ELEMENT_ATTR",disabled:"DISABLED"},_partialOptionChangesMap:{},_partialOptionChangesPath:{},getPartialChangeOptionsName:function(e){var t=this,n=e.fullName,i=n.split(/[.]/),o=e.name,a=e.value,r=this._partialOptionChangesPath[o],s=[];return r&&(r===!0?s.push(o):(r.forEach(function(e){n.indexOf(e)>=0&&s.push(e)}),1===i.length&&("object"===g.type(a)?t._addOptionsNameForPartialUpdate(a,r,s):"array"===g.type(a)&&a.length>0&&a.every(function(e){return t._checkOptionsForPartialUpdate(e,r)})&&a.forEach(function(e){return t._addOptionsNameForPartialUpdate(e,r,s)})))),s.filter(function(e,t,n){return n.indexOf(e)===t})},_checkOptionsForPartialUpdate:function(e,t){return!Object.keys(e).some(function(e){return t.indexOf(e)===-1})},_addOptionsNameForPartialUpdate:function(e,t,n){var i=Object.keys(e);this._checkOptionsForPartialUpdate(e,t)&&i.forEach(function(e){return t.indexOf(e)>-1&&n.push(e)})},_visibilityChanged:function(){this.render()},_setThemeAndRtl:function(){this._themeManager.setTheme(this.option("theme"),this.option(R))},_getRendererOptions:function(){return{rtl:this.option(R),encodeHtml:this.option("encodeHtml"),animation:this._getAnimationOptions()}},_setRendererOptions:function(){this._renderer.setOptions(this._getRendererOptions())},svg:function(){return this._renderer.svg()},getSize:function(){var e=this._canvas||{};return{width:e.width,height:e.height}},isReady:o,_dataIsReady:i,_resetIsReady:function(){this.isReady=o},_drawn:function(){var e=this;e.isReady=o,e._dataIsReady()&&e._renderer.onEndAnimation(function(){e.isReady=i}),e._eventTrigger("drawn",{})}}),S.replaceInherit(e.exports)},function(e,t,n){function i(e){"@babel/helpers - typeof";return(i="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}function o(e){return e&&e.__esModule?e:{"default":e}}function a(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}function r(e,t){for(var n=0;n<t.length;n++){var i=t[n];i.enumerable=i.enumerable||!1,i.configurable=!0,"value"in i&&(i.writable=!0),Object.defineProperty(e,i.key,i)}}function s(e,t,n){return t&&r(e.prototype,t),n&&r(e,n),e}function l(e,t){if("function"!=typeof t&&null!==t)throw new TypeError("Super expression must either be null or a function");e.prototype=Object.create(t&&t.prototype,{constructor:{value:e,writable:!0,configurable:!0}}),t&&u(e,t)}function u(e,t){return(u=Object.setPrototypeOf||function(e,t){return e.__proto__=t,e})(e,t)}function c(e){var t=f();return function(){var n,i=p(e);if(t){var o=p(this).constructor;n=Reflect.construct(i,arguments,o)}else n=i.apply(this,arguments);return d(this,n)}}function d(e,t){return!t||"object"!==i(t)&&"function"!=typeof t?h(e):t}function h(e){if(void 0===e)throw new ReferenceError("this hasn't been initialised - super() hasn't been called");return e}function f(){if("undefined"==typeof Reflect||!Reflect.construct)return!1;if(Reflect.construct.sham)return!1;if("function"==typeof Proxy)return!0;try{return Date.prototype.toString.call(Reflect.construct(Date,[],function(){})),!0}catch(e){return!1}}function p(e){return(p=Object.setPrototypeOf?Object.getPrototypeOf:function(e){return e.__proto__||Object.getPrototypeOf(e)})(e)}Object.defineProperty(t,"__esModule",{value:!0}),t.EmptyTemplate=void 0;var g=n(2),_=o(g),m=n(70);t.EmptyTemplate=function(e){function t(){return a(this,t),n.apply(this,arguments)}l(t,e);var n=c(t);return s(t,[{key:"_renderCore",value:function(){return(0,_.default)()}}]),t}(m.TemplateBase)},function(e,t,n){var i=n(8),o=n(116),a=n(91),r=Math.abs,s="dxhold",l=750,u=5,c=o.inherit({start:function(e){this._startEventData=i.eventData(e),this._startTimer(e)},_startTimer:function(e){var t="timeout"in this?this.timeout:l;this._holdTimer=setTimeout(function(){this._requestAccept(e),this._fireEvent(s,e,{target:e.target}),this._forgetAccept()}.bind(this),t)},move:function(e){this._touchWasMoved(e)&&this._cancel(e)},_touchWasMoved:function(e){var t=i.eventDelta(this._startEventData,i.eventData(e));return r(t.x)>u||r(t.y)>u},end:function(){this._stopTimer()},_stopTimer:function(){clearTimeout(this._holdTimer)},cancel:function(){this._stopTimer()},dispose:function(){this._stopTimer()}});a({emitter:c,bubble:!0,events:[s]}),e.exports={name:s}},function(e,t,n){function i(e){"@babel/helpers - typeof";return(i="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}function o(e,t,n){
var i=[],o=function(){return e.getHours()+e.getMinutes()+e.getSeconds()+e.getMilliseconds()<1},a=function(e){return D(e,2)};return i.push(e.getFullYear()),i.push("-"),i.push(a(e.getMonth()+1)),i.push("-"),i.push(a(e.getDate())),t&&o()||(i.push("T"),i.push(a(e.getHours())),i.push(":"),i.push(a(e.getMinutes())),i.push(":"),i.push(a(e.getSeconds())),e.getMilliseconds()&&(i.push("."),i.push(D(e.getMilliseconds(),3))),n||i.push("Z")),i.join("")}function a(e){var t=new Date(60*new Date(0).getTimezoneOffset()*1e3),n=e.replace("Z","").split("T"),i=/(\d{4})-(\d{2})-(\d{2})/.exec(n[0]),o=/(\d{2}):(\d{2}):(\d{2})\.?(\d{0,7})?/.exec(n[1]);if(t.setFullYear(Number(i[1])),t.setMonth(Number(i[2])-1),t.setDate(Number(i[3])),Array.isArray(o)&&o.length){t.setHours(Number(o[1])),t.setMinutes(Number(o[2])),t.setSeconds(Number(o[3]));var a=(o[4]||"").slice(0,3);a=D(a,3,!0),t.setMilliseconds(Number(a))}return t}function r(e){return/^(?:[a-z]+:)?\/\//i.test(e)}function s(e,t){function n(e){var t=e.indexOf("?");return t>-1?e.substr(0,t):e}var i,o=n(e).split("/"),a=t.split("/");for(o.pop();a.length;)i=a.shift(),".."===i?o.pop():o.push(i);return o.join("/")}var l=n(15),u=n(0).extend,c=n(1),d=n(3),h=n(3).each,f=n(63),p=n(35),g=c.isDefined,_=c.isPlainObject,m=n(4).grep,v=n(6).Deferred,y=n(38).errors,b=n(42),x=/^(\{{0,1}([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}\}{0,1})$/,w=/^\/Date\((-?\d+)((\+|-)?(\d+)?)\)\/$/,C=/^\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}(\.\d+)?(Z|[-+]{1}\d{2}(:?)(\d{2})?)?$/,k="application/json;odata=verbose",S=function(e){return"string"===c.type(e)?e.split():e},I=function(e){return/\./.test(e)},D=function(e,t,n){for(e=String(e);e.length<t;)e=n?e+"0":"0"+e;return e},T=function(e){var t=[];for(var n in e)t.push(n+"="+e[n]);return t.join("&")},E=function(e,t,n){function i(t){return JSON.stringify(t,function(t,n){if(!(this[t]instanceof Date))return n;switch(n=o(this[t]),e){case 2:return n.substr(0,n.length-1);case 3:case 4:return n;default:throw y.Error("E4002")}})}t=u({async:!0,method:"get",url:"",params:{},payload:null,headers:{},timeout:3e4},t),n=n||{};var a=n.beforeSend;a&&a(t);var r=(t.method||"get").toLowerCase(),s="get"===r,l=s&&n.jsonp,c=u({},t.params),d=s?c:i(t.payload),h=!s&&T(c),f=t.url,p=!s&&k;return h&&(f+=(f.indexOf("?")>-1?"&":"?")+h),l&&(d.$format="json"),{url:f,data:d,dataType:l?"jsonp":"json",jsonp:l&&"$callback",method:r,async:t.async,timeout:t.timeout,headers:t.headers,contentType:p,accepts:{json:[k,"text/plain"].join()},xhrFields:{withCredentials:n.withCredentials}}},A=function e(t,n,i){var o=new v,a=E(t,n,i);return f.sendRequest(a).always(function(n,l){var u,c={deserializeDates:i.deserializeDates,fieldTypes:i.fieldTypes},d=R(n,l,c,a),h=d.error,f=d.data,p=d.nextUrl;h?h.message!==b.XHR_ERROR_UNLOAD&&o.reject(h):i.countOnly?isFinite(d.count)?o.resolve(d.count):o.reject(new y.Error("E4018")):p&&!i.isPaged?(r(p)||(p=s(a.url,p)),e(t,{url:p},i).fail(o.reject).done(function(e){o.resolve(f.concat(e))})):(isFinite(d.count)&&(u={totalCount:d.count}),o.resolve(f,u))}),o.promise()},O=function(e){var t,n=e;"message"in e&&(t=e.message.value?e.message.value:e.message);for(;(n=n.innererror||n.internalexception)&&(t=n.message,!n.internalexception||t.indexOf("inner exception")!==-1););return t},P=function(e,t,n){if("nocontent"===t)return null;var i="Unknown error",o=e,a=200,r={requestOptions:n};if("success"!==t){a=e.status,i=b.errorMessageFromXhr(e,t);try{o=JSON.parse(e.responseText)}catch(e){}}var s=o&&(o.then&&o||o.error||o["odata.error"]||o["@odata.error"]);if(s){i=O(s)||i,r.errorDetails=s,200===a&&(a=500);var l=Number(s.code);isFinite(l)&&l>=400&&(a=l)}return a>=400||0===a?(r.httpStatus=a,u(Error(i),r)):null},R=function(e,t,n,i){var o,a=P(e,t,i);return a?{error:a}:_(e)?(o="d"in e&&(Array.isArray(e.d)||c.isObject(e.d))?B(e,t):M(e,t),F(o,n),o):{data:e}},B=function(e){var t=e.d;return g(t)?(g(t.results)&&(t=t.results),{data:t,nextUrl:e.d.__next,count:parseInt(e.d.__count,10)}):{error:Error("Malformed or unsupported JSON response received")}},M=function(e){var t=e;return g(t.value)&&(t=t.value),{data:t,nextUrl:e["@odata.nextLink"],count:parseInt(e["@odata.count"],10)}},V=l.inherit({ctor:function(e){this._value=e},valueOf:function(){return this._value}}),F=function e(t,n){n=n||{},h(t,function(o,r){if(null!==r&&"object"===i(r))"results"in r&&(t[o]=r.results),e(t[o],n);else if("string"==typeof r){var s=n.fieldTypes,l=!s||"String"!==s[o];if(l&&x.test(r)&&(t[o]=new p(r)),n.deserializeDates!==!1)if(r.match(w)){var u=new Date(Number(RegExp.$1)+60*RegExp.$2*1e3);t[o]=new Date(u.valueOf()+60*u.getTimezoneOffset()*1e3)}else C.test(r)&&(t[o]=new Date(a(t[o]).valueOf()))}})},L=function(e){return"datetime'"+o(e,!0,!0)+"'"},H=function(e){return"'"+e.replace(/'/g,"''")+"'"},z=function(e){return e instanceof V?e.valueOf():e.replace(/\./g,"/")},N=function e(t){return t instanceof Date?o(t,!1,!1):t instanceof p?t.valueOf():Array.isArray(t)?"["+t.map(function(t){return e(t)}).join(",")+"]":$(t)},$=function(e){return e instanceof Date?L(e):e instanceof p?"guid'"+e+"'":e instanceof V?e.valueOf():"string"==typeof e?H(e):String(e)},W=function(e,t){switch(t){case 2:case 3:return $(e);case 4:return N(e);default:throw y.Error("E4002")}},G=function(e,t){if(_(e)){var n=[];return h(e,function(e,i){n.push(z(e)+"="+W(i,t))}),n.join()}return W(e,t)},j={String:function(e){return e+""},Int32:function(e){return Math.floor(e)},Int64:function(e){return e instanceof V?e:new V(e+"L")},Guid:function(e){return e instanceof p?e:new p(e)},Boolean:function(e){return!!e},Single:function(e){return e instanceof V?e:new V(e+"f")},Decimal:function(e){return e instanceof V?e:new V(e+"m")}},q=function(e,t){if(null===t)return null;var n=j[e];if(!n)throw y.Error("E4014",e);return n(t)},K=function(e,t){if(t)return e<4?z(t.join()):m(t,I,!0).join()},U=function(e,t,n){var i=function(){var e={};return t&&d.each(S(t),function(){e[z(this)]=1}),n&&d.each(S(n),function(){var t=this.split(".");t.length<2||(t.pop(),e[z(t.join("."))]=1)}),d.map(e,function(e,t){return t}).join()},o=function(){var e=function(e){var t=function e(t){var n="",i=[],o=[];return d.each(t,function(t,n){Array.isArray(n)&&[].push.apply(i,n),_(n)&&o.push(t+e(n))}),(i.length||o.length)&&(n+="(",i.length&&(n+="$select="+d.map(i,z).join()),o.length&&(i.length&&(n+=";"),n+="$expand="+d.map(o,z).join()),n+=")"),n},n=[];return d.each(e,function(e,i){n.push(e+t(i))}),n.join()},i=function(e,t,n){var i=function e(t,n,i){var o=i(n,t.shift(),t);o!==!1&&e(t,o,i)};d.each(e,function(e,o){i(o.split("."),t,n)})},o={};if(t||n)return t&&i(S(t),o,function(e,t,n){return e[t]=e[t]||{},!!n.length&&e[t]}),n&&i(m(S(n),I),o,function(e,t,n){return n.length?e[t]=e[t]||{}:(e[t]=e[t]||[],e[t].push(t),!1)}),e(o)};return e<4?i():o()};t.sendRequest=A,t.serializePropName=z,t.serializeValue=W,t.serializeKey=G,t.keyConverters=j,t.convertPrimitiveValue=q,t.generateExpand=U,t.generateSelect=K,t.EdmLiteral=V},function(e,t,n){var i=n(531),o=n(9);o("dxList",i),e.exports=i},function(e,t,n){var i=n(0).extend;t.registry={},t.register=function(e,n,o){var a=t.registry,r={};r[e]=a[e]?a[e]:{},r[e][n]=o,a=i(a,r)}},function(e,t,n){var i=n(2),o=n(5),a=n(16),r=n(0).extend,s=n(75),l=n(50),u=n(9),c=n(8),d=n(19),h="dx-checkbox",f="dx-checkbox-icon",p="dx-checkbox-checked",g="dx-checkbox-container",_="dx-checkbox-text",m="dx-checkbox-has-text",v="dx-checkbox-indeterminate",y=100,b=l.inherit({_supportedKeys:function(){var e=function(e){e.preventDefault(),this._clickAction({event:e})};return r(this.callBase(),{space:e})},_getDefaultOptions:function(){return r(this.callBase(),{hoverStateEnabled:!0,activeStateEnabled:!0,value:!1,text:"",useInkRipple:!1})},_defaultOptionsRules:function(){return this.callBase().concat([{device:function(){return"desktop"===a.real().deviceType&&!a.isSimulator()},options:{focusStateEnabled:!0}}])},_canValueBeChangedByClick:function(){return!0},_feedbackHideTimeout:y,_initMarkup:function(){this._renderSubmitElement(),this._$container=i("<div>").addClass(g),this.setAria("role","checkbox"),this.$element().addClass(h),this._renderValue(),this._renderIcon(),this._renderText(),this.option("useInkRipple")&&this._renderInkRipple(),this.$element().append(this._$container),this.callBase()},_render:function(){this._renderClick(),this.callBase()},_renderSubmitElement:function(){this._$submitElement=i("<input>").attr("type","hidden").appendTo(this.$element())},_getSubmitElement:function(){return this._$submitElement},_renderInkRipple:function(){this._inkRipple=s.render({waveSizeCoefficient:2.5,useHoldAnimation:!1,wavesNumber:2,isCentered:!0})},_renderInkWave:function(e,t,n,i){if(this._inkRipple){var o={element:e,event:t,wave:i};n?this._inkRipple.showWave(o):this._inkRipple.hideWave(o)}},_updateFocusState:function(e,t){this.callBase.apply(this,arguments),this._renderInkWave(this._$icon,e,t,0)},_toggleActiveState:function(e,t,n){this.callBase.apply(this,arguments),this._renderInkWave(this._$icon,n,t,1)},_renderIcon:function(){this._$icon=i("<span>").addClass(f).prependTo(this._$container)},_renderText:function(){var e=this.option("text");return e?(this._$text||(this._$text=i("<span>").addClass(_)),this._$text.text(e),this._$container.append(this._$text),void this.$element().addClass(m)):void(this._$text&&(this._$text.remove(),this.$element().removeClass(m)))},_renderClick:function(){var e=this,t=c.addNamespace(d.name,e.NAME);e._clickAction=e._createAction(e._clickHandler),o.off(e.$element(),t),o.on(e.$element(),t,function(t){e._clickAction({event:t})})},_clickHandler:function(e){var t=e.component;t._saveValueChangeEvent(e.event),t.option("value",!t.option("value"))},_renderValue:function(){var e=this.$element(),t=this.option("value"),n=void 0===t;e.toggleClass(p,Boolean(t)),e.toggleClass(v,n),this._getSubmitElement().val(t),this.setAria("checked",n?"mixed":t||"false")},_optionChanged:function(e){switch(e.name){case"useInkRipple":this._invalidate();break;case"value":this._renderValue(),this.callBase(e);break;case"text":this._renderText(),this._renderDimensions();break;default:this.callBase(e)}},_clean:function(){delete this._inkRipple,this.callBase()}});u("dxCheckBox",b),e.exports=b},function(e,t,n){function i(e){return e&&e.__esModule?e:{"default":e}}function o(t,n,i,o,r,s){var u=l(n,i.originalEvent,s);if(!u){var c=g.default.normalizeKeyName(i);"enter"===c||"space"===c?(a(i.target,n),o&&o({event:i})):"tab"===c?r.addClass(y):e.exports.selectView(t,n,i)}}function a(e,t){var n=(0,d.default)(e),i=n.attr("aria-label"),o=r(i,t.element()),a=o.index(n);E=(0,_.extend)({},{ariaLabel:i,index:a},{viewInstance:t})}function r(e,t){var n,i=(0,d.default)(t);return n=e?i.find('[aria-label="'.concat(e,'"][tabindex]')):i.find("[tabindex]")}function s(e){for(var t in e){var n=e[t],i=(0,d.default)(n).first();if(i.length)return i}}function l(e,t,n){var i={event:t,handled:!1};return n?n(i):e._createActionByOption("onKeyDown")(i),i.handled}function u(){T="visible"===v.default.getDocument().visibilityState}var c=n(2),d=i(c),h=n(5),f=i(h),p=n(8),g=i(p),_=n(0),m=n(11),v=i(m),y="dx-state-focused",b="dx-cell-focus-disabled",x=".dx-row-focused",w=".dx-datagrid-rowsview .dx-row",C="".concat(w," > td"),k=".dx-treelist-rowsview .dx-row",S="".concat(k," > td"),I={groupPanel:[".dx-datagrid-group-panel .dx-group-panel-item[tabindex]"],columnHeaders:[".dx-datagrid-headers .dx-header-row > td.dx-datagrid-action",".dx-treelist-headers .dx-header-row > td.dx-treelist-action"],filterRow:[".dx-datagrid-headers .dx-datagrid-filter-row .dx-editor-cell .dx-texteditor-input",".dx-treelist-headers .dx-treelist-filter-row .dx-editor-cell .dx-texteditor-input"],rowsView:["".concat(x),"".concat(w,"[tabindex]"),"".concat(C,"[tabindex]"),"".concat(C),"".concat(k,"[tabindex]"),"".concat(S,"[tabindex]"),"".concat(S)],footer:[".dx-datagrid-total-footer .dx-datagrid-summary-item",".dx-treelist-total-footer .dx-treelist-summary-item"],filterPanel:[".dx-datagrid-filter-panel .dx-icon-filter",".dx-treelist-filter-panel .dx-icon-filter"],pager:[".dx-datagrid-pager [tabindex]",".dx-treelist-pager [tabindex]"]},D=!1,T=!1,E=null;e.exports={subscribeVisibilityChange:function(){f.default.on(v.default.getDocument(),"visibilitychange",u)},unsubscribeVisibilityChange:function(){f.default.off(v.default.getDocument(),"visibilitychange",u)},hiddenFocus:function(e){T=!0,e.focus(),T=!1},registerKeyboardAction:function(e,t,n,i,a,r){if(!t.option("useLegacyKeyboardNavigation")){var s=(0,d.default)(t.element());f.default.on(n,"keydown",i,function(n){return o(e,t,n,a,s,r)}),f.default.on(n,"mousedown",i,function(){D=!0,s.removeClass(y)}),f.default.on(n,"focusin",i,function(){var e=!D&&!T;e&&s.addClass(y),D=!1})}},restoreFocus:function(e){if(!e.option("useLegacyKeyboardNavigation")&&E){var t=E.viewInstance;if(t){var n=r(E.ariaLabel,t.element()),i=n.eq(E.index);E=null,f.default.trigger(i,"focus")}}},selectView:function(e,t,n){var i=g.default.normalizeKeyName(n);if(n.ctrlKey&&("upArrow"===i||"downArrow"===i))for(var o=Object.keys(I),a=o.indexOf(e);a>=0&&a<o.length;){a="upArrow"===i?--a:++a;var r=o[a],l=I[r],u=s(l);if(u&&u.length){u.attr("tabindex",t.option("tabindex")||0),f.default.trigger(u,"focus"),u.removeClass(b);break}}},setTabIndex:function(e,t){e.option("useLegacyKeyboardnavigation")||t.attr("tabindex",e.option("tabindex")||0)}}},function(e,t,n){function i(e){return!!(e&&String(e).length>0)}function o(e,t,n,i,o){e.attr({text:t}).setMaxSize(n,o,i).textChanged&&e.setTitle(t)}function a(e){return e>=0?c(e):_}function r(e){var t;return e>=0?t={left:c(e),top:c(e),right:c(e),bottom:c(e)}:(e=e||{},t={left:a(e.left),top:a(e.top),right:a(e.right),bottom:a(e.bottom)}),t}function s(e,t){return e[2]-e[0]<t.width||e[3]-e[1]<t.height}function l(e){this._params=e,this._group=e.renderer.g().attr({"class":e.cssClass}).linkOn(e.root||e.renderer.root,"title"),this._hasText=!1}function u(e){var t=d(e)?{text:e}:e||{};return t.subtitle=d(t.subtitle)?{text:t.subtitle}:t.subtitle||{},t}var c=Number,d=n(1).isString,h=n(0).extend,f=n(13).patchFontOptions,p=n(13).enumParser(["left","center","right"]),g=n(13).enumParser(["top","bottom"]),_=10;h(l.prototype,n(279).LayoutElement.prototype,{dispose:function(){var e=this;e._group.linkRemove(),e._group.linkOff(),e._titleElement&&(e._clipRect.dispose(),e._titleElement=e._subtitleElement=e._clipRect=null),e._params=e._group=e._options=null},_updateOptions:function(e){this._options=e,this._options.horizontalAlignment=p(e.horizontalAlignment,"center"),this._options.verticalAlignment=g(e.verticalAlignment,"top"),this._options.margin=r(e.margin)},_updateStructure:function(){var e=this,t=e._params.renderer,n=e._group,o=e._options,a=o.horizontalAlignment;e._titleElement||(e._titleElement=t.text().append(n),e._subtitleElement=t.text(),e._clipRect=t.clipRect(),n.attr({"clip-path":e._clipRect.id})),e._titleElement.attr({align:a,"class":o.cssClass}),e._subtitleElement.attr({align:a,"class":o.subtitle.cssClass}),n.linkAppend(),i(o.subtitle.text)?e._subtitleElement.append(n):e._subtitleElement.remove()},_updateTexts:function(){var e,t=this,n=t._options,o=n.subtitle,a=t._titleElement,r=t._subtitleElement,s="A";a.attr({text:s,y:0}).css(f(n.font)),e=a.getBBox(),t._baseLineCorrection=e.height+e.y,a.attr({text:n.text}),e=a.getBBox();var l=-e.y;a.attr({y:l}),i(o.text)&&r.attr({text:o.text,y:0}).css(f(o.font))},_shiftSubtitle:function(){var e=this,t=e._titleElement.getBBox(),n=e._subtitleElement,i=e._options.subtitle.offset;n.move(0,t.y+t.height-n.getBBox().y-i)},_updateBoundingRectAlignment:function(){var e=this._boundingRect,t=this._options;e.verticalAlignment=t.verticalAlignment,e.horizontalAlignment=t.horizontalAlignment,e.cutLayoutSide=t.verticalAlignment,e.cutSide="vertical",e.position={horizontal:t.horizontalAlignment,vertical:t.verticalAlignment}},hasText:function(){return this._hasText},update:function(e,t){var n=this,o=h(!0,{},e,u(t)),a=i(o.text),r=a||a!==n._hasText;return n._baseLineCorrection=0,n._updateOptions(o),n._boundingRect={},a?(n._updateStructure(),n._updateTexts()):n._group.linkRemove(),n._updateBoundingRect(),n._updateBoundingRectAlignment(),n._hasText=a,r},draw:function(e,t){var n=this;return n._hasText&&(n._group.linkAppend(),n._correctTitleLength(e),n._group.getBBox().height>t&&this.freeSpace()),n},_correctTitleLength:function(e){var t=this,n=t._options,i=n.margin,a=e-i.left-i.right,r=n.placeholderSize;o(t._titleElement,n.text,a,n,r),t._subtitleElement&&(c(r)>0&&(r-=t._titleElement.getBBox().height),o(t._subtitleElement,n.subtitle.text,a,n.subtitle,r),t._shiftSubtitle()),t._updateBoundingRect();var s=this.getCorrectedLayoutOptions(),l=s.x,u=s.y,d=s.height;this._clipRect.attr({x:l,y:u,width:e,height:d})},getLayoutOptions:function(){return this._boundingRect||null},shift:function(e,t){var n=this,i=n.getLayoutOptions();return n._group.move(e-i.x,t-i.y),n},_updateBoundingRect:function(){var e=this,t=e._options,n=t.margin,i=e._boundingRect,o=e._hasText?e._group.getBBox():{width:0,height:0,x:0,y:0,isEmpty:!0};o.isEmpty||(o.height+=n.top+n.bottom-e._baseLineCorrection,o.width+=n.left+n.right,o.x-=n.left,o.y+=e._baseLineCorrection-n.top),t.placeholderSize>0&&(o.height=t.placeholderSize),i.height=o.height,i.width=o.width,i.x=o.x,i.y=o.y},getCorrectedLayoutOptions:function(){var e=this.getLayoutOptions(),t=this._baseLineCorrection;return h({},e,{y:e.y-t,height:e.height+t})},layoutOptions:function(){return this._hasText?{horizontalAlignment:this._boundingRect.horizontalAlignment,verticalAlignment:this._boundingRect.verticalAlignment,priority:0}:null},measure:function(e){return this.draw(e[0],e[1]),[this._boundingRect.width,this._boundingRect.height]},move:function(e,t){var n=this._boundingRect;s(e,n)?this.shift(t[0],t[1]):this.shift(Math.round(e[0]),Math.round(e[1]))},freeSpace:function(){var e=this;e._params.incidentOccurred("W2103"),e._group.linkRemove(),e._boundingRect.width=e._boundingRect.height=0},getOptions:function(){return this._options},changeLink:function(e){this._group.linkRemove(),this._group.linkOn(e,"title")}}),t.Title=l,t.plugin={name:"title",init:function(){var e=this;e._title=new t.Title({renderer:e._renderer,cssClass:e._rootClassPrefix+"-title",incidentOccurred:e._incidentOccurred}),e._layout.add(e._title)},dispose:function(){this._title.dispose(),this._title=null},customize:function(e){e.addChange({code:"TITLE",handler:function(){this._title.update(this._themeManager.theme("title"),this.option("title"))&&this._change(["LAYOUT"])},isThemeDependent:!0,option:"title",isOptionChange:!0})},fontFields:["title.font","title.subtitle.font"]}},function(e,t,n){function i(e,t,n){return t in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}function o(e){var t=0;return f(e,function(e,n){t+=n}),t}function a(e){return h(e,[B,R,A,O,P])!==-1}function r(e,t){return o(b(e,function(e){return(e-t)*(e-t)}))/e.length}function s(e,t,n){var i=n.getOptions().valueErrorBar,o=n.getValueFields()[0],a=i.lowValueField||E,r=i.highValueField||T;if(n.areErrorBarsVisible()&&void 0===i.type){var s=t.reduce(function(e,t){return v(t[a])&&(e[0]+=t[o]-t[a],e[1]++),v(t[r])&&(e[2]+=t[r]-t[o],e[3]++),e},[0,0,0,0]);s[1]&&(e[a]=e[o]-s[0]/s[1]),s[2]&&(e[r]=e[o]+s[2]/s[3])}return e}function l(e,t,n){var i=n.getOptions().valueErrorBar,o=i.lowValueField||E,a=i.highValueField||T;return n.areErrorBarsVisible()&&void 0===i.type&&(e[o]=0,e[a]=0,e=t.reduce(function(e,t){return e[o]+=t[o],e[a]+=t[a],e},e)),e}function u(e){return function(t,n){var o=t.intervalStart,a=t.data,r=n.getValueFields()[0],s=a[0];return s=a.reduce(function(t,n){var i=n[r];return null===t[r]&&(t=n),null!==i&&e(i,t[r])?n:t},s),d({},s,i({},n.getArgumentField(),o))}}function c(e,t,n){var i=!0;for(var o in t){var a="argument"===o;if(a||"size"===o?!v(e[o]):void 0===e[o]){var r=t[o];a||(n[r]=(n[r]||0)+1),i=!1}}return i}var d=n(0).extend,h=n(14).inArray,f=n(3).each,p=n(208),g=n(1),_=n(13),m=n(4).noop,v=g.isDefined,y=g.isString,b=_.map,x=_.normalizeEnum,w=Math,C=w.abs,k=w.sqrt,S=w.max,I=12,D=400,T="highError",E="lowError",A="variance",O="stddeviation",P="stderror",R="percent",B="fixed",M="undefined",V="discrete",F="logarithmic",L="datetime";t.chart={},t.polar={};var H={_defaultDuration:D,_defaultTrackerWidth:I,_applyStyle:m,_updateOptions:m,_parseStyle:m,_prepareSegment:m,_drawSegment:m,_appendInGroup:function(){this._group.append(this._extGroups.seriesGroup)},_createLegendState:function(e,t){return{fill:e.color||t,hatching:e.hatching?d({},e.hatching,{direction:"right"}):void 0}},_applyElementsClipRect:function(e){e["clip-path"]=this._paneClipRectID},_applyMarkerClipRect:function(e){e["clip-path"]=this._forceClipping?this._paneClipRectID:null},_createGroup:function(e,t,n,i){var o=t[e]=t[e]||this._renderer.g();n&&o.append(n),i&&o.attr(i)},_applyClearingSettings:function(e){e.opacity=null,e.scale=null,this._options.rotated?e.translateX=null:e.translateY=null},_createGroups:function(){var e=this;e._createGroup("_markersGroup",e,e._group),e._createGroup("_labelsGroup",e)},_setMarkerGroupSettings:function(){var e=this,t=e._createPointStyles(e._getMarkerGroupOptions()).normal;t.class="dxc-markers",t.opacity=1,e._applyMarkerClipRect(t),e._markersGroup.attr(t)},getVisibleArea:function(){return this._visibleArea},areErrorBarsVisible:function(){var e=this._options.valueErrorBar;return e&&this._errorBarsEnabled()&&"none"!==e.displayMode&&(a(x(e.type))||v(e.lowValueField)||v(e.highValueField))},groupPointsByCoords:function(e){var t=[];return f(this.getVisiblePoints(),function(n,i){var o=parseInt(e?i.vy:i.vx);t[o]?Array.isArray(t[o])?t[o].push(i):t[o]=[t[o],i]:t[o]=i}),t},_createErrorBarGroup:function(e){var t,n=this,i=n._options.valueErrorBar;n.areErrorBarsVisible()&&(t={"class":"dxc-error-bars",stroke:i.color,"stroke-width":i.lineWidth,opacity:e?.001:i.opacity||1,"stroke-linecap":"square",sharp:!0,"clip-path":n._forceClipping?n._paneClipRectID:n._widePaneClipRectID},n._createGroup("_errorBarGroup",n,n._group,t))},_setGroupsSettings:function(e){var t=this;t._setMarkerGroupSettings(),t._setLabelGroupSettings(e),t._createErrorBarGroup(e)},_getCreatingPointOptions:function(){var e,t,n=this,i=n._predefinedPointOptions;return i||(e=n._getPointOptions(),n._predefinedPointOptions=i=d(!0,{styles:{}},e),t=e.styles&&e.styles.normal||{},i.styles=i.styles||{},i.styles.normal={"stroke-width":t["stroke-width"],r:t.r,opacity:t.opacity}),i},_getPointOptions:function(){return this._parsePointOptions(this._preparePointOptions(),this._options.label)},_getOptionsForPoint:function(){return this._options.point},_parsePointStyle:function(e,t,n,i){var o=e.border||{},a=void 0!==e.size?e.size:i;return{fill:e.color||t,stroke:o.color||n,"stroke-width":o.visible?o.width:0,r:a/2+(o.visible&&0!==a?~~(o.width/2)||0:0)}},_createPointStyles:function(e){var t=this,n=e.color||t._options.mainSeriesColor,i=t._options.containerBackgroundColor,o=t._parsePointStyle(e,n,n);return o.visibility=e.visible?"visible":"hidden",{normal:o,hover:t._parsePointStyle(e.hoverStyle,i,n,e.size),selection:t._parsePointStyle(e.selectionStyle,i,n,e.size)}},_checkData:function(e,t,n){return n=n||{value:this.getValueFields()[0]},n.argument=this.getArgumentField(),c(e,n,t||{})&&e.value===e.value},getValueRangeInitialValue:function(){},_getRangeData:function(){return p.getRangeData(this)},_getPointDataSelector:function(){var e,t,n=this,i=this.getValueFields()[0],o=this.getArgumentField(),a=this.getTagField(),r=this.areErrorBarsVisible();if(r){var s=this._options.valueErrorBar;e=s.lowValueField||E,t=s.highValueField||T}return function(s){var l={value:n._processEmptyValue(s[i]),argument:s[o],tag:s[a],data:s};return r&&(l.lowError=s[e],l.highError=s[t]),l}},_errorBarsEnabled:function(){return this.valueAxisType!==V&&this.valueAxisType!==F&&this.valueType!==L},_drawPoint:function(e){var t=e.point;t.isInVisibleArea()?(t.clearVisibility(),t.draw(this._renderer,e.groups,e.hasAnimation,e.firstDrawing),this._drawnPoints.push(t)):t.setInvisibility()},_animateComplete:function(){var e=this,t={duration:e._defaultDuration};e._labelsGroup&&e._labelsGroup.animate({opacity:1},t),e._errorBarGroup&&e._errorBarGroup.animate({opacity:e._options.valueErrorBar.opacity||1},t)},_animate:function(){var e=this,t=e._drawnPoints.length-1;f(e._drawnPoints||[],function(n,i){i.animate(n===t?function(){e._animateComplete()}:void 0,{translateX:i.x,translateY:i.y})})},_defaultAggregator:"avg",_aggregators:{avg:function(e,t){var n,o=e.data,a=e.intervalStart;if(o.length){var r=t.getValueFields()[0],l=o.reduce(function(e,t){var n=t[r];return v(n)?(e[0]+=n,e[1]++):null===n&&e[2]++,e},[0,0,0]);return s((n={},i(n,r,l[2]===o.length?null:l[0]/l[1]),i(n,t.getArgumentField(),a),n),o,t)}},sum:function(e,t){var n,o=e.intervalStart,a=e.data;if(a.length){var r=t.getValueFields()[0],s=a.reduce(function(e,t){var n=t[r];return void 0!==n&&(e[0]+=n),null===n?e[1]++:void 0===n&&e[2]++,e},[0,0,0]),u=s[0];if(s[1]===a.length&&(u=null),s[2]!==a.length)return l((n={},i(n,r,u),i(n,t.getArgumentField(),o),n),a,t)}},count:function(e,t){var n,o=e.data,a=e.intervalStart,r=t.getValueFields()[0];return n={},i(n,t.getArgumentField(),a),i(n,r,o.filter(function(e){return void 0!==e[r]}).length),n},min:u(function(e,t){return e<t}),max:u(function(e,t){return e>t})},_endUpdateData:function(){delete this._predefinedPointOptions},getArgumentField:function(){return this._options.argumentField||"arg"},getValueFields:function(){var e,t,n=this._options,i=n.valueErrorBar,o=[n.valueField||"val"];return i&&(e=i.lowValueField,t=i.highValueField,y(e)&&o.push(e),y(t)&&o.push(t)),o},_calculateErrorBars:function(e){if(this.areErrorBarsVisible()){var t,n,i,a,s,l=this,u=l._options,c=u.valueErrorBar,d=x(c.type),h=parseFloat(c.value),p=l.getValueFields()[0],g=c.lowValueField||E,_=c.highValueField||T,m=function(e,n){t=n.value,n.lowError=t-h,n.highError=t+h};switch(d){case B:s=m;break;case R:s=function(e,n){t=n.value;var i=t*h/100;n.lowError=t-i,n.highError=t+i};break;case M:s=function(e,t){t.lowError=t.data[g],t.highError=t.data[_]};break;default:switch(n=b(e,function(e){return v(e.data[p])?e.data[p]:null}),i=n.length,h=h||1,d){case A:h=r(n,o(n)/i)*h,s=m;break;case O:a=o(n)/i,h=k(r(n,a))*h,s=function(e,t){t.lowError=a-h,t.highError=a+h};break;case P:h=k(r(n,o(n)/i)/i)*h,s=m}}s&&f(e,s)}},_patchMarginOptions:function(e){var t=this._getCreatingPointOptions(),n=t.styles,i=[n.normal,n.hover,n.selection].reduce(function(e,t){return S(e,2*t.r+t["stroke-width"])},0);return e.size=t.visible?i:0,e.sizePointNormalState=t.visible?2*n.normal.r+n.normal["stroke-width"]:2,e},usePointsToDefineAutoHiding:function(){return!0}};t.chart=d({},H,{drawTrackers:function(){var e,t,n=this,i=n._segments||[],o=n._options.rotated;n.isVisible()&&(i.length&&(e=n._trackers=n._trackers||[],t=n._trackersGroup=(n._trackersGroup||n._renderer.g().attr({fill:"gray",opacity:.001,stroke:"gray","class":"dxc-trackers"})).attr({"clip-path":this._paneClipRectID||null}).append(n._group),f(i,function(i,o){e[i]?n._updateTrackerElement(o,e[i]):e[i]=n._drawTrackerElement(o).data({"chart-data-series":n}).append(t)})),n._trackersTranslator=n.groupPointsByCoords(o))},_checkAxisVisibleAreaCoord:function(e,t){var n=e?this.getArgumentAxis():this.getValueAxis(),i=n.getVisibleArea();return v(t)&&i[0]<=t&&i[1]>=t},checkSeriesViewportCoord:function(e,t){return!0},getSeriesPairCoord:function(e,t){for(var n=null,i=!t&&!this._options.rotated||t&&this._options.rotated,o=i?"vy":"vx",a=i?"vx":"vy",r=this.getVisiblePoints(),s=0;s<r.length;s++){var l=r[s],u=l[o]===e?l[a]:void 0;if(this._checkAxisVisibleAreaCoord(!t,u)){n=u;break}}return n},_getNearestPoints:function(e,t){return[e,t]},_getBezierPoints:function(){return[]},_getNearestPointsByCoord:function(e,t){var n=this,i=n.getOptions().rotated,o=!t&&!i||t&&i,a=o?"vy":"vx",r=n.getPoints(),s=n._getBezierPoints(),l=[];return r.length>1?r.forEach(function(t,i){var o=r[i+1];o&&(t[a]<=e&&o[a]>=e||t[a]>=e&&o[a]<=e)&&l.push(n._getNearestPoints(t,o,s))}):l.push([r[0],r[0]]),l},getNeighborPoint:function(e,t){var n,i=this._options.rotated?t:e,o=i,a=this._trackersTranslator,r=null,s=this._options.rotated?e:t,l=this._options.rotated?"vx":"vy";if(this.isVisible()&&a){r=a[i];do r=a[o]||a[i],i--,o++;while((i>=0||o<a.length)&&!r);Array.isArray(r)&&(n=C(r[0][l]-s),f(r,function(e,t){var i=C(t[l]-s);n>=i&&(n=i,r=t)}))}return r},_applyVisibleArea:function(){var e=this,t=e._options.rotated,n=(t?e.getValueAxis():e.getArgumentAxis()).getVisibleArea(),i=(t?e.getArgumentAxis():e.getValueAxis()).getVisibleArea();e._visibleArea={minX:n[0],maxX:n[1],minY:i[0],maxY:i[1]}},getPointCenterByArg:function(e){var t=this.getPointsByArg(e)[0];return t?t.getCenterCoord():void 0}}),t.polar=d({},H,{drawTrackers:function(){t.chart.drawTrackers.call(this);var e,n=this._trackersTranslator;this.isVisible()&&(f(n,function(t,n){if(n)return e=t,!1}),n[e+360]=n[e])},getNeighborPoint:function(e,n){var i=_.convertXYToPolar(this.getValueAxis().getCenter(),e,n);return t.chart.getNeighborPoint.call(this,i.phi,i.r)},_applyVisibleArea:function(){var e=this,t=e.getValueAxis().getCanvas();e._visibleArea={minX:t.left,maxX:t.width-t.right,minY:t.top,maxY:t.height-t.bottom}}})},function(e,t,n){function i(e){return e&&e.__esModule?e:{"default":e}}function o(e){e.css({left:"-9999px"}).detach()}function a(e,t){var n=e;switch(t){case"argument":n={format:e.argumentFormat};break;case"percent":n={format:{type:"percent",precision:e.format&&e.format.percentPrecision}}}return n}function r(e){var t,n=this;n._eventTrigger=e.eventTrigger,n._widgetRoot=e.widgetRoot,n._widget=e.widget,n._wrapper=(0,p.default)("<div>").css({position:"absolute",overflow:"hidden",pointerEvents:"none"}).addClass(e.cssClass),n._renderer=t=new _.default.Renderer({pathModified:e.pathModified,container:n._wrapper[0]});var i=t.root;i.attr({"pointer-events":"none"}),n._text=t.text(void 0,0,0),n._textGroupHtml=(0,p.default)("<div>").css({position:"absolute",padding:0,margin:0,border:"0px solid transparent"}).appendTo(n._wrapper),n._textHtml=(0,p.default)("<div>").css({position:"relative",display:"inline-block",padding:0,margin:0,border:"0px solid transparent"}).appendTo(n._textGroupHtml)}var s=n(11),l=i(s),u=n(7),c=i(u),d=n(33),h=i(d),f=n(2),p=i(f),g=n(149),_=i(g),m=n(1),v=i(m),y=n(0),b=n(13),x=i(b),w=n(65),C=n(419),k=Math.ceil,S=Math.max,I=Math.min,D=c.default.getWindow(),T=3e3;r.prototype={constructor:r,dispose:function(){this._wrapper.remove(),this._renderer.dispose(),this._options=this._widgetRoot=null},_getContainer:function(){var e=this._options,t=(0,p.default)(this._widgetRoot).closest(e.container);return 0===t.length&&(t=(0,p.default)(e.container)),(t.length?t:(0,p.default)("body")).get(0)},setTemplate:function(e){var t=this;t._template=e?t._widget._getTemplate(e):null},setOptions:function(e){var t=this;e=e||{};var n=this;n._options=e,n._textFontStyles=x.default.patchFontOptions(e.font),n._textFontStyles.color=n._textFontStyles.fill,n._wrapper.css({zIndex:e.zIndex}),n._customizeTooltip=e.customizeTooltip;var i=n._textGroupHtml,o=n._textHtml;this.plaque&&this.plaque.clear(),this.setTemplate(e.contentTemplate);var a=function(a){var r=a.group,s=a.onRender,l=a.eventData,u=a.isMoving,c=n._state;if(!u){var d=n._template,h=d&&!c.formatObject.skipTemplate;if(c.html||h){if(i.css({color:c.textColor,width:T}),h)return void d.render({model:c.formatObject,container:o,onRendered:function(){return c.html=o.html(),c.html?(s(),n._riseEvents(l),n._moveWrapper(),void n.plaque.customizeCloud({fill:c.color,stroke:c.borderColor})):void t.plaque.clear()}});n._text.attr({text:""}),o.html(c.html)}else n._text.css({fill:c.textColor}).attr({text:c.text,"class":e.cssClass}).append(r.attr({align:e.textAlignment}));n._riseEvents(l),n.plaque.customizeCloud({fill:c.color,stroke:c.borderColor})}s(),n._moveWrapper()};return this.plaque=new C.Plaque({opacity:n._options.opacity,color:n._options.color,border:n._options.border,paddingLeftRight:n._options.paddingLeftRight,paddingTopBottom:n._options.paddingTopBottom,arrowLength:n._options.arrowLength,arrowWidth:20,shadow:n._options.shadow,cornerRadius:n._options.cornerRadius
},n,n._renderer.root,a,(!0),function(e,t){var n=e._state;if(n.html){var i,a=D.getComputedStyle;return a?(i=a(o.get(0)),i={x:0,y:0,width:k(parseFloat(i.width)),height:k(parseFloat(i.height))}):(i=o.get(0).getBoundingClientRect(),i={x:0,y:0,width:k(i.width?i.width:i.right-i.left),height:k(i.height?i.height:i.bottom-i.top)}),i}return t.getBBox()},function(e,t,i,o){var a=e._state;a.html?n._textGroupHtml.css({left:i,top:o}):t.move(i,o)}),n},_riseEvents:function(e){var t=this;t._eventData&&t._eventTrigger("tooltipHidden",t._eventData),t._eventData=e,t._eventTrigger("tooltipShown",t._eventData)},setRendererOptions:function(e){return this._renderer.setOptions(e),this._textGroupHtml.css({direction:e.rtl?"rtl":"ltr"}),this},update:function(e){var t=this;t.setOptions(e),o(t._wrapper);var n={};for(var i in t._textFontStyles)n[h.default.camelize(i)]=t._textFontStyles[i];return t._textGroupHtml.css(n),t._text.css(t._textFontStyles),t._eventData=null,t},_prepare:function(e,t){var n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:this._customizeTooltip,i=this._options,o={};return v.default.isFunction(n)&&(o=n.call(e,e),o=v.default.isPlainObject(o)?o:{},"text"in o&&(t.text=v.default.isDefined(o.text)?String(o.text):""),"html"in o&&(t.html=v.default.isDefined(o.html)?String(o.html):"")),"text"in t||"html"in t||(t.text=e.valueText||e.description||""),t.color=o.color||i.color,t.borderColor=o.borderColor||(i.border||{}).color,t.textColor=o.fontColor||(this._textFontStyles||{}).color,!!t.text||!!t.html||!!this._template},show:function(e,t,n,i){var o=this,a={formatObject:e,eventData:n};if(!o._prepare(e,a,i))return!1;o._state=a,o._wrapper.appendTo(o._getContainer()),o._clear();var r=(0,y.extend)({},o._options,{canvas:o._getCanvas()},a,{x:t.x,y:t.y,offset:t.offset});return this.plaque.clear().draw(r)},hide:function(){var e=this;o(e._wrapper),e._eventData&&(e._eventTrigger("tooltipHidden",e._eventData),e._clear(),e._eventData=null)},_clear:function(){this._textHtml.empty()},move:function(e,t,n){this.plaque.draw({x:e,y:t,offset:n,canvas:this._getCanvas(),isMoving:!0})},_moveWrapper:function(){var e=this,t=this.plaque.getBBox();e._renderer.resize(t.width,t.height);var n=e._wrapper.css({left:0,top:0}).offset(),i=t.x,o=t.y;e._wrapper.css({left:i-n.left,top:o-n.top}),this.plaque.moveRoot(-i,-o),this._state.html&&(e._textHtml.css({left:-i,top:-o}),e._textGroupHtml.css({width:t.width}))},formatValue:function(e,t){var n=t?a(this._options,t):this._options;return(0,w.format)(e,n.format)},getLocation:function(){return x.default.normalizeEnum(this._options.location)},isEnabled:function(){return!!this._options.enabled},isShared:function(){return!!this._options.shared},_getCanvas:function(){var e=this._getContainer(),t=e.getBoundingClientRect(),n=l.default.getDocumentElement(),i=l.default.getDocument(),o=D.pageXOffset||n.scrollLeft||0,a=D.pageYOffset||n.scrollTop||0,r={left:o,top:a,width:n.clientWidth+o||0,height:S(i.body.scrollHeight,n.scrollHeight,i.body.offsetHeight,n.offsetHeight,i.body.clientHeight,n.clientHeight)||0,right:0,bottom:0};return e!==l.default.getBody()&&(o=S(r.left,r.left+t.left),a=S(r.top,r.top+t.top),r.width=I(t.width,r.width)+o+r.left,r.height=I(t.height,r.height)+a+r.top,r.left=o,r.top=a),r}},t.Tooltip=r,t.plugin={name:"tooltip",init:function(){this._initTooltip()},dispose:function(){this._disposeTooltip()},members:{_initTooltip:function(){this._tooltip=new t.Tooltip({cssClass:this._rootClassPrefix+"-tooltip",eventTrigger:this._eventTrigger,pathModified:this.option("pathModified"),widgetRoot:this.element(),widget:this})},_disposeTooltip:function(){this._tooltip.dispose(),this._tooltip=null},_setTooltipRendererOptions:function(){this._tooltip.setRendererOptions(this._getRendererOptions())},_setTooltipOptions:function(){this._tooltip.update(this._getOption("tooltip"))}},extenders:{_stopCurrentHandling:function(){this._tooltip&&this._tooltip.hide()}},customize:function(e){var t=e.prototype;t._eventsMap.onTooltipShown={name:"tooltipShown"},t._eventsMap.onTooltipHidden={name:"tooltipHidden"},e.addChange({code:"TOOLTIP_RENDERER",handler:function(){this._setTooltipRendererOptions()},isThemeDependent:!0,isOptionChange:!0}),e.addChange({code:"TOOLTIP",handler:function(){this._setTooltipOptions()},isThemeDependent:!0,isOptionChange:!0,option:"tooltip"})},fontFields:["tooltip.font"]}},function(e,t,n){function i(e,t){return t<e}function o(e,t){return t>e}function a(e,t,n,i){var o=l(t);l(e)?o&&i(e,t)&&n(t):o&&n(t)}var r=n(1),s=n(0).extend,l=r.isDefined,u=r.isDate,c=r.isFunction,d=n(13).unique,h="min",f="max",p="minVisible",g="maxVisible",_="base",m="axisType",v=t.Range=function(e){e&&s(this,e)};v.prototype={constructor:v,addRange:function(e){var t=this,n=t.categories,r=e.categories,s="discrete"===t[m],u=function(n,i){a(t[n],e[n],function(e){t[n]=e},i)},c=function(e,n,i){a(t[e],t[n],function(n){l(t[e])&&(t[e]=n)},i)},v=function(n){t[n]=t[n]||e[n]};return v("invert"),v(m),v("dataType"),v("isSpacedMargin"),"logarithmic"===t[m]?v(_):t[_]=void 0,u(h,i),u(f,o),s?(v(p),v(g)):(u(p,i),u(g,o)),u("interval",i),s||(c(h,p,i),c(h,g,i),c(f,g,o),c(f,p,o)),void 0===n?t.categories=r:t.categories=r?d(n.concat(r)):n,"logarithmic"===t[m]&&(v("allowNegatives"),u("linearThreshold",i)),t},isEmpty:function(){return!(l(this[h])&&l(this[f])||this.categories&&0!==this.categories.length)},correctValueZeroLevel:function(){function e(e,n){t[e]<0&&t[n]<0&&(t[n]=0),t[e]>0&&t[n]>0&&(t[e]=0)}var t=this;return"logarithmic"===t[m]||u(t[f])||u(t[h])?t:(e(h,f),e(p,g),t)},sortCategories:function(e){if(e!==!1&&this.categories)if(Array.isArray(e)){var t=e.map(function(e){return e.valueOf()}),n=this.categories.filter(function(e){return t.indexOf(e.valueOf())===-1});this.categories=e.concat(n)}else{var i=!c(e);i&&"string"!==this.dataType?e=function(e,t){return e.valueOf()-t.valueOf()}:i&&(e=!1),e&&this.categories.sort(e)}}}},function(e,t,n){var i=n(2),o=n(28),a=n(7).getWindow(),r=n(1),s=n(3).each,l=n(15),u=n(21),c=l.inherit({ctor:function(e,t){t=t||{},this._action=e,this._context=t.context||a,this._beforeExecute=t.beforeExecute,this._afterExecute=t.afterExecute,this._component=t.component,this._validatingTargetName=t.validatingTargetName;var n=this._excludeValidators={};if(t.excludeValidators)for(var i=0;i<t.excludeValidators.length;i++)n[t.excludeValidators[i]]=!0},execute:function(){var e={action:this._action,args:Array.prototype.slice.call(arguments),context:this._context,component:this._component,validatingTargetName:this._validatingTargetName,cancel:!1,handled:!1},t=this._beforeExecute,n=this._afterExecute,i=e.args[0]||{};if("jQueryEvent"in i||!i.event||!o().useJQuery||Object.defineProperty(i,"jQueryEvent",{get:function(){return u.log("W0003","Handler argument","jQueryEvent","17.2","Use the 'event' field instead"),i.event},set:function(e){u.log("W0003","Handler argument","jQueryEvent","17.2","Use the 'event' field instead"),i.event=e}}),this._validateAction(e)&&(t&&t.call(this._context,e),!e.cancel)){var a=this._executeAction(e);if(!i.cancel)return n&&n.call(this._context,e),a}},_validateAction:function(e){var t=this._excludeValidators,n=c.executors;for(var i in n)if(!t[i]){var o=n[i];if(o.validate&&o.validate(e),e.cancel)return!1}return!0},_executeAction:function(e){var t,n=c.executors;for(var i in n){var o=n[i];if(o.execute&&o.execute(e),e.handled){t=e.result;break}}return t}});c.executors={},c.registerExecutor=function(e,t){return r.isPlainObject(e)?void s(e,c.registerExecutor):void(c.executors[e]=t)},c.unregisterExecutor=function(){var e=[].slice.call(arguments);s(e,function(){delete c.executors[this]})},c.registerExecutor({undefined:{execute:function(e){e.action||(e.result=void 0,e.handled=!0)}},func:{execute:function(e){r.isFunction(e.action)&&(e.result=e.action.call(e.context,e.args[0]),e.handled=!0)}}});var d=function(e){return function(t){if(t.args.length){var n=t.args[0],o=n[t.validatingTargetName]||n.element;o&&e(i(o))&&(t.cancel=!0)}}};c.registerExecutor({disabled:{validate:d(function(e){return e.is(".dx-state-disabled, .dx-state-disabled *")})},readOnly:{validate:d(function(e){return e.is(".dx-state-readonly, .dx-state-readonly *:not(.dx-state-independent)")})}}),e.exports=c},function(e,t,n){function i(e){"@babel/helpers - typeof";return(i="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}function o(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}function a(e,t){for(var n=0;n<t.length;n++){var i=t[n];i.enumerable=i.enumerable||!1,i.configurable=!0,"value"in i&&(i.writable=!0),Object.defineProperty(e,i.key,i)}}function r(e,t,n){return t&&a(e.prototype,t),n&&a(e,n),e}function s(e,t){if("function"!=typeof t&&null!==t)throw new TypeError("Super expression must either be null or a function");e.prototype=Object.create(t&&t.prototype,{constructor:{value:e,writable:!0,configurable:!0}}),t&&l(e,t)}function l(e,t){return(l=Object.setPrototypeOf||function(e,t){return e.__proto__=t,e})(e,t)}function u(e){var t=h();return function(){var n,i=f(e);if(t){var o=f(this).constructor;n=Reflect.construct(i,arguments,o)}else n=i.apply(this,arguments);return c(this,n)}}function c(e,t){return!t||"object"!==i(t)&&"function"!=typeof t?d(e):t}function d(e){if(void 0===e)throw new ReferenceError("this hasn't been initialised - super() hasn't been called");return e}function h(){if("undefined"==typeof Reflect||!Reflect.construct)return!1;if(Reflect.construct.sham)return!1;if("function"==typeof Proxy)return!0;try{return Date.prototype.toString.call(Reflect.construct(Date,[],function(){})),!0}catch(e){return!1}}function f(e){return(f=Object.setPrototypeOf?Object.getPrototypeOf:function(e){return e.__proto__||Object.getPrototypeOf(e)})(e)}Object.defineProperty(t,"__esModule",{value:!0}),t.FunctionTemplate=void 0;var p=n(70),g=n(12);t.FunctionTemplate=function(e){function t(e){var i;return o(this,t),i=n.call(this),i._render=e,i}s(t,e);var n=u(t);return r(t,[{key:"_renderCore",value:function(e){return(0,g.normalizeTemplateElement)(this._render(e))}}]),t}(p.TemplateBase)},function(e,t,n){function i(e){return s(e)||r(e)||a(e)||o()}function o(){throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}function a(e,t){if(e){if("string"==typeof e)return l(e,t);var n=Object.prototype.toString.call(e).slice(8,-1);return"Object"===n&&e.constructor&&(n=e.constructor.name),"Map"===n||"Set"===n?Array.from(e):"Arguments"===n||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)?l(e,t):void 0}}function r(e){if("undefined"!=typeof Symbol&&Symbol.iterator in Object(e))return Array.from(e)}function s(e){if(Array.isArray(e))return l(e)}function l(e,t){(null==t||t>e.length)&&(t=e.length);for(var n=0,i=new Array(t);n<t;n++)i[n]=e[n];return i}function u(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}function c(e,t){for(var n=0;n<t.length;n++){var i=t[n];i.enumerable=i.enumerable||!1,i.configurable=!0,"value"in i&&(i.writable=!0),Object.defineProperty(e,i.key,i)}}function d(e,t,n){return t&&c(e.prototype,t),n&&c(e,n),e}var h=n(28),f=n(0).extend,p=n(464).OptionManager,g=n(20).bracketsToDots,_=n(15),m=n(110),v=n(21),y=n(4),b=n(1),x=n(48),w=n(6),C=w.Deferred,k=w.when,S=n(27),I=n(83),D=n(131),T=n(16),E=b.isFunction,A=y.noop,O=function(){function e(){u(this,e),this._postponedOperations={}}return d(e,[{key:"add",value:function(e,t,n){if(e in this._postponedOperations)n&&this._postponedOperations[e].promises.push(n);else{var i=new C;this._postponedOperations[e]={fn:t,completePromise:i,promises:n?[n]:[]}}return this._postponedOperations[e].completePromise.promise()}},{key:"callPostponedOperations",value:function(){for(var e in this._postponedOperations){var t=this._postponedOperations[e];b.isDefined(t)&&(t.promises&&t.promises.length?k.apply(void 0,i(t.promises)).done(t.fn).then(t.completePromise.resolve):t.fn().done(t.completePromise.resolve))}this._postponedOperations={}}}]),e}(),P=function(e,t){if("string"!=typeof e)return e;var n={};return n[e]=t,n},R=_.inherit({_setDeprecatedOptions:function(){this._deprecatedOptions={}},_getDeprecatedOptions:function(){return this._deprecatedOptions},_getOptionAliasesByName:function(e){var t=this;return Object.keys(this._deprecatedOptions).filter(function(n){return e===t._deprecatedOptions[n].alias})},_getDefaultOptions:function(){return{onInitialized:null,onOptionChanged:null,onDisposing:null,defaultOptionsRules:null}},_defaultOptionsRules:function(){return[]},_getOptionByRules:function(e){var t=this._defaultOptionsRules();return Array.isArray(e)&&(t=t.concat(e)),this._convertRulesToOptions(t)},_setOptionsByDevice:function(e){var t=this._getOptionByRules(e);this._setOptionByStealth(t)},_convertRulesToOptions:function(e){for(var t={},n=T.current(),i=function(e,t){var n=[];return Array.prototype.push.call(n,t),1===n.length&&b.isEmptyObject(n[0])||y.findBestMatches(e,n).length>0},o=0;o<e.length;o++){var a,r=e[o],s=r.device||{};a=E(s)?s(n):i(n,s),a&&f(t,r.options)}return t},_isInitialOptionValue:function(e){var t=this.option(e),n=this.initialOption(e),i=E(t)&&E(n)?t.toString()===n.toString():y.equalByValue(t,n);return i},_setOptionsByReference:function(){this._optionsByReference={}},_getOptionsByReference:function(){return this._optionsByReference},ctor:function(e){var t=this;this.NAME=D.name(this.constructor),e=e||{},e.eventsStrategy&&this.setEventsStrategy(e.eventsStrategy),this._options={},this._updateLockCount=0,this._optionChangedCallbacks=e._optionChangedCallbacks||S(),this._disposingCallbacks=e._disposingCallbacks||S(),this.postponedOperations=new O,this.beginUpdate();try{this._setOptionsByReference(),this._setDeprecatedOptions(),this._options=this._getDefaultOptions(),this._optionManager=new p(this._options,this._getOptionsByReference(),this._deprecatedOptions),this._optionManager.onChanging(function(e,n,i){t._initialized&&t._optionChanging(e,n,i)}),this._optionManager.onDeprecated(function(e,n){t._logDeprecatedWarning(e,n)}),this._optionManager.onChanged(function(e,n,i){t._notifyOptionChanged(e,n,i)}),e&&e.onInitializing&&e.onInitializing.apply(this,[e]),this._setOptionsByDevice(e.defaultOptionsRules),this._initOptions(e)}finally{this.endUpdate()}},_initOptions:function(e){this.option(e)},_init:function(){this._createOptionChangedAction(),this.on("disposing",function(e){this._disposingCallbacks.fireWith(this,[e])}.bind(this))},_logDeprecatedWarning:function(e,t){var n=t.message||"Use the '"+t.alias+"' option instead";v.log("W0001",this.NAME,e,t.since,n)},_createOptionChangedAction:function(){this._optionChangedAction=this._createActionByOption("onOptionChanged",{excludeValidators:["disabled","readOnly"]})},_createDisposingAction:function(){this._disposingAction=this._createActionByOption("onDisposing",{excludeValidators:["disabled","readOnly"]})},_optionChanged:function(e){switch(e.name){case"onDisposing":case"onInitialized":break;case"onOptionChanged":this._createOptionChangedAction();break;case"defaultOptionsRules":}},_dispose:function(){this._optionChangedCallbacks.empty(),this._createDisposingAction(),this._disposingAction(),this._disposeEvents(),this._optionManager.dispose(),this._disposed=!0},instance:function(){return this},beginUpdate:function(){this._updateLockCount++},endUpdate:function(){if(this._updateLockCount=Math.max(this._updateLockCount-1,0),!this._updateLockCount&&(this.postponedOperations.callPostponedOperations(),!this._initializing&&!this._initialized)){this._initializing=!0;try{this._init()}finally{this._initializing=!1,this._updateLockCount++,this._createActionByOption("onInitialized",{excludeValidators:["disabled","readOnly"]})(),this._updateLockCount--,this._initialized=!0}}},_optionChanging:A,_notifyOptionChanged:function(e,t,n){var i=this;if(this._initialized)for(var o=[e].concat(i._getOptionAliasesByName(e)),a=0;a<o.length;a++){var r=o[a],s={name:r.split(/[.[]/)[0],fullName:r,value:t,previousValue:n};i._optionChangedCallbacks.fireWith(i,[f(i._defaultActionArgs(),s)]),i._optionChangedAction(f({},s)),i._disposed||this._cancelOptionChange===s.name||i._optionChanged(s)}},initialOption:function(e){if(!this._initialOptions){this._initialOptions=this._getDefaultOptions();var t=this._getOptionByRules(this._getOptionByStealth("defaultOptionsRules"));this._optionManager.setValueByReference(this._initialOptions,t)}return this._initialOptions[e]},_defaultActionConfig:function(){return{context:this,component:this}},_defaultActionArgs:function(){return{component:this}},_createAction:function(e,t){var n,i=this;return function(o){return arguments.length||(o={}),b.isPlainObject(o)||(o={actionValue:o}),n=n||new m(e,f(t,i._defaultActionConfig())),n.execute.call(n,f(o,i._defaultActionArgs()))}},_createActionByOption:function(e,t){var n,i,o,a=this,r=function(){if(!i){if(t=t||{},"string"!=typeof e)throw v.Error("E0008");0===e.indexOf("on")&&(i=a._getEventName(e)),o=a.option(e)}if(n||o||t.beforeExecute||t.afterExecute||a.hasEvent(i)){if(!n){var r=t.beforeExecute;t.beforeExecute=function(e){r&&r.apply(a,arguments),a.fireEvent(i,e.args)},n=a._createAction(o,t)}if(h().wrapActionsBeforeExecute){var s=a.option("beforeActionExecute")||A,l=s(a,n,t)||n;return l.apply(a,arguments)}return n.apply(a,arguments)}};if(!h().wrapActionsBeforeExecute){var s=a.option("onActionCreated")||A;r=s(a,r,t)||r}return r},_getOptionByStealth:function(e){return this._optionManager.getValueSilently(e)},_setOptionByStealth:function(e,t){this._optionManager.setValueSilently(P(e,t))},_getEventName:function(e){return e.charAt(2).toLowerCase()+e.substr(3)},hasActionSubscription:function(e){return!!this.option(e)||this.hasEvent(this._getEventName(e))},isOptionDeprecated:function(e){var t=this._getDeprecatedOptions();return Object.prototype.hasOwnProperty.call(t,e)},_setOptionSilent:function(e,t){this._cancelOptionChange=e,this.option(e,t),this._cancelOptionChange=!1},_getOptionValue:function(e,t){var n=this.option(e);return E(n)?n.bind(t)():n},option:function(e,t){if(arguments.length<2&&"object"!==b.type(e))return this._optionManager.getValue(e);this.beginUpdate();try{this._optionManager.setValue(P(e,t))}finally{this.endUpdate()}},resetOption:function(e){var t=this;if(e){var n;if(e.search(/\.|\[/)!==-1){e=g(e);var i=e.split(".");i.forEach(function(e){n=n?n[e]:t.initialOption(e)})}else n=this.initialOption(e);n=b.isObject(n)?x.clone(n):n,this.beginUpdate(),this._optionManager.setValue(P(e,n),!1),this.endUpdate()}}}).include(I);e.exports=R,e.exports.PostponedOperations=O},function(e,t,n){var i=n(7),o=i.hasWindow()?i.getWindow():{},a=n(62),r=1e3/60,s=function(e){return setTimeout(e,r)},l=function(e){clearTimeout(e)},u=a(function(){var e=o.requestAnimationFrame||o.webkitRequestAnimationFrame||o.mozRequestAnimationFrame||o.oRequestAnimationFrame||o.msRequestAnimationFrame,t=o.cancelAnimationFrame||o.webkitCancelAnimationFrame||o.mozCancelAnimationFrame||o.oCancelAnimationFrame||o.msCancelAnimationFrame;if(e&&t&&(s=e,l=t),e&&!t){var n={};s=function(t){var i=e.call(o,function(){try{if(i in n)return;t.apply(this,arguments)}finally{delete n[i]}});return i},l=function(e){n[e]=!0}}});t.requestAnimationFrame=function(){return u(),s.apply(o,arguments)},t.cancelAnimationFrame=function(){u(),l.apply(o,arguments)}},function(e,t,n){var i=n(182);e.exports=new i},function(e,t,n){var i=n(0);e.exports={_formatNumberCore:function(e,t,n){if("currency"===t){n.precision=n.precision||0;var o=this.format(e,(0,i.extend)({},n,{type:"fixedpoint"})),a=this.getCurrencySymbol().symbol.replace("$","$$$$");return o=o.replace(/^(\D*)(\d.*)/,"$1"+a+"$2")}return this.callBase.apply(this,arguments)},getCurrencySymbol:function(){return{symbol:"$"}},getOpenXmlCurrencyFormat:function(){return"$#,##0{0}_);\\($#,##0{0}\\)"}}},function(e,t,n){var i=n(2),o=n(4).noop,a=n(15),r=n(27),s=n(0).extend,l=n(8),u=a.inherit({ctor:function(e){this._$element=i(e),this._cancelCallback=r(),this._acceptCallback=r()},getElement:function(){return this._$element},validate:function(e){return!l.isDxMouseWheelEvent(e)},validatePointers:function(e){return 1===l.hasTouches(e)},allowInterruptionByMouseWheel:function(){return!0},configure:function(e){s(this,e)},addCancelCallback:function(e){this._cancelCallback.add(e)},removeCancelCallback:function(){this._cancelCallback.empty()},_cancel:function(e){this._cancelCallback.fire(this,e)},addAcceptCallback:function(e){this._acceptCallback.add(e)},removeAcceptCallback:function(){this._acceptCallback.empty()},_accept:function(e){this._acceptCallback.fire(this,e)},_requestAccept:function(e){this._acceptRequestEvent=e},_forgetAccept:function(){this._accept(this._acceptRequestEvent),this._acceptRequestEvent=null},start:o,move:o,end:o,cancel:o,reset:function(){this._acceptRequestEvent&&this._accept(this._acceptRequestEvent)},_fireEvent:function(e,t,n){var i=s({type:e,originalEvent:t,target:this._getEmitterTarget(t),delegateTarget:this.getElement().get(0)},n);return t=l.fireEvent(i),t.cancel&&this._cancel(t),t},_getEmitterTarget:function(e){return(this.delegateSelector?i(e.target).closest(this.delegateSelector):this.getElement()).get(0)},dispose:o});e.exports=u},function(e,t,n){function i(e){return e&&e.__esModule?e:{"default":e}}var o=n(73),a=i(o),r=n(77),s=i(r);if(a.default&&a.default.load){var l={supplemental:{version:{_cldrVersion:"28",_unicodeVersion:"8.0.0",_number:"$Revision: 11965 $"},likelySubtags:{en:"en-Latn-US",de:"de-Latn-DE",ru:"ru-Cyrl-RU",ja:"ja-Jpan-JP"}}};a.default.locale()||(a.default.load(l),a.default.locale("en")),s.default.inject({locale:function(e){return e?void a.default.locale(e):a.default.locale().locale}})}},function(e,t,n){e.exports=n(311)},function(e,t,n){e.exports=n(552)},function(e,t,n){function i(e){"@babel/helpers - typeof";return(i="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}var o=n(2),a=n(54),r=n(1).isDate,s=n(3).each,l=n(37),u=function(){return["year","day","month","day"]},c=6e4,d=60*c*24,h=365*d,f=function(e){var t=i(e);return"string"===t?"format":"object"===t&&void 0!==e.type?e.type:null},p={SUPPORTED_FORMATS:["date","time","datetime"],DATE_COMPONENT_TEXT_FORMATTER:function(e,t){var n=o("<div>").addClass("dx-dateview-formatter-container");return o("<span>").text(e).addClass("dx-dateview-value-formatter").appendTo(n),o("<span>").text(t).addClass("dx-dateview-name-formatter").appendTo(n),n},ONE_MINUTE:c,ONE_DAY:d,ONE_YEAR:h,MIN_DATEVIEW_DEFAULT_DATE:new Date(1900,0,1),MAX_DATEVIEW_DEFAULT_DATE:function(){var e=new Date;return new Date(e.getFullYear()+50,e.getMonth(),e.getDate(),23,59,59)}(),FORMATS_INFO:{date:{getStandardPattern:function(){return"yyyy-MM-dd"},components:u()},time:{getStandardPattern:function(){return"HH:mm"},components:["hours","minutes","seconds","milliseconds"]},datetime:{getStandardPattern:function(){var e;return function(){var t="yyyy-MM-ddTHH:mmZ",n="2000-01-01T01:01Z",i=o("<input>").attr("type","datetime");i.val(n),i.val()&&(e=t)}(),e||(e="yyyy-MM-ddTHH:mm:ssZ"),p.FORMATS_INFO.datetime.getStandardPattern=function(){return e},e},components:u().concat(["hours","minutes","seconds","milliseconds"])},"datetime-local":{getStandardPattern:function(){return"yyyy-MM-ddTHH:mm:ss"},components:u().concat(["hours","minutes","seconds"])}},FORMATS_MAP:{date:"shortdate",time:"shorttime",datetime:"shortdateshorttime"},SUBMIT_FORMATS_MAP:{date:"date",time:"time",datetime:"datetime-local"},toStandardDateFormat:function(e,t){var n=p.FORMATS_INFO[t].getStandardPattern();return a.serializeDate(e,n)},fromStandardDateFormat:function(e){var t=a.dateParser(e);return r(t)?t:void 0},getMaxMonthDay:function(e,t){return new Date(e,t+1,0).getDate()},mergeDates:function(e,t,n){if(!t)return t||null;if(!e||isNaN(e.getTime())){var i=new Date(null);e=new Date(i.getFullYear(),i.getMonth(),i.getDate())}var o=new Date(e.valueOf()),a=p.FORMATS_INFO[n];return s(a.components,function(){var e=p.DATE_COMPONENTS_INFO[this];o[e.setter](t[e.getter]())}),o},getLongestCaptionIndex:function(e){var t,n=0,i=0;for(t=0;t<e.length;++t)e[t].length>i&&(n=t,i=e[t].length);return n},formatUsesMonthName:function(e){return l.formatUsesMonthName(e)},formatUsesDayName:function(e){return l.formatUsesDayName(e)},getLongestDate:function(e,t,n){var i=f(e),o=9;i&&!p.formatUsesMonthName(i)||(o=p.getLongestCaptionIndex(t));var a=new Date(1888,o,21,23,59,59,999);if(!i||p.formatUsesDayName(i)){var r=a.getDate()-a.getDay()+p.getLongestCaptionIndex(n);a.setDate(r)}return a},normalizeTime:function(e){e.setSeconds(0),e.setMilliseconds(0)}};p.DATE_COMPONENTS_INFO={year:{getter:"getFullYear",setter:"setFullYear",formatter:function(e,t){var n=new Date(t.getTime());return n.setFullYear(e),l.format(n,"yyyy")},startValue:void 0,endValue:void 0},day:{getter:"getDate",setter:"setDate",formatter:function(e,t){var n=new Date(t.getTime());return n.setDate(e),l.format(n,"d")},startValue:1,endValue:void 0},month:{getter:"getMonth",setter:"setMonth",formatter:function(e){return l.getMonthNames()[e]},startValue:0,endValue:11},hours:{getter:"getHours",setter:"setHours",formatter:function(e){return l.format(new Date(0,0,0,e),"hour")},startValue:0,endValue:23},minutes:{getter:"getMinutes",setter:"setMinutes",formatter:function(e){return l.format(new Date(0,0,0,0,e),"minute")},startValue:0,endValue:59},seconds:{getter:"getSeconds",setter:"setSeconds",formatter:function(e){return l.format(new Date(0,0,0,0,0,e),"second")},startValue:0,endValue:59},milliseconds:{getter:"getMilliseconds",setter:"setMilliseconds",formatter:function(e){return l.format(new Date(0,0,0,0,0,0,e),"millisecond")},startValue:0,endValue:999}},e.exports=p},function(e,t,n){e.exports=n(574)},function(e,t,n){var i={notifyObserver:function(e,t){var n=this.option("observer");n&&n.fire(e,t)},invoke:function(){var e=this.option("observer");if(e)return e.fire.apply(e,arguments)}};e.exports=i},function(e,t,n){e.exports={events:{mouseover:"mouseover",mouseout:"mouseout",mousemove:"mousemove",touchstart:"touchstart",touchmove:"touchmove",touchend:"touchend",mousedown:"mousedown",mouseup:"mouseup",click:"click",selectSeries:"selectseries",deselectSeries:"deselectseries",selectPoint:"selectpoint",deselectPoint:"deselectpoint",showPointTooltip:"showpointtooltip",hidePointTooltip:"hidepointtooltip"},states:{hover:"hover",normal:"normal",selection:"selection",normalMark:0,hoverMark:1,selectedMark:2,applyHover:"applyHover",applySelected:"applySelected",resetItem:"resetItem"},radialLabelIndent:30,pieLabelSpacing:10,pieSeriesSpacing:4}},function(e,t,n){function i(e){return[-e,-e,e,-e,e,e,-e,e,-e,-e]}function o(e){var t=b(e);return[-t,0,0,-t,t,0,0,t,-t,0]}function a(e){var t=b(e),n=y(t/2),i=b(t/2);return[-t,-n,-n,-t,0,-i,n,-t,t,-n,i,0,t,n,n,t,0,i,-n,t,-t,n,-i,0]}function r(e){return[-e,-e,e,-e,0,e,-e,-e]}function s(e){return[-e,e,e,e,0,-e,-e,e]}var l=n(0).extend,u=n(3).each,c=n(4).noop,d=n(7),h=d.getWindow(),f=n(283),p=l,g=n(1).isDefined,_=n(13).normalizeEnum,m=Math,v=m.round,y=m.floor,b=m.ceil,x=20,w=20,C=10,k="canvas_position_default";e.exports={deleteLabel:function(){this._label.dispose(),this._label=null},_hasGraphic:function(){return this.graphic},clearVisibility:function(){var e=this,t=e.graphic;t&&t.attr("visibility")&&t.attr({visibility:null})},isVisible:function(){return this.inVisibleArea&&this.series.isVisible()},setInvisibility:function(){var e=this,t=e.graphic;t&&"hidden"!==t.attr("visibility")&&t.attr({visibility:"hidden"}),e._errorBar&&e._errorBar.attr({visibility:"hidden"}),e._label.draw(!1)},clearMarker:function(){var e=this.graphic;e&&e.attr(this._emptySettings)},_createLabel:function(){this._label=new f.Label({renderer:this.series._renderer,labelsGroup:this.series._labelsGroup,point:this})},_updateLabelData:function(){this._label.setData(this._getLabelFormatObject())},_updateLabelOptions:function(){!this._label&&this._createLabel(),this._label.setOptions(this._options.label)},_checkImage:function(e){return g(e)&&("string"==typeof e||g(e.url))},_fillStyle:function(){this._styles=this._options.styles},_checkSymbol:function(e,t){var n=e.symbol,i=t.symbol,o="circle"===n&&"circle"!==i||"circle"!==n&&"circle"===i,a=this._checkImage(e.image)!==this._checkImage(t.image);return!(!o&&!a)},_populatePointShape:function(e,t){switch(e){case"square":return i(t);case"polygon":return o(t);case"triangle":case"triangleDown":return r(t);case"triangleUp":return s(t);case"cross":return a(t)}},hasCoords:function(){return null!==this.x&&null!==this.y},correctValue:function(e){var t=this,n=t.series.getValueAxis();t.hasValue()&&(t.value=t.properValue=n.validateUnit(t.initialValue.valueOf()+e.valueOf()),t.minValue=n.validateUnit(e))},resetCorrection:function(){this.value=this.properValue=this.initialValue,this.minValue=k},resetValue:function(){var e=this;e.hasValue()&&(e.value=e.properValue=e.initialValue=0,e.minValue=0,e._label.setDataField("value",e.value))},_getTranslates:function(e){var t=this.x,n=this.y;return e&&(this._options.rotated?t=this.defaultX:n=this.defaultY),{x:t,y:n}},_createImageMarker:function(e,t,n){var i=n.width||x,o=n.height||w;return e.image(-v(.5*i),-v(.5*o),i,o,n.url?n.url.toString():n.toString(),"center").attr({translateX:t.translateX,translateY:t.translateY,visibility:t.visibility})},_createSymbolMarker:function(e,t){var n,i=this._options.symbol;return"circle"===i?(delete t.points,n=e.circle().attr(t)):"square"!==i&&"polygon"!==i&&"triangle"!==i&&"triangleDown"!==i&&"triangleUp"!==i&&"cross"!==i||(n=e.path([],"area").attr(t).sharp()),n},_createMarker:function(e,t,n,i){var o=this,a=o._checkImage(n)?o._createImageMarker(e,i,n):o._createSymbolMarker(e,i);return a&&a.data({"chart-data-point":o}).append(t),a},_getSymbolBBox:function(e,t,n){return{x:e-n,y:t-n,width:2*n,height:2*n}},_getImageBBox:function(e,t){var n=this._options.image,i=n.width||x,o=n.height||w;return{x:e-v(i/2),y:t-v(o/2),width:i,height:o}},_getGraphicBBox:function(){var e,t=this,n=t._options,i=t.x,o=t.y;return e=n.visible?t._checkImage(n.image)?t._getImageBBox(i,o):t._getSymbolBBox(i,o,n.styles.normal.r):{x:i,y:o,width:0,height:0}},hideInsideLabel:c,_getShiftLabelCoords:function(e){var t=this._addLabelAlignmentAndOffset(e,this._getLabelCoords(e));return this._checkLabelPosition(e,t)},_drawLabel:function(){var e=this,t=e._getCustomLabelVisibility(),n=e._label,i=e._showForZeroValues()&&e.hasValue()&&t!==!1&&(e.series.getLabelVisibility()||t);n.draw(!!i)},correctLabelPosition:function(e){var t=this,n=t._getShiftLabelCoords(e);t.hideInsideLabel(e,n)||(e.setFigureToDrawConnector(t._getLabelConnector(e.pointPosition)),e.shift(v(n.x),v(n.y)))},_showForZeroValues:function(){return!0},_getLabelConnector:function(e){var t=this._getGraphicBBox(e),n=t.width/2,i=t.height/2;return{x:t.x+n,y:t.y+i,r:this._options.visible?Math.max(n,i):0}},_getPositionFromLocation:function(){return{x:this.x,y:this.y}},_isPointInVisibleArea:function(e,t){return e.minX<=t.x+t.width&&e.maxX>=t.x&&e.minY<=t.y+t.height&&e.maxY>=t.y},_checkLabelPosition:function(e,t){var n=this,i=n._getVisibleArea(),o=e.getBoundingRect(),a=n._getGraphicBBox(e.pointPosition),r=n._getGraphicBBox(),s="inside"===e.getLayoutOptions().position,l=C;return n._isPointInVisibleArea(i,r)&&(n._options.rotated?(i.minX>t.x&&(t.x=s?i.minX:a.x+a.width+l),i.maxX<t.x+o.width&&(t.x=s?i.maxX-o.width:a.x-l-o.width),i.minY>t.y&&(t.y=i.minY),i.maxY<t.y+o.height&&(t.y=i.maxY-o.height)):(i.minX>t.x&&(t.x=i.minX),i.maxX<t.x+o.width&&(t.x=i.maxX-o.width),i.minY>t.y&&(t.y=s?i.minY:a.y+a.height+l),i.maxY<t.y+o.height&&(t.y=s?i.maxY-o.height:a.y-o.height-l))),t},_addLabelAlignmentAndOffset:function(e,t){var n=e.getBoundingRect(),i=e.getLayoutOptions();return this._options.rotated||("left"===i.alignment?t.x+=n.width/2:"right"===i.alignment&&(t.x-=n.width/2)),t.x+=i.horizontalOffset,t.y+=i.verticalOffset,t},_getLabelCoords:function(e){
return this._getLabelCoordOfPosition(e,this._getLabelPosition(e.pointPosition))},_getLabelCoordOfPosition:function(e,t){var n=this,i=e.getBoundingRect(),o=n._getGraphicBBox(e.pointPosition),a=C,r=o.height/2-i.height/2,s=o.width/2-i.width/2,l=o.x,u=o.y;switch(t){case"left":l-=i.width+a,u+=r;break;case"right":l+=o.width+a,u+=r;break;case"top":l+=s,u-=i.height+a;break;case"bottom":l+=s,u+=o.height+a;break;case"inside":l+=s,u+=r}return{x:l,y:u}},_drawMarker:function(e,t,n){var i=this,o=i._options,a=i._getTranslates(n),r=i._getStyle();i.graphic=i._createMarker(e,t,o.image,p({translateX:a.x,translateY:a.y,points:i._populatePointShape(o.symbol,r.r)},r))},_getErrorBarSettings:function(){return{visibility:"visible"}},_getErrorBarBaseEdgeLength:function(){return 2*this.getPointRadius()},_drawErrorBar:function(e,t){if(this._options.errorBars){var n,i=this,o=i._options,a=o.errorBars,r=[],s=i._errorBarPos,l=i._highErrorCoord,c=i._lowErrorCoord,d=_(a.displayMode),h="high"===d,f="low"===d,p=(h||!g(c))&&g(l)&&!f,m=(f||!g(l))&&g(c)&&!h,v=a.edgeLength;v<=1&&v>0&&(v=this._getErrorBarBaseEdgeLength()*a.edgeLength),v=y(parseInt(v)/2),p&&(c=i._baseErrorBarPos),m&&(l=i._baseErrorBarPos),"none"!==d&&g(l)&&g(c)&&g(s)?(!m&&r.push([s-v,l,s+v,l]),r.push([s,l,s,c]),!p&&r.push([s+v,c,s-v,c]),o.rotated&&u(r,function(e,t){t.reverse()}),n=i._getErrorBarSettings(a),i._errorBar?(n.points=r,i._errorBar.attr(n)):i._errorBar=e.path(r,"line").attr(n).append(t)):i._errorBar&&i._errorBar.attr({visibility:"hidden"})}},getTooltipParams:function(){var e=this,t=e.graphic;return{x:e.x,y:e.y,offset:t?t.getBBox().height/2:0}},setPercentValue:function(e,t,n,i){var o=this,a=o.value/e||0,r=o.minValue/e||0,s=a-r;o._label.setDataField("percent",s),o._label.setDataField("total",t),o.series.isFullStackedSeries()&&o.hasValue()&&(o.leftHole&&(o.leftHole/=e-n,o.minLeftHole/=e-n),o.rightHole&&(o.rightHole/=e-i,o.minRightHole/=e-i),o.value=o.properValue=a,o.minValue=r?r:o.minValue)},_storeTrackerR:function(){var e=this,t=h.navigator,n=e._options.styles.normal.r,i=d.hasProperty("ontouchstart")||t.msPointerEnabled&&t.msMaxTouchPoints||t.pointerEnabled&&t.maxTouchPoints?20:6;return e._options.trackerR=n<i?i:n,e._options.trackerR},_translateErrorBars:function(){var e=this,t=e._options,n=t.rotated,i=t.errorBars,o=e._getValTranslator();i&&(g(e.lowError)&&(e._lowErrorCoord=o.translate(e.lowError)),g(e.highError)&&(e._highErrorCoord=o.translate(e.highError)),e._errorBarPos=y(n?e.vy:e.vx),e._baseErrorBarPos="stdDeviation"===i.type?e._lowErrorCoord+(e._highErrorCoord-e._lowErrorCoord)/2:n?e.vx:e.vy)},_translate:function(){var e=this,t=e._getValTranslator(),n=e._getArgTranslator();e._options.rotated?(e.vx=e.x=t.translate(e.value),e.vy=e.y=n.translate(e.argument),e.minX=t.translate(e.minValue),e.defaultX=t.translate(k)):(e.vy=e.y=t.translate(e.value),e.vx=e.x=n.translate(e.argument),e.minY=t.translate(e.minValue),e.defaultY=t.translate(k)),e._translateErrorBars(),e._calculateVisibility(e.x,e.y)},_updateData:function(e){var t=this;t.value=t.properValue=t.initialValue=t.originalValue=e.value,t.minValue=t.initialMinValue=t.originalMinValue=g(e.minValue)?e.minValue:k},_getImageSettings:function(e){return{href:e.url||e.toString(),width:e.width||x,height:e.height||w}},getCrosshairData:function(){var e=this,t=e._options.rotated,n=e.properValue,i=e.argument;return{x:e.vx,y:e.vy,xValue:t?n:i,yValue:t?i:n,axis:e.series.axis}},getPointRadius:function(){var e,t=this._getStyle(),n=this._options,i=t.r,o=n.symbol,a="square"===o,r="triangle"===o||"triangleDown"===o||"triangleUp"===o;return n.visible&&!n.image&&i?(e=t["stroke-width"]/2,(a||r?1.4*i:i)+e):0},_updateMarker:function(e,t){var n,i=this,o=i._options,a=o.image,r=i.isVisible()?{}:{visibility:"hidden"};n=i._checkImage(a)?p({},{visibility:t.visibility},r,i._getImageSettings(a)):p({},t,r,{points:i._populatePointShape(o.symbol,t.r)}),e||(n.translateX=i.x,n.translateY=i.y),i.graphic.attr(n).sharp()},_getLabelFormatObject:function(){var e=this;return{argument:e.initialArgument,value:e.initialValue,originalArgument:e.originalArgument,originalValue:e.originalValue,seriesName:e.series.name,lowErrorValue:e.lowError,highErrorValue:e.highError,point:e}},_getLabelPosition:function(){var e=this._options.rotated;return this.initialValue>0?e?"right":"top":e?"left":"bottom"},_getFormatObject:function(e){var t=this,n=t._label.getData();return p({},n,{argumentText:e.formatValue(t.initialArgument,"argument"),valueText:e.formatValue(t.initialValue)},g(n.percent)?{percentText:e.formatValue(n.percent,"percent")}:{},g(n.total)?{totalText:e.formatValue(n.total)}:{})},getMarkerVisibility:function(){return this._options.visible},coordsIn:function(e,t){var n=this._storeTrackerR();return e>=this.x-n&&e<=this.x+n&&t>=this.y-n&&t<=this.y+n},getMinValue:function(e){var t=this._options.errorBars;if(t&&!e){var n=t.displayMode,i="high"!==n&&g(this.lowError)?this.lowError:this.value,o="low"!==n&&g(this.highError)?this.highError:this.value;return i<o?i:o}return this.value},getMaxValue:function(e){var t=this._options.errorBars;if(t&&!e){var n=t.displayMode,i="high"!==n&&g(this.lowError)?this.lowError:this.value,o="low"!==n&&g(this.highError)?this.highError:this.value;return i>o?i:o}return this.value}}},function(e,t,n){function i(e){var t=this,n=e.renderer;t._group=n.g().attr({"class":"dx-loading-indicator"}).linkOn(n.root,{name:"loading-indicator",after:"peripheral"}),t._rect=n.rect().attr({opacity:0}).append(t._group),t._text=n.text().attr({align:"center"}).append(t._group),t._createStates(e.eventTrigger,t._group,n.root,e.notify)}var o=n(13).patchFontOptions,a=0,r=1,s="linear",l=400,u="loadingIndicatorReady";i.prototype={constructor:i,_createStates:function(e,t,n,i){var o=this;o._states=[{opacity:0,start:function(){i(!1)},complete:function(){t.linkRemove(),n.css({"pointer-events":""}),e(u)}},{opacity:.85,start:function(){t.linkAppend(),n.css({"pointer-events":"none"}),i(!0)},complete:function(){e(u)}}],o._state=a},setSize:function(e){var t=e.width,n=e.height;this._rect.attr({width:t,height:n}),this._text.attr({x:t/2,y:n/2})},setOptions:function(e){this._rect.attr({fill:e.backgroundColor}),this._text.css(o(e.font)).attr({text:e.text,"class":e.cssClass}),this[e.show?"show":"hide"]()},dispose:function(){var e=this;e._group.linkRemove().linkOff(),e._group=e._rect=e._text=e._states=null},_transit:function(e){var t,n=this;n._state!==e&&(n._state=e,n._isHiding=!1,t=n._states[e],n._rect.stopAnimation().animate({opacity:t.opacity},{complete:t.complete,easing:s,duration:l,unstoppable:!0}),n._noHiding=!0,t.start(),n._noHiding=!1)},show:function(){this._transit(r)},hide:function(){this._transit(a)},scheduleHiding:function(){this._noHiding||(this._isHiding=!0)},fulfillHiding:function(){this._isHiding&&this.hide()}},t.LoadingIndicator=i,t.plugin={name:"loading_indicator",init:function(){function e(e){n._skipLoadingIndicatorOptions=!0,n.option("loadingIndicator",{show:e}),n._skipLoadingIndicatorOptions=!1,e&&n._stopCurrentHandling()}var n=this;n._loadingIndicator=new t.LoadingIndicator({eventTrigger:n._eventTrigger,renderer:n._renderer,notify:e}),n._scheduleLoadingIndicatorHiding()},dispose:function(){this._loadingIndicator.dispose(),this._loadingIndicator=null},members:{_scheduleLoadingIndicatorHiding:function(){this._loadingIndicator.scheduleHiding()},_fulfillLoadingIndicatorHiding:function(){this._loadingIndicator.fulfillHiding()},showLoadingIndicator:function(){this._loadingIndicator.show()},hideLoadingIndicator:function(){this._loadingIndicator.hide()},_onBeginUpdate:function(){this._optionChangedLocker||this._scheduleLoadingIndicatorHiding()}},extenders:{_dataSourceLoadingChangedHandler:function(e){e&&(this._options.loadingIndicator||{}).enabled&&this._loadingIndicator.show()},_setContentSize:function(){this._loadingIndicator.setSize(this._canvas)},endUpdate:function(){this._initialized&&this._dataIsReady()&&this._fulfillLoadingIndicatorHiding()}},customize:function(e){var t=e.prototype;if(t._dataSourceChangedHandler){var n=t._dataSourceChangedHandler;t._dataSourceChangedHandler=function(){this._scheduleLoadingIndicatorHiding(),n.apply(this,arguments)}}e.addChange({code:"LOADING_INDICATOR",handler:function(){this._skipLoadingIndicatorOptions||this._loadingIndicator.setOptions(this._getOption("loadingIndicator")),this._scheduleLoadingIndicatorHiding()},isThemeDependent:!0,option:"loadingIndicator",isOptionChange:!0}),t._eventsMap.onLoadingIndicatorReady={name:"loadingIndicatorReady"};var i=t._drawn;t._drawn=function(){i.apply(this,arguments),this._dataIsReady()&&this._fulfillLoadingIndicatorHiding()}},fontFields:["loadingIndicator.font"]}},function(e,t,n){var i,o=n(1).isFunction,a=n(13).normalizeEnum,r=Math.round,s={};t.getAlgorithm=function(e){return s[a(e)]||o(e)&&e||i},t.addAlgorithm=function(e,t){s[e]=t},t.setDefaultAlgorithm=function(e){i=s[e]};var l={};l[-1]=[2,0],l[1]=[0,2];var u=function(e){return e[2]-e[0]<e[3]-e[1]?0:1};t.getStaticSideIndex=u,t.buildSidesData=function(e,t,n){var i=void 0!==n?n:u(e),o=1-i,a=t[i],r=t[o],s=l[a],c=l[r];return{staticSide:e[2+i]-e[i],variedSide:e[2+o]-e[o],static1:i+s[0],static2:i+s[1],varied1:o+c[0],varied2:o+c[1],staticDir:a,variedDir:r}},t.calculateRectangles=function(e,t,n,i,o){var a,s,l,u,c=[0,0,0,0],d=i.static1,h=i.static2,f=n[d],p=i.staticDir,g=i.staticSide,_=o.sum;for(c[i.varied1]=n[i.varied1],c[i.varied2]=n[i.varied1]+i.variedDir*o.side,a=t,s=t+o.count;a<s;++a)l=c.slice(),l[d]=f,u=r(g*e[a].value/_)||0,_-=e[a].value,g-=u,f+=p*u,l[h]=f,e[a].rect=l;n[i.varied1]=c[i.varied2]}},function(e,t,n){function i(e){return function(t){return t.isNode()?void 0:e(t)}}function o(e){return function(t){var n=!t.isNode()&&t.parent;return n?n._groupColor=n._groupColor||e(n):void 0}}function a(e){return e.value}function r(e){return function(t){return Number(t.data[e])}}var s,l=n(13).normalizeEnum,u=n(4).noop,c={};t.getColorizer=function(e,t,n){var a=l(e.type||s),r=c[a]&&c[a](e,t,n);return r?(e.colorizeGroups?o:i)(r):u},t.addColorizer=function(e,t){c[e]=t},t.setDefaultColorizer=function(e){s=e},t.createColorCodeGetter=function(e){return e.colorCodeField?r(e.colorCodeField):a}},function(e,t,n){var i=n(0).extend,o=n(64),a=n(43),r=n(129),s="http://js.devexpress.com/error/"+r.split(".").slice(0,2).join("_")+"/";e.exports=function(e,t){var n={ERROR_MESSAGES:i(t,e),Error:function(){return c([].slice.call(arguments))},log:function(e){var t="log";/^E\d+$/.test(e)?t="error":/^W\d+$/.test(e)&&(t="warn"),o.logger[t]("log"===t?e:r([].slice.call(arguments)))}},r=function(e){var t=e[0];return e=e.slice(1),u(t,l(t,e))},l=function(e,t){return t=[n.ERROR_MESSAGES[e]].concat(t),a.format.apply(this,t).replace(/\.*\s*?$/,"")},u=function(e,t){return a.format.apply(this,["{0} - {1}. See:\n{2}",e,t,d(e)])},c=function(e){var t=e[0];e=e.slice(1);var n=l(t,e),o=d(t),a=u(t,n);return i(new Error(a),{__id:t,__details:n,url:o})},d=function(e){return s+e};return n}},function(e,t,n){e.exports="19.2.11"},function(e,t,n){var i=n(7),o=n(11),a=n(27),r=n(52),s=n(62),l=function(){var e,t=a(),n=t.add,l=t.remove;if(!i.hasWindow())return t;var u,c=function(){var e=i.getWindow();return{width:e.innerWidth,height:e.innerHeight}},d=function(){var n=c();if(n.width!==e.width||n.height!==e.height){var i;n.width===e.width&&(i="height"),n.height===e.height&&(i="width"),e=n,t.fire(i)}},h=s(function(){e=c()});return t.add=function(){var e=n.apply(t,arguments);return h(),r.add(function(){!u&&t.has()&&(u=o.listen(i.getWindow(),"resize",d))}),e},t.remove=function(){var e=l.apply(t,arguments);return!t.has()&&u&&(u(),u=void 0),e},t}();e.exports=l},function(e,t,n){var i=n(39),o=n(5),a=n(181),r=n(1).isDefined,s=n(137),l="dxComponents",u="dxPrivateComponent",c=new a,d=0,h=t.name=function(e,t){if(r(t))return void c.set(e,t);if(!c.has(e)){var n=u+d++;return c.set(e,n),n}return c.get(e)};t.attachInstanceToElement=function(e,t,n){var a=i.data(e.get(0)),r=h(t.constructor);a[r]=t,n&&o.one(e,s,function(){n.call(t)}),a[l]||(a[l]=[]),a[l].push(r)},t.getInstanceByElement=function(e,t){var n=h(t);return i.data(e.get(0),n)}},function(e,t,n){function i(e){return e&&e.__esModule?e:{"default":e}}var o=n(2),a=i(o),r=n(5),s=i(r),l=n(69),u=i(l),c=n(8),d="dxmousewheel",h="dxWheel",f="wheel",p=0,g=30,_={setup:function(e){var t=(0,a.default)(e);s.default.on(t,(0,c.addNamespace)(f,h),_._wheelHandler.bind(_))},teardown:function(e){s.default.off(e,".".concat(h))},_wheelHandler:function(e){var t=e.originalEvent,n=t.deltaMode,i=t.deltaY,o=t.deltaX,a=t.deltaZ;(0,c.fireEvent)({type:d,originalEvent:e,delta:this._normalizeDelta(i,n),deltaX:o,deltaY:i,deltaZ:a,deltaMode:n,pointerType:"mouse"}),e.stopPropagation()},_normalizeDelta:function(e){var t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:p;return t===p?-e:-g*e}};(0,u.default)(d,_),t.name=d},function(e,t,n){var i,o=n(15),a=n(4),r=n(12).contains,s=n(16),l=n(8),u=n(24),c=n(116),d=n(91),h="dxactive",f="dxinactive",p=30,g=400,_=o.inherit({ctor:function(e,t){this._timeout=e,this._fire=t},start:function(){var e=this;this._schedule(function(){e.force()})},_schedule:function(e){this.stop(),this._timer=setTimeout(e,this._timeout)},stop:function(){clearTimeout(this._timer)},force:function(){this._fired||(this.stop(),this._fire(),this._fired=!0)},fired:function(){return this._fired}}),m=c.inherit({ctor:function(){this.callBase.apply(this,arguments),this._active=new _(0,a.noop),this._inactive=new _(0,a.noop)},configure:function(e,t){switch(t){case h:e.activeTimeout=e.timeout;break;case f:e.inactiveTimeout=e.timeout}this.callBase(e)},start:function(e){if(i){var t=r(this.getElement().get(0),i.getElement().get(0)),n=!i._active.fired();if(t&&n)return void this._cancel();i._inactive.force()}i=this,this._initEvents(e),this._active.start()},_initEvents:function(e){var t=this,n=this._getEmitterTarget(e),o=l.isMouseEvent(e),r=s.isSimulator(),u=r||!o,c=a.ensureDefined(this.activeTimeout,p),d=a.ensureDefined(this.inactiveTimeout,g);this._active=new _(u?c:0,function(){t._fireEvent(h,e,{target:n})}),this._inactive=new _(u?d:0,function(){t._fireEvent(f,e,{target:n}),i=null})},cancel:function(e){this.end(e)},end:function(e){var t=e.type!==u.up;t?this._active.stop():this._active.force(),this._inactive.start(),t&&this._inactive.force()},dispose:function(){this._active.stop(),this._inactive.stop(),this.callBase()},lockInactive:function(){return this._active.force(),this._inactive.stop(),i=null,this._cancel(),this._inactive.force.bind(this._inactive)}});m.lock=function(e){var t=i?i.lockInactive():a.noop;e.done(t)},d({emitter:m,events:[h,f]}),t.lock=m.lock,t.active=h,t.inactive=f},function(e,t,n){var i=n(2),o=n(15),a=n(3).each,r=n(131),s="dx-state-invisible",l="dx-state-disabled",u="dx-item-content-placeholder",c=function(e,t,n){var i=function(){var e;return function(t){e!==t&&(n(t,e),e=t)}}();return{dispose:e(t,i),force:function(){i(t())}}},d=o.inherit({ctor:function(e,t,n){this._$element=e,this._options=t,this._rawData=n,r.attachInstanceToElement(e,this,this._dispose),this._render()},_render:function(){var e=i("<div>").addClass(u);this._$element.append(e),this._watchers=[],this._renderWatchers()},_renderWatchers:function(){this._startWatcher("disabled",this._renderDisabled.bind(this)),this._startWatcher("visible",this._renderVisible.bind(this))},_startWatcher:function(e,t){var n=this._rawData,i=this._options.fieldGetter(e),o=c(this._options.watchMethod(),function(){return i(n)},function(e,n){this._dirty=!0,t(e,n)}.bind(this));this._watchers.push(o)},setDataField:function(){if(this._dirty=!1,a(this._watchers,function(e,t){t.force()}),this._dirty)return!0},_renderDisabled:function(e,t){this._$element.toggleClass(l,!!e),this._updateOwnerFocus(e)},_updateOwnerFocus:function(e){var t=this._options.owner;t&&e&&t._resetItemFocus(this._$element)},_renderVisible:function(e,t){this._$element.toggleClass(s,void 0!==e&&!e)},_dispose:function(){a(this._watchers,function(e,t){t.dispose()})}});d.getInstance=function(e){return r.getInstanceByElement(e,this)},e.exports=d},function(e,t,n){var i=n(5),o=n(12),a=n(11),r=n(15),s=n(69),l=n(19),u=n(8),c="dxdblclick",d="dxDblClick",h=u.addNamespace(l.name,d),f=300,p=r.inherit({ctor:function(){this._handlerCount=0,this._forgetLastClick()},_forgetLastClick:function(){this._firstClickTarget=null,this._lastClickTimeStamp=-f},add:function(){this._handlerCount<=0&&i.on(a.getDocument(),h,this._clickHandler.bind(this)),this._handlerCount++},_clickHandler:function(e){var t=e.timeStamp||Date.now();t-this._lastClickTimeStamp<f?(u.fireEvent({type:c,target:o.closestCommonParent(this._firstClickTarget,e.target),originalEvent:e}),this._forgetLastClick()):(this._firstClickTarget=e.target,this._lastClickTimeStamp=t)},remove:function(){this._handlerCount--,this._handlerCount<=0&&(this._forgetLastClick(),i.off(a.getDocument(),h))}});s(c,new p),t.name=c},function(e,t,n){var i=n(7),o=i.getWindow(),a=o.DevExpress=o.DevExpress||{},r=a.errors=n(21);if(a._DEVEXTREME_BUNDLE_INITIALIZED)throw r.Error("E0024");a._DEVEXTREME_BUNDLE_INITIALIZED=!0,a.clientExporter=n(177),a.excelExporter=n(461),a.VERSION=n(129),a.Class=n(15),a.DOMComponent=n(86),a.registerComponent=n(9),a.devices=n(16),a.Color=n(87);var s=n(113);a.EventsMixin=n(83),a.utils={},a.utils.requestAnimationFrame=s.requestAnimationFrame,a.utils.cancelAnimationFrame=s.cancelAnimationFrame,a.utils.initMobileViewport=n(466).initMobileViewport,a.utils.extendFromObject=n(0).extendFromObject,a.utils.createComponents=n(12).createComponents,a.utils.triggerShownEvent=n(12).triggerShownEvent,a.utils.triggerHidingEvent=n(12).triggerHidingEvent,a.utils.resetActiveElement=n(12).resetActiveElement,a.utils.findBestMatches=n(4).findBestMatches,a.createQueue=n(228).create,a.utils.dom=n(12),a.utils.common=n(4),a.utils.date=n(25),a.utils.browser=n(23),a.utils.inflector=n(33),a.utils.iterator=n(3),a.utils.readyCallbacks=n(52),a.utils.resizeCallbacks=n(130),a.utils.console=n(64),a.utils.string=n(43),a.utils.support=n(45),a.utils.ajax=n(63),a.viewPort=n(74).value,a.hideTopOverlay=n(214),a.formatHelper=n(65),a.config=n(28),a.animationPresets=n(184).presets,a.fx=n(40),a.TransitionExecutor=n(292).TransitionExecutor,a.AnimationPresetCollection=n(184).PresetCollection,a.events=n(293),a.events.click=n(19),a.events.utils=n(8),a.events.GestureEmitter=n(159),a.localization=n(469),a.templateRendered=n(70).renderedCallbacks,a.setTemplateEngine=n(160).setTemplateEngine,e.exports=a},function(e,t,n){var i=n(2),o=n(39).beforeCleanData,a=n(5),r=n(69),s="dxremove",l="dxRemoveEvent";o(function(e){e=[].slice.call(e);for(var t=0;t<e.length;t++){var n=i(e[t]);n.prop(l)&&(n[0][l]=null,a.triggerHandler(n,s))}}),r(s,{noBubble:!0,setup:function(e){i(e).prop(l,!0)}}),e.exports=s},function(e,t,n){function i(e){return e&&e.__esModule?e:{"default":e}}function o(e){"@babel/helpers - typeof";return(o="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}function a(e,t){for(var n="string"==typeof t?t.split():t.slice();n.length;){var i=n.shift();if(i in e)return!0}return!1}function r(e,t,n,i){if(i)for(var o=0;o<t.length;o++){var a=t[o].items||t[o].collapsedItems||[],s=r(e,a||[],n,i-1);if(s)return s}else if(_(e,t,n)>=0)return t}function s(e,t,n,i){return i?r(e,t,n,i)||[]:t}function l(e,t){if(e.key()&&(!t._dataByKeyMap||t._dataByKeyMapLength!==t.length)){for(var n={},i=0,o=t.length;i<o;i++)n[JSON.stringify(e.keyOf(t[i]))]=t[i];t._dataByKeyMap=n,t._dataByKeyMapLength=o}}function u(e,t){if(e._dataByKeyMap)return e._dataByKeyMap[JSON.stringify(t)]}function c(e,t){return!e._dataByKeyMap||e._dataByKeyMap[JSON.stringify(t)]}function d(e,t,n){e._dataByKeyMap&&(e._dataByKeyMap[JSON.stringify(t)]=n)}function h(e,t,n,i,o){n.forEach(function(n){var a="insert"===n.type?t:s(e,t,n.key,i);switch(l(e,a),n.type){case"update":f(e,a,n.key,n.data,!0);break;case"insert":p(e,a,n.data,o&&(0,m.isDefined)(n.index)?n.index:-1,!0);break;case"remove":g(e,a,n.key,!0)}})}function f(e,t,n,i,o){var r,s=!0,l=e.key();if(l){if(a(i,l)&&!(0,I.keysEqual)(n,e.keyOf(i)))return!o&&(0,I.rejectedPromise)(C.errors.Error("E4017"));if(r=u(t,n),!r){var c=_(e,t,n);if(c<0)return!o&&(0,I.rejectedPromise)(C.errors.Error("E4009"));r=t[c]}}else r=n;if(S.default.deepExtendArraySafe(r,i,s),!o)return(0,y.default)().useLegacyStoreResult?(0,I.trivialPromise)(n,i):(0,I.trivialPromise)(r,n)}function p(e,t,n,i,a){var r,s=e.key(),l=(0,m.isPlainObject)(n)?(0,w.extend)({},n):n;if(s){if(r=e.keyOf(l),void 0===r||"object"===o(r)&&(0,m.isEmptyObject)(r)){if(Array.isArray(s))throw C.errors.Error("E4007");r=l[s]=String(new x.default)}else if(void 0!==t[_(e,t,r)])return!a&&(0,I.rejectedPromise)(C.errors.Error("E4008"))}else r=l;if(i>=0?t.splice(i,0,l):t.push(l),d(t,r,l),!a)return(0,I.trivialPromise)((0,y.default)().useLegacyStoreResult?n:l,r)}function g(e,t,n,i){var o=_(e,t,n);if(o>-1&&t.splice(o,1),!i)return(0,I.trivialPromise)(n)}function _(e,t,n){if(!c(t,n))return-1;for(var i=0,o=t.length;i<o;i++)if((0,I.keysEqual)(e.keyOf(t[i]),n))return i;return-1}var m=n(1),v=n(28),y=i(v),b=n(35),x=i(b),w=n(0),C=n(38),k=n(48),S=i(k),I=n(42);e.exports.applyBatch=h,e.exports.update=f,e.exports.insert=p,e.exports.remove=g,e.exports.indexByKey=_},function(e,t,n){function i(e){"@babel/helpers - typeof";return(i="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}function o(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}function a(e,t){if("function"!=typeof t&&null!==t)throw new TypeError("Super expression must either be null or a function");e.prototype=Object.create(t&&t.prototype,{constructor:{value:e,writable:!0,configurable:!0}}),t&&r(e,t)}function r(e,t){return(r=Object.setPrototypeOf||function(e,t){return e.__proto__=t,e})(e,t)}function s(e){var t=c();return function(){var n,i=d(e);if(t){var o=d(this).constructor;n=Reflect.construct(i,arguments,o)}else n=i.apply(this,arguments);return l(this,n)}}function l(e,t){return!t||"object"!==i(t)&&"function"!=typeof t?u(e):t}function u(e){if(void 0===e)throw new ReferenceError("this hasn't been initialised - super() hasn't been called");return e}function c(){if("undefined"==typeof Reflect||!Reflect.construct)return!1;if(Reflect.construct.sham)return!1;if("function"==typeof Proxy)return!0;try{return Date.prototype.toString.call(Reflect.construct(Date,[],function(){})),!0}catch(e){return!1}}function d(e){return(d=Object.setPrototypeOf?Object.getPrototypeOf:function(e){return e.__proto__||Object.getPrototypeOf(e)})(e)}Object.defineProperty(t,"__esModule",{value:!0}),t.ChildDefaultTemplate=void 0;var h=n(70);t.ChildDefaultTemplate=function(e){function t(e){var i;return o(this,t),i=n.call(this),i.name=e,i}a(t,e);var n=s(t);return t}(h.TemplateBase)},function(e,t,n){var i=n(5),o=n(39),a=n(15),r=n(16),s=n(69),l=n(8),u=n(24),c="dxHoverStart",d="dxhoverstart",h=l.addNamespace(u.enter,c),f="dxHoverEnd",p="dxhoverend",g=l.addNamespace(u.leave,f),_=a.inherit({noBubble:!0,ctor:function(){this._handlerArrayKeyPath=this._eventNamespace+"_HandlerStore"},setup:function(e){o.data(e,this._handlerArrayKeyPath,{})},add:function(e,t){var n=this,a=function(e){n._handler(e)};i.on(e,this._originalEventName,t.selector,a),o.data(e,this._handlerArrayKeyPath)[t.guid]=a},_handler:function(e){l.isTouchEvent(e)||r.isSimulator()||l.fireEvent({type:this._eventName,originalEvent:e,delegateTarget:e.delegateTarget})},remove:function(e,t){var n=o.data(e,this._handlerArrayKeyPath)[t.guid];i.off(e,this._originalEventName,t.selector,n)},teardown:function(e){o.removeData(e,this._handlerArrayKeyPath)}}),m=_.inherit({ctor:function(){this._eventNamespace=c,this._eventName=d,this._originalEventName=h,this.callBase()},_handler:function(e){var t=e.pointers||[];t.length||this.callBase(e)}}),v=_.inherit({ctor:function(){this._eventNamespace=f,this._eventName=p,this._originalEventName=g,this.callBase()}});s(d,new m),s(p,new v),t.start=d,t.end=p},function(e,t,n){function i(e){return e&&m(e.then)}function o(e){return(new k).resolve(e).promise()}function a(e,t){if(!m(t))throw y.Error("E4011",e)}function r(e){throw y.Error("E4012",e)}function s(e){function t(e){var t=e[0],n=e[1];return t&&t.getResponseHeader?g.errorMessageFromXhr(t,n):null}return function(n){var i;i=n instanceof Error?n:new Error(t(arguments)||n&&String(n)||"Unknown error"),i.message!==g.XHR_ERROR_UNLOAD&&e.reject(i)}}function l(e,t){var n,s=e._loadFunc;return a(T,s),n=s.apply(e,[t]),Array.isArray(n)?n=o(n):null===n||void 0===n?n=o([]):i(n)||r(T),I(n)}function u(e,t){var n,a=e._totalCountFunc;if(!m(a))throw y.Error("E4021");return n=a.apply(e,[t]),i(n)||(n=Number(n),isFinite(n)||r(D),n=o(n)),I(n)}function c(e,t,n){var r,s=e._byKeyFunc;return a(E,s),r=s.apply(e,[t,n]),i(r)||(r=o(r)),I(r)}function d(e,t,n,i){if(t.__rawData)i(t.__rawData);else{var o=t.__rawDataPromise||l(t,n);t._cacheRawData&&(t.__rawDataPromise=o),o.always(function(){delete t.__rawDataPromise}).done(function(e){t._cacheRawData&&(t.__rawData=e),i(e)}).fail(s(e))}}function h(e,t,n,i){n=n||{};var o={};"userData"in n&&(o.userData=n.userData),d(e,t,o,function(o){var a,r,s,l,u=x(o,{errorHandler:t._errorHandler}),c=[];i||(a=w(u,n),a===u?s=o.slice(0):c.push(a.enumerate().done(function(e){s=e}))),(n.requireTotalCount||i)&&(r=w(u,n,!0),r===u?l=o.length:c.push(r.count().done(function(e){l=e}))),S.apply(p,c).done(function(){i?e.resolve(l):n.requireTotalCount?e.resolve(s,{totalCount:l}):e.resolve(s)}).fail(function(t){e.reject(t)})})}function f(e,t,n){d(e,t,{},function(i){for(var o,a=0,r=i.length;a<r;a++)if(o=i[a],g.keysEqual(t.keyOf(i[a]),n))return void e.resolve(o);e.reject(y.Error("E4009"))})}var p=n(2),g=n(42),_=n(138),m=n(1).isFunction,v=n(28),y=n(38).errors,b=n(92),x=n(157),w=n(85).queryByOptions,C=n(6),k=C.Deferred,S=C.when,I=C.fromPromise,D="totalCount",T="load",E="byKey",A="insert",O="update",P="remove",R=b.inherit({ctor:function(e){e=e||{},this.callBase(e),this._useDefaultSearch=!!e.useDefaultSearch||"raw"===e.loadMode,this._loadMode=e.loadMode,this._cacheRawData=e.cacheRawData!==!1,this._loadFunc=e[T],this._totalCountFunc=e[D],this._byKeyFunc=e[E],this._insertFunc=e[A],this._updateFunc=e[O],this._removeFunc=e[P]},createQuery:function(){throw y.Error("E4010")},clearRawDataCache:function(){delete this.__rawData},_totalCountImpl:function(e){var t=new k;return"raw"!==this._loadMode||this._totalCountFunc?(u(this,e).done(function(e){t.resolve(Number(e))}).fail(s(t)),t=this._addFailHandlers(t)):h(t,this,e,!0),t.promise()},_pushImpl:function(e){this.__rawData&&_.applyBatch(this,this.__rawData,e)},_loadImpl:function(e){var t=new k;return"raw"===this._loadMode?h(t,this,e,!1):(l(this,e).done(function(e,n){t.resolve(e,n)}).fail(s(t)),t=this._addFailHandlers(t)),t.promise()},_byKeyImpl:function(e,t){var n=new k;return this._byKeyViaLoad()?(this._requireKey(),f(n,this,e)):c(this,e,t).done(function(e){n.resolve(e)}).fail(s(n)),n.promise()},_byKeyViaLoad:function(){return"raw"===this._loadMode&&!this._byKeyFunc},_insertImpl:function(e){var t,n=this,r=n._insertFunc,l=new k;return a(A,r),t=r.apply(n,[e]),i(t)||(t=o(t)),I(t).done(function(t){v().useLegacyStoreResult?l.resolve(e,t):l.resolve(t||e,n.keyOf(t))}).fail(s(l)),l.promise()},_updateImpl:function(e,t){var n,r=this._updateFunc,l=new k;return a(O,r),n=r.apply(this,[e,t]),i(n)||(n=o(n)),I(n).done(function(n){v().useLegacyStoreResult?l.resolve(e,t):l.resolve(n||t,e)}).fail(s(l)),l.promise()},_removeImpl:function(e){var t,n=this._removeFunc,r=new k;return a(P,n),t=n.apply(this,[e]),i(t)||(t=o()),I(t).done(function(){r.resolve(e)}).fail(s(r)),r.promise()}});e.exports=R},function(e,t,n){function i(e){"@babel/helpers - typeof";return(i="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}var o=n(2),a=n(7),r=a.getWindow(),s=n(12).getPublicElement,l=n(11),u=n(5),c=n(9),d=n(4),h=n(0).extend,f=n(23),p=n(29),g=n(79),_=n(1),m=n(31),v=n(8),y=n(46),b=n(22).getBoundingRect,x="dx-popover",w="dx-popover-wrapper",C="dx-popover-arrow",k="dx-popover-without-title",S={left:"right",top:"bottom",right:"left",bottom:"top",center:"center"},I={left:-1,top:-1,center:0,right:1,bottom:1},D={top:{my:"bottom center",at:"top center",collision:"fit flip"},bottom:{my:"top center",at:"bottom center",collision:"fit flip"},right:{my:"left center",at:"right center",collision:"flip fit"},left:{my:"right center",at:"left center",collision:"flip fit"}},T={left:"borderLeftWidth",top:"borderTopWidth",right:"borderRightWidth",bottom:"borderBottomWidth"},E=f.mozilla,A=function(e,t){var n=e.option(t);return O(n)},O=function(e){return _.isObject(e)?e.name:e},P=function(e,t){var n=e.option(t);return _.isObject(n)&&n.delay},R=function(e,t){var n=e.option("target"),i=_.isString(n),a=A(e,t+"Event");if(a&&!e.option("disabled")){var r=v.addNamespace(a,e.NAME),c=e._createAction(function(){var n=P(e,t+"Event");this._clearEventsTimeouts(),n?this._timeouts[t]=setTimeout(function(){e[t]()},n):e[t]()}.bind(e),{validatingTargetName:"target"}),d=function(e){c({event:e,target:o(e.currentTarget)})},h="_"+t+"EventHandler";if(i)e[h]=d,u.on(l.getDocument(),r,n,d);else{var f=s(o(n));e[h]=void 0,u.on(f,r,d)}}},B=function(e,t,n,i){var a=i||A(e,n+"Event");if(a){a=v.addNamespace(a,e.NAME);var r="_"+n+"EventHandler";e[r]?u.off(l.getDocument(),a,t,e[r]):u.off(s(o(t)),a)}},M=y.inherit({_getDefaultOptions:function(){return h(this.callBase(),{target:r,shading:!1,position:"bottom",closeOnOutsideClick:!0,animation:{show:{type:"fade",from:0,to:1},hide:{type:"fade",to:0}},showTitle:!1,width:"auto",height:"auto",dragEnabled:!1,resizeEnabled:!1,fullScreen:!1,closeOnTargetScroll:!0,arrowPosition:"",arrowOffset:0,boundaryOffset:{h:10,v:10}})},_defaultOptionsRules:function(){return[{device:{platform:"ios"},options:{arrowPosition:{boundaryOffset:{h:20,v:-10},collision:"fit"}}},{device:function(){return!a.hasWindow()},options:{animation:null}}]},_init:function(){this.callBase(),this._renderArrow(),this._timeouts={},this.$element().addClass(x),this._wrapper().addClass(w)},_render:function(){this.callBase.apply(this,arguments),this._detachEvents(this.option("target")),this._attachEvents()},_detachEvents:function(e){B(this,e,"show"),B(this,e,"hide")},_attachEvents:function(){R(this,"show"),R(this,"hide")},_renderArrow:function(){this._$arrow=o("<div>").addClass(C).prependTo(this.overlayContent())},_documentDownHandler:function(e){return!this._isOutsideClick(e)||this.callBase(e)},_isOutsideClick:function(e){return!o(e.target).closest(this.option("target")).length},_animate:function(e){e&&e.to&&"object"===i(e.to)&&h(e.to,{position:this._getContainerPosition()}),this.callBase.apply(this,arguments)},_stopAnimation:function(){this.callBase.apply(this,arguments)},_renderTitle:function(){this._wrapper().toggleClass(k,!this.option("showTitle")),this.callBase()},_renderPosition:function(){this.callBase(),this._renderOverlayPosition()},_renderOverlayBoundaryOffset:d.noop,_renderOverlayPosition:function(){this._resetOverlayPosition(),this._updateContentSize();var e=this._getContainerPosition(),t=g.setup(this._$content,e),n=this._getSideByLocation(t);this._togglePositionClass("dx-position-"+n),this._toggleFlippedClass(t.h.flip,t.v.flip);var i=this._isHorizontalSide()||this._isVerticalSide();i&&this._renderArrowPosition(n)},_resetOverlayPosition:function(){this._setContentHeight(!0),this._togglePositionClass("dx-position-"+this._positionSide),p.move(this._$content,{left:0,top:0}),this._$arrow.css({top:"auto",right:"auto",bottom:"auto",left:"auto"})},_updateContentSize:function(){if(this._$popupContent){var e=g.calculate(this._$content,this._getContainerPosition());if(e.h.oversize>0&&this._isHorizontalSide()&&!e.h.fit){var t=this._$content.width()-e.h.oversize;this._$content.width(t)}if(e.v.oversize>0&&this._isVerticalSide()&&!e.v.fit){
var n=this._$content.height()-e.v.oversize,i=this._$popupContent.height()-e.v.oversize;this._$content.height(n),this._$popupContent.height(i)}}},_getContainerPosition:function(){var e=d.pairToObject(this._position.offset||""),t=e.h,n=e.v,i=this._isVerticalSide(),o=this._isHorizontalSide();if(i||o){var a=this._isPopoverInside(),r=(a?-1:1)*I[this._positionSide],s=i?this._$arrow.height():this._$arrow.width(),l=this._getContentBorderWidth(this._positionSide),u=r*(s-l);i?n+=u:t+=u}return h({},this._position,{offset:t+" "+n})},_getContentBorderWidth:function(e){var t=this._$content.css(T[e]);return parseInt(t)||0},_getSideByLocation:function(e){var t=e.v.flip,n=e.h.flip;return this._isVerticalSide()&&t||this._isHorizontalSide()&&n||this._isPopoverInside()?S[this._positionSide]:this._positionSide},_togglePositionClass:function(e){this._$wrapper.removeClass("dx-position-left dx-position-right dx-position-top dx-position-bottom").addClass(e)},_toggleFlippedClass:function(e,t){this._$wrapper.toggleClass("dx-popover-flipped-horizontal",e).toggleClass("dx-popover-flipped-vertical",t)},_renderArrowPosition:function(e){var t=b(this._$arrow.get(0)),n=-(this._isVerticalSide(e)?t.height:t.width);this._$arrow.css(S[e],n);var i,a=this._isVerticalSide(e)?"left":"top",r=this._isVerticalSide(e)?"width":"height",s=o(this._position.of),l=g.offset(s)||{top:0,left:0},u=g.offset(this._$content),c=t[r],d=u[a],h=b(this._$content.get(0))[r],f=l[a],p=s.get(0).preventDefault?0:b(s.get(0))[r],_=Math.max(d,f),v=Math.min(d+h,f+p);i="start"===this.option("arrowPosition")?_-d:"end"===this.option("arrowPosition")?v-d-c:(_+v)/2-d-c/2;var y=this._getContentBorderWidth(e),x=m.fitIntoRange(i-y+this.option("arrowOffset"),y,h-c-2*y);this._$arrow.css(a,x)},_isPopoverInside:function(){var e=this._transformStringPosition(this.option("position"),D),t=g.setup.normalizeAlign(e.my),n=g.setup.normalizeAlign(e.at);return t.h===n.h&&t.v===n.v},_setContentHeight:function(e){e&&this.callBase()},_renderWrapperPosition:function(){this.option("shading")&&this._$wrapper.css({top:0,left:0})},_renderWrapperDimensions:function(){this.option("shading")&&this._$wrapper.css({width:"100%",height:"100%"})},_normalizePosition:function(){var e=h({},this._transformStringPosition(this.option("position"),D));e.of||(e.of=this.option("target")),e.collision||(e.collision="flip"),e.boundaryOffset||(e.boundaryOffset=this.option("boundaryOffset")),this._positionSide=this._getDisplaySide(e),this._position=e},_getDisplaySide:function(e){var t=g.setup.normalizeAlign(e.my),n=g.setup.normalizeAlign(e.at),i=I[t.h]===I[n.h]&&I[t.v]===I[n.v]?-1:1,o=Math.abs(I[t.h]-i*I[n.h]),a=Math.abs(I[t.v]-i*I[n.v]);return o>a?n.h:n.v},_resetContentHeight:function(){if(this.callBase(),E){var e=this._$popupContent.css("overflow");this._$popupContent.css("overflow","visible"),this._$popupContent.css("overflow",e)}},_isVerticalSide:function(e){return e=e||this._positionSide,"top"===e||"bottom"===e},_isHorizontalSide:function(e){return e=e||this._positionSide,"left"===e||"right"===e},_clearEventTimeout:function(e){clearTimeout(this._timeouts[e])},_clearEventsTimeouts:function(){this._clearEventTimeout("show"),this._clearEventTimeout("hide")},_clean:function(){this._detachEvents(this.option("target")),this.callBase.apply(this,arguments)},_optionChanged:function(e){switch(e.name){case"boundaryOffset":case"arrowPosition":case"arrowOffset":this._renderGeometry();break;case"fullScreen":e.value&&this.option("fullScreen",!1);break;case"target":e.previousValue&&this._detachEvents(e.previousValue),this.callBase(e);break;case"showEvent":case"hideEvent":var t=e.name.substring(0,4),n=O(e.previousValue);this.hide(),B(this,this.option("target"),t,n),R(this,t);break;case"visible":this._clearEventTimeout(e.value?"show":"hide"),this.callBase(e);break;default:this.callBase(e)}},show:function(e){return e&&this.option("target",e),this.callBase()}});c("dxPopover",M),e.exports=M},function(e,t,n){var i=n(2),o=n(5),a=n(4).noop,r=n(15),s=n(180),l=n(8),u="dxListEditDecorator",c=l.addNamespace(s.start,u),d=l.addNamespace(s.swipe,u),h=l.addNamespace(s.end,u),f=r.inherit({ctor:function(e){this._list=e,this._init()},_init:a,_shouldHandleSwipe:!1,_attachSwipeEvent:function(e){var t={itemSizeFunc:function(){return this._clearSwipeCache&&(this._itemWidthCache=this._list.$element().width(),this._clearSwipeCache=!1),this._itemWidthCache}.bind(this)};o.on(e.$itemElement,c,t,this._itemSwipeStartHandler.bind(this)),o.on(e.$itemElement,d,this._itemSwipeUpdateHandler.bind(this)),o.on(e.$itemElement,h,this._itemSwipeEndHandler.bind(this))},_itemSwipeStartHandler:function(e){var t=i(e.currentTarget);return t.is(".dx-state-disabled, .dx-state-disabled *")?void(e.cancel=!0):(clearTimeout(this._list._inkRippleTimer),void this._swipeStartHandler(t,e))},_itemSwipeUpdateHandler:function(e){var t=i(e.currentTarget);this._swipeUpdateHandler(t,e)},_itemSwipeEndHandler:function(e){var t=i(e.currentTarget);this._swipeEndHandler(t,e),this._clearSwipeCache=!0},beforeBag:a,afterBag:a,_commonOptions:function(){return{activeStateEnabled:this._list.option("activeStateEnabled"),hoverStateEnabled:this._list.option("hoverStateEnabled"),focusStateEnabled:this._list.option("focusStateEnabled")}},modifyElement:function(e){this._shouldHandleSwipe&&(this._attachSwipeEvent(e),this._clearSwipeCache=!0)},afterRender:a,handleClick:a,handleKeyboardEvents:a,handleEnterPressing:a,handleContextMenu:a,_swipeStartHandler:a,_swipeUpdateHandler:a,_swipeEndHandler:a,visibilityChange:a,getExcludedSelectors:a,dispose:a});e.exports=f},function(e,t,n){e.exports=n(360)},function(e,t,n){var i=n(21),o=n(0).extend,a=n(3).each,r=n(14).inArray,s=n(1).isDefined,l=n(25),u=l.dateToMilliseconds,c=4,d={secondly:"seconds",minutely:"minutes",hourly:"hours",daily:"days",weekly:"weeks",monthly:"months",yearly:"years"},h={bysecond:function(e,t){e.setSeconds(t)},byminute:function(e,t){e.setMinutes(t)},byhour:function(e,t){e.setHours(t)},bymonth:function(e,t){e.setMonth(t)},bymonthday:function(e,t){if(t<0){var n=new Date(e);f(n,1,-1);var i=n.getDate();i>=Math.abs(t)?f(e,1,t):f(e,2,t)}else t<=l.getLastMonthDay(e)?e.setDate(t):oe(e)},byday:function(e,t,n,i,o){var a=e.getDay(),r=m[n];t+=t>=r==r>a?7:0,e.setDate(e.getDate()-a+t)},byweekno:function(e,t,n){var i=new Date(e),o=new Date(i.setMonth(0,1)),a=o.getDay()-m[n],r=o.getTime()-a*u("day"),s=a+1;s>c?e.setTime(r+7*t*u("day")):e.setTime(r+7*(t-1)*u("day"));var l=(e.getTimezoneOffset()-o.getTimezoneOffset())*u("minute");l&&e.setTime(e.getTime()+l)},byyearday:function(e,t){e.setMonth(0,1),e.setDate(t)}},f=function(e,t,n){var i=new Date(e);e.setMonth(e.getMonth()+t),e.getMonth()-i.getMonth()>t&&e.setDate(n+1),e.setDate(n+1)},p={bysecond:function(e){return e.getSeconds()},byminute:function(e){return e.getMinutes()},byhour:function(e){return e.getHours()},bymonth:function(e){return e.getMonth()},bymonthday:function(e){return e.getDate()},byday:function(e){return e.getDay()},byweekno:function(e,t){var n=new Date(e),i=c-n.getDay()+m[t]-1,o=u("day");e.getDay()<m[t]&&(i-=7),n.setHours(0,0,0),n.setDate(n.getDate()+i);var a=new Date(n.getFullYear(),0,1),r=(a.getTimezoneOffset()-n.getTimezoneOffset())*u("minute"),s=1+(n-a+r)/o;return Math.ceil(s/7)},byyearday:function(e){var t=new Date(e.getFullYear(),0,0),n=e.getTimezoneOffset()-t.getTimezoneOffset(),i=e-t-n*u("minute"),o=u("day");return Math.floor(i/o)}},g=["freq","interval","byday","byweekno","byyearday","bymonth","bymonthday","count","until","byhour","byminute","bysecond","bysetpos","wkst"],_=["DAILY","WEEKLY","MONTHLY","YEARLY","SECONDLY","MINUTELY","HOURLY"],m={SU:0,MO:1,TU:2,WE:3,TH:4,FR:5,SA:6},v={0:"SU",1:"MO",2:"TU",3:"WE",4:"TH",5:"FR",6:"SA"},y=function(){return(new Date).getTimezoneOffset()},b=function(e){var t=[];return e.rule&&(t=S(e)),!!t.length},x=function(e){var t=e.interval,n=e.freq,i={},o=d[n.toLowerCase()];return"MONTHLY"===n&&e.byday&&(o=d.daily),i[o]=t,i},w=function(e,t){for(var n=[],i=0,o=e.length;i<o;i++)n[i]=j(e[i],t);return n},C=function(e,t){var n=!1;if(!t)return n;for(var i=t.split(","),o=w(i,e),a=/\d{8}$/,r=0,s=o.length;r<s;r++)if(i[r].match(a)){var l=P(e,o[r]);0===l.years&&0===l.months&&0===l.days&&(n=!0)}else e.getTime()===o[r].getTime()&&(n=!0);return n},k=function(e,t,n,i,o){var a=!0;n=n.getTime(),i.until&&i.until.getTime()<n&&(n=i.until.getTime()),i.count&&o===i.count&&(a=!1);var r=e.getTime()<=n;return r&&a},S=function(e){var t=[],n=R(e.rule),i={},o=n.rule,r=e.start,s=E(e.max,o);if(!n.isValid||!o.freq)return t;o.interval=x(o);var l=Y(o,e.firstDayOfWeek),c=e.end?e.end.getTime()-e.start.getTime():u("day"),d={exception:e.exception,min:e.min,dateRules:l,rule:o,recurrenceStartDate:r,recurrenceEndDate:e.end,duration:c};if(l.length&&o.count){var h=0;ee(l,new Date(r),new Date(r),o).forEach(function(e,t){e<s&&(h++,i=I(h,i,e,t,d,!0))})}else J(l,new Date(r),o).forEach(function(e,t){for(var n=0;k(e,r,s,o,n);)n++,i=I(n,i,e,t,d),e=O(e,r,o,t)});return o.bysetpos&&a(i,function(e,t){i[e]=T(t,o.bysetpos)}),a(i,function(e,n){t=t.concat(n)}),t=t.filter(function(t){return t<=e.max}),t.sort(function(e,t){return e-t}),t},I=function(e,t,n,i,o,a){return t[e]||(t[e]=[]),D(n,i,o,a)&&t[e].push(n),t},D=function(e,t,n,i){if(!C(e,n.exception)){var o=l.sameDate(e,n.recurrenceEndDate)&&n.recurrenceEndDate.getTime()>e.getTime()?n.recurrenceEndDate.getTime()-e.getTime():n.duration;if(e.getTime()>=n.recurrenceStartDate.getTime()&&e.getTime()+o>n.min.getTime())return i||ne(e,[n.dateRules[t]],n.rule.wkst)}return!1},T=function(e,t){var n=[];return t.split(",").forEach(function(t){t=Number(t);var i=t>0?t-1:e.length+t;e[i]&&n.push(e[i])}),n},E=function(e,t){var n=new Date(e);switch(t.freq){case"MONTHLY":n.setMonth(n.getMonth()+1);break;case"YEARLY":n.setYear(n.getYear()+1)}return n>e?n:e},A=function(e,t){e.getDate()!==t&&e.setDate(t)},O=function(e,t,n,i){var o=new Date(e),a=!0;if(e=l.addInterval(e,n.interval),"DAILY"!==n.freq||s(n.byhour)||t.getHours()===e.getHours()||(e=new Date(e.getTime()-(o.getHours()-t.getHours())*u("hour"))),"MONTHLY"===n.freq&&!n.byday){var r=t.getDate();n.bymonthday&&(r=Number(n.bymonthday.split(",")[i]),r<0&&(o.setMonth(o.getMonth()+1,1),h.bymonthday(o,r),e=o,a=!1)),a&&A(e,r)}if("YEARLY"===n.freq){if(n.byyearday){var c=Number(n.byyearday.split(",")[i]);h.byyearday(e,c)}var d=Y(n);for(var f in d[i])h[f]&&h[f](e,d[i][f],n.wkst)}return e},P=function(e,t){return{years:e.getFullYear()-t.getFullYear(),months:e.getMonth()-t.getMonth(),days:e.getDate()-t.getDate(),hours:e.getHours()-t.getHours(),minutes:e.getMinutes()-t.getMinutes(),seconds:e.getSeconds()-t.getSeconds()}},R=function(e){var t={rule:{},isValid:!1};return e&&(t.rule=G(e),t.isValid=M(t.rule,e)),t},B=[],M=function(e,t){return!($(e)||r(e.freq,_)===-1||F(e)||z(e)||N(e)||L(e)||H(e)||V(e))||(W(t),!1)},V=function(e){var t=!1,n=e.until;return void 0===n||n instanceof Date||(t=!0),t},F=function(e){var t=!1,n=e.count;return n&&"string"==typeof n&&(t=!0),t},L=function(e){var t=!1,n=e.bymonthday;return n&&isNaN(parseInt(n))&&(t=!0),t},H=function e(t){var e=!1,n=t.bymonth;return n&&isNaN(parseInt(n))&&(e=!0),e},z=function(e){var t=!1,n=e.interval;return n&&"string"==typeof n&&(t=!0),t},N=function(e){var t=K(e),n=!1;return a(t,function(e,t){if(!Object.prototype.hasOwnProperty.call(m,t))return n=!0,!1}),n},$=function(e){var t=!1;return a(e,function(e){if(r(e,g)===-1)return t=!0,!1}),t},W=function(e){r(e,B)===-1&&(i.log("W0006",e),B.push(e))},G=function(e){for(var t={},n=e.split(";"),i=0,o=n.length;i<o;i++){var a=n[i].split("="),r=a[0].toLowerCase(),s=a[1];t[r]=s}var l=parseInt(t.count);if(isNaN(l)||(t.count=l),t.interval){var u=parseInt(t.interval);isNaN(u)||(t.interval=u)}else t.interval=1;return t.freq&&t.until&&(t.until=j(t.until)),t},j=function(e,t){if("string"!=typeof e)return e;var n=e.match(/(\d{4})(\d{2})(\d{2})(T(\d{2})(\d{2})(\d{2}))?(Z)?/);if(!n)return null;var i=void 0!==n[8],o=t?t.getTimezoneOffset():re.getTimeZoneOffset(),a=new(Function.prototype.bind.apply(Date,q(n)));return o=6e4*o,i&&(a=new Date(a.getTime()-o)),a},q=function(e){return e.shift(),void 0===e[3]?e.splice(3):(e.splice(3,1),e.splice(6)),e[1]--,e.unshift(null),e},K=function(e){var t=[];return e.byday&&(t=Array.isArray(e.byday)?e.byday:e.byday.split(",")),t},U=function(e){var t=6e4*re.getTimeZoneOffset();return e=new Date(e.getTime()+t),e.getFullYear()+("0"+(e.getMonth()+1)).slice(-2)+("0"+e.getDate()).slice(-2)+"T"+("0"+e.getHours()).slice(-2)+("0"+e.getMinutes()).slice(-2)+("0"+e.getSeconds()).slice(-2)+"Z"},Y=function(e){var t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:null,n=[];if(s(t)&&(e.fdow=t),e.wkst||(e.wkst=s(t)?v[t]:"MO"),e.byweekno&&!e.byday){for(var i=Object.keys(m),o=0;o<m[e.wkst];o++)i.push(i.shift());e.byday=i.join(",")}for(var a in h)if(e[a]){var r=e[a].split(","),l=X(a,r);n=n.length?Q(l,n):l}return n},X=function(e,t){for(var n=[],i=0,o=t.length;i<o;i++){var a={};a[e]=Z(e,t[i]),n.push(a)}return n},Z=function(e,t){var n=parseInt(t);return"bymonth"===e&&(n-=1),"byday"===e&&(n=m[t]),n},Q=function(e,t){for(var n=[],i=0,a=e.length;i<a;i++)for(var r=0,s=t.length;r<s;r++)n.push(o({},e[i],t[r]));return n},J=function(e,t,n){for(var i=[],o=0,a=e.length;o<a;o++){var r=e[o],s=te(t,e,n.wkst);for(var l in r)h[l]&&h[l](s,r[l],n.wkst,n.freq,n.fdow);if(Array.isArray(s))i=i.concat(s);else{var u=ae(s)?s:new Date(s);i.push(u)}}return i.length||i.push(t),i},ee=function(e,t,n,i){for(var o=[],a=i.count,r=0,s=te(t,e,i.wkst),u=function(){var t=J(e,s,i),u=[];t.forEach(function(e){ae(e)||e.getTime()>=n.getTime()&&u.push(e)});var c=u.length;r+=c;var d=r-a;r>a&&u.splice(c-d,d),u.forEach(function(e){return o.push(e)});var h=i.interval;"days"===Object.keys(h)[0]&&(h={weeks:1}),s=l.addInterval(s,h)};r<a;)u();return o},te=function(e,t,n){var i=new Date(e),o=i.getDay();return t.length&&s(t[0].byday)?i.setDate(i.getDate()-o+m[n]-(o<m[n]?7:0)):i.setDate(1),i},ne=function(e,t,n){for(var i=!1,o=0;o<t.length;o++){var a=t[o],r=!0;for(var s in a){var l="bymonthday"===s&&a[s]<0;p[s]&&!l&&a[s]!==p[s](e,n)&&(r=!1)}i=i||r}return i||!t.length},ie=function(e){if(e&&e.freq){var t="";for(var n in e){var i=e[n];"interval"===n&&i<2||("until"===n&&(i=U(i)),t+=n+"="+i+";")}return t=t.substring(0,t.length-1),t.toUpperCase()}},oe=function(e){e.isWrongDate=!0},ae=function(e){return e.isWrongDate},re={getRecurrenceString:ie,getRecurrenceRule:R,getAsciiStringByDate:U,getDatesByRecurrence:S,dateInRecurrenceRange:b,getDateByAsciiString:j,daysFromByDayRule:K,getTimeZoneOffset:y};e.exports=re},function(e,t,n){function i(e){return e&&e.__esModule?e:{"default":e}}var o=n(25),a=i(o),r=n(394),s=i(r),l=a.default.dateToMilliseconds,u=60,c=function(e,t,n,i){return h(n,i)-h(e,t)},d=function(e,t,n,i){return c(e,t,n,i)*l("minute")},h=function(e,t){return new Date(e).getTimezoneOffset()-new Date(t).getTimezoneOffset()},f=function(e,t){return h(e,t)*l("minute")},p=function(e,t){if("string"==typeof e){t=t||new Date;var n=Date.UTC(t.getUTCFullYear(),t.getUTCMonth(),t.getUTCDate(),t.getUTCHours(),t.getUTCMinutes());e=s.default.getTimezoneOffsetById(e,n)}return e},g=function(e,t,n){return p(n,e)-p(n,t)},_=function(e,t,n,i,o){var a=g(e,t,i),r=g(e,t,o),s=a-r;return new Date(n.getTime()-s*l("hour"))},m=function(e,t,n,i){var o=(e.getTimezoneOffset()-t.getTimezoneOffset())/u;return i?o=g(t,e,i):n&&(o=g(t,e,n)),new Date(e.getTime()+o*l("hour"))},v=function(e){var t=new Date(new Date(e).setHours(0,0,0,0)),n=new Date(new Date(e).setHours(23,59,59,0));return t.getTimezoneOffset()-n.getTimezoneOffset()!==0},y=function(e,t){return t=new Date(t.getTime()-1),a.default.sameDate(e,t)},b={getDaylightOffset:h,getDaylightOffsetInMs:f,getTimezoneOffsetChangeInMinutes:c,getTimezoneOffsetChangeInMs:d,calculateTimezoneByValue:p,getCorrectedDateByDaylightOffsets:_,isTimezoneChangeInDate:v,isSameAppointmentDates:y,correctRecurrenceExceptionByTimezone:m};e.exports=b},function(e,t,n){function i(e){return e&&e.__esModule?e:{"default":e}}function o(){return r||(r=a()),r}function a(){var e=(0,u.getWindow)(),t=e&&e.DevExpress&&e.DevExpress.diagram||n(773);if(!t)throw l.default.Error("E1041","devexpress-diagram");return t}Object.defineProperty(t,"__esModule",{value:!0}),t.getDiagram=void 0;var r,s=n(18),l=i(s),u=n(7);t.getDiagram=o},function(e,t,n){function i(){this.reset()}function o(e,t){return e!==t?d({},e,t):d({},e)}function a(e,t){return e!==t?e.concat(t):e.slice()}function r(e){e._totalChangesOrder=e._optionChangesOrder.concat(e._layoutChangesOrder,e._customChangesOrder)}function s(e){var t=this.prototype,n=e.code;t["_change_"+n]=e.handler,e.isThemeDependent&&t._themeDependentChanges.push(n),e.option&&(t._optionChangesMap[e.option]=n),(e.isOptionChange?t._optionChangesOrder:t._customChangesOrder).push(n),r(t)}function l(){var e=function e(){var t,n,i=e._chain.length;for(t=0;t<i;++t)n=e._chain[t].apply(this,arguments);return n};return e._chain=[],e.add=function(t){e._chain.push(t)},e.copy=function(t){e._chain=t._chain.slice()},e}function u(e,t,n){var i=e[t];i?i.add?(Object.prototype.hasOwnProperty.call(e,t)===!1&&(i=l(),i.copy(e[t])),i.add(n)):(i=l(),i.add(e[t]),i.add(n)):i=n,e[t]=i}function c(e){var t=this.prototype;t._plugins.push(e),e.fontFields&&t._fontFields.push.apply(t._fontFields,e.fontFields),e.members&&d(this.prototype,e.members),e.customize&&e.customize(this),e.extenders&&Object.keys(e.extenders).forEach(function(n){var i=e.extenders[n];u(t,n,i)},this)}var d=n(0).extend,h=n(7),f=n(4).noop,p=!h.hasWindow();i.prototype={constructor:i,add:function(e){var t,n=e.length,i=this._flags;for(t=0;t<n;++t)i[e[t]]=1;this._k+=n},has:function(e){return this._flags[e]>0},count:function(){return this._k},reset:function(){this._flags={},this._k=0}},t.replaceInherit=p?function(e){var t=e.inherit;e.inherit=function(){var e=t.apply(this,arguments),n=e.prototype;return["_plugins","_eventsMap","_initialChanges","_themeDependentChanges","_optionChangesMap","_optionChangesOrder","_layoutChangesOrder","_customChangesOrder","_totalChangesOrder"].forEach(function(e){n[e]={}}),e.addPlugin=f,e},e.addChange=f,e.addPlugin=f}:function(e){var t=e.inherit;e.inherit=function(){var e=this.prototype,n=e._plugins,i=e._fontFields,s=e._eventsMap,l=e._initialChanges,u=e._themeDependentChanges,d=e._optionChangesMap,h=e._partialOptionChangesMap,f=e._partialOptionChangesPath,p=e._optionChangesOrder,g=e._layoutChangesOrder,_=e._customChangesOrder,m=t.apply(this,arguments);return e=m.prototype,e._plugins=a(n,e._plugins),e._fontFields=a(i,e._fontFields),e._eventsMap=o(s,e._eventsMap),e._initialChanges=a(l,e._initialChanges),e._themeDependentChanges=a(u,e._themeDependentChanges),e._optionChangesMap=o(d,e._optionChangesMap),e._partialOptionChangesMap=o(h,e._partialOptionChangesMap),e._partialOptionChangesPath=o(f,e._partialOptionChangesPath),e._optionChangesOrder=a(p,e._optionChangesOrder),e._layoutChangesOrder=a(g,e._layoutChangesOrder),e._customChangesOrder=a(_,e._customChangesOrder),r(e),m.addPlugin=c,m},e.prototype._plugins=[],e.prototype._fontFields=[],e.addChange=s,e.addPlugin=c},t.changes=function(){return new i},t.expand=u},function(e,t,n){function i(e){return e&&e.__esModule?e:{"default":e}}function o(e,t){return u(e)||l(e,t)||r(e,t)||a()}function a(){throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}function r(e,t){if(e){if("string"==typeof e)return s(e,t);var n=Object.prototype.toString.call(e).slice(8,-1);return"Object"===n&&e.constructor&&(n=e.constructor.name),"Map"===n||"Set"===n?Array.from(e):"Arguments"===n||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)?s(e,t):void 0}}function s(e,t){(null==t||t>e.length)&&(t=e.length);for(var n=0,i=new Array(t);n<t;n++)i[n]=e[n];return i}function l(e,t){if("undefined"!=typeof Symbol&&Symbol.iterator in Object(e)){var n=[],i=!0,o=!1,a=void 0;try{for(var r,s=e[Symbol.iterator]();!(i=(r=s.next()).done)&&(n.push(r.value),!t||n.length!==t);i=!0);}catch(e){o=!0,a=e}finally{try{i||null==s.return||s.return()}finally{if(o)throw a}}return n}}function u(e){if(Array.isArray(e))return e}function c(e){0===xt().backupCounter&&Be.default.getBody().appendChild(xt().backupContainer),++xt().backupCounter,e.append({element:xt().backupContainer})}function d(e,t){e.append({element:t}),--xt().backupCounter,0===xt().backupCounter&&Be.default.getBody().removeChild(xt().backupContainer)}function h(e){return e&&"string"!=typeof e}function f(e){return Be.default.createElementNS("http://www.w3.org/2000/svg",e)}function p(e,t){return null!==e?"url("+(t?Ue.location.href.split("#")[0]:"")+"#"+e+")":e}function g(e,t){var n;for(n in t)e[n]=t[n];return e}function _(e,t){return e=e.toString().split("e"),e=Qe(+(e[0]+"e"+(e[1]?+e[1]+t:t))),e=e.toString().split("e"),+(e[0]+"e"+(e[1]?+e[1]-t:-t))}function m(e){var t;try{t=e.getBoundingClientRect()}catch(e){}return t||{left:0,top:0}}function v(e,t){return t.hatching&&"none"!==(0,qe.normalizeEnum)(t.hatching.direction)?(t=g({},t),t.fill=e._hatching=e.renderer.lockHatching(t.fill,t.hatching,e._hatching),delete t.hatching):e._hatching&&(e.renderer.releaseHatching(e._hatching),e._hatching=null),t}function y(e,t,n,i,o,a){var r,s=!0,l=_(a,3)-_(o,3);return l&&(tt(l)%360===0&&(o=0,a=360,r=!0,a-=.01),o>360&&(o%=360),a>360&&(a%=360),o>a&&(o-=360),s=!1),o*=it,a*=it,[e,t,Xe(i,n),Ye(i,n),et(o),Je(o),et(a),Je(a),r,Ze(tt(a-o)/nt)%2?"1":"0",s]}function b(e,t){var n=[["M",0,0]];switch(t){case"line":n=x(e);break;case"area":n=x(e,!0);break;case"bezier":n=w(e);break;case"bezierarea":n=w(e,!0)}return n}function x(e,t){return C(e,k,t)}function w(e,t){return C(e,S,t)}function C(e,t,n){var i,o,a=[];if(e[0]&&e[0].length)for(i=0,o=e.length;i<o;++i)t(e[i],n,a);else t(e,n,a);return a}function k(e,t,n){var i=0,o=n.length,a=o,r=(e||[]).length;if(r){if(void 0!==e[0].x)for(;i<r;)n[a++]=["L",e[i].x,e[i++].y];else for(;i<r;)n[a++]=["L",e[i++],e[i++]];n[o][0]="M"}else n[a]=["M",0,0];return t&&n.push(["Z"]),n}function S(e,t,n){var i,o=n.length,a=(e||[]).length;if(a)if(void 0!==e[0].x)for(n[o++]=["M",e[0].x,e[0].y],i=1;i<a;)n[o++]=["C",e[i].x,e[i++].y,e[i].x,e[i++].y,e[i].x,e[i++].y];else for(n[o++]=["M",e[0],e[1]],i=2;i<a;)n[o++]=["C",e[i++],e[i++],e[i++],e[i++],e[i++],e[i++]];else n[o]=["M",0,0];return t&&n.push(["Z"]),n}function I(e){var t,n,i,o,a=[],r=0,s=e.length;for(t=0;t<s;++t)for(n=e[t],i=0,o=n.length;i<o;++i)a[r++]=n[i];return a.join(" ")}function D(e,t,n){var i,o,a=e.length,r=t.length,s=n.indexOf("area")!==-1?A:E;if(0===a)for(i=0;i<r;i++)e.push(t[i].slice(0));else a<r?s(e,t,n):a>r&&(o=t.slice(0),s(t,e,n));return o}function T(e,t){var n=e[e.length-2],i=e[e.length-1];switch(t){case"line":case"area":e[0]="L";break;case"bezier":case"bezierarea":e[0]="C",e[1]=e[3]=e[5]=n,e[2]=e[4]=e[6]=i}}function E(e,t,n){var i=e[e.length-1].slice(),o=e.length;for(T(i,n);o<t.length;o++)e[o]=i.slice(0)}function A(e,t,n){var i,o,a,r,s=e.length,l=t.length;if((s-1)%2===0&&(l-1)%2===0){i=(s-1)/2-1,o=e.slice(0,i+1),a=o[o.length-1].slice(0),r=e.slice(i+1)[0].slice(0),T(a,n),T(r,n);for(var u=i;u<(l-1)/2-1;u++)e.splice(u+1,0,a),e.splice(u+3,0,r)}}function O(e,t){var n,i,o=e._styles,a="";t=t||{};for(n in t)i=t[n],(0,Ke.isDefined)(i)&&(i+="number"!=typeof i||rt[n]?"":"px",o[n]=""!==i?i:null);for(n in o)i=o[n],i&&(a+=n+":"+i+";");return a&&e.element.setAttribute("style",a),e}function P(e,t){var n=e.element,i=e.attr(t);i&&i.indexOf("DevExpress")!==-1&&(n.removeAttribute(t),n.setAttribute(t,p(i,e.renderer.pathModified)))}function R(e,t){t=t||{};var n,i,o,a,r,s,l=e._settings,u={},c=e.element,d=e.renderer,f=d.rtl;if(!h(t))return t in l?l[t]:t in bt?bt[t]:0;g(u,t);for(n in u)if(i=u[n],void 0!==i){if(l[n]=i,"align"===n)n="text-anchor",i={left:f?"end":"start",center:"middle",right:f?"start":"end"}[i]||null;else{if("dashStyle"===n){a=!0;continue}if(n===ut)a=!0;else if(!i||"fill"!==n&&"clip-path"!==n&&"filter"!==n||0!==i.indexOf("DevExpress")){if(/^(translate(X|Y)|rotate[XY]?|scale(X|Y)|sharp|sharpDirection)$/i.test(n)){o=!0;continue}/^(x|y|d)$/i.test(n)&&(o=!0)}else e._addFixIRICallback(),i=p(i,d.pathModified)}null===i?c.removeAttribute(n):c.setAttribute(n,i)}if(a&&"dashStyle"in l)if(i=l.dashStyle,r=("_originalSW"in e?e._originalSW:l[ut])||1,n="stroke-dasharray",i=null===i?"":(0,qe.normalizeEnum)(i),""===i||"solid"===i||i===_t)e.element.removeAttribute(n);else{for(i=i.replace(/longdash/g,"8,3,").replace(/dash/g,"4,3,").replace(/dot/g,"1,3,").replace(/,$/,"").split(","),s=i.length;s--;)i[s]=parseInt(i[s])*r;e.element.setAttribute(n,i.join(","))}return o&&e._applyTransformation(),e}function B(e){var t,n=this;return h(e)&&(e=g({},e),t=e.segments,"points"in e&&(t=b(e.points,n.type),delete e.points),t&&(e.d=I(t),n.segments=t,delete e.segments)),R(n,e)}function M(e){var t,n,i,o,a,r,s=this._settings;return h(e)&&(e=g({},e),("x"in e||"y"in e||"innerRadius"in e||"outerRadius"in e||"startAngle"in e||"endAngle"in e)&&(s.x=t="x"in e?e.x:s.x,delete e.x,s.y=n="y"in e?e.y:s.y,delete e.y,s.innerRadius=i="innerRadius"in e?e.innerRadius:s.innerRadius,delete e.innerRadius,s.outerRadius=o="outerRadius"in e?e.outerRadius:s.outerRadius,delete e.outerRadius,s.startAngle=a="startAngle"in e?e.startAngle:s.startAngle,delete e.startAngle,s.endAngle=r="endAngle"in e?e.endAngle:s.endAngle,delete e.endAngle,e.d=kt.apply(null,y(t,n,i,o,a,r)))),R(this,e)}function V(e){var t,n,i,o,a,r,s,l=this;return h(e)&&(e=g({},e),void 0===e.x&&void 0===e.y&&void 0===e.width&&void 0===e.height&&void 0===e[ut]||(t=void 0!==e.x?l._originalX=e.x:l._originalX||0,n=void 0!==e.y?l._originalY=e.y:l._originalY||0,i=void 0!==e.width?l._originalWidth=e.width:l._originalWidth||0,o=void 0!==e.height?l._originalHeight=e.height:l._originalHeight||0,a=void 0!==e[ut]?l._originalSW=e[ut]:l._originalSW,r=~~((i<o?i:o)/2),s=(a||0)<r?a||0:r,e.x=t+s/2,e.y=n+s/2,e.width=i-s,e.height=o-s,((a||0)!==s||!(0===s&&void 0===a))&&(e[ut]=s)),"sharp"in e&&delete e.sharp),R(l,e)}function F(e){var t,n=this;if(!h(e))return R(n,e);e=g({},e);var i=n._settings,o=(0,Ke.isDefined)(i[lt])&&(0,Ke.isDefined)(i[ut]);void 0!==e[st]&&(i[st]=e[st],delete e[st],t=!0),void 0!==e[lt]&&(i[lt]=e[lt],delete e[lt]),void 0!==e[ut]&&(i[ut]=e[ut],delete e[ut]),void 0!==e[ct]&&(i[ct]=e[ct],delete e[ct]),void 0!==e[gt]&&(fe(n,e[gt]),delete e[gt]);var a=(0,Ke.isDefined)(i[lt])&&(0,Ke.isDefined)(i[ut]);return R(n,e),t=t||a!==o&&i[st],t&&(ue(n,i.text,a),n._hasEllipsis=!1),(t||void 0!==e.x||void 0!==e.y)&&he(n),a&&ge(n),n}function L(e){return e=e||{},O(this,e),dt in e&&he(this),this}function H(e,t,n,i,o){var a,r,s,l,u;if(void 0!==n.wholeText)e.push({value:n.wholeText,style:i,className:o,line:t,height:i[dt]||0});else if("BR"===n.tagName)++t;else if(Be.default.isElementNode(n)){switch(g(a={},i),n.tagName){case"B":case"STRONG":a[ft]="bold";break;case"I":case"EM":a[ht]="italic";break;case"U":a[pt]="underline"}for(r=n.style,r.color&&(a.fill=r.color),r.fontSize&&(a[dt]=r.fontSize),r.fontStyle&&(a[ht]=r.fontStyle),r.fontWeight&&(a[ft]=r.fontWeight),r.textDecoration&&(a[pt]=r.textDecoration),s=0,u=n.childNodes,l=u.length;s<l;++s)t=H(e,t,u[s],a,n.className||o)}return t}function z(e){var t,n,i,o=e[0];for(t=1,n=e.length;t<n;++t)i=e[t],i.line===o.line?(o.height=pe(o.height,i.height),o.inherits=o.inherits||0===parseFloat(i.height),i.height=NaN):o=i}function N(e){var t=/(?:(<[a-z0-9]+\s*))([\s\S]*?)(>|\/>)/gi,n=/(style|class)\s*=\s*(["'])(?:(?!\2).)*\2\s?/gi;return e.replace(t,function(e,t,i,o){return i=(i&&i.match(n)||[]).map(function(e){return e}).join(" "),t+i+o})}function $(e){var t=[],n=Be.default.createElement("div");return n.innerHTML=e.replace(/\r/g,"").replace(/\n/g,"<br/>"),H(t,0,n,{},""),z(t),t}function W(e){for(var t=e.replace(/\r/g,"").split(/\n/g),n=0,i=[];n<t.length;n++)i.push({value:t[n].trim(),height:0,line:n});return i}function G(e,t,n){var i,o,a;for(i=0,o=e.length;i<o;++i)a=e[i],a[n]=f("tspan"),a[n].appendChild(Be.default.createTextNode(a.value)),a.style&&O({element:a[n],_styles:{}},a.style),a.className&&a[n].setAttribute("class",a.className),t.appendChild(a[n])}function j(){this._hasEllipsis&&this.attr({text:this._settings.text})}function q(e){var t,n,i,o,a,r,s,l=this,u=!1;j.call(l);var c=l.renderer.text(vt).attr(l._styles).append(l.renderer.root),d=c.getBBox().width;if(l._getElementBBox().width>e)for(e-d<0?e=0:e-=d,t=Q(l.element,l._texts,e),n=0,i=t.length;n<i;++n)if(o=t[n].parts,1!==t[n].commonLength)for(a=0,r=o.length;a<r;++a)s=o[a],(0,Ke.isDefined)(s.endIndex)?(se(s,s.endIndex),u=!0):s.startBox>e&&le(s);return c.remove(),l._hasEllipsis=u,u}function K(e){var t;return e&&(t=e.cloneNode(),t.removeAttribute("y"),t.removeAttribute("x")),t||e}function U(e){for(var t=Be.default.querySelectorAll(e,"title"),n=0;n<t.length;n++)e.removeChild(t[n]);return function(){for(var n=0;n<t.length;n++)e.appendChild(t[n])}}function Y(e,t){var n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{},i=this,o=[],a=!1,r=!1,s=e;j.call(i);var l=U(this.element),u=i.renderer.text(vt).attr(i._styles).append(i.renderer.root),c=u.getBBox().width,d=i._getElementBBox(),h=d.width,f=d.height;return(h||f)&&(h>e||t&&f>t)&&(e-c<0?s=0:s-=c,o=re(i.element,i._texts,e,s,n,t),o=ae(o,s,n,t,parseFloat(this._getLineHeight())),this._texts=o.reduce(function(e,t){return e.concat(t.parts)},[]).filter(function(e){return""!==e.value}).map(function(e){return e.stroke&&e.tspan.parentNode.appendChild(e.stroke),e}).map(function(e){return e.tspan.parentNode.appendChild(e.tspan),e}),!this._texts.length&&(this._texts=null),a=!0,this._texts?he(this):(this.element.textContent="",r=!0)),u.remove(),i._hasEllipsis=a,l(),{rowCount:o.length,textChanged:a,textIsEmpty:r}}function X(e,t,n,i){var o,a;if(n<=t&&i>t)for(o=1,a=e.value.length;o<=a;++o)if(n+e.tspan.getSubStringLength(0,o)>t)return o-1}function Z(e){return e.value.length?e.tspan.getSubStringLength(0,e.value.length):0}function Q(e,t,n){var i,o,a,r,s,l=[];if(t)for(i=0,o=t.length;i<o;++i)a=t[i],l[a.line]?(a.startBox=r,l[a.line].parts.push(a),l[a.line].commonLength+=a.value.length):(a.startBox=r=0,l.push({commonLength:a.value.length,parts:[a]})),s=r+a.tspan.getSubStringLength(0,a.value.length),a.endIndex=X(a,n,r,s),r=s;else a={value:e.textContent,tspan:e},a.startBox=r=0,s=r+Z(a),a.endIndex=X(a,n,r,s),l=[{commonLength:e.textContent.length,parts:[a]}];return l}function J(e,t){for(var n=e.startBox>0?[0]:[],i=e.value.split("").reduce(function(e,t,n){return" "===t&&e.push(n),e},n),o=0;void 0!==i[o+1]&&e.startBox+e.tspan.getSubStringLength(0,i[o+1])<t;)o++;return i[o]}function ee(e,t){for(var n=0;n<e.value.length-1;n++)if(e.startBox+e.tspan.getSubStringLength(0,n+1)>t)return n}function te(e,t){var n=t.hideOverflowEllipsis;return n&&0===e?"":vt}function ne(e,t,n){var i=te(t,n);if(e.value.length&&e.tspan.parentNode)for(var o=e.value.length-1;o>=1;o--){if(e.startBox+e.tspan.getSubStringLength(0,o)<t){se(e,o,i);break}1===o&&se(e,0,i)}}function ie(e,t,n,i){var o,a=e.value;"none"!==i.wordWrap&&(o="normal"===i.wordWrap?J(e,t):ee(e,t));var r,s=[];if(isFinite(o)){se(e,o,"");var l=" "===a[o]?1:0,u=a.slice(o+l);if(u.length){var c=K(e.tspan);if(c.textContent=u,e.tspan.parentNode.appendChild(c),r=g(g({},e),{value:u,startBox:0,height:0,tspan:c,stroke:K(e.stroke),endBox:c.getSubStringLength(0,u.length)}),r.stroke&&(r.stroke.textContent=u),r.endBox>t&&(s=ie(r,t,n,i),!s.length))return[]}}if(e.value.length){if("ellipsis"===i.textOverflow&&e.tspan.getSubStringLength(0,e.value.length)>t&&ne(e,n,i),"hide"===i.textOverflow&&e.tspan.getSubStringLength(0,e.value.length)>t)return[]}else e.tspan.parentNode.removeChild(e.tspan);var d=[];return r&&d.push(r),[{commonLength:a.length,parts:d}].concat(s)}function oe(e,t){return e.parts.reduce(function(e,n){return Ye(e,de(n,t))},0)}function ae(e,t,n,i,a){var r=n.textOverflow;if(!isFinite(i)||0===Number(i)||"none"===r)return e;var s=e.reduce(function(e,s,l,u){var c=o(e,2),d=c[0],h=c[1],f=oe(s,a);if(h+=f,h<i)d.push(s);else if(s.parts.forEach(function(e){le(e)}),"ellipsis"===r){var p=u[l-1];if(p){var g=p.parts[p.parts.length-1];g.hasEllipsis||(0===t||g.endBox<t?se(g,g.value.length,te(t,n)):ne(g,t,n))}}return[d,h]},[[],0]);return"hide"===r&&s[1]>i?(s[0].forEach(function(e){
e.parts.forEach(function(e){le(e)})}),[]):s[0]}function re(e,t,n,i,a){if(!t){var r=e.textContent,s={value:r,height:0,line:0};e.textContent="",G([s],e,"tspan"),t=[s]}return t.reduce(function(e,t){var r=o(e,5),s=r[0],l=r[1],u=r[2],c=r[3],d=r[4],h=s[s.length-1];if(c)return[s,l,u,c];if(h&&t.line===d){if(t.startBox=l,l>i&&"none"===a.wordWrap&&"ellipsis"===a.textOverflow)return le(t),[s,l,u,c,d];h.parts.push(t),h.commonLength+=t.value.length}else t.startBox=l=0,s.push({commonLength:t.value.length,parts:[t]});if(t.endBox=u=l+Z(t),l=u,(0,Ke.isDefined)(n)&&u>n){var f=ie(t,n,i,a);f.length?s=s.concat(f.filter(function(e){return e.parts.length>0})):(s=[],c=!0)}return[s,l,u,c,t.line]},[[],0,0,!1,0])[0]}function se(e,t){var n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:vt,i=e.value.substr(0,t)+n;e.value=e.tspan.textContent=i,e.stroke&&(e.stroke.textContent=i),n===vt&&(e.hasEllipsis=!0)}function le(e){e.tspan.parentNode&&e.tspan.parentNode.removeChild(e.tspan),e.stroke&&e.stroke.parentNode&&e.stroke.parentNode.removeChild(e.stroke)}function ue(e,t,n){var i,o;e._texts=null,e.clear(),null!==t&&(t=""+t,e.renderer.encodeHtml||!/<[a-z][\s\S]*>/i.test(t)&&t.indexOf("&")===-1?/\n/g.test(t)?i=W(t):n&&(i=[{value:t.trim(),height:0}]):(o=N(t),i=$(o)),i?i.length&&(e._texts=i,n&&G(i,e.element,lt),G(i,e.element,"tspan")):e.element.appendChild(Be.default.createTextNode(t)))}function ce(e,t,n){e.tspan.setAttribute(t,n),e.stroke&&e.stroke.setAttribute(t,n)}function de(e,t){return e.inherits?pe(e.height,t):e.height||t}function he(e){if(e._texts){var t,n,i=e._texts,o=e._settings.x,a=e._getLineHeight(),r=i[0];for(ce(r,"x",o),ce(r,"y",e._settings.y),t=1,n=i.length;t<n;++t)if(r=i[t],parseFloat(r.height)>=0){ce(r,"x",o);var s=de(r,a);ce(r,"dy",s)}}}function fe(e,t){if(e._texts&&"center"!==t)for(var n=e._texts,i="left"===t?-1:1,o=Math.max.apply(Math,n.map(function(e){return Z(e)})),a=0;a<n.length;a++){var r=n[a],s=Z(r);0!==o&&o!==s&&ce(r,"dx",i*Qe((o-s)/2*10)/10)}}function pe(e,t){var n=parseFloat(e),i=parseFloat(t),o=n||mt,a=i||mt;return o>a?isNaN(n)?o:e:isNaN(i)?a:t}function ge(e){if(e._texts){var t,n,i,o=e._texts,a=e._settings[lt],r=e._settings[ut],s=e._settings[ct]||1;for(n=0,i=o.length;n<i;++n)t=o[n].stroke,t.setAttribute(lt,a),t.setAttribute(ut,r),t.setAttribute(ct,s),t.setAttribute("stroke-linejoin","round")}}function _e(e,t,n,i){n=n||{};var o,a,r=e.renderer,s=e._settings,l={},u={translateX:0,translateY:0,scaleX:1,scaleY:1,rotate:0,rotateX:0,rotateY:0};if(i&&(n.complete=i),r.animationEnabled()){for(o in t)a=t[o],/^(translate(X|Y)|rotate[XY]?|scale(X|Y))$/i.test(o)?(l.transform=l.transform||{from:{},to:{}},l.transform.from[o]=o in s?Number(s[o].toFixed(3)):u[o],l.transform.to[o]=a):"arc"===o||"segments"===o?l[o]=a:l[o]={from:o in s?s[o]:parseFloat(e.element.getAttribute(o)||0),to:a};r.animateElement(e,l,g(g({},r._animation),n))}else n.step&&n.step.call(e,1,1),n.complete&&n.complete.call(e),e.attr(t);return e}function me(e,t,n){var i,o,a=this,r=a.segments||[];return a.renderer.animationEnabled()&&"points"in e&&(i=b(e.points,a.type),o=D(r,i,a.type),e.segments={from:r,to:i,end:o},delete e.points),_e(a,e,t,n)}function ve(e,t,n){var i=this,o=i._settings,a={from:{},to:{}};return i.renderer.animationEnabled()&&("x"in e||"y"in e||"innerRadius"in e||"outerRadius"in e||"startAngle"in e||"endAngle"in e)&&(a.from.x=o.x||0,a.from.y=o.y||0,a.from.innerRadius=o.innerRadius||0,a.from.outerRadius=o.outerRadius||0,a.from.startAngle=o.startAngle||0,a.from.endAngle=o.endAngle||0,a.to.x="x"in e?e.x:o.x,delete e.x,a.to.y="y"in e?e.y:o.y,delete e.y,a.to.innerRadius="innerRadius"in e?e.innerRadius:o.innerRadius,delete e.innerRadius,a.to.outerRadius="outerRadius"in e?e.outerRadius:o.outerRadius,delete e.outerRadius,a.to.startAngle="startAngle"in e?e.startAngle:o.startAngle,delete e.startAngle,a.to.endAngle="endAngle"in e?e.endAngle:o.endAngle,delete e.endAngle,e.arc=a),_e(i,e,t,n)}function ye(e,t){var n={is:!1,name:t.name||t,after:t.after};return e?n.to=e:n.virtual=!0,n}function be(e,t,n){var i=this;i.renderer=e,i.element=f(t),i._settings={},i._styles={},"path"===t&&(i.type=n||"line")}function xe(e){St.remove(e)}function we(e,t){be.call(this,e,"path",t)}function Ce(e){be.call(this,e,"path","arc")}function ke(e){be.call(this,e,"rect")}function Se(e){be.call(this,e,"text"),this.css({"white-space":"pre"})}function Ie(e,t){var n,i;for(n=t;i=e[n];++n)i._link.i=n}function De(e,t){var n,i,o=t._links,a=e._link.after=e._link.after||t._linkAfter;if(a){for(n=0;(i=o[n])&&i._link.name!==a;++n);if(i)for(++n;(i=o[n])&&i._link.after===a;++n);}else n=o.length;o.splice(n,0,e),Ie(o,n)}function Te(e){var t,n=e._link.to._links;for(t=0;n[t]!==e;++t);n.splice(t,1),Ie(n,t)}function Ee(e){var t=this;t.root=t._createElement("svg",{xmlns:"http://www.w3.org/2000/svg",version:"1.1",fill:_t,stroke:_t,"stroke-width":0}).attr({"class":e.cssClass}).css({"line-height":"normal","-ms-user-select":_t,"-moz-user-select":_t,"-webkit-user-select":_t,"-webkit-tap-highlight-color":"rgba(0, 0, 0, 0)",display:"block",overflow:"hidden"}),t._init(),t.pathModified=!!e.pathModified,t._$container=(0,Pe.default)(e.container),t.root.append({element:e.container}),t.fixPlacement(),t._locker=0,t._backed=!1}function Ae(e,t){return"@"+e+"::"+t.step+":"+t.width+":"+t.opacity+":"+t.direction}var Oe=n(2),Pe=i(Oe),Re=n(11),Be=i(Re),Me=n(7),Ve=i(Me),Fe=n(62),Le=i(Fe),He=n(5),ze=i(He),Ne=n(23),$e=i(Ne),We=n(190),Ge=n(806),je=i(Ge),qe=n(13),Ke=n(1),Ue=Ve.default.getWindow(),Ye=Math.max,Xe=Math.min,Ze=Math.floor,Qe=Math.round,Je=Math.sin,et=Math.cos,tt=Math.abs,nt=Math.PI,it=nt/180,ot=.5,at=5,rt={"column-count":!0,"fill-opacity":!0,"flex-grow":!0,"flex-shrink":!0,"font-weight":!0,"line-height":!0,opacity:!0,order:!0,orphans:!0,widows:!0,"z-index":!0,zoom:!0},st="text",lt="stroke",ut="stroke-width",ct="stroke-opacity",dt="font-size",ht="font-style",ft="font-weight",pt="text-decoration",gt="textsAlignment",_t="none",mt=12,vt="...",yt=function(){return Object.create?function(e){return Object.create(e)}:function(e){var t=function(){};return t.prototype=e,new t}}(),bt={scaleX:1,scaleY:1,"pointer-events":null},xt=(0,Le.default)(function(){var e=Be.default.createElement("div"),t=0;return e.style.left="-9999px",e.style.position="absolute",{backupContainer:e,backupCounter:t}}),wt=function(){var e=1;return function(){return"DevExpress_"+e++}}();e.exports.getFuncIri=p;var Ct={full:_t,lefttop:"xMinYMin",leftcenter:"xMinYMid",leftbottom:"xMinYMax",centertop:"xMidYMin",center:"xMidYMid",centerbottom:"xMidYMax",righttop:"xMaxYMin",rightcenter:"xMaxYMid",rightbottom:"xMaxYMax"};e.exports.processHatchingAttrs=v;var kt=function(e,t,n,i,o,a,r,s,l,u){return["M",(e+i*o).toFixed(at),(t-i*a).toFixed(at),"A",i.toFixed(at),i.toFixed(at),0,u,0,(e+i*r).toFixed(at),(t-i*s).toFixed(at),l?"M":"L",(e+n*r).toFixed(5),(t-n*s).toFixed(at),"A",n.toFixed(at),n.toFixed(at),0,u,1,(e+n*o).toFixed(at),(t-n*a).toFixed(at),"Z"].join(" ")};t.SvgElement=be,be.prototype={constructor:be,_getJQElement:function(){return this._$element||(this._$element=(0,Pe.default)(this.element))},_addFixIRICallback:function(){var e=this,t=function(){P(e,"fill"),P(e,"clip-path"),P(e,"filter")};e.element._fixFuncIri=t,t.renderer=e.renderer,St.add(t),e._addFixIRICallback=function(){}},_clearChildrenFuncIri:function(){var e=function e(t){var n;for(n=0;n<t.childNodes.length;n++)xe(t.childNodes[n]._fixFuncIri),e(t.childNodes[n])};e(this.element)},dispose:function(){return xe(this.element._fixFuncIri),this._clearChildrenFuncIri(),this._getJQElement().remove(),this},append:function(e){return(e||this.renderer.root).element.appendChild(this.element),this},remove:function(){var e=this.element;return e.parentNode&&e.parentNode.removeChild(e),this},enableLinks:function(){return this._links=[],this},virtualLink:function(e){return De({_link:ye(null,e)},this),this},linkAfter:function(e){return this._linkAfter=e,this},linkOn:function(e,t){return this._link=ye(e,t),De(this,e),this},linkOff:function(){return Te(this),this._link=null,this},linkAppend:function(){var e,t,n=this._link,i=n.to._links;for(e=n.i+1;(t=i[e])&&!t._link.is;++e);return this._insert(n.to,t),n.is=!0,this},_insert:function(e,t){e.element.insertBefore(this.element,t?t.element:null)},linkRemove:function(){return this.remove(),this._link.is=!1,this},clear:function(){return this._clearChildrenFuncIri(),this._getJQElement().empty(),this},toBackground:function(){var e=this.element,t=e.parentNode;return t&&t.insertBefore(e,t.firstChild),this},toForeground:function(){var e=this.element,t=e.parentNode;return t&&t.appendChild(e),this},attr:function(e){return R(this,e)},smartAttr:function(e){return this.attr(v(this,e))},css:function(e){return O(this,e)},animate:function(e,t,n){return _e(this,e,t,n)},sharp:function(e,t){return this.attr({sharp:e||!0,sharpDirection:t})},_applyTransformation:function(){var e,t,n=this._settings,i=[],o=n.sharp,a=n.sharpDirection||1,r=n[ut]%2,s=!r||"h"!==o&&o!==!0?0:ot*a,l=!r||"v"!==o&&o!==!0?0:ot*a;i.push("translate("+((n.translateX||0)+s)+","+((n.translateY||0)+l)+")"),n.rotate&&(e="rotateX"in n?n.rotateX:n.x,t="rotateY"in n?n.rotateY:n.y,i.push("rotate("+n.rotate+","+(e||0)+","+(t||0)+")"));var u=(0,Ke.isDefined)(n.scaleX),