/*!
* DevExtreme (dx.messages.lt.js)
* Version: 22.2.6
* Build date: Tue Apr 18 2023
*
* Copyright (c) 2012 - 2023 Developer Express Inc. ALL RIGHTS RESERVED
* Read about DevExtreme licensing here: https://js.devexpress.com/Licensing/
*/
"use strict";

! function(root, factory) {
    if ("function" === typeof define && define.amd) {
        define((function(require) {
            factory(require("devextreme/localization"))
        }))
    } else if ("object" === typeof module && module.exports) {
        factory(require("devextreme/localization"))
    } else {
        factory(DevExpress.localization)
    }
}(0, (function(localization) {
    localization.loadMessages({
        lt: {
            Yes: "Taip",
            No: "Ne",
            Cancel: "At\u0161aukti",
            Close: "U\u017edaryti",
            Clear: "Ai\u0161ku",
            Done: "padaryta",
            Loading: "Pakrovimas ...",
            Select: "Pasirinkite ...",
            Search: "Paie\u0161ka",
            Back: "Atgal",
            OK: "Gerai",
            "dxCollectionWidget-noDataText": "N\u0117ra duomen\u0173, kuriuos reikia rodyti",
            "dxDropDownEditor-selectLabel": "Pasirinkite",
            "validation-required": "B\u016btinas",
            "validation-required-formatted": "{0} reikalingas",
            "validation-numeric": "Vert\u0117 turi b\u016bti skai\u010dius",
            "validation-numeric-formatted": "{0} turi b\u016bti skai\u010dius",
            "validation-range": "Vert\u0117 n\u0117ra diapazono",
            "validation-range-formatted": "{0} n\u0117ra diapazono",
            "validation-stringLength": "Vert\u0117s ilgis n\u0117ra teisingas",
            "validation-stringLength-formatted": "{0} ilgis n\u0117ra teisingas",
            "validation-custom": "Vert\u0117 neteisinga",
            "validation-custom-formatted": "{0} neteisinga",
            "validation-async": "Vert\u0117 neteisinga",
            "validation-async-formatted": "{0} neteisinga",
            "validation-compare": "Vertyb\u0117s nesutampa",
            "validation-compare-formatted": "{0} nesutampa",
            "validation-pattern": "Vert\u0117 neatitinka modelio",
            "validation-pattern-formatted": "{0} neatitinka modelio",
            "validation-email": "El. Pa\u0161tas neteisingas",
            "validation-email-formatted": "{0} neteisinga",
            "validation-mask": "Vert\u0117 neteisinga",
            "dxLookup-searchPlaceholder": "Minimalus simbolio numeris: {0}",
            "dxList-pullingDownText": "Atsitraukite, kad atnaujintum\u0117te ...",
            "dxList-pulledDownText": "Atleiskite atnaujinti ...",
            "dxList-refreshingText": "Gaivus ...",
            "dxList-pageLoadingText": "Pakrovimas ...",
            "dxList-nextButtonText": "Daugiau",
            "dxList-selectAll": "Pasirinkti visk\u0105",
            "dxListEditDecorator-delete": "I\u0161trinti",
            "dxListEditDecorator-more": "Daugiau",
            "dxScrollView-pullingDownText": "Atsitraukite, kad atnaujintum\u0117te ...",
            "dxScrollView-pulledDownText": "Atleiskite atnaujinti ...",
            "dxScrollView-refreshingText": "Gaivus ...",
            "dxScrollView-reachBottomText": "Pakrovimas ...",
            "dxDateBox-simulatedDataPickerTitleTime": "Pasirinkite Laikas",
            "dxDateBox-simulatedDataPickerTitleDate": "Pasirinkite Dat\u0105",
            "dxDateBox-simulatedDataPickerTitleDateTime": "Pasirinkite dat\u0105 ir laik\u0105",
            "dxDateBox-validation-datetime": "Vert\u0117 turi b\u016bti data ar laikas",
            "dxFileUploader-selectFile": "Pasirinkite fail\u0105",
            "dxFileUploader-dropFile": "Arba atsisakykite failo \u010dia",
            "dxFileUploader-bytes": "baitai",
            "dxFileUploader-kb": "kb",
            "dxFileUploader-Mb": "MB",
            "dxFileUploader-Gb": "GB",
            "dxFileUploader-upload": "\u012ekelti",
            "dxFileUploader-uploaded": "\u012ekelta",
            "dxFileUploader-readyToUpload": "Paruo\u0161ta \u012fkelti",
            "dxFileUploader-uploadAbortedMessage": "\u012ekelti at\u0161aukt\u0105",
            "dxFileUploader-uploadFailedMessage": "\u012ekelti nepavyko",
            "dxFileUploader-invalidFileExtension": "Failo tipas neleid\u017eiamas",
            "dxFileUploader-invalidMaxFileSize": "Failas yra per didelis",
            "dxFileUploader-invalidMinFileSize": "Failas yra per ma\u017eas",
            "dxRangeSlider-ariaFrom": "Nuo",
            "dxRangeSlider-ariaTill": "Iki",
            "dxSwitch-switchedOnText": "Ant",
            "dxSwitch-switchedOffText": "I\u0161jungtas",
            "dxForm-optionalMark": "neprivaloma",
            "dxForm-requiredMessage": "{0} reikalingas",
            "dxNumberBox-invalidValueMessage": "Vert\u0117 turi b\u016bti skai\u010dius",
            "dxNumberBox-noDataText": "N\u0117ra duomen\u0173",
            "dxDataGrid-columnChooserTitle": "Stulpelio pasirinkimas",
            "dxDataGrid-columnChooserEmptyText": "Vilkite stulpel\u012f \u010dia, kad j\u012f pasl\u0117ptum\u0117te",
            "dxDataGrid-groupContinuesMessage": "T\u0119siamas kitame puslapyje",
            "dxDataGrid-groupContinuedMessage": "T\u0119sinys i\u0161 ankstesnio puslapio",
            "dxDataGrid-groupHeaderText": "Grup\u0117 pagal \u0161\u012f stulpel\u012f",
            "dxDataGrid-ungroupHeaderText": "Nesugeb\u0117jimas",
            "dxDataGrid-ungroupAllText": "Ne visi",
            "dxDataGrid-editingEditRow": "Redaguoti",
            "dxDataGrid-editingSaveRowChanges": "Sutaupyti",
            "dxDataGrid-editingCancelRowChanges": "At\u0161aukti",
            "dxDataGrid-editingDeleteRow": "I\u0161trinti",
            "dxDataGrid-editingUndeleteRow": "Nei\u0161nyk\u0119s",
            "dxDataGrid-editingConfirmDeleteMessage": "Ar tikrai norite i\u0161trinti \u0161\u012f \u012fra\u0161\u0105?",
            "dxDataGrid-validationCancelChanges": "At\u0161aukti pakeitimus",
            "dxDataGrid-groupPanelEmptyText": "Vilkite stulpelio antra\u0161t\u0119 \u010dia, kad gal\u0117tum\u0117te grupuoti pagal t\u0105 stulpel\u012f",
            "dxDataGrid-noDataText": "N\u0117ra duomen\u0173",
            "dxDataGrid-searchPanelPlaceholder": "Paie\u0161ka...",
            "dxDataGrid-filterRowShowAllText": "(Visi)",
            "dxDataGrid-filterRowResetOperationText": "Atstatyti",
            "dxDataGrid-filterRowOperationEquals": "Lygus",
            "dxDataGrid-filterRowOperationNotEquals": "Neprilygsta",
            "dxDataGrid-filterRowOperationLess": "Ma\u017eiau nei",
            "dxDataGrid-filterRowOperationLessOrEquals": "Ma\u017eiau ar lygus",
            "dxDataGrid-filterRowOperationGreater": "Geresnis negu",
            "dxDataGrid-filterRowOperationGreaterOrEquals": "Didesnis arba lygus",
            "dxDataGrid-filterRowOperationStartsWith": "Prasideda su",
            "dxDataGrid-filterRowOperationContains": "Sud\u0117tyje",
            "dxDataGrid-filterRowOperationNotContains": "N\u0117ra",
            "dxDataGrid-filterRowOperationEndsWith": "Baigiasi",
            "dxDataGrid-filterRowOperationBetween": "Tarp",
            "dxDataGrid-filterRowOperationBetweenStartText": "Prad\u0117ti",
            "dxDataGrid-filterRowOperationBetweenEndText": "Pabaiga",
            "dxDataGrid-applyFilterText": "Taikyti filtr\u0105",
            "dxDataGrid-trueText": "tiesa",
            "dxDataGrid-falseText": "melaginga",
            "dxDataGrid-sortingAscendingText": "R\u016b\u0161iuoti kylantys",
            "dxDataGrid-sortingDescendingText": "R\u016b\u0161iuoti ma\u017e\u0117jant",
            "dxDataGrid-sortingClearText": "Ai\u0161kus r\u016b\u0161iavimas",
            "dxDataGrid-editingSaveAllChanges": "I\u0161saugoti pakeitimus",
            "dxDataGrid-editingCancelAllChanges": "Atsisakyti pakeitim\u0173",
            "dxDataGrid-editingAddRow": "Prid\u0117ti eilut\u0119",
            "dxDataGrid-summaryMin": "Min: {0}",
            "dxDataGrid-summaryMinOtherColumn": "{1} yra {0}",
            "dxDataGrid-summaryMax": "Max: {0}",
            "dxDataGrid-summaryMaxOtherColumn": "{1} maks. Yra {0}",
            "dxDataGrid-summaryAvg": "Avg: {0}",
            "dxDataGrid-summaryAvgOtherColumn": "{1} yra {0}",
            "dxDataGrid-summarySum": "Suma: {0}",
            "dxDataGrid-summarySumOtherColumn": "{1} suma yra {0}",
            "dxDataGrid-summaryCount": "Skai\u010diavimas: {0}",
            "dxDataGrid-columnFixingFix": "Pataisymas",
            "dxDataGrid-columnFixingUnfix": "Nefix",
            "dxDataGrid-columnFixingLeftPosition": "\u012e kair\u0119",
            "dxDataGrid-columnFixingRightPosition": "\u012e de\u0161in\u0119",
            "dxDataGrid-exportTo": "Eksportas",
            "dxDataGrid-exportToExcel": "Eksportuoti \u012f \u201eExcel\u201c fail\u0105",
            "dxDataGrid-exporting": "Eksportuoja ...",
            "dxDataGrid-excelFormat": "\u201eExcel\u201c failas",
            "dxDataGrid-selectedRows": "Pasirinktos eilut\u0117s",
            "dxDataGrid-exportSelectedRows": "Eksportuoti pasirinktas eilutes \u012f {0}",
            "dxDataGrid-exportAll": "Eksportuoti visus duomenis \u012f {0}",
            "dxDataGrid-headerFilterLabel": "Filter options",
            "dxDataGrid-headerFilterIndicatorLabel": "Show filter options for column '{0}'",
            "dxDataGrid-headerFilterEmptyValue": "(Ruo\u0161iniai)",
            "dxDataGrid-headerFilterOK": "Gerai",
            "dxDataGrid-headerFilterCancel": "At\u0161aukti",
            "dxDataGrid-ariaAdaptiveCollapse": "Sl\u0117pti papildom\u0173 duomen\u0173",
            "dxDataGrid-ariaAdaptiveExpand": "Rodyti papildomus duomenis",
            "dxDataGrid-ariaColumn": "Stulpelis",
            "dxDataGrid-ariaValue": "Vert\u0117",
            "dxDataGrid-ariaFilterCell": "Filtro l\u0105stel\u0117",
            "dxDataGrid-ariaCollapse": "\u017dlugimas",
            "dxDataGrid-ariaExpand": "I\u0161pl\u0117sti",
            "dxDataGrid-ariaDataGrid": "Duomen\u0173 tinklas",
            "dxDataGrid-ariaSearchInGrid": "Ie\u0161kokite duomen\u0173 tinklelyje",
            "dxDataGrid-ariaSelectAll": "Pasirinkti visk\u0105",
            "dxDataGrid-ariaSelectRow": "Pasirinkite eilut\u0119",
            "dxDataGrid-ariaToolbar": "Duomen\u0173 tinklo \u012franki\u0173 juosta",
            "dxDataGrid-filterBuilderPopupTitle": "Filtr\u0173 k\u016br\u0117jas",
            "dxDataGrid-filterPanelCreateFilter": "Sukurti filtr\u0105",
            "dxDataGrid-filterPanelClearFilter": "Ai\u0161ku",
            "dxDataGrid-filterPanelFilterEnabledHint": "\u012egalinti filtr\u0105",
            "dxTreeList-ariaTreeList": "Med\u017ei\u0173 s\u0105ra\u0161as",
            "dxTreeList-ariaSearchInGrid": "Paie\u0161ka med\u017ei\u0173 s\u0105ra\u0161e",
            "dxTreeList-ariaToolbar": "Med\u017ei\u0173 s\u0105ra\u0161o \u012franki\u0173 juosta",
            "dxTreeList-editingAddRowToNode": "Papildyti",
            "dxPager-infoText": "Puslapis {0} i\u0161 {1} ({2} elementai)",
            "dxPager-pagesCountText": "apie",
            "dxPager-pageSizesAllText": "Viskas",
            "dxPager-page": "Puslapis {0}",
            "dxPager-prevPage": "Ankstesnis puslapis",
            "dxPager-nextPage": "Kitas puslapis",
            "dxPager-ariaLabel": "Puslapio nar\u0161ymas",
            "dxPivotGrid-grandTotal": "I\u0161 viso",
            "dxPivotGrid-total": "{0} i\u0161 viso",
            "dxPivotGrid-fieldChooserTitle": "Lauko pasirink\u0117jas",
            "dxPivotGrid-showFieldChooser": "Rodyti lauko pasirinkim\u0105",
            "dxPivotGrid-expandAll": "I\u0161pl\u0117sti visk\u0105",
            "dxPivotGrid-collapseAll": "Sugriauti visus",
            "dxPivotGrid-sortColumnBySummary": "R\u016b\u0161iuoti \u201e{0}\u201c pagal \u0161\u012f stulpel\u012f",
            "dxPivotGrid-sortRowBySummary": "R\u016b\u0161iuoti \u201e{0}\u201c pagal \u0161i\u0105 eilut\u0119",
            "dxPivotGrid-removeAllSorting": "Pa\u0161alinkite vis\u0105 r\u016b\u0161iavim\u0105",
            "dxPivotGrid-dataNotAvailable": "N/A.",
            "dxPivotGrid-rowFields": "Eilut\u0117s laukai",
            "dxPivotGrid-columnFields": "Stulpeli\u0173 laukai",
            "dxPivotGrid-dataFields": "Duomen\u0173 laukai",
            "dxPivotGrid-filterFields": "Filtr\u0173 laukai",
            "dxPivotGrid-allFields": "Visi laukai",
            "dxPivotGrid-columnFieldArea": "Drentelkite stulpeli\u0173 laukus \u010dia",
            "dxPivotGrid-dataFieldArea": "Duomen\u0173 laukai \u010dia",
            "dxPivotGrid-rowFieldArea": "Drentelkite eil\u0117s laukus \u010dia",
            "dxPivotGrid-filterFieldArea": "Drop filtro laukai \u010dia",
            "dxScheduler-editorLabelTitle": "Tema",
            "dxScheduler-editorLabelStartDate": "Prad\u017eios data",
            "dxScheduler-editorLabelEndDate": "Pabaigos data",
            "dxScheduler-editorLabelDescription": "apib\u016bdinimas",
            "dxScheduler-editorLabelRecurrence": "Pakartoti",
            "dxScheduler-openAppointment": "Atviras paskyrimas",
            "dxScheduler-recurrenceNever": "Niekada",
            "dxScheduler-recurrenceMinutely": "Kiekviena minut\u0117",
            "dxScheduler-recurrenceHourly": "Valandos",
            "dxScheduler-recurrenceDaily": "Kasdien",
            "dxScheduler-recurrenceWeekly": "Savaitra\u0161tis",
            "dxScheduler-recurrenceMonthly": "M\u0117nesinis",
            "dxScheduler-recurrenceYearly": "Kasmet",
            "dxScheduler-recurrenceRepeatEvery": "Pakartokite kiekvien\u0105",
            "dxScheduler-recurrenceRepeatOn": "Pakartokite",
            "dxScheduler-recurrenceEnd": "Pabaigos pakartojimas",
            "dxScheduler-recurrenceAfter": "Po",
            "dxScheduler-recurrenceOn": "Ant",
            "dxScheduler-recurrenceRepeatMinutely": "minut\u0117 (-os)",
            "dxScheduler-recurrenceRepeatHourly": "valanda (-os)",
            "dxScheduler-recurrenceRepeatDaily": "Diena (-os)",
            "dxScheduler-recurrenceRepeatWeekly": "savait\u0117 (-os)",
            "dxScheduler-recurrenceRepeatMonthly": "m\u0117nesi\u0173)",
            "dxScheduler-recurrenceRepeatYearly": "Metai (-ai)",
            "dxScheduler-switcherDay": "Diena",
            "dxScheduler-switcherWeek": "Savait\u0117",
            "dxScheduler-switcherWorkWeek": "Darbo savait\u0117",
            "dxScheduler-switcherMonth": "M\u0117nuo",
            "dxScheduler-switcherAgenda": "Darbotvark\u0117",
            "dxScheduler-switcherTimelineDay": "Laiko linijos diena",
            "dxScheduler-switcherTimelineWeek": "Laiko linijos savait\u0117",
            "dxScheduler-switcherTimelineWorkWeek": "Laiko juostos darbo savait\u0117",
            "dxScheduler-switcherTimelineMonth": "Laiko juosta",
            "dxScheduler-recurrenceRepeatOnDate": "data",
            "dxScheduler-recurrenceRepeatCount": "\u012fvykis (-ai)",
            "dxScheduler-allDay": "Vis\u0105 dien\u0105",
            "dxScheduler-confirmRecurrenceEditMessage": "Ar norite redaguoti tik \u0161\u012f paskyrim\u0105 ar vis\u0105 serij\u0105?",
            "dxScheduler-confirmRecurrenceDeleteMessage": "Ar norite i\u0161trinti tik \u0161\u012f paskyrim\u0105 ar vis\u0105 serij\u0105?",
            "dxScheduler-confirmRecurrenceEditSeries": "Redaguoti serij\u0105",
            "dxScheduler-confirmRecurrenceDeleteSeries": "I\u0161trinti serijas",
            "dxScheduler-confirmRecurrenceEditOccurrence": "Redaguoti paskyrim\u0105",
            "dxScheduler-confirmRecurrenceDeleteOccurrence": "I\u0161trinti susitikim\u0105",
            "dxScheduler-noTimezoneTitle": "N\u0117ra laiko juostos",
            "dxScheduler-moreAppointments": "{0} daugiau",
            "dxCalendar-todayButtonText": "\u0160iandien",
            "dxCalendar-ariaWidgetName": "Kalendorius",
            "dxColorView-ariaRed": "Raudonas",
            "dxColorView-ariaGreen": "\u017dalias",
            "dxColorView-ariaBlue": "M\u0117lyna",
            "dxColorView-ariaAlpha": "Skaidrumas",
            "dxColorView-ariaHex": "Spalvotas kodas",
            "dxTagBox-selected": "{0} pasirinkta",
            "dxTagBox-allSelected": "Visi pasirinkti ({0})",
            "dxTagBox-moreSelected": "{0} daugiau",
            "vizExport-printingButtonText": "Spausdinti",
            "vizExport-titleMenuText": "Eksportas/spausdinimas",
            "vizExport-exportButtonText": "{0} failas",
            "dxFilterBuilder-and": "Ir",
            "dxFilterBuilder-or": "Arba",
            "dxFilterBuilder-notAnd": "Ne ir",
            "dxFilterBuilder-notOr": "Ne arba",
            "dxFilterBuilder-addCondition": "Prid\u0117ti s\u0105lyg\u0105",
            "dxFilterBuilder-addGroup": "Prid\u0117ti grup\u0119",
            "dxFilterBuilder-enterValueText": "<\u012eveskite vert\u0119>",
            "dxFilterBuilder-filterOperationEquals": "Lygus",
            "dxFilterBuilder-filterOperationNotEquals": "Neprilygsta",
            "dxFilterBuilder-filterOperationLess": "Ma\u017eiau nei",
            "dxFilterBuilder-filterOperationLessOrEquals": "Yra ma\u017eesnis arba lygus",
            "dxFilterBuilder-filterOperationGreater": "Yra didesnis nei",
            "dxFilterBuilder-filterOperationGreaterOrEquals": "Yra didesnis arba lygus",
            "dxFilterBuilder-filterOperationStartsWith": "Prasideda su",
            "dxFilterBuilder-filterOperationContains": "Sud\u0117tyje",
            "dxFilterBuilder-filterOperationNotContains": "N\u0117ra",
            "dxFilterBuilder-filterOperationEndsWith": "Baigiasi",
            "dxFilterBuilder-filterOperationIsBlank": "Yra tu\u0161\u010dias",
            "dxFilterBuilder-filterOperationIsNotBlank": "N\u0117ra tu\u0161\u010dias",
            "dxFilterBuilder-filterOperationBetween": "Yra tarp",
            "dxFilterBuilder-filterOperationAnyOf": "Yra bet kuris i\u0161",
            "dxFilterBuilder-filterOperationNoneOf": "N\u0117ra",
            "dxHtmlEditor-dialogColorCaption": "Pakeiskite \u0161rifto spalv\u0105",
            "dxHtmlEditor-dialogBackgroundCaption": "Pakeiskite fono spalv\u0105",
            "dxHtmlEditor-dialogLinkCaption": "Prid\u0117ti nuorod\u0105",
            "dxHtmlEditor-dialogLinkUrlField": "URL",
            "dxHtmlEditor-dialogLinkTextField": "Tekstas",
            "dxHtmlEditor-dialogLinkTargetField": "Atidarykite nuorod\u0105 naujame lange",
            "dxHtmlEditor-dialogImageCaption": "Prid\u0117kite vaizd\u0105",
            "dxHtmlEditor-dialogImageUrlField": "URL",
            "dxHtmlEditor-dialogImageAltField": "Pakaitinis tekstas",
            "dxHtmlEditor-dialogImageWidthField": "Plotis (px)",
            "dxHtmlEditor-dialogImageHeightField": "Auk\u0161tis (PX)",
            "dxHtmlEditor-dialogInsertTableRowsField": "Eilut\u0117s",
            "dxHtmlEditor-dialogInsertTableColumnsField": "Stulpeliai",
            "dxHtmlEditor-dialogInsertTableCaption": "\u012eterpti lentel\u0119",
            "dxHtmlEditor-dialogUpdateImageCaption": "Atnaujinkite vaizd\u0105",
            "dxHtmlEditor-dialogImageUpdateButton": "Atnaujinimas",
            "dxHtmlEditor-dialogImageAddButton": "Papildyti",
            "dxHtmlEditor-dialogImageSpecifyUrl": "I\u0161 interneto",
            "dxHtmlEditor-dialogImageSelectFile": "I\u0161 \u0161io \u012frenginio",
            "dxHtmlEditor-dialogImageKeepAspectRatio": "Saugokite kra\u0161tini\u0173 santyk\u012f",
            "dxHtmlEditor-dialogImageEncodeToBase64": "Kod\u0105 \u012f baz\u011964",
            "dxHtmlEditor-heading": "Antra\u0161t\u0117",
            "dxHtmlEditor-normalText": "Normalus tekstas",
            "dxHtmlEditor-background": "Fono spalva",
            "dxHtmlEditor-bold": "Pary\u0161kintasis",
            "dxHtmlEditor-color": "\u0160rifto spalva",
            "dxHtmlEditor-font": "\u0160riftas",
            "dxHtmlEditor-italic": "Kursyvu",
            "dxHtmlEditor-link": "Prid\u0117ti nuorod\u0105",
            "dxHtmlEditor-image": "Prid\u0117kite vaizd\u0105",
            "dxHtmlEditor-size": "Dydis",
            "dxHtmlEditor-strike": "Perbrauktasis",
            "dxHtmlEditor-subscript": "Indeksas",
            "dxHtmlEditor-superscript": "Vir\u0161utinis indeksas",
            "dxHtmlEditor-underline": "Pabraukimas",
            "dxHtmlEditor-blockquote": "Citata",
            "dxHtmlEditor-header": "Antra\u0161t\u0117",
            "dxHtmlEditor-increaseIndent": "Padidinti \u012ftrauk\u0105",
            "dxHtmlEditor-decreaseIndent": "Suma\u017einti \u012ftrauk\u0105",
            "dxHtmlEditor-orderedList": "U\u017esakytas s\u0105ra\u0161as",
            "dxHtmlEditor-bulletList": "Kulk\u0173 s\u0105ra\u0161as",
            "dxHtmlEditor-alignLeft": "Lyginkite kair\u0119",
            "dxHtmlEditor-alignCenter": "Klijavimo centras",
            "dxHtmlEditor-alignRight": "Lygiuokite de\u0161in\u0119",
            "dxHtmlEditor-alignJustify": "Suderinti teising\u0105",
            "dxHtmlEditor-codeBlock": "Kodo blokas",
            "dxHtmlEditor-variable": "Prid\u0117ti kintam\u0105j\u012f",
            "dxHtmlEditor-undo": "Anulia",
            "dxHtmlEditor-redo": "Perdaryti",
            "dxHtmlEditor-clear": "Ai\u0161kus formatavimas",
            "dxHtmlEditor-insertTable": "\u012eterpti lentel\u0119",
            "dxHtmlEditor-insertHeaderRow": "\u012ed\u0117kite antra\u0161t\u0117s eilut\u0119",
            "dxHtmlEditor-insertRowAbove": "\u012ed\u0117kite eilut\u0119 auk\u0161\u010diau",
            "dxHtmlEditor-insertRowBelow": "\u012eterpkite eilut\u0119 \u017eemiau",
            "dxHtmlEditor-insertColumnLeft": "\u012eterpkite stulpel\u012f kair\u0117je",
            "dxHtmlEditor-insertColumnRight": "\u012ed\u0117kite stulpel\u012f de\u0161in\u0117je",
            "dxHtmlEditor-deleteColumn": "I\u0161trinti stulpel\u012f",
            "dxHtmlEditor-deleteRow": "I\u0161trinti eilut\u0119",
            "dxHtmlEditor-deleteTable": "I\u0161trinti lentel\u0119",
            "dxHtmlEditor-cellProperties": "L\u0105steli\u0173 savyb\u0117s",
            "dxHtmlEditor-tableProperties": "Lentel\u0117s savyb\u0117s",
            "dxHtmlEditor-insert": "\u012ed\u0117ti",
            "dxHtmlEditor-delete": "I\u0161trinti",
            "dxHtmlEditor-border": "Pasienis",
            "dxHtmlEditor-style": "Stilius",
            "dxHtmlEditor-width": "Plotis",
            "dxHtmlEditor-height": "\u016agis",
            "dxHtmlEditor-borderColor": "Spalva",
            "dxHtmlEditor-tableBackground": "Fonas",
            "dxHtmlEditor-dimensions": "Matmenys",
            "dxHtmlEditor-alignment": "Suderinimas",
            "dxHtmlEditor-horizontal": "Horizontalus",
            "dxHtmlEditor-vertical": "Vertikali",
            "dxHtmlEditor-paddingVertical": "Vertikalus pamink\u0161tinimas",
            "dxHtmlEditor-paddingHorizontal": "Horizontalus pamink\u0161tinimas",
            "dxHtmlEditor-pixels": "Ta\u0161kai",
            "dxHtmlEditor-list": "S\u0105ra\u0161as",
            "dxHtmlEditor-ordered": "U\u017esakyta",
            "dxHtmlEditor-bullet": "Kulka",
            "dxHtmlEditor-align": "Lygi",
            "dxHtmlEditor-center": "Centras",
            "dxHtmlEditor-left": "Kair\u0117je",
            "dxHtmlEditor-right": "Teisingai",
            "dxHtmlEditor-indent": "\u012etrauka",
            "dxHtmlEditor-justify": "Pateisinti",
            "dxFileManager-newDirectoryName": "Be pavadinimo katalogas",
            "dxFileManager-rootDirectoryName": "Failai",
            "dxFileManager-errorNoAccess": "Prieiga atmesta. Operacijos negal\u0117jo b\u016bti baigta.",
            "dxFileManager-errorDirectoryExistsFormat": "Katalogas '{0}' jau egzistuoja.",
            "dxFileManager-errorFileExistsFormat": "Failas '{0}' jau egzistuoja.",
            "dxFileManager-errorFileNotFoundFormat": "Failas '{0}' nerastas.",
            "dxFileManager-errorDirectoryNotFoundFormat": "Katalogas '{0}' nerastas.",
            "dxFileManager-errorWrongFileExtension": "Failo pl\u0117tinys neleid\u017eiamas.",
            "dxFileManager-errorMaxFileSizeExceeded": "Failo dydis vir\u0161ija maksimal\u0173 leistin\u0105 dyd\u012f.",
            "dxFileManager-errorInvalidSymbols": "\u0160iame pavadinime yra negaliojan\u010di\u0173 simboli\u0173.",
            "dxFileManager-errorDefault": "Nepatikslinta klaida.",
            "dxFileManager-errorDirectoryOpenFailed": "Katalogo negalima atidaryti",
            "dxFileManager-commandCreate": "Naujas katalogas",
            "dxFileManager-commandRename": "Pervardyti",
            "dxFileManager-commandMove": "Pereiti prie",
            "dxFileManager-commandCopy": "Nukopijuoti",
            "dxFileManager-commandDelete": "I\u0161trinti",
            "dxFileManager-commandDownload": "parsisi\u0173sti",
            "dxFileManager-commandUpload": "\u012ekelti failus",
            "dxFileManager-commandRefresh": "Atnaujinti",
            "dxFileManager-commandThumbnails": "Miniati\u016bros vaizdas",
            "dxFileManager-commandDetails": "Informacijos vaizdas",
            "dxFileManager-commandClearSelection": "Ai\u0161kus pasirinkimas",
            "dxFileManager-commandShowNavPane": "Perjunkite navigacijos srit\u012f",
            "dxFileManager-dialogDirectoryChooserMoveTitle": "Pereiti prie",
            "dxFileManager-dialogDirectoryChooserMoveButtonText": "Jud\u0117ti",
            "dxFileManager-dialogDirectoryChooserCopyTitle": "Nukopijuoti",
            "dxFileManager-dialogDirectoryChooserCopyButtonText": "Kopijuoti",
            "dxFileManager-dialogRenameItemTitle": "Pervardyti",
            "dxFileManager-dialogRenameItemButtonText": "Sutaupyti",
            "dxFileManager-dialogCreateDirectoryTitle": "Naujas katalogas",
            "dxFileManager-dialogCreateDirectoryButtonText": "Sukurti",
            "dxFileManager-dialogDeleteItemTitle": "I\u0161trinti",
            "dxFileManager-dialogDeleteItemButtonText": "I\u0161trinti",
            "dxFileManager-dialogDeleteItemSingleItemConfirmation": "Ar tikrai norite i\u0161trinti {0}?",
            "dxFileManager-dialogDeleteItemMultipleItemsConfirmation": "Ar tikrai norite i\u0161trinti {0} elementus?",
            "dxFileManager-dialogButtonCancel": "At\u0161aukti",
            "dxFileManager-editingCreateSingleItemProcessingMessage": "Katalogo k\u016brimas {0} viduje",
            "dxFileManager-editingCreateSingleItemSuccessMessage": "Suk\u016br\u0117 katalog\u0105 {0} viduje",
            "dxFileManager-editingCreateSingleItemErrorMessage": "Katalogas nebuvo sukurtas",
            "dxFileManager-editingCreateCommonErrorMessage": "Katalogas nebuvo sukurtas",
            "dxFileManager-editingRenameSingleItemProcessingMessage": "Prek\u0117s pervadinimas {0} viduje",
            "dxFileManager-editingRenameSingleItemSuccessMessage": "Pervadintas daikto viduje {0}",
            "dxFileManager-editingRenameSingleItemErrorMessage": "Prek\u0117 nebuvo pervadinta",
            "dxFileManager-editingRenameCommonErrorMessage": "Prek\u0117 nebuvo pervadinta",
            "dxFileManager-editingDeleteSingleItemProcessingMessage": "I\u0161trinti element\u0105 i\u0161 {0}",
            "dxFileManager-editingDeleteMultipleItemsProcessingMessage": "I\u0161trynimas {0} element\u0173 i\u0161 {1}",
            "dxFileManager-editingDeleteSingleItemSuccessMessage": "I\u0161tryniau element\u0105 i\u0161 {0}",
            "dxFileManager-editingDeleteMultipleItemsSuccessMessage": "I\u0161tryn\u0119 {0} elementai i\u0161 {1}",
            "dxFileManager-editingDeleteSingleItemErrorMessage": "Prek\u0117 nebuvo i\u0161trinta",
            "dxFileManager-editingDeleteMultipleItemsErrorMessage": "{0} elementai nebuvo i\u0161trinti",
            "dxFileManager-editingDeleteCommonErrorMessage": "Kai kurie daiktai nebuvo i\u0161trinti",
            "dxFileManager-editingMoveSingleItemProcessingMessage": "Elemento perk\u0117limas \u012f {0}",
            "dxFileManager-editingMoveMultipleItemsProcessingMessage": "Perkelti {0} elementus \u012f {1}",
            "dxFileManager-editingMoveSingleItemSuccessMessage": "Perk\u0117l\u0117 element\u0105 \u012f {0}",
            "dxFileManager-editingMoveMultipleItemsSuccessMessage": "Perk\u0117l\u0117 {0} elementus \u012f {1}",
            "dxFileManager-editingMoveSingleItemErrorMessage": "Prek\u0117 nebuvo perkelta",
            "dxFileManager-editingMoveMultipleItemsErrorMessage": "{0} daiktai nebuvo perkelti",
            "dxFileManager-editingMoveCommonErrorMessage": "Kai kurie daiktai nebuvo perkelti",
            "dxFileManager-editingCopySingleItemProcessingMessage": "Daikto kopijavimas \u012f {0}",
            "dxFileManager-editingCopyMultipleItemsProcessingMessage": "Kopijavimas {0} element\u0173 \u012f {1}",
            "dxFileManager-editingCopySingleItemSuccessMessage": "Nukopijavo element\u0105 \u012f {0}",
            "dxFileManager-editingCopyMultipleItemsSuccessMessage": "Nukopijavo {0} elementus \u012f {1}",
            "dxFileManager-editingCopySingleItemErrorMessage": "Prek\u0117 nebuvo nukopijuota",
            "dxFileManager-editingCopyMultipleItemsErrorMessage": "{0} daiktai nebuvo nukopijuoti",
            "dxFileManager-editingCopyCommonErrorMessage": "Kai kurie daiktai nebuvo nukopijuoti",
            "dxFileManager-editingUploadSingleItemProcessingMessage": "\u012ekelkite element\u0105 \u012f {0}",
            "dxFileManager-editingUploadMultipleItemsProcessingMessage": "\u012ekelti {0} elementus \u012f {1}",
            "dxFileManager-editingUploadSingleItemSuccessMessage": "\u012ek\u0117l\u0117 element\u0105 \u012f {0}",
            "dxFileManager-editingUploadMultipleItemsSuccessMessage": "\u012ekelta {0} elementai \u012f {1}",
            "dxFileManager-editingUploadSingleItemErrorMessage": "Prek\u0117 nebuvo \u012fkelta",
            "dxFileManager-editingUploadMultipleItemsErrorMessage": "{0} daiktai nebuvo \u012fkelti",
            "dxFileManager-editingUploadCanceledMessage": "At\u0161auktas",
            "dxFileManager-editingDownloadSingleItemErrorMessage": "Prek\u0117 nebuvo atsisi\u0173sta",
            "dxFileManager-editingDownloadMultipleItemsErrorMessage": "{0} elementai nebuvo atsisi\u0173sti",
            "dxFileManager-listDetailsColumnCaptionName": "vardas",
            "dxFileManager-listDetailsColumnCaptionDateModified": "Data pakeista",
            "dxFileManager-listDetailsColumnCaptionFileSize": "Failo dydis",
            "dxFileManager-listThumbnailsTooltipTextSize": "Dydis",
            "dxFileManager-listThumbnailsTooltipTextDateModified": "Data pakeista",
            "dxFileManager-notificationProgressPanelTitle": "Progresas",
            "dxFileManager-notificationProgressPanelEmptyListText": "Joki\u0173 operacij\u0173",
            "dxFileManager-notificationProgressPanelOperationCanceled": "At\u0161auktas",
            "dxDiagram-categoryGeneral": "Bendrasis",
            "dxDiagram-categoryFlowchart": "Schema",
            "dxDiagram-categoryOrgChart": "ORG diagrama",
            "dxDiagram-categoryContainers": "Konteineriai",
            "dxDiagram-categoryCustom": "Paprotys",
            "dxDiagram-commandExportToSvg": "Eksportas \u012f SVG",
            "dxDiagram-commandExportToPng": "Eksportas \u012f PNG",
            "dxDiagram-commandExportToJpg": "Eksportas \u012f JPEG",
            "dxDiagram-commandUndo": "Anulia",
            "dxDiagram-commandRedo": "Perdaryti",
            "dxDiagram-commandFontName": "\u0160rifto vardas",
            "dxDiagram-commandFontSize": "\u0160rifto dydis",
            "dxDiagram-commandBold": "Bold",
            "dxDiagram-commandItalic": "Kursyvu",
            "dxDiagram-commandUnderline": "Pabraukimas",
            "dxDiagram-commandTextColor": "\u0160rifto spalva",
            "dxDiagram-commandLineColor": "Linijos spalva",
            "dxDiagram-commandLineWidth": "Linijos plotis",
            "dxDiagram-commandLineStyle": "Linijos stilius",
            "dxDiagram-commandLineStyleSolid": "Kietas",
            "dxDiagram-commandLineStyleDotted": "Punktyvas",
            "dxDiagram-commandLineStyleDashed": "Punktyvas",
            "dxDiagram-commandFillColor": "U\u017epildykite spalv\u0105",
            "dxDiagram-commandAlignLeft": "Lyginkite kair\u0119",
            "dxDiagram-commandAlignCenter": "Klijavimo centras",
            "dxDiagram-commandAlignRight": "Lygiuokite de\u0161in\u0119",
            "dxDiagram-commandConnectorLineType": "Jungties linijos tipas",
            "dxDiagram-commandConnectorLineStraight": "Tiesus",
            "dxDiagram-commandConnectorLineOrthogonal": "Ortogonalus",
            "dxDiagram-commandConnectorLineStart": "Jungties linijos paleidimas",
            "dxDiagram-commandConnectorLineEnd": "Jungties linijos galas",
            "dxDiagram-commandConnectorLineNone": "N\u0117 vienas",
            "dxDiagram-commandConnectorLineArrow": "Str\u0117l\u0117",
            "dxDiagram-commandFullscreen": "Per vis\u0105 ekran\u0105",
            "dxDiagram-commandUnits": "Vienetai",
            "dxDiagram-commandPageSize": "Puslapio dydis",
            "dxDiagram-commandPageOrientation": "Puslapio orientacija",
            "dxDiagram-commandPageOrientationLandscape": "Kra\u0161tovaizdis",
            "dxDiagram-commandPageOrientationPortrait": "Portretas",
            "dxDiagram-commandPageColor": "Puslapio spalva",
            "dxDiagram-commandShowGrid": "Parodykite tinklel\u012f",
            "dxDiagram-commandSnapToGrid": "Snaps to Grid",
            "dxDiagram-commandGridSize": "Tinklelio dydis",
            "dxDiagram-commandZoomLevel": "Mastelio keitimo lygis",
            "dxDiagram-commandAutoZoom": "Automatinis mastelio keitimas",
            "dxDiagram-commandFitToContent": "Tinkamas turiniui",
            "dxDiagram-commandFitToWidth": "Tinka iki plo\u010dio",
            "dxDiagram-commandAutoZoomByContent": "Automatinis mastelio keitimas pagal turin\u012f",
            "dxDiagram-commandAutoZoomByWidth": "Automatinis mastelio keitimas pagal plot\u012f",
            "dxDiagram-commandSimpleView": "Paprastas vaizdas",
            "dxDiagram-commandCut": "Supjaustytas",
            "dxDiagram-commandCopy": "Kopijuoti",
            "dxDiagram-commandPaste": "\u012eklijuoti",
            "dxDiagram-commandSelectAll": "Pasirinkti visk\u0105",
            "dxDiagram-commandDelete": "I\u0161trinti",
            "dxDiagram-commandBringToFront": "Atne\u0161ti \u012f priek\u012f",
            "dxDiagram-commandSendToBack": "Si\u0173sti atgal",
            "dxDiagram-commandLock": "U\u017erakinti",
            "dxDiagram-commandUnlock": "Atrakinti",
            "dxDiagram-commandInsertShapeImage": "\u012eterpkite vaizd\u0105 ...",
            "dxDiagram-commandEditShapeImage": "Pakeiskite vaizd\u0105 ...",
            "dxDiagram-commandDeleteShapeImage": "I\u0161trinti vaizd\u0105",
            "dxDiagram-commandLayoutLeftToRight": "I\u0161 kair\u0117s \u012f de\u0161in\u0119",
            "dxDiagram-commandLayoutRightToLeft": "I\u0161 de\u0161in\u0117s \u012f kair\u0119",
            "dxDiagram-commandLayoutTopToBottom": "Nuo vir\u0161aus iki apa\u010dios",
            "dxDiagram-commandLayoutBottomToTop": "Nuo apa\u010dios iki vir\u0161aus",
            "dxDiagram-unitIn": "\u012f",
            "dxDiagram-unitCm": "cm",
            "dxDiagram-unitPx": "PX",
            "dxDiagram-dialogButtonOK": "Gerai",
            "dxDiagram-dialogButtonCancel": "At\u0161aukti",
            "dxDiagram-dialogInsertShapeImageTitle": "\u012eterpti vaizd\u0105",
            "dxDiagram-dialogEditShapeImageTitle": "Pakeiskite vaizd\u0105",
            "dxDiagram-dialogEditShapeImageSelectButton": "Pasirinkite Vaizdas",
            "dxDiagram-dialogEditShapeImageLabelText": "Arba atsisakykite failo \u010dia",
            "dxDiagram-uiExport": "Eksportas",
            "dxDiagram-uiProperties": "Savyb\u0117s",
            "dxDiagram-uiSettings": "Nustatymai",
            "dxDiagram-uiShowToolbox": "Rodyti \u012franki\u0173 rinkin\u012f",
            "dxDiagram-uiSearch": "Paie\u0161ka",
            "dxDiagram-uiStyle": "Stilius",
            "dxDiagram-uiLayout": "I\u0161d\u0117stymas",
            "dxDiagram-uiLayoutTree": "Medis",
            "dxDiagram-uiLayoutLayered": "Sluoksniuotas",
            "dxDiagram-uiDiagram": "Diagrama",
            "dxDiagram-uiText": "Tekstas",
            "dxDiagram-uiObject": "Objektas",
            "dxDiagram-uiConnector": "Jungtis",
            "dxDiagram-uiPage": "Puslapis",
            "dxDiagram-shapeText": "Tekstas",
            "dxDiagram-shapeRectangle": "Sta\u010diakampis",
            "dxDiagram-shapeEllipse": "Elips\u0117",
            "dxDiagram-shapeCross": "Kirsti",
            "dxDiagram-shapeTriangle": "Trikampis",
            "dxDiagram-shapeDiamond": "Deimantas",
            "dxDiagram-shapeHeart": "\u0160irdis",
            "dxDiagram-shapePentagon": "Pentagonas",
            "dxDiagram-shapeHexagon": "\u0160e\u0161iakampis",
            "dxDiagram-shapeOctagon": "A\u0161tuonkampis",
            "dxDiagram-shapeStar": "\u017dvaig\u017ed\u0117",
            "dxDiagram-shapeArrowLeft": "Kair\u0117 rodykl\u0117",
            "dxDiagram-shapeArrowUp": "Auk\u0161tyn rodykl\u0117",
            "dxDiagram-shapeArrowRight": "De\u0161in\u0117 rodykl\u0117",
            "dxDiagram-shapeArrowDown": "Rodykl\u0117 \u017eemyn",
            "dxDiagram-shapeArrowUpDown": "Auk\u0161tyn \u017eemyn",
            "dxDiagram-shapeArrowLeftRight": "Kair\u0117je de\u0161in\u0117je rodykl\u0117",
            "dxDiagram-shapeProcess": "Procesas",
            "dxDiagram-shapeDecision": "Sprendimas",
            "dxDiagram-shapeTerminator": "Terminatorius",
            "dxDiagram-shapePredefinedProcess": "I\u0161 anksto nustatytas procesas",
            "dxDiagram-shapeDocument": "Dokumentas",
            "dxDiagram-shapeMultipleDocuments": "Keli dokumentai",
            "dxDiagram-shapeManualInput": "Rankinis \u012fvestis",
            "dxDiagram-shapePreparation": "Paruo\u0161imas",
            "dxDiagram-shapeData": "Duomenys",
            "dxDiagram-shapeDatabase": "Duomen\u0173 baz\u0117",
            "dxDiagram-shapeHardDisk": "Kietasis diskas",
            "dxDiagram-shapeInternalStorage": "Vidin\u0117 atmintis",
            "dxDiagram-shapePaperTape": "Popierin\u0117 juosta",
            "dxDiagram-shapeManualOperation": "Rankinis operacija",
            "dxDiagram-shapeDelay": "U\u017edelsimas",
            "dxDiagram-shapeStoredData": "Saugomi duomenys",
            "dxDiagram-shapeDisplay": "Rodymas",
            "dxDiagram-shapeMerge": "Sujungti",
            "dxDiagram-shapeConnector": "Jungtis",
            "dxDiagram-shapeOr": "Arba",
            "dxDiagram-shapeSummingJunction": "Summing sankry\u017ea",
            "dxDiagram-shapeContainerDefaultText": "Konteineris",
            "dxDiagram-shapeVerticalContainer": "Vertikalusis konteineris",
            "dxDiagram-shapeHorizontalContainer": "Horizontalusis konteineris",
            "dxDiagram-shapeCardDefaultText": "Asmens vardas",
            "dxDiagram-shapeCardWithImageOnLeft": "Kortel\u0117 su vaizdu kair\u0117je",
            "dxDiagram-shapeCardWithImageOnTop": "Kortel\u0117 su vaizdu vir\u0161uje",
            "dxDiagram-shapeCardWithImageOnRight": "Kortel\u0117 su vaizdu de\u0161in\u0117je",
            "dxGantt-dialogTitle": "Pavadinimas",
            "dxGantt-dialogStartTitle": "Prad\u0117ti",
            "dxGantt-dialogEndTitle": "Pabaiga",
            "dxGantt-dialogProgressTitle": "Progresas",
            "dxGantt-dialogResourcesTitle": "\u0160altiniai",
            "dxGantt-dialogResourceManagerTitle": "I\u0161tekli\u0173 valdytojas",
            "dxGantt-dialogTaskDetailsTitle": "I\u0161sami u\u017eduoties informacija",
            "dxGantt-dialogEditResourceListHint": "Redaguoti \u0161altini\u0173 s\u0105ra\u0161\u0105",
            "dxGantt-dialogEditNoResources": "N\u0117ra i\u0161tekli\u0173",
            "dxGantt-dialogButtonAdd": "Papildyti",
            "dxGantt-contextMenuNewTask": "Nauja u\u017eduotis",
            "dxGantt-contextMenuNewSubtask": "Nauja suvystyta",
            "dxGantt-contextMenuDeleteTask": "I\u0161trinti u\u017eduot\u012f",
            "dxGantt-contextMenuDeleteDependency": "I\u0161trinti priklausomyb\u0119",
            "dxGantt-dialogTaskDeleteConfirmation": "U\u017eduoties i\u0161trinimas taip pat i\u0161trina visas jos priklausomybes ir padalijas. Ar tikrai norite i\u0161trinti \u0161i\u0105 u\u017eduot\u012f?",
            "dxGantt-dialogDependencyDeleteConfirmation": "Ar tikrai norite i\u0161trinti priklausomyb\u0119 nuo u\u017eduoties?",
            "dxGantt-dialogResourcesDeleteConfirmation": "\u0160altinio i\u0161trinimas taip pat i\u0161trina j\u012f i\u0161 u\u017eduo\u010di\u0173, kurioms priskiriamas \u0161is \u0161altinis. Ar tikrai norite i\u0161trinti \u0161iuos i\u0161teklius? \u0160altiniai: {0}",
            "dxGantt-dialogConstraintCriticalViolationMessage": "U\u017eduotis, kuri\u0105 bandote jud\u0117ti, yra susijusi su antr\u0105ja u\u017eduotimi priklausomyb\u0117s santykiu. \u0160is pakeitimas prie\u0161taraut\u0173 priklausomyb\u0117s taisykl\u0117ms. Kaip nor\u0117tum\u0117te t\u0119sti?",
            "dxGantt-dialogConstraintViolationMessage": "U\u017eduotis, kuri\u0105 bandote jud\u0117ti, yra susijusi su antr\u0105ja u\u017eduotimi priklausomyb\u0117s santykiu. Kaip nor\u0117tum\u0117te t\u0119sti?",
            "dxGantt-dialogCancelOperationMessage": "At\u0161aukti operacij\u0105",
            "dxGantt-dialogDeleteDependencyMessage": "I\u0161trinkite priklausomyb\u0119",
            "dxGantt-dialogMoveTaskAndKeepDependencyMessage": "Perkelkite u\u017eduot\u012f ir i\u0161laikykite priklausomyb\u0119",
            "dxGantt-dialogConstraintCriticalViolationSeveralTasksMessage": "U\u017eduotis, kuri\u0105 bandote jud\u0117ti, yra susieta su kitomis u\u017eduotimis priklausomyb\u0117s ry\u0161iais. \u0160is pakeitimas prie\u0161taraut\u0173 priklausomyb\u0117s taisykl\u0117ms. Kaip nor\u0117tum\u0117te t\u0119sti?",
            "dxGantt-dialogConstraintViolationSeveralTasksMessage": "U\u017eduotis, kuri\u0105 bandote jud\u0117ti, yra susieta su kitomis u\u017eduotimis priklausomyb\u0117s ry\u0161iais. Kaip nor\u0117tum\u0117te t\u0119sti?",
            "dxGantt-dialogDeleteDependenciesMessage": "I\u0161trinkite priklausomyb\u0117s santykius",
            "dxGantt-dialogMoveTaskAndKeepDependenciesMessage": "Perkelkite u\u017eduot\u012f ir saugokite priklausomybes",
            "dxGantt-undo": "Anulia",
            "dxGantt-redo": "Perdaryti",
            "dxGantt-expandAll": "I\u0161pl\u0117sti visk\u0105",
            "dxGantt-collapseAll": "Sugriauti visus",
            "dxGantt-addNewTask": "Prid\u0117kite nauj\u0105 u\u017eduot\u012f",
            "dxGantt-deleteSelectedTask": "I\u0161trinkite pasirinkt\u0105 u\u017eduot\u012f",
            "dxGantt-zoomIn": "Priartinti",
            "dxGantt-zoomOut": "Nutolinti",
            "dxGantt-fullScreen": "Per vis\u0105 ekran\u0105",
            "dxGantt-quarter": "Q {0}",
            "dxGantt-sortingAscendingText": "R\u016b\u0161iuoti kylantys",
            "dxGantt-sortingDescendingText": "R\u016b\u0161iuoti ma\u017e\u0117jant",
            "dxGantt-sortingClearText": "Ai\u0161kus r\u016b\u0161iavimas",
            "dxGantt-showResources": "Rodyti i\u0161teklius",
            "dxGantt-showDependencies": "Rodyti priklausomybes",
            "dxGantt-dialogStartDateValidation": "Prad\u017eios data turi b\u016bti po {0}",
            "dxGantt-dialogEndDateValidation": "Pabaigos data turi b\u016bti po {0}"
        }
    })
}));
