﻿function InitializeSwagger() {
    // set header
    var swaggerHeaderTimer = setInterval(function () {
        if (document.getElementsByClassName("auth-wrapper").length > 0) {
            
            clearInterval(swaggerHeaderTimer);
            var container = document.createElement("div");
            container.setAttribute("class", "auth-header");
            var logo = document.createElement("img");
            logo.src = "/img/visual-guard-logo.ico";

            var header = document.createElement("h1");
            var descriptionDiv = document.getElementsByClassName("renderedMarkdown");

            if (descriptionDiv.length > 0) {
                header.innerText = document.getElementsByClassName("renderedMarkdown")[0].innerText;
            }
            else {
                header.innerText = "VisualGuardIdentityServer API";
            }

            container.append(logo);
            container.append(header);

            var authWrapper = document.getElementsByClassName("auth-wrapper")[0];
            authWrapper.prepend(container);

            var containerDropdown = document.createElement("div");
            containerDropdown.setAttribute("class", "auth-header-right");

            var specsDropdown = document.getElementsByTagName("select")[0];
            specsDropdown.setAttribute("onchange", "redirect(this.value)");
            var containerForm = document.createElement("form");
            containerForm.append(specsDropdown);
            containerDropdown.append(containerForm);

            var authorizeButton = document.getElementsByClassName("btn authorize unlocked")[0];
            containerDropdown.append(authorizeButton);

            authWrapper.append(containerDropdown);
            authorizeButton.setAttribute("style", "visibility:visible;")
        }
    }, 100);

    var link = document.querySelector("link[rel*='icon']") || document.createElement('link');;
    document.head.removeChild(link);
    link = document.querySelector("link[rel*='icon']") || document.createElement('link');
    document.head.removeChild(link);
    link = document.createElement('link');
    link.type = 'image/x-icon';
    link.rel = 'shortcut icon';
    link.href = '/img/visual-guard-logo.ico';
    document.getElementsByTagName('head')[0].appendChild(link);
}

function redirect(href) {
    var res = href.split("/");
    location.href = location.origin + location.pathname + "?urls.primaryName=" + res[2];
}

if (window.addEventListener) {
    window.addEventListener('load', InitializeSwagger, false); //W3C
} else {
    window.attachEvent('onload', InitializeSwagger, false); //IE
}