﻿$('#btnSaveUrl').on('click', function () {

    if (!IsLocalSettingsValid()) {
        return false;
    }
    if (!SaveLocalSettings_ConfigServerUrl()) {
        return false;
    }
});

$('#btnStep1Next').on('click', function () {

    var repoType = $("#cboConnType").find("option:selected").text();
    var repoTypeS = $("#cboConnType").val();
    let repositoryType;
    $('[id^=repositoryType_]').hide();
    if (repoType == 'SQLServer') {
        repositoryType = 'repositoryType_sql';
    }
    else {
        repositoryType = 'repositoryType_oracle';
    }
    $("#" + repositoryType).show();
    //NextClick($(this));

    var parent_fieldset = $(this).parents('fieldset');
    var next_step = true;
    // navigation steps / progress steps
    var current_active_step = $(this).parents('.f1').find('.f1-step.active');
    var progress_line = $(this).parents('.f1').find('.f1-progress-line');

    parent_fieldset.fadeOut(400, function () {
        //			// change icons
        current_active_step.removeClass('active').addClass('activated').next().addClass('active');
        //			// progress bar
        bar_progress(progress_line, 'right');
        //			// show next step
        $(this).next().fadeIn();
        // 		// scroll window to beginning of the form
        scroll_to_class($('.f1'), 20);

    });
});

$('#btnStep2NextOracle').on('click', function () {
    //debugger;
    var result = false;
    if (IsSQLServerSelected()) {
        if (!IsSQLFormValid(false)) {
            return;
        }
        GenerateConfigurationForSQLRepository();
    }
    else {
        if (!IsOracleFormValid()) {
            return;
        }
        GenerateConfigurationForOracleRepository();
    }
});

$('#btnStep2Next').on('click', function () {
    //debugger;
    var result = false;
    if (IsSQLServerSelected()) {
        if (!IsSQLFormValid(false)) {
            return;
        }
        GenerateConfigurationForSQLRepository();
    }
    else {
        if (!IsOracleFormValid()) {
            return;
        }
        GenerateConfigurationForOracleRepository();
    }
});

$('#btnStep3Next').on('click', function () {

    if (!IsLocalSettingsValid()) {
        return false;
    }
    if (SaveLocalSettings_RepoWizard()) {
        //GoNext($(this));
    }
});
$('#btnStep4Next').on('click', function () {

    RestartServerClick();
});



$('input[type=radio][name=SelectServiceSID]').change(function () {
    //debugger;
    if ($("#ServiceNamerdo").is(':checked')) {
        //alert("ServiceName");
        $("#txtSid").attr("disabled", "disabled");
        $("#txtServiceName").removeAttr("disabled", "disabled");
        $('#txtSid').val('');
    }
    else if ($("#SIDrdo").is(':checked')) {
        //alert("SID");
        $("#txtSid").removeAttr("disabled", "disabled");
        $("#txtServiceName").attr("disabled", "disabled");
        $('#txtServiceName').val('');
    }
});

$("#cboAuthenticationMode").change(function () {
    //debugger;
    if ($(this).val() == 1) {
        $("#txtusername").val('');
        $("#txtpwd").val('');
        $("#divSQLUsername").hide();
        $("#divSQLPwd").hide();

        $('#cbodb').html('');
        var options = '';
        options += '<option value="Select">Select</option>';
        $('#cbodb').append(options);

        //$("#txtusername").attr("disabled", "disabled");
        //$("#txtpwd").attr("disabled", "disabled");
    }
    else {
        //$("#txtusername").removeAttr("disabled");
        //$("#txtpwd").removeAttr("disabled");
        $("#divSQLUsername").show();
        $("#divSQLPwd").show();
        $("#txtusername").focus();

        $('#cbodb').html('');
        var options = '';
        options += '<option value="Select">Select</option>';
        $('#cbodb').append(options);
    }
});





$("#btnFilldb").click(function () {


   // debugger;
    if (!IsSQLFormValid(true)) {
        return false;
    }

    var model = GetFormData();

    //waitingDialog.show();
    //var model = JSON.stringify(formData);

    //ajax call

    $.ajax({
        type: "Post",
        url: "ConfigureRepo/sqlserver/Getdatabases",
        cache: false,
        dataType: 'json',
        contentType: 'application/x-www-form-urlencoded; charset=UTF-8',
        data: model,
        success: function (data) {
            debugger;
            if (data.databaseList.length > 0) {
                $('#cbodb').html('');
                var options = '';
                options += '<option value="Select">Select</option>';
                for (var i = 0; i < data.databaseList.length; i++) {
                    options += '<option value="' + data.databaseList[i] + '">' + data.databaseList[i] + '</option>';
                }
                $('#cbodb').append(options);
                //waitingDialog.hide();
                return false;
            }
            else {
                //waitingDialog.hide();

                $('#cbodb').html('');
                var options = '';
                options += '<option value="Select">Select</option>';                
                $('#cbodb').append(options);

                var bodymsg = data.errorInfo; //"Could not fetch the database list, Please check the credentials or privileges";
                var body = '<img src="../img/vgidentityserver/InCorrect.png" /> ' + bodymsg;
                $("#mydialog .modal-body").html(body);
                $("#mydialog").modal('show');
            }
        },
        failed: function (err) {
            //waitingDialog.hide();
            console.log(err);
            return false;
        }
    });
});

$("#btnTestSqlConnection").click(function () {
    if (!IsSQLFormValid(false)) {
        return false;
    }

    //waitingDialog.show();
    /*$('#action').val('@strTestConnection');*/
    var form = GetFormData();
    $.ajax({
        type: "POST",
        url: "ConfigureRepo/sqlserver/TestConnection",
        cache: false,
        dataType: 'json',
        contentType: 'application/x-www-form-urlencoded; charset=UTF-8',
        data: form,
        success: function (data) {
            //waitingDialog.hide();
            //debugger;
            //var title = "<div class='widget-header'><h4><i class='fa fa-info-circle'></i> Validate Connection </h4></div>";
            var body = "";
            if (data.license_IsExpired) {
                var msg = $('#connectionLicExpiredMsg');
                body = '<img src="../img/vgidentityserver/InCorrect.png" /> ' + msg.val();// "Connection Successful !!!";                
            }
            else if (data.license_IsNotAllowedIdentityServer) {
                var msg = $('#connectionLicDoesNotAllowIdentityServer');
                body = '<img src="../img/vgidentityserver/InCorrect.png" /> ' + msg.val();// "Connection Successful !!!"; 
            }
            else if (data.isMigrationRequired) {
                var msg = $('#repoRequiresMigrationMsg');
                body = '<img src="../img/vgidentityserver/InCorrect.png" /> ' + msg.val();// "Connection Successful !!!";                
            }
            else if (data.isSuccess) {
                var msg = $('#connectionSuccessMsg');
                body = '<img src="../img/vgidentityserver/Correct.png" /> ' + msg.val();// "Connection Successful !!!";                
            }
            else {
                var msg = $('#connectionFailedMsg');
                var statustring = data.connectionStorageStatusString;
                body = '<img src="../img/vgidentityserver/InCorrect.png" /> ' + msg.val() + ":  Please check the credentials or privileges - " + statustring;
            }
            $("#mydialog .modal-body").html(body);
            $("#mydialog").modal('show');
            //$("#dialog_simple").html(title);

            //$("#dialog_simple").html(body);
            //$('#dialog_simple').dialog('open');
            return false;
        },
        failed: function (err) {
            //waitingDialog.hide();
            //debugger;
            var body = "Failed: " + err;
            $("#mydialog .modal-body").html(body);
            $("#mydialog").modal('show');
            // $("#dialog_simple").html(title);
            //$("#dialog_simple").html(body);
            //$('#dialog_simple').dialog('open');
            return false;
        }
    });
});

$("#btnTestOracleConnection").click(function () {

    if (!IsOracleFormValid()) {
        return false;
    }
    //waitingDialog.show();

    /*$('#action').val('@strTestConnection');*/
    var form = GetFormData();
    $.ajax({
        type: "POST",
        url: "ConfigureRepo/oracle/TestConnection",
        cache: false,
        dataType: 'json',
        contentType: 'application/x-www-form-urlencoded; charset=UTF-8',
        data: form,
        success: function (data) {
            //waitingDialog.hide();
            //debugger;
            //var title = "<div class='widget-header'><h4><i class='fa fa-info-circle'></i> Validate Connection </h4></div>";
            var body = "";
            if (data.license_IsExpired) {
                var msg = $('#connectionLicExpiredMsg');
                body = '<img src="../img/vgidentityserver/InCorrect.png" /> ' + msg.val();// "Connection Successful !!!";                
            }
            else if (data.license_IsNotAllowedIdentityServer) {
                var msg = $('#connectionLicDoesNotAllowIdentityServer');
                body = '<img src="../img/vgidentityserver/InCorrect.png" /> ' + msg.val();// "Connection Successful !!!"; 
            }
            else if (data.isMigrationRequired) {
                var msg = $('#repoRequiresMigrationMsg');
                body = '<img src="../img/vgidentityserver/InCorrect.png" /> ' + msg.val();// "Connection Successful !!!";                
            }
            else if (data.isSuccess) {
                var msg = $('#connectionSuccessMsg');
                body = '<img src="../img/vgidentityserver/Correct.png" /> ' + msg.val();// "Connection Successful !!!";                
            }
            else {
                var msg = $('#connectionFailedMsg');
                var statustring = data.connectionStorageStatusString;
                body = '<img src="../img/vgidentityserver/InCorrect.png" /> ' + msg.val() + ":  Please check the credentials or privileges - " + statustring;
            }
            $("#mydialog .modal-body").html(body);
            $("#mydialog").modal('show');
            return false;
        },
        failed: function (err) {
            //waitingDialog.hide();
            //debugger;
            var body = "Failed: " + err;
            $("#mydialog .modal-body").html(body);
            $("#mydialog").modal('show');
            // $("#dialog_simple").html(title);
            //$("#dialog_simple").html(body);
            //$('#dialog_simple').dialog('open');
            return false;
        }
    });
});

function ShowMessage(message, isError) {
    var body = message;
    if (isError) {
        body = '<span style="color:red"> <b>Warning!  </b></span> ' + message;
    }
    else {
        body = '<span style="color:green"> <i class="fal fa-check-square" style="color:green"></i></span> ' + message;
    }
    $("#mydialog .modal-body").html(body);
    $("#mydialog").modal('show');
}
function GenerateConfigurationForSQLRepository() {

    if (!IsSQLFormValid(true)) {
        return;
    }
    var model = GetFormData();

    $.ajax({
        type: "POST",
        url: "ConfigureRepo/sqlserver/GenerateConfiguration",
        cache: false,
        async: false,
        dataType: 'json',
        contentType: 'application/x-www-form-urlencoded; charset=UTF-8',
        data: model,
        success: function (data) {
            //debugger;
            //var title = "<div class='widget-header'><h4><i class='fa fa-info-circle'></i> Validate Connection </h4></div>";

            var body = "";
            if (data.notHaveRootFolderPermission) {
                //IIS user needs root folder access. Grant permissions, then retry.
                //Exception Message: ' + data.errorMessageForRootFolderPermission;
                var msg = 'IIS user needs more permissions to the application root folder. Please Grant permissions, and retry.';// $('#repoRequiresMigrationMsg');
                body = '<img src="../img/vgidentityserver/InCorrect.png" /> ' + " IIS user needs more permissions to the application root folder. Please Grant permissions, and retry.";// "Connection Successful !!!"; 
                $("#mydialog .modal-body").html(body);
                $("#mydialog").modal('show');
            }
            else if (data.license_IsExpired) {
                var msg = $('#connectionLicExpiredMsg');
                body = '<img src="../img/vgidentityserver/InCorrect.png" /> ' + msg.val();// "Connection Successful !!!";       
                $("#mydialog .modal-body").html(body);
                $("#mydialog").modal('show');
            }
            else if (data.license_IsNotAllowedIdentityServer) {
                var msg = $('#connectionLicDoesNotAllowIdentityServer');
                body = '<img src="../img/vgidentityserver/InCorrect.png" /> ' + msg.val();// "Connection Successful !!!"; 
                $("#mydialog .modal-body").html(body);
                $("#mydialog").modal('show');
            }
            else if (data.isMigrationRequired) {
                var msg = $('#repoRequiresMigrationMsg');
                body = '<img src="../img/vgidentityserver/InCorrect.png" /> ' + msg.val();// "Connection Successful !!!"; 
                $("#mydialog .modal-body").html(body);
                $("#mydialog").modal('show');
            }            
            else if (data.isSuccess) {
                var mybtn = $("#btnStep2Next");
                GoNext(mybtn);
                return;
            }
            else {
                var msg = $('#connectionFailedMsg');
                var statustring = data.connectionStorageStatusString;
                body = '<img src="../img/vgidentityserver/InCorrect.png" /> ' + msg.val() + ":  Please check the credentials or privileges - " + statustring;
                $("#mydialog .modal-body").html(body);
                $("#mydialog").modal('show');
            }
            //return;
        },
        failed: function (err) {
            var body = "Failed: Generating Configuration!!!";
            $("#mydialog .modal-body").html(body);
            $("#mydialog").modal('show');
            return;
        }
    });
}

function GenerateConfigurationForOracleRepository() {

    //if (!IsOracleFormValid()) {
    //    return false;
    //}
    var model = GetFormData();

    $.ajax({
        type: "POST",
        url: "ConfigureRepo/oracle/GenerateConfiguration",
        cache: false,
        async: false,
        dataType: 'json',
        contentType: 'application/x-www-form-urlencoded; charset=UTF-8',
        data: model,
        success: function (data) {
            //debugger;
            //var title = "<div class='widget-header'><h4><i class='fa fa-info-circle'></i> Validate Connection </h4></div>";
            var body = "";            
            if (data.notHaveRootFolderPermission) {
                //IIS user needs root folder access. Grant permissions, then retry.
                //Exception Message: ' + data.errorMessageForRootFolderPermission;
                var msg = 'IIS user needs more permissions to the application root folder. Please Grant permissions, and retry.';// $('#repoRequiresMigrationMsg');
                body = '<img src="../img/vgidentityserver/InCorrect.png" /> ' + " IIS user needs more permissions to the application root folder. Please Grant permissions, and retry.";// "Connection Successful !!!"; 
                $("#mydialog .modal-body").html(body);
                $("#mydialog").modal('show');
            }
            else if (data.license_IsExpired) {
                var msg = $('#connectionLicExpiredMsg');
                body = '<img src="../img/vgidentityserver/InCorrect.png" /> ' + msg.val();// "Connection Successful !!!";       
                $("#mydialog .modal-body").html(body);
                $("#mydialog").modal('show');
            }
            else if (data.license_IsNotAllowedIdentityServer) {
                var msg = $('#connectionLicDoesNotAllowIdentityServer');
                body = '<img src="../img/vgidentityserver/InCorrect.png" /> ' + msg.val();// "Connection Successful !!!"; 
                $("#mydialog .modal-body").html(body);
                $("#mydialog").modal('show');
            }
            else if (data.isMigrationRequired) {
                var msg = $('#repoRequiresMigrationMsg');
                body = '<img src="../img/vgidentityserver/InCorrect.png" /> ' + msg.val();// "Connection Successful !!!"; 
                $("#mydialog .modal-body").html(body);
                $("#mydialog").modal('show');
            }
            else if (data.isSuccess) {
                var mybtn = $("#btnStep2Next");
                GoNext(mybtn);
                return;
            }
            else {
                var msg = $('#connectionFailedMsg');
                var statustring = data.connectionStorageStatusString;
                body = '<img src="../img/vgidentityserver/InCorrect.png" /> ' + msg.val() + ":  Please check the credentials or privileges - " + statustring;
                $("#mydialog .modal-body").html(body);
                $("#mydialog").modal('show');
            }
        },
        failed: function (err) {

            var body = "Failed: Generating Configuration!!!";
            $("#mydialog .modal-body").html(body);
            $("#mydialog").modal('show');
        }
    });
}

function IsSQLServerSelected() {
    var repoType = $("#cboConnType").find("option:selected").text();
    if (repoType == 'SQLServer') {
        return true;
    }
    else {
        return false;
    }
}

function IsOracleFormValid() {
   // debugger;
    var errorClass = 'invalid-feedback';
    var errorElement = 'em';

    let Host = $("#Host");
    if (Host.val() === '') {
        Host.addClass('is-invalid');
        return false;
    }
    else {
        Host.removeClass('is-invalid');
    }

    let Port = $("#Port");
    if (Port.val() === '') {
        Port.addClass('is-invalid');
        return false;
    }
    else {
        Port.removeClass('is-invalid');
    }
    let ServiceName = $("#txtServiceName");
    let SID = $("#txtSid");

    if ($("#ServiceNamerdo").is(':checked')) {

        if (ServiceName.val() === '') {
            ServiceName.addClass('is-invalid');
            return false;
        }
        else {
            ServiceName.removeClass('is-invalid');
            SID.removeClass('is-invalid');
        }
    }

    if ($("#SIDrdo").is(':checked')) {

        if (SID.val() === '') {
            SID.addClass('is-invalid');
            return false;
        }
        else {
            SID.removeClass('is-invalid');
            ServiceName.removeClass('is-invalid');
        }
    }
    let username = $("#UserName");
    if (username.val() === '') {
        username.addClass('is-invalid');
        return false;
    }
    else {
        username.removeClass('is-invalid');
    }

    let password = $("#Password");
    if (password.val() === '') {
        password.addClass('is-invalid');
        return false;
    }
    else {
        password.removeClass('is-invalid');
    }

    let schemaName = $("#SchemaName");
    if (schemaName.val() === '') {
        schemaName.addClass('is-invalid');
        return false;
    }
    else {
        schemaName.removeClass('is-invalid');
    }


    return true;
}

function GetOracleServerData(oracleFormData) {
    //debugger;
    oracleFormData.Host = $("#Host").val();
    oracleFormData.Port = $("#Port").val();
    oracleFormData.UserName = $("#UserName").val();
    oracleFormData.Password = $("#Password").val();
    oracleFormData.SchemaName = $("#SchemaName").val();
    if ($("#ServiceNamerdo").is(':checked')) {
        oracleFormData.ServiceName = $("#txtServiceName").val();
    }
    if ($("#SIDrdo").is(':checked')) {
        oracleFormData.SID = $("#txtSid").val();
    }
    return oracleFormData;
}


function IsSQLFormValid(isForLoadingDb) {
    let server = $("#Server");
    if (server.val() === '') {
        server.addClass('is-invalid');
        return false;
    }
    else {
        server.removeClass('is-invalid');
    }

    if (IsSqlServerAuthenticationInSql()) {
        let username = $("#txtusername");
        if (username.val() === '') {
            username.addClass('is-invalid');
            return false;
        }
        else {
            username.removeClass('is-invalid');
        }

        let password = $("#txtpwd");
        if (password.val() === '') {
            password.addClass('is-invalid');
            return false;
        }
        else {
            password.removeClass('is-invalid');
        }
    }

    if (!isForLoadingDb) {
        let db = $("#cbodb");
        let selecteddb = $("#cbodb").find("option:selected").text();

        if (selecteddb === 'Select') {
            db.addClass('is-invalid');
            return false;
        }
        else {
            db.removeClass('is-invalid');
        }
    }

    return true;
}


function GetSqlServerData(sqlFormData) {
    sqlFormData.Server = $("#Server").val();

    if (IsSqlServerAuthenticationInSql()) {
        sqlFormData.UserName = $("#txtusername").val();
        sqlFormData.Password = $("#txtpwd").val();
        sqlFormData.IsTrusted = false;
    }
    else if (IsWindowsAuthenticationInSql()) {
        sqlFormData.IsTrusted = true;
    }

    sqlFormData.Database = $("#cbodb").find("option:selected").text();
    sqlFormData.SelectedAuthenticationMode = $("#cboAuthenticationMode").find("option:selected").text();

    return sqlFormData;
}

function IsSqlServerAuthenticationInSql() {
    var sqlAuthMode = $("#cboAuthenticationMode").find("option:selected").text();
    if (sqlAuthMode == 'SQLServer') {
        return true;
    }
    else {
        return false;
    }
}

function IsWindowsAuthenticationInSql() {
    var sqlAuthMode = $("#cboAuthenticationMode").find("option:selected").text();
    if (sqlAuthMode == 'Windows') {
        return true;
    }
    else {
        return false;
    }
}

function GetFormData() {
    let formData = {};
    if (IsSQLServerSelected()) {
        formData = GetSqlServerData(formData);
    }
    else {
        formData = GetOracleServerData(formData);
    }

    return formData;
}



function scroll_to_class(element_class, removed_height) {
    var scroll_to = $(element_class).offset().top - removed_height;
    if ($(window).scrollTop() != scroll_to) {
        $('html, body').stop().animate({ scrollTop: scroll_to }, 0);
    }
}

function bar_progress(progress_line_object, direction) {
    var number_of_steps = progress_line_object.data('number-of-steps');
    var now_value = progress_line_object.data('now-value');
    var new_value = 0;
    if (direction == 'right') {
        new_value = now_value + (100 / number_of_steps);
    }
    else if (direction == 'left') {
        new_value = now_value - (100 / number_of_steps);
    }
    progress_line_object.attr('style', 'width: ' + new_value + '%;').data('now-value', new_value);
}

function getNextStep(step, fieldSet, stepToCheck) {
    let nextStep = step;
    if (fieldSet[0].id.indexOf(stepToCheck) > -1) {
        //if (IsSQLServerSelected()) {
        //    nextStep = $("#step4_sqlrepository");
        //}
        //else{
        //    nextStep = $("#step4_oraclerepository");
        //}
    }

    return nextStep;
}


function GoNext(thisObj) {
    var parent_fieldset = thisObj.parents('fieldset');
    var next_step = true;
    // navigation steps / progress steps
    var current_active_step = thisObj.parents('.f1').find('.f1-step.active');
    var progress_line = thisObj.parents('.f1').find('.f1-progress-line');

    // fields validation
    //parent_fieldset.find('input[type="text"], input[type="password"], textarea').each(function () {
    //    if ($(this).val() == "") {
    //        $(this).addClass('input-error');
    //        next_step = false;
    //    }
    //    else {
    //        $(this).removeClass('input-error');
    //    }
    //});
    // fields validation

    if (next_step) {
        parent_fieldset.fadeOut(400, function () {
            // change icons
            current_active_step.removeClass('active').addClass('activated').next().addClass('active');
            // progress bar
            bar_progress(progress_line, 'right');
            // show next step
            //let nextStep = $(this).next();

            let nextStep = getNextStep($(this).next(), parent_fieldset, 'step2');

            nextStep.fadeIn();
            // scroll window to beginning of the form
            scroll_to_class($('.f1'), 20);
        });
    }
}

function NextClick(obj) {


    var parent_fieldset = obj.parents('fieldset');
    var next_step = true;
    // navigation steps / progress steps
    var current_active_step = obj.parents('.f1').find('.f1-step.active');
    var progress_line = obj.parents('.f1').find('.f1-progress-line');

    if (next_step) {
        parent_fieldset.fadeOut(400, function () {
            // change icons
            current_active_step.removeClass('active').addClass('activated').next().addClass('active');
            // progress bar
            bar_progress(progress_line, 'right');

            let nextStep = getNextStep(obj.next(), parent_fieldset, 'step2');
            // show next step
            nextStep.fadeIn();
            // scroll window to beginning of the form
            scroll_to_class($('.f1'), 25);
        });
    }

}

function IsLocalSettingsValid() {
    let serverUrl = $("#IdentityServerUrl");
    //let div =
    if (serverUrl.val() === '') {
        serverUrl.addClass('is-invalid');
        $("#divUrl").addClass('is-invalid');

        return false;
    }
    else {
        serverUrl.removeClass('is-invalid');//invalid-feedback
    }

    return true;
}
function GetLocalSettingsFormData() {
    let LocalSettingsViewModel = {};
    LocalSettingsViewModel.IdentityServerUrl = $("#IdentityServerUrl").val();

    let formData = {};
    formData.LocalSettingsViewModel = LocalSettingsViewModel;
    return formData;
}

function SaveLocalSettings_RepoWizard() {
    var model = GetLocalSettingsFormData();

    $.ajax({
        type: "POST",
        url: "ConfigureServer/ConfigureServerUrl",
        cache: false,
        async: false,
        dataType: 'json',
        contentType: 'application/x-www-form-urlencoded; charset=UTF-8',
        data: model,
        success: function (data) {
            //debugger;
            //var title = "<div class='widget-header'><h4><i class='fa fa-info-circle'></i> Validate Connection </h4></div>";
            var body = "";
            if (data == 'Success') {
                var btn = $('#btnStep3Next');
                GoNext(btn);
                //location.href = 'ConfigureServer/ConfigurationSuccessful';
                return true;
                //$('#configure-sqlRepository-form input').clearErrors();
            }
            else {
                var body = "Failed Saving Local settings!!!";
                $("#mydialog .modal-body").html(body);
                $("#mydialog").modal('show');
                return false;
                //location.href = url;
            }


        },
        failed: function (err) {
           // debugger;
            var body = "Failed Saving Local settings!!!";
            $("#mydialog .modal-body").html(body);
            $("#mydialog").modal('show');
            return false;
        }
    });
}

function SaveLocalSettings_ConfigServerUrl() {
    var model = GetLocalSettingsFormData();

    $.ajax({
        type: "POST",
        url: "ConfigureServer/ConfigureServerUrl",
        cache: false,
        async: false,
        dataType: 'json',
        contentType: 'application/x-www-form-urlencoded; charset=UTF-8',
        data: model,
        success: function (data) {
            //debugger;
            //var title = "<div class='widget-header'><h4><i class='fa fa-info-circle'></i> Validate Connection </h4></div>";
            var body = "";
            if (data == 'Success') {
                ShowMessage('Local settings saved successfully', false);
                //location.href = 'ConfigureServer/ConfigurationSuccessful';
                return true;
                //$('#configure-sqlRepository-form input').clearErrors();
            }
            else {
                var body = "Failed Saving Local settings!!!";
                $("#mydialog .modal-body").html(body);
                $("#mydialog").modal('show');
                return false;
                //location.href = url;
            }


        },
        failed: function (err) {
            //debugger;
            var body = "Failed Saving Local settings!!!";
            $("#mydialog .modal-body").html(body);
            $("#mydialog").modal('show');
            return false;
        }
    });
}



function isValidHttpUrl(string) {
    let url;

    try {
        url = new URL(string);
    } catch (_) {
        return false;
    }

    return url.protocol === "http:" || url.protocol === "https:";
}


jQuery(document).ready(function () {
    /*
        Fullscreen background
    */
    /*$.backstretch("../assets/img/backgrounds/1.jpg");*/

    $('#top-navbar-1').on('shown.bs.collapse', function () {
        $.backstretch("resize");
    });
    $('#top-navbar-1').on('hidden.bs.collapse', function () {
        $.backstretch("resize");
    });

    /*
        Form
    */
    $('.f1 fieldset:first').fadeIn('slow');


    $('.f1 input[type="text"], .f1 input[type="password"], .f1 textarea').on('focus', function () {
        $(this).removeClass('input-error');
    });



    // next step
    //$('.f1 .btn-next').on('click', function () {

    //	var parent_fieldset = $(this).parents('fieldset');
    //	var next_step = true;
    //	// navigation steps / progress steps
    //	var current_active_step = $(this).parents('.f1').find('.f1-step.active');
    //	var progress_line = $(this).parents('.f1').find('.f1-progress-line');

    //	// fields validation
    //    parent_fieldset.find('input[type="text"], input[type="password"], textarea').each(function () {
    //        //if (parent_fieldset.attr("Id") == "step2_connectRepository")
    //        //{
    //        //    if ($("#cboConnType").find("option:selected").text() == "SQLServer") {

    //        //    }
    //        //    else
    //        //    {
    //        //    }
    //        //}
    //		if( $(this).val() == "" ) {
    //			//$(this).addClass('input-error');
    //			//next_step = false;
    //		}
    //		else {
    //			/*$(this).removeClass('input-error');*/
    //		}
    //	});
    //	// fields validation

    //	if( next_step ) {
    //		parent_fieldset.fadeOut(400, function() {
    //			// change icons
    //			current_active_step.removeClass('active').addClass('activated').next().addClass('active');
    //			// progress bar
    //			bar_progress(progress_line, 'right');
    //			// show next step
    // 		$(this).next().fadeIn();
    // 		// scroll window to beginning of the form
    //			scroll_to_class( $('.f1'), 20 );
    // 	});
    //	}

    //});
    //});

    // previous step
    $('.f1 .btn-previous').on('click', function () {

        // navigation steps / progress steps
        var current_active_step = $(this).parents('.f1').find('.f1-step.active');
        var progress_line = $(this).parents('.f1').find('.f1-progress-line');

        $(this).parents('fieldset').fadeOut(400, function () {
            // change icons
            current_active_step.removeClass('active').prev().removeClass('activated').addClass('active');
            // progress bar
            bar_progress(progress_line, 'left');

            let current_fieldset = $(this);
            let prevStep = $(this).prev();
            if (current_fieldset[0].id.indexOf('step2') > -1) {
                prevStep = $("#step1_selectrepositorytype");
            }

            // show previous step
            $(this).prev().fadeIn();
            // scroll window to beginning of the form
            scroll_to_class($('.f1'), 20);
        });
    });

    // submit
    //$('.f1').on('submit', function(e) {

    //	// fields validation
    //	$(this).find('input[type="text"], input[type="password"], textarea').each(function() {
    //		if( $(this).val() == "" ) {
    //			e.preventDefault();
    //			$(this).addClass('input-error');
    //		}
    //		else {
    //			$(this).removeClass('input-error');
    //		}
    //	});
    //	// fields validation

    //});




});